from typing import List, Optional

from com.inductiveautomation.ignition.common.user import ContactInfo, PyUser
from incendium.helper.types import String

class IncendiumUser:
    def __init__(self, user: PyUser) -> None: ...
    @property
    def contact_info(self) -> List[ContactInfo]: ...
    @property
    def email(self) -> List[String]: ...
    @property
    def first_name(self) -> String: ...
    @property
    def full_name(self) -> String: ...
    @property
    def last_name(self) -> String: ...
    @property
    def locale(self) -> String: ...
    @property
    def roles(self) -> List[String]: ...

def get_emails(
    user_source: String = ..., filter_role: String = ...
) -> List[String]: ...
def get_user(
    user_source: String = ..., failover: Optional[String] = ...
) -> IncendiumUser: ...
def get_user_email_address(
    user_source: String = ..., failover: Optional[String] = ...
) -> List[String]: ...
def get_user_first_name(
    user_source: String = ..., failover: Optional[String] = ...
) -> String: ...
def get_user_full_name(
    user_source: String = ..., failover: Optional[String] = ...
) -> String: ...
def get_users(user_source: String = ..., filter_role: String = ...) -> List[PyUser]: ...
