Tola Payments Python Package

A python package to easy push payment integration with Tola Payments with Mpesa, TigoPesa, and AirtelMoney Tanzania. You can easily charge a customer's phone number with a specified amount, and the package will handle the necessary details to make the payment using the Tola Mobile API. No need to integrate each MNO individualy.

Installation
To install the Tola Payments package, run the following command:

pip install tola_payments

Usage

Configuration

To use the package, you need to set up your Tola Mobile API credentials in a .env file. Add the following variables to your .env file:
To use the Tola Payments package, you first need to import it into your Python code. Here's an example:

TOLA_USERNAME=<your Tola Mobile API username>
TOLA_PASSWORD=<your Tola Mobile API password>
VODA_TARGET=<your Vodacom Tola Mobile API target>
TIGO_TARGET=<your Tigo Tola Mobile API target>
AIRTEL_TARGET=<your Airtel Tola Mobile API target>
TOLA_LIVE_URL = <your Tola Live Url>


Next, create an instance of the TolaPayments class, providing your Tola Mobile API credentials:

from tolapyments import TolaPayments

tolapayments = TolaPayments(is_sandbox=True)

Note that the is_sandbox parameter specifies whether you're using the Tola Mobile sandbox environment or the live environment. If you're using the sandbox environment, set is_sandbox to True. Otherwise, set it to False and provide the live API URL via the TOLA_LIVE_URL environment variable.

To charge a customer, call the charge_customer method on your TolaPayments instance, passing in the customer's phone number, the amount to charge, and a source reference

response =tolapayments.charge_costomer(amount="1000",phone_number="+25561189850", sourcereference='4546f56543poF66')

print(response.text)

