# ory-keto-client
Ory Keto is a cloud native access control server providing best-practice patterns (RBAC, ABAC, ACL, AWS IAM Policies, Kubernetes Roles, ...) via REST APIs.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0.0.0-alpha.54
- Package version: v0.0.0-alpha.54
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.ory.sh](https://www.ory.sh)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ory/sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ory/sdk.git`)

Then import the package:
```python
import ory_keto_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ory_keto_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ory_keto_client
from pprint import pprint
from ory_keto_client.api import engines_api
from ory_keto_client.model.add_ory_access_control_policy_role_members_body import AddOryAccessControlPolicyRoleMembersBody
from ory_keto_client.model.authorization_result import AuthorizationResult
from ory_keto_client.model.inline_response500 import InlineResponse500
from ory_keto_client.model.ory_access_control_policy import OryAccessControlPolicy
from ory_keto_client.model.ory_access_control_policy_allowed_input import OryAccessControlPolicyAllowedInput
from ory_keto_client.model.ory_access_control_policy_role import OryAccessControlPolicyRole
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = ory_keto_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with ory_keto_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = engines_api.EnginesApi(api_client)
    flavor = "flavor_example" # str | The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".
id = "id_example" # str | The ID of the ORY Access Control Policy Role.
body = AddOryAccessControlPolicyRoleMembersBody(
        members=[
            "members_example",
        ],
    ) # AddOryAccessControlPolicyRoleMembersBody |  (optional)

    try:
        # Add a member to an ORY Access Control Policy Role
        api_response = api_instance.add_ory_access_control_policy_role_members(flavor, id, body=body)
        pprint(api_response)
    except ory_keto_client.ApiException as e:
        print("Exception when calling EnginesApi->add_ory_access_control_policy_role_members: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EnginesApi* | [**add_ory_access_control_policy_role_members**](docs/EnginesApi.md#add_ory_access_control_policy_role_members) | **PUT** /engines/acp/ory/{flavor}/roles/{id}/members | Add a member to an ORY Access Control Policy Role
*EnginesApi* | [**delete_ory_access_control_policy**](docs/EnginesApi.md#delete_ory_access_control_policy) | **DELETE** /engines/acp/ory/{flavor}/policies/{id} | 
*EnginesApi* | [**delete_ory_access_control_policy_role**](docs/EnginesApi.md#delete_ory_access_control_policy_role) | **DELETE** /engines/acp/ory/{flavor}/roles/{id} | Delete an ORY Access Control Policy Role
*EnginesApi* | [**do_ory_access_control_policies_allow**](docs/EnginesApi.md#do_ory_access_control_policies_allow) | **POST** /engines/acp/ory/{flavor}/allowed | Check if a request is allowed
*EnginesApi* | [**get_ory_access_control_policy**](docs/EnginesApi.md#get_ory_access_control_policy) | **GET** /engines/acp/ory/{flavor}/policies/{id} | 
*EnginesApi* | [**get_ory_access_control_policy_role**](docs/EnginesApi.md#get_ory_access_control_policy_role) | **GET** /engines/acp/ory/{flavor}/roles/{id} | Get an ORY Access Control Policy Role
*EnginesApi* | [**list_ory_access_control_policies**](docs/EnginesApi.md#list_ory_access_control_policies) | **GET** /engines/acp/ory/{flavor}/policies | 
*EnginesApi* | [**list_ory_access_control_policy_roles**](docs/EnginesApi.md#list_ory_access_control_policy_roles) | **GET** /engines/acp/ory/{flavor}/roles | List ORY Access Control Policy Roles
*EnginesApi* | [**remove_ory_access_control_policy_role_members**](docs/EnginesApi.md#remove_ory_access_control_policy_role_members) | **DELETE** /engines/acp/ory/{flavor}/roles/{id}/members/{member} | Remove a member from an ORY Access Control Policy Role
*EnginesApi* | [**upsert_ory_access_control_policy**](docs/EnginesApi.md#upsert_ory_access_control_policy) | **PUT** /engines/acp/ory/{flavor}/policies | 
*EnginesApi* | [**upsert_ory_access_control_policy_role**](docs/EnginesApi.md#upsert_ory_access_control_policy_role) | **PUT** /engines/acp/ory/{flavor}/roles | Upsert an ORY Access Control Policy Role
*HealthApi* | [**is_instance_alive**](docs/HealthApi.md#is_instance_alive) | **GET** /health/alive | Check alive status
*HealthApi* | [**is_instance_ready**](docs/HealthApi.md#is_instance_ready) | **GET** /health/ready | Check readiness status
*VersionApi* | [**get_version**](docs/VersionApi.md#get_version) | **GET** /version | Get service version


## Documentation For Models

 - [AddOryAccessControlPolicyRoleMembersBody](docs/AddOryAccessControlPolicyRoleMembersBody.md)
 - [AuthorizationResult](docs/AuthorizationResult.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [OryAccessControlPolicy](docs/OryAccessControlPolicy.md)
 - [OryAccessControlPolicyAllowedInput](docs/OryAccessControlPolicyAllowedInput.md)
 - [OryAccessControlPolicyRole](docs/OryAccessControlPolicyRole.md)
 - [Version](docs/Version.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

hi@ory.sh


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ory_keto_client.apis and ory_keto_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ory_keto_client.api.default_api import DefaultApi`
- `from ory_keto_client.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ory_keto_client
from ory_keto_client.apis import *
from ory_keto_client.models import *
```

