"""
    ORY Keto

    Ory Keto is a cloud native access control server providing best-practice patterns (RBAC, ABAC, ACL, AWS IAM Policies, Kubernetes Roles, ...) via REST APIs.  # noqa: E501

    The version of the OpenAPI document: v0.0.0-alpha.54
    Contact: hi@ory.sh
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ory_keto_client.api_client import ApiClient, Endpoint
from ory_keto_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from ory_keto_client.model.add_ory_access_control_policy_role_members_body import AddOryAccessControlPolicyRoleMembersBody
from ory_keto_client.model.authorization_result import AuthorizationResult
from ory_keto_client.model.inline_response500 import InlineResponse500
from ory_keto_client.model.ory_access_control_policy import OryAccessControlPolicy
from ory_keto_client.model.ory_access_control_policy_allowed_input import OryAccessControlPolicyAllowedInput
from ory_keto_client.model.ory_access_control_policy_role import OryAccessControlPolicyRole


class EnginesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_ory_access_control_policy_role_members(
            self,
            flavor,
            id,
            **kwargs
        ):
            """Add a member to an ORY Access Control Policy Role  # noqa: E501

            Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_ory_access_control_policy_role_members(flavor, id, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".
                id (str): The ID of the ORY Access Control Policy Role.

            Keyword Args:
                body (AddOryAccessControlPolicyRoleMembersBody): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OryAccessControlPolicyRole
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.add_ory_access_control_policy_role_members = Endpoint(
            settings={
                'response_type': (OryAccessControlPolicyRole,),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/roles/{id}/members',
                'operation_id': 'add_ory_access_control_policy_role_members',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'id',
                    'body',
                ],
                'required': [
                    'flavor',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'id':
                        (str,),
                    'body':
                        (AddOryAccessControlPolicyRoleMembersBody,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'id': 'id',
                },
                'location_map': {
                    'flavor': 'path',
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_ory_access_control_policy_role_members
        )

        def __delete_ory_access_control_policy(
            self,
            flavor,
            id,
            **kwargs
        ):
            """delete_ory_access_control_policy  # noqa: E501

            Delete an ORY Access Control Policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_ory_access_control_policy(flavor, id, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".
                id (str): The ID of the ORY Access Control Policy Role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.delete_ory_access_control_policy = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/policies/{id}',
                'operation_id': 'delete_ory_access_control_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'id',
                ],
                'required': [
                    'flavor',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'id': 'id',
                },
                'location_map': {
                    'flavor': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_ory_access_control_policy
        )

        def __delete_ory_access_control_policy_role(
            self,
            flavor,
            id,
            **kwargs
        ):
            """Delete an ORY Access Control Policy Role  # noqa: E501

            Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_ory_access_control_policy_role(flavor, id, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".
                id (str): The ID of the ORY Access Control Policy Role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.delete_ory_access_control_policy_role = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/roles/{id}',
                'operation_id': 'delete_ory_access_control_policy_role',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'id',
                ],
                'required': [
                    'flavor',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'id': 'id',
                },
                'location_map': {
                    'flavor': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_ory_access_control_policy_role
        )

        def __do_ory_access_control_policies_allow(
            self,
            flavor,
            **kwargs
        ):
            """Check if a request is allowed  # noqa: E501

            Use this endpoint to check if a request is allowed or not. If the request is allowed, a 200 response with `{\"allowed\":\"true\"}` will be sent. If the request is denied, a 403 response with `{\"allowed\":\"false\"}` will be sent instead.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.do_ory_access_control_policies_allow(flavor, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".

            Keyword Args:
                body (OryAccessControlPolicyAllowedInput): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuthorizationResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            return self.call_with_http_info(**kwargs)

        self.do_ory_access_control_policies_allow = Endpoint(
            settings={
                'response_type': (AuthorizationResult,),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/allowed',
                'operation_id': 'do_ory_access_control_policies_allow',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'body',
                ],
                'required': [
                    'flavor',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'body':
                        (OryAccessControlPolicyAllowedInput,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                },
                'location_map': {
                    'flavor': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__do_ory_access_control_policies_allow
        )

        def __get_ory_access_control_policy(
            self,
            flavor,
            id,
            **kwargs
        ):
            """get_ory_access_control_policy  # noqa: E501

            Get an ORY Access Control Policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ory_access_control_policy(flavor, id, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".
                id (str): The ID of the ORY Access Control Policy Role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OryAccessControlPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_ory_access_control_policy = Endpoint(
            settings={
                'response_type': (OryAccessControlPolicy,),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/policies/{id}',
                'operation_id': 'get_ory_access_control_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'id',
                ],
                'required': [
                    'flavor',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'id': 'id',
                },
                'location_map': {
                    'flavor': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ory_access_control_policy
        )

        def __get_ory_access_control_policy_role(
            self,
            flavor,
            id,
            **kwargs
        ):
            """Get an ORY Access Control Policy Role  # noqa: E501

            Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ory_access_control_policy_role(flavor, id, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".
                id (str): The ID of the ORY Access Control Policy Role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OryAccessControlPolicyRole
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_ory_access_control_policy_role = Endpoint(
            settings={
                'response_type': (OryAccessControlPolicyRole,),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/roles/{id}',
                'operation_id': 'get_ory_access_control_policy_role',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'id',
                ],
                'required': [
                    'flavor',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'id': 'id',
                },
                'location_map': {
                    'flavor': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ory_access_control_policy_role
        )

        def __list_ory_access_control_policies(
            self,
            flavor,
            **kwargs
        ):
            """list_ory_access_control_policies  # noqa: E501

            List ORY Access Control Policies  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ory_access_control_policies(flavor, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\"

            Keyword Args:
                limit (int): The maximum amount of policies returned.. [optional]
                offset (int): The offset from where to start looking.. [optional]
                subject (str): The subject for whom the policies are to be listed.. [optional]
                resource (str): The resource for which the policies are to be listed.. [optional]
                action (str): The action for which policies are to be listed.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [OryAccessControlPolicy]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            return self.call_with_http_info(**kwargs)

        self.list_ory_access_control_policies = Endpoint(
            settings={
                'response_type': ([OryAccessControlPolicy],),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/policies',
                'operation_id': 'list_ory_access_control_policies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'limit',
                    'offset',
                    'subject',
                    'resource',
                    'action',
                ],
                'required': [
                    'flavor',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'subject':
                        (str,),
                    'resource':
                        (str,),
                    'action':
                        (str,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'limit': 'limit',
                    'offset': 'offset',
                    'subject': 'subject',
                    'resource': 'resource',
                    'action': 'action',
                },
                'location_map': {
                    'flavor': 'path',
                    'limit': 'query',
                    'offset': 'query',
                    'subject': 'query',
                    'resource': 'query',
                    'action': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_ory_access_control_policies
        )

        def __list_ory_access_control_policy_roles(
            self,
            flavor,
            **kwargs
        ):
            """List ORY Access Control Policy Roles  # noqa: E501

            Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ory_access_control_policy_roles(flavor, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\"

            Keyword Args:
                limit (int): The maximum amount of policies returned.. [optional]
                offset (int): The offset from where to start looking.. [optional]
                member (str): The member for which the roles are to be listed.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [OryAccessControlPolicyRole]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            return self.call_with_http_info(**kwargs)

        self.list_ory_access_control_policy_roles = Endpoint(
            settings={
                'response_type': ([OryAccessControlPolicyRole],),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/roles',
                'operation_id': 'list_ory_access_control_policy_roles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'limit',
                    'offset',
                    'member',
                ],
                'required': [
                    'flavor',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'member':
                        (str,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'limit': 'limit',
                    'offset': 'offset',
                    'member': 'member',
                },
                'location_map': {
                    'flavor': 'path',
                    'limit': 'query',
                    'offset': 'query',
                    'member': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_ory_access_control_policy_roles
        )

        def __remove_ory_access_control_policy_role_members(
            self,
            flavor,
            id,
            member,
            **kwargs
        ):
            """Remove a member from an ORY Access Control Policy Role  # noqa: E501

            Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_ory_access_control_policy_role_members(flavor, id, member, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".
                id (str): The ID of the ORY Access Control Policy Role.
                member (str): The member to be removed.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            kwargs['id'] = \
                id
            kwargs['member'] = \
                member
            return self.call_with_http_info(**kwargs)

        self.remove_ory_access_control_policy_role_members = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/roles/{id}/members/{member}',
                'operation_id': 'remove_ory_access_control_policy_role_members',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'id',
                    'member',
                ],
                'required': [
                    'flavor',
                    'id',
                    'member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'id':
                        (str,),
                    'member':
                        (str,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                    'id': 'id',
                    'member': 'member',
                },
                'location_map': {
                    'flavor': 'path',
                    'id': 'path',
                    'member': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__remove_ory_access_control_policy_role_members
        )

        def __upsert_ory_access_control_policy(
            self,
            flavor,
            **kwargs
        ):
            """upsert_ory_access_control_policy  # noqa: E501

            Upsert an ORY Access Control Policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upsert_ory_access_control_policy(flavor, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".

            Keyword Args:
                body (OryAccessControlPolicy): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OryAccessControlPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            return self.call_with_http_info(**kwargs)

        self.upsert_ory_access_control_policy = Endpoint(
            settings={
                'response_type': (OryAccessControlPolicy,),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/policies',
                'operation_id': 'upsert_ory_access_control_policy',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'body',
                ],
                'required': [
                    'flavor',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'body':
                        (OryAccessControlPolicy,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                },
                'location_map': {
                    'flavor': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upsert_ory_access_control_policy
        )

        def __upsert_ory_access_control_policy_role(
            self,
            flavor,
            **kwargs
        ):
            """Upsert an ORY Access Control Policy Role  # noqa: E501

            Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upsert_ory_access_control_policy_role(flavor, async_req=True)
            >>> result = thread.get()

            Args:
                flavor (str): The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\".

            Keyword Args:
                body (OryAccessControlPolicyRole): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OryAccessControlPolicyRole
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['flavor'] = \
                flavor
            return self.call_with_http_info(**kwargs)

        self.upsert_ory_access_control_policy_role = Endpoint(
            settings={
                'response_type': (OryAccessControlPolicyRole,),
                'auth': [],
                'endpoint_path': '/engines/acp/ory/{flavor}/roles',
                'operation_id': 'upsert_ory_access_control_policy_role',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'flavor',
                    'body',
                ],
                'required': [
                    'flavor',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'flavor':
                        (str,),
                    'body':
                        (OryAccessControlPolicyRole,),
                },
                'attribute_map': {
                    'flavor': 'flavor',
                },
                'location_map': {
                    'flavor': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upsert_ory_access_control_policy_role
        )
