import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingProjectBucketConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the logging bucket. Logging automatically creates two log buckets: _Required and _Default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_bucket_config.html#bucket_id LoggingProjectBucketConfig#bucket_id}
     *
     * @stability stable
     */
    readonly bucketId: string;
    /**
     * An optional description for this bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_bucket_config.html#description LoggingProjectBucketConfig#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The location of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_bucket_config.html#location LoggingProjectBucketConfig#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The parent project that contains the logging bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_bucket_config.html#project LoggingProjectBucketConfig#project}
     *
     * @stability stable
     */
    readonly project: string;
    /**
     * Logs will be retained by default for this amount of time, after which they will automatically be deleted.
     *
     * The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_bucket_config.html#retention_days LoggingProjectBucketConfig#retention_days}
     *
     * @stability stable
     */
    readonly retentionDays?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_project_bucket_config.html google_logging_project_bucket_config}.
 *
 * @stability stable
 */
export declare class LoggingProjectBucketConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_project_bucket_config.html google_logging_project_bucket_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingProjectBucketConfigConfig);
    private _bucketId?;
    /**
     * @stability stable
     */
    get bucketId(): string;
    /**
     * @stability stable
     */
    set bucketId(value: string);
    /**
     * @stability stable
     */
    get bucketIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lifecycleState(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number | undefined;
    /**
     * @stability stable
     */
    set retentionDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
