"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
/**
 * Base class for listeners
 */
class BaseListener extends core_1.Resource {
    constructor(scope, id, additionalProps) {
        super(scope, id);
        this.defaultActions = [];
        const resource = new elasticloadbalancingv2_generated_1.CfnListener(this, 'Resource', {
            ...additionalProps,
            defaultActions: core_1.Lazy.anyValue({ produce: () => this.defaultActions }),
        });
        this.listenerArn = resource.ref;
    }
    /**
     * Validate this listener
     */
    validate() {
        if (this.defaultActions.length === 0) {
            return ['Listener needs at least one default target group (call addTargetGroups)'];
        }
        return [];
    }
    /**
     * Add an action to the list of default actions of this listener
     * @internal
     */
    _addDefaultAction(action) {
        this.defaultActions.push(action);
    }
    /**
     * Add a TargetGroup to the list of default actions of this listener
     * @internal
     */
    _addDefaultTargetGroup(targetGroup) {
        this._addDefaultAction({
            targetGroupArn: targetGroup.targetGroupArn,
            type: 'forward',
        });
    }
}
exports.BaseListener = BaseListener;
//# sourceMappingURL=data:application/json;base64,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