"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * What kind of addresses to allocate to the load balancer
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * Allocate IPv4 addresses
     */
    IpAddressType["IPV4"] = "ipv4";
    /**
     * Allocate both IPv4 and IPv6 addresses
     */
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks
 */
var Protocol;
(function (Protocol) {
    /**
     * HTTP (ALB health checks and NLB health checks)
     */
    Protocol["HTTP"] = "HTTP";
    /**
     * HTTPS (ALB health checks and NLB health checks)
     */
    Protocol["HTTPS"] = "HTTPS";
    /**
     * TCP (NLB, NLB health checks)
     */
    Protocol["TCP"] = "TCP";
    /**
     * TLS (NLB)
     */
    Protocol["TLS"] = "TLS";
    /**
     * UDP (NLB)
     */
    Protocol["UDP"] = "UDP";
    /**
     * Listen to both TCP and UDP on the same port (NLB)
     */
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    /**
     * HTTP
     */
    ApplicationProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS
     */
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 */
var SslPolicy;
(function (SslPolicy) {
    /**
     * The recommended security policy
     */
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    /**
     * Strong forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    /**
     * Forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    /**
     * Forward secrecy ciphers only with TLS1.1 and higher
     */
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    /**
     * Forward secrecy ciphers only
     */
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    /**
     * TLS1.2 only and no SHA ciphers
     */
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    /**
     * TLS1.2 only with all ciphers
     */
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    /**
     * TLS1.1 and higher with all ciphers
     */
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    /**
     * Support for DES-CBC3-SHA
     *
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     */
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers
 */
var TargetType;
(function (TargetType) {
    /**
     * Targets identified by instance ID
     */
    TargetType["INSTANCE"] = "instance";
    /**
     * Targets identified by IP address
     */
    TargetType["IP"] = "ip";
    /**
     * Target is a single Lambda Function
     */
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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