import * as cdk from '@aws-cdk/core';
import { ITargetGroup, TargetGroupImportProps } from './base-target-group';
/**
 * Base internal class for existing target groups
 */
export declare abstract class ImportedTargetGroupBase extends cdk.Construct implements ITargetGroup {
    /**
     * ARN of the target group
     */
    readonly targetGroupArn: string;
    /**
     * A token representing a list of ARNs of the load balancers that route traffic to this target group
     */
    readonly loadBalancerArns: string;
    /**
     * Return an object to depend on the listeners added to this target group
     */
    readonly loadBalancerAttached: cdk.IDependable;
    constructor(scope: cdk.Construct, id: string, props: TargetGroupImportProps);
}
