"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A certificate source for an ELBv2 listener
 */
class ListenerCertificate {
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate
     */
    static fromCertificateManager(acmCertificate) {
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci1jZXJ0aWZpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQVlBOztHQUVHO0FBQ0gsTUFBYSxtQkFBbUI7SUFvQjlCLFlBQXNCLGNBQXNCO1FBQzFDLElBQUksQ0FBQyxjQUFjLEdBQUcsY0FBYyxDQUFDO0lBQ3ZDLENBQUM7SUFyQkQ7O09BRUc7SUFDSSxNQUFNLENBQUMsc0JBQXNCLENBQUMsY0FBZ0M7UUFDbkUsT0FBTyxJQUFJLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNoRSxDQUFDO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsT0FBTyxDQUFDLGNBQXNCO1FBQzFDLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0NBVUY7QUF2QkQsa0RBdUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYWNtIGZyb20gJ0Bhd3MtY2RrL2F3cy1jZXJ0aWZpY2F0ZW1hbmFnZXInO1xuXG4vKipcbiAqIEEgY2VydGlmaWNhdGUgc291cmNlIGZvciBhbiBFTEJ2MiBsaXN0ZW5lclxuICovXG5leHBvcnQgaW50ZXJmYWNlIElMaXN0ZW5lckNlcnRpZmljYXRlIHtcbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIGNlcnRpZmljYXRlIHRvIHVzZVxuICAgKi9cbiAgcmVhZG9ubHkgY2VydGlmaWNhdGVBcm46IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIGNlcnRpZmljYXRlIHNvdXJjZSBmb3IgYW4gRUxCdjIgbGlzdGVuZXJcbiAqL1xuZXhwb3J0IGNsYXNzIExpc3RlbmVyQ2VydGlmaWNhdGUgaW1wbGVtZW50cyBJTGlzdGVuZXJDZXJ0aWZpY2F0ZSB7XG4gIC8qKlxuICAgKiBVc2UgYW4gQUNNIGNlcnRpZmljYXRlIGFzIGEgbGlzdGVuZXIgY2VydGlmaWNhdGVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUNlcnRpZmljYXRlTWFuYWdlcihhY21DZXJ0aWZpY2F0ZTogYWNtLklDZXJ0aWZpY2F0ZSkge1xuICAgIHJldHVybiBuZXcgTGlzdGVuZXJDZXJ0aWZpY2F0ZShhY21DZXJ0aWZpY2F0ZS5jZXJ0aWZpY2F0ZUFybik7XG4gIH1cblxuICAvKipcbiAgICogVXNlIGFueSBjZXJ0aWZpY2F0ZSwgaWRlbnRpZmllZCBieSBpdHMgQVJOLCBhcyBhIGxpc3RlbmVyIGNlcnRpZmljYXRlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Bcm4oY2VydGlmaWNhdGVBcm46IHN0cmluZykge1xuICAgIHJldHVybiBuZXcgTGlzdGVuZXJDZXJ0aWZpY2F0ZShjZXJ0aWZpY2F0ZUFybik7XG4gIH1cblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgY2VydGlmaWNhdGUgdG8gdXNlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY2VydGlmaWNhdGVBcm46IHN0cmluZztcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IoY2VydGlmaWNhdGVBcm46IHN0cmluZykge1xuICAgIHRoaXMuY2VydGlmaWNhdGVBcm4gPSBjZXJ0aWZpY2F0ZUFybjtcbiAgfVxufVxuIl19