import { ApplicationProtocol } from './enums';
export declare type Attributes = {
    [key: string]: string | undefined;
};
/**
 * Render an attribute dict to a list of { key, value } pairs
 */
export declare function renderAttributes(attributes: Attributes): any[];
/**
 * Return the appropriate default port for a given protocol
 */
export declare function defaultPortForProtocol(proto: ApplicationProtocol): number;
/**
 * Return the appropriate default protocol for a given port
 */
export declare function defaultProtocolForPort(port: number): ApplicationProtocol;
/**
 * Given a protocol and a port, try to guess the other one if it's undefined
 */
export declare function determineProtocolAndPort(protocol: ApplicationProtocol | undefined, port: number | undefined): [ApplicationProtocol | undefined, number | undefined];
/**
 * Helper function to default undefined input props
 */
export declare function ifUndefined<T>(x: T | undefined, def: T): T;
