import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * If true, allows Terraform to stop the instance to update its properties.
     *
     * If you try to update a property that requires stopping the instance without setting this field, the update will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#allow_stopping_for_update ComputeInstanceFromTemplate#allow_stopping_for_update}
     *
     * @stability stable
     */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
     * List of disks attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#attached_disk ComputeInstanceFromTemplate#attached_disk}
     *
     * @stability stable
     */
    readonly attachedDisk?: ComputeInstanceFromTemplateAttachedDisk[];
    /**
     * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#can_ip_forward ComputeInstanceFromTemplate#can_ip_forward}
     *
     * @stability stable
     */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
     * Whether deletion protection is enabled on this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#deletion_protection ComputeInstanceFromTemplate#deletion_protection}
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * A brief description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#description ComputeInstanceFromTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Desired status of the instance. Either "RUNNING" or "TERMINATED".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#desired_status ComputeInstanceFromTemplate#desired_status}
     *
     * @stability stable
     */
    readonly desiredStatus?: string;
    /**
     * Whether the instance has virtual displays enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_display ComputeInstanceFromTemplate#enable_display}
     *
     * @stability stable
     */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#guest_accelerator ComputeInstanceFromTemplate#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ComputeInstanceFromTemplateGuestAccelerator[];
    /**
     * A custom hostname for the instance.
     *
     * Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#hostname ComputeInstanceFromTemplate#hostname}
     *
     * @stability stable
     */
    readonly hostname?: string;
    /**
     * A set of key/value label pairs assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#labels ComputeInstanceFromTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The machine type to create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#machine_type ComputeInstanceFromTemplate#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Metadata key/value pairs made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#metadata ComputeInstanceFromTemplate#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Metadata startup scripts made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#metadata_startup_script ComputeInstanceFromTemplate#metadata_startup_script}
     *
     * @stability stable
     */
    readonly metadataStartupScript?: string;
    /**
     * The minimum CPU platform specified for the VM instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#min_cpu_platform ComputeInstanceFromTemplate#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The name of the instance. One of name or self_link must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#name ComputeInstanceFromTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#project ComputeInstanceFromTemplate#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A list of short names or self_links of resource policies to attach to the instance.
     *
     * Currently a max of 1 resource policy is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#resource_policies ComputeInstanceFromTemplate#resource_policies}
     *
     * @stability stable
     */
    readonly resourcePolicies?: string[];
    /**
     * The scratch disks attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#scratch_disk ComputeInstanceFromTemplate#scratch_disk}
     *
     * @stability stable
     */
    readonly scratchDisk?: ComputeInstanceFromTemplateScratchDisk[];
    /**
     * The service account to attach to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#service_account ComputeInstanceFromTemplate#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: ComputeInstanceFromTemplateServiceAccount[];
    /**
     * Name or self link of an instance template to create the instance based on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#source_instance_template ComputeInstanceFromTemplate#source_instance_template}
     *
     * @stability stable
     */
    readonly sourceInstanceTemplate: string;
    /**
     * The list of tags attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#tags ComputeInstanceFromTemplate#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The zone of the instance.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#zone ComputeInstanceFromTemplate#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * advanced_machine_features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#advanced_machine_features ComputeInstanceFromTemplate#advanced_machine_features}
     *
     * @stability stable
     */
    readonly advancedMachineFeatures?: ComputeInstanceFromTemplateAdvancedMachineFeatures;
    /**
     * boot_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#boot_disk ComputeInstanceFromTemplate#boot_disk}
     *
     * @stability stable
     */
    readonly bootDisk?: ComputeInstanceFromTemplateBootDisk;
    /**
     * confidential_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#confidential_instance_config ComputeInstanceFromTemplate#confidential_instance_config}
     *
     * @stability stable
     */
    readonly confidentialInstanceConfig?: ComputeInstanceFromTemplateConfidentialInstanceConfig;
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_interface ComputeInstanceFromTemplate#network_interface}
     *
     * @stability stable
     */
    readonly networkInterface?: ComputeInstanceFromTemplateNetworkInterface[];
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#reservation_affinity ComputeInstanceFromTemplate#reservation_affinity}
     *
     * @stability stable
     */
    readonly reservationAffinity?: ComputeInstanceFromTemplateReservationAffinity;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#scheduling ComputeInstanceFromTemplate#scheduling}
     *
     * @stability stable
     */
    readonly scheduling?: ComputeInstanceFromTemplateScheduling;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#shielded_instance_config ComputeInstanceFromTemplate#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ComputeInstanceFromTemplateShieldedInstanceConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#timeouts ComputeInstanceFromTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInstanceFromTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateAttachedDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#device_name ComputeInstanceFromTemplate#device_name}.
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#disk_encryption_key_raw ComputeInstanceFromTemplate#disk_encryption_key_raw}.
     *
     * @stability stable
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#disk_encryption_key_sha256 ComputeInstanceFromTemplate#disk_encryption_key_sha256}.
     *
     * @stability stable
     */
    readonly diskEncryptionKeySha256?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#kms_key_self_link ComputeInstanceFromTemplate#kms_key_self_link}.
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#mode ComputeInstanceFromTemplate#mode}.
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#source ComputeInstanceFromTemplate#source}.
     *
     * @stability stable
     */
    readonly source?: string;
}
export declare function computeInstanceFromTemplateAttachedDiskToTerraform(struct?: ComputeInstanceFromTemplateAttachedDisk): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#count ComputeInstanceFromTemplate#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#type ComputeInstanceFromTemplate#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function computeInstanceFromTemplateGuestAcceleratorToTerraform(struct?: ComputeInstanceFromTemplateGuestAccelerator): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateScratchDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#interface ComputeInstanceFromTemplate#interface}.
     *
     * @stability stable
     */
    readonly interface?: string;
}
export declare function computeInstanceFromTemplateScratchDiskToTerraform(struct?: ComputeInstanceFromTemplateScratchDisk): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateServiceAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#email ComputeInstanceFromTemplate#email}.
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#scopes ComputeInstanceFromTemplate#scopes}.
     *
     * @stability stable
     */
    readonly scopes?: string[];
}
export declare function computeInstanceFromTemplateServiceAccountToTerraform(struct?: ComputeInstanceFromTemplateServiceAccount): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateAdvancedMachineFeatures {
    /**
     * Whether to enable nested virtualization or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_nested_virtualization ComputeInstanceFromTemplate#enable_nested_virtualization}
     *
     * @stability stable
     */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
     * The number of threads per physical core.
     *
     * To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#threads_per_core ComputeInstanceFromTemplate#threads_per_core}
     *
     * @stability stable
     */
    readonly threadsPerCore?: number;
}
export declare function computeInstanceFromTemplateAdvancedMachineFeaturesToTerraform(struct?: ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference | ComputeInstanceFromTemplateAdvancedMachineFeatures): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    /**
     * @stability stable
     */
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableNestedVirtualization(): void;
    /**
     * @stability stable
     */
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    /**
     * @stability stable
     */
    get threadsPerCore(): number;
    /**
     * @stability stable
     */
    set threadsPerCore(value: number);
    /**
     * @stability stable
     */
    resetThreadsPerCore(): void;
    /**
     * @stability stable
     */
    get threadsPerCoreInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateBootDiskInitializeParams {
    /**
     * The image from which this disk was initialised.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#image ComputeInstanceFromTemplate#image}
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * A set of key/value label pairs assigned to the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#labels ComputeInstanceFromTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The size of the image in gigabytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#size ComputeInstanceFromTemplate#size}
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * The Google Compute Engine disk type. One of pd-standard, pd-ssd or pd-balanced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#type ComputeInstanceFromTemplate#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function computeInstanceFromTemplateBootDiskInitializeParamsToTerraform(struct?: ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference | ComputeInstanceFromTemplateBootDiskInitializeParams): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateBootDiskInitializeParams | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateBootDiskInitializeParams | undefined);
    private _image?;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateBootDisk {
    /**
     * Whether the disk will be auto-deleted when the instance is deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#auto_delete ComputeInstanceFromTemplate#auto_delete}
     *
     * @stability stable
     */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
     * Name with which attached disk will be accessible under /dev/disk/by-id/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#device_name ComputeInstanceFromTemplate#device_name}
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#disk_encryption_key_raw ComputeInstanceFromTemplate#disk_encryption_key_raw}
     *
     * @stability stable
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#kms_key_self_link ComputeInstanceFromTemplate#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#mode ComputeInstanceFromTemplate#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The name or self_link of the disk attached to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#source ComputeInstanceFromTemplate#source}
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * initialize_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#initialize_params ComputeInstanceFromTemplate#initialize_params}
     *
     * @stability stable
     */
    readonly initializeParams?: ComputeInstanceFromTemplateBootDiskInitializeParams;
}
export declare function computeInstanceFromTemplateBootDiskToTerraform(struct?: ComputeInstanceFromTemplateBootDiskOutputReference | ComputeInstanceFromTemplateBootDisk): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateBootDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateBootDisk | undefined);
    private _autoDelete?;
    /**
     * @stability stable
     */
    get autoDelete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoDelete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoDelete(): void;
    /**
     * @stability stable
     */
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    /**
     * @stability stable
     */
    get deviceName(): string;
    /**
     * @stability stable
     */
    set deviceName(value: string);
    /**
     * @stability stable
     */
    resetDeviceName(): void;
    /**
     * @stability stable
     */
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    /**
     * @stability stable
     */
    get diskEncryptionKeyRaw(): string;
    /**
     * @stability stable
     */
    set diskEncryptionKeyRaw(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionKeyRaw(): void;
    /**
     * @stability stable
     */
    get diskEncryptionKeyRawInput(): string | undefined;
    private _kmsKeySelfLink?;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string;
    /**
     * @stability stable
     */
    set kmsKeySelfLink(value: string);
    /**
     * @stability stable
     */
    resetKmsKeySelfLink(): void;
    /**
     * @stability stable
     */
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _initializeParams;
    /**
     * @stability stable
     */
    get initializeParams(): ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference;
    /**
     * @stability stable
     */
    putInitializeParams(value: ComputeInstanceFromTemplateBootDiskInitializeParams): void;
    /**
     * @stability stable
     */
    resetInitializeParams(): void;
    /**
     * @stability stable
     */
    get initializeParamsInput(): ComputeInstanceFromTemplateBootDiskInitializeParams | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateConfidentialInstanceConfig {
    /**
     * Defines whether the instance should have confidential compute enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_confidential_compute ComputeInstanceFromTemplate#enable_confidential_compute}
     *
     * @stability stable
     */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare function computeInstanceFromTemplateConfidentialInstanceConfigToTerraform(struct?: ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference | ComputeInstanceFromTemplateConfidentialInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    /**
     * @stability stable
     */
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateNetworkInterfaceAccessConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#nat_ip ComputeInstanceFromTemplate#nat_ip}.
     *
     * @stability stable
     */
    readonly natIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_tier ComputeInstanceFromTemplate#network_tier}.
     *
     * @stability stable
     */
    readonly networkTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#public_ptr_domain_name ComputeInstanceFromTemplate#public_ptr_domain_name}.
     *
     * @stability stable
     */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceFromTemplateNetworkInterfaceAccessConfigToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#ip_cidr_range ComputeInstanceFromTemplate#ip_cidr_range}.
     *
     * @stability stable
     */
    readonly ipCidrRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#subnetwork_range_name ComputeInstanceFromTemplate#subnetwork_range_name}.
     *
     * @stability stable
     */
    readonly subnetworkRangeName?: string;
}
export declare function computeInstanceFromTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig {
    /**
     * The service-level to be provided for IPv6 traffic when the subnet has an external subnet.
     *
     * Only PREMIUM tier is valid for IPv6
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_tier ComputeInstanceFromTemplate#network_tier}
     *
     * @stability stable
     */
    readonly networkTier: string;
    /**
     * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#public_ptr_domain_name ComputeInstanceFromTemplate#public_ptr_domain_name}
     *
     * @stability stable
     */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateNetworkInterface {
    /**
     * Access configurations, i.e. IPs via which this instance can be accessed via the Internet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#access_config ComputeInstanceFromTemplate#access_config}
     *
     * @stability stable
     */
    readonly accessConfig?: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig[];
    /**
     * An array of alias IP ranges for this network interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#alias_ip_range ComputeInstanceFromTemplate#alias_ip_range}
     *
     * @stability stable
     */
    readonly aliasIpRange?: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[];
    /**
     * The name or self_link of the network attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network ComputeInstanceFromTemplate#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The private IP address assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_ip ComputeInstanceFromTemplate#network_ip}
     *
     * @stability stable
     */
    readonly networkIp?: string;
    /**
     * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#nic_type ComputeInstanceFromTemplate#nic_type}
     *
     * @stability stable
     */
    readonly nicType?: string;
    /**
     * The stack type for this network interface to identify whether the IPv6 feature is enabled or not.
     *
     * If not specified, IPV4_ONLY will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#stack_type ComputeInstanceFromTemplate#stack_type}
     *
     * @stability stable
     */
    readonly stackType?: string;
    /**
     * The name or self_link of the subnetwork attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#subnetwork ComputeInstanceFromTemplate#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * The project in which the subnetwork belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#subnetwork_project ComputeInstanceFromTemplate#subnetwork_project}
     *
     * @stability stable
     */
    readonly subnetworkProject?: string;
    /**
     * ipv6_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#ipv6_access_config ComputeInstanceFromTemplate#ipv6_access_config}
     *
     * @stability stable
     */
    readonly ipv6AccessConfig?: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[];
}
export declare function computeInstanceFromTemplateNetworkInterfaceToTerraform(struct?: ComputeInstanceFromTemplateNetworkInterface): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateReservationAffinitySpecificReservation {
    /**
     * Corresponds to the label key of a reservation resource.
     *
     * To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#key ComputeInstanceFromTemplate#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Corresponds to the label values of a reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#values ComputeInstanceFromTemplate#values}
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function computeInstanceFromTemplateReservationAffinitySpecificReservationToTerraform(struct?: ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference | ComputeInstanceFromTemplateReservationAffinitySpecificReservation): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined);
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateReservationAffinity {
    /**
     * The type of reservation from which this instance can consume resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#type ComputeInstanceFromTemplate#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#specific_reservation ComputeInstanceFromTemplate#specific_reservation}
     *
     * @stability stable
     */
    readonly specificReservation?: ComputeInstanceFromTemplateReservationAffinitySpecificReservation;
}
export declare function computeInstanceFromTemplateReservationAffinityToTerraform(struct?: ComputeInstanceFromTemplateReservationAffinityOutputReference | ComputeInstanceFromTemplateReservationAffinity): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateReservationAffinity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateReservationAffinity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _specificReservation;
    /**
     * @stability stable
     */
    get specificReservation(): ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference;
    /**
     * @stability stable
     */
    putSpecificReservation(value: ComputeInstanceFromTemplateReservationAffinitySpecificReservation): void;
    /**
     * @stability stable
     */
    resetSpecificReservation(): void;
    /**
     * @stability stable
     */
    get specificReservationInput(): ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateSchedulingNodeAffinities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#key ComputeInstanceFromTemplate#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#operator ComputeInstanceFromTemplate#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#values ComputeInstanceFromTemplate#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function computeInstanceFromTemplateSchedulingNodeAffinitiesToTerraform(struct?: ComputeInstanceFromTemplateSchedulingNodeAffinities): any;
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateScheduling {
    /**
     * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#automatic_restart ComputeInstanceFromTemplate#automatic_restart}
     *
     * @stability stable
     */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#min_node_cpus ComputeInstanceFromTemplate#min_node_cpus}.
     *
     * @stability stable
     */
    readonly minNodeCpus?: number;
    /**
     * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#on_host_maintenance ComputeInstanceFromTemplate#on_host_maintenance}
     *
     * @stability stable
     */
    readonly onHostMaintenance?: string;
    /**
     * Whether the instance is preemptible.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#preemptible ComputeInstanceFromTemplate#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * node_affinities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#node_affinities ComputeInstanceFromTemplate#node_affinities}
     *
     * @stability stable
     */
    readonly nodeAffinities?: ComputeInstanceFromTemplateSchedulingNodeAffinities[];
}
export declare function computeInstanceFromTemplateSchedulingToTerraform(struct?: ComputeInstanceFromTemplateSchedulingOutputReference | ComputeInstanceFromTemplateScheduling): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateScheduling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateScheduling | undefined);
    private _automaticRestart?;
    /**
     * @stability stable
     */
    get automaticRestart(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automaticRestart(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomaticRestart(): void;
    /**
     * @stability stable
     */
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _minNodeCpus?;
    /**
     * @stability stable
     */
    get minNodeCpus(): number;
    /**
     * @stability stable
     */
    set minNodeCpus(value: number);
    /**
     * @stability stable
     */
    resetMinNodeCpus(): void;
    /**
     * @stability stable
     */
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    /**
     * @stability stable
     */
    get onHostMaintenance(): string;
    /**
     * @stability stable
     */
    set onHostMaintenance(value: string);
    /**
     * @stability stable
     */
    resetOnHostMaintenance(): void;
    /**
     * @stability stable
     */
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    /**
     * @stability stable
     */
    get preemptible(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preemptible(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreemptible(): void;
    /**
     * @stability stable
     */
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeAffinities?;
    /**
     * @stability stable
     */
    get nodeAffinities(): ComputeInstanceFromTemplateSchedulingNodeAffinities[];
    /**
     * @stability stable
     */
    set nodeAffinities(value: ComputeInstanceFromTemplateSchedulingNodeAffinities[]);
    /**
     * @stability stable
     */
    resetNodeAffinities(): void;
    /**
     * @stability stable
     */
    get nodeAffinitiesInput(): ComputeInstanceFromTemplateSchedulingNodeAffinities[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateShieldedInstanceConfig {
    /**
     * Whether integrity monitoring is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_integrity_monitoring ComputeInstanceFromTemplate#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Whether secure boot is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_secure_boot ComputeInstanceFromTemplate#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Whether the instance uses vTPM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_vtpm ComputeInstanceFromTemplate#enable_vtpm}
     *
     * @stability stable
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function computeInstanceFromTemplateShieldedInstanceConfigToTerraform(struct?: ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference | ComputeInstanceFromTemplateShieldedInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateShieldedInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIntegrityMonitoring(): void;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableSecureBoot(): void;
    /**
     * @stability stable
     */
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    /**
     * @stability stable
     */
    get enableVtpm(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableVtpm(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableVtpm(): void;
    /**
     * @stability stable
     */
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceFromTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#create ComputeInstanceFromTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#delete ComputeInstanceFromTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#update ComputeInstanceFromTemplate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeInstanceFromTemplateTimeoutsToTerraform(struct?: ComputeInstanceFromTemplateTimeoutsOutputReference | ComputeInstanceFromTemplateTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceFromTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceFromTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceFromTemplateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html google_compute_instance_from_template}.
 *
 * @stability stable
 */
export declare class ComputeInstanceFromTemplate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html google_compute_instance_from_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceFromTemplateConfig);
    private _allowStoppingForUpdate?;
    /**
     * @stability stable
     */
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowStoppingForUpdate(): void;
    /**
     * @stability stable
     */
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _attachedDisk?;
    /**
     * @stability stable
     */
    get attachedDisk(): ComputeInstanceFromTemplateAttachedDisk[];
    /**
     * @stability stable
     */
    set attachedDisk(value: ComputeInstanceFromTemplateAttachedDisk[]);
    /**
     * @stability stable
     */
    resetAttachedDisk(): void;
    /**
     * @stability stable
     */
    get attachedDiskInput(): ComputeInstanceFromTemplateAttachedDisk[] | undefined;
    private _canIpForward?;
    /**
     * @stability stable
     */
    get canIpForward(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set canIpForward(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCanIpForward(): void;
    /**
     * @stability stable
     */
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get cpuPlatform(): string;
    /**
     * @stability stable
     */
    get currentStatus(): string;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    /**
     * @stability stable
     */
    get desiredStatus(): string;
    /**
     * @stability stable
     */
    set desiredStatus(value: string);
    /**
     * @stability stable
     */
    resetDesiredStatus(): void;
    /**
     * @stability stable
     */
    get desiredStatusInput(): string | undefined;
    private _enableDisplay?;
    /**
     * @stability stable
     */
    get enableDisplay(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableDisplay(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableDisplay(): void;
    /**
     * @stability stable
     */
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator?;
    /**
     * @stability stable
     */
    get guestAccelerator(): ComputeInstanceFromTemplateGuestAccelerator[];
    /**
     * @stability stable
     */
    set guestAccelerator(value: ComputeInstanceFromTemplateGuestAccelerator[]);
    /**
     * @stability stable
     */
    resetGuestAccelerator(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorInput(): ComputeInstanceFromTemplateGuestAccelerator[] | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    resetHostname(): void;
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    /**
     * @stability stable
     */
    get metadataStartupScript(): string;
    /**
     * @stability stable
     */
    set metadataStartupScript(value: string);
    /**
     * @stability stable
     */
    resetMetadataStartupScript(): void;
    /**
     * @stability stable
     */
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    /**
     * @stability stable
     */
    get resourcePolicies(): string[];
    /**
     * @stability stable
     */
    set resourcePolicies(value: string[]);
    /**
     * @stability stable
     */
    resetResourcePolicies(): void;
    /**
     * @stability stable
     */
    get resourcePoliciesInput(): string[] | undefined;
    private _scratchDisk?;
    /**
     * @stability stable
     */
    get scratchDisk(): ComputeInstanceFromTemplateScratchDisk[];
    /**
     * @stability stable
     */
    set scratchDisk(value: ComputeInstanceFromTemplateScratchDisk[]);
    /**
     * @stability stable
     */
    resetScratchDisk(): void;
    /**
     * @stability stable
     */
    get scratchDiskInput(): ComputeInstanceFromTemplateScratchDisk[] | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): ComputeInstanceFromTemplateServiceAccount[];
    /**
     * @stability stable
     */
    set serviceAccount(value: ComputeInstanceFromTemplateServiceAccount[]);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): ComputeInstanceFromTemplateServiceAccount[] | undefined;
    private _sourceInstanceTemplate?;
    /**
     * @stability stable
     */
    get sourceInstanceTemplate(): string;
    /**
     * @stability stable
     */
    set sourceInstanceTemplate(value: string);
    /**
     * @stability stable
     */
    get sourceInstanceTemplateInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get tagsFingerprint(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures;
    /**
     * @stability stable
     */
    get advancedMachineFeatures(): ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference;
    /**
     * @stability stable
     */
    putAdvancedMachineFeatures(value: ComputeInstanceFromTemplateAdvancedMachineFeatures): void;
    /**
     * @stability stable
     */
    resetAdvancedMachineFeatures(): void;
    /**
     * @stability stable
     */
    get advancedMachineFeaturesInput(): ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined;
    private _bootDisk;
    /**
     * @stability stable
     */
    get bootDisk(): ComputeInstanceFromTemplateBootDiskOutputReference;
    /**
     * @stability stable
     */
    putBootDisk(value: ComputeInstanceFromTemplateBootDisk): void;
    /**
     * @stability stable
     */
    resetBootDisk(): void;
    /**
     * @stability stable
     */
    get bootDiskInput(): ComputeInstanceFromTemplateBootDisk | undefined;
    private _confidentialInstanceConfig;
    /**
     * @stability stable
     */
    get confidentialInstanceConfig(): ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putConfidentialInstanceConfig(value: ComputeInstanceFromTemplateConfidentialInstanceConfig): void;
    /**
     * @stability stable
     */
    resetConfidentialInstanceConfig(): void;
    /**
     * @stability stable
     */
    get confidentialInstanceConfigInput(): ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): ComputeInstanceFromTemplateNetworkInterface[];
    /**
     * @stability stable
     */
    set networkInterface(value: ComputeInstanceFromTemplateNetworkInterface[]);
    /**
     * @stability stable
     */
    resetNetworkInterface(): void;
    /**
     * @stability stable
     */
    get networkInterfaceInput(): ComputeInstanceFromTemplateNetworkInterface[] | undefined;
    private _reservationAffinity;
    /**
     * @stability stable
     */
    get reservationAffinity(): ComputeInstanceFromTemplateReservationAffinityOutputReference;
    /**
     * @stability stable
     */
    putReservationAffinity(value: ComputeInstanceFromTemplateReservationAffinity): void;
    /**
     * @stability stable
     */
    resetReservationAffinity(): void;
    /**
     * @stability stable
     */
    get reservationAffinityInput(): ComputeInstanceFromTemplateReservationAffinity | undefined;
    private _scheduling;
    /**
     * @stability stable
     */
    get scheduling(): ComputeInstanceFromTemplateSchedulingOutputReference;
    /**
     * @stability stable
     */
    putScheduling(value: ComputeInstanceFromTemplateScheduling): void;
    /**
     * @stability stable
     */
    resetScheduling(): void;
    /**
     * @stability stable
     */
    get schedulingInput(): ComputeInstanceFromTemplateScheduling | undefined;
    private _shieldedInstanceConfig;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putShieldedInstanceConfig(value: ComputeInstanceFromTemplateShieldedInstanceConfig): void;
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): ComputeInstanceFromTemplateShieldedInstanceConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInstanceFromTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeInstanceFromTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInstanceFromTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
