import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataArchiveFileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#excludes DataArchiveFile#excludes}.
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#output_file_mode DataArchiveFile#output_file_mode}.
     *
     * @stability stable
     */
    readonly outputFileMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#output_path DataArchiveFile#output_path}.
     *
     * @stability stable
     */
    readonly outputPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#source_content DataArchiveFile#source_content}.
     *
     * @stability stable
     */
    readonly sourceContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#source_content_filename DataArchiveFile#source_content_filename}.
     *
     * @stability stable
     */
    readonly sourceContentFilename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#source_dir DataArchiveFile#source_dir}.
     *
     * @stability stable
     */
    readonly sourceDir?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#source_file DataArchiveFile#source_file}.
     *
     * @stability stable
     */
    readonly sourceFile?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#type DataArchiveFile#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#source DataArchiveFile#source}
     *
     * @stability stable
     */
    readonly source?: DataArchiveFileSource[];
}
/**
 * @stability stable
 */
export interface DataArchiveFileSource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#content DataArchiveFile#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file.html#filename DataArchiveFile#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/archive/d/file.html archive_file}.
 *
 * @stability stable
 */
export declare class DataArchiveFile extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/archive/d/file.html archive_file} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataArchiveFileConfig);
    private _excludes?;
    /**
     * @stability stable
     */
    get excludes(): string[];
    /**
     * @stability stable
     */
    set excludes(value: string[]);
    /**
     * @stability stable
     */
    resetExcludes(): void;
    /**
     * @stability stable
     */
    get excludesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get outputBase64Sha256(): string;
    private _outputFileMode?;
    /**
     * @stability stable
     */
    get outputFileMode(): string;
    /**
     * @stability stable
     */
    set outputFileMode(value: string);
    /**
     * @stability stable
     */
    resetOutputFileMode(): void;
    /**
     * @stability stable
     */
    get outputFileModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get outputMd5(): string;
    private _outputPath;
    /**
     * @stability stable
     */
    get outputPath(): string;
    /**
     * @stability stable
     */
    set outputPath(value: string);
    /**
     * @stability stable
     */
    get outputPathInput(): string;
    /**
     * @stability stable
     */
    get outputSha(): string;
    /**
     * @stability stable
     */
    get outputSize(): number;
    private _sourceContent?;
    /**
     * @stability stable
     */
    get sourceContent(): string;
    /**
     * @stability stable
     */
    set sourceContent(value: string);
    /**
     * @stability stable
     */
    resetSourceContent(): void;
    /**
     * @stability stable
     */
    get sourceContentInput(): string | undefined;
    private _sourceContentFilename?;
    /**
     * @stability stable
     */
    get sourceContentFilename(): string;
    /**
     * @stability stable
     */
    set sourceContentFilename(value: string);
    /**
     * @stability stable
     */
    resetSourceContentFilename(): void;
    /**
     * @stability stable
     */
    get sourceContentFilenameInput(): string | undefined;
    private _sourceDir?;
    /**
     * @stability stable
     */
    get sourceDir(): string;
    /**
     * @stability stable
     */
    set sourceDir(value: string);
    /**
     * @stability stable
     */
    resetSourceDir(): void;
    /**
     * @stability stable
     */
    get sourceDirInput(): string | undefined;
    private _sourceFile?;
    /**
     * @stability stable
     */
    get sourceFile(): string;
    /**
     * @stability stable
     */
    set sourceFile(value: string);
    /**
     * @stability stable
     */
    resetSourceFile(): void;
    /**
     * @stability stable
     */
    get sourceFileInput(): string | undefined;
    private _type;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string;
    private _source?;
    /**
     * @stability stable
     */
    get source(): DataArchiveFileSource[];
    /**
     * @stability stable
     */
    set source(value: DataArchiveFileSource[]);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): DataArchiveFileSource[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
