import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#excludes File#excludes}.
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#output_file_mode File#output_file_mode}.
     *
     * @stability stable
     */
    readonly outputFileMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#output_path File#output_path}.
     *
     * @stability stable
     */
    readonly outputPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#source_content File#source_content}.
     *
     * @stability stable
     */
    readonly sourceContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#source_content_filename File#source_content_filename}.
     *
     * @stability stable
     */
    readonly sourceContentFilename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#source_dir File#source_dir}.
     *
     * @stability stable
     */
    readonly sourceDir?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#source_file File#source_file}.
     *
     * @stability stable
     */
    readonly sourceFile?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#type File#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#source File#source}
     *
     * @stability stable
     */
    readonly source?: FileSource[];
}
/**
 * @stability stable
 */
export interface FileSource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#content File#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/r/file.html#filename File#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/archive/r/file.html archive_file}.
 *
 * @stability stable
 */
export declare class File extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/archive/r/file.html archive_file} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FileConfig);
    private _excludes?;
    /**
     * @stability stable
     */
    get excludes(): string[];
    /**
     * @stability stable
     */
    set excludes(value: string[]);
    /**
     * @stability stable
     */
    resetExcludes(): void;
    /**
     * @stability stable
     */
    get excludesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get outputBase64Sha256(): string;
    private _outputFileMode?;
    /**
     * @stability stable
     */
    get outputFileMode(): string;
    /**
     * @stability stable
     */
    set outputFileMode(value: string);
    /**
     * @stability stable
     */
    resetOutputFileMode(): void;
    /**
     * @stability stable
     */
    get outputFileModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get outputMd5(): string;
    private _outputPath;
    /**
     * @stability stable
     */
    get outputPath(): string;
    /**
     * @stability stable
     */
    set outputPath(value: string);
    /**
     * @stability stable
     */
    get outputPathInput(): string;
    /**
     * @stability stable
     */
    get outputSha(): string;
    /**
     * @stability stable
     */
    get outputSize(): number;
    private _sourceContent?;
    /**
     * @stability stable
     */
    get sourceContent(): string;
    /**
     * @stability stable
     */
    set sourceContent(value: string);
    /**
     * @stability stable
     */
    resetSourceContent(): void;
    /**
     * @stability stable
     */
    get sourceContentInput(): string | undefined;
    private _sourceContentFilename?;
    /**
     * @stability stable
     */
    get sourceContentFilename(): string;
    /**
     * @stability stable
     */
    set sourceContentFilename(value: string);
    /**
     * @stability stable
     */
    resetSourceContentFilename(): void;
    /**
     * @stability stable
     */
    get sourceContentFilenameInput(): string | undefined;
    private _sourceDir?;
    /**
     * @stability stable
     */
    get sourceDir(): string;
    /**
     * @stability stable
     */
    set sourceDir(value: string);
    /**
     * @stability stable
     */
    resetSourceDir(): void;
    /**
     * @stability stable
     */
    get sourceDirInput(): string | undefined;
    private _sourceFile?;
    /**
     * @stability stable
     */
    get sourceFile(): string;
    /**
     * @stability stable
     */
    set sourceFile(value: string);
    /**
     * @stability stable
     */
    resetSourceFile(): void;
    /**
     * @stability stable
     */
    get sourceFileInput(): string | undefined;
    private _type;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string;
    private _source?;
    /**
     * @stability stable
     */
    get source(): FileSource[];
    /**
     * @stability stable
     */
    set source(value: FileSource[]);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): FileSource[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
