"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceGroupModifyConfigPropertyToJson = exports.BootstrapActionConfigToJson = exports.PlacementTypePropertyToJson = exports.InstanceGroupConfigPropertyToJson = exports.AutoScalingPolicyPropertyToJson = exports.ScalingRulePropertyToJson = exports.ScalingActionPropertyToJson = exports.ScalingTriggerPropertyToJson = exports.MetricDimensionPropertyToJson = exports.InstanceFleetConfigPropertyToJson = exports.InstanceFleetProvisioningSpecificationsPropertyToJson = exports.InstanceTypeConfigPropertyToJson = exports.EbsConfigurationPropertyToJson = exports.EbsBlockDeviceConfigPropertyToJson = exports.ConfigurationPropertyToJson = exports.ApplicationConfigPropertyToJson = exports.InstancesConfigPropertyToJson = exports.KerberosAttributesPropertyToJson = void 0;
const cdk = require("@aws-cdk/core");
/**
 * Render the KerberosAttributesProperty as JSON
 *
 * @param property
 */
function KerberosAttributesPropertyToJson(property) {
    return {
        ADDomainJoinPassword: cdk.stringToCloudFormation(property.adDomainJoinPassword),
        ADDomainJoinUser: cdk.stringToCloudFormation(property.adDomainJoinUser),
        CrossRealmTrustPrincipalPassword: cdk.stringToCloudFormation(property.crossRealmTrustPrincipalPassword),
        KdcAdminPassword: cdk.stringToCloudFormation(property.kdcAdminPassword),
        Realm: cdk.stringToCloudFormation(property.realm),
    };
}
exports.KerberosAttributesPropertyToJson = KerberosAttributesPropertyToJson;
/**
 * Render the InstancesConfigProperty to JSON
 *
 * @param property
 */
function InstancesConfigPropertyToJson(property) {
    return {
        AdditionalMasterSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalMasterSecurityGroups),
        AdditionalSlaveSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalSlaveSecurityGroups),
        Ec2KeyName: cdk.stringToCloudFormation(property.ec2KeyName),
        Ec2SubnetId: cdk.stringToCloudFormation(property.ec2SubnetId),
        Ec2SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(property.ec2SubnetIds),
        EmrManagedMasterSecurityGroup: cdk.stringToCloudFormation(property.emrManagedMasterSecurityGroup),
        EmrManagedSlaveSecurityGroup: cdk.stringToCloudFormation(property.emrManagedSlaveSecurityGroup),
        HadoopVersion: cdk.stringToCloudFormation(property.hadoopVersion),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceFleets: cdk.listMapper(InstanceFleetConfigPropertyToJson)(property.instanceFleets),
        InstanceGroups: cdk.listMapper(InstanceGroupConfigPropertyToJson)(property.instanceGroups),
        KeepJobFlowAliveWhenNoSteps: true,
        MasterInstanceType: cdk.stringToCloudFormation(property.masterInstanceType),
        Placement: property.placement === undefined ? property.placement : PlacementTypePropertyToJson(property.placement),
        ServiceAccessSecurityGroup: cdk.stringToCloudFormation(property.serviceAccessSecurityGroup),
        SlaveInstanceType: cdk.stringToCloudFormation(property.slaveInstanceType),
        TerminationProtected: cdk.booleanToCloudFormation(property.terminationProtected),
    };
}
exports.InstancesConfigPropertyToJson = InstancesConfigPropertyToJson;
/**
 * Render the ApplicationConfigProperty as JSON
 *
 * @param property
 */
function ApplicationConfigPropertyToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        Args: cdk.listMapper(cdk.stringToCloudFormation)(property.args),
        Version: cdk.stringToCloudFormation(property.version),
        AdditionalInfo: cdk.objectToCloudFormation(property.additionalInfo),
    };
}
exports.ApplicationConfigPropertyToJson = ApplicationConfigPropertyToJson;
/**
 * Render the ConfigurationProperty as JSON
 *
 * @param property
 */
function ConfigurationPropertyToJson(property) {
    return {
        Classification: cdk.stringToCloudFormation(property.classification),
        Properties: cdk.objectToCloudFormation(property.properties),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
    };
}
exports.ConfigurationPropertyToJson = ConfigurationPropertyToJson;
/**
 * Render the EbsBlockDeviceConfigProperty as JSON
 *
 * @param property
 */
function EbsBlockDeviceConfigPropertyToJson(property) {
    return {
        VolumeSpecification: {
            Iops: cdk.numberToCloudFormation(property.volumeSpecification.iops),
            SizeInGB: property.volumeSpecification.volumeSize?.toGibibytes(),
            VolumeType: cdk.stringToCloudFormation(property.volumeSpecification.volumeType?.valueOf()),
        },
        VolumesPerInstance: cdk.numberToCloudFormation(property.volumesPerInstance),
    };
}
exports.EbsBlockDeviceConfigPropertyToJson = EbsBlockDeviceConfigPropertyToJson;
/**
 * Render the EbsConfigurationProperty to JSON
 *
 * @param property
 */
function EbsConfigurationPropertyToJson(property) {
    return {
        EbsBlockDeviceConfigs: cdk.listMapper(EbsBlockDeviceConfigPropertyToJson)(property.ebsBlockDeviceConfigs),
        EbsOptimized: cdk.booleanToCloudFormation(property.ebsOptimized),
    };
}
exports.EbsConfigurationPropertyToJson = EbsConfigurationPropertyToJson;
/**
 * Render the InstanceTypeConfigProperty to JSON]
 *
 * @param property
 */
function InstanceTypeConfigPropertyToJson(property) {
    return {
        BidPrice: cdk.stringToCloudFormation(property.bidPrice),
        BidPriceAsPercentageOfOnDemandPrice: cdk.numberToCloudFormation(property.bidPriceAsPercentageOfOnDemandPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceType: cdk.stringToCloudFormation(property.instanceType?.valueOf()),
        WeightedCapacity: cdk.numberToCloudFormation(property.weightedCapacity),
    };
}
exports.InstanceTypeConfigPropertyToJson = InstanceTypeConfigPropertyToJson;
/**
 * Render the InstanceFleetProvisioningSpecificationsProperty to JSON
 *
 * @param property
 */
function InstanceFleetProvisioningSpecificationsPropertyToJson(property) {
    return {
        SpotSpecification: {
            AllocationStrategy: cdk.stringToCloudFormation(property.spotSpecification.allocationStrategy),
            BlockDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.blockDurationMinutes),
            TimeoutAction: cdk.stringToCloudFormation(property.spotSpecification.timeoutAction?.valueOf()),
            TimeoutDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.timeoutDurationMinutes),
        },
    };
}
exports.InstanceFleetProvisioningSpecificationsPropertyToJson = InstanceFleetProvisioningSpecificationsPropertyToJson;
/**
 * Render the InstanceFleetConfigProperty as JSON
 *
 * @param property
 */
function InstanceFleetConfigPropertyToJson(property) {
    return {
        InstanceFleetType: cdk.stringToCloudFormation(property.instanceFleetType?.valueOf()),
        InstanceTypeConfigs: cdk.listMapper(InstanceTypeConfigPropertyToJson)(property.instanceTypeConfigs),
        LaunchSpecifications: property.launchSpecifications === undefined
            ? property.launchSpecifications
            : InstanceFleetProvisioningSpecificationsPropertyToJson(property.launchSpecifications),
        Name: cdk.stringToCloudFormation(property.name),
        TargetOnDemandCapacity: cdk.numberToCloudFormation(property.targetOnDemandCapacity),
        TargetSpotCapacity: cdk.numberToCloudFormation(property.targetSpotCapacity),
    };
}
exports.InstanceFleetConfigPropertyToJson = InstanceFleetConfigPropertyToJson;
/**
 * Render the MetricDimensionProperty as JSON
 *
 * @param property
 */
function MetricDimensionPropertyToJson(property) {
    return {
        Key: cdk.stringToCloudFormation(property.key),
        Value: cdk.stringToCloudFormation(property.value),
    };
}
exports.MetricDimensionPropertyToJson = MetricDimensionPropertyToJson;
/**
 * Render the ScalingTriggerProperty to JSON
 *
 * @param property
 */
function ScalingTriggerPropertyToJson(property) {
    return {
        CloudWatchAlarmDefinition: {
            ComparisonOperator: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.comparisonOperator?.valueOf()),
            Dimensions: cdk.listMapper(MetricDimensionPropertyToJson)(property.cloudWatchAlarmDefinition.dimensions),
            EvaluationPeriods: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.evaluationPeriods),
            MetricName: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.metricName),
            Namespace: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.namespace),
            Period: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.period.toSeconds()),
            Statistic: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.statistic?.valueOf()),
            Threshold: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.threshold),
            Unit: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.unit?.valueOf()),
        },
    };
}
exports.ScalingTriggerPropertyToJson = ScalingTriggerPropertyToJson;
/**
 * Render the ScalingActionProperty to JSON
 *
 * @param property
 */
function ScalingActionPropertyToJson(property) {
    return {
        Market: cdk.stringToCloudFormation(property.market?.valueOf()),
        SimpleScalingPolicyConfiguration: {
            AdjustmentType: cdk.stringToCloudFormation(property.simpleScalingPolicyConfiguration.adjustmentType),
            CoolDown: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.coolDown),
            ScalingAdjustment: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.scalingAdjustment),
        },
    };
}
exports.ScalingActionPropertyToJson = ScalingActionPropertyToJson;
/**
 * Render the ScalingRuleProperty to JSON
 *
 * @param property
 */
function ScalingRulePropertyToJson(property) {
    return {
        Action: ScalingActionPropertyToJson(property.action),
        Description: cdk.stringToCloudFormation(property.description),
        Name: cdk.stringToCloudFormation(property.name),
        Trigger: ScalingTriggerPropertyToJson(property.trigger),
    };
}
exports.ScalingRulePropertyToJson = ScalingRulePropertyToJson;
/**
 * Render the AutoScalingPolicyProperty to JSON
 *
 * @param property
 */
function AutoScalingPolicyPropertyToJson(property) {
    return {
        Constraints: {
            MaxCapacity: cdk.numberToCloudFormation(property.constraints.maxCapacity),
            MinCapacity: cdk.numberToCloudFormation(property.constraints.minCapacity),
        },
        Rules: cdk.listMapper(ScalingRulePropertyToJson)(property.rules),
    };
}
exports.AutoScalingPolicyPropertyToJson = AutoScalingPolicyPropertyToJson;
/**
 * Render the InstanceGroupConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupConfigPropertyToJson(property) {
    return {
        AutoScalingPolicy: property.autoScalingPolicy === undefined ? property.autoScalingPolicy : AutoScalingPolicyPropertyToJson(property.autoScalingPolicy),
        BidPrice: cdk.numberToCloudFormation(property.bidPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceRole: cdk.stringToCloudFormation(property.instanceRole?.valueOf()),
        InstanceType: cdk.stringToCloudFormation(property.instanceType),
        Market: cdk.stringToCloudFormation(property.market?.valueOf()),
        Name: cdk.stringToCloudFormation(property.name),
    };
}
exports.InstanceGroupConfigPropertyToJson = InstanceGroupConfigPropertyToJson;
/**
 * Render the PlacementTypeProperty to JSON
 *
 * @param property
 */
function PlacementTypePropertyToJson(property) {
    return {
        AvailabilityZone: cdk.stringToCloudFormation(property.availabilityZone),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(property.availabilityZones),
    };
}
exports.PlacementTypePropertyToJson = PlacementTypePropertyToJson;
/**
 * Render the BootstrapActionProperty as JSON
 *
 * @param property
 */
function BootstrapActionConfigToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        ScriptBootstrapAction: {
            Path: cdk.stringToCloudFormation(property.scriptBootstrapAction.path),
            Args: cdk.listMapper(cdk.stringToCloudFormation)(property.scriptBootstrapAction.args),
        },
    };
}
exports.BootstrapActionConfigToJson = BootstrapActionConfigToJson;
/**
 * Render the InstanceGroupModifyConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupModifyConfigPropertyToJson(property) {
    return {
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        ShrinkPolicy: property.shrinkPolicy === undefined ? property.shrinkPolicy : ShrinkPolicyPropertyToJson(property.shrinkPolicy),
    };
}
exports.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
/**
 * Render the ShrinkPolicyProperty to JSON
 *
 * @param property
 */
function ShrinkPolicyPropertyToJson(property) {
    return {
        DecommissionTimeout: cdk.numberToCloudFormation(property.decommissionTimeout?.toSeconds()),
        InstanceResizePolicy: property.instanceResizePolicy ? InstanceResizePolicyPropertyToJson(property.instanceResizePolicy) : undefined,
    };
}
/**
 * Render the InstanceResizePolicyProperty to JSON
 *
 * @param property
 */
function InstanceResizePolicyPropertyToJson(property) {
    return {
        InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
        InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
        InstanceTerminationTimeout: cdk.numberToCloudFormation(property.instanceTerminationTimeout?.toSeconds()),
    };
}
//# sourceMappingURL=data:application/json;base64,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