"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrContainersCreateVirtualCluster = exports.EksClusterInput = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * Class for supported types of EMR Containers' Container Providers
 */
var ContainerProviderTypes;
(function (ContainerProviderTypes) {
    /**
     * Supported container provider type for a EKS Cluster
     */
    ContainerProviderTypes["EKS"] = "EKS";
})(ContainerProviderTypes || (ContainerProviderTypes = {}));
/**
 * Class that supports methods which return the EKS cluster name depending on input type.
 */
class EksClusterInput {
    /**
     * Initializes the clusterName
     *
     * @param clusterName The name of the EKS Cluster
     */
    constructor(clusterName) {
        this.clusterName = clusterName;
    }
    /**
     * Specify an existing EKS Cluster as the name for this Cluster
     */
    static fromCluster(cluster) {
        return new EksClusterInput(cluster.clusterName);
    }
    /**
     * Specify a Task Input as the name for this Cluster
     */
    static fromTaskInput(taskInput) {
        return new EksClusterInput(taskInput.value);
    }
}
exports.EksClusterInput = EksClusterInput;
_a = JSII_RTTI_SYMBOL_1;
EksClusterInput[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EksClusterInput", version: "1.163.0" };
/**
 * Task that creates an EMR Containers virtual cluster from an EKS cluster
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-emr-eks.html
 */
class EmrContainersCreateVirtualCluster extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EmrContainersCreateVirtualCluster);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern ?? sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('emr-containers', 'createVirtualCluster', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Name: this.props.virtualClusterName ?? sfn.JsonPath.stringAt('States.Format(\'{}/{}\', $$.Execution.Name, $$.State.Name)'),
                ContainerProvider: {
                    Id: this.props.eksCluster.clusterName,
                    Info: {
                        EksInfo: {
                            Namespace: this.props.eksNamespace ?? 'default',
                        },
                    },
                    Type: ContainerProviderTypes.EKS,
                },
                Tags: this.props.tags,
            }),
        };
    }
    ;
    createPolicyStatements() {
        return [
            new iam.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:CreateVirtualCluster'],
            }),
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'iam',
                        region: '',
                        resource: 'role/aws-service-role/emr-containers.amazonaws.com',
                        resourceName: 'AWSServiceRoleForAmazonEMRContainers',
                    }),
                ],
                actions: ['iam:CreateServiceLinkedRole'],
                conditions: {
                    StringLike: { 'iam:AWSServiceName': 'emr-containers.amazonaws.com' },
                },
            }),
        ];
    }
}
exports.EmrContainersCreateVirtualCluster = EmrContainersCreateVirtualCluster;
_b = JSII_RTTI_SYMBOL_1;
EmrContainersCreateVirtualCluster[_b] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrContainersCreateVirtualCluster", version: "1.163.0" };
EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
//# sourceMappingURL=data:application/json;base64,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