#!/usr/bin/env python3

"""
Permet d'unifier les couleurs et la mise en
forme de tous les widgets tkinter.
"""

import os

from ...tools import Printer, temprep
from ..hmi import tkinter

JAUNE      = "#fee473"
POURPRE    = "#6a1433"
VERT_CLAIR = "#b8dc72"
VERT_FONCE = "#3f6317"

def theme(widget):
    """
    Initialise un panel de couleur qui fait
    pensser a du raisin.
    Decore 'widget' avec le bon theme
    retourne le widget.
    """
    if type(widget) is tkinter.Label:
        widget.configure(
            background=JAUNE,                   # couleur d'arriere plan
            foreground="#000",                  # couleur du texte
            )
    elif type(widget) is tkinter.Entry:
        widget.configure(
            background=VERT_CLAIR,              # couleur de fond
            foreground="#000",                  # couleur du texte
            selectbackground=VERT_FONCE,        # couleur de selection
            selectforeground=JAUNE,             # couleur du texte selectionne
            highlightcolor=VERT_FONCE,          # couleur du cadre qui indique qu'on a le focus
            highlightbackground=POURPRE,        # couleur du cadre quand il n'y a pas le focus
            highlightthickness=2,               # epaisseur de la bordure
            )
    elif type(widget) is tkinter.Button:
        widget.configure(
            background=POURPRE,                 # couleur de font en cas de non activite
            foreground=JAUNE,                   # couleur du texte en cas d'inactivite
            activebackground=VERT_FONCE,        # couleur de fond en cas d'activite
            activeforeground=JAUNE,             # couleur du texte en cas d'activite
            takefocus=0,                        # on rend les boutons inxessible par la touche 'Tab'
            )
    elif type(widget) is tkinter.Checkbutton:
        widget.configure(
            background=JAUNE,                   # couleur de fond en temps normal
            activeforeground=JAUNE,             # couleur du texte quand il y a le curseur
            activebackground=VERT_FONCE,        # couleur de font quand il y a le curseur
            highlightbackground=POURPRE,        # couleur de la bordure en temps normal
            highlightcolor=VERT_FONCE,          # couleur de la bordure quand il y a le focus
            highlightthickness=2,               # eppaisseur de la bordure
            selectcolor=VERT_CLAIR,             # couleur de la petite case
            anchor="w",                         # pour placer le wigjet a gauche quand il a trop de place
        )
    elif type(widget) is tkinter.Canvas:
        widget.configure(
            borderwidth=0,                      # c'est la taille de la bordure, donc il n'y a pas de bordure
            background=JAUNE,                   # couleur de fond
            highlightbackground=JAUNE,          # couleur du contour en cas de non selection
            height=16,                          # hauteur du canvas en pxl
            width=16,                           # largeur du canvas en pxl
        )
    elif type(widget) is tkinter.Frame:
        widget.configure(
            background=JAUNE                    # couleur de fond
            )
    elif type(widget) is tkinter.Radiobutton:
        widget.configure(
            background=JAUNE,                   # couleur de fond
            activeforeground=JAUNE,             # couleur du texte lorsque la souris est au-dessus du widget
            activebackground=VERT_FONCE,        # couleur d’arriere plan quand la souris est au-dessus du widget
            highlightbackground=POURPRE,        # couleur de la bordure en temps normal
            highlightcolor=VERT_FONCE,          # couleur de la bordure quand il y a le focus
            highlightthickness=2,               # eppaisseur de la bordure
            selectcolor=VERT_CLAIR,             # couleur de la petite case
            anchor="w",                         # pour placer le wigjet a gauche quand il a trop de place
            )
    elif type(widget) is tkinter.Spinbox:
        widget.configure(
            background=VERT_CLAIR,              # couleur de fond
            foreground="#000",                  # couleur des chiffres
            highlightbackground=POURPRE,        # couleur de la bordure quand il n'y a pas le focus
            highlightcolor=VERT_FONCE,          # couleur de la ligne de mise en valeur du focus lorsque le widget l’obtient
            selectbackground=VERT_FONCE,        # couleur de font de la selection
            selectforeground=JAUNE,             # couleur de fond quand l'item est selectionne
            highlightthickness=2,               # taille de la bordure
            buttonbackground=POURPRE,           # couleur d'arriere plan utilise par les fleches
            )
    elif type(widget) is tkinter.PanedWindow:
        widget.configure(
            orient="horizontal",                # oriantation des panneau, l'un a cote des autre et non pas les un au dessu des autres
            background=POURPRE,                 # couleur de fond (donc le cadre)
            borderwidth=2,                      # taille des bordures
            )
    elif type(widget) is tkinter.ttk.Notebook:
        style = tkinter.ttk.Style()
        style.configure("TNotebook.Tab",
            background=POURPRE,                 # couleur d'arriere plan des onglets non selectionnes
            focuscolor=POURPRE,                 # couleur des petits pointilles de focus
            foreground=JAUNE,                   # couleur du text dans les onglets
            )
        style.map("TNotebook.Tab", background=
            [("selected", JAUNE),               # couleur de l'onglet selectionne
            ("active", VERT_FONCE)],            # couleur de l'onglet sous la souris
            foreground=[("selected", "#000")])  # couleur du texte de l'onglet selectionne
    else:
        raise TypeError("Il est impossible de decorer un %s." % type(widget))
    return widget

class Icons:
    """
    Genere des icons
    """
    def __init__(self):
        self.icon_help = None
        self.icon_error = None
        self.icon_info = None
        self.icon_ok = None
        self.icon_warning = None
        self.icon_refresh = None
        self.icon_trash = None

    def help(self):
        """
        Retourne l'icon 'help'.
        """
        if self.icon_help:
            return self.icon_help
        with Printer("Loading help icon..."):
            with open(os.path.join(temprep, "help.png"), "wb") as f: # creation d'une image de taille 16*16
                f.write(
                    b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x02\xc3IDATx\xdatS\x03sdA'
                    b'\x18\xbc\xba?r\xb6m\xdb\xb6m+\xb6mol\xdb\xb6m\xdb\\o%o\xfbf^\xac\xafj<\xdd\x9f\x97\x00\x985\x96_\xd4^O\x86&\x19\x19dp\'F\xc6\xc4\xdd'
                    b'\xfa\xb9\xffg\x02\x97\x92!\xbb\xf9\xb6\xa1\xc0\xc0%\x85I\xc8\xa9C\xdf\x10\x9f\x1dto\xe0\x9a\xc2\x907!\xf9#C\xffN\xe2f\x82\xd3\x1f\xc9y'
                    b'\t\xdb\xba\x87\xe1\x13S\x8c7j\xfe8\xf4\xdc\x8a\x1dt\xef\x1b[\x82\xf6\x9ea<\x96\xf7\x12\xd2\xbf\x143\x93@\xf6\x85\x92\xaf\xb0\xab\x8f\x8b'
                    b'\x072\x9e8\xf7\xc1\x01\xa9\x85\x8d\x18\xe6\x89\xd0\xd9;\x02\xaf\xe8b\\\xf9\xe6\x8c\xd7j\x01\xe8\x1e\xe0\xe1\x89\x82\xb7\x88b(\x96\xf5y'
                    b'\xcb\x1d#A\x07\xf9x_\xc6\x03\xe4\x8c\xcf:\xc1`\x18)*\x1b{0\xc4\x15\x82JBn=\xf6?\xb7\xc1\'\xdd0t\x12E[\xee\xb0\xee\xac\xa7\x04\x9a&\x1ei'
                    b'Rj6\x05\xd3q\xe9\xab\x13\xabq\xe7#\x0b<\x90\xf3\x06\x95\xd11\x06g\xbf\xb8\xe0\xd4G\'De\xd6\xc2\xc2\'\x93\xa1XJ\x90\x91\x9c\xdf@\xfdd\xc1'
                    b'\xeb\xae\xebc\xcb]\x13\xec~l\x89\x83/m\xa1\xeb\x92\n*\xdd\xfd<\\\xfa\xe9\x81+\xbf<\xa1\xe5\x92\x86\xcc\xd2\x16\xac\xba\xac\x9bA\t\xb8\x03'
                    b'\xc3\x02\xec}l\x8e5\xd7\xf4\xc6\xc1O,q\xe8\x95\x1d\xbe\xe8G@2:\x06\xa9T\n5N\nn\xcb\xf9\xe3\xaeB\x00>\x1bFa\x88\xc4g\xc5%\x1d\xee$\x01\xf6?'
                    b'\xb5\xc0\xc6[F\xd8E\xcc\xa6\x9aO~pb\x03F\xc59\xa2\x18\x0f\x95\x83\xf1T=\x14\xcf5\xc3\xf1\xc7"\x81\x04X\x8c\x95\x94`\xd2\x85\x8fZA\xd8v\xdf'
                    b'\x94\x04\xca\x1a\xc7\xdfqp\xe3\xaf\x17\xb2\xcb\xdb\x91[\xd9\x81\x97Z\xe1x\xa5\x1d\x89w\xfa1\xf8h\x14\x0b\xfb\xd0\x12\xe4Wub\xf5U\xbd\x8c'
                    b'\xc9 2\x01\xf1e\xd8\xf5\xd8\x02\x87_\xdb\xe1\xccg\x17\xdc\x94\xf1\x81\xb1w6,\x02\xf2\xf1F7\n\x9f\x8c\xe3\xf0\xdd<\t\xbf\xacR\x90S\xd5\x05'
                    b'\xe7\xf0"\x86\xb8\xa09\x99F!M\xcd\x07\xed\x10V\xfb\x85onx\xa9\x11\x8aI\xf9f\x96\x80\x9f\x04(c\x9f\x01NT%\x06FD\xd8v\xcf\x98M\xe3d!\xc9'
                    b'\xbcR\xf5\x13\xf6\x0c\xf2\xf0\xd38\n\x97I\xb4\xdfh\x87aR~[\x8f\x83\x9dc\xaa0"\x90\xe0\x93N\xa8h\xe5e\x1d\x99y\xa5\xfcZ\xcd_\xd4C\x02\x17'
                    b'\x9b\xd3\x00}\x8f,\xfc0\x8d\x83\xacm\n\x9c\xa2*PPK\x8a\x8a\x04\xee\x87a\x84h\xed5\xfd\xc9R\x9e\xdfL[\xef\x18\x0b\xed\x83\xf2\xa4y$x#|1\xb8'
                    b'DcI]7<c\xca\x98\x1d\xf7M\x85$\xf7\xb3\x9bi\xb1v^uE7\x83\x98\xc9\xa5c\xcd5\xfd\x0c\x1a\xb0\xff\xc3\x96\x9d\x01B+\x9e\x9ch\xc3mb\x00\x00\x00'
                    b'\x00IEND\xaeB`\x82')
            self.icon_help = tkinter.PhotoImage(file=os.path.join(temprep, "help.png"))
            os.remove(os.path.join(temprep, "help.png"))
            return self.icon_help
            
    def error(self):
        """
        Retourne l'icon 'error'.
        """
        if self.icon_error:
            return self.icon_error
        with Printer("Loading error icon..."):
            with open(os.path.join(temprep, "error.png"), "wb") as f:
                f.write(
                    b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x01\xf6IDATx\xda\x84\x92\x03'
                    b'\x8c\x9cq\x10\xc5\xe7\x1c\xd4nP\xdb\xb6\xed6\xae\xe3\xe4b\x14A\x11\xd7\xb6m#\xa8m\xdb>\xdb\xc6\xeb{\xf9\xb2\xde\xcdM\xf2\xdb\x1d\xbc\x99'
                    b'\xef/\x0bf\x8f\xcd\xea=4\x9bv\xcfl\xfe\x1dr\x83\xfe5\xe6\xac*{F\xd1S\xb3\x03\xaf\xcc\x8a\xbe7m\x8a\xb8!C\xf0\x8f|n\xd3\x06w\x99\xbb\xcc\xda'
                    b'\xc5P\x83\x9e\x9b\xb5{a\x16\x97\xd0\xb3\'\xca\xcf\x9f\x07\xe2\xe3}\xa8\xb8u\x0b\xbf\xc6\x8d\xc3EjNQ\x1b\xf0e5gM\x9e\x0c\xdc\xbd\x0b<y\x02<x'
                    b'\xe0\x83+\x97\x1e\x1b\x8b\xd3\xd4\x1e\xf1^\x89\x96\x9d\xd0\xa2\x05p\xe0\x00\xf0\xea\x15P\\\x0c\\\xbe\x0c\x1c:$\xe4+\xe7\xd4\x18\x7f\xed\xd3'
                    b'\x07\x87\xd8\xe3>0\xed\xb9|\xee\\`\xf9r 7\x172\xe4\xe7\x03\xdb\xb7;\xc8\x97\xb1V\xb9x1J&L\xd0*\x8avk\x15:\xedo11\x80\x06\x88\x85\x0b\x81\xac'
                    b',\xc8\x90\x93\xe3@\xabLJBa\xef\xde\xc85\x13x@v\xb0\xd7tUq5k\x02\x83\x06y\x981\x03HO\x87\xcc\xd5\x9c\xdf\xae\x9d\x1a\xdd\xbc![\xd9k\xb7\xf9'
                    b'\xf3/:\x1ah\xdc\xd8\xc3\xd0\xa1@jj\xc0\x80<37\xaf\xc9&\r\xd0#\xf9\xc2\xa02<\xdc\xa1}{\x80\r\xaeF\xe1\xf2K8\xa4\x98Zq\x97\xac\xd7\x16\xae\xf2'
                    b' \xb8\x8d\xa2\xca\xc8HTr+\xaef$\'\x03\x1d;:\xc8\x97\xb1&\x8d\xb4\x07\xd8\xb3\xd6u\x95\x97\xcc\x0e\xfc\xabQ\x03h\xd4\x08X\xba\xd4Y\xfe\xe0\xc1'
                    b'NL\xe4+\xa7\x9a\xe2\x0f\xd4\xaef\x8f\xb9\xec\x02\']\x0c\x0f\x8f\xcbj\xd5\n\xe8\xd2\x05\xe8\xd7O\xff>\xb8r\xa9\xd4l\xa0v\x95\xff\x93>i\xd6\xee'
                    b'tDD\xdc\x0f\xee\x13\xa3F\x05\xe5\x03k\x1b\xa8YI\xad\x05\xb3\xc3\x9cz\x80K;S\xbdz\xd1S\x8a\xbf\xf0\xc5}"\x0f\xe8\x1f`N\xcbv\xbe\\\x85\xed2\xab'
                    b'\xa5G\xb2\x85\xd7\xb4\x89\xe8\xb4\xff\xaf\x17\x87F\x00\xb1/\xeb\xae,9\xe7K\x00\x00\x00\x00IEND\xaeB`\x82')
            self.icon_error = tkinter.PhotoImage(file=os.path.join(temprep, "error.png"))
            os.remove(os.path.join(temprep, "error.png"))
            return self.icon_error
    
    def info(self):
        """
        Retourne l'icon 'info'.
        """
        if self.icon_info:
            return self.icon_info
        with Printer("Loading info icon..."):
            with open(os.path.join(temprep, "info.png"), "wb") as f:
                f.write(
                    b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x03\x13IDATx\xdab@\x07\x80\xbe'
                    b'\xc8\x01H\xb23\x08\xc0\xaf\xcc\x14\xe3\x94\xcf6b[g\xdb\x1e\x9dom\xdb\xb6\xad\xd9Yc\xb4\xb6\x8d:\xdb\xfe\xf2\xe7\xec\xaej\xbb;$\xb1l\xcb\xea'
                    b'#\tQ2\xa7\x8c[{lR\xd9m\x9d\xca~\xfb\x0c\xd6\x1eM\x88\xf5\x8f\xd3,\x93\xde\x06\x03g\xce|\xbcT\x1e^f\x15\\I\xdb\xe0\x15\xae\xdf\xbc\xc7\xb5\x9b'
                    b'w\x11\xfc\x11\xd6t^@\xe5Q\xccRED\xd4k\xc9\'O\x9e\xfc`\x91<\xba>K;D\xc7\xe0\x05Z\xfa\xce\xd3=|\x89+\xd7\xef0x\xf2\n-\xbd\xe7i\x15\xb6\x8e\x81'
                    b'\x0b\x04d\xb4\xb3H\x16\xde\xfaR\x81\xa5\xca\xa8\xb2\x90\xecN\xd4\xfa\xa1G\x98\xab\x1b\xe4\xc2\x95\xdb\x00\xdc\xbdw_\xe8\x03\xcf|\x1a\xe30f!'
                    b'\xb5l9\x11]\xf6(\xd99X\xbdd\xa3U\xfe\x95\x90\xac\x0e\x822\xdb\t~\xc4;(\xa9?\xc9\xad\xdbb\xf4\xf6S\xf8\xa7\xb7>\xb2\x0b|\x14\x13\x9a\xdd\xc1'
                    b'_\xaa,R\xd5\xb5\x9fH\x7f\xa9\xe2\xbd\x94\xfe5\x98\x85\xd5a\x1eV\x8fyD\x03\'B\xeb9.\xd0<\xa2\x11\xd3p\xc1#\x1b\x1f\xdbC\xea\xd8\xea\xa4\xe5'
                    b'\xcb\xbd\xd9L\xde\x94\xca\xbcU\x1e*i\x95Y\x06\xdb\\\xf5lq\xd6\xb1\xd5\xc5\xc0fW\x03\x81\xb9=\x0c\x9c\xbe\xc6\xd9K\xb7\xb8p\xf5\x0e\x1b\x85'
                    b'\xef\xb7\xe3\xa5L\xdc\x9a\xc5\xd8\r\xe9\x8c\xdb\x90\xc6\xb8\x8d\x19,7\xcf\xee\x94\xbe\xd8\x13\xc7\xaf\xc7J\xf8E\x04\xfcr\xa2\x8c_M*\xf8\xf1'
                    b'D9~y}\x00\xdc\xbas\x8f\xa9\xbbs\x98\xb03\x9f\x89;\xd4L\xd8\x96\xcb\x84\xad\xd9\x8c\xdf\x9c\xc5\xbf\x16yH\xf3\xf6\xc43mO>\xd3\xf6\x150}\x7f!'
                    b'\xd3e\xc5L\x93\x97 \x0bm\x01\xe0\xa6(0y\xaf\x9aI\xfb\x8a\x99\xb4\xb7\x90I\xbb5L\xdc\xa9f\xbc(\xb6\xc8V\x83\xf4\xa7Ev\xcf\x84\x03\xc5L\xde_'
                    b'\xcc\x14Y)S\x14eLWU \x0bo{6\xc1LE!\xd3\x94\x15L\x96\x971\xf9@\x89(T\xc4\xf8\xfdE\xacs\xc8\x1d\x966[\xa5\xbb\x8eW\x8adE93\x0fiYp\\\xcfW&FN\xc4'
                    b'w?+\xf0\xed\xf12\xbe\x16\xb6\xf9\xc7\xf4\xcc8X)\n\x953AQ\xc4\x11\xf7<\x7fI\xab\xedx\xef7s\r\x9f\x8b\x80\xef-\x8c\xfcfS\xc3_vu\xd8\xa7>\xbe\xc1'
                    b'\x9d\xbb\xf7\xf9\xd7F\xc7\xdf\xf6u\xfcb]\xc37\xa6F\xe6\x89&\x8bm\x0bo\x0c\x9f?\xff\x99\xf4?\x98\xf8h\x0e-r\xd0\xb3\xc8\xb1\x9e\x95\xaeM\x98'
                    b'\xc4\xf5\xd0=zU|\xe1\xe6#\xd4\xb6\x9ee\x83G\x03+\x84o\xb1u9+m\xf2Y\xba\xd3\xfd;\xe9E\xb0\t-O\xda\xe2Q\x8d<\xac\x9b\xfd\xc1\x9d\xc8\x82ZQ\nT'
                    b'\x04\xb5p \xa0\x99\xbd\x01\xad\xe2.\xbd\xacw\xaad\xe9\t\xf5\xa3\xe4\xd7\xc0%\xb2\xf4/\x95g\x19.)\xfdxd\x8c\xe2\x93s\xf2\x11\xba\xa7\x8f\xe0'
                    b'\x9c\xdc\xc7\x11\x9f\nT\xf6\xc9"\xf9\x1d\xd0\xdb\xdb;.2M\xef`\xe9_R\xef\x11S\x85{t\x15\xf6!\xe5\xda\xe8L\x83\xc5\xa9\xde\xde\x0f_\x8d\xff'
                    b'\x0f6\xafdJ\xdb\x7f\xaa\xf2\x00\x00\x00\x00IEND\xaeB`\x82')
            self.icon_info = tkinter.PhotoImage(file=os.path.join(temprep, "info.png"))
            os.remove(os.path.join(temprep, "info.png"))
            return self.icon_info

    def ok(self):
        """
        Retourne l'icon 'ok'.
        """
        if self.icon_ok:
            return self.icon_ok
        with Printer("Loading ok icon..."):
            with open(os.path.join(temprep, "ok.png"), "wb") as f:
                f.write(
                    b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x01\xaaIDATx\xdac\x18( \x03'
                    b'\xc4\x11@l@\xaaF&FFF?aI\xc1\xfbr\x9a\xb2_\x81\xfcXR43333%\x1b\xda\xe9\x7f\x08\xce\xf1\xff\xcf\xc9\xc3y\x0c(&J\xacfF&&Fo\x13\x07\xc3\x0f\x8d'
                    b'\x8b\xaa\xff\x03]\xf0\x01(\xe6\x0f2\x94X\x03\x0c\xd5\x0cT\x9eO\xdd\xdd\xf7\xdf\xd8\xd9\xe0?\x90\xbf\x06\x88\xf9\xd1\x15i\x01q\x00\x10K\xa2'
                    b'\x89\x0b\t\x89\x0bnoZR\xfd?\xa7\'\x15\xe8t\x8e\xb7@1O\x0c\xdb\x05D\xf87\x05\xa6\x04\xfc\x93\x94\x97\xbc\r\x0c(_\xa0\x10\x0b\xc8\xe9,l,'
                    b'\xd9\x81\x19>\x7f&\xee\xe9\xfc\xaf\xef\xa0\xf3\x8f\x91\x91a#\xc8Pl\xceLv\x8fp\xfd\xd1\xbc\xa4\xfe\xbf\xba\x91\xea\'f\x16\xe6T\xa0\x98\xb6'
                    b'\xb2\x9e\xe2\x8d\xde\xed-\xffS;\xe2\xfe\xf3\n\xf3\x80B>\x12b8&\xe0\xe2\xe2\xe5\xda\x9e\xd3\x91\xfe\xbffA\xf9\x7fUC\xe5/\xacl,G\xe2k#\xfe5'
                    b'\xaf\xaf\xfao\xe9o\xf2\x1f\x18\x90\xa7\x80\xea\xe4\xf1\x05\x96\xa9\x92\x8e\xc2\xbb\xda\xc5\xe5\xff\xf3&\xa5\xffw\x8e\xb1\xff\xdf\xb4\xbe'
                    b'\xf2\x7frG\xf4\x7f\x11Y\xa1\xdf@\xf9\x1a \xe6\xc0\x9bP\x80Now\x89v\xf8S\xbe \xff\x7f\xc5\xe2\xfc\xff\x05\xb3\xd3\xfe\xdbGY\xfegfe~\x00\x94'
                    b'\xd7\x07\x85\x0b\xa1(\x93\xe2\x17\xe1\xbd\x14Y\x15\xf4?sR\xc2\xff\xc8\xba\x80\xff\x92\xaab\x7f\x81\xe2s\x81\x98\x8f\xd8x\x0f\x91\xd1\x90'
                    b'\xfc\xe8W\xe8\xf6\xdf\xd8[\xf7?\x0b\x1b\xf3K\xa0\x98\x0b)\t\x87\x19\x18\x95U\xbc"<\x9f\xd8\xb8\xd9~\x02\xf9\xd3\x81\x98\x97\xd4\x8c\xc3\x0c'
                    b'\xf5\xb3\x1d\x10\x0b\xe2\xf2;\x00\xfa,x\x06\\\xe1z\xcb\x00\x00\x00\x00IEND\xaeB`\x82')
            self.icon_ok = tkinter.PhotoImage(file=os.path.join(temprep, "ok.png"))
            os.remove(os.path.join(temprep, "ok.png"))
            return self.icon_ok

    def warning(self):
        """
        Retourne l'icon 'warning'.
        """
        if self.icon_warning:
            return self.icon_warning
        with Printer("Loading warning icon..."):
            with open(os.path.join(temprep, "warning.png"), "wb") as f:
                f.write(
                    b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x01\xf3IDATx\xda\x9c\xd1\x03'
                    b'\x90\x96Q\x00\x85\xe1\x93m\xdb\xb6m\xdb\xb6m\xd7(\xdb\xb6m\xdb\xb6\xedZ\xdb\xfa\xf1v\xb3\xb5g\xe6\xf9p\r\xfd)\x97j*\x81\xa4\x08\nOn\xd7U'
                    b"\xf7'\x9d\xc5\xc9j\x1a()\x92\xfe'\xb7\xea(\xb1\xe9\xecm?+\x1eu\x92\xdf\xe0\\\xca\xfc\xbf\xb3/\xf2\xdf_\x0c\xec\x0f0oNU\xd7zIQ\xf5/\xb9YG"
                    b'\xf9_\x0f\x8fd\xf1u\xde\xce\x95+G\xf0u\xde\xc6\xab\xe1\x91\xac\x0b\x8b\xab\xe2?\x9d\xc7\xddF:\x17v\xaf5\xa7N\xeda\xe1\xc2\x85\xec\xd9\xb3'
                    b'\x99\xb0{-\xb9R_\xd7$\xc5\xfc\xdb\xd2\x9b\xbb\xcc\x8b\x0f\xd6\xe3\\\xb8\xb0\x939s\xe6p\xfc\xf8&\xb0\x1e\xc6en\\vUP\x0fI\x11\xf5\xab\\\xad'
                    b'\xad\xe8\x0f\xdb\xeb\xad\xdd\xa37p\x827o\xf60q\xe2D\xee\xdf\xdf\x04\x1c\xc4\xee\xde\x91\xbbm\xe5R#\x95\x92\xfdn\xf6q>\xfbR\x82}-\xb0\t\x8be'
                    b'#\xa3F\r%(h\x15\xb0\x0c\xec3\xf0\xd9\x97\x98\xe3U5GR\xe4\x1f\xaf-\xfd\xf3\xc1\n&\xa4-0\xd9\x98jL\xe1\xec\xd9\xa1\xc0\x18c\x941\x00\x82\xab'
                    b"\xf2t\x90B'\x16TA}\x9b;\r\xb5)\xe8~r\xa0\x83\xd1\xe5\x03\x0f\x8f\xf6\xac\\\xd9\x10'\xa7f@c\xa3\xb6Q\x99\xa0\xfbq9_[\xfb$E\xff8{]\x95w\x98"
                    b"\x15\x01l\xb9\x80\x92F\x99\x0f\x96.-D\xb6l\xd9\x187.'\x90\xd7\xc8nd4\xed\x92\xe30K\xac-\xad\x86\x1f\x0e\xf4~+\xdd\xb2zG\x03\x92\x19)\x8dT"
                    b'\x1f\xb8\xb9\xa5`\xda\xb4\xa4<}\x9a\x08\x88o\xc41b\x1a\xd1\xb0zG\xe4Fs=\x94\x14[\xf7\xdb\xc8\xc1aNd\x1c\xe6\xc5\xc4a~l\x1c\x16\xc4\xf9\xf0'
                    b'6>\x96\xcd\x8dnD\xc3aN\x14\xde\x9avogG4\xc4\xadVr\x93\x94Z\xcd3(Q\xff\x1c*\xdd#\x9b\xca\xff\x8f\x1c\xf1\xf4n\x9a`\x17@\x01\x13\x99\x98\x01'
                    b'\x00\x97\x0ed$\xac}\xef\xa8\x00\x00\x00\x00IEND\xaeB`\x82')
            self.icon_warning = tkinter.PhotoImage(file=os.path.join(temprep, "warning.png"))
            os.remove(os.path.join(temprep, "warning.png"))
            return self.icon_warning

    def refresh(self):
        """
        Retourne l'icon 'refresh'.
        """
        if self.icon_refresh:
            return self.icon_refresh
        with Printer("Loading refresh icon..."):
            with open(os.path.join(temprep, "refresh.png"), "wb") as f:
                f.write(
                    b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x02&IDATx\xda\x8d\x93C{da'
                    b'\x14\x84\x83\x7f1\xb6m3\xb6\xad/7\xb6\xed\xb6\xed\x1e\xdb\xb6mk\x9d\xd5x9\xd8UN\xac\xf65\xaa\xea\xd6\xfb\x1c/\x00n\xd7\xc4\x03\x11\r\xd1'
                    b'\xb6`_G\xf7<\x12\x88\xb4\x04\xbe\x0f\xd6l\xb7\xbb\x14(\xbb\xcbM.\xba\x91Y\x91{1\xf5J\xe6\xa9\x84\x1f)\x87\xa3\x10\xbb;\x14\xe1F\x7f\x14'
                    b'\x1c\xcdB\xf6\xfeTlh[\xa5v(Pz;{}\xc1\xb5\x8c\xb3\xbc\x07\x8d\xd0>\x97\xc0\xfeV\x8f\xdd\xef\x0c\xb0\xbcQC\xffB\x0e\xd53\x11D\x0f;\x10g\x88'
                    b'\xc0\xa2\xd2\xb9\xfcQ\x02%7\xb3&\xe7_N;\xab|&\xc0\xc1\x8f6\x98_\xab`}\xa3\x85\xe1\xa5\x02\xea\xe7b\xc8\x1e\xf3 x\xd8\x86\xf6{\x8d\x08S\x04'
                    b'bv\xee\x0c\xe9(\x01\x8a\\\xd1v\xa7\x16\xfb\xde\x9ba\x7f\xa3\x87\xe2\x89\x10\xb9G2\xb0M\xb8\x1e\x14\x19+\xeb\x96 R\x1d\x8c\x10\x99?fq\xd3t'
                    b'\xe3>!\xe3D\xdc\x15\xc9\x83\x8e>G\xe9C\x1e\xfcd\x9b\xbb\xb7\xf0\xd6*F>47o\xe6\xfb\x99l\xea\x1e\x87%\xc6\xef\x0b\xffF-\xff\xa7\x96\xff\xee'
                    b'\x10o\xfc\xbd\xa9c5o\xecC\xd33\xa74OI\x9d\xe8Kf\x8c\x902B\xcaBu;\x19\x991/j\x99\x05(\xb72\x8a\xcc(2\xa3\xc8\xac\xfaq\xbeo\xc5\xfd\x9c\xe6'
                    b'\xb1Bd\xc6#\xb3\xdf\x03f\xff\xc9\xec\x9bC\xee\x84t\x0f!}?\xf2\x1a!U\x90Y\xb7\xf2\xb1\x90\xa8\x88Qw\xa1\x1cdve\xdc\xcb\x84T\'x\xd2\x8c\xce'
                    b'\xfb\xf5\xa0\xc8\xa0\xc8\xa0\xc8(>\xc9A\xf6\x80\xd7\x87T\xf2\xb8\x0b\t\xa6(\x10\xd2\x8aQ/\x13R)\xefa#\x8e|\xd9\xdd\x87t\xcf{\xd3(\xa4]\xf7'
                    b'\x9b\xfa\x90r\x07\xd3\xb1\xa0x\xceYB:y\x94\x00!\xe5\xb7\xdc\xaa\xc6\x9ew\xc6>\xa4\xc6W*h\x9eK!{"@\xe7\xed&\x94\x9c\xcaE\xb46\x14\xf3\x0bf'
                    b'\x9d%\xa4\xeb\x1d\xce\x02EV\x97\x9d\xcdC\xc1q\xd6\x8b\x14\x84\x14k\x9bW`E\xcd\xa2\x1f\x14\xf9\n!\xad \xa4\x93]\x0eS\xef\xe0P\xcb\xef=\x184'
                    b'\xc7\x02\x84\xd4\x97\x906x"\xd0\x03\x84\xac\x88\x99\xa8\xec\xca\xe6\x00\x00\x00\x00IEND\xaeB`\x82')
            self.icon_refresh = tkinter.PhotoImage(file=os.path.join(temprep, "refresh.png"))
            os.remove(os.path.join(temprep, "refresh.png"))
            return self.icon_refresh

    def trash(self):
        """
        Retourne l'icon 'trash'.
        """
        if self.icon_trash:
            return self.icon_trash
        with Printer("Loading trash icon..."):
            with open(os.path.join(temprep, "trash.png"), "wb") as f:
                f.write(
                    b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x03\x00\x00\x00(-\x0fS\x00\x00\x00\x9cPLTE\x00\x00\x00\x00\x00'
                    b'\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\xff\xff\xff\x00\x00\x00\x01\x01\x01\x04\x04\x04\x07\x07\x07\x13\x13\x13\x17\x17\x17'
                    b'\x19\x19\x19   """333@@@LLLMMMUUU]]]```bbbfffuuu{{{\x7f\x7f\x7f\x80\x80\x80\x88\x88\x88\x95\x95\x95\x97\x97\x97\x9a\x9a\x9a\xa6\xa6\xa6'
                    b'\xaa\xaa\xaa\xb5\xb5\xb5\xbb\xbb\xbb\xbf\xbf\xbf\xcb\xcb\xcb\xcc\xcc\xcc\xd4\xd4\xd4\xdf\xdf\xdf\xe1\xe1\xe1\xe5\xe5\xe5\xea\xea\xea\xec'
                    b'\xec\xec\xf0\xf0\xf0\xf4\xf4\xf4\xf6\xf6\xf6\xfd\xfd\xfd\xfe\xfe\xfe\xff\xff\xff\xeb\xbb\n%\x00\x00\x00\x07tRNS\x00 @\xc1\xc2\xdf\xf0\xed'
                    b'\xfcW\xa6\x00\x00\x00zIDATx\xda\x95\xcf\x03\x12\xc4P\x14D\xd1\x17\xdbN\xc6\xb6z\xffk\x8b\xf5\xcbs\x8a}\x8bMD"\x06\x02\xb5\xf3\x17[N\xc3'
                    b'\x0c\xdeM\xc2a\xa3D\x87F\xa6,\x0e\x1f\x81\xa0\xcc]AX\xce\xbdD\x92\x1f\xe1\n\x9d]x\x01\x11\xaeJ\x8c\xe2\xec\xdfS\x14\xcaq\x081/q\xde\x9f'
                    b'\xe1h_\x99\xb0\xbf\xad_\xdby\xe8tA|\xaa\x86\xdb\xb1\x94S\x1d\x08\xb9\xaet\xb4\xe4+\xce\xdf\xd7\xea]\x01i\xd0\x1b1\xb6\x80a\xba\x00\x00\x00'
                    b'\x00IEND\xaeB`\x82')
            self.icon_trash = tkinter.PhotoImage(file=os.path.join(temprep, "trash.png"))
            os.remove(os.path.join(temprep, "trash.png"))
            return self.icon_trash

icons = Icons()
