# -*- coding: ISO-8859-1 -*-
#
# generated by wxGlade 0.9.3 on Thu Jun 27 21:45:40 2019
#
import copy
import os
import sys
import threading
import traceback

from .mwindow import MWindow

try:
    from math import tau
except ImportError:
    from math import pi

    tau = pi * 2

import wx
import wx.aui as aui
import wx.ribbon as RB

from ..core.cutplanner import CutPlanner
from ..core.elements import LaserOperation
from ..device.lasercommandconstants import (
    COMMAND_FUNCTION,
    COMMAND_HOME,
    COMMAND_JOG,
    COMMAND_JOG_FINISH,
    COMMAND_JOG_SWITCH,
    COMMAND_LASER_OFF,
    COMMAND_LASER_ON,
    COMMAND_MODE_PROGRAM,
    COMMAND_MODE_RAPID,
    COMMAND_MOVE,
    COMMAND_SET_ABSOLUTE,
    COMMAND_SET_DIRECTION,
    COMMAND_SET_SPEED,
    COMMAND_WAIT,
    COMMAND_WAIT_FINISH,
)
from ..kernel import STATE_BUSY, Job, Module
from ..svgelements import (
    SVG_ATTR_STROKE,
    Color,
    Length,
    Matrix,
    Path,
    SVGElement,
    SVGImage,
    SVGText,
)
from .about import About
from .bufferview import BufferView
from .camerainteface import CameraInterface
from .controller import Controller
from .devicemanager import DeviceManager
from .icons import (
    icon_meerk40t,
    icons8_administrative_tools_50,
    icons8_align_bottom_50,
    icons8_align_left_50,
    icons8_align_right_50,
    icons8_align_top_50,
    icons8_camera_50,
    icons8_circle_50,
    icons8_comments_50,
    icons8_connected_50,
    icons8_console_50,
    icons8_direction_20,
    icons8_emergency_stop_button_50,
    icons8_fantasy_50,
    icons8_file_20,
    icons8_flip_horizontal_50,
    icons8_flip_vertical_50,
    icons8_group_objects_20,
    icons8_group_objects_50,
    icons8_keyboard_50,
    icons8_laser_beam_20,
    icons8_laser_beam_52,
    icons8_lock_50,
    icons8_manager_50,
    icons8_move_50,
    icons8_opened_folder_50,
    icons8_oval_50,
    icons8_padlock_50,
    icons8_pause_50,
    icons8_place_marker_50,
    icons8_polygon_50,
    icons8_polyline_50,
    icons8_rectangular_50,
    icons8_roll_50,
    icons8_route_50,
    icons8_save_50,
    icons8_type_50,
    icons8_ungroup_objects_50,
    icons8_usb_connector_50,
    icons8_vector_20,
    icons_centerize,
    icons_evenspace_horiz,
    icons_evenspace_vert,
)
from .imageproperty import ImageProperty
from .jobpreview import JobPreview
from .jobspooler import JobSpooler
from .keymap import Keymap
from .laserrender import (
    DRAW_MODE_ANIMATE,
    DRAW_MODE_BACKGROUND,
    DRAW_MODE_CACHE,
    DRAW_MODE_FILLS,
    DRAW_MODE_FLIPXY,
    DRAW_MODE_GRID,
    DRAW_MODE_GUIDES,
    DRAW_MODE_ICONS,
    DRAW_MODE_IMAGE,
    DRAW_MODE_INVERT,
    DRAW_MODE_LASERPATH,
    DRAW_MODE_PATH,
    DRAW_MODE_REFRESH,
    DRAW_MODE_RETICLE,
    DRAW_MODE_SELECTION,
    DRAW_MODE_STROKES,
    DRAW_MODE_TEXT,
    DRAW_MODE_TREE,
    LaserRender,
    swizzlecolor,
)
from .navigation import Navigation
from .notes import Notes
from .operationproperty import OperationProperty
from .pathproperty import PathProperty
from .preferences import Preferences
from .rasterwizard import RasterWizard
from .rotarysettings import RotarySettings
from .settings import Settings
from .terminal import Terminal
from .textproperty import TextProperty
from .usbconnect import UsbConnect
from .widget import (
    ElementsWidget,
    GridWidget,
    GuideWidget,
    LaserPathWidget,
    RectSelectWidget,
    ReticleWidget,
    Scene,
    SelectionWidget,
)

"""
Laser software for the Stock-LIHUIYU laserboard.

MeerK40t (pronounced MeerKat) is a built-from-the-ground-up MIT licensed
open-source laser cutting software. See https://github.com/meerk40t/meerk40t
for full details.

wxMeerK40t is the primary gui addon for MeerK40t. It requires wxPython for the interface.
The Transformations work in Windows/OSX/Linux for wxPython 4.0+ (and likely before)

"""

MILS_IN_MM = 39.3701


def plugin(kernel, lifecycle):
    if lifecycle == "register":
        kernel.register("module/wxMeerK40t", wxMeerK40t)
    if lifecycle == "configure":
        kernel_root = kernel.get_context("/")
        kernel_root.open("module/wxMeerK40t")
    elif lifecycle == "mainloop":
        kernel_root = kernel.get_context("/")
        meerk40tgui = kernel_root.open("module/wxMeerK40t")
        kernel.console("window open -p / MeerK40t\n")
        meerk40tgui.MainLoop()


ID_MAIN_TOOLBAR = wx.NewId()
ID_ADD_FILE = wx.NewId()
ID_OPEN = wx.NewId()

ID_SAVE = wx.NewId()
ID_NAV = wx.NewId()
ID_USB = wx.NewId()
ID_CONTROLLER = wx.NewId()
ID_PREFERENCES = wx.NewId()
ID_DEVICES = wx.NewId()
ID_CAMERA = wx.NewId()
ID_CAMERA1 = wx.NewId()
ID_CAMERA2 = wx.NewId()
ID_CAMERA3 = wx.NewId()
ID_CAMERA4 = wx.NewId()
ID_CAMERA5 = wx.NewId()
ID_JOB = wx.NewId()
ID_PAUSE = wx.NewId()

ID_SPOOLER = wx.NewId()
ID_KEYMAP = wx.NewId()
ID_NOTES = wx.NewId()
ID_OPERATIONS = wx.NewId()
ID_TERMINAL = wx.NewId()
ID_ROTARY = wx.NewId()
ID_RASTER = wx.NewId()

ID_HOMEPAGE = wx.NewId()

ID_SELECT = wx.NewId()

ID_MENU_IMPORT = wx.NewId()
ID_MENU_RECENT = wx.NewId()
ID_MENU_ZOOM_OUT = wx.NewId()
ID_MENU_ZOOM_IN = wx.NewId()
ID_MENU_ZOOM_SIZE = wx.NewId()

# 1 fill, 2 grids, 4 guides, 8 laserpath, 16 writer_position, 32 selection
ID_MENU_HIDE_FILLS = wx.NewId()
ID_MENU_HIDE_GUIDES = wx.NewId()
ID_MENU_HIDE_GRID = wx.NewId()
ID_MENU_HIDE_BACKGROUND = wx.NewId()
ID_MENU_HIDE_STROKES = wx.NewId()
ID_MENU_HIDE_ICONS = wx.NewId()
ID_MENU_HIDE_TREE = wx.NewId()
ID_MENU_HIDE_LASERPATH = wx.NewId()
ID_MENU_HIDE_RETICLE = wx.NewId()
ID_MENU_HIDE_SELECTION = wx.NewId()
ID_MENU_SCREEN_REFRESH = wx.NewId()
ID_MENU_SCREEN_ANIMATE = wx.NewId()
ID_MENU_SCREEN_INVERT = wx.NewId()
ID_MENU_SCREEN_FLIPXY = wx.NewId()
ID_MENU_PREVENT_CACHING = wx.NewId()
ID_MENU_HIDE_IMAGE = wx.NewId()
ID_MENU_HIDE_PATH = wx.NewId()
ID_MENU_HIDE_TEXT = wx.NewId()

ID_MENU_FILE0 = wx.NewId()
ID_MENU_FILE1 = wx.NewId()
ID_MENU_FILE2 = wx.NewId()
ID_MENU_FILE3 = wx.NewId()
ID_MENU_FILE4 = wx.NewId()
ID_MENU_FILE5 = wx.NewId()
ID_MENU_FILE6 = wx.NewId()
ID_MENU_FILE7 = wx.NewId()
ID_MENU_FILE8 = wx.NewId()
ID_MENU_FILE9 = wx.NewId()
ID_MENU_FILE_CLEAR = wx.NewId()

ID_MENU_KEYMAP = wx.NewId()
ID_MENU_DEVICE_MANAGER = wx.NewId()
ID_MENU_SETTINGS = wx.NewId()
ID_MENU_ROTARY = wx.NewId()
ID_MENU_NAVIGATION = wx.NewId()
ID_MENU_NOTES = wx.NewId()
ID_MENU_OPERATIONS = wx.NewId()
ID_MENU_CONTROLLER = wx.NewId()
ID_MENU_CAMERA = wx.NewId()
ID_MENU_TERMINAL = wx.NewId()
ID_MENU_USB = wx.NewId()
ID_MENU_SPOOLER = wx.NewId()
ID_MENU_WINDOW_RESET = wx.NewId()
ID_MENU_JOB = wx.NewId()
ID_MENU_TREE = wx.NewId()

ID_ALIGN_LEFT = wx.NewId()
ID_ALIGN_RIGHT = wx.NewId()
ID_ALIGN_TOP = wx.NewId()
ID_ALIGN_BOTTOM = wx.NewId()
ID_ALIGN_CENTER = wx.NewId()

ID_ALIGN_SPACE_V = wx.NewId()
ID_ALIGN_SPACE_H = wx.NewId()

ID_FLIP_HORIZONTAL = wx.NewId()
ID_FLIP_VERTICAL = wx.NewId()
ID_GROUP = wx.NewId()
ID_UNGROUP = wx.NewId()
ID_TOOL_POSITION = wx.NewId()
ID_TOOL_OVAL = wx.NewId()
ID_TOOL_CIRCLE = wx.NewId()
ID_TOOL_POLYGON = wx.NewId()
ID_TOOL_POLYLINE = wx.NewId()
ID_TOOL_RECT = wx.NewId()
ID_TOOL_TEXT = wx.NewId()

_ = wx.GetTranslation
supported_languages = (
    ("en", u"English", wx.LANGUAGE_ENGLISH),
    ("it", u"italiano", wx.LANGUAGE_ITALIAN),
    ("fr", u"franais", wx.LANGUAGE_FRENCH),
    ("de", u"Deutsch", wx.LANGUAGE_GERMAN),
    ("es", u"espaol", wx.LANGUAGE_SPANISH),
    ("zh", u"Chinese", wx.LANGUAGE_CHINESE),
)


def resource_path(relative_path):
    """ Get absolute path to resource, works for dev and for PyInstaller """
    base_path = getattr(sys, "_MEIPASS", os.path.dirname(os.path.abspath(__file__)))
    return os.path.join(base_path, relative_path)


# TODO: _buffer can be updated partially rather than fully rewritten, especially with some layering.


class MeerK40t(MWindow, Job):
    """
    MeerK40t main window
    """

    def __init__(self, *args, **kwds):
        super().__init__(1200, 600, *args, **kwds)
        Job.__init__(self, job_name="refresh_scene", process=self.refresh_scene)

        context = self.context
        self.root_context = context.get_context("/")

        self.DragAcceptFiles(True)
        self._mgr = aui.AuiManager()

        # notify AUI which frame to use
        self._mgr.SetManagedWindow(self)

        self._Buffer = None
        self.screen_refresh_is_requested = False
        self.screen_refresh_is_running = False
        self.screen_refresh_lock = threading.Lock()
        self.background_brush = wx.Brush("Grey")
        self.renderer = LaserRender(context)
        self.laserpath = [[0, 0] for i in range(1000)], [[0, 0] for i in range(1000)]
        self.laserpath_index = 0
        self.working_file = None
        self.wxtree = wx.TreeCtrl(
            self, wx.ID_ANY, style=wx.TR_MULTIPLE | wx.TR_HAS_BUTTONS
        )
        self.scene = wx.Panel(self, style=wx.EXPAND | wx.WANTS_CHARS)
        self.scene.SetDoubleBuffered(True)

        self._ribbon = RB.RibbonBar(self, style=RB.RIBBON_BAR_DEFAULT_STYLE)

        if self.is_dark:
            provider = self._ribbon.GetArtProvider()
            _update_ribbon_artprovider_for_dark_mode(provider)
        self.ribbon_position_aspect_ratio = True
        self.ribbon_position_ignore_update = False
        self.ribbon_position_x = 0.0
        self.ribbon_position_y = 0.0
        self.ribbon_position_h = 0.0
        self.ribbon_position_w = 0.0
        self.ribbon_position_units = 0
        self.ribbon_position_name = None
        self.__set_ribbonbar()
        stop = wx.BitmapButton(
            self, wx.ID_ANY, icons8_emergency_stop_button_50.GetBitmap()
        )

        def on_stop_button(e=None):
            try:
                self.context("estop\n")
            except AttributeError:
                pass

        self.Bind(
            wx.EVT_BUTTON,
            on_stop_button,
            stop,
        )
        stop.SetBackgroundColour(wx.Colour(127, 0, 0))
        stop.SetToolTip(_("Emergency stop/reset the controller."))
        stop.SetSize(stop.GetBestSize())
        self._mgr.AddPane(stop, aui.AuiPaneInfo().Bottom())
        #
        # home = wx.BitmapButton(self, wx.ID_ANY, icons8_home_filled_50.GetBitmap())
        # self.Bind(wx.EVT_BUTTON, lambda e: self.context.console("home\n"), home)
        # self._mgr.AddPane(home, aui.AuiPaneInfo().Bottom())

        # self.auiToolBar = wx.aui.AuiToolBar(self, wx.ID_ANY, wx.DefaultPosition, wx.DefaultSize,
        #                                     wx.aui.AUI_TB_HORZ_LAYOUT)
        # self.auiToolBar.AddTool(wx.ID_ANY, u"tool", icons8_home_filled_50.GetBitmap(),
        #                         wx.NullBitmap, wx.ITEM_NORMAL, wx.EmptyString, wx.EmptyString, None)
        # self.auiToolBar.Realize()
        # self._mgr.AddPane(self.auiToolBar,
        #                   wx.aui.AuiPaneInfo().Top().CaptionVisible(False).CloseButton(False).MaximizeButton(
        #                        False).MinimizeButton(False).PinButton(False).PaneBorder(False).Movable(
        #                        False).Dock().Fixed().DockFixed(False).Floatable(False).Layer(1))

        self._mgr.AddPane(
            self._ribbon,
            aui.AuiPaneInfo()
            .Top()
            .TopDockable()
            .BottomDockable()
            .RightDockable(False)
            .LeftDockable(False)
            .MinSize(-1, 150)
            .CaptionVisible(False),
        )
        self._mgr.AddPane(
            self.wxtree,
            aui.AuiPaneInfo()
            .CloseButton(False)
            .Left()
            .MinSize(200, -1)
            .MaxSize(275, -1)
            .LeftDockable()
            .RightDockable()
            .BottomDockable(False)
            .TopDockable(False),
        )
        self._mgr.AddPane(self.scene, aui.AuiPaneInfo().CenterPane())

        self._mgr.Update()

        # Menu Bar
        self.main_menubar = wx.MenuBar()
        self.__set_menubar()

        self.main_statusbar = self.CreateStatusBar(3)

        # end wxGlade

        self.Bind(wx.EVT_DROP_FILES, self.on_drop_file)

        self.previous_position = None
        self.__set_properties()
        self.__do_layout()

        self.__scene_binds()

        self.scene.Bind(wx.EVT_KEY_UP, self.on_key_up)
        self.scene.Bind(wx.EVT_KEY_DOWN, self.on_key_down)

        self.wxtree.Bind(wx.EVT_KEY_UP, self.on_key_up)
        self.wxtree.Bind(wx.EVT_KEY_DOWN, self.on_key_down)
        self.Bind(wx.EVT_KEY_UP, self.on_key_up)
        self.Bind(wx.EVT_KEY_DOWN, self.on_key_down)

        try:
            self.scene.Bind(wx.EVT_MAGNIFY, self.on_magnify_mouse)
            self.EnableTouchEvents(wx.TOUCH_ZOOM_GESTURE | wx.TOUCH_PAN_GESTURES)
            self.scene.Bind(wx.EVT_GESTURE_PAN, self.on_gesture)
            self.scene.Bind(wx.EVT_GESTURE_ZOOM, self.on_gesture)
            self.tree.Bind(wx.EVT_GESTURE_PAN, self.on_gesture)
            self.tree.Bind(wx.EVT_GESTURE_ZOOM, self.on_gesture)
        except AttributeError:
            # Not WX 4.1
            pass

        self.scene.SetFocus()
        self.widget_scene = None
        self.pipe_state = None

        self.shadow_tree = ShadowTree(self.context, self, self.context.elements._tree)
        self.Bind(
            wx.EVT_TREE_BEGIN_DRAG, self.shadow_tree.on_drag_begin_handler, self.wxtree
        )
        self.Bind(
            wx.EVT_TREE_END_DRAG, self.shadow_tree.on_drag_end_handler, self.wxtree
        )
        self.Bind(
            wx.EVT_TREE_ITEM_ACTIVATED, self.shadow_tree.on_item_activated, self.wxtree
        )
        self.Bind(
            wx.EVT_TREE_SEL_CHANGED,
            self.shadow_tree.on_item_selection_changed,
            self.wxtree,
        )
        self.Bind(
            wx.EVT_TREE_ITEM_RIGHT_CLICK,
            self.shadow_tree.on_item_right_click,
            self.wxtree,
        )

        self.__set_titlebar()
        self.__kernel_initialize(context)

        self.Bind(wx.EVT_SIZE, self.on_size)

        self.context.schedule(self)

        self._rotary_view = False
        self.CenterOnScreen()

    @property
    def is_dark(self):
        return wx.SystemSettings().GetColour(wx.SYS_COLOUR_WINDOW)[0] < 127

    def __scene_binds(self):
        self.scene.Bind(wx.EVT_PAINT, self.on_paint)
        self.scene.Bind(wx.EVT_ERASE_BACKGROUND, self.on_erase)

        self.scene.Bind(wx.EVT_MOTION, self.on_mouse_move)

        self.scene.Bind(wx.EVT_MOUSEWHEEL, self.on_mousewheel)

        self.scene.Bind(wx.EVT_MIDDLE_DOWN, self.on_mouse_middle_down)
        self.scene.Bind(wx.EVT_MIDDLE_UP, self.on_mouse_middle_up)

        self.scene.Bind(wx.EVT_LEFT_DCLICK, self.on_mouse_double_click)

        self.scene.Bind(wx.EVT_RIGHT_DOWN, self.on_right_mouse_down)
        self.scene.Bind(wx.EVT_RIGHT_UP, self.on_right_mouse_up)

        self.scene.Bind(wx.EVT_LEFT_DOWN, self.on_left_mouse_down)
        self.scene.Bind(wx.EVT_LEFT_UP, self.on_left_mouse_up)

    def __kernel_initialize(self, context):
        context.gui = self
        context._reticle_x = 0
        context._reticle_y = 0
        context.setting(int, "draw_mode", 0)
        context.setting(float, "units_convert", MILS_IN_MM)
        context.setting(str, "units_name", "mm")
        context.setting(int, "units_marks", 10)
        context.setting(int, "units_index", 0)
        context.setting(bool, "mouse_zoom_invert", False)
        context.setting(bool, "print_shutdown", False)
        context.setting(int, "fps", 40)
        if context.fps <= 0:
            context.fps = 60

        context.listen("units", self.space_changed)

        context.listen("export-image", self.on_export_signal)
        context.listen("background", self.on_background_signal)
        context.listen("rebuild_tree", self.on_rebuild_tree_signal)
        context.listen("refresh_tree", self.request_refresh)
        context.listen("refresh_scene", self.on_refresh_scene)
        context.listen("element_property_update", self.on_element_update)
        bed_dim = context.get_context("/")
        bed_dim.setting(int, "bed_width", 310)  # Default Value
        bed_dim.setting(int, "bed_height", 210)  # Default Value

        context.listen("active", self.on_active_change)

        self.widget_scene = context.open("module/Scene")

        self.widget_scene.add_scenewidget(
            SelectionWidget(self.widget_scene, self.shadow_tree)
        )
        self.widget_scene.add_scenewidget(RectSelectWidget(self.widget_scene))
        self.widget_scene.add_scenewidget(LaserPathWidget(self.widget_scene))
        self.widget_scene.add_scenewidget(
            ElementsWidget(self.widget_scene, self.shadow_tree, self.renderer)
        )
        self.widget_scene.add_scenewidget(GridWidget(self.widget_scene))
        self.widget_scene.add_interfacewidget(GuideWidget(self.widget_scene))
        self.widget_scene.add_interfacewidget(ReticleWidget(self.widget_scene))

        context.register("control/Transform", self.open_transform_dialog)
        context.register("control/Flip", self.open_flip_dialog)
        context.register("control/Path", self.open_path_dialog)
        context.register("control/Fill", self.open_fill_dialog)
        context.register("control/Stroke", self.open_stroke_dialog)
        context.register("control/FPS", self.open_fps_dialog)
        context.register(
            "control/Speedcode-Gear-Force", self.open_speedcode_gear_dialog
        )
        context.register("control/Jog Transition Test", self.run_jog_transition_test)
        context.register(
            "control/Jog Transition Switch Test", self.run_jog_transition_switch_test
        )
        context.register(
            "control/Jog Transition Finish Test", self.run_jog_transition_finish_test
        )
        context.register("control/Home and Dot", self.run_home_and_dot_test)

        def test_crash_in_thread():
            def foo():
                a = 1 / 0

            context.threaded(foo)

        context.register("control/Crash Thread", test_crash_in_thread)
        context.register("control/Clear Laserpath", self.clear_laserpath)
        context.register("control/egv export", self.egv_export)
        context.register("control/egv import", self.egv_import)

        @context.console_command("theme", help="Theming information and assignments")
        def theme(command, channel, _, args=tuple(), **kwargs):
            channel(str(wx.SystemSettings().GetColour(wx.SYS_COLOUR_WINDOW)))

        @context.console_command("rotaryview", help="Rotary View of Scene")
        def toggle_rotary_view(*args, **kwargs):
            self.toggle_rotary_view()

        @context.console_command("rotaryscale", help="Rotary Scale selected elements")
        def apply_rotary_scale(*args, **kwargs):
            self.apply_rotary_scale()

        self.interval = 1.0 / float(context.fps)
        self.process()

        context.setting(str, "file0", None)
        context.setting(str, "file1", None)
        context.setting(str, "file2", None)
        context.setting(str, "file3", None)
        context.setting(str, "file4", None)
        context.setting(str, "file5", None)
        context.setting(str, "file6", None)
        context.setting(str, "file7", None)
        context.setting(str, "file8", None)
        context.setting(str, "file9", None)
        self.populate_recent_menu()

        bed_dim = context.get_context("/")
        bed_dim.setting(int, "bed_width", 310)
        bed_dim.setting(int, "bed_height", 210)
        bbox = (0, 0, bed_dim.bed_width * MILS_IN_MM, bed_dim.bed_height * MILS_IN_MM)
        self.widget_scene.widget_root.focus_viewport_scene(
            bbox, self.scene.ClientSize, 0.1
        )

        def interrupt_popup():
            dlg = wx.MessageDialog(
                None,
                _("Spooling Interrupted. Press OK to Continue."),
                _("Interrupt"),
                wx.OK,
            )
            dlg.ShowModal()
            dlg.Destroy()

        def interrupt():
            yield COMMAND_WAIT_FINISH
            yield COMMAND_FUNCTION, interrupt_popup

        context.register("plan/interrupt", interrupt)

        # Registers the render-op make_raster. This is used to do cut planning.
        context.register("render-op/make_raster", self.renderer.make_raster)

    def __set_ribbonbar(self):
        home = RB.RibbonPage(
            self._ribbon,
            wx.ID_ANY,
            _("Home"),
            icons8_opened_folder_50.GetBitmap(),
        )

        toolbar_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("" if self.is_dark else "Main"),
            style=wx.ribbon.RIBBON_PANEL_NO_AUTO_MINIMISE | RB.RIBBON_PANEL_FLEXIBLE,
        )
        self.Bind(
            RB.EVT_RIBBONBAR_HELP_CLICK,
            lambda e: self.context.console("webhelp help\n"),
        )
        toolbar = RB.RibbonButtonBar(toolbar_panel)
        self.toolbar_button_bar = toolbar
        toolbar.AddButton(ID_OPEN, _("Open"), icons8_opened_folder_50.GetBitmap(), "")
        toolbar.AddButton(ID_SAVE, _("Save"), icons8_save_50.GetBitmap(), "")
        toolbar.AddButton(ID_JOB, _("Start Job"), icons8_laser_beam_52.GetBitmap(), "")
        toolbar.AddToggleButton(ID_PAUSE, _("Pause"), icons8_pause_50.GetBitmap(), "")

        windows_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("" if self.is_dark else "Windows"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )
        windows = RB.RibbonButtonBar(windows_panel)
        self.window_button_bar = windows
        windows.AddButton(ID_NAV, _("Navigation"), icons8_move_50.GetBitmap(), "")
        windows.AddButton(ID_USB, _("Usb"), icons8_usb_connector_50.GetBitmap(), "")
        windows.AddButton(ID_SPOOLER, _("Spooler"), icons8_route_50.GetBitmap(), "")
        windows.AddButton(
            ID_CONTROLLER, _("Controller"), icons8_connected_50.GetBitmap(), ""
        )
        windows.AddButton(
            ID_PREFERENCES,
            _("Preferences"),
            icons8_administrative_tools_50.GetBitmap(),
            "",
        )
        windows.AddButton(ID_DEVICES, _("Devices"), icons8_manager_50.GetBitmap(), "")
        if self.context.has_feature("modifier/Camera"):
            windows.AddHybridButton(
                ID_CAMERA, _("Camera"), icons8_camera_50.GetBitmap(), ""
            )

        windows.AddButton(ID_KEYMAP, _("Keymap"), icons8_keyboard_50.GetBitmap(), "")
        windows.AddButton(ID_NOTES, _("Notes"), icons8_comments_50.GetBitmap(), "")
        windows.AddButton(ID_TERMINAL, _("Terminal"), icons8_console_50.GetBitmap(), "")
        windows.AddButton(ID_ROTARY, _("Rotary"), icons8_roll_50.GetBitmap(), "")
        windows.AddButton(
            ID_RASTER, _("RasterWizard"), icons8_fantasy_50.GetBitmap(), ""
        )
        home = RB.RibbonPage(
            self._ribbon,
            wx.ID_ANY,
            _("Tools"),
            icons8_opened_folder_50.GetBitmap(),
        )

        align_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Align"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )
        align = RB.RibbonButtonBar(align_panel)
        align.AddButton(
            ID_ALIGN_LEFT, _("Align Left"), icons8_align_left_50.GetBitmap(), ""
        )
        align.AddButton(
            ID_ALIGN_RIGHT, _("Align Right"), icons8_align_right_50.GetBitmap(), ""
        )
        align.AddButton(
            ID_ALIGN_TOP, _("Align Top"), icons8_align_top_50.GetBitmap(), ""
        )
        align.AddButton(
            ID_ALIGN_BOTTOM, _("Align Bottom"), icons8_align_bottom_50.GetBitmap(), ""
        )
        align.AddButton(
            ID_ALIGN_CENTER, _("Align Center"), icons_centerize.GetBitmap(), ""
        )
        align.AddButton(
            ID_ALIGN_SPACE_V, _("Space Vertical"), icons_evenspace_vert.GetBitmap(), ""
        )
        align.AddButton(
            ID_ALIGN_SPACE_H,
            _("Space Horizontal"),
            icons_evenspace_horiz.GetBitmap(),
            "",
        )

        # TODO: Fix and reenable.
        align.EnableButton(ID_ALIGN_LEFT, False)
        align.EnableButton(ID_ALIGN_RIGHT, False)
        align.EnableButton(ID_ALIGN_TOP, False)
        align.EnableButton(ID_ALIGN_BOTTOM, False)
        align.EnableButton(ID_ALIGN_CENTER, False)
        align.EnableButton(ID_ALIGN_SPACE_V, False)
        align.EnableButton(ID_ALIGN_SPACE_H, False)

        flip_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Flip"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )
        flip = RB.RibbonButtonBar(flip_panel)

        flip.AddButton(
            ID_FLIP_HORIZONTAL,
            _("Flip Horizontal"),
            icons8_flip_horizontal_50.GetBitmap(),
            "",
        )
        flip.AddButton(
            ID_FLIP_VERTICAL,
            _("Flip Vertical"),
            icons8_flip_vertical_50.GetBitmap(),
            "",
        )

        group_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Group"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )

        group = RB.RibbonButtonBar(group_panel)
        group.AddButton(ID_GROUP, _("Group"), icons8_group_objects_50.GetBitmap(), "")
        group.AddButton(
            ID_UNGROUP, _("Ungroup"), icons8_ungroup_objects_50.GetBitmap(), ""
        )

        # TODO: Fix and Reenable.
        group.EnableButton(ID_GROUP, False)
        group.EnableButton(ID_UNGROUP, False)

        tool_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Tools"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )
        tool = RB.RibbonButtonBar(tool_panel)
        tool.AddButton(
            ID_TOOL_POSITION, _("Set Position"), icons8_place_marker_50.GetBitmap(), ""
        )
        tool.AddButton(ID_TOOL_OVAL, _("Oval"), icons8_oval_50.GetBitmap(), "")
        tool.AddButton(ID_TOOL_CIRCLE, _("Circle"), icons8_circle_50.GetBitmap(), "")
        tool.AddButton(ID_TOOL_POLYGON, _("Polygon"), icons8_polygon_50.GetBitmap(), "")
        tool.AddButton(
            ID_TOOL_POLYLINE, _("Polyline"), icons8_polyline_50.GetBitmap(), ""
        )
        tool.AddButton(
            ID_TOOL_RECT, _("Rectangle"), icons8_rectangular_50.GetBitmap(), ""
        )
        tool.AddButton(ID_TOOL_TEXT, _("Text"), icons8_type_50.GetBitmap(), "")

        # TODO: Fix and Reenable
        tool.EnableButton(ID_TOOL_POSITION, False)
        tool.EnableButton(ID_TOOL_OVAL, False)
        tool.EnableButton(ID_TOOL_CIRCLE, False)
        tool.EnableButton(ID_TOOL_POLYLINE, False)
        tool.EnableButton(ID_TOOL_POLYGON, False)
        tool.EnableButton(ID_TOOL_RECT, False)
        tool.EnableButton(ID_TOOL_TEXT, False)

        home = RB.RibbonPage(
            self._ribbon,
            wx.ID_ANY,
            _("Position"),
            icons8_opened_folder_50.GetBitmap(),
        )
        position_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Position"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )

        self.text_x = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.text_y = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.text_w = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.button_aspect_ratio = wx.BitmapButton(
            position_panel, wx.ID_ANY, icons8_lock_50.GetBitmap()
        )
        self.text_h = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.combo_box_units = wx.ComboBox(
            position_panel,
            wx.ID_ANY,
            choices=["mm", "cm", "inch", "mil", "%"],
            style=wx.CB_DROPDOWN | wx.CB_READONLY,
        )

        self.button_aspect_ratio.SetSize(self.button_aspect_ratio.GetBestSize())
        self.combo_box_units.SetSelection(0)

        sizer_panel = wx.BoxSizer(wx.HORIZONTAL)
        sizer_units = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "Units:"), wx.HORIZONTAL
        )
        sizer_h = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "H:"), wx.HORIZONTAL
        )
        sizer_w = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "W:"), wx.HORIZONTAL
        )
        sizer_y = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "Y:"), wx.HORIZONTAL
        )
        sizer_x = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "X:"), wx.HORIZONTAL
        )
        sizer_x.Add(self.text_x, 1, 0, 0)
        sizer_panel.Add(sizer_x, 0, 0, 0)
        sizer_y.Add(self.text_y, 1, 0, 0)
        sizer_panel.Add(sizer_y, 0, 0, 0)
        sizer_w.Add(self.text_w, 1, 0, 0)
        sizer_panel.Add(sizer_w, 0, 0, 0)
        sizer_panel.Add(self.button_aspect_ratio, 0, 0, 0)
        sizer_h.Add(self.text_h, 1, 0, 0)
        sizer_panel.Add(sizer_h, 0, 0, 0)
        sizer_units.Add(self.combo_box_units, 0, 0, 0)
        sizer_panel.Add(sizer_units, 0, 0, 0)
        position_panel.SetSizer(sizer_panel)
        self._ribbon.Realize()

        self.Bind(wx.EVT_TEXT, self.on_text_x, self.text_x)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_pos_enter, self.text_x)
        self.Bind(wx.EVT_TEXT, self.on_text_y, self.text_y)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_pos_enter, self.text_y)
        self.Bind(wx.EVT_TEXT, self.on_text_w, self.text_w)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_dim_enter, self.text_w)
        self.Bind(wx.EVT_BUTTON, self.on_button_aspect_ratio, self.button_aspect_ratio)
        self.Bind(wx.EVT_TEXT, self.on_text_h, self.text_h)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_dim_enter, self.text_h)
        self.Bind(wx.EVT_COMBOBOX, self.on_combo_box_units, self.combo_box_units)

        toolbar.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_click_open, id=ID_OPEN)
        toolbar.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_click_save, id=ID_SAVE)
        toolbar.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / JobPreview 0\n"),
            id=ID_JOB,
        )
        toolbar.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_click_pause, id=ID_PAUSE)
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context("window open UsbConnect\n"),
            id=ID_USB,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open Controller\n"),
            id=ID_CONTROLLER,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open Preferences\n"),
            id=ID_PREFERENCES,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p rotary/1 Rotary\n"),
            id=ID_ROTARY,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open JobSpooler\n"),
            id=ID_SPOOLER,
        )
        windows.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_camera_click, id=ID_CAMERA)
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / Navigation\n"),
            id=ID_NAV,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / DeviceManager\n"),
            id=ID_DEVICES,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / Keymap\n"),
            id=ID_KEYMAP,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / Notes\n"),
            id=ID_NOTES,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / Terminal\n"),
            id=ID_TERMINAL,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / Operations\n"),
            id=ID_OPERATIONS,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.console("window open -p / RasterWizard\n"),
            id=ID_RASTER,
        )
        if self.context.has_feature("modifier/Camera"):
            windows.Bind(
                RB.EVT_RIBBONBUTTONBAR_DROPDOWN_CLICKED,
                self.on_camera_dropdown,
                id=ID_CAMERA,
            )

            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA1)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA2)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA3)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA4)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA5)
        align.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("align left\n"),
            id=ID_ALIGN_LEFT,
        )
        align.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("align right\n"),
            id=ID_ALIGN_RIGHT,
        )
        align.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("align top\n"),
            id=ID_ALIGN_TOP,
        )
        align.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("align bottom\n"),
            id=ID_ALIGN_BOTTOM,
        )
        align.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("align center\n"),
            id=ID_ALIGN_CENTER,
        )
        align.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("align spacev\n"),
            id=ID_ALIGN_SPACE_V,
        )
        align.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("align spaceh\n"),
            id=ID_ALIGN_SPACE_H,
        )
        flip.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("scale 1 -1\n"),
            id=ID_FLIP_HORIZONTAL,
        )
        flip.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("scale -1 1\n"),
            id=ID_FLIP_VERTICAL,
        )
        group.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("group\n"),
            id=ID_GROUP,
        )
        group.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("ungroup\n"),
            id=ID_UNGROUP,
        )
        tool.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("tool position\n"),
            id=ID_TOOL_POSITION,
        )
        tool.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("tool oval\n"),
            id=ID_TOOL_OVAL,
        )
        tool.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("tool circle\n"),
            id=ID_TOOL_CIRCLE,
        )
        tool.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("tool polygon\n"),
            id=ID_TOOL_POLYGON,
        )
        tool.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("tool polyline\n"),
            id=ID_TOOL_POLYLINE,
        )
        tool.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("tool rect\n"),
            id=ID_TOOL_RECT,
        )
        tool.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda e: self.context.console("tool text\n"),
            id=ID_TOOL_TEXT,
        )
        self.context.setting(int, "units_index", 0)
        self.ribbon_position_units = self.context.units_index
        self.update_ribbon_position()

    def on_camera_dropdown(self, event):
        menu = wx.Menu()
        menu.Append(ID_CAMERA1, "Camera %d" % 1)
        menu.Append(ID_CAMERA2, "Camera %d" % 2)
        menu.Append(ID_CAMERA3, "Camera %d" % 3)
        menu.Append(ID_CAMERA4, "Camera %d" % 4)
        menu.Append(ID_CAMERA5, "Camera %d" % 5)
        event.PopupMenu(menu)

    def on_camera_click(self, event):
        eid = event.GetId()
        self.context.setting(int, "camera_default", 1)
        if eid == ID_CAMERA1:
            self.context.camera_default = 1
        elif eid == ID_CAMERA2:
            self.context.camera_default = 2
        elif eid == ID_CAMERA3:
            self.context.camera_default = 3
        elif eid == ID_CAMERA4:
            self.context.camera_default = 4
        elif eid == ID_CAMERA5:
            self.context.camera_default = 5

        v = self.context.camera_default
        self.context.console("camwin %d\n" % v)

    def __set_menubar(self):
        wxglade_tmp_menu = wx.Menu()

        wxglade_tmp_menu.Append(wx.ID_NEW, _("New\tCtrl-N"), "")
        wxglade_tmp_menu.Append(wx.ID_OPEN, _("Open Project\tCtrl-O"), "")
        self.recent_file_menu = wx.Menu()
        wxglade_tmp_menu.AppendSubMenu(self.recent_file_menu, _("Recent"))
        wxglade_tmp_menu.Append(ID_MENU_IMPORT, _("Import File"), "")
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(wx.ID_SAVE, _("Save\tCtrl-S"), "")
        wxglade_tmp_menu.Append(wx.ID_SAVEAS, _("Save As\tCtrl-Shift-S"), "")
        wxglade_tmp_menu.AppendSeparator()

        wxglade_tmp_menu.Append(wx.ID_EXIT, _("Exit"), "")
        self.main_menubar.Append(wxglade_tmp_menu, _("File"))
        wxglade_tmp_menu = wx.Menu()

        wxglade_tmp_menu.Append(ID_MENU_ZOOM_OUT, _("Zoom Out\tCtrl--"), "")
        wxglade_tmp_menu.Append(ID_MENU_ZOOM_IN, _("Zoom In\tCtrl-+"), "")
        wxglade_tmp_menu.Append(ID_MENU_ZOOM_SIZE, _("Zoom To Size"), "")
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(ID_MENU_HIDE_GRID, _("Hide Grid"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_BACKGROUND, _("Hide Background"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_GUIDES, _("Hide Guides"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(ID_MENU_HIDE_PATH, _("Hide Paths"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_IMAGE, _("Hide Images"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_TEXT, _("Hide Text"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_FILLS, _("Hide Fills"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_STROKES, _("Hide Strokes"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_LASERPATH, _("Hide Laserpath"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_RETICLE, _("Hide Reticle"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_SELECTION, _("Hide Selection"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(ID_MENU_HIDE_ICONS, _("Hide Icons"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_TREE, _("Hide Tree"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(
            ID_MENU_PREVENT_CACHING, _("Do Not Cache Image"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_SCREEN_REFRESH, _("Do Not Refresh"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_SCREEN_ANIMATE, _("Do Not Animate"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(ID_MENU_SCREEN_INVERT, _("Invert"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_SCREEN_FLIPXY, _("Flip XY"), "", wx.ITEM_CHECK)

        self.main_menubar.Append(wxglade_tmp_menu, _("View"))
        wxglade_tmp_menu = wx.Menu()
        self.main_menubar.view = wxglade_tmp_menu
        self.main_menubar.preferences = wxglade_tmp_menu.Append(
            wx.ID_PREFERENCES, _("Preferences"), ""
        )
        self.main_menubar.settings = wxglade_tmp_menu.Append(
            ID_MENU_SETTINGS, _("Settings"), ""
        )
        self.main_menubar.rotary = wxglade_tmp_menu.Append(
            ID_MENU_ROTARY, _("Rotary Settings"), ""
        )
        self.main_menubar.keymap = wxglade_tmp_menu.Append(
            ID_MENU_KEYMAP, _("Keymap Settings"), ""
        )
        self.main_menubar.devices = wxglade_tmp_menu.Append(
            ID_MENU_DEVICE_MANAGER, _("Device Manager"), ""
        )
        if self.context.has_feature("modifier/Camera"):
            self.main_menubar.camera = wxglade_tmp_menu.Append(
                ID_MENU_CAMERA, _("Camera"), ""
            )
        self.main_menubar.terminal = wxglade_tmp_menu.Append(
            ID_MENU_TERMINAL, _("Terminal"), ""
        )
        self.main_menubar.navigation = wxglade_tmp_menu.Append(
            ID_MENU_NAVIGATION, _("Navigation"), ""
        )
        self.main_menubar.controller = wxglade_tmp_menu.Append(
            ID_MENU_CONTROLLER, _("Controller"), ""
        )
        self.main_menubar.notes = wxglade_tmp_menu.Append(ID_MENU_NOTES, _("Notes"), "")
        self.main_menubar.usb = wxglade_tmp_menu.Append(ID_MENU_USB, _("USB"), "")
        self.main_menubar.jobspooler = wxglade_tmp_menu.Append(
            ID_MENU_SPOOLER, _("Job Spooler"), ""
        )
        self.main_menubar.jobpreview = wxglade_tmp_menu.Append(
            ID_MENU_JOB, _("Execute Job"), ""
        )
        wxglade_tmp_menu.AppendSeparator()
        self.main_menubar.windowreset = wxglade_tmp_menu.Append(
            ID_MENU_WINDOW_RESET, _("Reset Windows"), ""
        )

        self.main_menubar.Append(wxglade_tmp_menu, _("Tools"))

        from sys import platform

        if platform == "darwin":
            wxglade_tmp_menu = wx.Menu()
            self.main_menubar.Append(wxglade_tmp_menu, "Window")

        wxglade_tmp_menu = wx.Menu()
        wxglade_tmp_menu.Append(wx.ID_HELP, _("Help"), "")
        wxglade_tmp_menu.Append(ID_HOMEPAGE, _("Webpage"), "")
        wxglade_tmp_menu.Append(wx.ID_ABOUT, _("About"), "")
        self.main_menubar.Append(wxglade_tmp_menu, _("Help"))

        self.SetMenuBar(self.main_menubar)
        # Menu Bar end

        self.Bind(wx.EVT_MENU, self.on_click_new, id=wx.ID_NEW)
        self.Bind(wx.EVT_MENU, self.on_click_open, id=wx.ID_OPEN)
        self.Bind(wx.EVT_MENU, self.on_click_open, id=ID_MENU_IMPORT)
        self.Bind(wx.EVT_MENU, self.on_click_save, id=wx.ID_SAVE)
        self.Bind(wx.EVT_MENU, self.on_click_save_as, id=wx.ID_SAVEAS)

        self.Bind(wx.EVT_MENU, self.on_click_exit, id=wx.ID_EXIT)
        self.Bind(wx.EVT_MENU, self.on_click_zoom_out, id=ID_MENU_ZOOM_OUT)
        self.Bind(wx.EVT_MENU, self.on_click_zoom_in, id=ID_MENU_ZOOM_IN)
        self.Bind(wx.EVT_MENU, self.on_click_zoom_size, id=ID_MENU_ZOOM_SIZE)

        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_GRID), id=ID_MENU_HIDE_GRID
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_BACKGROUND),
            id=ID_MENU_HIDE_BACKGROUND,
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_GUIDES), id=ID_MENU_HIDE_GUIDES
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_PATH), id=ID_MENU_HIDE_PATH
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_IMAGE), id=ID_MENU_HIDE_IMAGE
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_TEXT), id=ID_MENU_HIDE_TEXT
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_FILLS), id=ID_MENU_HIDE_FILLS
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_LASERPATH),
            id=ID_MENU_HIDE_LASERPATH,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_RETICLE),
            id=ID_MENU_HIDE_RETICLE,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_SELECTION),
            id=ID_MENU_HIDE_SELECTION,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_STROKES),
            id=ID_MENU_HIDE_STROKES,
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_ICONS), id=ID_MENU_HIDE_ICONS
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_TREE), id=ID_MENU_HIDE_TREE
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_CACHE),
            id=ID_MENU_PREVENT_CACHING,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_REFRESH),
            id=ID_MENU_SCREEN_REFRESH,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_ANIMATE),
            id=ID_MENU_SCREEN_ANIMATE,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_INVERT),
            id=ID_MENU_SCREEN_INVERT,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_FLIPXY),
            id=ID_MENU_SCREEN_FLIPXY,
        )

        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / About\n"),
            id=wx.ID_ABOUT,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / Terminal\n"),
            id=ID_MENU_TERMINAL,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / DeviceManager\n"),
            id=ID_MENU_DEVICE_MANAGER,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / Keymap\n"),
            id=ID_MENU_KEYMAP,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / Settings\n"),
            id=ID_MENU_SETTINGS,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / Notes\n"),
            id=ID_MENU_NOTES,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / Navigation\n"),
            id=ID_MENU_NAVIGATION,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p / JobPreview 0\n"),
            id=ID_MENU_JOB,
        )
        if self.context.has_feature("modifier/Camera"):
            self.Bind(
                wx.EVT_MENU,
                lambda v: self.context.console("window open -p / CameraInterface\n"),
                id=ID_MENU_CAMERA,
            )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open Preferences\n"),
            id=wx.ID_PREFERENCES,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open -p rotary/1 Rotary\n"),
            id=ID_MENU_ROTARY,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open Controller\n"),
            id=ID_MENU_CONTROLLER,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open UsbConnect\n"),
            id=ID_MENU_USB,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window open JobSpooler\n"),
            id=ID_MENU_SPOOLER,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.console("window reset *\n"),
            id=ID_MENU_WINDOW_RESET,
        )
        self.Bind(
            wx.EVT_MENU, lambda e: self.context.console("webhelp help\n"), id=wx.ID_HELP
        )
        self.Bind(
            wx.EVT_MENU,
            lambda e: self.context.console("webhelp main\n"),
            id=ID_HOMEPAGE,
        )

        self.add_language_menu()

        self.context.setting(int, "draw_mode", 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_FILLS)
        m.Check(self.context.draw_mode & DRAW_MODE_FILLS != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_GUIDES)
        m.Check(self.context.draw_mode & DRAW_MODE_GUIDES != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_BACKGROUND)
        m.Check(self.context.draw_mode & DRAW_MODE_BACKGROUND != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_GRID)
        m.Check(self.context.draw_mode & DRAW_MODE_GRID != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_LASERPATH)
        m.Check(self.context.draw_mode & DRAW_MODE_LASERPATH != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_RETICLE)
        m.Check(self.context.draw_mode & DRAW_MODE_RETICLE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_SELECTION)
        m.Check(self.context.draw_mode & DRAW_MODE_SELECTION != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_STROKES)
        m.Check(self.context.draw_mode & DRAW_MODE_STROKES != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_ICONS)
        m.Check(self.context.draw_mode & DRAW_MODE_ICONS != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_TREE)
        m.Check(self.context.draw_mode & DRAW_MODE_TREE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_PREVENT_CACHING)
        m.Check(self.context.draw_mode & DRAW_MODE_CACHE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_REFRESH)
        m.Check(self.context.draw_mode & DRAW_MODE_REFRESH != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_ANIMATE)
        m.Check(self.context.draw_mode & DRAW_MODE_ANIMATE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_PATH)
        m.Check(self.context.draw_mode & DRAW_MODE_PATH != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_IMAGE)
        m.Check(self.context.draw_mode & DRAW_MODE_IMAGE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_TEXT)
        m.Check(self.context.draw_mode & DRAW_MODE_TEXT != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_FLIPXY)
        m.Check(self.context.draw_mode & DRAW_MODE_FLIPXY != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_INVERT)
        m.Check(self.context.draw_mode & DRAW_MODE_INVERT != 0)

    def add_language_menu(self):
        tl = wx.FileTranslationsLoader()
        trans = tl.GetAvailableTranslations("meerk40t")

        if trans:
            wxglade_tmp_menu = wx.Menu()
            i = 0
            for lang in supported_languages:
                language_code, language_name, language_index = lang
                m = wxglade_tmp_menu.Append(wx.ID_ANY, language_name, "", wx.ITEM_RADIO)
                if i == self.context.language:
                    m.Check(True)

                def language_update(q):
                    return lambda e: self.context.app.update_language(q)

                self.Bind(wx.EVT_MENU, language_update(i), id=m.GetId())
                if language_code not in trans and i != 0:
                    m.Enable(False)
                i += 1
            self.main_menubar.Append(wxglade_tmp_menu, _("Languages"))

    def on_active_change(self, old_active, context_active):
        if old_active is not None:
            old_active.unlisten("pipe;error", self.on_usb_error)
            old_active.unlisten("pipe;usb_status", self.on_usb_state_text)
            old_active.unlisten("pipe;thread", self.on_pipe_state)
            old_active.unlisten("spooler;thread", self.on_spooler_state)
            old_active.unlisten("interpreter;position", self.update_position)
            old_active.unlisten("interpreter;mode", self.on_interpreter_mode)
            old_active.unlisten("bed_size", self.bed_changed)
        if context_active is not None:
            context_active.listen("pipe;error", self.on_usb_error)
            context_active.listen("pipe;usb_status", self.on_usb_state_text)
            context_active.listen("pipe;thread", self.on_pipe_state)
            context_active.listen("spooler;thread", self.on_spooler_state)
            context_active.listen("interpreter;position", self.update_position)
            context_active.listen("interpreter;mode", self.on_interpreter_mode)
            context_active.listen("bed_size", self.bed_changed)
            self.main_menubar.Enable(ID_MENU_ROTARY, True)
            self.main_menubar.Enable(ID_MENU_USB, True)
            self.main_menubar.Enable(ID_MENU_CONTROLLER, True)
            self.main_menubar.Enable(wx.ID_PREFERENCES, True)
            self.main_menubar.Enable(ID_MENU_SPOOLER, True)
            self.window_button_bar.EnableButton(ID_CONTROLLER, True)
            self.window_button_bar.EnableButton(ID_PREFERENCES, True)
            self.window_button_bar.EnableButton(ID_ROTARY, True)
            self.window_button_bar.EnableButton(ID_SPOOLER, True)
            self.window_button_bar.EnableButton(ID_USB, True)
        else:
            self.main_menubar.Enable(ID_MENU_ROTARY, False)
            self.main_menubar.Enable(ID_MENU_USB, False)
            self.main_menubar.Enable(ID_MENU_CONTROLLER, False)
            self.main_menubar.Enable(wx.ID_PREFERENCES, False)
            self.main_menubar.Enable(ID_MENU_SPOOLER, False)
            self.window_button_bar.EnableButton(ID_CONTROLLER, False)
            self.window_button_bar.EnableButton(ID_PREFERENCES, False)
            self.window_button_bar.EnableButton(ID_ROTARY, False)
            self.window_button_bar.EnableButton(ID_SPOOLER, False)
            self.window_button_bar.EnableButton(ID_USB, False)

    def window_close(self):
        self._mgr.UnInit()

        context = self.context

        if context.print_shutdown:
            context.channel("shutdown").watch(print)

        context.unschedule(self)
        self.screen_refresh_lock.acquire()  # calling shutdown live locks here since it's already shutting down.

        context.unlisten("units", self.space_changed)

        context.unlisten("export-image", self.on_export_signal)
        context.unlisten("background", self.on_background_signal)
        context.unlisten("rebuild_tree", self.on_rebuild_tree_signal)
        context.unlisten("refresh_scene", self.on_refresh_scene)
        context.unlisten("refresh_tree", self.request_refresh)
        context.unlisten("element_property_update", self.on_element_update)

        context.unlisten("active", self.on_active_change)

        self.context.console("quit\n")

    def set_fps(self, fps):
        if fps == 0:
            fps = 1
        self.context.fps = fps
        self.interval = 1.0 / float(self.context.fps)

    def on_element_update(self, *args):
        """
        Called by 'element_property_update' when the properties of an element are changed.

        :param args:
        :return:
        """
        if self.shadow_tree is not None:
            self.shadow_tree.on_element_update(*args)

    def on_rebuild_tree_request(self, *args):
        """
        Called by various functions, sends a rebuild_tree signal.
        This is to prevent multiple events from overtaxing the rebuild.

        :param args:
        :return:
        """
        self.context.signal("rebuild_tree")

    def on_refresh_tree_signal(self, *args):
        self.request_refresh()

    def on_rebuild_tree_signal(self, *args):
        """
        Called by 'rebuild_tree' signal. To refresh tree directly

        :param args:
        :return:
        """
        if self.context.draw_mode & DRAW_MODE_TREE != 0:
            self.wxtree.Hide()
            return
        else:
            self.wxtree.Show()
        self.shadow_tree.rebuild_tree()
        self.request_refresh()

    def on_refresh_scene(self, *args):
        """
        Called by 'refresh_scene' change. To refresh tree.

        :param args:
        :return:
        """
        self.request_refresh()

    def on_usb_error(self, value):
        dlg = wx.MessageDialog(
            None,
            _("All attempts to connect to USB have failed."),
            _("Usb Connection Problem."),
            wx.OK | wx.ICON_WARNING,
        )
        dlg.ShowModal()
        dlg.Destroy()

    def on_usb_state_text(self, value):
        self.main_statusbar.SetStatusText(_("Usb: %s") % value, 0)

    def on_pipe_state(self, state):
        if state == self.pipe_state:
            return
        self.pipe_state = state

        self.main_statusbar.SetStatusText(
            _("Controller: %s") % self.context._kernel.get_text_thread_state(state), 1
        )
        self.toolbar_button_bar.ToggleButton(ID_PAUSE, state == STATE_BUSY)

    def on_spooler_state(self, value):
        self.main_statusbar.SetStatusText(
            _("Spooler: %s") % self.context.get_text_thread_state(value), 2
        )

    def on_interpreter_mode(self, state):
        if state == 0:
            self.background_brush = wx.Brush("Grey")
        else:
            self.background_brush = wx.Brush("Red")
        self.request_refresh_for_animation()

    def on_export_signal(self, frame):
        image_width, image_height, frame = frame
        if frame is not None:
            elements = self.context.elements
            from PIL import Image

            img = Image.fromarray(frame)
            obj = SVGImage()
            obj.image = img
            obj.image_width = image_width
            obj.image_height = image_height
            elements.add_elem(obj)

    def on_background_signal(self, background):
        background = wx.Bitmap.FromBuffer(*background)
        self.widget_scene.signal("background", background)
        self.request_refresh()

    def __set_titlebar(self):
        device_name = ""
        device_version = ""
        if self.context is not None:
            device_version = self.context.device_version
            device_name = str(self.context.device_name)
        self.SetTitle(_("%s v%s") % (device_name, device_version))

    def __set_properties(self):
        # begin wxGlade: MeerK40t.__set_properties
        self.__set_titlebar()
        self.main_statusbar.SetStatusWidths([-1] * self.main_statusbar.GetFieldsCount())
        _icon = wx.NullIcon
        _icon.CopyFromBitmap(icon_meerk40t.GetBitmap())
        self.SetIcon(_icon)
        # statusbar fields
        main_statusbar_fields = ["Status"]
        for i in range(len(main_statusbar_fields)):
            self.main_statusbar.SetStatusText(main_statusbar_fields[i], i)
        self.wxtree.SetMaxSize((275, -1))

    def __do_layout(self):
        # main_sizer = wx.BoxSizer(wx.VERTICAL)
        # main_sizer.Add(self._ribbon, 0, wx.EXPAND, 0)
        # widget_sizer = wx.BoxSizer(wx.HORIZONTAL)
        # widget_sizer.Add(self.tree, 1, wx.EXPAND, 0)
        # widget_sizer.Add(self.scene, 5, wx.EXPAND, 0)
        # main_sizer.Add(widget_sizer, 8, wx.EXPAND, 0)
        # self.SetSizer(main_sizer)
        # self._mgr.Update()
        self.Layout()

    def load_or_open(self, filename):
        """
        Loads recent file name given. If the filename cannot be opened attempts open dialog at last known location.
        """
        if os.path.exists(filename):
            try:
                self.load(filename)
            except PermissionError:
                self.tryopen(filename)
        else:
            self.tryopen(filename)

    def tryopen(self, filename):
        """
        Loads an open dialog at given filename to load data.
        """
        files = self.context.load_types()
        defaultFile = os.path.basename(filename)
        defaultDir = os.path.dirname(filename)

        with wx.FileDialog(
            self,
            _("Open"),
            defaultDir=defaultDir,
            defaultFile=defaultFile,
            wildcard=files,
            style=wx.FD_OPEN | wx.FD_FILE_MUST_EXIST,
        ) as fileDialog:
            fileDialog.SetFilename(defaultFile)
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
            self.load(pathname)

    def populate_recent_menu(self):
        for i in range(self.recent_file_menu.MenuItemCount):
            self.recent_file_menu.Remove(self.recent_file_menu.FindItemByPosition(0))
        context = self.context
        if context.file0 is not None and len(context.file0):
            self.recent_file_menu.Append(ID_MENU_FILE0, context.file0, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file0),
                id=ID_MENU_FILE0,
            )
        if context.file1 is not None and len(context.file1):
            self.recent_file_menu.Append(ID_MENU_FILE1, context.file1, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file1),
                id=ID_MENU_FILE1,
            )
        if context.file2 is not None and len(context.file2):
            self.recent_file_menu.Append(ID_MENU_FILE2, context.file2, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file2),
                id=ID_MENU_FILE2,
            )
        if context.file3 is not None and len(context.file3):
            self.recent_file_menu.Append(ID_MENU_FILE3, context.file3, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file3),
                id=ID_MENU_FILE3,
            )
        if context.file4 is not None and len(context.file4):
            self.recent_file_menu.Append(ID_MENU_FILE4, context.file4, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file4),
                id=ID_MENU_FILE4,
            )
        if context.file5 is not None and len(context.file5):
            self.recent_file_menu.Append(ID_MENU_FILE5, context.file5, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file5),
                id=ID_MENU_FILE5,
            )
        if context.file6 is not None and len(context.file6):
            self.recent_file_menu.Append(ID_MENU_FILE6, context.file6, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file6),
                id=ID_MENU_FILE6,
            )
        if context.file7 is not None and len(context.file7):
            self.recent_file_menu.Append(ID_MENU_FILE7, context.file7, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file7),
                id=ID_MENU_FILE7,
            )
        if context.file8 is not None and len(context.file8):
            self.recent_file_menu.Append(ID_MENU_FILE8, context.file8, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file8),
                id=ID_MENU_FILE8,
            )
        if context.file9 is not None and len(context.file9):
            self.recent_file_menu.Append(ID_MENU_FILE9, context.file9, "")
            self.Bind(
                wx.EVT_MENU,
                lambda e: self.load_or_open(context.file9),
                id=ID_MENU_FILE9,
            )
        if self.recent_file_menu.MenuItemCount != 0:
            self.recent_file_menu.Append(ID_MENU_FILE_CLEAR, _("Clear Recent"), "")
            self.Bind(wx.EVT_MENU, lambda e: self.clear_recent(), id=ID_MENU_FILE_CLEAR)

    def clear_recent(self):
        for i in range(10):
            try:
                setattr(self.context, "file" + str(i), "")
            except IndexError:
                break
        self.populate_recent_menu()

    def save_recent(self, pathname):
        recent = list()
        for i in range(10):
            recent.append(getattr(self.context, "file" + str(i)))
        recent = [r for r in recent if r is not None and r != pathname and len(r) > 0]
        recent.insert(0, pathname)
        for i in range(10):
            try:
                setattr(self.context, "file" + str(i), recent[i])
            except IndexError:
                break
        self.populate_recent_menu()

    def load(self, pathname):
        self.context.setting(bool, "auto_note", True)
        self.context.setting(bool, "uniform_svg", False)
        self.context.setting(float, "svg_ppi", 96.0)
        with wx.BusyInfo(_("Loading File...")):
            n = self.context.elements.note
            results = self.context.load(
                pathname,
                channel=self.context.channel("load"),
                svg_ppi=self.context.svg_ppi,
            )
            if results:
                self.save_recent(pathname)
                if n != self.context.elements.note and self.context.auto_note:
                    self.context.console("window open -p / Notes\n")
                try:
                    if self.context.uniform_svg and pathname.lower().endswith("svg"):
                        # or (len(elements) > 0 and "meerK40t" in elements[0].values):
                        # TODO: Disabled uniform_svg, no longer detecting namespace.
                        self.working_file = pathname
                except AttributeError:
                    pass
                return True
            return False

    def on_drop_file(self, event):
        """
        Drop file handler

        Accepts multiple files drops.
        """
        accepted = 0
        rejected = 0
        rejected_files = []
        for pathname in event.GetFiles():
            if self.load(pathname):
                accepted += 1
            else:
                rejected += 1
                rejected_files.append(pathname)
        if rejected != 0:
            reject = "\n".join(rejected_files)
            err_msg = _("Some files were unrecognized:\n%s") % reject
            dlg = wx.MessageDialog(
                None, err_msg, _("Error encountered"), wx.OK | wx.ICON_ERROR
            )
            dlg.ShowModal()
            dlg.Destroy()

    def on_paint(self, event):
        try:
            if self._Buffer is None:
                self.update_buffer_ui_thread()
            wx.BufferedPaintDC(self.scene, self._Buffer)
        except RuntimeError:
            pass

    def set_buffer(self):
        width, height = self.scene.ClientSize
        if width <= 0:
            width = 1
        if height <= 0:
            height = 1
        self._Buffer = wx.Bitmap(width, height)

    def on_size(self, event):
        if self.context is None:
            return
        self.Layout()
        self.widget_scene.signal("guide")
        self.request_refresh()

    def update_position(self, pos):
        self.laserpath[0][self.laserpath_index][0] = pos[0]
        self.laserpath[0][self.laserpath_index][1] = pos[1]
        self.laserpath[1][self.laserpath_index][0] = pos[2]
        self.laserpath[1][self.laserpath_index][1] = pos[3]
        self.context._reticle_x = pos[2]
        self.context._reticle_y = pos[3]
        self.laserpath_index += 1
        self.laserpath_index %= len(self.laserpath[0])
        # self.request_refresh()
        self.request_refresh_for_animation()

    def space_changed(self, *args):
        self.ribbon_position_units = self.context.units_index
        self.update_ribbon_position()
        self.widget_scene.signal("grid")
        self.widget_scene.signal("guide")
        self.request_refresh()

    def bed_changed(self, *args):
        self.widget_scene.signal("grid")
        # self.widget_scene.signal('guide')
        self.request_refresh()

    def on_emphasized_elements_changed(self, *args):
        self.update_ribbon_position()
        self.clear_laserpath()
        self.request_refresh()

    def on_element_modified(self, *args):
        self.update_ribbon_position()

    def clear_laserpath(self):
        self.laserpath = [[0, 0] for i in range(1000)], [[0, 0] for i in range(1000)]
        self.laserpath_index = 0

    def on_erase(self, event):
        pass

    def request_refresh_for_animation(self):
        """Called on the various signals trying to animate the screen."""
        try:
            if self.context.draw_mode & DRAW_MODE_ANIMATE == 0:
                self.request_refresh()
        except AttributeError:
            pass

    def request_refresh(self):
        """Request an update to the scene."""
        try:
            if self.context.draw_mode & DRAW_MODE_REFRESH == 0:
                self.screen_refresh_is_requested = True
        except AttributeError:
            pass

    def refresh_scene(self):
        """Called by the Scheduler at a given the specified framerate."""
        if self.screen_refresh_is_requested and not self.screen_refresh_is_running:
            self.screen_refresh_is_running = True
            if self.screen_refresh_lock.acquire(timeout=1):
                if not wx.IsMainThread():
                    wx.CallAfter(self._refresh_in_ui)
                else:
                    self._refresh_in_ui()
            else:
                self.screen_refresh_is_requested = False
                self.screen_refresh_is_running = False

    def _refresh_in_ui(self):
        """Called by refresh_scene() in the UI thread."""
        if self.context is None:
            return
        self.update_buffer_ui_thread()
        self.scene.Refresh()
        self.scene.Update()
        self.screen_refresh_is_requested = False
        self.screen_refresh_is_running = False
        self.screen_refresh_lock.release()

    def update_buffer_ui_thread(self):
        """Performs the redraw of the data in the UI thread."""
        dm = self.context.draw_mode
        if self._Buffer is None or self._Buffer.GetSize() != self.scene.ClientSize:
            self.set_buffer()
        dc = wx.MemoryDC()
        dc.SelectObject(self._Buffer)
        dc.SetBackground(self.background_brush)
        dc.Clear()
        w, h = dc.Size
        if dm & DRAW_MODE_FLIPXY != 0:
            dc.SetUserScale(-1, -1)
            dc.SetLogicalOrigin(w, h)
        gc = wx.GraphicsContext.Create(dc)
        gc.Size = dc.Size

        gc.laserpath = self.laserpath
        font = wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD)
        gc.SetFont(font, wx.BLACK)
        if self.widget_scene is not None:
            self.widget_scene.draw(gc)
        if dm & DRAW_MODE_INVERT != 0:
            dc.Blit(0, 0, w, h, dc, 0, 0, wx.SRC_INVERT)
        gc.Destroy()
        del dc

    # Mouse Events.

    def on_mousewheel(self, event):
        if self.scene.HasCapture():
            return
        rotation = event.GetWheelRotation()
        if event.GetWheelAxis() == wx.MOUSE_WHEEL_VERTICAL and not event.ShiftDown():
            if event.HasAnyModifiers():
                if rotation > 1:
                    self.widget_scene.event(event.GetPosition(), "wheelup_ctrl")
                elif rotation < -1:
                    self.widget_scene.event(event.GetPosition(), "wheeldown_ctrl")
            else:
                if rotation > 1:
                    self.widget_scene.event(event.GetPosition(), "wheelup")
                elif rotation < -1:
                    self.widget_scene.event(event.GetPosition(), "wheeldown")
        else:
            if rotation > 1:
                self.widget_scene.event(event.GetPosition(), "wheelleft")
            elif rotation < -1:
                self.widget_scene.event(event.GetPosition(), "wheelright")

    def on_mousewheel_zoom(self, event):
        if self.scene.HasCapture():
            return
        rotation = event.GetWheelRotation()
        if self.context.mouse_zoom_invert:
            rotation = -rotation
        if rotation > 1:
            self.widget_scene.event(event.GetPosition(), "wheelup")
        elif rotation < -1:
            self.widget_scene.event(event.GetPosition(), "wheeldown")

    def on_mouse_middle_down(self, event):
        self.scene.SetFocus()
        if not self.scene.HasCapture():
            self.scene.CaptureMouse()
        self.widget_scene.event(event.GetPosition(), "middledown")

    def on_mouse_middle_up(self, event):
        if self.scene.HasCapture():
            self.scene.ReleaseMouse()
        self.widget_scene.event(event.GetPosition(), "middleup")

    def on_left_mouse_down(self, event):
        self.scene.SetFocus()
        if not self.scene.HasCapture():
            self.scene.CaptureMouse()
        self.widget_scene.event(event.GetPosition(), "leftdown")

    def on_left_mouse_up(self, event):
        if self.scene.HasCapture():
            self.scene.ReleaseMouse()
        self.widget_scene.event(event.GetPosition(), "leftup")

    def on_mouse_double_click(self, event):
        if self.scene.HasCapture():
            return
        self.widget_scene.event(event.GetPosition(), "doubleclick")

    def on_mouse_move(self, event):
        if not event.Dragging():
            self.widget_scene.event(event.GetPosition(), "hover")
            return
        self.widget_scene.event(event.GetPosition(), "move")

    def on_right_mouse_down(self, event):
        self.scene.SetFocus()
        if event.AltDown():
            self.widget_scene.event(event.GetPosition(), "rightdown+alt")
        elif event.ControlDown():
            self.widget_scene.event(event.GetPosition(), "rightdown+control")
        else:
            self.widget_scene.event(event.GetPosition(), "rightdown")

    def on_right_mouse_up(self, event):
        self.widget_scene.event(event.GetPosition(), "rightup")

    def on_magnify_mouse(self, event):
        magnify = event.GetMagnification()
        if magnify > 0:
            self.widget_scene.event(event.GetPosition(), "zoom-in")
        if magnify < 0:
            self.widget_scene.event(event.GetPosition(), "zoom-out")

    def on_gesture(self, event):
        """
        This code requires WXPython 4.1 and the bind will fail otherwise.
        """
        if event.IsGestureStart():
            self.widget_scene.event(event.GetPosition(), "gesture-start")
        elif event.IsGestureEnd():
            self.widget_scene.event(event.GetPosition(), "gesture-end")
        else:
            try:
                zoom = event.GetZoomFactor()
            except AttributeError:
                zoom = 1.0
            self.widget_scene.event(event.GetPosition(), "zoom %f" % zoom)

    def on_focus_lost(self, event):
        self.context.console("-laser\nend\n")
        # event.Skip()

    def on_key_down(self, event):
        keyvalue = get_key_name(event)
        keymap = self.context.keymap
        if keyvalue in keymap:
            action = keymap[keyvalue]
            self.context.console(action + "\n")
        else:
            event.Skip()

    def on_key_up(self, event):
        keyvalue = get_key_name(event)
        keymap = self.context.keymap
        if keyvalue in keymap:
            action = keymap[keyvalue]
            if action.startswith("+"):
                # Keyup commands only trigger if the down command started with +
                action = "-" + action[1:]
                self.context.console(action + "\n")
        else:
            event.Skip()

    def update_ribbon_position(self):
        p = self.context
        elements = p.elements
        bounds = elements.selected_area()
        self.text_w.Enable(bounds is not None)
        self.text_h.Enable(bounds is not None)
        self.text_x.Enable(bounds is not None)
        self.text_y.Enable(bounds is not None)
        self.button_aspect_ratio.Enable(bounds is not None)
        if bounds is None:
            self.ribbon_position_ignore_update = True
            self.combo_box_units.SetSelection(self.ribbon_position_units)
            self.ribbon_position_ignore_update = False
            return
        x0, y0, x1, y1 = bounds
        conversion, name, index = (39.37, "mm", 0)
        if self.ribbon_position_units == 2:
            conversion, name, index = (1000.0, "in", 2)
        elif self.ribbon_position_units == 3:
            conversion, name, index = (1.0, "mil", 3)
        elif self.ribbon_position_units == 1:
            conversion, name, index = (393.7, "cm", 1)
        elif self.ribbon_position_units == 0:
            conversion, name, index = (39.37, "mm", 0)
        self.ribbon_position_name = name
        self.ribbon_position_x = x0 / conversion
        self.ribbon_position_y = y0 / conversion
        self.ribbon_position_w = (x1 - x0) / conversion
        self.ribbon_position_h = (y1 - y0) / conversion
        self.ribbon_position_ignore_update = True
        if self.ribbon_position_units != 4:
            self.text_x.SetValue("%.2f" % self.ribbon_position_x)
            self.text_y.SetValue("%.2f" % self.ribbon_position_y)
            self.text_w.SetValue("%.2f" % self.ribbon_position_w)
            self.text_h.SetValue("%.2f" % self.ribbon_position_h)
        else:
            self.text_x.SetValue("%.2f" % 100)
            self.text_y.SetValue("%.2f" % 100)
            self.text_w.SetValue("%.2f" % 100)
            self.text_h.SetValue("%.2f" % 100)
        self.combo_box_units.SetSelection(self.ribbon_position_units)
        self.ribbon_position_ignore_update = False

    def on_text_x(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            if self.ribbon_position_units != 4:
                self.ribbon_position_x = float(self.text_x.GetValue())
        except ValueError:
            pass

    def on_text_y(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            if self.ribbon_position_units != 4:
                self.ribbon_position_y = float(self.text_y.GetValue())
        except ValueError:
            pass

    def on_text_w(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            new = float(self.text_w.GetValue())
            old = self.ribbon_position_w
            if self.ribbon_position_units == 4:
                ratio = new / 100.0
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_h.SetValue("%.2f" % (ratio * 100))
                    self.ribbon_position_ignore_update = False
            else:
                ratio = new / old
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_h.SetValue("%.2f" % (self.ribbon_position_h * ratio))
                    self.ribbon_position_ignore_update = False
        except (ValueError, ZeroDivisionError):
            pass

    def on_button_aspect_ratio(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        if self.ribbon_position_aspect_ratio:
            self.button_aspect_ratio.SetBitmap(icons8_padlock_50.GetBitmap())
        else:
            self.button_aspect_ratio.SetBitmap(icons8_lock_50.GetBitmap())
        self.ribbon_position_aspect_ratio = not self.ribbon_position_aspect_ratio

    def on_text_h(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            new = float(self.text_h.GetValue())
            old = self.ribbon_position_h
            if self.ribbon_position_units == 4:
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_w.SetValue("%.2f" % (new))
                    self.ribbon_position_ignore_update = False
            else:
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_w.SetValue(
                        "%.2f" % (self.ribbon_position_w * (new / old))
                    )
                    self.ribbon_position_ignore_update = False
        except (ValueError, ZeroDivisionError):
            pass

    def on_text_dim_enter(self, event):
        if self.ribbon_position_units == 4:
            ratio_w = float(self.text_w.GetValue()) / 100.0
            ratio_h = float(self.text_h.GetValue()) / 100.0
            self.ribbon_position_w *= ratio_w
            self.ribbon_position_h *= ratio_h
        else:
            w = float(self.text_w.GetValue())
            h = float(self.text_h.GetValue())
            self.ribbon_position_w = w
            self.ribbon_position_h = h
        self.context.console(
            "resize %f%s %f%s %f%s %f%s\n"
            % (
                self.ribbon_position_x,
                self.ribbon_position_name,
                self.ribbon_position_y,
                self.ribbon_position_name,
                self.ribbon_position_w,
                self.ribbon_position_name,
                self.ribbon_position_h,
                self.ribbon_position_name,
            )
        )
        self.update_ribbon_position()

    def on_text_pos_enter(self, event):
        if self.ribbon_position_units == 4:
            ratio_x = float(self.text_x.GetValue()) / 100.0
            ratio_y = float(self.text_y.GetValue()) / 100.0
            self.ribbon_position_x *= ratio_x
            self.ribbon_position_y *= ratio_y
        else:
            x = float(self.text_x.GetValue())
            y = float(self.text_y.GetValue())
            self.ribbon_position_x = x
            self.ribbon_position_y = y
        self.context.console(
            "resize %f%s %f%s %f%s %f%s\n"
            % (
                self.ribbon_position_x,
                self.ribbon_position_name,
                self.ribbon_position_y,
                self.ribbon_position_name,
                self.ribbon_position_w,
                self.ribbon_position_name,
                self.ribbon_position_h,
                self.ribbon_position_name,
            )
        )
        self.update_ribbon_position()

    def on_combo_box_units(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        self.ribbon_position_units = self.combo_box_units.GetSelection()
        self.update_ribbon_position()

    def on_click_new(self, event):  # wxGlade: MeerK40t.<event_handler>
        context = self.context
        self.working_file = None
        context.elements.clear_all()
        self.clear_laserpath()
        self.request_refresh()

    def on_click_open(self, event):  # wxGlade: MeerK40t.<event_handler>
        # This code should load just specific project files rather than all importable formats.
        files = self.context.load_types()
        with wx.FileDialog(
            self, _("Open"), wildcard=files, style=wx.FD_OPEN | wx.FD_FILE_MUST_EXIST
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
            self.load(pathname)

    def on_click_pause(self, event):
        self.context.console("pause\n")

    def on_click_save(self, event):
        if self.working_file is None:
            self.on_click_save_as(event)
        else:
            self.context.save(self.working_file)

    def on_click_save_as(self, event):
        files = self.context.save_types()
        with wx.FileDialog(
            self,
            "Save Project",
            wildcard=files,
            style=wx.FD_SAVE | wx.FD_OVERWRITE_PROMPT,
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
            if not pathname.lower().endswith(".svg"):
                pathname += ".svg"
            self.context.save(pathname)
            self.working_file = pathname

    def on_click_exit(self, event):  # wxGlade: MeerK40t.<event_handler>
        try:
            self.Close()
        except RuntimeError:
            pass

    def on_click_zoom_out(self, event):  # wxGlade: MeerK40t.<event_handler>
        """
        Zoomout button press
        """
        m = self.scene.ClientSize / 2
        self.widget_scene.widget_root.scene_widget.scene_post_scale(
            1.0 / 1.5, 1.0 / 1.5, m[0], m[1]
        )
        self.request_refresh()

    def on_click_zoom_in(self, event):  # wxGlade: MeerK40t.<event_handler>
        """
        Zoomin button press
        """
        m = self.scene.ClientSize / 2
        self.widget_scene.widget_root.scene_widget.scene_post_scale(
            1.5, 1.5, m[0], m[1]
        )
        self.request_refresh()

    def on_click_zoom_size(self, event):  # wxGlade: MeerK40t.<event_handler>
        """
        Zoom size button press.
        """
        elements = self.context.elements
        bbox = elements.selected_area()
        if bbox is None:
            bed_dim = self.context.get_context("/")
            bbox = (
                0,
                0,
                bed_dim.bed_width * MILS_IN_MM,
                bed_dim.bed_height * MILS_IN_MM,
            )
        self.widget_scene.widget_root.focus_viewport_scene(bbox, self.scene.ClientSize)

    def toggle_draw_mode(self, bits):
        """
        Toggle the draw mode.
        :param bits: Bit to toggle.
        :return: Toggle function.
        """

        def toggle(event):
            self.context.draw_mode ^= bits
            self.context.signal("draw_mode", self.context.draw_mode)
            self.request_refresh()

        return toggle

    def open_speedcode_gear_dialog(self):
        dlg = wx.TextEntryDialog(self, _("Enter Forced Gear"), _("Gear Entry"), "")
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            value = dlg.GetValue()
            if value in ("0", "1", "2", "3", "4"):
                self.context._stepping_force = int(value)
            else:
                self.context._stepping_force = None
        dlg.Destroy()

    def open_fps_dialog(self):
        dlg = wx.TextEntryDialog(self, _("Enter FPS Limit"), _("FPS Limit Entry"), "")
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            fps = dlg.GetValue()
            try:
                self.set_fps(int(fps))
            except ValueError:
                pass
        dlg.Destroy()

    def open_transform_dialog(self):
        dlg = wx.TextEntryDialog(
            self,
            _(
                "Enter SVG Transform Instruction e.g. 'scale(1.49, 1, $x, $y)', rotate, translate, etc..."
            ),
            _("Transform Entry"),
            "",
        )
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            p = self.context
            root_context = self.context.get_context("/")
            bed_dim = self.context.get_context("/")
            m = str(dlg.GetValue())
            m = m.replace("$x", str(p.current_x))
            m = m.replace("$y", str(p.current_y))
            mx = Matrix(m)
            wmils = bed_dim.bed_width * 39.37
            hmils = bed_dim.bed_height * 39.37
            mx.render(ppi=1000, width=wmils, height=hmils)
            if mx.is_identity():
                dlg.Destroy()
                dlg = wx.MessageDialog(
                    None,
                    _("The entered command does nothing."),
                    _("Non-Useful Matrix."),
                    wx.OK | wx.ICON_WARNING,
                )
                result = dlg.ShowModal()
                dlg.Destroy()
            else:
                for element in root_context.elements.elems():
                    try:
                        element *= mx
                        element.node.modified()
                    except AttributeError:
                        pass

    def open_fill_dialog(self):
        context = self.context
        elements = context.elements
        first_selected = elements.first_element(emphasized=True)
        if first_selected is None:
            return
        data = wx.ColourData()
        if first_selected.fill is not None and first_selected.fill != "none":
            data.SetColour(wx.Colour(swizzlecolor(first_selected.fill)))
        dlg = wx.ColourDialog(self, data)
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            rgb = color.GetRGB()
            color = swizzlecolor(rgb)
            color = Color(color, 1.0)
            for elem in elements.elems(emphasized=True):
                elem.fill = color
                elem.node.altered()

    def open_stroke_dialog(self):
        context = self.context
        elements = context.elements
        first_selected = elements.first_element(emphasized=True)
        if first_selected is None:
            return
        data = wx.ColourData()
        if first_selected.stroke is not None and first_selected.stroke != "none":
            data.SetColour(wx.Colour(swizzlecolor(first_selected.stroke)))
        dlg = wx.ColourDialog(self, data)
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            rgb = color.GetRGB()
            color = swizzlecolor(rgb)
            color = Color(color, 1.0)
            for elem in elements.elems(emphasized=True):
                elem.stroke = color
                elem.node.altered()

    def open_flip_dialog(self):
        dlg = wx.TextEntryDialog(
            self,
            _(
                "Material must be jigged at 0,0 either home or home offset.\nHow wide is your material (give units: in, mm, cm, px, etc)?"
            ),
            _("Double Side Flip"),
            "",
        )
        dlg.SetValue("")
        if dlg.ShowModal() == wx.ID_OK:
            p = self.context
            root_context = p.get_context("/")
            bed_dim = root_context
            context = p
            wmils = bed_dim.bed_width * MILS_IN_MM
            hmils = bed_dim.bed_height * MILS_IN_MM
            length = Length(dlg.GetValue()).value(ppi=1000.0, relative_length=wmils)
            mx = Matrix()
            mx.post_scale(-1.0, 1, length / 2.0, 0)
            for element in root_context.elements.elems(emphasized=True):
                try:
                    element *= mx
                    element.node.modified()
                except AttributeError:
                    pass
        dlg.Destroy()

    def open_path_dialog(self):
        dlg = wx.TextEntryDialog(self, _("Enter SVG Path Data"), _("Path Entry"), "")
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            context = self.context
            path = Path(dlg.GetValue())
            path.stroke = "blue"
            p = abs(path)
            context.elements.add_elem(p)
            self.context.classify([p])
        dlg.Destroy()

    def egv_import(self):
        pathname = None
        files = "*.egv"
        with wx.FileDialog(
            self,
            _("Import EGV"),
            wildcard=files,
            style=wx.FD_OPEN | wx.FD_FILE_MUST_EXIST,
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
        if pathname is None:
            return
        with wx.BusyInfo(_("Loading File...")):
            self.context.console("egv_import %s\n" % pathname)
            return

    def egv_export(self):
        pathname = None
        files = "*.egv"
        with wx.FileDialog(
            self, _("Export EGV"), wildcard=files, style=wx.FD_SAVE
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
        if pathname is None:
            return
        with wx.BusyInfo(_("Saving File...")):
            self.context.console("egv_export %s\n" % pathname)
            return

    def apply_rotary_scale(self):
        r = self.context.get_context("rotary/1")
        sx = r.scale_x
        sy = r.scale_y
        a = self.context.active

        mx = Matrix(
            "scale(%f, %f, %f, %f)" % (r.scale_x, r.scale_y, a.current_x, a.current_y)
        )
        for element in self.context.get_context("/").elements.elems():
            try:
                element *= mx
                element.node.modified()
            except AttributeError:
                pass

    def toggle_rotary_view(self):
        if self._rotary_view:
            self.widget_scene.rotary_stretch()
        else:
            self.widget_scene.rotary_unstretch()
        self._rotary_view = not self._rotary_view

    def run_jog_transition_finish_test(self):
        return self.run_jog_transition_test(COMMAND_JOG_FINISH)

    def run_jog_transition_switch_test(self):
        return self.run_jog_transition_test(COMMAND_JOG_SWITCH)

    def run_jog_transition_test(self, command=COMMAND_JOG):
        """ "
        The Jog Transition Test is intended to test the jogging
        """

        def jog_transition_test():
            yield COMMAND_SET_ABSOLUTE
            yield COMMAND_MODE_RAPID
            yield COMMAND_HOME
            yield COMMAND_LASER_OFF
            yield COMMAND_WAIT_FINISH
            yield COMMAND_MOVE, 3000, 3000
            yield COMMAND_WAIT_FINISH
            yield COMMAND_LASER_ON
            yield COMMAND_WAIT, 0.05
            yield COMMAND_LASER_OFF
            yield COMMAND_WAIT_FINISH

            yield COMMAND_SET_SPEED, 10.0

            def pos(i):
                if i < 3:
                    x = 200
                elif i < 6:
                    x = -200
                else:
                    x = 0
                if i % 3 == 0:
                    y = 200
                elif i % 3 == 1:
                    y = -200
                else:
                    y = 0
                return x, y

            for q in range(8):
                top = q & 1
                left = q & 2
                x_val = q & 3
                yield COMMAND_SET_DIRECTION, top, left, x_val, not x_val
                yield COMMAND_MODE_PROGRAM
                for j in range(9):
                    jx, jy = pos(j)
                    for k in range(9):
                        kx, ky = pos(k)
                        yield COMMAND_MOVE, 3000, 3000
                        yield COMMAND_MOVE, 3000 + jx, 3000 + jy
                        yield command, 3000 + jx + kx, 3000 + jy + ky
                yield COMMAND_MOVE, 3000, 3000
                yield COMMAND_MODE_RAPID
                yield COMMAND_WAIT_FINISH
                yield COMMAND_LASER_ON
                yield COMMAND_WAIT, 0.05
                yield COMMAND_LASER_OFF
                yield COMMAND_WAIT_FINISH

        self.context.spooler.job(jog_transition_test)

    def run_home_and_dot_test(self):
        def home_dot_test():
            for i in range(25):
                yield COMMAND_SET_ABSOLUTE
                yield COMMAND_MODE_RAPID
                yield COMMAND_HOME
                yield COMMAND_LASER_OFF
                yield COMMAND_WAIT_FINISH
                yield COMMAND_MOVE, 3000, 3000
                yield COMMAND_WAIT_FINISH
                yield COMMAND_LASER_ON
                yield COMMAND_WAIT, 0.05
                yield COMMAND_LASER_OFF
                yield COMMAND_WAIT_FINISH
            yield COMMAND_HOME
            yield COMMAND_WAIT_FINISH

        self.context.spooler.job(home_dot_test)


NODE_ROOT = 0
NODE_OPERATION_BRANCH = 10
NODE_OPERATION = 11
NODE_OPERATION_ELEMENT = 12
NODE_ELEMENTS_BRANCH = 20
NODE_ELEMENT = 21
NODE_FILES_BRANCH = 30
NODE_FILE_FILE = 31
NODE_FILE_ELEMENT = 32


class ShadowTree:
    """
    The shadowTree creates a wx.Tree structure from the elements.tree structure. It listens to updates to the elements
    tree and updates the GUI version accordingly. This tree does not permit alterations to it, rather it sends any
    requested alterations to the elements.tree or the elements.elements or elements.operations and when those are
    reflected in the tree, the shadow tree is updated accordingly.
    """

    def __init__(self, context, gui, root):
        self.context = context
        self.element_root = root
        self.gui = gui
        self.wxtree = gui.wxtree
        self.renderer = gui.renderer
        self.dragging_nodes = None
        self.tree_images = None
        self.object = "Project"
        self.name = "Project"
        self.context = context
        self.elements = context.elements
        self.elements.listen(self)
        self.do_not_select = False

    def node_removed(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.wxtree.Delete(node.item)
        for i in self.wxtree.GetSelections():
            self.wxtree.SelectItem(i, False)

    def node_added(self, node, **kwargs):
        self.node_register(node, **kwargs)

    def node_changed(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.update_name(node)

    def emphasized(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.update_name(node)
        self.set_enhancements(node)
        self.context.signal("emphasized", node)

    def targeted(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.update_name(node)
        self.set_enhancements(node)
        self.context.signal("targeted", node)

    def highlighted(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.update_name(node)
        self.set_enhancements(node)
        self.context.signal("highlighted", node)

    def modified(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.update_name(node)
        try:
            c = node.color
            self.set_color(node, c)
        except AttributeError:
            pass

    def altered(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.update_name(node)
        try:
            c = node.color
            self.set_color(node, c)
        except AttributeError:
            pass
        self.set_icon(node)

    def expand(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.wxtree.ExpandAllChildren(item)

    def collapse(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.wxtree.CollapseAllChildren(item)

    def reorder(self, node):
        self.rebuild_tree()

    def update(self, node):
        item = node.item
        if not item.IsOk():
            raise ValueError("Bad Item")
        self.set_icon(node)

    def on_element_update(self, *args):
        element = args[0]
        if hasattr(element, "node"):
            self.update_name(element.node, True)
        else:
            self.update_name(element, True)

    def refresh_tree(self, node=None):
        """Any tree elements currently displaying wrong data as per elements should be updated to display
        the proper values and contexts and icons."""
        if node is None:
            node = self.element_root.item
        if node is None:
            return
        tree = self.wxtree

        child, cookie = tree.GetFirstChild(node)
        while child.IsOk():
            child_node = self.wxtree.GetItemData(child)
            self.set_enhancements(child_node)
            self.refresh_tree(child)
            child, cookie = tree.GetNextChild(node, cookie)

    def rebuild_tree(self):
        self.dragging_nodes = None
        self.wxtree.DeleteAllItems()

        self.tree_images = wx.ImageList()
        self.tree_images.Create(width=20, height=20)

        self.wxtree.SetImageList(self.tree_images)
        self.element_root.item = self.wxtree.AddRoot(self.name)

        self.wxtree.SetItemData(self.element_root.item, self.element_root)

        self.set_icon(
            self.element_root, icon_meerk40t.GetBitmap(False, resize=(20, 20))
        )
        self.build_tree(self.element_root)

        node_operations = self.element_root.get(type="branch ops")
        self.set_icon(node_operations, icons8_laser_beam_20.GetBitmap(True))

        for n in node_operations.children:
            self.set_icon(n)

        node_elements = self.element_root.get(type="branch elems")
        self.set_icon(node_elements, icons8_vector_20.GetBitmap(True))

        self.wxtree.ExpandAll()

    def build_tree(self, parent_node):
        for node in parent_node._children:
            self.node_register(node)
            self.build_tree(node)

    def node_register(self, node, pos=None, **kwargs):
        parent = node.parent
        parent_item = parent.item
        tree = self.wxtree
        if pos is None:
            node.item = tree.AppendItem(parent_item, self.name)
        else:
            node.item = tree.InsertItem(parent_item, pos, self.name)
        tree.SetItemData(node.item, node)
        self.update_name(node)
        try:
            stroke = node.object.values[SVG_ATTR_STROKE]
            color = wx.Colour(swizzlecolor(Color(stroke).value))
            tree.SetItemTextColour(node.item, color)
        except AttributeError:
            pass
        except KeyError:
            pass
        except TypeError:
            pass
        self.set_icon(node)
        self.context.signal("refresh_tree")

    def set_enhancements(self, node):
        tree = self.wxtree
        node_item = node.item
        tree.SetItemBackgroundColour(node_item, None)
        try:
            if node.highlighted:
                tree.SetItemBackgroundColour(node_item, wx.YELLOW)
            elif node.emphasized:
                tree.SetItemBackgroundColour(node_item, wx.CYAN)
            elif node.targeted:
                tree.SetItemBackgroundColour(node_item, wx.Colour(0xFF00FF))
        except AttributeError:
            pass

    def set_color(self, node, color=None):
        item = node.item
        tree = self.wxtree
        if color is None:
            tree.SetItemTextColour(item, None)
        else:
            tree.SetItemTextColour(item, wx.Colour(swizzlecolor(color)))

    def set_icon(self, node, icon=None):
        root = self
        drawmode = self.context.draw_mode
        if drawmode & DRAW_MODE_ICONS != 0:
            return
        item = node.item
        data_object = node.object
        tree = root.wxtree
        if icon is None:
            if isinstance(data_object, SVGImage):
                image = self.renderer.make_thumbnail(
                    data_object.image, width=20, height=20
                )
                image_id = self.tree_images.Add(bitmap=image)
                tree.SetItemImage(item, image=image_id)
            elif isinstance(data_object, (Path, SVGText)):
                image = self.renderer.make_raster(
                    node, data_object.bbox(), width=20, height=20, bitmap=True
                )
                if image is not None:
                    image_id = self.tree_images.Add(bitmap=image)
                    tree.SetItemImage(item, image=image_id)
                    self.context.signal("refresh_tree")
            elif isinstance(node, LaserOperation):
                try:
                    op = node.operation
                except AttributeError:
                    op = None
                if op in ("Raster", "Image"):
                    self.set_icon(node, icons8_direction_20.GetBitmap(True))
                else:
                    self.set_icon(node, icons8_laser_beam_20.GetBitmap(True))
                try:
                    c = node.color
                    self.set_color(node, c)
                except AttributeError:
                    pass
            elif node.type == "file":
                self.set_icon(node, icons8_file_20.GetBitmap(True))
            elif node.type == "group":
                self.set_icon(node, icons8_group_objects_20.GetBitmap(True))
        else:
            image_id = self.tree_images.Add(bitmap=icon)
            tree.SetItemImage(item, image=image_id)

    def update_name(self, node, force=False):
        try:
            node.name = node.object.id
        except AttributeError:
            pass
        if node.name is None or force:
            if node.object is not None:
                node.name = str(node.object)
            else:
                node.name = str(node)
        if not hasattr(node, "item"):
            # Unregistered node updating name.
            self.rebuild_tree()
            return

        self.wxtree.SetItemText(node.item, node.name)
        try:
            stroke = node.object.stroke
            color = wx.Colour(swizzlecolor(Color(stroke)))
            self.wxtree.SetItemTextColour(node.item, color)
        except AttributeError:
            pass
        try:
            color = node.color
            c = wx.Colour(swizzlecolor(Color(color)))
            self.wxtree.SetItemTextColour(node.item, c)
        except AttributeError:
            pass

    def move_node(self, node, new_parent, pos=None):
        tree = self.root.shadow_tree
        item = self.item
        image = tree.GetItemImage(item)
        data = tree.GetItemData(item)
        color = tree.GetItemTextColour(item)
        tree.Delete(item)
        if pos is None:
            self.item = tree.AppendItem(new_parent.item, self.name)
        else:
            self.item = tree.InsertItem(new_parent.item, pos, self.name)
        item = self.item
        tree.SetItemImage(item, image)
        tree.SetItemData(item, data)
        tree.SetItemTextColour(item, color)

    def bbox(self, node):
        return CutPlanner.bounding_box(self.object)

    def on_drag_begin_handler(self, event):
        """
        Drag handler begin for the tree.

        :param event:
        :return:
        """
        self.dragging_nodes = None

        pt = event.GetPoint()
        drag_item, _ = self.wxtree.HitTest(pt)

        if drag_item is None or drag_item.ID is None or not drag_item.IsOk():
            event.Skip()
            return

        self.dragging_nodes = [
            self.wxtree.GetItemData(item) for item in self.wxtree.GetSelections()
        ]
        if not len(self.dragging_nodes):
            event.Skip()
            return

        t = self.dragging_nodes[0].type
        for n in self.dragging_nodes:
            if t != n.type:
                event.Skip()
                return
            if not n.is_movable():
                event.Skip()
                return
        event.Allow()

    def on_drag_end_handler(self, event):
        """
        Drag end handler for the tree

        :param event:
        :return:
        """
        if self.dragging_nodes is None:
            event.Skip()
            return

        drop_item = event.GetItem()
        if drop_item is None or drop_item.ID is None:
            event.Skip()
            return
        drop_node = self.wxtree.GetItemData(drop_item)
        if drop_node is None:
            event.Skip()
            return

        skip = True
        for drag_node in self.dragging_nodes:
            if drop_node is drag_node:
                continue
            if drop_node.drop(drag_node):
                skip = False
        if skip:
            event.Skip()
        else:
            event.Allow()
        self.dragging_nodes = None

    def on_item_right_click(self, event):
        """
        Right click of element in tree.

        :param event:
        :return:
        """
        item = event.GetItem()
        if item is None:
            return
        node = self.wxtree.GetItemData(item)

        self.create_menu(self.gui, node)

    def on_item_activated(self, event):
        """
        Tree item is double-clicked. Launches PropertyWindow associated with that object.

        :param event:
        :return:
        """
        item = event.GetItem()
        node = self.wxtree.GetItemData(item)
        self.activated_node(node)

    def activate_selected_node(self):
        first_element = self.elements.first_element(emphasized=True)
        if hasattr(first_element, "node"):
            self.activated_node(first_element.node)

    def activated_node(self, node):
        if isinstance(node, LaserOperation):
            self.context.open("window/OperationProperty", self.gui, node=node)
            return
        if node is None:
            return
        obj = node.object
        if obj is None:
            return
        elif isinstance(obj, Path):
            self.context.open("window/PathProperty", self.gui, node=node)
        elif isinstance(obj, SVGText):
            self.context.open("window/TextProperty", self.gui, node=node)
        elif isinstance(obj, SVGImage):
            self.context.open("window/ImageProperty", self.gui, node=node)
        elif isinstance(obj, SVGElement):
            self.context.open("window/PathProperty", self.gui, node=node)

    def on_item_selection_changed(self, event):
        """
        Tree menu item is changed. Modify the selection.

        :param event:
        :return:
        """
        if self.do_not_select:
            return
        selected = [
            self.wxtree.GetItemData(item) for item in self.wxtree.GetSelections()
        ]
        for i in range(len(selected)):
            node = selected[i]
            if node.type == "opnode":
                selected[i] = node.object.node
            elif node.type == "op":
                for n in node.flat(types=("opnode",), cascade=False):
                    try:
                        selected.append(n.object.node)
                    except Exception:
                        pass

        self.elements.set_emphasis(selected)
        self.refresh_tree()
        self.gui.request_refresh()
        event.Allow()

    def select_in_tree_by_emphasis(self):
        """
        :return:
        """
        self.do_not_select = True
        for e in self.elements.elems_nodes(emphasized=True):
            self.wxtree.SelectItem(e.item, True)
        self.do_not_select = False

    def contains(self, box, x, y=None):
        if y is None:
            y = x[1]
            x = x[0]
        return box[0] <= x <= box[2] and box[1] <= y <= box[3]

    def create_menu(self, gui, node):
        """
        Create menu items. This is used for both the scene and the tree to create menu items.

        :param gui: Gui used to create menu items.
        :param node: The Node clicked on for the generated menu.
        :return:
        """
        if node is None:
            return
        if hasattr(node, "node"):
            node = node.node
        menu = wx.Menu()

        submenus = {}

        def menu_functions(f, node):
            func_dict = dict(f.func_dict)

            def specific(event):
                f(node, **func_dict)

            return specific

        for func in self.elements.tree_operations_for_node(node):
            submenu_name = func.submenu
            submenu = None
            if submenu_name in submenus:
                submenu = submenus[submenu_name]
            elif submenu_name is not None:
                submenu = wx.Menu()
                menu.AppendSubMenu(submenu, submenu_name)
                submenus[submenu_name] = submenu

            menu_context = submenu if submenu is not None else menu
            if func.radio_state is not None:
                item = menu_context.Append(wx.ID_ANY, func.real_name, "", wx.ITEM_RADIO)
                gui.Bind(
                    wx.EVT_MENU,
                    menu_functions(func, node),
                    item,
                )
                item.Check(func.radio_state)
            else:
                gui.Bind(
                    wx.EVT_MENU,
                    menu_functions(func, node),
                    menu_context.Append(wx.ID_ANY, func.real_name, "", wx.ITEM_NORMAL),
                )
        if menu.MenuItemCount != 0:
            gui.PopupMenu(menu)
            menu.Destroy()


def get_key_name(event):
    keyvalue = ""
    if event.ControlDown():
        keyvalue += "control+"
    if event.AltDown():
        keyvalue += "alt+"
    if event.ShiftDown():
        keyvalue += "shift+"
    if event.MetaDown():
        keyvalue += "meta+"
    key = event.GetKeyCode()
    if key == wx.WXK_CONTROL:
        return
    if key == wx.WXK_ALT:
        return
    if key == wx.WXK_SHIFT:
        return
    if key == wx.WXK_F1:
        keyvalue += "f1"
    elif key == wx.WXK_F2:
        keyvalue += "f2"
    elif key == wx.WXK_F3:
        keyvalue += "f3"
    elif key == wx.WXK_F4:
        keyvalue += "f4"
    elif key == wx.WXK_F5:
        keyvalue += "f5"
    elif key == wx.WXK_F6:
        keyvalue += "f6"
    elif key == wx.WXK_F7:
        keyvalue += "f7"
    elif key == wx.WXK_F8:
        keyvalue += "f8"
    elif key == wx.WXK_F9:
        keyvalue += "f9"
    elif key == wx.WXK_F10:
        keyvalue += "f10"
    elif key == wx.WXK_F11:
        keyvalue += "f11"
    elif key == wx.WXK_F12:
        keyvalue += "f12"
    elif key == wx.WXK_F13:
        keyvalue += "f13"
    elif key == wx.WXK_F14:
        keyvalue += "f14"
    elif key == wx.WXK_F15:
        keyvalue += "f15"
    elif key == wx.WXK_F16:
        keyvalue += "f16"
    elif key == wx.WXK_ADD:
        keyvalue += "+"
    elif key == wx.WXK_END:
        keyvalue += "end"
    elif key == wx.WXK_NUMPAD0:
        keyvalue += "numpad0"
    elif key == wx.WXK_NUMPAD1:
        keyvalue += "numpad1"
    elif key == wx.WXK_NUMPAD2:
        keyvalue += "numpad2"
    elif key == wx.WXK_NUMPAD3:
        keyvalue += "numpad3"
    elif key == wx.WXK_NUMPAD4:
        keyvalue += "numpad4"
    elif key == wx.WXK_NUMPAD5:
        keyvalue += "numpad5"
    elif key == wx.WXK_NUMPAD6:
        keyvalue += "numpad6"
    elif key == wx.WXK_NUMPAD7:
        keyvalue += "numpad7"
    elif key == wx.WXK_NUMPAD8:
        keyvalue += "numpad8"
    elif key == wx.WXK_NUMPAD9:
        keyvalue += "numpad9"
    elif key == wx.WXK_NUMPAD_ADD:
        keyvalue += "numpad_add"
    elif key == wx.WXK_NUMPAD_SUBTRACT:
        keyvalue += "numpad_subtract"
    elif key == wx.WXK_NUMPAD_MULTIPLY:
        keyvalue += "numpad_multiply"
    elif key == wx.WXK_NUMPAD_DIVIDE:
        keyvalue += "numpad_divide"
    elif key == wx.WXK_NUMPAD_DECIMAL:
        keyvalue += "numpad."
    elif key == wx.WXK_NUMPAD_ENTER:
        keyvalue += "numpad_enter"
    elif key == wx.WXK_NUMPAD_RIGHT:
        keyvalue += "numpad_right"
    elif key == wx.WXK_NUMPAD_LEFT:
        keyvalue += "numpad_left"
    elif key == wx.WXK_NUMPAD_UP:
        keyvalue += "numpad_up"
    elif key == wx.WXK_NUMPAD_DOWN:
        keyvalue += "numpad_down"
    elif key == wx.WXK_NUMPAD_DELETE:
        keyvalue += "numpad_delete"
    elif key == wx.WXK_NUMPAD_INSERT:
        keyvalue += "numpad_insert"
    elif key == wx.WXK_NUMPAD_PAGEUP:
        keyvalue += "numpad_pgup"
    elif key == wx.WXK_NUMPAD_PAGEDOWN:
        keyvalue += "numpad_pgdn"
    elif key == wx.WXK_NUMLOCK:
        keyvalue += "numlock"
    elif key == wx.WXK_SCROLL:
        keyvalue += "scroll"
    elif key == wx.WXK_HOME:
        keyvalue += "home"
    elif key == wx.WXK_DOWN:
        keyvalue += "down"
    elif key == wx.WXK_UP:
        keyvalue += "up"
    elif key == wx.WXK_RIGHT:
        keyvalue += "right"
    elif key == wx.WXK_LEFT:
        keyvalue += "left"
    elif key == wx.WXK_ESCAPE:
        keyvalue += "escape"
    elif key == wx.WXK_BACK:
        keyvalue += "back"
    elif key == wx.WXK_PAUSE:
        keyvalue += "pause"
    elif key == wx.WXK_PAGEDOWN:
        keyvalue += "pagedown"
    elif key == wx.WXK_PAGEUP:
        keyvalue += "pageup"
    elif key == wx.WXK_PRINT:
        keyvalue += "print"
    elif key == wx.WXK_RETURN:
        keyvalue += "return"
    elif key == wx.WXK_SPACE:
        keyvalue += "space"
    elif key == wx.WXK_TAB:
        keyvalue += "tab"
    elif key == wx.WXK_DELETE:
        keyvalue += "delete"
    elif key == wx.WXK_INSERT:
        keyvalue += "insert"
    else:
        keyvalue += chr(key)
    return keyvalue.lower()


class wxMeerK40t(wx.App, Module):
    """
    wxMeerK40t is the wx.App main class and a qualified Module for the MeerK40t kernel.
    Running MeerK40t without the wxMeerK40t gui is both possible and reasonable. This should not change the way the
    underlying code runs. It should just be a series of frames held together with the kernel.
    """

    def __init__(self, context, path):
        wx.App.__init__(self, 0)
        import meerk40t.gui.icons as icons

        icons.DARKMODE = wx.SystemSettings().GetColour(wx.SYS_COLOUR_WINDOW)[0] < 127
        icons.icon_r = 230
        icons.icon_g = 230
        icons.icon_b = 230
        Module.__init__(self, context, path)
        self.locale = None
        self.Bind(wx.EVT_CLOSE, self.on_app_close)
        self.Bind(wx.EVT_QUERY_END_SESSION, self.on_app_close)  # MAC DOCK QUIT.
        self.Bind(wx.EVT_END_SESSION, self.on_app_close)
        self.Bind(wx.EVT_END_PROCESS, self.on_app_close)
        # This catches events when the app is asked to activate by some other process
        self.Bind(wx.EVT_ACTIVATE_APP, self.OnActivate)
        try:
            self.InitLocale()
        except AttributeError:
            pass  # 4.1

    def on_app_close(self, event):
        try:
            if self.context is not None:
                self.context.console("quit\n")
        except AttributeError:
            pass

    def OnInit(self):
        return True

    def BringWindowToFront(self):
        try:  # it's possible for this event to come when the frame is closed
            self.GetTopWindow().Raise()
        except Exception:
            pass

    def OnActivate(self, event):
        # if this is an activate event, rather than something else, like iconize.
        if event.GetActive():
            self.BringWindowToFront()
        event.Skip()

    def MacReopenApp(self):
        """Called when the doc icon is clicked, and ???"""
        self.BringWindowToFront()

    def MacNewFile(self):
        try:
            if self.context is not None:
                self.context.elements.clear_all()
        except AttributeError:
            pass

    def MacPrintFile(self, file_path):
        pass

    def MacOpenFile(self, filename):
        try:
            if self.context is not None:
                self.context.load(os.path.realpath(filename))
        except AttributeError:
            pass

    def MacOpenFiles(self, filenames):
        try:
            if self.context is not None:
                for filename in filenames:
                    self.context.load(os.path.realpath(filename))
        except AttributeError:
            pass

    @staticmethod
    def sub_register(kernel):
        kernel.register("window/MeerK40t", MeerK40t)
        kernel.register("module/Scene", Scene)
        kernel.register("window/PathProperty", PathProperty)
        kernel.register("window/TextProperty", TextProperty)
        kernel.register("window/ImageProperty", ImageProperty)
        kernel.register("window/OperationProperty", OperationProperty)
        kernel.register("window/Controller", Controller)
        kernel.register("window/Preferences", Preferences)
        kernel.register("window/CameraInterface", CameraInterface)
        kernel.register("window/Terminal", Terminal)
        kernel.register("window/Settings", Settings)
        kernel.register("window/Rotary", RotarySettings)
        kernel.register("window/About", About)
        kernel.register("window/DeviceManager", DeviceManager)
        kernel.register("window/Keymap", Keymap)
        kernel.register("window/UsbConnect", UsbConnect)
        kernel.register("window/Navigation", Navigation)
        kernel.register("window/Notes", Notes)
        kernel.register("window/JobSpooler", JobSpooler)
        kernel.register("window/JobPreview", JobPreview)
        kernel.register("window/BufferView", BufferView)
        kernel.register("window/RasterWizard", RasterWizard)

        context = kernel.get_context("/")

        @kernel.console_option(
            "path",
            "p",
            type=context.get_context,
            default=context.active,
            help="Context Path at which to open the window",
        )
        @kernel.console_argument("subcommand", type=str, help="open <window>")
        @kernel.console_argument(
            "window", type=str, help="window to apply subcommand to"
        )
        @kernel.console_command("window", help="wxMeerK40 window information")
        def window(
            channel, _, subcommand=None, window=None, path=None, args=(), **kwargs
        ):
            """
            Opens a MeerK40t window or provides information. This command is restricted to use with the wxMeerK40t gui.
            This also allows use of a -p flag that sets the context path for this window to operate at. This should
            often be restricted to where the windows are typically opened since their function and settings usually
            depend on the context used. The default root path is "/". Eg. "window open -p / Settings"
            """
            context = kernel.get_context("/")
            if path is None:
                path = context.active
            if subcommand is None:
                channel(_("----------"))
                channel(_("Loaded Windows in Context %s:") % str(context._path))
                for i, name in enumerate(context.opened):
                    if not name.startswith("window"):
                        continue
                    module = context.opened[name]
                    channel(_("%d: %s as type of %s") % (i + 1, name, type(module)))

                channel(_("----------"))
                channel(_("Loaded Windows in Device %s:") % str(path._path))
                for i, name in enumerate(path.opened):
                    if not name.startswith("window"):
                        continue
                    module = path.opened[name]
                    channel(_("%d: %s as type of %s") % (i + 1, name, type(module)))
                channel(_("----------"))
                return
            if window is None or subcommand == "list":
                channel(_("----------"))
                channel(_("Windows Registered:"))
                for i, name in enumerate(context.match("window")):
                    channel("%d: %s" % (i + 1, name))
                return
            elif subcommand == "open":
                try:
                    parent = context.gui
                except AttributeError:
                    parent = None
                try:
                    path.open("window/%s" % window, parent, *args)
                    channel(_("Window Opened."))
                except (KeyError, ValueError):
                    channel(_("No such window as %s" % window))
                except IndexError:
                    raise SyntaxError
            elif subcommand == "close":
                try:
                    parent = context.gui
                except AttributeError:
                    parent = None
                try:
                    path.close("window/%s" % window, parent, *args)
                    channel(_("Window closed."))
                except (KeyError, ValueError):
                    channel(_("No such window as %s" % window))
                except IndexError:
                    raise SyntaxError
            elif subcommand == "reset":
                if kernel._config is not None:
                    for context in list(kernel.contexts):
                        if context.startswith("window"):
                            del kernel.contexts[context]
                    kernel._config.DeleteGroup("window")
            else:
                raise SyntaxError

        @kernel.console_command("refresh", help="wxMeerK40 refresh")
        def refresh(command, channel, _, args=tuple(), **kwargs):
            context.signal("refresh_scene")
            context.signal("rebuild_tree")
            channel(_("Refreshed."))
            return

    def run_later(self, command, *args):
        if wx.IsMainThread():
            command(*args)
        else:
            wx.CallAfter(command, *args)

    def initialize(self, *args, **kwargs):
        context = self.context
        kernel = context._kernel

        try:  # pyinstaller internal location
            _resource_path = os.path.join(sys._MEIPASS, "locale")
            wx.Locale.AddCatalogLookupPathPrefix(_resource_path)
        except Exception:
            pass

        try:  # Mac py2app resource
            _resource_path = os.path.join(os.environ["RESOURCEPATH"], "locale")
            wx.Locale.AddCatalogLookupPathPrefix(_resource_path)
        except Exception:
            pass

        wx.Locale.AddCatalogLookupPathPrefix(
            "locale"
        )  # Default Locale, prepended. Check this first.

        kernel.run_later = self.run_later
        kernel.translation = wx.GetTranslation
        kernel.set_config(wx.Config(kernel.profile))
        context.app = self  # Registers self as kernel.app

        context.setting(int, "language", None)
        context.register("control/Delete Settings", self.clear_control)
        language = context.language
        if language is not None and language != 0:
            self.update_language(language)

    def clear_control(self):
        kernel = self.context._kernel
        if kernel._config is not None:
            kernel._config.DeleteAll()
            kernel._config = None
            kernel.shutdown()

    def update_language(self, lang):
        """
        Update language to the requested language.
        """
        context = self.context
        try:
            language_code, language_name, language_index = supported_languages[lang]
        except (IndexError, ValueError):
            return
        context.language = lang

        if self.locale:
            assert sys.getrefcount(self.locale) <= 2
            del self.locale
        self.locale = wx.Locale(language_index)
        if self.locale.IsOk():
            self.locale.AddCatalog("meerk40t")
        else:
            self.locale = None
        context.signal("language", (lang, language_code, language_name, language_index))


# end of class MeerK40tGui
def send_file_to_developers(filename):
    """
    Sends crash log to a server using rfc1341 7.2 The multipart Content-Type
    https://www.w3.org/Protocols/rfc1341/7_2_Multipart.html

    :param filename: filename to send. (must be text/plain)
    :return:
    """
    import socket

    with open(filename, "r") as f:
        data = f.read()
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        ipaddr = socket.gethostbyname("api.anonfiles.com")
        s.connect((ipaddr, 80))
        boundary = "----------------meerk40t-boundary"
        file_head = list()
        file_head.append("--" + boundary)
        file_head.append(
            'Content-Disposition: form-data; name="file"; filename="%s"' % filename
        )
        file_head.append("Content-Type: text/plain")
        file_head.append("")
        part = "\x0D\x0A".join(file_head)
        terminal = "--" + boundary + "--"
        payload = "\x0D\x0A".join((part, data, terminal, ""))
        http_req = list()
        http_req.append("POST /upload?token=630f908431136ef4 HTTP/1.1")
        http_req.append("Host: api.anonfiles.com")
        http_req.append("User-Agent: meerk40t/0.0.1")
        http_req.append("Accept: */*")
        http_req.append("Content-Length: %d" % (len(payload)))
        http_req.append("Content-Type: multipart/form-data; boundary=%s" % boundary)
        http_req.append("")
        header = "\x0D\x0A".join(http_req)
        request = "\x0D\x0A".join((header, payload))
        s.send(bytes(request, "utf-8"))
        response = s.recv(4096)
        response = response.decode("utf-8")
        print(response)
        s.close()
    if response is None or len(response) == 0:
        http_code = "No Response."
    else:
        http_code = response.split("\n")[0]

    if http_code.startswith("HTTP/1.1 200 OK"):
        http_code = response.split("\n")[0]
        dlg = wx.MessageDialog(
            None,
            _("We got your message. Thank you for helping\n\n") + str(http_code),
            _("Thanks"),
            wx.OK,
        )
        dlg.ShowModal()
        dlg.Destroy()
    else:
        MEERK40T_ISSUES = "https://github.com/meerk40t/meerk40t/issues"
        dlg = wx.MessageDialog(
            None,
            _(
                "We're sorry, that didn't work. Raise an issue on the github please.\n\n The log file will be in your working directory.\n"
                + MEERK40T_ISSUES
                + "\n\n"
                + str(http_code)
            ),
            _("Thanks"),
            wx.OK,
        )
        dlg.ShowModal()
        dlg.Destroy()


def handleGUIException(exc_type, exc_value, exc_traceback):
    """
    Handler for errors. Save error to a file, and create dialog.

    :param exc_type:
    :param exc_value:
    :param exc_traceback:
    :return:
    """
    error_log = "MeerK40t crash log. Version: %s on %s\n" % (
        "0.7.0 Beta-18",
        sys.platform,
    )
    error_log += "".join(traceback.format_exception(exc_type, exc_value, exc_traceback))
    print(error_log)
    try:
        import datetime

        filename = "MeerK40t-{date:%Y-%m-%d_%H_%M_%S}.txt".format(
            date=datetime.datetime.now()
        )
    except Exception:  # I already crashed once, if there's another here just ignore it.
        filename = "MeerK40t-Crash.txt"

    try:
        with open(filename, "w") as file:
            # Crash logs are not translated.
            file.write(error_log)
            print(file)
    except Exception:  # I already crashed once, if there's another here just ignore it.
        pass

    # Ask to send file.
    message = """
    Good news MeerK40t User! MeerK40t encountered an crash!

    You now have the ability to help meerk40t's development by sending us the log.

    Send the following data to the MeerK40t team?
    ------
    """
    message += error_log
    answer = wx.MessageBox(
        message, _("Crash Detected! Send Log?"), wx.YES_NO | wx.CANCEL, None
    )
    if answer == wx.YES:
        send_file_to_developers(filename)


def _update_ribbon_artprovider_for_dark_mode(provider: RB.RibbonArtProvider) -> None:
    def _set_ribbon_colour(
        provider: RB.RibbonArtProvider, art_id_list: list, colour: wx.Colour
    ) -> None:
        for id_ in art_id_list:
            provider.SetColour(id_, colour)

    TEXTCOLOUR = wx.SystemSettings().GetColour(wx.SYS_COLOUR_BTNTEXT)

    BTNFACE_HOVER = copy.copy(wx.SystemSettings().GetColour(wx.SYS_COLOUR_HIGHLIGHT))
    INACTIVE_BG = copy.copy(
        wx.SystemSettings().GetColour(wx.SYS_COLOUR_INACTIVECAPTION)
    )
    INACTIVE_TEXT = copy.copy(wx.SystemSettings().GetColour(wx.SYS_COLOUR_GRAYTEXT))
    BTNFACE = copy.copy(wx.SystemSettings().GetColour(wx.SYS_COLOUR_BTNFACE))
    BTNFACE_HOVER = BTNFACE_HOVER.ChangeLightness(50)

    texts = [
        RB.RIBBON_ART_BUTTON_BAR_LABEL_COLOUR,
        RB.RIBBON_ART_PANEL_LABEL_COLOUR,
    ]
    try:  # wx 4.0 compat, not supported on that
        texts.extend(
            [
                RB.RIBBON_ART_TAB_ACTIVE_LABEL_COLOUR,
                RB.RIBBON_ART_TAB_HOVER_LABEL_COLOUR,
            ]
        )
        _set_ribbon_colour(provider, [RB.RIBBON_ART_TAB_LABEL_COLOUR], INACTIVE_TEXT)
    except AttributeError:
        _set_ribbon_colour(provider, [RB.RIBBON_ART_TAB_LABEL_COLOUR], TEXTCOLOUR)
        pass
    _set_ribbon_colour(provider, texts, TEXTCOLOUR)

    backgrounds = [
        RB.RIBBON_ART_BUTTON_BAR_HOVER_BACKGROUND_TOP_COLOUR,
        RB.RIBBON_ART_BUTTON_BAR_HOVER_BACKGROUND_COLOUR,
        RB.RIBBON_ART_PANEL_ACTIVE_BACKGROUND_COLOUR,
        RB.RIBBON_ART_PANEL_ACTIVE_BACKGROUND_GRADIENT_COLOUR,
        RB.RIBBON_ART_PANEL_ACTIVE_BACKGROUND_TOP_COLOUR,
        RB.RIBBON_ART_PANEL_ACTIVE_BACKGROUND_TOP_GRADIENT_COLOUR,
        RB.RIBBON_ART_PANEL_LABEL_BACKGROUND_COLOUR,
        RB.RIBBON_ART_PANEL_LABEL_BACKGROUND_GRADIENT_COLOUR,
        RB.RIBBON_ART_PANEL_HOVER_LABEL_BACKGROUND_COLOUR,
        RB.RIBBON_ART_PANEL_HOVER_LABEL_BACKGROUND_GRADIENT_COLOUR,
        RB.RIBBON_ART_TAB_HOVER_BACKGROUND_COLOUR,
        RB.RIBBON_ART_TAB_ACTIVE_BACKGROUND_TOP_COLOUR,
        RB.RIBBON_ART_TAB_ACTIVE_BACKGROUND_COLOUR,
        RB.RIBBON_ART_PAGE_BACKGROUND_TOP_COLOUR,
        RB.RIBBON_ART_PAGE_BACKGROUND_TOP_GRADIENT_COLOUR,
        RB.RIBBON_ART_PAGE_HOVER_BACKGROUND_COLOUR,
        RB.RIBBON_ART_PAGE_HOVER_BACKGROUND_GRADIENT_COLOUR,
        RB.RIBBON_ART_TAB_CTRL_BACKGROUND_COLOUR,
        RB.RIBBON_ART_TAB_CTRL_BACKGROUND_GRADIENT_COLOUR,
    ]
    _set_ribbon_colour(provider, backgrounds, BTNFACE)
    _set_ribbon_colour(
        provider,
        [
            RB.RIBBON_ART_TAB_HOVER_BACKGROUND_COLOUR,
            RB.RIBBON_ART_TAB_HOVER_BACKGROUND_GRADIENT_COLOUR,
            RB.RIBBON_ART_TAB_HOVER_BACKGROUND_TOP_COLOUR,
            RB.RIBBON_ART_TAB_HOVER_BACKGROUND_TOP_GRADIENT_COLOUR,
        ],
        INACTIVE_BG,
    )


sys.excepthook = handleGUIException
