# WARNING: Do not edit by hand, this file was generated by Crank:
#
#   https://github.com/gocardless/crank
#

import json

import requests
import responses
from nose.tools import (
  assert_equal,
  assert_is_instance,
  assert_is_none,
  assert_is_not_none,
  assert_not_equal,
  assert_raises
)

from gocardless_pro.errors import MalformedResponseError
from gocardless_pro import resources
from gocardless_pro import list_response

from .. import helpers
  

@responses.activate
def test_currency_exchange_rates_list():
    fixture = helpers.load_fixture('currency_exchange_rates')['list']
    helpers.stub_response(fixture)
    response = helpers.client.currency_exchange_rates.list(*fixture['url_params'])
    body = fixture['body']['currency_exchange_rates']

    assert_is_instance(response, list_response.ListResponse)
    assert_is_instance(response.records[0], resources.CurrencyExchangeRate)

    assert_equal(response.before, fixture['body']['meta']['cursors']['before'])
    assert_equal(response.after, fixture['body']['meta']['cursors']['after'])
    assert_is_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal([r.rate for r in response.records],
                 [b.get('rate') for b in body])
    assert_equal([r.source for r in response.records],
                 [b.get('source') for b in body])
    assert_equal([r.target for r in response.records],
                 [b.get('target') for b in body])
    assert_equal([r.time for r in response.records],
                 [b.get('time') for b in body])

@responses.activate
def test_timeout_currency_exchange_rates_list_retries():
    fixture = helpers.load_fixture('currency_exchange_rates')['list']
    with helpers.stub_timeout_then_response(fixture) as rsps:
      response = helpers.client.currency_exchange_rates.list(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['currency_exchange_rates']

    assert_is_instance(response, list_response.ListResponse)
    assert_is_instance(response.records[0], resources.CurrencyExchangeRate)

    assert_equal(response.before, fixture['body']['meta']['cursors']['before'])
    assert_equal(response.after, fixture['body']['meta']['cursors']['after'])

def test_502_currency_exchange_rates_list_retries():
    fixture = helpers.load_fixture('currency_exchange_rates')['list']
    with helpers.stub_502_then_response(fixture) as rsps:
      response = helpers.client.currency_exchange_rates.list(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['currency_exchange_rates']

    assert_is_instance(response, list_response.ListResponse)
    assert_is_instance(response.records[0], resources.CurrencyExchangeRate)

    assert_equal(response.before, fixture['body']['meta']['cursors']['before'])
    assert_equal(response.after, fixture['body']['meta']['cursors']['after'])

@responses.activate
def test_currency_exchange_rates_all():
    fixture = helpers.load_fixture('currency_exchange_rates')['list']

    def callback(request):
        if 'after=123' in request.url:
          fixture['body']['meta']['cursors']['after'] = None
        else:
          fixture['body']['meta']['cursors']['after'] = '123'
        return [200, {}, json.dumps(fixture['body'])]

    url = 'http://example.com' + fixture['path_template']
    responses.add_callback(fixture['method'], url, callback)

    all_records = list(helpers.client.currency_exchange_rates.all())
    assert_equal(len(all_records), len(fixture['body']['currency_exchange_rates']) * 2)
    for record in all_records:
      assert_is_instance(record, resources.CurrencyExchangeRate)
    
  
