# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dtuhpc',
 'dtuhpc.cli',
 'dtuhpc.cli.commands',
 'dtuhpc.cli.commands.server',
 'dtuhpc.commands',
 'dtuhpc.jobwriter',
 'dtuhpc.jobwriter.commands',
 'dtuhpc.jobwriter.options']

package_data = \
{'': ['*'], 'dtuhpc': ['default_jobs/*']}

install_requires = \
['cryptography>=39.0.1,<40.0.0',
 'fabric>=2.7.0,<3.0.0',
 'gitpython>=3.1.30,<4.0.0',
 'pygithub>=1.57,<2.0',
 'python-semantic-release>=7.33.1,<8.0.0',
 'rich>=13.2.0,<14.0.0',
 'tomli>=2.0.1,<3.0.0']

entry_points = \
{'console_scripts': ['dtuhpc = dtuhpc.cli.cli:main']}

setup_kwargs = {
    'name': 'dtuhpc',
    'version': '2.0.2',
    'description': '',
    'long_description': '# DTU HPC\nDTU HPC is a collection of scripts and tools for running jobs on the DTU HPC cluster.\nIt should help you to get started with running jobs on the cluster, and to make your life easier.\n\n## Installation\nTo install just run:\n```bash\npip install dtuhpc\n```\n## Getting started\nTo get started you first need to run:\n```bash\ndtuhpc auth\n```\nIt will ask you for your username and password for DTU, and it will then\nask you for an encryption password. This password is used to encrypt your\nDTU password, so that it can be stored on your computer. You will need to\nremember this password, as it is used to decrypt your password when you\nrun commands.\n\nAfterwards, you should create a configuration file for your project. This\nshould be named `.dtuhpc.toml` and should be placed in the root of your project.\nYou can use the following template:\n```toml\n[ssh]\nuser = "<username>"\nhost = "<login-host>"\ndefault_cwd = "<default working directory>"\n\n[github]\naccess_token = "<github access token>"\n\n[project]\nname = "<project name>"\npath = "<path to project on cluster>"\ndefault_deploy_branch = "master"\n```\nThe `ssh` section is used to configure the ssh connection to the cluster.\nThe GitHub access token can be generated from the following [page](https://github.com/settings/tokens).\n\n### Setup project\nTo set up a project, you can run:\n```bash\ndtuhpc init [--poetry] [--custom-job=<path to job script>]\n```\nThis will dispatch a job to the cluster, which will clone your project, create a\nvirtual environment, and install the dependencies.\nYou can choose to use either poetry, pip, or a custom job script. How to define jobs\nwill be explained in the next section.\n\n### Writing jobs\nJobs are defined as toml files. It contains numerous options:\n```\nname = "<name of job>"\nqueue = "<queue name>"\nsingle_host = <true/false>\nwalltime = { hours = <hours>, minutes = <minutes> }\nstandard_output = "<path to standard output file>"\nerror_output = "<path to error output file>"\nmemory = <memory to allocate>\nmemory_kill_limit = <memory kill limit>\ncores = <number of cores to allocate>\nemail = "<email address>"\nnotification_start = <true/false>\nnotification_end = <true/false>\ncore_block_size = <core block size>\ncore_p_tile_size = <core p tile size>\nuse_gpu = { num_of_gpus = <number of gpus>, per_task = <true/false> }\n\ncommands = [\n    "<bash command 1>",\n    "<bash command 2>",\n    ...\n]\n```\n\nAn example of a script can be seen here:\n```toml\nqueue = "hpc"\nname = "init_${{ project_name }}"\nwalltime = { hours = 0, minutes = 15 }\nsingle_host = true\ncpu = 2\nmemory = 4\nstandard_output = "init_${{ project_name }}.out"\nerror_output = "init_${{ project_name }}.err"\n\ncommands = [\n    "git clone ${{ git_url }} ${{ project_path }}",\n    "module load python3/3.10.7",\n    "cd ${{ project_path }}",\n    "python3 -m venv ${{ project_path }}/venv",\n    "source ${{ project_path }}/venv/bin/activate",\n    "pip3 install \'poetry==1.3.2\'",\n    "poetry install",\n]\n```\nIn this script, we can see that we can use variables in the script. These variables\nare some default ones that are only available for the `init` job.\n\n### Deploying jobs\nTo deploy a job you just run the following command:\n```bash\ndtuhpc deploy <job_path>\n```\nIt will then ask you to pick from branches or PR\'s. It will then dispatch the job\nto the cluster.\n\n### Other commands\nSome other commands:\n\n#### Exec commands on cluster\nTo execute commands on the cluster, you can run:\n```bash\ndtuhpc exec \'<command to run>\'\n```\nIt will run in the default working directory, which is defined in the configuration file.\n\n#### SSH into cluster\nTo ssh into the cluster, you can run:\n```bash\ndtuhpc ssh\n```\nIt will then open an ssh connection to the cluster. From here you can run commands\nas you would normally.\n\n#### Predefined subcommands\nThere are also some predefined subcommands, which are just wrappers around the\ncluster commands. They are all prefixed by `dtuhpc c <command_name>`. To get the\nfull documentation for the commands, you can run:\n```bash\ndtuhpc c <command_name> --help\n```\n\n##### bkill\nKill a job on the cluster.\n```bash\ndtuhpc c bkill <job_id>\n```\n##### bqueues\nList all queues on the cluster.\n```bash\ndtuhpc c bqueues\n```\n##### bstat\nGet the status of a job on the cluster.\n```bash\ndtuhpc c bstat <optional job_id>\n```\n##### bsub\nSubmit a job to the cluster.\n```bash\ndtuhpc c bsub <path to job script>\n```\n##### nodestat\nGet the status of the nodes on the cluster.\n```bash\ndtuhpc c nodestat\n```\n##### showstart\nShow the start time of a job on the cluster.\n```bash\ndtuhpc c showstart <job_id>\n```\n',
    'author': 'Jonas Hoffmannn',
    'author_email': 's204071@student.dtu.dk',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
