import { Connections, ISubnet } from '@aws-cdk/aws-ec2';
import { Construct } from 'constructs';
import { FileSystemAttributes, FileSystemBase, FileSystemProps, IFileSystem } from './file-system';
import { LustreMaintenanceTime } from './maintenance-time';
/**
 * (experimental) The different kinds of file system deployments used by Lustre.
 *
 * @experimental
 */
export declare enum LustreDeploymentType {
    /**
     * (experimental) Original type for shorter term data processing.
     *
     * Data is not replicated and does not persist on server fail.
     *
     * @experimental
     */
    SCRATCH_1 = "SCRATCH_1",
    /**
     * (experimental) Newer type for shorter term data processing.
     *
     * Data is not replicated and does not persist on server fail.
     * Provides better support for spiky workloads.
     *
     * @experimental
     */
    SCRATCH_2 = "SCRATCH_2",
    /**
     * (experimental) Long term storage.
     *
     * Data is replicated and file servers are replaced if they fail.
     *
     * @experimental
     */
    PERSISTENT_1 = "PERSISTENT_1"
}
/**
 * (experimental) The configuration for the Amazon FSx for Lustre file system.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html
 * @experimental
 */
export interface LustreConfiguration {
    /**
     * (experimental) The type of backing file system deployment used by FSx.
     *
     * @experimental
     */
    readonly deploymentType: LustreDeploymentType;
    /**
     * (experimental) The path in Amazon S3 where the root of your Amazon FSx file system is exported.
     *
     * The path must use the same
     * Amazon S3 bucket as specified in ImportPath. If you only specify a bucket name, such as s3://import-bucket, you
     * get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is
     * overwritten on export. If you provide a custom prefix in the export path, such as
     * s3://import-bucket/[custom-optional-prefix], Amazon FSx exports the contents of your file system to that export
     * prefix in the Amazon S3 bucket.
     *
     * @default s3://import-bucket/FSxLustre[creation-timestamp]
     * @experimental
     */
    readonly exportPath?: string;
    /**
     * (experimental) For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
     *
     * Allowed values are between 1 and 512,000.
     *
     * @default 1024
     * @experimental
     */
    readonly importedFileChunkSizeMiB?: number;
    /**
     * (experimental) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system.
     *
     * Must be of the format "s3://{bucketName}/optional-prefix" and cannot
     * exceed 900 characters.
     *
     * @default - no bucket is imported
     * @experimental
     */
    readonly importPath?: string;
    /**
     * (experimental) Required for the PERSISTENT_1 deployment type, describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB.
     *
     * Valid values are 50, 100, 200.
     *
     * @default - no default, conditionally required for PERSISTENT_1 deployment type
     * @experimental
     */
    readonly perUnitStorageThroughput?: number;
    /**
     * (experimental) The preferred day and time to perform weekly maintenance.
     *
     * The first digit is the day of the week, starting at 0
     * for Sunday, then the following are hours and minutes in the UTC time zone, 24 hour clock. For example: '2:20:30'
     * is Tuesdays at 20:30.
     *
     * @default - no preference
     * @experimental
     */
    readonly weeklyMaintenanceStartTime?: LustreMaintenanceTime;
}
/**
 * (experimental) Properties specific to the Lustre version of the FSx file system.
 *
 * @experimental
 */
export interface LustreFileSystemProps extends FileSystemProps {
    /**
     * (experimental) Additional configuration for FSx specific to Lustre.
     *
     * @experimental
     */
    readonly lustreConfiguration: LustreConfiguration;
    /**
     * (experimental) The subnet that the file system will be accessible from.
     *
     * @experimental
     */
    readonly vpcSubnet: ISubnet;
}
/**
 * (experimental) The FSx for Lustre File System implementation of IFileSystem.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 * @experimental
 * @resource AWS::FSx::FileSystem
 */
export declare class LustreFileSystem extends FileSystemBase {
    /**
     * (experimental) Import an existing FSx for Lustre file system from the given properties.
     *
     * @experimental
     */
    static fromLustreFileSystemAttributes(scope: Construct, id: string, attrs: FileSystemAttributes): IFileSystem;
    /**
     * The default FSx file system type used by FSx for Lustre.
     */
    private static readonly DEFAULT_FILE_SYSTEM_TYPE;
    /**
     * The default ports the file system listens on. Actual port list is: [988, 1021, 1022, 1023]
     */
    private static readonly DEFAULT_PORT_RANGE;
    /**
     * Configures a Connections object with all the ports required by FSx for Lustre
     */
    private static configureConnections;
    /**
     * (experimental) The security groups/rules used to allow network connections to the file system.
     *
     * @experimental
     */
    readonly connections: Connections;
    /**
     * (experimental) The DNS name assigned to this file system.
     *
     * @experimental
     */
    readonly dnsName: string;
    /**
     * (experimental) The ID that AWS assigns to the file system.
     *
     * @experimental
     */
    readonly fileSystemId: string;
    /**
     * (experimental) The mount name of the file system, generated by FSx.
     *
     * @experimental
     * @attribute LustreMountName
     */
    readonly mountName: string;
    /**
     * The encapsulated L1 file system.
     */
    private readonly fileSystem;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LustreFileSystemProps);
    /**
     * Validates the props provided for a new FSx for Lustre file system.
     */
    private validateProps;
    /**
     * Validates the export path is in the correct format and matches the import path.
     */
    private validateExportPath;
    /**
     * Validates the importedFileChunkSize is in the correct range.
     */
    private validateImportedFileChunkSize;
    /**
     * Validates the import path is the correct format.
     */
    private validateImportPath;
    /**
     * Validates the perUnitStorageThroughput is defined correctly for the given deploymentType.
     */
    private validatePerUnitStorageThroughput;
    /**
     * Validates the storage capacity is an acceptable value for the deployment type.
     */
    private validateStorageCapacity;
}
