"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    /**
     * @experimental
     */
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.string({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            },
        });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    /**
     * @experimental
     */
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    /**
     * @experimental
     */
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    /**
     * @experimental
     */
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYWN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLDhDQUE4QztBQUM5Qyx3Q0FBZ0Q7Ozs7Ozs7Ozs7O0FBWWhELE1BQXNCLE1BQU07Ozs7SUFVMUIsWUFBc0IsZ0JBQStDO1FBRjdELHVCQUFrQixHQUFHLEtBQUssQ0FBQztRQUdqQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsZ0JBQWdCLENBQUMsa0JBQWtCLENBQUM7UUFDckUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFdBQUksQ0FBQyxNQUFNLENBQUM7WUFDbEMsT0FBTyxFQUFFLEdBQUcsRUFBRTtnQkFDZCx5REFBeUQ7Z0JBQ3ZELElBQUksSUFBSSxDQUFDLGVBQWUsS0FBSyxTQUFTLEVBQUU7b0JBQ3RDLE9BQU8sSUFBSSxDQUFDLHlCQUF5QixLQUFLLFNBQVM7d0JBQ25ELCtEQUErRDt3QkFDN0QsQ0FBQyxDQUFDLElBQUksQ0FBQyx5QkFBeUI7d0JBQ2xDLG9FQUFvRTt3QkFDbEUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztpQkFDbEU7cUJBQU07b0JBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyx5Q0FBeUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsS0FBSzt3QkFDOUYsOENBQThDLENBQUMsQ0FBQztpQkFDakQ7WUFDSCxDQUFDO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGdCQUFnQixHQUFHO1lBQ3RCLEdBQUcsZ0JBQWdCO1lBQ25CLGtCQUFrQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7U0FDMUMsQ0FBQztJQUNKLENBQUM7Ozs7SUFFTSxJQUFJLENBQUMsS0FBZ0IsRUFBRSxLQUEwQixFQUFFLE9BQXVDO1FBRS9GLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUNoQyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztRQUNwQixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztRQUVwQixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyx5QkFBeUIsS0FBSyxTQUFTO1lBQ2pFLGdFQUFnRTtZQUNoRSxDQUFDLENBQUMsR0FBRyxLQUFLLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVLEtBQUs7WUFDN0QsQ0FBQyxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztRQUVuQyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztJQUMzQyxDQUFDOzs7O0lBRU0sYUFBYSxDQUFDLElBQVksRUFBRSxNQUEyQixFQUFFLE9BQTBCO1FBQ3hGLE1BQU0sSUFBSSxHQUFHLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztRQUN4RCxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDbkIsVUFBVSxFQUFFLENBQUMsNENBQTRDLENBQUM7WUFDMUQsTUFBTSxFQUFFLENBQUMsa0JBQWtCLENBQUM7WUFDNUIsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUM7WUFDdEMsTUFBTSxFQUFFO2dCQUNOLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDO2dCQUM3QixNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxDQUFDO2FBQzNDO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7O0lBRVMsa0JBQWtCLENBQUMsWUFBb0I7UUFDL0MsSUFBSSxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUMvQixPQUFPLEtBQUssSUFBSSxDQUFDLGdCQUFnQixJQUFJLFlBQVksR0FBRyxDQUFDO0lBQ3ZELENBQUM7SUFhRCxJQUFZLFFBQVE7UUFDbEIsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO1lBQ2xCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUN2QjthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyx1RkFBdUYsQ0FBQyxDQUFDO1NBQzFHO0lBQ0gsQ0FBQztJQUVELElBQVksS0FBSztRQUNmLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRTtZQUNmLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztTQUNwQjthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyx1RkFBdUYsQ0FBQyxDQUFDO1NBQzFHO0lBQ0gsQ0FBQztJQUVEOzs7O09BSUc7SUFDSCxJQUFZLEtBQUs7UUFDZixJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDZixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDcEI7YUFBTTtZQUNMLE1BQU0sSUFBSSxLQUFLLENBQUMsa0VBQWtFLENBQUMsQ0FBQztTQUNyRjtJQUNILENBQUM7Q0FDRjtBQTFHRCx3QkEwR0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjb2RlcGlwZWxpbmUgZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVwaXBlbGluZSc7XG5pbXBvcnQgKiBhcyBldmVudHMgZnJvbSAnQGF3cy1jZGsvYXdzLWV2ZW50cyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIExhenkgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQWN0aW9uIGltcGxlbWVudHMgY29kZXBpcGVsaW5lLklBY3Rpb24ge1xuICBwdWJsaWMgcmVhZG9ubHkgYWN0aW9uUHJvcGVydGllczogY29kZXBpcGVsaW5lLkFjdGlvblByb3BlcnRpZXM7XG4gIHByaXZhdGUgX3BpcGVsaW5lPzogY29kZXBpcGVsaW5lLklQaXBlbGluZTtcbiAgcHJpdmF0ZSBfc3RhZ2U/OiBjb2RlcGlwZWxpbmUuSVN0YWdlO1xuICBwcml2YXRlIF9zY29wZT86IENvbnN0cnVjdDtcbiAgcHJpdmF0ZSByZWFkb25seSBjdXN0b21lclByb3ZpZGVkTmFtZXNwYWNlPzogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IG5hbWVzcGFjZU9yVG9rZW46IHN0cmluZztcbiAgcHJpdmF0ZSBhY3R1YWxOYW1lc3BhY2U/OiBzdHJpbmc7XG4gIHByaXZhdGUgdmFyaWFibGVSZWZlcmVuY2VkID0gZmFsc2U7XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKGFjdGlvblByb3BlcnRpZXM6IGNvZGVwaXBlbGluZS5BY3Rpb25Qcm9wZXJ0aWVzKSB7XG4gICAgdGhpcy5jdXN0b21lclByb3ZpZGVkTmFtZXNwYWNlID0gYWN0aW9uUHJvcGVydGllcy52YXJpYWJsZXNOYW1lc3BhY2U7XG4gICAgdGhpcy5uYW1lc3BhY2VPclRva2VuID0gTGF6eS5zdHJpbmcoe1xuICAgICAgcHJvZHVjZTogKCkgPT4ge1xuICAgICAgLy8gbWFrZSBzdXJlIHRoZSBhY3Rpb24gd2FzIGJvdW5kICg9IGFkZGVkIHRvIGEgcGlwZWxpbmUpXG4gICAgICAgIGlmICh0aGlzLmFjdHVhbE5hbWVzcGFjZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgcmV0dXJuIHRoaXMuY3VzdG9tZXJQcm92aWRlZE5hbWVzcGFjZSAhPT0gdW5kZWZpbmVkXG4gICAgICAgICAgLy8gaWYgYSBjdXN0b21lciBwYXNzZWQgYSBuYW1lc3BhY2UgZXhwbGljaXRseSwgYWx3YXlzIHVzZSB0aGF0XG4gICAgICAgICAgICA/IHRoaXMuY3VzdG9tZXJQcm92aWRlZE5hbWVzcGFjZVxuICAgICAgICAgIC8vIG90aGVyd2lzZSwgb25seSByZXR1cm4gYSBuYW1lc3BhY2UgaWYgYW55IHZhcmlhYmxlIHdhcyByZWZlcmVuY2VkXG4gICAgICAgICAgICA6ICh0aGlzLnZhcmlhYmxlUmVmZXJlbmNlZCA/IHRoaXMuYWN0dWFsTmFtZXNwYWNlIDogdW5kZWZpbmVkKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYENhbm5vdCByZWZlcmVuY2UgdmFyaWFibGVzIG9mIGFjdGlvbiAnJHt0aGlzLmFjdGlvblByb3BlcnRpZXMuYWN0aW9uTmFtZX0nLCBgICtcbiAgICAgICAgICAnYXMgdGhhdCBhY3Rpb24gd2FzIG5ldmVyIGFkZGVkIHRvIGEgcGlwZWxpbmUnKTtcbiAgICAgICAgfVxuICAgICAgfSxcbiAgICB9KTtcbiAgICB0aGlzLmFjdGlvblByb3BlcnRpZXMgPSB7XG4gICAgICAuLi5hY3Rpb25Qcm9wZXJ0aWVzLFxuICAgICAgdmFyaWFibGVzTmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZU9yVG9rZW4sXG4gICAgfTtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QsIHN0YWdlOiBjb2RlcGlwZWxpbmUuSVN0YWdlLCBvcHRpb25zOiBjb2RlcGlwZWxpbmUuQWN0aW9uQmluZE9wdGlvbnMpOlxuICBjb2RlcGlwZWxpbmUuQWN0aW9uQ29uZmlnIHtcbiAgICB0aGlzLl9waXBlbGluZSA9IHN0YWdlLnBpcGVsaW5lO1xuICAgIHRoaXMuX3N0YWdlID0gc3RhZ2U7XG4gICAgdGhpcy5fc2NvcGUgPSBzY29wZTtcblxuICAgIHRoaXMuYWN0dWFsTmFtZXNwYWNlID0gdGhpcy5jdXN0b21lclByb3ZpZGVkTmFtZXNwYWNlID09PSB1bmRlZmluZWRcbiAgICAgIC8vIGRlZmF1bHQgYSBuYW1lc3BhY2UgbmFtZSwgYmFzZWQgb24gdGhlIHN0YWdlIGFuZCBhY3Rpb24gbmFtZXNcbiAgICAgID8gYCR7c3RhZ2Uuc3RhZ2VOYW1lfV8ke3RoaXMuYWN0aW9uUHJvcGVydGllcy5hY3Rpb25OYW1lfV9OU2BcbiAgICAgIDogdGhpcy5jdXN0b21lclByb3ZpZGVkTmFtZXNwYWNlO1xuXG4gICAgcmV0dXJuIHRoaXMuYm91bmQoc2NvcGUsIHN0YWdlLCBvcHRpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyBvblN0YXRlQ2hhbmdlKG5hbWU6IHN0cmluZywgdGFyZ2V0PzogZXZlbnRzLklSdWxlVGFyZ2V0LCBvcHRpb25zPzogZXZlbnRzLlJ1bGVQcm9wcykge1xuICAgIGNvbnN0IHJ1bGUgPSBuZXcgZXZlbnRzLlJ1bGUodGhpcy5zY29wZSwgbmFtZSwgb3B0aW9ucyk7XG4gICAgcnVsZS5hZGRUYXJnZXQodGFyZ2V0KTtcbiAgICBydWxlLmFkZEV2ZW50UGF0dGVybih7XG4gICAgICBkZXRhaWxUeXBlOiBbJ0NvZGVQaXBlbGluZSBBY3Rpb24gRXhlY3V0aW9uIFN0YXRlIENoYW5nZSddLFxuICAgICAgc291cmNlOiBbJ2F3cy5jb2RlcGlwZWxpbmUnXSxcbiAgICAgIHJlc291cmNlczogW3RoaXMucGlwZWxpbmUucGlwZWxpbmVBcm5dLFxuICAgICAgZGV0YWlsOiB7XG4gICAgICAgIHN0YWdlOiBbdGhpcy5zdGFnZS5zdGFnZU5hbWVdLFxuICAgICAgICBhY3Rpb246IFt0aGlzLmFjdGlvblByb3BlcnRpZXMuYWN0aW9uTmFtZV0sXG4gICAgICB9LFxuICAgIH0pO1xuICAgIHJldHVybiBydWxlO1xuICB9XG5cbiAgcHJvdGVjdGVkIHZhcmlhYmxlRXhwcmVzc2lvbih2YXJpYWJsZU5hbWU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgdGhpcy52YXJpYWJsZVJlZmVyZW5jZWQgPSB0cnVlO1xuICAgIHJldHVybiBgI3ske3RoaXMubmFtZXNwYWNlT3JUb2tlbn0uJHt2YXJpYWJsZU5hbWV9fWA7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwcm90ZWN0ZWQgYWJzdHJhY3QgYm91bmQoc2NvcGU6IENvbnN0cnVjdCwgc3RhZ2U6IGNvZGVwaXBlbGluZS5JU3RhZ2UsIG9wdGlvbnM6IGNvZGVwaXBlbGluZS5BY3Rpb25CaW5kT3B0aW9ucyk6XG4gIGNvZGVwaXBlbGluZS5BY3Rpb25Db25maWc7XG5cbiAgcHJpdmF0ZSBnZXQgcGlwZWxpbmUoKTogY29kZXBpcGVsaW5lLklQaXBlbGluZSB7XG4gICAgaWYgKHRoaXMuX3BpcGVsaW5lKSB7XG4gICAgICByZXR1cm4gdGhpcy5fcGlwZWxpbmU7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQWN0aW9uIG11c3QgYmUgYWRkZWQgdG8gYSBzdGFnZSB0aGF0IGlzIHBhcnQgb2YgYSBwaXBlbGluZSBiZWZvcmUgdXNpbmcgb25TdGF0ZUNoYW5nZScpO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgZ2V0IHN0YWdlKCk6IGNvZGVwaXBlbGluZS5JU3RhZ2Uge1xuICAgIGlmICh0aGlzLl9zdGFnZSkge1xuICAgICAgcmV0dXJuIHRoaXMuX3N0YWdlO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0FjdGlvbiBtdXN0IGJlIGFkZGVkIHRvIGEgc3RhZ2UgdGhhdCBpcyBwYXJ0IG9mIGEgcGlwZWxpbmUgYmVmb3JlIHVzaW5nIG9uU3RhdGVDaGFuZ2UnKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogUmV0cmlldmVzIHRoZSBDb25zdHJ1Y3Qgc2NvcGUgb2YgdGhpcyBBY3Rpb24uXG4gICAqIE9ubHkgYXZhaWxhYmxlIGFmdGVyIHRoZSBBY3Rpb24gaGFzIGJlZW4gYWRkZWQgdG8gYSBTdGFnZSxcbiAgICogYW5kIHRoYXQgU3RhZ2UgdG8gYSBQaXBlbGluZS5cbiAgICovXG4gIHByaXZhdGUgZ2V0IHNjb3BlKCk6IENvbnN0cnVjdCB7XG4gICAgaWYgKHRoaXMuX3Njb3BlKSB7XG4gICAgICByZXR1cm4gdGhpcy5fc2NvcGU7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQWN0aW9uIG11c3QgYmUgYWRkZWQgdG8gYSBzdGFnZSB0aGF0IGlzIHBhcnQgb2YgYSBwaXBlbGluZSBmaXJzdCcpO1xuICAgIH1cbiAgfVxufVxuIl19