import type { Target } from 'nx/src/command-line/run';
import { ProjectGraph } from 'nx/src/config/project-graph';
/**
 * @deprecated(v17) A project graph should be passed to parseTargetString for best accuracy.
 */
export declare function parseTargetString(targetString: string): Target;
/**
 * Parses a target string into {project, target, configuration}
 *
 * Examples:
 * ```typescript
 * parseTargetString("proj:test", graph) // returns { project: "proj", target: "test" }
 * parseTargetString("proj:test:production", graph) // returns { project: "proj", target: "test", configuration: "production" }
 * ```
 *
 * @param targetString - target reference
 */
export declare function parseTargetString(targetString: string, projectGraph: ProjectGraph): Target;
/**
 * Returns a string in the format "project:target[:configuration]" for the target
 *
 * @param target - target object
 *
 * Examples:
 *
 * ```typescript
 * targetToTargetString({ project: "proj", target: "test" }) // returns "proj:test"
 * targetToTargetString({ project: "proj", target: "test", configuration: "production" }) // returns "proj:test:production"
 * ```
 */
export declare function targetToTargetString({ project, target, configuration, }: Target): string;
