/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.util;

import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.exception.ParamIllegalArgumentException;
import com.cmayes.common.util.BeanMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;

public final class TypeUtils {
    public static final HashMap<Type, BeanMap.Transformer> XFORMERS = new HashMap();

    private TypeUtils() {
    }

    public static <T> T runtimeConvertType(Class<T> newType, Object value) {
        try {
            return TypeUtils.convertType(newType, value);
        }
        catch (InstantiationException e) {
            throw new EnvironmentException("Problems converting value", (Throwable)e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new EnvironmentException("Security issues converting value", (Throwable)e, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new EnvironmentException("Problems converting value", (Throwable)e, new Object[0]);
        }
    }

    public static <T> T convertType(Class<T> newType, Object value) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (value == null) {
            return null;
        }
        if (newType.isEnum()) {
            Class<Enum> clazz = newType.asSubclass(Enum.class);
            return (T)Enum.valueOf(clazz, (String)value);
        }
        if (value.getClass().isArray()) {
            Object[] objArray = (Object[])value;
            if (newType.isArray()) {
                return (T)objArray;
            }
            if (Set.class.isAssignableFrom(newType)) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objArray.length; ++i) {
                    hashSet.add(objArray[i]);
                }
                return (T)hashSet;
            }
            if (Collection.class.isAssignableFrom(newType)) {
                ArrayList<Object> hashSet = new ArrayList<Object>();
                for (int i = 0; i < objArray.length; ++i) {
                    hashSet.add(objArray[i]);
                }
                return (T)hashSet;
            }
            throw new ParamIllegalArgumentException("Can't convert array %s to type %s", value, newType);
        }
        if (newType.equals(Boolean.TYPE) && value.getClass().equals(String.class)) {
            String strVal = value.toString();
            if (strVal.equalsIgnoreCase("y")) {
                return (T)Boolean.TRUE;
            }
            return (T)Boolean.valueOf(strVal);
        }
        Class[] types = new Class[]{value.getClass()};
        try {
            Constructor<T> constructor = newType.getConstructor(types);
            Object[] arguments = new Object[]{value};
            return constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            BeanMap.Transformer transformer = XFORMERS.get(newType);
            if (value instanceof Boolean && Number.class.isAssignableFrom(newType)) {
                return (T)transformer.transform((Boolean)value != false ? 1 : 0);
            }
            if (transformer != null) {
                return (T)transformer.transform(value);
            }
            if (newType.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            throw new IllegalArgumentException("Cannot convert value " + value + ", class " + value.getClass() + " to " + newType);
        }
    }

    static {
        XFORMERS.put(Boolean.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Boolean.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Boolean.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Boolean.valueOf(input.toString());
            }
        });
        XFORMERS.put(Character.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Character.valueOf(input.toString().charAt(0));
            }
        });
        XFORMERS.put((Type)((Object)Character.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Character.valueOf(input.toString().charAt(0));
            }
        });
        XFORMERS.put(Byte.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Byte.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Byte.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Byte.valueOf(input.toString());
            }
        });
        XFORMERS.put(Short.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Short.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Short.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Short.valueOf(input.toString());
            }
        });
        XFORMERS.put(Integer.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Integer.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Integer.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Integer.valueOf(input.toString());
            }
        });
        XFORMERS.put(Long.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Long.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Long.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Long.valueOf(input.toString());
            }
        });
        XFORMERS.put(Float.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Float.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Float.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Float.valueOf(input.toString());
            }
        });
        XFORMERS.put(Double.TYPE, new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Double.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Double.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return Double.valueOf(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)Number.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return NumberUtils.createNumber(input.toString());
            }
        });
        XFORMERS.put((Type)((Object)String.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                return input.toString();
            }
        });
        XFORMERS.put((Type)((Object)Class.class), new BeanMap.Transformer(){

            @Override
            public Object transform(Object input) {
                try {
                    return Class.forName(input.toString());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("No class found for " + input.toString(), e);
                }
            }
        });
    }
}

