/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.model.def;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cmayes.hartree.model.DihedralPair;
import org.cmayes.hartree.model.InternalMotion;
import org.cmayes.hartree.model.NormalMode;
import org.cmayes.hartree.model.NormalModeCalculation;
import org.cmayes.hartree.model.NormalModeReport;
import org.cmayes.hartree.model.NormalModeSummary;
import org.cmayes.hartree.model.def.DefaultBaseResult;
import org.cmayes.hartree.model.def.DefaultNormalModeReport;
import org.cmayes.hartree.model.def.DefaultNormalModeSummary;

public class DefaultNormalModeCalculation
extends DefaultBaseResult
implements NormalModeCalculation {
    private List<NormalMode> normalModes = new ArrayList<NormalMode>();

    public DefaultNormalModeCalculation() {
    }

    public DefaultNormalModeCalculation(String srcName) {
        super(srcName);
    }

    @Override
    public List<NormalMode> getNormalModes() {
        return this.normalModes;
    }

    @Override
    public void setNormalModes(List<NormalMode> norModes) {
        this.normalModes = norModes;
    }

    @Override
    public NormalModeReport generateReport() {
        LinkedHashMap<NormalMode, NormalModeSummary> summaries = new LinkedHashMap<NormalMode, NormalModeSummary>();
        for (NormalMode curMode : this.normalModes) {
            summaries.put(curMode, this.calculateSummary(curMode));
        }
        return new DefaultNormalModeReport(summaries);
    }

    NormalModeSummary calculateSummary(NormalMode curMode) {
        DefaultNormalModeSummary sum = new DefaultNormalModeSummary();
        for (InternalMotion curMot : curMode.getMotions()) {
            switch (curMot.getType()) {
                case ANGLE_BENDING: {
                    sum.addToAngleBendingWeight(curMot.getWeight());
                    break;
                }
                case BOND_STRETCHING: {
                    sum.addToBondStretchingWeight(curMot.getWeight());
                    break;
                }
                case DIHEDRAL_ROTATION: {
                    sum.addToDihedralPairWeights(this.genPair(curMot), curMot.getWeight());
                    break;
                }
            }
        }
        return sum;
    }

    DihedralPair genPair(InternalMotion curMot) {
        try {
            return new DihedralPair(curMot.getMembers().get(1), curMot.getMembers().get(2));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("index mismatch when getting inner two atoms from list (%s)", Joiner.on(',').join(curMot.getMembers())), e);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultNormalModeCalculation)) {
            return false;
        }
        DefaultNormalModeCalculation rhs = (DefaultNormalModeCalculation)object;
        return new EqualsBuilder().appendSuper(super.equals(rhs)).append(this.normalModes, rhs.normalModes).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(-260541395, -1134444587).appendSuper(super.hashCode()).append(this.normalModes).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("symmetricTop", this.isSymmetricTop()).append("transPart", this.getTransPart()).append("atoms", this.getAtoms()).append("frequencyValues", this.getFrequencyValues()).append("cpuTimes", this.getCpuTimes()).append("mult", this.getMult()).append("terminationDates", this.getTerminationDates()).append("rotPart", this.getRotPart()).append("normalModes", this.normalModes).toString();
    }
}

