from .commands import GeoMember, GeoPoint, Redis, create_redis, create_redis_pool

try:
    from aioredis.connection import RedisConnection
except ImportError:
    from .._aioredis.connection import RedisConnection

from .errors import (
    AuthError,
    BusyGroupError,
    ChannelClosedError,
    ConnectionClosedError,
    ConnectionForcedCloseError,
    MasterNotFoundError,
    MasterReplyError,
    MaxClientsError,
    MultiExecError,
    PipelineError,
    PoolClosedError,
    ProtocolError,
    ReadOnlyError,
    RedisError,
    ReplyError,
    SlaveNotFoundError,
    SlaveReplyError,
    WatchVariableError,
)

try:
    from aioredis.pool import ConnectionsPool
except ImportError:
    from .._aioredis.pool import ConnectionsPool
try:
    from aioredis.pubsub import Channel
except ImportError:
    from .._aioredis.pubsub import Channel
try:
    from aioredis.sentinel import RedisSentinel, create_sentinel
except ImportError:
    from .._aioredis.sentinel import RedisSentinel, create_sentinel

from .connection import create_connection
from .pool import create_pool

__version__ = "1.3.1"

__all__ = (
    # Factories
    "create_connection",
    "create_pool",
    "create_redis",
    "create_redis_pool",
    "create_sentinel",
    # Classes
    "RedisConnection",
    "ConnectionsPool",
    "Redis",
    "GeoPoint",
    "GeoMember",
    "Channel",
    "RedisSentinel",
    # Errors
    "RedisError",
    "ReplyError",
    "MaxClientsError",
    "AuthError",
    "BusyGroupError",
    "ProtocolError",
    "PipelineError",
    "MultiExecError",
    "WatchVariableError",
    "ConnectionClosedError",
    "ConnectionForcedCloseError",
    "ConnectTimeoutError",
    "PoolClosedError",
    "ChannelClosedError",
    "MasterNotFoundError",
    "SlaveNotFoundError",
    "ReadOnlyError",
    "MasterReplyError",
    "SlaveReplyError",
)
