# Generated by Django 2.2.23 on 2022-03-04 09:46

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields
import djangoldp_circle.permissions


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_circle', '0031_circle_parentcircle'),
    ]

    operations = [
        migrations.AlterField(
            model_name='circle',
            name='status',
            field=models.CharField(choices=[('Public', 'Public'), ('Private', 'Private'), ('Archived', 'Archived'), ('Restrict', 'Restricted')], default='Public', max_length=8),
        ),
        migrations.CreateModel(
            name='CircleAccessRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Accepted', 'Accepted'), ('Refused', 'Refused')], default='Pending', max_length=8)),
                ('circle', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='access_requests', to='djangoldp_circle.Circle')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='circle_access_requests', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'hd:circleaccessrequest',
                'auto_author': 'user',
                'permission_classes': [djangoldp_circle.permissions.CirclePermissions],
                'depth': 0,
                'anonymous_perms': [],
                'authenticated_perms': ['add'],
                'owner_perms': ['add'],
            },
        ),
    ]
