from mobio.libs.profiling_mf.merge_fields.base_merge import BaseMerge, MergeListGroup


class MergeUpdatedTime(BaseMerge):
    def serialize_data(
        self,
        suggest_data,
        profile_data,
        set_suggest_fields,
        set_unique_suggest_values,
        field_key,
        field_property,
        display_type,
        translate_key,
        predict=None
    ):
        suggest = False
        if profile_data is not None and field_key not in set_suggest_fields:
            suggest = True
            set_suggest_fields.add(field_key)
        field_value = self.__build_value__(value=profile_data, suggest=suggest)
        suggest_data[field_key] = self.build_merge_data(
            translate_key=translate_key,
            field_property=field_property,
            display_type=display_type,
            displayable=False,
            editable=False,
            mergeable=False,
            order=1,
            group=MergeListGroup.OTHER,
            value=field_value,
        )

    def set_filter_value(self, suggest_filter_data, profile_data):
        pass

    def serialize_origin_data(
        self,
        suggest_data,
        origin_data,
        set_suggest_fields,
        set_unique_suggest_values,
        field_key,
        field_property,
        display_type,
        translate_key,
    ):
        suggest = False
        if origin_data is not None and field_key not in set_suggest_fields:
            suggest = True
            set_suggest_fields.add(field_key)
        field_value = self.__build_value__(value=origin_data, suggest=suggest)
        suggest_data[field_key] = self.build_merge_data(
            translate_key=translate_key,
            field_property=field_property,
            display_type=display_type,
            displayable=False,
            editable=False,
            mergeable=False,
            order=1,
            group=MergeListGroup.OTHER,
            value=field_value,
        )

    def merge_data(self, target_data, source_data, field_key, is_master_data=False):
        pass
