"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const appscaling = require("@aws-cdk/aws-applicationautoscaling");
const cdk = require("@aws-cdk/core");
const dynamodb = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-dynamodb');
const table = new dynamodb.Table(stack, 'Table', {
    partitionKey: { name: 'hashKey', type: dynamodb.AttributeType.STRING },
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
/// !show
const readScaling = table.autoScaleReadCapacity({ minCapacity: 1, maxCapacity: 50 });
readScaling.scaleOnUtilization({
    targetUtilizationPercent: 50,
});
readScaling.scaleOnSchedule('ScaleUpInTheMorning', {
    schedule: appscaling.Schedule.cron({ hour: '8', minute: '0' }),
    minCapacity: 20,
});
readScaling.scaleOnSchedule('ScaleDownAtNight', {
    schedule: appscaling.Schedule.cron({ hour: '20', minute: '0' }),
    maxCapacity: 20,
});
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,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