# File generated from our OpenAPI spec by Stainless.

from __future__ import annotations

from typing import Dict, List, Union, Optional
from datetime import date, datetime
from typing_extensions import Literal

from ..types import (
    ExpectedPayment,
    ExpectedPaymentType,
    shared_params,
    expected_payment_list_params,
    expected_payment_create_params,
    expected_payment_update_params,
)
from .._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from .._utils import maybe_transform
from .._resource import SyncAPIResource, AsyncAPIResource
from ..pagination import SyncPage, AsyncPage
from .._base_client import AsyncPaginator, make_request_options

__all__ = ["ExpectedPayments", "AsyncExpectedPayments"]


class ExpectedPayments(SyncAPIResource):
    def create(
        self,
        *,
        amount_upper_bound: int,
        amount_lower_bound: int,
        direction: Literal["credit", "debit"],
        internal_account_id: str,
        type: ExpectedPaymentType | NotGiven = NOT_GIVEN,
        currency: shared_params.Currency | NotGiven = NOT_GIVEN,
        date_upper_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        date_lower_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        description: Optional[str] | NotGiven = NOT_GIVEN,
        statement_descriptor: Optional[str] | NotGiven = NOT_GIVEN,
        metadata: Dict[str, str] | NotGiven = NOT_GIVEN,
        counterparty_id: Optional[str] | NotGiven = NOT_GIVEN,
        remittance_information: Optional[str] | NotGiven = NOT_GIVEN,
        line_items: List[expected_payment_create_params.LineItem] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """
        create expected payment

        Args:
          amount_upper_bound: The highest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          amount_lower_bound: The lowest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          direction: One of credit or debit. When you are receiving money, use credit. When you are
              being charged, use debit.

          internal_account_id: The ID of the Internal Account for the expected payment.

          type: One of: ach, au_becs, bacs, book, check, eft, interac, provxchange, rtp, sen,
              sepa, signet, wire.

          currency: Must conform to ISO 4217. Defaults to the currency of the internal account.

          date_upper_bound: The latest date the payment may come in. Format: yyyy-mm-dd

          date_lower_bound: The earliest date the payment may come in. Format: yyyy-mm-dd

          description: An optional description for internal use.

          statement_descriptor: The statement description you expect to see on the transaction. For ACH
              payments, this will be the full line item passed from the bank. For wire
              payments, this will be the OBI field on the wire. For check payments, this will
              be the memo field.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          counterparty_id: The ID of the counterparty you expect for this payment.

          remittance_information: For `ach`, this field will be passed through on an addenda record. For `wire`
              payments the field will be passed through as the "Originator to Beneficiary
              Information", also known as OBI or Fedwire tag 6000.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request
        """
        return self._post(
            "/api/expected_payments",
            body=maybe_transform(
                {
                    "amount_upper_bound": amount_upper_bound,
                    "amount_lower_bound": amount_lower_bound,
                    "direction": direction,
                    "internal_account_id": internal_account_id,
                    "type": type,
                    "currency": currency,
                    "date_upper_bound": date_upper_bound,
                    "date_lower_bound": date_lower_bound,
                    "description": description,
                    "statement_descriptor": statement_descriptor,
                    "metadata": metadata,
                    "counterparty_id": counterparty_id,
                    "remittance_information": remittance_information,
                    "line_items": line_items,
                },
                expected_payment_create_params.ExpectedPaymentCreateParams,
            ),
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )

    def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """get expected payment"""
        return self._get(
            f"/api/expected_payments/{id}",
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )

    def update(
        self,
        id: str,
        *,
        amount_upper_bound: int | NotGiven = NOT_GIVEN,
        amount_lower_bound: int | NotGiven = NOT_GIVEN,
        direction: Literal["credit", "debit"] | NotGiven = NOT_GIVEN,
        internal_account_id: str | NotGiven = NOT_GIVEN,
        type: ExpectedPaymentType | NotGiven = NOT_GIVEN,
        currency: shared_params.Currency | NotGiven = NOT_GIVEN,
        date_upper_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        date_lower_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        description: Optional[str] | NotGiven = NOT_GIVEN,
        statement_descriptor: Optional[str] | NotGiven = NOT_GIVEN,
        metadata: Dict[str, str] | NotGiven = NOT_GIVEN,
        counterparty_id: Optional[str] | NotGiven = NOT_GIVEN,
        remittance_information: Optional[str] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """
        update expected payment

        Args:
          amount_upper_bound: The highest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          amount_lower_bound: The lowest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          direction: One of credit or debit. When you are receiving money, use credit. When you are
              being charged, use debit.

          internal_account_id: The ID of the Internal Account for the expected payment.

          type: One of: ach, au_becs, bacs, book, check, eft, interac, provxchange, rtp, sen,
              sepa, signet, wire.

          currency: Must conform to ISO 4217. Defaults to the currency of the internal account.

          date_upper_bound: The latest date the payment may come in. Format: yyyy-mm-dd

          date_lower_bound: The earliest date the payment may come in. Format: yyyy-mm-dd

          description: An optional description for internal use.

          statement_descriptor: The statement description you expect to see on the transaction. For ACH
              payments, this will be the full line item passed from the bank. For wire
              payments, this will be the OBI field on the wire. For check payments, this will
              be the memo field.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          counterparty_id: The ID of the counterparty you expect for this payment.

          remittance_information: For `ach`, this field will be passed through on an addenda record. For `wire`
              payments the field will be passed through as the "Originator to Beneficiary
              Information", also known as OBI or Fedwire tag 6000.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request
        """
        return self._patch(
            f"/api/expected_payments/{id}",
            body=maybe_transform(
                {
                    "amount_upper_bound": amount_upper_bound,
                    "amount_lower_bound": amount_lower_bound,
                    "direction": direction,
                    "internal_account_id": internal_account_id,
                    "type": type,
                    "currency": currency,
                    "date_upper_bound": date_upper_bound,
                    "date_lower_bound": date_lower_bound,
                    "description": description,
                    "statement_descriptor": statement_descriptor,
                    "metadata": metadata,
                    "counterparty_id": counterparty_id,
                    "remittance_information": remittance_information,
                },
                expected_payment_update_params.ExpectedPaymentUpdateParams,
            ),
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )

    def list(
        self,
        *,
        after_cursor: Optional[str] | NotGiven = NOT_GIVEN,
        per_page: int | NotGiven = NOT_GIVEN,
        status: Literal["archived", "reconciled", "unreconciled"] | NotGiven = NOT_GIVEN,
        internal_account_id: str | NotGiven = NOT_GIVEN,
        direction: Literal["credit", "debit"] | NotGiven = NOT_GIVEN,
        type: Literal[
            "ach",
            "au_becs",
            "bacs",
            "book",
            "card",
            "check",
            "cross_border",
            "eft",
            "interac",
            "masav",
            "neft",
            "provxchange",
            "rtp",
            "sen",
            "sepa",
            "signet",
            "wire",
        ]
        | NotGiven = NOT_GIVEN,
        counterparty_id: str | NotGiven = NOT_GIVEN,
        metadata: Dict[str, str] | NotGiven = NOT_GIVEN,
        created_at_lower_bound: Union[str, datetime] | NotGiven = NOT_GIVEN,
        created_at_upper_bound: Union[str, datetime] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> SyncPage[ExpectedPayment]:
        """
        list expected_payments

        Args:
          status: One of unreconciled, reconciled, or archived.

          internal_account_id: Specify internal_account_id to see expected_payments for a specific account.

          direction: One of credit, debit

          type: One of: ach, au_becs, bacs, book, check, eft, interac, provxchange, rtp,sen,
              sepa, signet, wire

          counterparty_id: Specify counterparty_id to see expected_payments for a specific account.

          metadata: For example, if you want to query for records with metadata key `Type` and value
              `Loan`, the query would be `metadata%5BType%5D=Loan`. This encodes the query
              parameters.

          created_at_lower_bound: Used to return expected payments created after some datetime

          created_at_upper_bound: Used to return expected payments created before some datetime

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request
        """
        return self._get_api_list(
            "/api/expected_payments",
            page=SyncPage[ExpectedPayment],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                query=maybe_transform(
                    {
                        "after_cursor": after_cursor,
                        "per_page": per_page,
                        "status": status,
                        "internal_account_id": internal_account_id,
                        "direction": direction,
                        "type": type,
                        "counterparty_id": counterparty_id,
                        "metadata": metadata,
                        "created_at_lower_bound": created_at_lower_bound,
                        "created_at_upper_bound": created_at_upper_bound,
                    },
                    expected_payment_list_params.ExpectedPaymentListParams,
                ),
            ),
            model=ExpectedPayment,
        )

    def delete(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """delete expected payment"""
        return self._delete(
            f"/api/expected_payments/{id}",
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )


class AsyncExpectedPayments(AsyncAPIResource):
    async def create(
        self,
        *,
        amount_upper_bound: int,
        amount_lower_bound: int,
        direction: Literal["credit", "debit"],
        internal_account_id: str,
        type: ExpectedPaymentType | NotGiven = NOT_GIVEN,
        currency: shared_params.Currency | NotGiven = NOT_GIVEN,
        date_upper_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        date_lower_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        description: Optional[str] | NotGiven = NOT_GIVEN,
        statement_descriptor: Optional[str] | NotGiven = NOT_GIVEN,
        metadata: Dict[str, str] | NotGiven = NOT_GIVEN,
        counterparty_id: Optional[str] | NotGiven = NOT_GIVEN,
        remittance_information: Optional[str] | NotGiven = NOT_GIVEN,
        line_items: List[expected_payment_create_params.LineItem] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """
        create expected payment

        Args:
          amount_upper_bound: The highest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          amount_lower_bound: The lowest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          direction: One of credit or debit. When you are receiving money, use credit. When you are
              being charged, use debit.

          internal_account_id: The ID of the Internal Account for the expected payment.

          type: One of: ach, au_becs, bacs, book, check, eft, interac, provxchange, rtp, sen,
              sepa, signet, wire.

          currency: Must conform to ISO 4217. Defaults to the currency of the internal account.

          date_upper_bound: The latest date the payment may come in. Format: yyyy-mm-dd

          date_lower_bound: The earliest date the payment may come in. Format: yyyy-mm-dd

          description: An optional description for internal use.

          statement_descriptor: The statement description you expect to see on the transaction. For ACH
              payments, this will be the full line item passed from the bank. For wire
              payments, this will be the OBI field on the wire. For check payments, this will
              be the memo field.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          counterparty_id: The ID of the counterparty you expect for this payment.

          remittance_information: For `ach`, this field will be passed through on an addenda record. For `wire`
              payments the field will be passed through as the "Originator to Beneficiary
              Information", also known as OBI or Fedwire tag 6000.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request
        """
        return await self._post(
            "/api/expected_payments",
            body=maybe_transform(
                {
                    "amount_upper_bound": amount_upper_bound,
                    "amount_lower_bound": amount_lower_bound,
                    "direction": direction,
                    "internal_account_id": internal_account_id,
                    "type": type,
                    "currency": currency,
                    "date_upper_bound": date_upper_bound,
                    "date_lower_bound": date_lower_bound,
                    "description": description,
                    "statement_descriptor": statement_descriptor,
                    "metadata": metadata,
                    "counterparty_id": counterparty_id,
                    "remittance_information": remittance_information,
                    "line_items": line_items,
                },
                expected_payment_create_params.ExpectedPaymentCreateParams,
            ),
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )

    async def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """get expected payment"""
        return await self._get(
            f"/api/expected_payments/{id}",
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )

    async def update(
        self,
        id: str,
        *,
        amount_upper_bound: int | NotGiven = NOT_GIVEN,
        amount_lower_bound: int | NotGiven = NOT_GIVEN,
        direction: Literal["credit", "debit"] | NotGiven = NOT_GIVEN,
        internal_account_id: str | NotGiven = NOT_GIVEN,
        type: ExpectedPaymentType | NotGiven = NOT_GIVEN,
        currency: shared_params.Currency | NotGiven = NOT_GIVEN,
        date_upper_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        date_lower_bound: Optional[Union[str, date]] | NotGiven = NOT_GIVEN,
        description: Optional[str] | NotGiven = NOT_GIVEN,
        statement_descriptor: Optional[str] | NotGiven = NOT_GIVEN,
        metadata: Dict[str, str] | NotGiven = NOT_GIVEN,
        counterparty_id: Optional[str] | NotGiven = NOT_GIVEN,
        remittance_information: Optional[str] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """
        update expected payment

        Args:
          amount_upper_bound: The highest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          amount_lower_bound: The lowest amount this expected payment may be equal to. Value in specified
              currency's smallest unit. e.g. $10 would be represented as 1000.

          direction: One of credit or debit. When you are receiving money, use credit. When you are
              being charged, use debit.

          internal_account_id: The ID of the Internal Account for the expected payment.

          type: One of: ach, au_becs, bacs, book, check, eft, interac, provxchange, rtp, sen,
              sepa, signet, wire.

          currency: Must conform to ISO 4217. Defaults to the currency of the internal account.

          date_upper_bound: The latest date the payment may come in. Format: yyyy-mm-dd

          date_lower_bound: The earliest date the payment may come in. Format: yyyy-mm-dd

          description: An optional description for internal use.

          statement_descriptor: The statement description you expect to see on the transaction. For ACH
              payments, this will be the full line item passed from the bank. For wire
              payments, this will be the OBI field on the wire. For check payments, this will
              be the memo field.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          counterparty_id: The ID of the counterparty you expect for this payment.

          remittance_information: For `ach`, this field will be passed through on an addenda record. For `wire`
              payments the field will be passed through as the "Originator to Beneficiary
              Information", also known as OBI or Fedwire tag 6000.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request
        """
        return await self._patch(
            f"/api/expected_payments/{id}",
            body=maybe_transform(
                {
                    "amount_upper_bound": amount_upper_bound,
                    "amount_lower_bound": amount_lower_bound,
                    "direction": direction,
                    "internal_account_id": internal_account_id,
                    "type": type,
                    "currency": currency,
                    "date_upper_bound": date_upper_bound,
                    "date_lower_bound": date_lower_bound,
                    "description": description,
                    "statement_descriptor": statement_descriptor,
                    "metadata": metadata,
                    "counterparty_id": counterparty_id,
                    "remittance_information": remittance_information,
                },
                expected_payment_update_params.ExpectedPaymentUpdateParams,
            ),
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )

    def list(
        self,
        *,
        after_cursor: Optional[str] | NotGiven = NOT_GIVEN,
        per_page: int | NotGiven = NOT_GIVEN,
        status: Literal["archived", "reconciled", "unreconciled"] | NotGiven = NOT_GIVEN,
        internal_account_id: str | NotGiven = NOT_GIVEN,
        direction: Literal["credit", "debit"] | NotGiven = NOT_GIVEN,
        type: Literal[
            "ach",
            "au_becs",
            "bacs",
            "book",
            "card",
            "check",
            "cross_border",
            "eft",
            "interac",
            "masav",
            "neft",
            "provxchange",
            "rtp",
            "sen",
            "sepa",
            "signet",
            "wire",
        ]
        | NotGiven = NOT_GIVEN,
        counterparty_id: str | NotGiven = NOT_GIVEN,
        metadata: Dict[str, str] | NotGiven = NOT_GIVEN,
        created_at_lower_bound: Union[str, datetime] | NotGiven = NOT_GIVEN,
        created_at_upper_bound: Union[str, datetime] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> AsyncPaginator[ExpectedPayment, AsyncPage[ExpectedPayment]]:
        """
        list expected_payments

        Args:
          status: One of unreconciled, reconciled, or archived.

          internal_account_id: Specify internal_account_id to see expected_payments for a specific account.

          direction: One of credit, debit

          type: One of: ach, au_becs, bacs, book, check, eft, interac, provxchange, rtp,sen,
              sepa, signet, wire

          counterparty_id: Specify counterparty_id to see expected_payments for a specific account.

          metadata: For example, if you want to query for records with metadata key `Type` and value
              `Loan`, the query would be `metadata%5BType%5D=Loan`. This encodes the query
              parameters.

          created_at_lower_bound: Used to return expected payments created after some datetime

          created_at_upper_bound: Used to return expected payments created before some datetime

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request
        """
        return self._get_api_list(
            "/api/expected_payments",
            page=AsyncPage[ExpectedPayment],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                query=maybe_transform(
                    {
                        "after_cursor": after_cursor,
                        "per_page": per_page,
                        "status": status,
                        "internal_account_id": internal_account_id,
                        "direction": direction,
                        "type": type,
                        "counterparty_id": counterparty_id,
                        "metadata": metadata,
                        "created_at_lower_bound": created_at_lower_bound,
                        "created_at_upper_bound": created_at_upper_bound,
                    },
                    expected_payment_list_params.ExpectedPaymentListParams,
                ),
            ),
            model=ExpectedPayment,
        )

    async def delete(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
    ) -> ExpectedPayment:
        """delete expected payment"""
        return await self._delete(
            f"/api/expected_payments/{id}",
            options=make_request_options(extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body),
            cast_to=ExpectedPayment,
        )
