"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.autoscaling.create_auto_scaling_group
hub.exec.boto3.client.autoscaling.delete_auto_scaling_group
hub.exec.boto3.client.autoscaling.describe_auto_scaling_groups
hub.exec.boto3.client.autoscaling.update_auto_scaling_group
"""
import copy
from typing import Any
from typing import Dict
from typing import List

__contracts__ = ["resource"]


async def present(
    hub,
    ctx,
    name: str,
    min_size: int,
    max_size: int,
    resource_id: str = None,
    launch_configuration_name: str = None,
    launch_template: Dict = None,
    mixed_instances_policy: Dict = None,
    instance_id: str = None,
    desired_capacity: int = None,
    default_cooldown: int = None,
    availability_zones: List = None,
    load_balancer_names: List = None,
    target_group_ar_ns: List = None,
    health_check_type: str = None,
    health_check_grace_period: int = None,
    placement_group: str = None,
    vpc_zone_identifier: str = None,
    termination_policies: List = None,
    new_instances_protected_from_scale_in: bool = None,
    capacity_rebalance: bool = None,
    lifecycle_hook_specification_list: List = None,
    tags: List = None,
    service_linked_role_arn: str = None,
    max_instance_lifetime: int = None,
    desired_capacity_type: str = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

     We strongly recommend using a launch template when calling this operation to ensure full functionality for
    Amazon EC2 Auto Scaling and Amazon EC2.  Creates an Auto Scaling group with the specified name and attributes.
    If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the
    DescribeAccountLimits API. For information about updating this limit, see Amazon EC2 Auto Scaling service quotas
    in the Amazon EC2 Auto Scaling User Guide. For introductory exercises for creating an Auto Scaling group, see
    Getting started with Amazon EC2 Auto Scaling and Tutorial: Set up a scaled and load-balanced application in the
    Amazon EC2 Auto Scaling User Guide. For more information, see Auto Scaling groups in the Amazon EC2 Auto Scaling
    User Guide. Every Auto Scaling group has three size parameters (DesiredCapacity, MaxSize, and MinSize). Usually,
    you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy
    that defines weights for the instance types, you must specify these sizes with the same units that you use for
    weighting instances.

    Args:
        resource_id(Text, optional): The name of the Auto Scaling group. This name must be unique per Region per account.
        name(Text): An Idem name of the resource. This is also used as the AutoScaling Group Name during resource creation.
        launch_configuration_name(Text, optional): The name of the launch configuration to use to launch instances.  Conditional: You must specify
            either a launch template (LaunchTemplate or MixedInstancesPolicy) or a launch configuration
            (LaunchConfigurationName or InstanceId). Defaults to None.
        launch_template(Dict, optional): Parameters used to specify the launch template and version to use to launch instances.
            Conditional: You must specify either a launch template (LaunchTemplate or MixedInstancesPolicy)
            or a launch configuration (LaunchConfigurationName or InstanceId).  The launch template that is
            specified must be configured for use with an Auto Scaling group. For more information, see
            Creating a launch template for an Auto Scaling group in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        mixed_instances_policy(Dict, optional): An embedded object that specifies a mixed instances policy. For more information, see Auto
            Scaling groups with multiple instance types and purchase options in the Amazon EC2 Auto Scaling
            User Guide. Defaults to None.
        instance_id(Text, optional): The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto
            Scaling uses the configuration values from the specified instance to create a new launch
            configuration. To get the instance ID, use the Amazon EC2 DescribeInstances API operation. For
            more information, see Creating an Auto Scaling group using an EC2 instance in the Amazon EC2
            Auto Scaling User Guide. Defaults to None.
        min_size(int): The minimum size of the group.
        max_size(int): The maximum size of the group.  With a mixed instances policy that uses instance weighting,
            Amazon EC2 Auto Scaling may need to go above MaxSize to meet your capacity requirements. In this
            event, Amazon EC2 Auto Scaling will never go above MaxSize by more than your largest instance
            weight (weights that define how many units each instance contributes to the desired capacity of
            the group).
        desired_capacity(int, optional): The desired capacity is the initial capacity of the Auto Scaling group at the time of its
            creation and the capacity it attempts to maintain. It can scale beyond this capacity if you
            configure auto scaling. This number must be greater than or equal to the minimum size of the
            group and less than or equal to the maximum size of the group. If you do not specify a desired
            capacity, the default is the minimum size of the group. Defaults to None.
        default_cooldown(int, optional): The amount of time, in seconds, after a scaling activity completes before another scaling
            activity can start. The default value is 300. This setting applies when using simple scaling
            policies, but not when using other scaling policies or scheduled scaling. For more information,
            see Scaling cooldowns for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        availability_zones(List, optional): A list of Availability Zones where instances in the Auto Scaling group can be created. This
            parameter is optional if you specify one or more subnets for VPCZoneIdentifier. Conditional: If
            your account supports EC2-Classic and VPC, this parameter is required to launch instances into
            EC2-Classic. Defaults to None.
        load_balancer_names(List, optional): A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load
            Balancers, Network Load Balancers, and Gateway Load Balancers, specify the TargetGroupARNs
            property instead. Defaults to None.
        target_group_ar_ns(List, optional): The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group.
            Instances are registered as targets in a target group, and traffic is routed to the target
            group. For more information, see Elastic Load Balancing and Amazon EC2 Auto Scaling in the
            Amazon EC2 Auto Scaling User Guide. Defaults to None.
        health_check_type(Text, optional): The service to use for the health checks. The valid values are EC2 (default) and ELB. If you
            configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the
            instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.
            For more information, see Health checks for Auto Scaling instances in the Amazon EC2 Auto
            Scaling User Guide. Defaults to None.
        health_check_grace_period(int, optional): The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health
            status of an EC2 instance that has come into service and marking it unhealthy due to a failed
            health check. The default value is 0. For more information, see Health check grace period in the
            Amazon EC2 Auto Scaling User Guide. Required if you are adding an ELB health check. Defaults to None.
        placement_group(Text, optional): The name of an existing placement group into which to launch your instances, if any. A placement
            group is a logical grouping of instances within a single Availability Zone. You cannot specify
            multiple Availability Zones and a placement group. For more information, see Placement Groups in
            the Amazon EC2 User Guide for Linux Instances. Defaults to None.
        vpc_zone_identifier(Text, optional): A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the
            Auto Scaling group can be created. If you specify VPCZoneIdentifier with AvailabilityZones, the
            subnets that you specify for this parameter must reside in those Availability Zones.
            Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch
            instances into a VPC. Defaults to None.
        termination_policies(List, optional): A policy or a list of policies that are used to select the instance to terminate. These policies
            are executed in the order that you list them. For more information, see Controlling which Auto
            Scaling instances terminate during scale in in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        new_instances_protected_from_scale_in(bool, optional): Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto
            Scaling when scaling in. For more information about preventing instances from terminating on
            scale in, see Using instance scale-in protection in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        capacity_rebalance(bool, optional): Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled.
            When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot
            Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of
            interruption. After launching a new instance, it then terminates an old instance. For more
            information, see Amazon EC2 Auto Scaling Capacity Rebalancing in the Amazon EC2 Auto Scaling
            User Guide. Defaults to None.
        lifecycle_hook_specification_list(List, optional): One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto
            Scaling launches or terminates instances. Defaults to None.
        tags(List, optional): One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2
            instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS
            volumes, specify the tags in a launch template but use caution. If the launch template specifies
            an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto
            Scaling overrides the value of that instance tag with the value specified by the Auto Scaling
            group. For more information, see Tagging Auto Scaling groups and instances in the Amazon EC2
            Auto Scaling User Guide. Defaults to None.
        service_linked_role_arn(Text, optional): The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to
            call other Amazon Web Services on your behalf. By default, Amazon EC2 Auto Scaling uses a
            service-linked role named AWSServiceRoleForAutoScaling, which it creates if it does not exist.
            For more information, see Service-linked roles in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        max_instance_lifetime(int, optional): The maximum amount of time, in seconds, that an instance can be in service. The default is null.
            If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1
            day). For more information, see Replacing Auto Scaling instances based on maximum instance
            lifetime in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        context(Text, optional): Reserved. Defaults to None.
        desired_capacity_type(Text, optional): The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling
            supports DesiredCapacityType for attribute-based instance type selection only. For more
            information, see Creating an Auto Scaling group using attribute-based instance type selection in
            the Amazon EC2 Auto Scaling User Guide. By default, Amazon EC2 Auto Scaling specifies units,
            which translates into number of instances. Valid values: units | vcpu | memory-mib. Defaults to None.

    Request Syntax:
       [auto-scaling-group-resource-id]:
            aws.autoscaling.auto_scaling_group.present:
              - resource_id: 'string'
              - name: 'string'
              - launch_configuration_name: 'string'
              - min_size: 'int'
              - max_size: 'int'
              - desired_capacity: 'int'
              - default_cooldown: 'int'
              - availability_zones: List
              - health_check_type: 'string'
              - health_check_grace_period: 'int'
              - vpc_zone_identifier: 'string'
              - termination_policies: List
              - new_instances_protected_from_scale_in: 'bool'
              - tags: Dict

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            idem-scaling-group:
              aws.autoscaling.auto_scaling_group.present:
              - resource_id: idem-scaling-group
              - name: idem-scaling-group
              - launch_configuration_name: idem-launch_configuration
              - min_size: 2
              - max_size: 4
              - desired_capacity: 2
              - default_cooldown: 300
              - availability_zones:
                - us-west-1b
                - us-west-1c
              - health_check_type: EC2
              - health_check_grace_period: 300
              - vpc_zone_identifier: subnet-xxxxxxx,subnet-xxxxxxx,subnet-xxxxxx
              - termination_policies:
                - Default
              - new_instances_protected_from_scale_in: false
              - tags:
                - key: Identifier
                  propagate_at_launch: true
                  value: idem-aws
                - key: Name
                  propagate_at_launch: false
                  value: idem-scaling-group
    """
    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)

    # Query for auto scaling groups
    auto_scaling_group = None
    if resource_id:
        auto_scaling_group = (
            await hub.exec.boto3.client.autoscaling.describe_auto_scaling_groups(
                ctx, AutoScalingGroupNames=[resource_id]
            )
        )
        if not auto_scaling_group["result"]:
            result["comment"] = auto_scaling_group["comment"]
            result["result"] = auto_scaling_group["result"]
            return result

    # Check for existing auto scaling group
    before = None
    if auto_scaling_group and auto_scaling_group["ret"]["AutoScalingGroups"]:
        before = auto_scaling_group["ret"]["AutoScalingGroups"][0]

    # Update current state
    current_state = hub.tool.aws.autoscaling.auto_scaling_group_utils.convert_raw_auto_scaling_group_to_present(
        auto_scaling_group=before
    )
    result["old_state"] = current_state

    # Handle No change behaviour
    desired_state = {
        "name": name,
        "resource_id": resource_id,
        "launch_configuration_name": launch_configuration_name,
        "launch_template": launch_template,
        "instance_id": instance_id,
        "min_size": min_size,
        "max_size": max_size,
        "desired_capacity": desired_capacity,
        "default_cooldown": default_cooldown,
        "availability_zones": availability_zones,
        "load_balancer_names": load_balancer_names,
        "target_group_ar_ns": target_group_ar_ns,
        "health_check_type": health_check_type,
        "health_check_grace_period": health_check_grace_period,
        "placement_group": placement_group,
        "mixed_instances_policy": mixed_instances_policy,
        "vpc_zone_identifier": vpc_zone_identifier,
        "termination_policies": termination_policies,
        "new_instances_protected_from_scale_in": new_instances_protected_from_scale_in,
        "capacity_rebalance": capacity_rebalance,
        "lifecycle_hook_specification_list": lifecycle_hook_specification_list,
        "tags": tags,
        "max_instance_lifetime": max_instance_lifetime,
        "desired_capacity_type": desired_capacity_type,
    }

    is_auto_scaling_group_updated = (
        hub.tool.aws.autoscaling.auto_scaling_group_utils.is_auto_scaling_group_updated(
            current_state=current_state, desired_state=desired_state
        )
    )

    is_tags_updated = not hub.tool.aws.state_comparison_utils.are_lists_identical(
        current_state.get("tags"), desired_state.get("tags")
    )

    is_change_detected = (
        before is None or is_auto_scaling_group_updated or is_tags_updated
    )

    if not is_change_detected:
        result["comment"] = (
            f"aws.autoscaling.auto_scaling_group '{name}' already exists",
        )
        result["new_state"] = copy.deepcopy(result["old_state"])
        return result

    # Handle test behaviour
    if ctx.get("test", False):
        result["new_state"] = hub.tool.aws.test_state_utils.generate_test_state(
            enforced_state=current_state,
            desired_state=desired_state,
        )
        result["comment"] = (
            hub.tool.aws.comment_utils.would_update_comment(
                resource_type="aws.autoscaling.auto_scaling_group", name=name
            )
            if before
            else hub.tool.aws.comment_utils.would_create_comment(
                resource_type="aws.autoscaling.auto_scaling_group", name=name
            )
        )
        return result

    # Handle actual resource create or update
    if before:
        # Update auto scaling group
        if is_auto_scaling_group_updated:
            ret = await hub.exec.boto3.client.autoscaling.update_auto_scaling_group(
                ctx,
                **{
                    "AutoScalingGroupName": name,
                    "LaunchConfigurationName": launch_configuration_name,
                    "LaunchTemplate": launch_template,
                    "MixedInstancesPolicy": mixed_instances_policy,
                    "InstanceId": instance_id,
                    "MinSize": min_size,
                    "MaxSize": max_size,
                    "DesiredCapacity": desired_capacity,
                    "DefaultCooldown": default_cooldown,
                    "AvailabilityZones": availability_zones,
                    "HealthCheckType": health_check_type,
                    "HealthCheckGracePeriod": health_check_grace_period,
                    "PlacementGroup": placement_group,
                    "VPCZoneIdentifier": vpc_zone_identifier,
                    "TerminationPolicies": termination_policies,
                    "NewInstancesProtectedFromScaleIn": new_instances_protected_from_scale_in,
                    "CapacityRebalance": capacity_rebalance,
                    "LifecycleHookSpecificationList": lifecycle_hook_specification_list,
                    "ServiceLinkedRoleARN": service_linked_role_arn,
                    "MaxInstanceLifetime": max_instance_lifetime,
                    "DesiredCapacityType": desired_capacity_type,
                },
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result
            result["comment"] = hub.tool.aws.comment_utils.update_comment(
                resource_type="aws.autoscaling.auto_scaling_group", name=name
            )

        # Update tags
        if is_tags_updated:
            translated_current_state_tags = hub.tool.aws.autoscaling.auto_scaling_group_utils.convert_present_tags_to_raw_tags(
                resource_id=name, tags=current_state["tags"]
            )
            translated_desired_state_tags = hub.tool.aws.autoscaling.auto_scaling_group_utils.convert_present_tags_to_raw_tags(
                resource_id=name, tags=desired_state["tags"]
            )
            update_tags = await hub.exec.aws.autoscaling.tag.update_tags(
                ctx,
                old_tags=translated_current_state_tags,
                new_tags=translated_desired_state_tags,
            )
            result["comment"] = result["comment"] + update_tags["comment"]
            result["result"] = result["result"] and update_tags["result"]
            if not result["result"]:
                result["comment"] = update_tags["comment"]
                return result
    else:
        # Handle actual resource creation
        translated_tags = hub.tool.aws.autoscaling.auto_scaling_group_utils.convert_present_tags_to_raw_tags(
            resource_id=name, tags=tags
        )
        ret = await hub.exec.boto3.client.autoscaling.create_auto_scaling_group(
            ctx,
            **{
                "AutoScalingGroupName": name,
                "LaunchConfigurationName": launch_configuration_name,
                "LaunchTemplate": launch_template,
                "MixedInstancesPolicy": mixed_instances_policy,
                "InstanceId": instance_id,
                "MinSize": min_size,
                "MaxSize": max_size,
                "DesiredCapacity": desired_capacity,
                "DefaultCooldown": default_cooldown,
                "AvailabilityZones": availability_zones,
                "LoadBalancerNames": load_balancer_names,
                "TargetGroupARNs": target_group_ar_ns,
                "HealthCheckType": health_check_type,
                "HealthCheckGracePeriod": health_check_grace_period,
                "PlacementGroup": placement_group,
                "VPCZoneIdentifier": vpc_zone_identifier,
                "TerminationPolicies": termination_policies,
                "NewInstancesProtectedFromScaleIn": new_instances_protected_from_scale_in,
                "CapacityRebalance": capacity_rebalance,
                "LifecycleHookSpecificationList": lifecycle_hook_specification_list,
                "Tags": translated_tags,
                "ServiceLinkedRoleARN": service_linked_role_arn,
                "MaxInstanceLifetime": max_instance_lifetime,
                "DesiredCapacityType": desired_capacity_type,
            },
        )
        result["result"] = ret["result"]
        if not result["result"]:
            result["comment"] = ret["comment"]
            return result
        result["comment"] = hub.tool.aws.comment_utils.create_comment(
            resource_type="aws.autoscaling.auto_scaling_group", name=name
        )
        resource_id = name

    # Populate new state
    new_auto_scaling_groups = (
        await hub.exec.boto3.client.autoscaling.describe_auto_scaling_groups(
            ctx, AutoScalingGroupNames=[resource_id]
        )
    )
    if not new_auto_scaling_groups["result"]:
        result["comment"] = result["comment"] + new_auto_scaling_groups["comment"]
        result["result"] = new_auto_scaling_groups["result"]
        return result

    after = new_auto_scaling_groups["ret"]["AutoScalingGroups"][0]
    result[
        "new_state"
    ] = hub.tool.aws.autoscaling.auto_scaling_group_utils.convert_raw_auto_scaling_group_to_present(
        auto_scaling_group=after
    )
    return result


async def absent(
    hub,
    ctx,
    name: str,
    resource_id: str = None,
    timeout: Dict = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes the specified Auto Scaling group. If the group has instances or scaling activities in progress, you must
    specify the option to force the deletion in order for it to succeed. If the group has policies, deleting the
    group deletes the policies, the underlying alarm actions, and any alarm that no longer has an associated action.
    To remove instances from the Auto Scaling group before deleting it, call the DetachInstances API with the list
    of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling does
    not launch replacement instances. To terminate all instances before deleting the Auto Scaling group, call the
    UpdateAutoScalingGroup API and set the minimum size and desired capacity of the Auto Scaling group to zero.

    Args:
        resource_id(Text, optional): The name of the Auto Scaling group.
        name(Text): An Idem name of the resource.
        timeout(Dict, optional): Timeout configuration for deletion of AWS auto scaling group.
            * delete (Dict) -- Timeout configuration for deletion of an auto scaling group
                * delay -- The amount of time in seconds to wait between attempts. Defaults to 15
                * max_attempts -- Customized timeout configuration containing delay and max attempts. Defaults to 40

    Request Syntax:
       [auto-scaling-group-resource-id]:
            aws.autoscaling.auto_scaling_group.absent:
              - resource_id: 'string'
              - name: 'string'

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            idem-scaling-group:
              aws.autoscaling.auto_scaling_group.absent:
              - resource_id: idem-scaling-group
              - name: idem-scaling-group
    """

    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)

    # Query for auto scaling groups
    auto_scaling_group = None
    if resource_id:
        auto_scaling_group = (
            await hub.exec.boto3.client.autoscaling.describe_auto_scaling_groups(
                ctx, AutoScalingGroupNames=[resource_id]
            )
        )

    # Check for existing auto scaling group
    before = None
    if (
        auto_scaling_group
        and auto_scaling_group["result"]
        and auto_scaling_group["ret"]["AutoScalingGroups"]
    ):
        before = auto_scaling_group["ret"]["AutoScalingGroups"][0]
        result[
            "old_state"
        ] = hub.tool.aws.autoscaling.auto_scaling_group_utils.convert_raw_auto_scaling_group_to_present(
            auto_scaling_group=before
        )

    if not before:
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.autoscaling.auto_scaling_group", name=name
        )

    elif ctx.get("test", False):
        result["comment"] = hub.tool.aws.comment_utils.would_delete_comment(
            resource_type="aws.autoscaling.auto_scaling_group", name=name
        )

    else:
        ret = await hub.exec.boto3.client.autoscaling.delete_auto_scaling_group(
            ctx,
            AutoScalingGroupName=resource_id,
            ForceDelete=True,
        )
        if not ret["result"]:
            result["result"] = ret["result"]
            result["comment"] = ret["comment"]
            return result

        # Custom waiter for delete
        waiter_config = hub.tool.aws.waiter_utils.create_waiter_config(
            default_delay=15,
            default_max_attempts=40,
            timeout_config=timeout.get("delete") if timeout else None,
        )
        delete_waiter_acceptors = [
            {
                "matcher": "path",
                "expected": True,
                "state": "success",
                "argument": "length(AutoScalingGroups) == `0`",
            },
            {
                "matcher": "path",
                "expected": True,
                "state": "retry",
                "argument": "length(AutoScalingGroups) > `0`",
            },
        ]
        auto_scaling_group_waiter = hub.tool.boto3.custom_waiter.waiter_wrapper(
            name="AutoScalingGroupDelete",
            operation="DescribeAutoScalingGroups",
            argument=["AutoScalingGroups"],
            acceptors=delete_waiter_acceptors,
            client=hub.tool.boto3.client.get_client(ctx, "autoscaling"),
        )
        try:
            await hub.tool.boto3.client.wait(
                ctx,
                "autoscaling",
                "AutoScalingGroupDelete",
                auto_scaling_group_waiter,
                AutoScalingGroupNames=[
                    resource_id,
                ],
                WaiterConfig=waiter_config,
            )
        except Exception as e:
            result["comment"] = result["comment"] + (str(e),)
            result["result"] = False
            return result

        result["comment"] = hub.tool.aws.comment_utils.delete_comment(
            resource_type="aws.autoscaling.auto_scaling_group", name=name
        )

    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Gets information about the Auto Scaling groups in the account and Region.

    Returns:
        Dict[str, Dict[str, Any]]

    Examples:

        .. code-block:: bash

            $ idem describe aws.autoscaling.auto_scaling_group
    """

    result = {}
    ret = await hub.exec.boto3.client.autoscaling.describe_auto_scaling_groups(ctx)
    if not ret["result"]:
        hub.log.debug(f"Could not describe auto_scaling_group {ret['comment']}")
        return {}

    for auto_scaling_group in ret["ret"]["AutoScalingGroups"]:
        resource_id = auto_scaling_group["AutoScalingGroupName"]
        resource = hub.tool.aws.autoscaling.auto_scaling_group_utils.convert_raw_auto_scaling_group_to_present(
            auto_scaling_group=auto_scaling_group
        )
        result[resource_id] = {
            "aws.autoscaling.auto_scaling_group.present": [
                {parameter_key: parameter_value}
                for parameter_key, parameter_value in resource.items()
            ]
        }
    return result
