"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.autoscaling.create_launch_configuration
hub.exec.boto3.client.autoscaling.delete_launch_configuration
hub.exec.boto3.client.autoscaling.describe_launch_configurations
"""
import copy
from typing import Any
from typing import Dict
from typing import List

__contracts__ = ["resource"]


async def present(
    hub,
    ctx,
    name: str,
    resource_id: str = None,
    image_id: str = None,
    key_name: str = None,
    security_groups: List = None,
    classic_link_vpc_id: str = None,
    classic_link_vpc_security_groups: List = None,
    user_data: str = None,
    instance_id: str = None,
    instance_type: str = None,
    kernel_id: str = None,
    ramdisk_id: str = None,
    block_device_mappings: List = None,
    instance_monitoring: Dict = None,
    spot_price: str = None,
    iam_instance_profile: str = None,
    ebs_optimized: bool = None,
    associate_public_ip_address: bool = None,
    placement_tenancy: str = None,
    metadata_options: Dict = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Creates a launch configuration. If you exceed your maximum limit of launch configurations, the call fails. To
    query this limit, call the DescribeAccountLimits API. For information about updating this limit, see Amazon EC2
    Auto Scaling service quotas in the Amazon EC2 Auto Scaling User Guide. For more information, see Launch
    configurations in the Amazon EC2 Auto Scaling User Guide.

    Args:
        name(Text): The name of the launch configuration. This name must be unique per Region per account.
        resource_id(Text, optional): AWS Launch Configuration name
        image_id(Text, optional): The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more
            information, see Finding an AMI in the Amazon EC2 User Guide for Linux Instances. If you do not
            specify InstanceId, you must specify ImageId. Defaults to None.
        key_name(Text, optional): The name of the key pair. For more information, see Amazon EC2 Key Pairs in the Amazon EC2 User
            Guide for Linux Instances. Defaults to None.
        security_groups(List, optional): A list that contains the security groups to assign to the instances in the Auto Scaling group.
            [EC2-VPC] Specify the security group IDs. For more information, see Security Groups for Your VPC
            in the Amazon Virtual Private Cloud User Guide. [EC2-Classic] Specify either the security group
            names or the security group IDs. For more information, see Amazon EC2 Security Groups in the
            Amazon EC2 User Guide for Linux Instances. Defaults to None.
        classic_link_vpc_id(Text, optional): The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information,
            see ClassicLink in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
            instances to a VPC in the Amazon EC2 Auto Scaling User Guide. This parameter can only be used if
            you are launching EC2-Classic instances. Defaults to None.
        classic_link_vpc_security_groups(List, optional): The IDs of one or more security groups for the specified ClassicLink-enabled VPC. For more
            information, see ClassicLink in the Amazon EC2 User Guide for Linux Instances and Linking
            EC2-Classic instances to a VPC in the Amazon EC2 Auto Scaling User Guide. If you specify the
            ClassicLinkVPCId parameter, you must specify this parameter. Defaults to None.
        user_data(Text, optional): The user data to make available to the launched EC2 instances. For more information, see
            Instance metadata and user data (Linux) and Instance metadata and user data (Windows). If you
            are using a command line tool, base64-encoding is performed for you, and you can load the text
            from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB. Defaults to None.
        instance_id(Text, optional): The ID of the instance to use to create the launch configuration. The new launch configuration
            derives attributes from the instance, except for the block device mapping. To create a launch
            configuration with a block device mapping or override any other instance attributes, specify
            them as part of the same request. For more information, see Creating a launch configuration
            using an EC2 instance in the Amazon EC2 Auto Scaling User Guide. If you do not specify
            InstanceId, you must specify both ImageId and InstanceType. Defaults to None.
        instance_type(Text, optional): Specifies the instance type of the EC2 instance. For information about available instance types,
            see Available Instance Types in the Amazon EC2 User Guide for Linux Instances. If you do not
            specify InstanceId, you must specify InstanceType. Defaults to None.
        kernel_id(Text, optional): The ID of the kernel associated with the AMI. Defaults to None.
        ramdisk_id(Text, optional): The ID of the RAM disk to select. Defaults to None.
        block_device_mappings(List, optional): A block device mapping, which specifies the block devices for the instance. You can specify
            virtual devices and EBS volumes. For more information, see Block Device Mapping in the Amazon
            EC2 User Guide for Linux Instances. Defaults to None.
        instance_monitoring(Dict, optional): Controls whether instances in this group are launched with detailed (true) or basic (false)
            monitoring. The default value is true (enabled).  When detailed monitoring is enabled, Amazon
            CloudWatch generates metrics every minute and your account is charged a fee. When you disable
            detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see
            Configure Monitoring for Auto Scaling Instances in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        spot_price(Text, optional): The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot
            Instances are launched when the price you specify exceeds the current Spot price. For more
            information, see Requesting Spot Instances in the Amazon EC2 Auto Scaling User Guide.  When you
            change your maximum price by creating a new launch configuration, running instances will
            continue to run as long as the maximum price for those running instances is higher than the
            current Spot price. Defaults to None.
        iam_instance_profile(Text, optional): The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role
            for the instance. The instance profile contains the IAM role. For more information, see IAM role
            for applications that run on Amazon EC2 instances in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        ebs_optimized(bool, optional): Specifies whether the launch configuration is optimized for EBS I/O (true) or not (false). The
            optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to
            provide optimal I/O performance. This optimization is not available with all instance types.
            Additional fees are incurred when you enable EBS optimization for an instance type that is not
            EBS-optimized by default. For more information, see Amazon EBS-optimized instances in the Amazon
            EC2 User Guide for Linux Instances. The default value is false. Defaults to None.
        associate_public_ip_address(bool, optional): For Auto Scaling groups that are running in a virtual private cloud (VPC), specifies whether to
            assign a public IP address to the group's instances. If you specify true, each instance in the
            Auto Scaling group receives a unique public IP address. For more information, see Launching Auto
            Scaling instances in a VPC in the Amazon EC2 Auto Scaling User Guide. If you specify this
            parameter, you must specify at least one subnet for VPCZoneIdentifier when you create your
            group.  If the instance is launched into a default subnet, the default is to assign a public IP
            address, unless you disabled the option to assign a public IP address on the subnet. If the
            instance is launched into a nondefault subnet, the default is not to assign a public IP address,
            unless you enabled the option to assign a public IP address on the subnet. Defaults to None.
        placement_tenancy(Text, optional): The tenancy of the instance. An instance with dedicated tenancy runs on isolated, single-tenant
            hardware and can only be launched into a VPC. To launch dedicated instances into a shared
            tenancy VPC (a VPC with the instance placement tenancy attribute set to default), you must set
            the value of this parameter to dedicated. If you specify PlacementTenancy, you must specify at
            least one subnet for VPCZoneIdentifier when you create your group. For more information, see
            Configuring instance tenancy with Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User
            Guide. Valid Values: default | dedicated. Defaults to None.
        metadata_options(Dict, optional): The metadata options for the instances. For more information, see Configuring the Instance
            Metadata Options in the Amazon EC2 Auto Scaling User Guide. Defaults to None.

    Request Syntax:
       [launch_configuration-resource-id]:
              aws.autoscaling.launch_configuration.present:
              - name: 'string'
              - resource_id: 'string'
              - image_id: 'string'
              - key_name: 'string'
              - security_groups: List
              - classic_link_vpc_id: 'string'
              - classic_link_vpc_security_groups: List
              - user_data: 'string'
              - instance_type: 'string'
              - kernel_id: aki-02b79b47
              - ramdisk_id: 'string'
              - block_device_mappings: List
              - instance_monitoring: Dict
              - spot_price: 'string'
              - iam_instance_profile: 'string'
              - ebs_optimized: true/false
              - metadata_options: Dict
                          - associate_public_ip_address: true/false

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            idem-test-launch_configuration:
              aws.autoscaling.launch_configuration.present:
              - name: idem-test-launch_configuration
              - resource_id: idem-test-launch_configuration
              - image_id: ami-73949613
              - key_name: test-n
              - security_groups:
                - sg-00bbd7b8d31f6bcad
                - sg-03064434ef6546344
              - classic_link_vpc_id: vpc-123456
              - classic_link_vpc_security_groups:
                - sg-00bbd7b8d31f6abcd
                - sg-03064434ef6541111
              - user_data: /etc/eks/bootstrap.sh
              - instance_type: t2.micro
              - kernel_id: aki-02b79b47
              - ramdisk_id: ari-177e2d52
              - block_device_mappings:
                - DeviceName: /dev/sda1
                  Ebs:
                    DeleteOnTermination: false
                    Encrypted: false
                    SnapshotId: snap-0526fa8583b2ef05f
                    VolumeSize: 8
                    VolumeType: gp2
                - DeviceName: /dev/sda
                  Ebs:
                    DeleteOnTermination: false
                    Encrypted: false
                    SnapshotId: snap-05cfe4be1b16a2e0f
                    VolumeSize: 8
                    VolumeType: gp2
              - instance_monitoring:
                  Enabled: true
              - spot_price: '0.045'
              - iam_instance_profile: arn:aws:iam::537227425989:instance-profile/aws-elasticbeanstalk-ec2-role
              - ebs_optimized: true
              - associate_public_ip_address: true
              - metadata_options:
                  HttpEndpoint: enabled
                  HttpPutResponseHopLimit: 64
                  HttpTokens: optional

    """

    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)
    launch_configuration_created = False
    before = None
    desired_state = {
        "name": name,
        "resource_id": name,
        "image_id": image_id,
        "key_name": key_name,
        "security_groups": security_groups,
        "classic_link_vpc_id": classic_link_vpc_id,
        "classic_link_vpc_security_groups": classic_link_vpc_security_groups,
        "user_data": user_data,
        "instance_id": instance_id,
        "instance_type": instance_type,
        "kernel_id": kernel_id,
        "ramdisk_id": ramdisk_id,
        "block_device_mappings": block_device_mappings,
        "instance_monitoring": instance_monitoring,
        "spot_price": spot_price,
        "iam_instance_profile": iam_instance_profile,
        "ebs_optimized": ebs_optimized,
        "associate_public_ip_address": associate_public_ip_address,
        "placement_tenancy": placement_tenancy,
        "metadata_options": metadata_options,
    }

    launch_conf_args = {
        "LaunchConfigurationName": name,
        "ImageId": image_id,
        "KeyName": key_name,
        "SecurityGroups": security_groups,
        "ClassicLinkVPCId": classic_link_vpc_id,
        "ClassicLinkVPCSecurityGroups": classic_link_vpc_security_groups,
        "UserData": user_data,
        "InstanceId": instance_id,
        "InstanceType": instance_type,
        "KernelId": kernel_id,
        "RamdiskId": ramdisk_id,
        "BlockDeviceMappings": block_device_mappings,
        "InstanceMonitoring": instance_monitoring,
        "SpotPrice": spot_price,
        "IamInstanceProfile": iam_instance_profile,
        "EbsOptimized": ebs_optimized,
        "AssociatePublicIpAddress": associate_public_ip_address,
        "PlacementTenancy": placement_tenancy,
        "MetadataOptions": metadata_options,
    }

    if resource_id:
        before = await hub.exec.boto3.client.autoscaling.describe_launch_configurations(
            ctx, LaunchConfigurationNames=[resource_id]
        )

    # Launch Configurations cannot be updated after creation with the Amazon Web Service API.
    if before and before["ret"].get("LaunchConfigurations"):  # resource present
        result[
            "old_state"
        ] = hub.tool.aws.autoscaling.conversion_utils.convert_raw_launch_configuration_to_present(
            raw_resource=before["ret"]["LaunchConfigurations"][0],
            idem_resource_name=name,
        )
        result["comment"] = (
            f"aws.autoscaling.launch_configuration '{name}' already exists",
        )
        result["new_state"] = copy.deepcopy(result["old_state"])
        return result
    else:
        if ctx.get("test", False):
            result["new_state"] = hub.tool.aws.test_state_utils.generate_test_state(
                enforced_state={}, desired_state=desired_state
            )
            result["comment"] = (
                f"Would create aws.autoscaling.launch_configuration '{name}'",
            )
            return result

        try:
            ret = await hub.exec.boto3.client.autoscaling.create_launch_configuration(
                ctx,
                **launch_conf_args,
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result

            result["comment"] = (
                f"Created aws.autoscaling.launch_configuration '{name}'",
            )
            launch_configuration_created = True
            resource_id = name
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = result["comment"] + (f"{e.__class__.__name__}: {e}",)
            result["result"] = False

    try:
        if launch_configuration_created:
            after = (
                await hub.exec.boto3.client.autoscaling.describe_launch_configurations(
                    ctx, LaunchConfigurationNames=[resource_id]
                )
            )
            result[
                "new_state"
            ] = hub.tool.aws.autoscaling.conversion_utils.convert_raw_launch_configuration_to_present(
                raw_resource=after["ret"]["LaunchConfigurations"][0],
                idem_resource_name=name,
            )
    except Exception as e:
        result["comment"] = result["comment"] + (str(e),)
        result["result"] = False
    return result


async def absent(hub, ctx, name: str, resource_id: str = None) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes the specified launch configuration. The launch configuration must not be attached to an Auto Scaling
    group. When this call completes, the launch configuration is no longer available for use.

    Args:
        name(Text): The name of the launch configuration.
        resource_id(Text, optional): AWS launch configuration name. Idem automatically considers this resource being absent if
         this field is not specified.

    Request Syntax:
       [launch_configuration-resource-id]:
              aws.autoscaling.launch_configuration.absent:
              - name: 'string'
              - resource_id: 'string'

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            idem-test-launch_configuration:
              aws.autoscaling.launch_configuration.absent:
                - name: idem-test-launch_configuration
                - resource_id:idem-test-launch_configuration
    """

    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)
    if not resource_id:
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.autoscaling.launch_configuration", name=name
        )
        return result

    before = await hub.exec.boto3.client.autoscaling.describe_launch_configurations(
        ctx, LaunchConfigurationNames=[resource_id]
    )
    if not before["result"]:
        result["result"] = False
        result["comment"] = before["comment"]
        return result
    if not before["ret"].get("LaunchConfigurations"):
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.autoscaling.launch_configuration", name=name
        )
    else:
        result[
            "old_state"
        ] = hub.tool.aws.autoscaling.conversion_utils.convert_raw_launch_configuration_to_present(
            raw_resource=before["ret"]["LaunchConfigurations"][0],
            idem_resource_name=name,
        )

        if ctx.get("test", False):
            result["comment"] = hub.tool.aws.comment_utils.would_delete_comment(
                resource_type="aws.autoscaling.launch_configuration", name=name
            )
            return result

        try:
            ret = await hub.exec.boto3.client.autoscaling.delete_launch_configuration(
                ctx, LaunchConfigurationName=resource_id
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result
            result["comment"] = hub.tool.aws.comment_utils.delete_comment(
                resource_type="aws.autoscaling.launch_configuration", name=name
            )
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = result["comment"] + (f"{e.__class__.__name__}: {e}",)

    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function

    Gets information about the launch configurations in the account and Region.

    Returns:
        Dict[str, Dict[str, Any]]

    Examples:

        .. code-block:: bash

            $ idem describe aws.autoscaling.launch_configuration
    """

    result = {}
    ret = await hub.exec.boto3.client.autoscaling.describe_launch_configurations(ctx)

    if not ret["result"]:
        hub.log.debug(f"Could not describe launch_configuration {ret['comment']}")
        return {}

    for launch_configuration in ret["ret"].get("LaunchConfigurations"):
        resource_id = launch_configuration.get("LaunchConfigurationName")
        resource_translated = hub.tool.aws.autoscaling.conversion_utils.convert_raw_launch_configuration_to_present(
            raw_resource=launch_configuration, idem_resource_name=resource_id
        )
        result[resource_id] = {
            "aws.autoscaling.launch_configuration.present": [
                {parameter_key: parameter_value}
                for parameter_key, parameter_value in resource_translated.items()
            ]
        }

    return result
