# pollination Streamlit IO

Streamlit input/output components to use with Pollination apps. This library uses 
WebView2 technology to interact with the Pollination CAD plugins.

## Controls
* button.send = Send a ladybug geometry or a HBjson to Rhino.
* button.get = Get a ladybug geometry or a HBjson from Rhino.
* button.command = Run a Rhino command from inside Streamlit.
* inputs.send = Preview of a ladybug geometry to Rhino.
* special.sync = Generate a token to use with button.get. A token is generated by the target software and broadcasted to streamlit.

## UX (for developers)
It is easy to use.

How to show pollination controls only if platform is Rhino

### Example of url `https://my-special-app.something?__platform__=Rhino`
```python
from pollination_streamlit_io import special

# get host name
platform = special.get_host()

if platform == 'Rhino':
    # add your logic here with pollination_streamlit_io
```

### Example of mini-app Rhino > Streamlit

```python
import streamlit as st
from pollination_streamlit_io import button

st.subheader("Pollination, Get Pollination Model")
model = button.get(isHbModel=True, key="my-secret-key")
st.write(model)
```

### Example of mini-app Rhino > Streamlit

```python
import streamlit as st
import json
from pollination_streamlit_io import button
from pollination_streamlit_io import inputs

st.subheader("Pollination, Bake Geometry Button")

# array of ladybug geometry dictionaries or 
# a ladybug geometry dictionary
data_to_pass = [{
    "type": "Mesh3D",
    "vertices": [(0, 0, 0), (10, 0, 0), (0, 10, 0)],
    "faces": [(0, 1, 2)],
    "colors": [{"r": 255, "g": 0, "b": 0}]
}, 
{ 
    'type': 'Polyline2D',
     'vertices': [[5, 5], [35, 5], [5, 35]] 
}]

option = st.selectbox(
 "What command do you want to use?",
 ("BakeGeometry", "ClearGeometry", "DrawGeometry", "DisableDraw"))
command_active = button.send(option,
    data_to_pass, "my-secret-key", key="foo")
st.write("Command in action: %s !" % command_active)

preview_geo = inputs.send(option,
    data_to_pass, "my-secret-key-2", key="goo")
```

### Example of mini-app Streamlit > Rhino

```python
import streamlit as st
from pollination_streamlit_io import button

st.subheader("Pollination, Run a Rhino command")
name_input = st.text_input("Enter the command here!", value="PO_AddRooms")
command = button.command(commandString=name_input, key="my-secret-key")
st.write(command)
```

### Example of mini-app Rhino > Streamlit with Sync!

```python
import streamlit as st
from pollination_streamlit_io import (button,
    special)

# special controls
# ONLY ONE FOR APP
st.subheader('Pollination Token for Sync')
po_token = special.sync(key="my-po-sync")
st.write(po_token)

# common controls
st.subheader('Pollination, Get Geometry Button')
geometry = button.get(key='my-geometry',
    syncToken=po_token)
if geometry:
    st.write(geometry)
```

## Make (for developers)
Use `make generate-frontend` to create build from react

Use `make copy-build` to copy build from dev folder to the py package

Create a virtual env in tests folder. Install requirements.txt with `pip install -r requirements.txt`. Install the package in dev mode with `pip install -e ../.`

- TODO: update tests examples
