function mpc = GBnetwork
% UK network data obtained from following publically available source:
%
%   Reference:
%   [1] GB SQSS Reviw working group report. [Online]
%       http://www.nationalgrid.com/uk/Electricity/Codes/gbsqsscode/workinggroups/intgeneration/

%Data Stats: 2224 buses, 394 generators, 3207 branches

% Acknowledgement:
% Thanks to Manolis Belivanis, Strathclyde University for pointing out the
% source of data and helping out with details.
%   MATPOWER
%   $Id: case39.m,v 1.14 2010/03/10 18:08:13 ray Exp $


%% 
%  W. A. Bukhsh March 2013
%  send your questions and comments to : w.a.bukhsh@sms.ed.ac.uk


%%
mpc.version = '2';
mpc.baseMVA = 100;
%% Bus Data
mpc.bus = [
1	1	0.00	0.00	0.00	0.00	1	1.0493	-1.4690	275.00	1	1.06	0.94;
2	2	0.00	0.00	0.00	0.00	1	1.0530	2.7505	275.00	1	1.06	0.94;
3	2	0.00	0.00	0.00	0.00	1	1.0530	2.7905	275.00	1	1.06	0.94;
4	2	0.00	0.00	0.00	0.00	1	1.0530	2.7451	275.00	1	1.06	0.94;
5	1	0.00	0.00	0.00	0.00	1	1.0420	0.3483	275.00	1	1.06	0.94;
6	2	0.00	0.00	0.00	0.00	1	1.0530	11.9795	275.00	1	1.06	0.94;
7	2	0.00	0.00	0.00	0.00	1	1.0530	11.9991	275.00	1	1.06	0.94;
8	1	0.00	0.00	0.00	0.00	1	1.0479	2.3561	275.00	1	1.06	0.94;
9	2	0.00	0.00	0.00	0.00	1	1.0530	13.7786	275.00	1	1.06	0.94;
10	2	0.00	0.00	0.00	0.00	1	1.0530	13.9344	275.00	1	1.06	0.94;
11	2	0.00	0.00	0.00	0.00	1	1.0530	13.9670	275.00	1	1.06	0.94;
12	2	0.00	0.00	0.00	0.00	1	1.0530	12.4827	275.00	1	1.06	0.94;
13	2	0.00	0.00	0.00	0.00	1	1.0530	15.9216	275.00	1	1.06	0.94;
14	1	7.79	21.52	0.00	0.00	1	1.0530	17.1884	400.00	1	1.06	0.94;
15	2	0.00	0.00	0.00	0.00	1	1.0530	21.5384	400.00	1	1.06	0.94;
16	2	0.00	0.00	0.00	0.00	1	1.0530	21.4533	400.00	1	1.06	0.94;
17	2	0.00	0.00	0.00	0.00	1	1.0530	21.4673	400.00	1	1.06	0.94;
18	2	0.00	0.00	0.00	0.00	1	1.0530	21.4446	400.00	1	1.06	0.94;
19	1	0.00	0.00	0.00	0.00	1	1.0481	16.7492	400.00	1	1.06	0.94;
20	2	0.00	0.00	0.00	0.00	1	1.0530	27.0498	400.00	1	1.06	0.94;
21	2	0.00	0.00	0.00	0.00	1	1.0530	27.0498	400.00	1	1.06	0.94;
22	2	0.00	0.00	0.00	0.00	1	1.0530	21.8639	400.00	1	1.06	0.94;
23	1	0.00	0.00	0.00	0.00	1	1.0522	-2.1979	400.00	1	1.06	0.94;
24	2	0.00	0.00	0.00	0.00	1	1.0530	2.2708	400.00	1	1.06	0.94;
25	2	0.00	0.00	0.00	0.00	1	1.0530	2.1618	400.00	1	1.06	0.94;
26	1	0.00	0.00	0.00	0.00	1	1.0530	0.2692	400.00	1	1.06	0.94;
27	2	0.00	0.00	0.00	0.00	1	1.0530	4.5396	400.00	1	1.06	0.94;
28	2	0.00	0.00	0.00	0.00	1	1.0530	4.6972	400.00	1	1.06	0.94;
29	1	0.00	0.00	0.00	0.00	1	1.0492	22.7018	400.00	1	1.06	0.94;
30	2	0.00	0.00	0.00	0.00	1	1.0530	29.5434	400.00	1	1.06	0.94;
31	2	0.00	0.00	0.00	0.00	1	1.0530	29.5434	400.00	1	1.06	0.94;
32	2	0.00	0.00	0.00	0.00	1	1.0530	29.5434	400.00	1	1.06	0.94;
33	2	0.00	0.00	0.00	0.00	1	1.0530	29.5434	400.00	1	1.06	0.94;
34	2	0.00	0.00	0.00	0.00	1	1.0530	29.5434	400.00	1	1.06	0.94;
35	2	0.00	0.00	0.00	0.00	1	1.0102	22.7018	400.00	1	1.06	0.94;
36	1	0.00	0.00	0.00	0.00	1	1.0530	19.6662	400.00	1	1.06	0.94;
37	2	0.00	0.00	0.00	0.00	1	1.0530	22.6393	400.00	1	1.06	0.94;
38	2	0.00	0.00	0.00	0.00	1	1.0530	22.6239	400.00	1	1.06	0.94;
39	2	0.00	0.00	0.00	0.00	1	1.0530	22.6900	400.00	1	1.06	0.94;
40	1	0.00	0.00	0.00	0.00	1	1.0526	18.9980	400.00	1	1.06	0.94;
41	2	0.00	0.00	0.00	0.00	1	1.0530	21.8870	400.00	1	1.06	0.94;
42	2	0.00	0.00	0.00	0.00	1	1.0530	21.9118	400.00	1	1.06	0.94;
43	2	0.00	0.00	0.00	0.00	1	1.0530	21.8837	400.00	1	1.06	0.94;
44	1	0.00	0.00	0.00	0.00	1	1.0506	-2.2249	400.00	1	1.06	0.94;
45	2	0.00	0.00	0.00	0.00	1	1.0530	1.1939	400.00	1	1.06	0.94;
46	2	0.00	0.00	0.00	0.00	1	1.0530	1.2109	400.00	1	1.06	0.94;
47	1	0.00	0.00	0.00	0.00	1	1.0508	17.7893	400.00	1	1.06	0.94;
48	2	0.00	0.00	0.00	0.00	1	1.0530	21.6306	400.00	1	1.06	0.94;
49	2	0.00	0.00	0.00	0.00	1	1.0530	21.9700	400.00	1	1.06	0.94;
50	1	15.98	11.47	0.00	0.00	1	1.0512	18.7796	400.00	1	1.06	0.94;
51	2	0.00	0.00	0.00	0.00	1	1.0530	22.6605	400.00	1	1.06	0.94;
52	2	0.00	0.00	0.00	0.00	1	1.0530	22.8792	400.00	1	1.06	0.94;
53	1	0.00	0.00	0.00	0.00	1	1.0231	-10.6942	400.00	1	1.06	0.94;
54	2	0.00	0.00	0.00	0.00	1	1.0055	-10.6942	400.00	1	1.06	0.94;
55	2	0.00	0.00	0.00	0.00	1	1.0055	-10.6942	400.00	1	1.06	0.94;
56	1	0.00	0.00	0.00	0.00	1	1.0529	15.6078	275.00	1	1.06	0.94;
57	2	0.00	0.00	0.00	0.00	1	1.0530	19.9553	275.00	1	1.06	0.94;
58	1	0.00	0.00	0.00	0.00	1	1.0529	15.7090	275.00	1	1.06	0.94;
59	2	0.00	0.00	0.00	0.00	1	1.0530	20.1519	275.00	1	1.06	0.94;
60	1	0.00	0.00	0.00	0.00	1	1.0439	13.7887	275.00	1	1.06	0.94;
61	2	0.00	0.00	0.00	0.00	1	1.0530	18.1498	275.00	1	1.06	0.94;
62	2	0.00	0.00	0.00	0.00	1	1.0530	19.9965	275.00	1	1.06	0.94;
63	1	0.00	0.00	0.00	0.00	1	1.0476	21.1867	275.00	1	1.06	0.94;
64	2	0.00	0.00	0.00	0.00	1	1.0530	34.9748	275.00	1	1.06	0.94;
65	2	0.00	0.00	0.00	0.00	1	1.0351	28.2008	275.00	1	1.06	0.94;
66	1	0.00	0.00	0.00	0.00	1	1.0530	16.3628	275.00	1	1.06	0.94;
67	2	0.00	0.00	0.00	0.00	1	1.0530	20.8923	275.00	1	1.06	0.94;
68	1	0.00	0.00	0.00	0.00	1	1.0530	16.3222	275.00	1	1.06	0.94;
69	2	0.00	0.00	0.00	0.00	1	1.0530	20.8527	275.00	1	1.06	0.94;
70	1	0.00	0.00	0.00	0.00	1	1.0530	15.3043	275.00	1	1.06	0.94;
71	2	0.00	0.00	0.00	0.00	1	1.0530	19.8131	275.00	1	1.06	0.94;
72	1	0.00	0.00	0.00	0.00	1	1.0530	15.3142	275.00	1	1.06	0.94;
73	2	0.00	0.00	0.00	0.00	1	1.0530	19.6272	275.00	1	1.06	0.94;
74	1	15.83	10.93	0.00	0.00	1	1.0515	0.8361	400.00	1	1.06	0.94;
75	2	0.00	0.00	0.00	0.00	1	1.0017	0.8361	400.00	1	1.06	0.94;
76	2	0.00	0.00	0.00	0.00	1	1.0017	0.8361	400.00	1	1.06	0.94;
77	2	0.00	0.00	0.00	0.00	1	1.0017	0.8361	400.00	1	1.06	0.94;
78	2	0.00	0.00	0.00	0.00	1	1.0017	0.8361	400.00	1	1.06	0.94;
79	1	0.00	0.00	0.00	0.00	1	1.0530	23.1218	275.00	1	1.06	0.94;
80	2	0.00	0.00	0.00	0.00	1	1.0530	26.4538	275.00	1	1.06	0.94;
81	2	0.00	0.00	0.00	0.00	1	1.0530	26.4620	275.00	1	1.06	0.94;
82	1	0.00	0.00	0.00	0.00	1	1.0530	18.0486	400.00	1	1.06	0.94;
83	2	0.00	0.00	0.00	0.00	1	1.0530	21.2460	400.00	1	1.06	0.94;
84	2	0.00	0.00	0.00	0.00	1	1.0530	21.2899	400.00	1	1.06	0.94;
85	2	0.00	0.00	0.00	0.00	1	1.0530	21.1733	400.00	1	1.06	0.94;
86	2	0.00	0.00	0.00	0.00	1	1.0530	21.1327	400.00	1	1.06	0.94;
87	1	0.00	0.00	0.00	0.00	1	1.0525	-8.7622	400.00	1	1.06	0.94;
88	2	0.00	0.00	0.00	0.00	1	1.0530	-5.1993	400.00	1	1.06	0.94;
89	2	0.00	0.00	0.00	0.00	1	1.0530	-5.3311	400.00	1	1.06	0.94;
90	1	0.00	0.00	0.00	2.02	1	1.0478	6.3877	400.00	1	1.06	0.94;
91	2	0.00	0.00	0.00	0.00	1	1.0530	10.8167	400.00	1	1.06	0.94;
92	2	0.00	0.00	0.00	0.00	1	1.0530	10.9454	400.00	1	1.06	0.94;
93	1	0.00	0.00	0.00	0.00	1	1.0514	23.3416	400.00	1	1.06	0.94;
94	2	0.00	0.00	0.00	0.00	1	1.0530	31.5402	400.00	1	1.06	0.94;
95	1	0.00	0.00	0.00	0.00	1	1.0501	23.1662	400.00	1	1.06	0.94;
96	2	0.00	0.00	0.00	0.00	1	1.0530	31.0070	400.00	1	1.06	0.94;
97	2	0.00	0.00	0.00	0.00	1	1.0530	31.0025	400.00	1	1.06	0.94;
98	1	0.00	0.00	0.00	0.00	1	1.0528	27.9944	400.00	1	1.06	0.94;
99	2	0.00	0.00	0.00	0.00	1	1.0530	36.0731	400.00	1	1.06	0.94;
100	2	0.00	0.00	0.00	0.00	1	1.0530	35.3815	400.00	1	1.06	0.94;
101	2	0.00	0.00	0.00	0.00	1	1.0530	36.0097	400.00	1	1.06	0.94;
102	2	0.00	0.00	0.00	0.00	1	1.0530	36.0097	400.00	1	1.06	0.94;
103	2	0.00	0.00	0.00	0.00	1	1.0530	36.0522	400.00	1	1.06	0.94;
104	2	0.00	0.00	0.00	0.00	1	1.0530	36.0522	400.00	1	1.06	0.94;
105	2	0.00	0.00	0.00	0.00	1	1.0530	35.8842	400.00	1	1.06	0.94;
106	2	0.00	0.00	0.00	0.00	1	1.0530	35.8842	400.00	1	1.06	0.94;
107	2	0.00	0.00	0.00	0.00	1	1.0530	35.8842	400.00	1	1.06	0.94;
108	2	0.00	0.00	0.00	0.00	1	1.0530	35.0714	400.00	1	1.06	0.94;
109	1	0.00	0.00	0.00	0.00	1	1.0524	1.2090	400.00	1	1.06	0.94;
110	2	0.00	0.00	0.00	0.00	1	1.0530	5.7289	400.00	1	1.06	0.94;
111	2	0.00	0.00	0.00	0.00	1	1.0530	5.7216	400.00	1	1.06	0.94;
112	1	0.00	0.00	0.00	0.00	1	1.0529	2.6686	400.00	1	1.06	0.94;
113	2	0.00	0.00	0.00	0.00	1	1.0530	6.9404	400.00	1	1.06	0.94;
114	2	0.00	0.00	0.00	0.00	1	1.0530	7.2157	400.00	1	1.06	0.94;
115	1	0.00	0.00	0.00	0.00	1	1.0524	8.9462	400.00	1	1.06	0.94;
116	2	0.00	0.00	0.00	0.00	1	1.0530	19.2041	400.00	1	1.06	0.94;
117	2	0.00	0.00	0.00	0.00	1	1.0530	19.1290	400.00	1	1.06	0.94;
118	2	0.00	0.00	0.00	0.00	1	1.0530	17.1037	400.00	1	1.06	0.94;
119	1	0.00	0.00	0.00	0.00	1	1.0460	-2.1519	400.00	1	1.06	0.94;
120	2	0.00	0.00	0.00	0.00	1	1.0530	0.9816	400.00	1	1.06	0.94;
121	2	0.00	0.00	0.00	0.00	1	1.0530	0.9579	400.00	1	1.06	0.94;
122	2	0.00	0.00	0.00	0.00	1	0.9997	-2.1519	400.00	1	1.06	0.94;
123	1	0.00	0.00	0.00	0.00	1	1.0514	1.0567	400.00	1	1.06	0.94;
124	2	0.00	0.00	0.00	0.00	1	1.0530	9.3374	400.00	1	1.06	0.94;
125	2	0.00	0.00	0.00	0.00	1	1.0530	9.3159	400.00	1	1.06	0.94;
126	2	0.00	0.00	0.00	0.00	1	1.0530	9.3830	400.00	1	1.06	0.94;
127	1	0.00	0.00	0.00	0.00	1	1.0461	5.9997	400.00	1	1.06	0.94;
128	2	0.00	0.00	0.00	0.00	1	1.0530	10.3951	400.00	1	1.06	0.94;
129	2	0.00	0.00	0.00	0.00	1	1.0530	9.1593	400.00	1	1.06	0.94;
130	1	0.00	0.00	0.00	0.00	1	1.0397	5.4684	400.00	1	1.06	0.94;
131	2	0.00	0.00	0.00	0.00	1	1.0530	8.6387	400.00	1	1.06	0.94;
132	2	0.00	0.00	0.00	0.00	1	1.0530	9.4284	400.00	1	1.06	0.94;
133	1	17.68	0.00	0.00	0.00	1	1.0530	5.0631	400.00	1	1.06	0.94;
134	2	0.00	0.00	0.00	0.00	1	1.0530	9.0113	400.00	1	1.06	0.94;
135	2	0.00	0.00	0.00	0.00	1	1.0530	8.9487	400.00	1	1.06	0.94;
136	1	0.00	0.00	0.00	0.00	1	1.0495	4.8068	400.00	1	1.06	0.94;
137	2	0.00	0.00	0.00	0.00	1	1.0530	13.4631	400.00	1	1.06	0.94;
138	2	0.00	0.00	0.00	0.00	1	1.0530	12.6489	400.00	1	1.06	0.94;
139	2	0.00	0.00	0.00	0.00	1	1.0530	13.5123	400.00	1	1.06	0.94;
140	2	0.00	0.00	0.00	0.00	1	1.0530	11.9276	400.00	1	1.06	0.94;
141	1	4.50	3.37	0.00	0.00	1	1.0530	5.7220	400.00	1	1.06	0.94;
142	2	0.00	0.00	0.00	0.00	1	1.0530	8.9705	400.00	1	1.06	0.94;
143	2	0.00	0.00	0.00	0.00	1	1.0530	8.9792	400.00	1	1.06	0.94;
144	1	0.00	0.00	0.00	0.00	1	1.0479	32.4623	275.00	1	1.06	0.94;
145	2	0.00	0.00	0.00	0.00	1	1.0530	45.0702	275.00	1	1.06	0.94;
146	2	0.00	0.00	0.00	0.00	1	1.0530	45.1787	275.00	1	1.06	0.94;
147	2	0.00	0.00	0.00	0.00	1	1.0530	45.1787	275.00	1	1.06	0.94;
148	2	0.00	0.00	0.00	0.00	1	1.0530	45.2316	275.00	1	1.06	0.94;
149	1	0.00	0.00	0.00	0.00	1	1.0479	32.4371	275.00	1	1.06	0.94;
150	2	0.00	0.00	0.00	0.00	1	1.0530	45.0672	275.00	1	1.06	0.94;
151	2	0.00	0.00	0.00	0.00	1	1.0530	45.1873	275.00	1	1.06	0.94;
152	2	0.00	0.00	0.00	0.00	1	1.0530	45.0672	275.00	1	1.06	0.94;
153	2	0.00	0.00	0.00	0.00	1	1.0530	45.1361	275.00	1	1.06	0.94;
154	2	0.00	0.00	0.00	0.00	1	1.0530	39.0635	275.00	1	1.06	0.94;
155	2	0.00	0.00	0.00	0.00	1	1.0530	39.1243	275.00	1	1.06	0.94;
156	2	0.00	0.00	0.00	0.00	1	1.0058	32.4623	275.00	1	1.06	0.94;
157	1	0.00	0.00	0.00	0.00	1	1.0500	1.8604	275.00	1	1.06	0.94;
158	2	0.00	0.00	0.00	0.00	1	0.9915	1.8604	275.00	1	1.06	0.94;
159	2	0.00	0.00	0.00	0.00	1	1.0530	8.6966	275.00	1	1.06	0.94;
160	1	0.00	0.00	0.00	0.00	1	1.0530	2.4134	275.00	1	1.06	0.94;
161	2	0.00	0.00	0.00	0.00	1	1.0530	9.3013	275.00	1	1.06	0.94;
162	2	0.00	0.00	0.00	0.00	1	1.0530	9.2162	275.00	1	1.06	0.94;
163	1	0.00	0.00	0.00	0.00	1	1.0530	17.6886	400.00	1	1.06	0.94;
164	2	0.00	0.00	0.00	0.00	1	1.0530	21.8145	400.00	1	1.06	0.94;
165	2	0.00	0.00	0.00	0.00	1	1.0530	21.8422	400.00	1	1.06	0.94;
166	2	0.00	0.00	0.00	0.00	1	1.0530	21.8683	400.00	1	1.06	0.94;
167	2	0.00	0.00	0.00	0.00	1	1.0530	21.8466	400.00	1	1.06	0.94;
168	1	0.00	0.00	0.00	0.00	1	1.0458	23.4949	400.00	1	1.06	0.94;
169	2	0.00	0.00	0.00	0.00	1	1.0530	30.7823	400.00	1	1.06	0.94;
170	2	0.00	0.00	0.00	0.00	1	1.0530	30.9603	400.00	1	1.06	0.94;
171	2	0.00	0.00	0.00	0.00	1	1.0530	30.7184	400.00	1	1.06	0.94;
172	2	0.00	0.00	0.00	0.00	1	1.0530	30.5500	400.00	1	1.06	0.94;
173	1	0.00	0.00	0.00	0.00	1	1.0530	16.9947	400.00	1	1.06	0.94;
174	2	0.00	0.00	0.00	0.00	1	1.0530	22.8854	400.00	1	1.06	0.94;
175	2	0.00	0.00	0.00	0.00	1	1.0530	22.8936	400.00	1	1.06	0.94;
176	2	0.00	0.00	0.00	0.00	1	1.0530	22.9215	400.00	1	1.06	0.94;
177	2	0.00	0.00	0.00	0.00	1	1.0530	22.9100	400.00	1	1.06	0.94;
178	2	0.00	0.00	0.00	0.00	1	1.0530	8.0184	400.00	1	1.06	0.94;
179	2	0.00	0.00	0.00	0.00	1	1.0530	8.0184	400.00	1	1.06	0.94;
180	2	0.00	0.00	0.00	0.00	1	1.0530	7.5806	400.00	1	1.06	0.94;
181	1	0.00	0.00	0.00	0.00	1	1.0485	-13.1392	400.00	1	1.06	0.94;
182	2	0.00	0.00	0.00	0.00	1	1.0092	-13.1392	400.00	1	1.06	0.94;
183	1	0.00	0.00	0.00	0.00	1	1.0530	28.9168	400.00	1	1.06	0.94;
184	2	0.00	0.00	0.00	0.00	1	1.0530	37.7580	400.00	1	1.06	0.94;
185	2	0.00	0.00	0.00	0.00	1	1.0530	37.7861	400.00	1	1.06	0.94;
186	2	0.00	0.00	0.00	0.00	1	1.0530	37.7472	400.00	1	1.06	0.94;
187	2	0.00	0.00	0.00	0.00	1	1.0530	35.8613	400.00	1	1.06	0.94;
188	2	0.00	0.00	0.00	0.00	1	1.0530	5.6204	400.00	1	1.06	0.94;
189	2	0.00	0.00	0.00	0.00	1	1.0530	5.6369	400.00	1	1.06	0.94;
190	2	0.00	0.00	0.00	0.00	1	1.0530	5.1976	400.00	1	1.06	0.94;
191	2	0.00	0.00	0.00	0.00	1	1.0530	37.9702	400.00	1	1.06	0.94;
192	2	0.00	0.00	0.00	0.00	1	1.0530	37.9992	400.00	1	1.06	0.94;
193	2	0.00	0.00	0.00	0.00	1	1.0530	37.6688	400.00	1	1.06	0.94;
194	1	125.64	71.00	0.00	0.00	1	1.0523	17.2388	400.00	1	1.06	0.94;
195	2	0.00	0.00	0.00	0.00	1	1.0530	24.0269	400.00	1	1.06	0.94;
196	2	0.00	0.00	0.00	0.00	1	1.0530	24.0269	400.00	1	1.06	0.94;
197	2	0.00	0.00	0.00	0.00	1	1.0530	24.0269	400.00	1	1.06	0.94;
198	1	0.00	0.00	0.00	0.00	1	1.0530	12.0447	400.00	1	1.06	0.94;
199	2	0.00	0.00	0.00	0.00	1	1.0530	19.0745	400.00	1	1.06	0.94;
200	2	0.00	0.00	0.00	0.00	1	1.0530	19.0745	400.00	1	1.06	0.94;
201	2	0.00	0.00	0.00	0.00	1	1.0530	19.1015	400.00	1	1.06	0.94;
202	1	0.00	0.00	0.00	0.00	1	1.0524	-2.2953	400.00	1	1.06	0.94;
203	2	0.00	0.00	0.00	0.00	1	1.0530	5.3073	400.00	1	1.06	0.94;
204	2	0.00	0.00	0.00	0.00	1	1.0530	5.3073	400.00	1	1.06	0.94;
205	2	0.00	0.00	0.00	0.00	1	1.0530	5.3073	400.00	1	1.06	0.94;
206	2	0.00	0.00	0.00	0.00	1	1.0530	2.8685	400.00	1	1.06	0.94;
207	1	0.00	0.00	0.00	0.00	1	1.0458	-3.0504	275.00	1	1.06	0.94;
208	2	0.00	0.00	0.00	0.00	1	1.0530	2.6974	275.00	1	1.06	0.94;
209	2	0.00	0.00	0.00	0.00	1	1.0530	7.4485	275.00	1	1.06	0.94;
210	1	0.00	0.00	0.00	0.00	1	1.0530	14.9121	400.00	1	1.06	0.94;
211	2	0.00	0.00	0.00	0.00	1	1.0530	22.1565	400.00	1	1.06	0.94;
212	2	0.00	0.00	0.00	0.00	1	1.0530	22.1565	400.00	1	1.06	0.94;
213	2	0.00	0.00	0.00	0.00	1	1.0530	20.2484	400.00	1	1.06	0.94;
214	1	0.00	0.00	0.00	0.00	1	1.0530	2.7151	400.00	1	1.06	0.94;
215	2	0.00	0.00	0.00	0.00	1	1.0530	9.6174	400.00	1	1.06	0.94;
216	2	0.00	0.00	0.00	0.00	1	1.0530	9.6174	400.00	1	1.06	0.94;
217	2	0.00	0.00	0.00	0.00	1	1.0530	9.6174	400.00	1	1.06	0.94;
218	1	0.00	0.00	0.00	0.00	1	1.0526	3.2622	400.00	1	1.06	0.94;
219	2	0.00	0.00	0.00	0.00	1	1.0530	9.7382	400.00	1	1.06	0.94;
220	2	0.00	0.00	0.00	0.00	1	1.0530	9.7382	400.00	1	1.06	0.94;
221	2	0.00	0.00	0.00	0.00	1	1.0530	9.7382	400.00	1	1.06	0.94;
222	2	0.00	0.00	0.00	0.00	1	1.0530	21.3444	400.00	1	1.06	0.94;
223	1	94.00	27.45	0.00	0.00	1	1.0496	25.5487	275.00	1	1.06	0.94;
224	2	0.00	0.00	0.00	0.00	1	1.0530	31.1894	275.00	1	1.06	0.94;
225	2	0.00	0.00	0.00	0.00	1	1.0530	31.1894	275.00	1	1.06	0.94;
226	2	0.00	0.00	0.00	0.00	1	1.0530	31.1894	275.00	1	1.06	0.94;
227	1	0.00	0.00	0.00	0.00	1	1.0526	-12.1201	400.00	1	1.06	0.94;
228	2	0.00	0.00	0.00	0.00	1	1.0154	-6.8950	400.00	1	1.06	0.94;
229	2	0.00	0.00	0.00	0.00	1	1.0154	-6.8949	400.00	1	1.06	0.94;
230	1	0.00	0.00	0.00	0.00	1	1.0530	-2.1197	400.00	1	1.06	0.94;
231	2	0.00	0.00	0.00	0.00	1	1.0530	2.9064	400.00	1	1.06	0.94;
232	2	0.00	0.00	0.00	0.00	1	1.0530	2.9064	400.00	1	1.06	0.94;
233	1	0.00	0.00	0.00	0.00	1	1.0530	27.2879	132.00	1	1.06	0.94;
234	2	0.00	0.00	0.00	0.00	1	1.0530	31.0219	132.00	1	1.06	0.94;
235	2	0.00	0.00	0.00	0.00	1	1.0530	31.0219	132.00	1	1.06	0.94;
236	2	0.00	0.00	0.00	0.00	1	1.0530	31.1068	132.00	1	1.06	0.94;
237	2	0.00	0.00	0.00	0.00	1	1.0530	31.1068	132.00	1	1.06	0.94;
238	2	0.00	0.00	0.00	0.00	1	1.0530	31.1068	132.00	1	1.06	0.94;
239	2	0.00	0.00	0.00	0.00	1	1.0530	31.1068	132.00	1	1.06	0.94;
240	1	0.00	0.00	0.00	0.00	1	1.0530	27.9225	400.00	1	1.06	0.94;
241	2	0.00	0.00	0.00	0.00	1	1.0530	35.0318	400.00	1	1.06	0.94;
242	2	0.00	0.00	0.00	0.00	1	1.0530	35.0318	400.00	1	1.06	0.94;
243	2	0.00	0.00	0.00	0.00	1	1.0530	37.4518	400.00	1	1.06	0.94;
244	2	0.00	0.00	0.00	0.00	1	1.0530	37.4518	400.00	1	1.06	0.94;
245	1	216.40	82.94	0.00	1.09	1	1.0381	-11.1281	132.00	1	1.06	0.94;
246	1	0.00	0.00	0.00	0.00	1	0.9989	-11.1281	132.00	1	1.06	0.94;
247	1	0.00	0.00	0.00	0.00	1	0.9989	-11.1281	132.00	1	1.06	0.94;
248	1	4.48	2.82	0.00	0.00	1	1.0530	-1.9361	132.00	1	1.06	0.94;
249	2	0.00	0.00	0.00	0.00	1	1.0530	5.3670	132.00	1	1.06	0.94;
250	1	0.00	0.00	0.00	0.00	1	1.0530	-2.2854	132.00	1	1.06	0.94;
251	2	0.00	0.00	0.00	0.00	1	1.0530	3.2808	132.00	1	1.06	0.94;
252	1	0.00	0.00	0.00	0.00	1	1.0522	34.8895	132.00	1	1.06	0.94;
253	2	0.00	0.00	0.00	0.00	1	1.0530	40.6549	132.00	1	1.06	0.94;
254	2	0.00	0.00	0.00	0.00	1	1.0530	42.8441	132.00	1	1.06	0.94;
255	1	34.12	12.37	0.00	0.00	1	1.0524	36.6108	132.00	1	1.06	0.94;
256	2	0.00	0.00	0.00	0.00	1	1.0530	43.6615	132.00	1	1.06	0.94;
257	2	0.00	0.00	0.00	0.00	1	1.0530	43.6496	132.00	1	1.06	0.94;
258	2	0.00	0.00	0.00	0.00	1	1.0530	43.6500	132.00	1	1.06	0.94;
259	2	0.00	0.00	0.00	0.00	1	1.0530	43.0678	132.00	1	1.06	0.94;
260	1	0.00	0.00	0.00	0.00	1	1.0507	-12.2399	132.00	1	1.06	0.94;
261	2	0.00	0.00	0.00	0.00	1	1.0530	-5.8125	132.00	1	1.06	0.94;
262	1	215.10	100.69	0.00	0.00	1	1.0527	19.0987	132.00	1	1.06	0.94;
263	2	0.00	0.00	0.00	0.00	1	1.0530	26.5964	132.00	1	1.06	0.94;
264	2	0.00	0.00	0.00	0.00	1	1.0530	26.6349	132.00	1	1.06	0.94;
265	2	0.00	0.00	0.00	0.00	1	1.0530	26.6930	132.00	1	1.06	0.94;
266	1	233.46	69.25	0.00	0.19	1	0.9470	-12.6423	132.00	1	1.06	0.94;
267	1	0.00	0.00	0.00	0.00	1	0.9751	-12.6423	132.00	1	1.06	0.94;
268	1	0.00	0.00	0.00	0.00	1	0.9751	-12.6423	132.00	1	1.06	0.94;
269	1	386.67	122.03	0.00	0.03	1	1.0420	-0.5611	132.00	1	1.06	0.94;
270	2	0.00	0.00	0.00	0.00	1	1.0530	5.7465	132.00	1	1.06	0.94;
271	1	5.84	3.02	0.00	0.00	1	1.0530	-0.6098	132.00	1	1.06	0.94;
272	2	0.00	0.00	0.00	0.00	1	1.0530	9.1139	132.00	1	1.06	0.94;
273	2	0.00	0.00	0.00	0.00	1	1.0530	7.5934	132.00	1	1.06	0.94;
274	1	267.83	96.23	0.00	0.09	1	1.0198	1.8406	132.00	1	1.06	0.94;
275	2	0.00	0.00	0.00	0.00	1	1.0530	11.8007	132.00	1	1.06	0.94;
276	2	0.00	0.00	0.00	0.00	1	1.0530	11.8007	132.00	1	1.06	0.94;
277	2	0.00	0.00	0.00	0.00	1	1.0530	11.8007	132.00	1	1.06	0.94;
278	1	0.00	0.00	0.00	0.00	1	1.0347	24.7717	400.00	1	1.06	0.94;
279	1	0.00	0.00	0.00	0.00	1	1.0466	29.3245	400.00	1	1.06	0.94;
280	1	0.00	0.00	0.00	0.00	1	1.0530	22.6796	400.00	1	1.06	0.94;
281	1	0.00	0.00	0.00	0.00	1	1.0499	19.5467	400.00	1	1.06	0.94;
282	1	0.00	0.00	0.00	0.00	1	1.0495	22.2161	400.00	1	1.06	0.94;
283	1	0.00	0.00	0.00	0.00	1	1.0321	14.0328	400.00	1	1.06	0.94;
284	1	0.00	0.00	0.00	0.00	1	1.0432	16.0210	400.00	1	1.06	0.94;
285	1	0.00	0.00	0.00	0.00	1	1.0506	17.9239	400.00	1	1.06	0.94;
286	1	0.00	0.00	0.00	0.00	1	1.0505	17.9160	400.00	1	1.06	0.94;
287	1	0.00	0.00	0.00	0.00	1	1.0277	12.0143	400.00	1	1.06	0.94;
288	1	0.00	0.00	0.00	0.00	1	1.0283	12.0834	400.00	1	1.06	0.94;
289	1	0.00	0.00	0.00	0.00	1	1.0478	15.8517	400.00	1	1.06	0.94;
290	1	0.00	0.00	0.00	0.00	1	1.0521	19.0503	400.00	1	1.06	0.94;
291	1	0.00	0.00	0.00	2.02	1	1.0476	14.5506	400.00	1	1.06	0.94;
292	1	0.00	0.00	0.00	0.00	1	1.0497	15.9542	400.00	1	1.06	0.94;
293	1	0.00	0.00	0.00	0.00	1	1.0529	19.9635	400.00	1	1.06	0.94;
294	1	0.00	0.00	0.00	0.00	1	1.0530	19.6846	400.00	1	1.06	0.94;
295	1	0.00	0.00	0.00	0.00	1	1.0277	12.0124	400.00	1	1.06	0.94;
296	1	0.00	0.00	0.00	0.00	1	1.0521	17.1690	400.00	1	1.06	0.94;
297	1	0.00	0.00	0.00	0.00	1	1.0319	10.1237	400.00	1	1.06	0.94;
298	1	0.00	0.00	0.00	0.00	1	1.0377	14.3839	400.00	1	1.06	0.94;
299	1	0.00	0.00	0.00	0.00	1	1.0400	14.5108	400.00	1	1.06	0.94;
300	1	0.00	0.00	0.00	0.00	1	1.0285	12.1900	400.00	1	1.06	0.94;
301	1	0.00	0.00	0.00	0.00	1	1.0206	12.0631	400.00	1	1.06	0.94;
302	1	0.00	0.00	0.00	0.00	1	1.0447	12.9880	400.00	1	1.06	0.94;
303	1	0.00	0.00	0.00	0.00	1	1.0452	13.0933	400.00	1	1.06	0.94;
304	1	0.00	0.00	0.00	0.00	1	1.0460	13.7537	400.00	1	1.06	0.94;
305	1	0.00	0.00	0.00	0.00	1	1.0466	16.7781	400.00	1	1.06	0.94;
306	1	0.00	0.00	0.00	0.00	1	1.0466	16.7739	400.00	1	1.06	0.94;
307	1	0.00	0.00	0.00	0.00	1	1.0462	16.7386	400.00	1	1.06	0.94;
308	1	0.00	0.00	0.00	0.00	1	1.0462	16.7345	400.00	1	1.06	0.94;
309	1	0.00	0.00	0.00	0.00	1	1.0522	16.8248	400.00	1	1.06	0.94;
310	1	0.00	0.00	0.00	0.00	1	1.0493	16.8061	400.00	1	1.06	0.94;
311	1	0.00	0.00	0.00	0.00	1	1.0529	23.2268	400.00	1	1.06	0.94;
312	1	0.00	0.00	0.00	0.00	1	1.0328	15.3401	400.00	1	1.06	0.94;
313	1	0.00	0.00	0.00	0.00	1	1.0266	14.7165	400.00	1	1.06	0.94;
314	1	0.00	0.00	0.00	0.00	1	1.0334	15.4024	400.00	1	1.06	0.94;
315	1	0.00	0.00	0.00	0.00	1	1.0428	17.2104	400.00	1	1.06	0.94;
316	1	0.00	0.00	0.00	0.00	1	1.0512	23.3214	400.00	1	1.06	0.94;
317	1	0.00	0.00	0.00	0.00	1	1.0509	27.6722	400.00	1	1.06	0.94;
318	1	0.00	0.00	0.00	0.00	1	1.0501	23.1425	400.00	1	1.06	0.94;
319	1	0.00	0.00	0.00	0.00	1	1.0495	22.7701	400.00	1	1.06	0.94;
320	1	0.00	0.00	0.00	0.00	1	1.0530	21.3814	400.00	1	1.06	0.94;
321	1	0.00	0.00	0.00	0.00	1	1.0469	23.3926	400.00	1	1.06	0.94;
322	1	0.00	0.00	0.00	0.00	1	1.0485	23.7031	400.00	1	1.06	0.94;
323	1	0.00	0.00	0.00	0.00	1	1.0530	21.5778	400.00	1	1.06	0.94;
324	1	0.00	0.00	0.00	0.00	1	1.0508	17.6026	400.00	1	1.06	0.94;
325	1	0.00	0.00	0.00	0.00	1	1.0530	25.8259	400.00	1	1.06	0.94;
326	1	0.00	0.00	0.00	0.00	1	1.0407	17.0750	400.00	1	1.06	0.94;
327	1	0.00	0.00	0.00	0.00	1	1.0513	18.7911	400.00	1	1.06	0.94;
328	1	0.00	0.00	0.00	0.00	1	1.0497	17.1694	400.00	1	1.06	0.94;
329	1	0.00	0.00	0.00	0.00	1	1.0521	21.6518	400.00	1	1.06	0.94;
330	1	0.00	0.00	0.00	0.00	1	1.0514	21.6359	400.00	1	1.06	0.94;
331	1	0.00	0.00	0.00	0.00	1	1.0510	23.8393	400.00	1	1.06	0.94;
332	1	0.00	0.00	0.00	0.00	1	1.0443	15.1457	400.00	1	1.06	0.94;
333	1	0.00	0.00	0.00	0.00	1	1.0501	23.7743	400.00	1	1.06	0.94;
334	1	0.00	0.00	0.00	0.00	1	1.0407	14.7074	400.00	1	1.06	0.94;
335	1	0.00	0.00	0.00	0.00	1	1.0520	18.4597	400.00	1	1.06	0.94;
336	1	0.00	0.00	0.00	0.00	1	1.0493	17.1236	400.00	1	1.06	0.94;
337	1	0.00	0.00	0.00	0.00	1	1.0188	14.7027	400.00	1	1.06	0.94;
338	1	0.00	0.00	0.00	0.00	1	1.0277	12.8409	400.00	1	1.06	0.94;
339	1	0.00	0.00	0.00	0.00	1	1.0348	24.8110	400.00	1	1.06	0.94;
340	1	0.00	0.00	0.00	0.00	1	1.0466	29.3276	400.00	1	1.06	0.94;
341	1	0.00	0.00	0.00	0.00	1	1.0460	15.3924	400.00	1	1.06	0.94;
342	1	0.00	0.00	0.00	0.00	1	1.0480	13.5318	400.00	1	1.06	0.94;
343	1	0.00	0.00	0.00	2.02	1	1.0349	5.8183	400.00	1	1.06	0.94;
344	1	0.00	0.00	0.00	0.00	1	1.0416	12.9598	400.00	1	1.06	0.94;
345	1	0.00	0.00	0.00	2.02	1	1.0384	3.5961	400.00	1	1.06	0.94;
346	1	17.04	0.00	0.00	0.00	1	1.0408	2.0029	400.00	1	1.06	0.94;
347	2	0.00	0.00	0.00	2.02	1	1.0419	0.3629	400.00	1	1.06	0.94;
348	2	0.00	0.00	0.00	2.02	1	1.0394	4.7810	400.00	1	1.06	0.94;
349	1	17.04	0.00	0.00	0.00	1	1.0407	2.0042	400.00	1	1.06	0.94;
350	1	0.00	0.00	0.00	0.00	1	1.0431	10.9318	400.00	1	1.06	0.94;
351	1	0.00	0.00	0.00	2.02	1	1.0480	14.9138	400.00	1	1.06	0.94;
352	2	0.00	0.00	0.00	2.02	1	1.0444	3.2269	400.00	1	1.06	0.94;
353	2	0.00	0.00	0.00	2.02	1	1.0477	2.8693	400.00	1	1.06	0.94;
354	1	0.00	0.00	0.00	0.00	1	1.0514	8.8013	400.00	1	1.06	0.94;
355	1	14.61	0.00	0.00	0.00	1	1.0429	1.7631	400.00	1	1.06	0.94;
356	1	0.00	0.00	0.00	0.00	1	1.0530	21.2059	400.00	1	1.06	0.94;
357	1	0.00	0.00	0.00	0.00	1	1.0530	21.2059	400.00	1	1.06	0.94;
358	1	0.00	0.00	0.00	0.00	1	1.0503	11.7188	400.00	1	1.06	0.94;
359	2	0.00	0.00	0.00	2.02	1	1.0358	7.0250	400.00	1	1.06	0.94;
360	1	0.00	0.00	0.00	2.02	1	1.0351	4.4452	400.00	1	1.06	0.94;
361	1	0.00	0.00	0.00	2.02	1	1.0431	3.9151	400.00	1	1.06	0.94;
362	1	0.00	0.00	0.00	0.00	1	1.0410	4.9838	400.00	1	1.06	0.94;
363	1	0.00	0.00	0.00	0.00	1	1.0408	4.9125	400.00	1	1.06	0.94;
364	2	0.00	0.00	0.00	2.02	1	1.0375	1.5642	400.00	1	1.06	0.94;
365	1	0.00	0.00	0.00	0.00	1	1.0354	1.7008	400.00	1	1.06	0.94;
366	1	0.00	0.00	0.00	0.00	1	1.0345	-0.1205	400.00	1	1.06	0.94;
367	1	0.00	0.00	0.00	0.00	1	1.0497	12.6507	400.00	1	1.06	0.94;
368	1	0.00	0.00	0.00	0.00	1	1.0399	-2.6053	400.00	1	1.06	0.94;
369	1	0.00	0.00	0.00	0.00	1	1.0405	-4.3113	400.00	1	1.06	0.94;
370	1	0.00	0.00	0.00	0.00	1	1.0490	12.6122	400.00	1	1.06	0.94;
371	1	0.00	0.00	0.00	0.00	1	1.0453	7.7575	400.00	1	1.06	0.94;
372	1	9.98	0.00	0.00	2.02	1	1.0467	5.6156	400.00	1	1.06	0.94;
373	1	0.00	0.00	0.00	0.00	1	1.0474	7.8581	400.00	1	1.06	0.94;
374	2	0.00	0.00	0.00	0.00	1	1.0501	5.0668	400.00	1	1.06	0.94;
375	1	12.66	0.00	0.00	0.00	1	1.0440	0.7672	400.00	1	1.06	0.94;
376	1	0.00	0.00	0.00	0.00	1	1.0530	-2.7610	400.00	1	1.06	0.94;
377	1	0.00	0.00	0.00	0.00	1	1.0522	-3.3180	400.00	1	1.06	0.94;
378	1	12.66	0.00	0.00	0.00	1	1.0463	1.1938	400.00	1	1.06	0.94;
379	1	0.00	0.00	0.00	0.00	1	1.0392	-1.7795	400.00	1	1.06	0.94;
380	1	0.00	0.00	0.00	0.00	1	1.0377	-2.8868	400.00	1	1.06	0.94;
381	1	0.00	0.00	0.00	0.00	1	1.0525	-3.2377	400.00	1	1.06	0.94;
382	1	0.00	0.00	0.00	0.00	1	1.0529	-2.9886	400.00	1	1.06	0.94;
383	1	0.00	0.00	0.00	0.00	1	1.0525	-3.2367	400.00	1	1.06	0.94;
384	1	0.00	0.00	0.00	0.00	1	1.0529	-2.9904	400.00	1	1.06	0.94;
385	1	0.00	0.00	0.00	0.00	1	1.0357	-2.1334	400.00	1	1.06	0.94;
386	1	0.00	0.00	0.00	0.00	1	1.0341	-3.4719	400.00	1	1.06	0.94;
387	1	0.00	0.00	0.00	0.00	1	1.0490	4.4334	400.00	1	1.06	0.94;
388	1	0.00	0.00	0.00	0.00	1	1.0490	3.8641	400.00	1	1.06	0.94;
389	1	0.00	0.00	0.00	0.00	1	1.0487	3.5705	400.00	1	1.06	0.94;
390	1	14.61	0.00	0.00	0.00	1	1.0486	2.2093	400.00	1	1.06	0.94;
391	1	0.00	0.00	0.00	0.00	1	1.0418	3.4255	400.00	1	1.06	0.94;
392	1	0.00	0.00	0.00	0.00	1	1.0379	4.5300	400.00	1	1.06	0.94;
393	1	0.00	0.00	0.00	0.00	1	1.0467	2.9909	400.00	1	1.06	0.94;
394	1	0.00	0.00	0.00	0.00	1	1.0366	7.4253	400.00	1	1.06	0.94;
395	1	0.00	0.00	0.00	0.00	1	1.0462	3.4652	400.00	1	1.06	0.94;
396	1	0.97	0.10	0.00	0.00	1	1.0486	-1.1203	400.00	1	1.06	0.94;
397	1	0.00	0.00	0.00	0.00	1	1.0487	-1.8556	400.00	1	1.06	0.94;
398	1	0.00	0.00	0.00	0.00	1	1.0505	2.7162	400.00	1	1.06	0.94;
399	1	0.00	0.00	0.00	0.00	1	1.0524	2.4676	400.00	1	1.06	0.94;
400	1	0.00	0.00	0.00	0.00	1	1.0487	0.2750	400.00	1	1.06	0.94;
401	1	0.00	0.00	0.00	0.00	1	1.0508	0.1684	400.00	1	1.06	0.94;
402	1	0.00	0.00	0.00	0.00	1	1.0465	-2.0418	400.00	1	1.06	0.94;
403	1	0.00	0.00	0.00	0.00	1	1.0465	-2.0409	400.00	1	1.06	0.94;
404	1	7.54	1.06	0.00	0.00	1	1.0498	0.5176	400.00	1	1.06	0.94;
405	2	0.00	0.00	0.00	0.00	1	1.0367	-5.2851	400.00	1	1.06	0.94;
406	1	0.00	0.00	0.00	2.02	1	1.0231	-8.0109	400.00	1	1.06	0.94;
407	1	0.00	0.00	0.00	0.00	1	1.0509	-0.5238	400.00	1	1.06	0.94;
408	2	0.00	1127.00	0.00	9.10	1	1.0530	-0.9892	400.00	1	1.06	0.94;
409	1	0.00	0.00	0.00	0.00	1	1.0509	-0.1928	400.00	1	1.06	0.94;
410	1	0.00	0.00	0.00	0.00	1	1.0442	-3.2891	400.00	1	1.06	0.94;
411	1	0.00	0.00	0.00	0.00	1	1.0424	-3.7166	400.00	1	1.06	0.94;
412	2	0.00	0.00	0.00	2.02	1	1.0233	-10.1380	400.00	1	1.06	0.94;
413	1	0.00	0.00	0.00	0.00	1	1.0506	-3.2078	400.00	1	1.06	0.94;
414	1	0.00	0.00	0.00	0.00	1	1.0458	-3.5361	400.00	1	1.06	0.94;
415	1	0.00	0.00	0.00	0.00	1	1.0433	-5.2375	400.00	1	1.06	0.94;
416	1	0.00	0.00	0.00	0.00	1	1.0530	-2.7242	400.00	1	1.06	0.94;
417	1	0.00	0.00	0.00	0.00	1	1.0457	-3.5442	400.00	1	1.06	0.94;
418	1	0.00	0.00	0.00	0.00	1	1.0458	-3.5437	400.00	1	1.06	0.94;
419	1	0.00	0.00	0.00	0.00	1	1.0518	-12.1975	400.00	1	1.06	0.94;
420	1	0.00	0.00	0.00	0.00	1	1.0459	-3.4300	400.00	1	1.06	0.94;
421	1	0.00	0.00	0.00	0.00	1	1.0415	-12.5128	400.00	1	1.06	0.94;
422	2	0.00	0.00	0.00	0.00	1	1.0312	-12.6855	400.00	1	1.06	0.94;
423	1	0.00	0.00	0.00	0.00	1	1.0506	-12.6382	400.00	1	1.06	0.94;
424	1	0.00	0.00	0.00	0.00	1	1.0515	-12.2962	400.00	1	1.06	0.94;
425	2	0.00	0.00	0.00	0.00	1	1.0523	-11.9259	400.00	1	1.06	0.94;
426	1	0.00	0.00	0.00	0.00	1	1.0517	-12.1267	400.00	1	1.06	0.94;
427	1	0.00	0.00	0.00	0.00	1	1.0530	-10.4102	400.00	1	1.06	0.94;
428	1	0.00	0.00	0.00	2.02	1	1.0257	-8.1355	400.00	1	1.06	0.94;
429	1	0.00	0.00	0.00	0.00	1	1.0216	-10.7591	400.00	1	1.06	0.94;
430	1	0.00	0.00	0.00	0.00	1	1.0229	-10.5548	400.00	1	1.06	0.94;
431	3	0.00	0.00	0.00	0.00	1	1.0507	0.0000	400.00	1	1.06	0.94;
432	1	0.00	0.00	0.00	0.00	1	1.0520	0.1468	400.00	1	1.06	0.94;
433	1	0.00	0.00	0.00	0.00	1	1.0327	-6.7531	400.00	1	1.06	0.94;
434	1	0.00	0.00	0.00	0.00	1	1.0253	-11.5344	400.00	1	1.06	0.94;
435	1	0.00	0.00	0.00	0.00	1	1.0450	-12.6315	400.00	1	1.06	0.94;
436	1	0.00	0.00	0.00	0.00	1	1.0407	-12.6543	400.00	1	1.06	0.94;
437	1	0.00	0.00	0.00	0.00	1	1.0515	-10.4908	400.00	1	1.06	0.94;
438	1	0.00	0.00	0.00	0.00	1	1.0514	-12.2986	400.00	1	1.06	0.94;
439	2	0.00	0.00	0.00	0.00	1	1.0516	-12.6326	400.00	1	1.06	0.94;
440	1	0.00	0.00	0.00	0.00	1	1.0501	-3.8230	400.00	1	1.06	0.94;
441	1	0.00	0.00	0.00	0.00	1	1.0248	-8.2016	400.00	1	1.06	0.94;
442	1	0.00	0.00	0.00	0.00	1	1.0342	-8.0002	400.00	1	1.06	0.94;
443	1	0.00	0.00	0.00	0.00	1	1.0528	24.4552	275.00	1	1.06	0.94;
444	2	0.00	0.00	0.00	1.35	1	1.0518	23.8647	275.00	1	1.06	0.94;
445	1	0.00	0.00	0.00	0.00	1	1.0477	13.7905	275.00	1	1.06	0.94;
446	1	0.00	0.00	0.00	0.00	1	1.0476	13.6112	275.00	1	1.06	0.94;
447	1	0.00	0.00	0.00	0.00	1	1.0492	14.6183	275.00	1	1.06	0.94;
448	1	0.00	0.00	0.00	0.00	1	1.0455	14.3845	275.00	1	1.06	0.94;
449	1	0.00	0.00	0.00	0.00	1	1.0528	16.4447	275.00	1	1.06	0.94;
450	1	0.00	0.00	0.00	0.00	1	1.0528	16.4208	275.00	1	1.06	0.94;
451	1	0.00	0.00	0.00	0.00	1	1.0499	13.1869	275.00	1	1.06	0.94;
452	1	0.00	0.00	0.00	1.35	1	1.0489	13.5835	275.00	1	1.06	0.94;
453	1	0.00	0.00	0.00	0.00	1	0.9924	10.2759	275.00	1	1.06	0.94;
454	1	0.00	0.00	0.00	1.35	1	0.9892	9.6986	275.00	1	1.06	0.94;
455	1	0.00	0.00	0.00	0.00	1	1.0512	13.2569	275.00	1	1.06	0.94;
456	1	0.00	0.00	0.00	0.00	1	1.0466	20.5395	275.00	1	1.06	0.94;
457	1	0.85	0.00	0.00	0.00	1	1.0465	20.5399	275.00	1	1.06	0.94;
458	1	0.00	0.00	0.00	0.00	1	1.0065	8.9248	275.00	1	1.06	0.94;
459	1	0.00	0.00	0.00	0.00	1	1.0019	8.3469	275.00	1	1.06	0.94;
460	1	0.00	0.00	0.00	0.00	1	0.9900	9.5037	275.00	1	1.06	0.94;
461	1	0.00	0.00	0.00	0.00	1	0.9998	11.2840	275.00	1	1.06	0.94;
462	1	0.00	0.00	0.00	0.00	1	1.0008	8.0125	275.00	1	1.06	0.94;
463	1	0.00	0.00	0.00	0.00	1	1.0019	8.3527	275.00	1	1.06	0.94;
464	1	0.00	0.00	0.00	0.00	1	1.0097	8.4532	275.00	1	1.06	0.94;
465	1	0.00	0.00	0.00	0.00	1	1.0439	15.2055	275.00	1	1.06	0.94;
466	1	0.00	0.00	0.00	0.00	1	1.0438	14.5102	275.00	1	1.06	0.94;
467	1	0.00	0.00	0.00	0.00	1	1.0443	14.9367	275.00	1	1.06	0.94;
468	1	0.00	0.00	0.00	0.00	1	1.0454	14.0194	275.00	1	1.06	0.94;
469	1	0.00	0.00	0.00	0.00	1	1.0442	14.9300	275.00	1	1.06	0.94;
470	1	0.00	0.00	0.00	0.00	1	1.0439	15.2045	275.00	1	1.06	0.94;
471	1	0.00	0.00	0.00	0.00	1	1.0350	21.7284	275.00	1	1.06	0.94;
472	1	0.00	0.00	0.00	0.00	1	1.0356	21.9070	275.00	1	1.06	0.94;
473	1	0.00	0.00	0.00	1.35	1	1.0306	22.1029	275.00	1	1.06	0.94;
474	1	0.00	0.00	0.00	0.00	1	1.0330	22.8923	275.00	1	1.06	0.94;
475	1	0.00	0.00	0.00	1.35	1	1.0371	22.3745	275.00	1	1.06	0.94;
476	1	0.00	0.00	0.00	0.00	1	1.0306	21.5263	275.00	1	1.06	0.94;
477	1	0.00	0.00	0.00	0.00	1	1.0350	21.6629	275.00	1	1.06	0.94;
478	1	0.00	0.00	0.00	0.00	1	1.0371	21.8682	275.00	1	1.06	0.94;
479	1	0.00	0.00	0.00	0.00	1	1.0407	22.2298	275.00	1	1.06	0.94;
480	1	0.00	0.00	0.00	0.00	1	1.0330	22.8912	275.00	1	1.06	0.94;
481	1	0.00	0.00	0.00	0.00	1	1.0461	22.5631	275.00	1	1.06	0.94;
482	1	0.00	0.00	0.00	0.00	1	1.0483	23.3122	275.00	1	1.06	0.94;
483	1	0.00	0.00	0.00	0.00	1	1.0492	23.2447	275.00	1	1.06	0.94;
484	1	0.00	0.00	0.00	0.00	1	1.0349	22.2126	275.00	1	1.06	0.94;
485	1	0.00	0.00	0.00	0.00	1	1.0410	22.5535	275.00	1	1.06	0.94;
486	1	0.00	0.00	0.00	0.00	1	1.0349	22.1110	275.00	1	1.06	0.94;
487	1	0.00	0.00	0.00	0.00	1	1.0482	23.3104	275.00	1	1.06	0.94;
488	1	0.00	0.00	0.00	0.00	1	1.0482	23.3104	275.00	1	1.06	0.94;
489	1	0.00	0.00	0.00	0.00	1	1.0469	22.6867	275.00	1	1.06	0.94;
490	1	0.00	0.00	0.00	0.00	1	1.0379	22.0328	275.00	1	1.06	0.94;
491	1	0.00	0.00	0.00	1.35	1	1.0503	15.4651	275.00	1	1.06	0.94;
492	1	0.00	0.00	0.00	0.00	1	1.0174	10.3740	275.00	1	1.06	0.94;
493	1	0.00	0.00	0.00	0.00	1	1.0204	11.0065	275.00	1	1.06	0.94;
494	1	0.00	0.00	0.00	0.00	1	1.0208	13.8985	275.00	1	1.06	0.94;
495	1	0.00	0.00	0.00	0.00	1	1.0082	12.1602	275.00	1	1.06	0.94;
496	1	0.00	0.00	0.00	0.00	1	1.0103	11.8558	275.00	1	1.06	0.94;
497	1	0.00	0.00	0.00	0.00	1	1.0210	11.5952	275.00	1	1.06	0.94;
498	1	0.00	0.00	0.00	0.00	1	1.0476	32.2843	275.00	1	1.06	0.94;
499	1	0.00	0.00	0.00	0.00	1	1.0477	32.3717	275.00	1	1.06	0.94;
500	1	0.00	0.00	0.00	0.00	1	1.0150	12.6859	275.00	1	1.06	0.94;
501	1	0.00	0.00	0.00	0.00	1	1.0122	12.4552	275.00	1	1.06	0.94;
502	1	0.00	0.00	0.00	0.00	1	1.0528	15.6199	275.00	1	1.06	0.94;
503	1	0.00	0.00	0.00	0.00	1	1.0527	15.8852	275.00	1	1.06	0.94;
504	1	0.00	0.00	0.00	0.00	1	1.0291	12.1762	275.00	1	1.06	0.94;
505	1	0.00	0.00	0.00	1.35	1	1.0289	12.5231	275.00	1	1.06	0.94;
506	1	0.00	0.00	0.00	1.35	1	1.0223	10.7585	275.00	1	1.06	0.94;
507	1	0.00	0.00	0.00	0.00	1	1.0476	32.3069	275.00	1	1.06	0.94;
508	1	0.00	0.00	0.00	0.00	1	1.0437	13.7623	275.00	1	1.06	0.94;
509	1	5.49	4.14	0.00	0.00	1	1.0511	15.2496	275.00	1	1.06	0.94;
510	1	0.00	0.00	0.00	0.00	1	1.0238	11.6698	275.00	1	1.06	0.94;
511	1	0.00	0.00	0.00	0.00	1	1.0227	11.5791	275.00	1	1.06	0.94;
512	1	0.00	0.00	0.00	0.00	1	1.0234	11.5789	275.00	1	1.06	0.94;
513	1	0.00	0.00	0.00	0.00	1	1.0218	11.5814	275.00	1	1.06	0.94;
514	1	0.00	0.00	0.00	0.00	1	1.0224	11.5751	275.00	1	1.06	0.94;
515	1	0.00	0.00	0.00	0.00	1	1.0218	11.5845	275.00	1	1.06	0.94;
516	1	0.00	0.00	0.00	0.00	1	1.0530	15.5979	275.00	1	1.06	0.94;
517	1	0.00	0.00	0.00	0.00	1	1.0226	11.4832	275.00	1	1.06	0.94;
518	1	0.00	0.00	0.00	0.00	1	1.0231	11.5649	275.00	1	1.06	0.94;
519	1	0.00	0.00	0.00	0.00	1	1.0145	12.6662	275.00	1	1.06	0.94;
520	1	0.00	0.00	0.00	0.00	1	1.0145	12.6657	275.00	1	1.06	0.94;
521	1	0.00	0.00	0.00	0.00	1	1.0228	11.4902	275.00	1	1.06	0.94;
522	2	0.00	0.00	0.00	0.00	1	1.0530	22.9320	275.00	1	1.06	0.94;
523	1	0.00	0.00	0.00	0.00	1	1.0450	22.9773	275.00	1	1.06	0.94;
524	1	0.00	0.00	0.00	0.00	1	1.0123	12.4431	275.00	1	1.06	0.94;
525	1	0.00	0.00	0.00	0.00	1	1.0495	25.4934	275.00	1	1.06	0.94;
526	1	0.00	0.00	0.00	0.00	1	1.0486	24.1285	275.00	1	1.06	0.94;
527	1	0.00	0.00	0.00	0.00	1	1.0486	24.1154	275.00	1	1.06	0.94;
528	1	0.00	0.00	0.00	0.00	1	1.0149	11.7301	275.00	1	1.06	0.94;
529	1	0.00	0.00	0.00	0.00	1	1.0267	13.0938	275.00	1	1.06	0.94;
530	1	0.00	0.00	0.00	0.00	1	1.0224	-1.1939	275.00	1	1.06	0.94;
531	1	0.00	0.00	0.00	0.00	1	1.0187	-1.8223	275.00	1	1.06	0.94;
532	1	0.00	0.00	0.00	0.00	1	1.0169	-2.5655	275.00	1	1.06	0.94;
533	2	0.00	0.00	0.00	0.00	1	1.0137	-3.2630	275.00	1	1.06	0.94;
534	1	0.00	0.00	0.00	1.35	1	1.0124	-3.4625	275.00	1	1.06	0.94;
535	2	0.00	0.00	0.00	0.00	1	1.0256	-2.6282	275.00	1	1.06	0.94;
536	1	0.00	0.00	0.00	1.35	1	1.0201	-2.7042	275.00	1	1.06	0.94;
537	1	0.00	0.00	0.00	0.00	1	1.0191	-2.7469	275.00	1	1.06	0.94;
538	1	0.00	0.00	0.00	0.00	1	1.0165	-1.4339	275.00	1	1.06	0.94;
539	1	0.00	0.00	0.00	0.00	1	1.0197	-1.6221	275.00	1	1.06	0.94;
540	1	0.00	0.00	0.00	0.00	1	1.0270	1.9239	275.00	1	1.06	0.94;
541	2	0.00	0.00	0.00	0.00	1	1.0315	0.0440	275.00	1	1.06	0.94;
542	1	0.00	0.00	0.00	1.35	1	1.0228	-1.3663	275.00	1	1.06	0.94;
543	1	0.00	0.00	0.00	0.00	1	1.0213	-2.8383	275.00	1	1.06	0.94;
544	2	0.00	0.00	0.00	0.00	1	1.0293	-2.2317	275.00	1	1.06	0.94;
545	1	0.00	0.00	0.00	0.00	1	1.0169	-2.8091	275.00	1	1.06	0.94;
546	2	0.00	0.00	0.00	0.00	1	1.0304	0.1019	275.00	1	1.06	0.94;
547	1	0.00	0.00	0.00	0.00	1	1.0217	-1.8288	275.00	1	1.06	0.94;
548	1	0.00	0.00	0.00	0.00	1	1.0217	-2.0074	275.00	1	1.06	0.94;
549	1	0.00	0.00	0.00	0.00	1	1.0341	2.3409	275.00	1	1.06	0.94;
550	1	0.00	0.00	0.00	0.00	1	1.0475	0.4780	275.00	1	1.06	0.94;
551	1	0.00	0.00	0.00	0.00	1	1.0490	0.8684	275.00	1	1.06	0.94;
552	1	0.00	0.00	0.00	0.00	1	1.0458	0.0052	275.00	1	1.06	0.94;
553	1	0.00	0.00	0.00	0.00	1	1.0493	0.2990	275.00	1	1.06	0.94;
554	1	0.00	0.00	0.00	0.00	1	1.0501	-0.3892	275.00	1	1.06	0.94;
555	1	0.00	0.00	0.00	0.00	1	1.0498	1.1161	275.00	1	1.06	0.94;
556	1	0.00	0.00	0.00	0.00	1	1.0505	1.2938	275.00	1	1.06	0.94;
557	1	0.00	0.00	0.00	0.00	1	1.0493	0.9521	275.00	1	1.06	0.94;
558	1	0.00	0.00	0.00	0.00	1	1.0505	0.6316	275.00	1	1.06	0.94;
559	1	0.00	0.00	0.00	0.00	1	1.0507	-0.2230	275.00	1	1.06	0.94;
560	2	0.00	0.00	0.00	0.00	1	1.0494	-1.0463	275.00	1	1.06	0.94;
561	1	0.00	0.00	0.00	0.00	1	1.0414	0.0028	275.00	1	1.06	0.94;
562	1	0.00	0.00	0.00	0.00	1	1.0449	-0.0431	275.00	1	1.06	0.94;
563	1	0.00	0.00	0.00	0.00	1	1.0473	1.8491	275.00	1	1.06	0.94;
564	1	0.00	0.00	0.00	0.00	1	1.0493	1.2120	275.00	1	1.06	0.94;
565	2	0.00	0.00	0.00	0.00	1	1.0494	-3.2904	275.00	1	1.06	0.94;
566	1	0.00	0.00	0.00	0.00	1	1.0496	-3.4523	275.00	1	1.06	0.94;
567	2	0.00	0.00	0.00	0.00	1	1.0521	-3.0291	275.00	1	1.06	0.94;
568	1	0.00	0.00	0.00	0.00	1	1.0508	-3.3454	275.00	1	1.06	0.94;
569	1	0.00	0.00	0.00	0.00	1	1.0488	0.9177	275.00	1	1.06	0.94;
570	1	0.00	0.00	0.00	0.00	1	1.0504	-3.2998	275.00	1	1.06	0.94;
571	1	0.00	0.00	0.00	0.00	1	1.0504	-3.2988	275.00	1	1.06	0.94;
572	2	0.00	0.00	0.00	0.00	1	1.0312	-7.0437	275.00	1	1.06	0.94;
573	1	0.00	0.00	0.00	0.00	1	1.0305	-7.1784	275.00	1	1.06	0.94;
574	2	0.00	0.00	0.00	0.00	1	1.0528	-3.6346	275.00	1	1.06	0.94;
575	1	0.00	0.00	0.00	0.00	1	1.0516	-3.8544	275.00	1	1.06	0.94;
576	1	0.00	0.00	0.00	0.00	1	1.0434	-0.4740	275.00	1	1.06	0.94;
577	1	0.00	0.00	0.00	0.00	1	1.0474	1.0050	275.00	1	1.06	0.94;
578	1	0.00	0.00	0.00	0.00	1	1.0480	0.6405	275.00	1	1.06	0.94;
579	1	0.00	0.00	0.00	0.00	1	1.0476	0.3682	275.00	1	1.06	0.94;
580	1	0.00	0.00	0.00	0.00	1	1.0451	-0.2215	275.00	1	1.06	0.94;
581	1	0.00	0.00	0.00	0.00	1	1.0452	-0.4020	275.00	1	1.06	0.94;
582	1	0.00	0.00	0.00	0.00	1	1.0528	-8.9873	275.00	1	1.06	0.94;
583	1	0.00	0.00	0.00	0.00	1	1.0520	-9.3446	275.00	1	1.06	0.94;
584	1	0.00	0.00	0.00	0.00	1	1.0528	-8.9873	275.00	1	1.06	0.94;
585	2	0.00	0.00	0.00	0.00	1	1.0259	-9.0033	275.00	1	1.06	0.94;
586	1	0.00	0.00	0.00	0.00	1	1.0468	-7.9965	275.00	1	1.06	0.94;
587	1	0.00	0.00	0.00	0.00	1	1.0493	-9.2937	275.00	1	1.06	0.94;
588	1	0.00	0.00	0.00	1.35	1	1.0455	-10.1355	275.00	1	1.06	0.94;
589	1	0.00	0.00	0.00	0.00	1	1.0462	-9.3833	275.00	1	1.06	0.94;
590	1	0.00	0.00	0.00	0.00	1	1.0462	-9.3796	275.00	1	1.06	0.94;
591	1	0.00	0.00	0.00	-1.00	1	1.0414	-11.1580	275.00	1	1.06	0.94;
592	1	0.00	0.00	0.00	0.00	1	1.0390	-11.1734	275.00	1	1.06	0.94;
593	1	0.00	0.00	0.00	0.00	1	1.0493	-10.4338	275.00	1	1.06	0.94;
594	1	0.00	0.00	0.00	0.00	1	1.0521	-9.4950	275.00	1	1.06	0.94;
595	1	0.00	0.00	0.00	0.00	1	1.0530	-9.4727	275.00	1	1.06	0.94;
596	1	0.00	0.00	0.00	0.00	1	1.0194	-9.9192	275.00	1	1.06	0.94;
597	1	0.00	0.00	0.00	0.00	1	1.0197	-9.4525	275.00	1	1.06	0.94;
598	1	0.00	0.00	0.00	1.35	1	1.0164	-9.7010	275.00	1	1.06	0.94;
599	1	0.00	0.00	0.00	1.35	1	1.0267	-10.5182	275.00	1	1.06	0.94;
600	1	0.00	0.00	0.00	0.00	1	1.0165	-9.7020	275.00	1	1.06	0.94;
601	1	0.00	0.00	0.00	0.00	1	1.0469	-9.0637	275.00	1	1.06	0.94;
602	1	0.00	0.00	0.00	0.00	1	1.0473	0.8348	275.00	1	1.06	0.94;
603	1	0.00	0.00	0.00	0.00	1	1.0437	-0.5635	275.00	1	1.06	0.94;
604	1	0.00	0.00	0.00	0.00	1	1.0453	-2.8535	275.00	1	1.06	0.94;
605	1	0.00	0.00	0.00	0.00	1	1.0444	-2.7848	275.00	1	1.06	0.94;
606	2	0.00	0.00	0.00	0.00	1	1.0482	-3.6603	275.00	1	1.06	0.94;
607	1	0.00	0.00	0.00	0.00	1	1.0453	-4.4718	275.00	1	1.06	0.94;
608	1	0.00	0.00	0.00	0.00	1	1.0455	-4.4527	275.00	1	1.06	0.94;
609	1	0.00	0.00	0.00	0.00	1	1.0530	-2.8822	275.00	1	1.06	0.94;
610	1	0.00	0.00	0.00	0.00	1	1.0530	-2.8822	275.00	1	1.06	0.94;
611	1	0.00	0.00	0.00	0.00	1	1.0467	-2.5147	275.00	1	1.06	0.94;
612	1	0.00	0.00	0.00	0.00	1	1.0471	-2.6224	275.00	1	1.06	0.94;
613	1	0.00	0.00	0.00	0.00	1	1.0455	-2.9460	275.00	1	1.06	0.94;
614	2	0.00	0.00	0.00	0.00	1	1.0476	-2.7353	275.00	1	1.06	0.94;
615	1	0.00	0.00	0.00	0.00	1	1.0505	-2.3180	275.00	1	1.06	0.94;
616	1	0.00	0.00	0.00	0.00	1	1.0504	-2.4711	275.00	1	1.06	0.94;
617	1	0.00	0.00	0.00	0.00	1	1.0355	-4.6111	275.00	1	1.06	0.94;
618	1	0.00	0.00	0.00	0.00	1	1.0495	-1.9751	275.00	1	1.06	0.94;
619	1	0.00	0.00	0.00	0.00	1	1.0504	-2.4198	275.00	1	1.06	0.94;
620	1	0.00	0.00	0.00	0.00	1	1.0510	-2.6168	275.00	1	1.06	0.94;
621	1	0.00	0.00	0.00	0.00	1	1.0507	-2.1859	275.00	1	1.06	0.94;
622	1	0.00	0.00	0.00	0.00	1	1.0424	-9.9400	275.00	1	1.06	0.94;
623	1	13.64	11.49	0.00	0.00	1	1.0450	-9.7072	275.00	1	1.06	0.94;
624	2	0.00	0.00	0.00	0.00	1	1.0529	-9.9609	275.00	1	1.06	0.94;
625	1	13.64	11.49	0.00	0.00	1	1.0530	-9.7146	275.00	1	1.06	0.94;
626	1	0.00	0.00	0.00	0.00	1	1.0507	-2.5220	275.00	1	1.06	0.94;
627	1	0.00	0.00	0.00	0.00	1	1.0506	-2.5257	275.00	1	1.06	0.94;
628	1	0.00	0.00	0.00	0.00	1	1.0503	-2.4637	275.00	1	1.06	0.94;
629	1	0.00	0.00	0.00	0.00	1	1.0524	12.7010	132.00	1	1.06	0.94;
630	1	74.02	10.52	0.00	0.00	1	1.0510	12.5010	132.00	1	1.06	0.94;
631	1	0.00	0.00	0.00	0.00	1	1.0530	13.0376	132.00	1	1.06	0.94;
632	1	268.67	0.00	0.00	0.54	1	1.0530	14.1011	66.00	1	1.06	0.94;
633	1	29.24	21.93	0.00	0.00	1	1.0524	22.4879	66.00	1	1.06	0.94;
634	1	8.50	6.40	0.00	0.00	1	1.0530	22.5021	66.00	1	1.06	0.94;
635	1	107.83	31.44	0.00	0.02	1	1.0530	18.6448	66.00	1	1.06	0.94;
636	1	97.78	24.49	0.00	0.00	1	1.0530	18.4220	66.00	1	1.06	0.94;
637	1	78.96	23.03	0.00	0.00	1	1.0530	13.4869	66.00	1	1.06	0.94;
638	1	125.33	49.54	0.00	0.00	1	1.0530	8.5756	66.00	1	1.06	0.94;
639	1	0.00	0.00	0.00	0.01	1	0.9942	15.1460	66.00	1	1.06	0.94;
640	1	190.82	62.70	0.00	0.01	1	1.0530	7.5906	66.00	1	1.06	0.94;
641	1	328.70	131.29	0.00	0.08	1	1.0530	-7.1271	66.00	1	1.06	0.94;
642	1	139.27	28.24	0.00	0.21	1	1.0530	-10.1360	66.00	1	1.06	0.94;
643	1	0.00	0.00	0.00	0.00	1	0.9470	-7.0426	66.00	1	1.06	0.94;
644	1	164.26	47.92	0.00	0.33	1	1.0530	-5.2457	66.00	1	1.06	0.94;
645	1	210.95	96.13	0.00	0.66	1	1.0530	-13.2693	66.00	1	1.06	0.94;
646	1	0.00	0.00	0.00	0.00	1	1.0530	-9.4948	66.00	1	1.06	0.94;
647	1	263.24	71.58	0.00	0.21	1	1.0530	-15.5906	66.00	1	1.06	0.94;
648	1	217.28	63.40	0.00	0.24	1	1.0530	-16.9735	66.00	1	1.06	0.94;
649	1	217.28	63.40	0.00	0.10	1	1.0530	-17.1508	66.00	1	1.06	0.94;
650	1	124.66	70.61	0.00	0.00	1	1.0530	-7.1142	66.00	1	1.06	0.94;
651	1	0.00	0.00	0.00	0.00	1	1.0441	15.3987	275.00	1	1.06	0.94;
652	1	0.00	0.00	0.00	0.00	1	1.0408	17.0749	275.00	1	1.06	0.94;
653	1	0.00	0.00	0.00	0.00	1	1.0323	13.7890	275.00	1	1.06	0.94;
654	1	13.57	10.10	0.00	0.00	1	1.0498	-2.2809	275.00	1	1.06	0.94;
655	1	81.42	31.98	0.00	0.00	1	0.9968	24.0696	132.00	1	1.06	0.94;
656	1	60.86	28.51	0.00	0.00	1	1.0068	22.9699	132.00	1	1.06	0.94;
657	1	-40.95	39.50	0.00	0.13	1	1.0530	18.6367	132.00	1	1.06	0.94;
658	1	77.81	23.40	0.00	0.07	1	1.0009	11.9100	132.00	1	1.06	0.94;
659	1	85.51	23.16	0.00	0.08	1	1.0015	12.9228	132.00	1	1.06	0.94;
660	1	217.67	31.36	0.00	0.58	1	1.0474	9.8691	132.00	1	1.06	0.94;
661	1	217.67	31.36	0.00	0.24	1	1.0530	9.6992	132.00	1	1.06	0.94;
662	1	163.62	46.75	0.00	0.03	1	1.0248	10.5467	132.00	1	1.06	0.94;
663	1	163.62	46.75	0.00	0.59	1	1.0200	10.4576	132.00	1	1.06	0.94;
664	1	323.35	50.64	0.00	1.09	1	1.0530	8.8830	132.00	1	1.06	0.94;
665	1	272.70	38.86	0.00	0.80	1	1.0530	9.0132	132.00	1	1.06	0.94;
666	1	125.64	71.00	0.00	0.00	1	1.0469	15.5967	132.00	1	1.06	0.94;
667	1	260.04	67.30	0.00	0.15	1	1.0530	10.3019	132.00	1	1.06	0.94;
668	1	344.67	87.65	0.00	0.23	1	1.0530	18.4471	132.00	1	1.06	0.94;
669	1	163.44	55.72	0.00	0.13	1	1.0530	14.7501	132.00	1	1.06	0.94;
670	1	0.00	0.00	0.00	0.00	1	1.0276	22.2163	132.00	1	1.06	0.94;
671	1	59.28	0.00	0.00	0.25	1	0.9470	18.6254	132.00	1	1.06	0.94;
672	1	0.00	0.00	0.00	0.00	1	0.9987	9.6989	132.00	1	1.06	0.94;
673	1	314.78	82.88	0.00	0.44	1	1.0530	1.8924	132.00	1	1.06	0.94;
674	1	312.73	109.37	0.00	0.29	1	1.0398	1.5561	132.00	1	1.06	0.94;
675	1	250.01	84.44	0.00	0.32	1	1.0530	3.0162	132.00	1	1.06	0.94;
676	1	220.30	82.59	0.00	0.03	1	1.0530	8.9153	132.00	1	1.06	0.94;
677	1	356.46	115.41	0.00	0.90	1	1.0530	-0.6869	132.00	1	1.06	0.94;
678	1	347.70	103.53	0.00	0.88	1	1.0530	2.2880	132.00	1	1.06	0.94;
679	1	0.00	0.00	0.00	0.00	1	1.0002	8.3469	132.00	1	1.06	0.94;
680	1	384.61	138.10	0.00	0.27	1	1.0530	5.0309	132.00	1	1.06	0.94;
681	1	110.05	42.17	0.00	0.00	1	1.0235	7.1299	132.00	1	1.06	0.94;
682	1	267.05	94.37	0.00	0.15	1	1.0530	6.5502	132.00	1	1.06	0.94;
683	1	0.00	0.00	0.00	0.00	1	1.0177	15.3814	132.00	1	1.06	0.94;
684	1	0.00	0.00	0.00	0.00	1	1.0530	16.2978	132.00	1	1.06	0.94;
685	1	123.20	47.14	0.00	0.00	1	1.0519	9.8439	132.00	1	1.06	0.94;
686	1	123.20	47.14	0.00	0.00	1	1.0444	8.9700	132.00	1	1.06	0.94;
687	1	201.96	50.63	0.00	0.35	1	1.0530	18.5947	132.00	1	1.06	0.94;
688	1	253.14	83.16	0.00	0.12	1	1.0530	18.1723	132.00	1	1.06	0.94;
689	1	137.24	54.24	0.00	0.08	1	1.0530	24.6526	132.00	1	1.06	0.94;
690	1	244.91	61.41	0.00	0.08	1	1.0530	18.4508	132.00	1	1.06	0.94;
691	1	-5.48	-1.64	0.00	0.23	1	1.0530	22.8052	132.00	1	1.06	0.94;
692	1	0.00	0.00	0.00	0.00	1	1.0057	15.7098	132.00	1	1.06	0.94;
693	1	267.90	97.20	0.00	0.24	1	1.0530	6.6201	132.00	1	1.06	0.94;
694	1	179.54	45.03	0.00	0.15	1	1.0530	6.0522	132.00	1	1.06	0.94;
695	1	173.90	57.15	0.00	0.26	1	1.0530	6.2787	132.00	1	1.06	0.94;
696	1	250.04	82.16	0.00	0.19	1	1.0500	5.3357	132.00	1	1.06	0.94;
697	1	210.56	69.19	0.00	1.13	1	1.0530	5.8651	132.00	1	1.06	0.94;
698	1	210.56	76.42	0.00	0.37	1	1.0530	18.0916	132.00	1	1.06	0.94;
699	1	258.50	75.39	0.00	0.11	1	1.0530	16.9603	132.00	1	1.06	0.94;
700	1	464.37	123.80	0.00	0.16	1	1.0283	22.1471	132.00	1	1.06	0.94;
701	1	113.27	54.05	0.00	0.09	1	1.0530	14.4730	132.00	1	1.06	0.94;
702	1	26.79	12.22	0.00	0.00	1	1.0250	18.5109	132.00	1	1.06	0.94;
703	1	250.66	99.08	0.00	0.04	1	1.0530	7.2410	132.00	1	1.06	0.94;
704	1	327.13	149.09	0.00	0.10	1	1.0328	7.1471	132.00	1	1.06	0.94;
705	1	214.79	58.19	0.00	0.20	1	1.0473	9.4080	132.00	1	1.06	0.94;
706	1	214.79	62.42	0.00	0.20	1	1.0530	10.3186	132.00	1	1.06	0.94;
707	1	262.08	77.46	0.00	0.19	1	1.0530	5.5557	132.00	1	1.06	0.94;
708	1	262.08	77.46	0.00	0.19	1	1.0521	5.5739	132.00	1	1.06	0.94;
709	1	0.00	0.00	0.00	0.00	1	1.0247	0.3634	132.00	1	1.06	0.94;
710	1	455.22	153.30	0.00	0.45	1	1.0530	-6.5979	132.00	1	1.06	0.94;
711	1	537.71	132.16	0.00	0.42	1	1.0530	-4.7927	132.00	1	1.06	0.94;
712	1	504.38	158.05	0.00	0.00	1	1.0089	0.9815	132.00	1	1.06	0.94;
713	1	471.95	147.93	0.00	0.54	1	1.0139	1.3925	132.00	1	1.06	0.94;
714	1	0.00	0.00	0.00	0.00	1	1.0263	6.0000	132.00	1	1.06	0.94;
715	1	656.04	198.10	0.00	0.78	1	1.0530	-4.3951	132.00	1	1.06	0.94;
716	1	275.72	81.42	0.00	0.21	1	1.0530	6.9822	132.00	1	1.06	0.94;
717	1	380.71	103.53	0.00	0.56	1	1.0530	-9.6841	132.00	1	1.06	0.94;
718	1	489.60	189.82	0.00	0.38	1	1.0530	-8.6293	132.00	1	1.06	0.94;
719	1	174.82	81.52	0.00	0.26	1	1.0530	-4.8511	132.00	1	1.06	0.94;
720	1	171.51	115.22	0.00	0.09	1	1.0504	-4.9923	132.00	1	1.06	0.94;
721	1	393.28	222.35	0.00	1.29	1	1.0530	-7.8251	132.00	1	1.06	0.94;
722	1	0.00	0.00	0.00	0.00	1	1.0018	-1.4337	132.00	1	1.06	0.94;
723	1	207.79	46.85	0.00	0.66	1	1.0530	2.4407	132.00	1	1.06	0.94;
724	1	446.11	80.84	0.00	0.74	1	1.0530	0.1426	132.00	1	1.06	0.94;
725	1	508.00	173.75	0.00	0.11	1	1.0530	-11.8735	132.00	1	1.06	0.94;
726	1	0.00	0.00	0.00	0.00	1	1.0015	-3.2627	132.00	1	1.06	0.94;
727	1	164.60	55.81	0.00	0.02	1	1.0530	-3.0857	132.00	1	1.06	0.94;
728	1	272.22	60.58	0.00	0.10	1	1.0530	-4.7256	132.00	1	1.06	0.94;
729	1	114.73	34.28	0.00	0.54	1	1.0530	1.2394	132.00	1	1.06	0.94;
730	1	105.28	31.46	0.00	0.03	1	1.0530	1.6784	132.00	1	1.06	0.94;
731	1	399.80	64.08	0.00	1.51	1	1.0530	-8.9122	132.00	1	1.06	0.94;
732	1	0.00	0.00	0.00	0.00	1	1.0023	-2.8380	132.00	1	1.06	0.94;
733	1	152.32	21.72	0.00	0.39	1	1.0530	-5.4244	132.00	1	1.06	0.94;
734	1	167.42	31.07	0.00	0.48	1	1.0530	-5.8668	132.00	1	1.06	0.94;
735	1	114.92	28.24	0.00	0.10	1	1.0530	-5.2914	132.00	1	1.06	0.94;
736	1	0.00	0.00	0.00	0.00	1	1.0021	-2.7036	132.00	1	1.06	0.94;
737	1	94.47	13.44	0.00	0.17	1	1.0530	-4.4662	132.00	1	1.06	0.94;
738	1	339.42	107.04	0.00	0.28	1	1.0530	-5.3490	132.00	1	1.06	0.94;
739	1	0.00	0.00	0.00	0.00	1	1.0033	0.1021	132.00	1	1.06	0.94;
740	1	208.13	60.19	0.00	0.26	1	1.0530	0.5505	132.00	1	1.06	0.94;
741	1	101.99	36.52	0.00	0.28	1	1.0530	-4.2381	132.00	1	1.06	0.94;
742	1	250.78	76.06	0.00	0.49	1	1.0530	-5.9511	132.00	1	1.06	0.94;
743	1	0.00	0.00	0.00	0.00	1	1.0051	1.8493	132.00	1	1.06	0.94;
744	1	0.00	0.00	0.00	0.00	1	1.0051	1.8493	132.00	1	1.06	0.94;
745	1	838.87	275.74	0.00	0.79	1	1.0530	-5.5823	132.00	1	1.06	0.94;
746	1	0.00	0.00	0.00	0.00	1	1.0055	0.6319	132.00	1	1.06	0.94;
747	1	228.81	90.38	0.00	0.06	1	1.0530	2.8056	132.00	1	1.06	0.94;
748	1	203.94	104.49	0.00	0.06	1	1.0530	-1.6967	132.00	1	1.06	0.94;
749	1	146.33	57.78	0.00	0.02	1	1.0530	2.4578	132.00	1	1.06	0.94;
750	1	219.14	92.87	0.00	0.41	1	1.0530	-8.0713	132.00	1	1.06	0.94;
751	1	219.14	92.87	0.00	0.41	1	0.9620	-7.1120	132.00	1	1.06	0.94;
752	1	43.65	14.32	0.00	0.00	1	1.0218	-5.5967	132.00	1	1.06	0.94;
753	1	43.65	14.32	0.00	0.00	1	1.0210	-5.8446	132.00	1	1.06	0.94;
754	1	134.72	44.31	0.00	0.14	1	1.0530	-6.2607	132.00	1	1.06	0.94;
755	1	141.70	46.36	0.00	0.17	1	1.0530	-6.5507	132.00	1	1.06	0.94;
756	1	125.32	40.76	0.00	0.03	1	1.0529	-0.4311	132.00	1	1.06	0.94;
757	1	125.32	40.76	0.00	0.03	1	1.0530	-0.4394	132.00	1	1.06	0.94;
758	1	131.07	67.16	0.00	0.03	1	1.0487	-2.2668	132.00	1	1.06	0.94;
759	1	131.07	67.16	0.00	0.01	1	1.0459	-2.6347	132.00	1	1.06	0.94;
760	1	170.97	87.60	0.00	0.10	1	1.0417	-3.5219	132.00	1	1.06	0.94;
761	1	146.99	76.50	0.00	0.03	1	1.0530	-2.4046	132.00	1	1.06	0.94;
762	1	309.47	101.68	0.00	0.05	1	1.0530	-3.9420	132.00	1	1.06	0.94;
763	1	309.47	101.68	0.00	0.03	1	1.0530	-3.8548	132.00	1	1.06	0.94;
764	1	37.81	13.12	0.00	0.03	1	1.0530	-0.3621	132.00	1	1.06	0.94;
765	1	38.92	12.82	0.00	0.03	1	1.0490	-0.5905	132.00	1	1.06	0.94;
766	1	38.92	12.82	0.00	0.00	1	1.0037	-0.1576	132.00	1	1.06	0.94;
767	1	35.55	11.69	0.00	0.00	1	1.0035	-0.5257	132.00	1	1.06	0.94;
768	1	150.08	49.38	0.00	0.29	1	1.0530	-2.8156	132.00	1	1.06	0.94;
769	1	150.08	49.38	0.00	0.27	1	1.0530	-3.7497	132.00	1	1.06	0.94;
770	1	292.53	76.10	0.00	0.54	1	1.0294	12.3509	132.00	1	1.06	0.94;
771	1	197.42	64.91	0.00	0.22	1	1.0530	-3.6184	132.00	1	1.06	0.94;
772	1	0.00	0.00	0.00	0.00	1	1.0053	0.9179	132.00	1	1.06	0.94;
773	1	0.00	0.00	0.00	0.00	1	1.0054	-3.4522	132.00	1	1.06	0.94;
774	1	173.44	56.98	0.00	0.02	1	1.0530	-7.1359	132.00	1	1.06	0.94;
775	1	60.87	22.09	0.00	0.05	1	0.9733	-6.0325	132.00	1	1.06	0.94;
776	1	250.64	81.52	0.00	0.35	1	1.0499	-0.2933	132.00	1	1.06	0.94;
777	1	15.74	13.49	0.00	0.00	1	1.0269	5.4005	132.00	1	1.06	0.94;
778	1	15.74	13.49	0.00	0.00	1	1.0270	5.4004	132.00	1	1.06	0.94;
779	1	268.81	131.77	0.00	0.22	1	1.0530	-16.3637	132.00	1	1.06	0.94;
780	1	271.73	133.23	0.00	0.22	1	1.0530	-16.4325	132.00	1	1.06	0.94;
781	1	84.86	24.76	0.00	0.43	1	1.0530	-16.0660	132.00	1	1.06	0.94;
782	1	84.86	24.76	0.00	0.43	1	1.0530	-16.7592	132.00	1	1.06	0.94;
783	1	188.72	113.18	0.00	0.41	1	1.0284	-13.8176	132.00	1	1.06	0.94;
784	1	218.07	106.94	0.00	0.28	1	1.0312	-13.5447	132.00	1	1.06	0.94;
785	1	92.73	45.46	0.00	0.12	1	1.0530	-4.6525	132.00	1	1.06	0.94;
786	1	92.73	45.46	0.00	0.08	1	1.0530	-4.6991	132.00	1	1.06	0.94;
787	1	206.47	101.19	0.00	0.01	1	1.0530	-14.8425	132.00	1	1.06	0.94;
788	1	67.20	32.92	0.00	0.00	1	1.0521	-14.4952	132.00	1	1.06	0.94;
789	1	67.20	32.92	0.00	0.00	1	1.0520	-14.5271	132.00	1	1.06	0.94;
790	1	84.86	24.76	0.00	0.42	1	0.9470	-13.9413	132.00	1	1.06	0.94;
791	1	84.86	24.76	0.00	0.43	1	0.9470	-13.9689	132.00	1	1.06	0.94;
792	1	84.86	24.76	0.00	0.14	1	0.9470	-13.9663	132.00	1	1.06	0.94;
793	1	0.00	0.00	0.00	0.00	1	1.0281	0.1685	132.00	1	1.06	0.94;
794	1	78.78	38.60	0.00	0.01	1	1.0530	-3.3139	132.00	1	1.06	0.94;
795	1	78.78	38.60	0.00	0.01	1	1.0530	-3.2516	132.00	1	1.06	0.94;
796	1	0.00	0.00	0.00	0.00	1	1.0263	-2.1518	132.00	1	1.06	0.94;
797	1	82.43	25.13	0.00	0.04	1	1.0523	-5.6262	132.00	1	1.06	0.94;
798	1	78.54	22.89	0.00	0.04	1	1.0530	-5.5232	132.00	1	1.06	0.94;
799	1	245.10	120.13	0.00	0.17	1	1.0335	-10.5772	132.00	1	1.06	0.94;
800	1	191.98	94.13	0.00	0.04	1	1.0363	-10.0545	132.00	1	1.06	0.94;
801	1	104.79	51.34	0.00	0.43	1	1.0530	-5.4649	132.00	1	1.06	0.94;
802	1	92.73	45.46	0.00	0.43	1	1.0530	-5.0687	132.00	1	1.06	0.94;
803	1	36.94	18.09	0.00	0.05	1	1.0530	-1.7728	132.00	1	1.06	0.94;
804	1	207.86	60.62	0.00	0.50	1	0.9470	-15.6963	132.00	1	1.06	0.94;
805	1	207.86	60.62	0.00	0.00	1	1.0019	-15.6916	132.00	1	1.06	0.94;
806	1	107.08	31.23	0.00	0.60	1	0.9470	-16.0181	132.00	1	1.06	0.94;
807	1	107.08	31.23	0.00	0.44	1	0.9470	-16.0197	132.00	1	1.06	0.94;
808	1	35.06	17.24	0.00	0.07	1	1.0530	-10.2583	132.00	1	1.06	0.94;
809	1	0.00	0.00	0.00	0.00	1	1.0028	-9.0030	132.00	1	1.06	0.94;
810	1	293.15	143.75	0.00	0.07	1	1.0530	-16.5281	132.00	1	1.06	0.94;
811	1	0.00	0.00	0.00	0.00	1	1.0028	-9.0029	132.00	1	1.06	0.94;
812	1	342.58	112.58	0.00	0.71	1	1.0530	-18.0702	132.00	1	1.06	0.94;
813	1	214.53	79.59	0.00	0.94	1	1.0530	-14.9970	132.00	1	1.06	0.94;
814	1	366.25	106.80	0.00	0.17	1	1.0530	-16.0491	132.00	1	1.06	0.94;
815	1	168.21	52.28	0.00	0.22	1	1.0530	-14.7057	132.00	1	1.06	0.94;
816	1	168.21	52.28	0.00	0.23	1	1.0530	-14.7059	132.00	1	1.06	0.94;
817	1	673.97	209.30	0.00	0.12	1	1.0530	-5.7996	132.00	1	1.06	0.94;
818	1	724.12	286.24	0.00	0.56	1	1.0530	-21.3154	132.00	1	1.06	0.94;
819	1	56.00	14.02	0.00	-0.60	1	0.9830	-13.7348	132.00	1	1.06	0.94;
820	1	218.75	54.35	0.00	0.00	1	1.0516	-17.1449	132.00	1	1.06	0.94;
821	1	139.56	29.51	0.00	0.41	1	1.0509	-18.6781	132.00	1	1.06	0.94;
822	1	142.89	30.29	0.00	0.41	1	1.0505	-18.7031	132.00	1	1.06	0.94;
823	1	0.00	0.00	0.00	0.00	1	1.0280	-12.6379	132.00	1	1.06	0.94;
824	1	274.65	67.40	0.00	0.54	1	1.0505	-18.5712	132.00	1	1.06	0.94;
825	1	428.53	106.26	0.00	0.54	1	1.0448	-19.0583	132.00	1	1.06	0.94;
826	1	325.29	80.25	0.00	0.50	1	1.0491	-18.9424	132.00	1	1.06	0.94;
827	1	299.27	61.46	0.00	0.21	1	1.0530	-11.5238	132.00	1	1.06	0.94;
828	1	351.32	72.17	0.00	0.21	1	1.0511	-11.9804	132.00	1	1.06	0.94;
829	1	207.45	29.22	0.00	0.43	1	1.0530	-6.5962	132.00	1	1.06	0.94;
830	1	285.46	91.94	0.00	0.27	1	1.0530	-9.1556	132.00	1	1.06	0.94;
831	1	183.10	51.23	0.00	0.12	1	1.0521	-6.9308	132.00	1	1.06	0.94;
832	1	125.01	23.28	0.00	0.00	1	1.0428	-2.9235	132.00	1	1.06	0.94;
833	1	125.01	23.28	0.00	0.54	1	1.0459	-2.1664	132.00	1	1.06	0.94;
834	1	166.54	47.63	0.00	0.04	1	1.0530	-6.3814	132.00	1	1.06	0.94;
835	1	96.42	47.72	0.00	0.00	1	1.0301	-13.0617	132.00	1	1.06	0.94;
836	1	331.26	119.21	0.00	0.00	1	1.0488	-4.1193	132.00	1	1.06	0.94;
837	1	277.05	95.45	0.00	0.00	1	1.0482	-3.7414	132.00	1	1.06	0.94;
838	1	226.93	32.04	0.00	0.54	1	1.0528	-17.6136	132.00	1	1.06	0.94;
839	1	304.65	98.08	0.00	0.31	1	1.0453	-9.5910	132.00	1	1.06	0.94;
840	1	0.00	0.00	0.00	0.00	1	1.0125	0.1468	33.00	1	1.06	0.94;
841	1	0.00	0.00	0.00	0.00	1	1.0125	0.1468	33.00	1	1.06	0.94;
842	1	0.00	0.00	0.00	0.00	1	1.0125	0.1468	33.00	1	1.06	0.94;
843	1	188.55	74.51	0.00	0.05	1	1.0530	-8.4093	132.00	1	1.06	0.94;
844	1	184.07	85.61	0.00	0.41	1	1.0317	-12.5862	132.00	1	1.06	0.94;
845	1	97.01	30.10	0.00	0.19	1	1.0530	-11.0027	132.00	1	1.06	0.94;
846	1	97.01	30.10	0.00	0.19	1	1.0530	-10.9791	132.00	1	1.06	0.94;
847	1	143.98	52.28	0.00	0.01	1	1.0530	-13.8506	132.00	1	1.06	0.94;
848	1	386.65	154.66	0.00	0.00	1	1.0503	-8.6557	132.00	1	1.06	0.94;
849	1	223.03	78.40	0.00	0.10	1	1.0530	-8.3648	132.00	1	1.06	0.94;
850	1	189.22	26.98	0.00	0.00	1	1.0469	-2.6751	132.00	1	1.06	0.94;
851	1	165.74	50.94	0.00	0.02	1	1.0530	-10.6555	33.00	1	1.06	0.94;
852	1	94.91	27.66	0.00	0.10	1	1.0530	-5.9488	33.00	1	1.06	0.94;
853	1	470.51	176.67	0.00	0.54	1	1.0518	-12.4961	132.00	1	1.06	0.94;
854	1	101.39	29.61	0.00	0.14	1	1.0530	-4.3791	33.00	1	1.06	0.94;
855	2	0.00	0.00	0.00	0.00	1	1.0530	-2.6718	275.00	1	1.06	0.94;
856	1	77.92	26.98	0.00	0.00	1	1.0530	-6.7355	33.00	1	1.06	0.94;
857	1	0.00	0.00	0.00	0.01	1	0.9470	11.8563	33.00	1	1.06	0.94;
858	1	101.52	69.00	0.00	0.02	1	1.0530	5.7026	33.00	1	1.06	0.94;
859	1	59.22	12.03	0.00	0.00	1	1.0530	8.3528	33.00	1	1.06	0.94;
860	1	108.69	33.21	0.00	0.00	1	1.0530	2.8999	33.00	1	1.06	0.94;
861	1	81.52	26.78	0.00	0.00	1	1.0530	3.4955	33.00	1	1.06	0.94;
862	1	91.18	38.82	0.00	0.03	1	1.0530	6.4300	33.00	1	1.06	0.94;
863	1	60.16	8.55	0.00	0.00	1	1.0530	8.5102	33.00	1	1.06	0.94;
864	1	64.88	18.92	0.00	0.01	1	1.0530	18.7153	33.00	1	1.06	0.94;
865	1	48.88	41.83	0.00	0.00	1	1.0530	8.7131	33.00	1	1.06	0.94;
866	1	3.76	2.63	0.00	0.00	1	0.9470	11.3410	33.00	1	1.06	0.94;
867	1	47.94	0.00	0.00	0.00	1	1.0530	12.2663	33.00	1	1.06	0.94;
868	1	91.18	18.52	0.00	0.00	1	1.0530	6.8504	33.00	1	1.06	0.94;
869	1	50.26	14.62	0.00	0.00	1	1.0530	19.1369	33.00	1	1.06	0.94;
870	1	23.97	13.91	0.00	0.00	1	1.0530	9.9881	33.00	1	1.06	0.94;
871	1	0.00	0.00	0.00	0.00	1	0.9470	12.6672	33.00	1	1.06	0.94;
872	1	62.98	64.30	0.00	0.00	1	1.0530	9.0720	33.00	1	1.06	0.94;
873	1	0.00	0.00	0.00	0.00	1	1.0530	-2.1855	33.00	1	1.06	0.94;
874	1	107.13	21.72	0.00	0.00	1	1.0530	-7.3629	33.00	1	1.06	0.94;
875	1	64.77	29.51	0.00	0.00	1	1.0530	-5.6790	33.00	1	1.06	0.94;
876	1	64.77	29.51	0.00	0.00	1	1.0530	-5.6663	33.00	1	1.06	0.94;
877	1	22.56	12.22	0.00	0.00	1	1.0530	10.1019	33.00	1	1.06	0.94;
878	1	98.70	24.72	0.00	0.00	1	1.0072	23.2632	132.00	1	1.06	0.94;
879	1	125.54	74.51	0.00	0.01	1	1.0530	2.1947	132.00	1	1.06	0.94;
880	1	183.95	90.17	0.00	0.33	1	1.0505	-3.7696	132.00	1	1.06	0.94;
881	1	174.91	85.72	0.00	0.00	1	1.0524	-4.0014	132.00	1	1.06	0.94;
882	2	0.00	0.00	0.00	0.00	1	1.0215	-1.0463	275.00	1	1.06	0.94;
883	2	0.00	0.00	0.00	0.00	1	1.0215	-1.0463	275.00	1	1.06	0.94;
884	2	0.00	0.00	0.00	0.00	1	1.0530	-10.1380	400.00	1	1.06	0.94;
885	2	0.00	0.00	0.00	0.00	1	1.0530	-5.3100	400.00	1	1.06	0.94;
886	2	0.00	0.00	0.00	0.00	1	1.0530	-0.9892	400.00	1	1.06	0.94;
887	2	0.00	0.00	0.00	0.00	1	1.0530	-0.9892	400.00	1	1.06	0.94;
888	2	0.00	0.00	0.00	0.00	1	1.0530	5.0624	400.00	1	1.06	0.94;
889	2	0.00	0.00	0.00	0.00	1	1.0530	5.0624	400.00	1	1.06	0.94;
890	2	0.00	0.00	0.00	0.00	1	1.0530	-12.7247	400.00	1	1.06	0.94;
891	2	0.00	0.00	0.00	0.00	1	1.0530	-12.7247	400.00	1	1.06	0.94;
892	2	0.00	0.00	0.00	0.00	1	1.0523	-11.9259	400.00	1	1.06	0.94;
893	2	0.00	0.00	0.00	0.00	1	1.0523	-11.9259	400.00	1	1.06	0.94;
894	2	0.00	0.00	0.00	0.00	1	1.0530	4.7568	400.00	1	1.06	0.94;
895	2	0.00	0.00	0.00	0.00	1	1.0530	6.9944	400.00	1	1.06	0.94;
896	2	0.00	0.00	0.00	0.00	1	1.0530	6.9944	400.00	1	1.06	0.94;
897	2	0.00	0.00	0.00	0.00	1	1.0518	23.8647	275.00	1	1.06	0.94;
898	2	0.00	0.00	0.00	0.00	1	1.0530	22.9320	275.00	1	1.06	0.94;
899	1	9.05	1.28	0.00	0.00	1	1.0530	-1.5471	33.00	1	1.06	0.94;
900	1	9.14	1.28	0.00	0.00	1	1.0530	21.4356	22.00	1	1.06	0.94;
901	2	0.00	0.00	0.00	0.00	1	1.0530	0.0105	275.00	1	1.06	0.94;
902	1	146.33	57.78	0.00	0.02	1	1.0530	2.4578	132.00	1	1.06	0.94;
903	2	0.00	0.00	0.00	0.00	1	1.0530	0.3440	400.00	1	1.06	0.94;
904	1	174.56	0.00	0.00	0.02	1	1.0530	17.8326	66.00	1	1.06	0.94;
905	1	0.00	0.00	0.00	0.00	1	1.0049	-4.4524	132.00	1	1.06	0.94;
906	1	615.71	280.50	0.00	0.40	1	1.0530	4.7595	132.00	1	1.06	0.94;
907	1	292.53	76.10	0.00	0.00	1	1.0252	10.8572	132.00	1	1.06	0.94;
908	1	0.00	0.00	0.00	0.00	1	1.0278	11.7192	132.00	1	1.06	0.94;
909	1	292.53	76.10	0.00	0.00	1	1.0237	12.2154	132.00	1	1.06	0.94;
910	1	54.83	48.34	0.00	0.07	1	1.0530	31.6019	66.00	1	1.06	0.94;
911	1	0.00	0.00	0.00	0.00	1	1.0227	27.9225	33.00	1	1.06	0.94;
912	1	196.25	89.41	0.00	0.11	1	1.0530	-11.8784	66.00	1	1.06	0.94;
913	1	209.27	52.46	0.00	0.34	1	1.0530	16.5566	132.00	1	1.06	0.94;
914	1	19.28	5.57	0.00	0.00	1	1.0530	19.1118	11.00	1	1.06	0.94;
915	1	3.58	2.53	0.00	0.00	1	1.0530	-2.8541	33.00	1	1.06	0.94;
916	1	0.31	0.19	0.00	0.00	1	1.0530	-2.4913	33.00	1	1.06	0.94;
917	1	222.15	66.42	0.00	0.15	1	1.0530	12.6736	132.00	1	1.06	0.94;
918	1	223.82	65.25	0.00	0.21	1	1.0530	-7.1299	66.00	1	1.06	0.94;
919	1	223.82	65.25	0.00	0.30	1	1.0530	-7.1366	66.00	1	1.06	0.94;
920	1	237.60	69.27	0.00	0.23	1	1.0530	16.4707	132.00	1	1.06	0.94;
921	1	237.60	69.27	0.00	0.22	1	1.0525	16.4762	132.00	1	1.06	0.94;
922	1	90.87	29.80	0.00	0.02	1	1.0530	10.6272	132.00	1	1.06	0.94;
923	1	90.87	29.80	0.00	0.02	1	1.0530	10.2173	132.00	1	1.06	0.94;
924	1	208.69	57.27	0.00	0.28	1	1.0026	12.3413	132.00	1	1.06	0.94;
925	1	30.08	4.32	0.00	0.00	1	1.0530	18.2362	66.00	1	1.06	0.94;
926	1	271.44	107.23	0.00	0.45	1	1.0530	-11.2202	132.00	1	1.06	0.94;
927	1	0.00	0.00	0.00	0.00	1	1.0057	-3.6345	132.00	1	1.06	0.94;
928	1	0.00	0.00	0.00	0.00	1	1.0194	-8.1354	132.00	1	1.06	0.94;
929	1	0.00	0.00	0.00	0.00	1	1.0270	6.3878	132.00	1	1.06	0.94;
930	1	0.00	0.00	0.00	0.00	1	1.0262	23.4950	132.00	1	1.06	0.94;
931	1	181.10	49.18	0.00	0.00	1	1.0147	23.7118	132.00	1	1.06	0.94;
932	1	0.00	0.00	0.00	0.00	1	0.9797	-0.1202	66.00	1	1.06	0.94;
933	1	327.37	95.45	0.00	0.63	1	0.9629	-10.6877	132.00	1	1.06	0.94;
934	1	0.00	0.00	0.00	0.00	1	1.0053	-1.0462	132.00	1	1.06	0.94;
935	1	33.60	4.77	0.00	0.05	1	1.0530	15.7006	132.00	1	1.06	0.94;
936	1	33.60	4.77	0.00	0.05	1	1.0530	15.6974	132.00	1	1.06	0.94;
937	1	224.88	32.72	0.00	0.06	1	1.0530	-3.5609	132.00	1	1.06	0.94;
938	1	0.00	0.00	0.00	0.00	1	1.0301	4.0963	275.00	1	1.06	0.94;
939	1	0.00	0.00	0.00	0.00	1	1.0032	4.0969	132.00	1	1.06	0.94;
940	1	302.94	88.34	0.00	0.15	1	0.9764	-7.6005	132.00	1	1.06	0.94;
941	1	370.26	108.01	0.00	0.16	1	0.9676	-8.6040	132.00	1	1.06	0.94;
942	1	0.00	0.00	0.00	0.00	1	0.9470	-1.0454	66.00	1	1.06	0.94;
943	1	37.55	12.37	0.00	0.00	1	1.0530	-2.5390	33.00	1	1.06	0.94;
944	1	234.86	47.70	0.00	0.34	1	1.0530	16.8121	66.00	1	1.06	0.94;
945	1	327.37	95.45	0.00	0.36	1	0.9626	-10.7213	132.00	1	1.06	0.94;
946	1	0.00	0.00	0.00	0.00	1	1.0100	15.5979	132.00	1	1.06	0.94;
947	1	148.99	30.27	0.00	0.07	1	0.9956	18.5242	132.00	1	1.06	0.94;
948	1	148.99	30.27	0.00	0.07	1	1.0530	15.3393	132.00	1	1.06	0.94;
949	1	0.00	0.00	0.00	0.00	1	1.0163	-9.7010	400.00	1	1.06	0.94;
950	1	0.00	0.00	0.00	0.00	1	0.9905	24.5734	132.00	1	1.06	0.94;
951	1	267.98	78.21	0.00	0.30	1	1.0530	-7.6047	132.00	1	1.06	0.94;
952	1	267.98	78.21	0.00	0.30	1	1.0530	-7.6349	132.00	1	1.06	0.94;
953	1	0.00	0.00	0.00	0.00	1	0.9991	10.2765	132.00	1	1.06	0.94;
954	1	210.86	90.48	0.00	0.16	1	1.0530	6.7960	132.00	1	1.06	0.94;
955	1	305.33	120.48	0.00	0.34	1	0.9470	-12.7405	132.00	1	1.06	0.94;
956	1	358.98	141.84	0.00	0.37	1	1.0530	-13.9845	132.00	1	1.06	0.94;
957	1	401.48	158.71	0.00	0.44	1	1.0512	-14.2917	132.00	1	1.06	0.94;
958	1	147.36	58.24	0.00	0.05	1	1.0530	-7.5099	132.00	1	1.06	0.94;
959	1	0.00	0.00	0.00	0.00	1	1.0186	-8.0108	132.00	1	1.06	0.94;
960	1	218.07	106.94	0.00	0.40	1	1.0282	-13.9598	132.00	1	1.06	0.94;
961	1	188.72	113.18	0.00	0.27	1	1.0327	-13.2769	132.00	1	1.06	0.94;
962	1	146.99	76.50	0.00	0.03	1	1.0530	-1.6929	132.00	1	1.06	0.94;
963	1	0.00	0.00	0.00	0.00	1	1.0274	3.8642	132.00	1	1.06	0.94;
964	1	0.00	0.00	0.00	0.00	1	1.0268	7.8582	132.00	1	1.06	0.94;
965	1	135.50	51.87	0.00	0.11	1	1.0530	11.4885	132.00	1	1.06	0.94;
966	1	135.50	51.87	0.00	0.00	1	1.0263	11.6768	132.00	1	1.06	0.94;
967	1	164.48	47.97	0.00	0.00	1	0.9988	-18.7649	132.00	1	1.06	0.94;
968	1	164.48	47.97	0.00	0.00	1	0.9990	-18.4918	132.00	1	1.06	0.94;
969	1	125.41	38.95	0.00	0.11	1	1.0530	10.6142	132.00	1	1.06	0.94;
970	1	73.69	23.40	0.00	0.04	1	1.0530	14.4805	132.00	1	1.06	0.94;
971	1	734.12	334.42	0.00	0.19	1	0.9837	2.4369	132.00	1	1.06	0.94;
972	1	630.34	197.90	0.00	0.46	1	0.9838	0.5930	132.00	1	1.06	0.94;
973	1	153.04	76.97	0.00	-0.60	1	1.0190	-1.2806	132.00	1	1.06	0.94;
974	2	0.00	0.00	0.00	0.00	1	1.0494	-3.2904	275.00	1	1.06	0.94;
975	2	0.00	0.00	0.00	0.00	1	1.0477	-2.7353	275.00	1	1.06	0.94;
976	2	0.00	0.00	0.00	0.00	1	1.0304	0.1019	275.00	1	1.06	0.94;
977	2	0.00	0.00	0.00	0.00	1	1.0294	-2.2317	275.00	1	1.06	0.94;
978	2	0.00	0.00	0.00	0.00	1	1.0138	-3.2630	275.00	1	1.06	0.94;
979	2	0.00	0.00	0.00	0.00	1	1.0376	1.5642	400.00	1	1.06	0.94;
980	2	0.00	0.00	0.00	0.00	1	1.0483	-3.6603	275.00	1	1.06	0.94;
981	2	0.00	0.00	0.00	0.00	1	1.0483	-3.6603	275.00	1	1.06	0.94;
982	2	0.00	0.00	0.00	0.00	1	1.0521	-3.0291	275.00	1	1.06	0.94;
983	2	0.00	0.00	0.00	0.00	1	1.0477	-2.7353	275.00	1	1.06	0.94;
984	2	0.00	0.00	0.00	0.00	1	1.0529	-9.9609	275.00	1	1.06	0.94;
985	2	0.00	0.00	0.00	0.00	1	1.0517	-12.6326	400.00	1	1.06	0.94;
986	1	0.00	0.00	0.00	0.43	1	1.0530	-14.5131	132.00	1	1.06	0.94;
987	1	0.00	0.00	0.00	0.43	1	1.0530	-14.5449	132.00	1	1.06	0.94;
988	1	0.00	0.00	0.00	0.00	1	1.0438	-3.0772	132.00	1	1.06	0.94;
989	1	0.00	0.00	0.00	0.00	1	0.9644	-10.7283	132.00	1	1.06	0.94;
990	1	0.00	0.00	0.00	0.00	1	0.9641	-10.7619	132.00	1	1.06	0.94;
991	1	0.00	0.00	0.00	0.00	1	1.0428	-2.9156	132.00	1	1.06	0.94;
992	1	0.00	0.00	0.00	0.00	1	1.0488	-1.6002	132.00	1	1.06	0.94;
993	1	0.00	0.00	0.00	0.00	1	1.0494	-1.5790	132.00	1	1.06	0.94;
994	1	0.00	0.00	0.00	0.00	1	1.0480	-2.5015	132.00	1	1.06	0.94;
995	1	0.00	0.00	0.00	0.00	1	1.0530	-6.9392	132.00	1	1.06	0.94;
996	1	0.00	0.00	0.00	0.00	1	1.0494	-1.5731	132.00	1	1.06	0.94;
997	1	0.00	0.00	0.00	0.00	1	1.0488	-1.9150	33.00	1	1.06	0.94;
998	1	0.00	0.00	0.00	0.00	1	1.0483	-2.5046	132.00	1	1.06	0.94;
999	1	0.00	0.00	0.00	0.00	1	1.0527	-0.6768	132.00	1	1.06	0.94;
1000	1	0.00	0.00	0.00	0.00	1	1.0440	-2.2824	33.00	1	1.06	0.94;
1001	1	0.00	0.00	0.00	0.00	1	1.0482	-2.4405	132.00	1	1.06	0.94;
1002	1	0.00	0.00	0.00	0.00	1	1.0479	-2.5275	132.00	1	1.06	0.94;
1003	1	0.00	0.00	0.00	0.00	1	1.0488	-2.1783	132.00	1	1.06	0.94;
1004	1	0.00	0.00	0.00	0.00	1	1.0497	-2.5119	33.00	1	1.06	0.94;
1005	1	0.00	0.00	0.00	0.00	1	1.0479	-2.5275	11.00	1	1.06	0.94;
1006	1	0.00	0.00	0.00	0.00	1	1.0503	-2.6432	33.00	1	1.06	0.94;
1007	1	0.00	0.00	0.00	0.00	1	1.0469	-2.6751	11.00	1	1.06	0.94;
1008	1	0.00	0.00	0.00	0.00	1	1.0507	-2.6428	33.00	1	1.06	0.94;
1009	1	0.00	0.00	0.00	0.00	1	1.0496	-2.5081	33.00	1	1.06	0.94;
1010	1	0.00	0.00	0.00	0.00	1	1.0303	7.5594	132.00	1	1.06	0.94;
1011	1	0.00	0.00	0.00	0.00	1	1.0271	7.3400	132.00	1	1.06	0.94;
1012	1	0.00	0.00	0.00	0.00	1	1.0479	9.6263	132.00	1	1.06	0.94;
1013	1	0.00	0.00	0.00	0.00	1	1.0417	8.7962	132.00	1	1.06	0.94;
1014	1	0.00	0.00	0.00	0.00	1	1.0328	7.7540	132.00	1	1.06	0.94;
1015	1	0.00	0.00	0.00	0.00	1	1.0298	7.5189	132.00	1	1.06	0.94;
1016	1	0.00	0.00	0.00	0.00	1	1.0361	8.0670	132.00	1	1.06	0.94;
1017	1	0.00	0.00	0.00	0.00	1	1.0501	9.7345	132.00	1	1.06	0.94;
1018	1	0.00	0.00	0.00	0.00	1	1.0501	9.7345	33.00	1	1.06	0.94;
1019	1	0.00	0.00	0.00	0.00	1	1.0501	9.7346	132.00	1	1.06	0.94;
1020	1	0.00	0.00	0.00	0.00	1	1.0493	9.6871	132.00	1	1.06	0.94;
1021	1	0.00	0.00	0.00	0.00	1	1.0307	7.5880	132.00	1	1.06	0.94;
1022	1	0.00	0.00	0.00	0.00	1	1.0307	7.5880	33.00	1	1.06	0.94;
1023	1	0.00	0.00	0.00	0.00	1	1.0311	7.6168	132.00	1	1.06	0.94;
1024	1	0.00	0.00	0.00	0.00	1	1.0432	8.8610	132.00	1	1.06	0.94;
1025	1	0.00	0.00	0.00	0.00	1	1.0378	8.2334	132.00	1	1.06	0.94;
1026	1	0.00	0.00	0.00	0.00	1	1.0378	8.2334	33.00	1	1.06	0.94;
1027	1	0.00	0.00	0.00	0.00	1	1.0271	7.3400	33.00	1	1.06	0.94;
1028	1	0.00	0.00	0.00	0.00	1	1.0296	7.5031	132.00	1	1.06	0.94;
1029	1	0.00	0.00	0.00	0.00	1	1.0298	7.5189	132.00	1	1.06	0.94;
1030	1	0.00	0.00	0.00	0.00	1	1.0298	7.5189	33.00	1	1.06	0.94;
1031	1	0.00	0.00	0.00	0.00	1	1.0530	9.6814	11.00	1	1.06	0.94;
1032	1	0.00	0.00	0.00	0.00	1	1.0432	8.8610	33.00	1	1.06	0.94;
1033	1	0.00	0.00	0.00	0.00	1	1.0296	7.5031	33.00	1	1.06	0.94;
1034	1	0.00	0.00	0.00	0.00	1	1.0296	7.5031	33.00	1	1.06	0.94;
1035	1	0.00	0.00	0.00	0.00	1	1.0479	9.6263	33.00	1	1.06	0.94;
1036	1	0.00	0.00	0.00	0.00	1	1.0417	8.7962	33.00	1	1.06	0.94;
1037	1	0.00	0.00	0.00	0.00	1	1.0361	8.0670	33.00	1	1.06	0.94;
1038	1	0.00	0.00	0.00	0.00	1	1.0530	35.0529	33.00	1	1.06	0.94;
1039	1	0.00	0.00	0.00	0.00	1	1.0529	35.0481	33.00	1	1.06	0.94;
1040	1	0.00	0.00	0.00	0.00	1	0.9976	24.7526	132.00	1	1.06	0.94;
1041	1	0.00	0.00	0.00	0.00	1	1.0367	34.4483	132.00	1	1.06	0.94;
1042	1	0.00	0.00	0.00	0.00	1	0.9990	24.5291	132.00	1	1.06	0.94;
1043	1	0.00	0.00	0.00	0.00	1	1.0073	23.0369	132.00	1	1.06	0.94;
1044	1	0.00	0.00	0.00	0.00	1	1.0036	23.3520	33.00	1	1.06	0.94;
1045	1	0.00	0.00	0.00	0.00	1	1.0105	23.3751	132.00	1	1.06	0.94;
1046	1	0.00	0.00	0.00	0.00	1	1.0068	22.9919	132.00	1	1.06	0.94;
1047	1	0.00	0.00	0.00	0.00	1	0.9969	24.0124	132.00	1	1.06	0.94;
1048	1	0.00	0.00	0.00	0.00	1	1.0102	24.2279	132.00	1	1.06	0.94;
1049	1	0.00	0.00	0.00	0.00	1	1.0130	24.1686	33.00	1	1.06	0.94;
1050	1	0.00	0.00	0.00	0.00	1	1.0162	24.3892	132.00	1	1.06	0.94;
1051	1	0.00	0.00	0.00	0.00	1	1.0188	24.6632	132.00	1	1.06	0.94;
1052	1	0.00	0.00	0.00	0.00	1	1.0239	29.5811	33.00	1	1.06	0.94;
1053	1	0.00	0.00	0.00	0.00	1	0.9974	24.0004	132.00	1	1.06	0.94;
1054	1	0.00	0.00	0.00	0.00	1	1.0072	23.0123	132.00	1	1.06	0.94;
1055	1	0.00	0.00	0.00	0.00	1	1.0163	24.2682	132.00	1	1.06	0.94;
1056	1	0.00	0.00	0.00	0.00	1	1.0141	23.9207	132.00	1	1.06	0.94;
1057	1	0.00	0.00	0.00	0.00	1	1.0147	23.7105	132.00	1	1.06	0.94;
1058	1	0.00	0.00	0.00	0.00	1	1.0144	23.6750	132.00	1	1.06	0.94;
1059	1	0.00	0.00	0.00	0.00	1	1.0173	25.0708	132.00	1	1.06	0.94;
1060	1	0.00	0.00	0.00	0.00	1	1.0173	25.0708	132.00	1	1.06	0.94;
1061	1	0.00	0.00	0.00	0.00	1	1.0145	23.6927	33.00	1	1.06	0.94;
1062	1	0.00	0.00	0.00	0.00	1	1.0127	23.5415	132.00	1	1.06	0.94;
1063	1	0.00	0.00	0.00	0.00	1	1.0525	35.1383	132.00	1	1.06	0.94;
1064	1	0.00	0.00	0.00	0.00	1	1.0525	35.1384	132.00	1	1.06	0.94;
1065	1	0.00	0.00	0.00	0.00	1	1.0394	32.1238	132.00	1	1.06	0.94;
1066	1	0.00	0.00	0.00	0.00	1	1.0394	32.1239	132.00	1	1.06	0.94;
1067	1	0.00	0.00	0.00	0.00	1	1.0061	23.9071	33.00	1	1.06	0.94;
1068	1	0.00	0.00	0.00	0.00	1	1.0096	23.6282	33.00	1	1.06	0.94;
1069	1	0.00	0.00	0.00	0.00	1	1.0530	36.6096	11.00	1	1.06	0.94;
1070	1	0.00	0.00	0.00	0.00	1	1.0140	24.1203	33.00	1	1.06	0.94;
1071	1	0.00	0.00	0.00	0.00	1	1.0021	23.5085	11.00	1	1.06	0.94;
1072	1	0.00	0.00	0.00	0.00	1	1.0395	32.1237	33.00	1	1.06	0.94;
1073	1	0.00	0.00	0.00	0.00	1	1.0162	24.3892	132.00	1	1.06	0.94;
1074	1	0.00	0.00	0.00	0.00	1	1.0162	24.3892	132.00	1	1.06	0.94;
1075	1	0.00	0.00	0.00	0.00	1	0.9906	24.8144	132.00	1	1.06	0.94;
1076	1	0.00	0.00	0.00	0.00	1	0.9905	24.8491	132.00	1	1.06	0.94;
1077	1	86.36	30.52	0.00	0.00	1	1.0233	25.2172	132.00	1	1.06	0.94;
1078	1	0.00	0.00	0.00	0.00	1	1.0236	25.2613	132.00	1	1.06	0.94;
1079	1	86.36	30.52	0.00	0.00	1	1.0232	25.2135	132.00	1	1.06	0.94;
1080	1	0.00	0.00	0.00	0.00	1	1.0225	24.7946	132.00	1	1.06	0.94;
1081	1	0.00	0.00	0.00	0.00	1	1.0225	24.7912	132.00	1	1.06	0.94;
1082	1	297.00	0.00	0.00	0.00	1	1.0530	32.3263	22.00	1	1.06	0.94;
1083	2	0.00	0.00	0.00	0.00	1	1.0530	32.3365	22.00	1	1.06	0.94;
1084	2	0.00	0.00	0.00	0.00	1	1.0530	32.3365	22.00	1	1.06	0.94;
1085	2	0.00	0.00	0.00	0.00	1	1.0530	32.3365	22.00	1	1.06	0.94;
1086	1	0.00	0.00	0.00	0.00	1	1.0510	-18.6836	132.00	1	1.06	0.94;
1087	1	0.00	0.00	0.00	0.00	1	1.0510	-18.6813	132.00	1	1.06	0.94;
1088	1	0.00	0.00	0.00	0.00	1	1.0509	-18.6782	132.00	1	1.06	0.94;
1089	1	0.00	0.00	0.00	0.00	1	1.0524	-19.0235	132.00	1	1.06	0.94;
1090	1	0.00	0.00	0.00	0.00	1	1.0506	-18.7263	132.00	1	1.06	0.94;
1091	1	0.00	0.00	0.00	0.00	1	1.0507	-18.7045	132.00	1	1.06	0.94;
1092	1	0.00	0.00	0.00	0.00	1	1.0506	-18.7028	132.00	1	1.06	0.94;
1093	1	0.00	0.00	0.00	0.00	1	1.0529	-17.6153	132.00	1	1.06	0.94;
1094	1	0.00	0.00	0.00	0.00	1	1.0508	-18.1245	132.00	1	1.06	0.94;
1095	1	0.00	0.00	0.00	0.00	1	1.0475	-18.7322	132.00	1	1.06	0.94;
1096	1	0.00	0.00	0.00	0.00	1	1.0502	-8.9191	132.00	1	1.06	0.94;
1097	1	0.00	0.00	0.00	0.00	1	1.0502	-8.9404	33.00	1	1.06	0.94;
1098	1	0.00	0.00	0.00	0.00	1	1.0502	-8.9620	132.00	1	1.06	0.94;
1099	1	0.00	0.00	0.00	0.00	1	1.0415	-10.6238	132.00	1	1.06	0.94;
1100	1	0.00	0.00	0.00	0.00	1	1.0516	-17.1450	132.00	1	1.06	0.94;
1101	1	0.00	0.00	0.00	0.00	1	1.0516	-17.1450	132.00	1	1.06	0.94;
1102	1	0.00	0.00	0.00	0.00	1	1.0530	-17.6168	132.00	1	1.06	0.94;
1103	1	0.00	0.00	0.00	0.00	1	1.0530	-17.6168	33.00	1	1.06	0.94;
1104	1	0.00	0.00	0.00	0.00	1	1.0530	-17.6168	132.00	1	1.06	0.94;
1105	1	0.00	0.00	0.00	0.00	1	1.0530	-12.5174	132.00	1	1.06	0.94;
1106	1	0.00	0.00	0.00	0.00	1	1.0530	-12.5174	33.00	1	1.06	0.94;
1107	1	0.00	0.00	0.00	0.00	1	1.0530	-12.5174	132.00	1	1.06	0.94;
1108	1	0.00	0.00	0.00	0.00	1	1.0305	-13.0736	132.00	1	1.06	0.94;
1109	1	0.00	0.00	0.00	0.00	1	1.0305	-13.0736	33.00	1	1.06	0.94;
1110	1	0.00	0.00	0.00	0.00	1	1.0305	-13.0736	132.00	1	1.06	0.94;
1111	1	0.00	0.00	0.00	0.00	1	1.0492	-4.2436	132.00	1	1.06	0.94;
1112	1	0.00	0.00	0.00	0.00	1	1.0495	-4.1715	33.00	1	1.06	0.94;
1113	1	0.00	0.00	0.00	0.00	1	1.0497	-4.1562	33.00	1	1.06	0.94;
1114	1	0.00	0.00	0.00	0.00	1	1.0320	-12.5873	33.00	1	1.06	0.94;
1115	1	0.00	0.00	0.00	0.00	1	1.0320	-12.5873	33.00	1	1.06	0.94;
1116	1	0.00	0.00	0.00	0.00	1	1.0408	-10.7449	132.00	1	1.06	0.94;
1117	1	0.00	0.00	0.00	0.00	1	1.0318	-12.5865	132.00	1	1.06	0.94;
1118	1	0.00	0.00	0.00	0.00	1	1.0319	-12.5855	33.00	1	1.06	0.94;
1119	1	0.00	0.00	0.00	0.00	1	1.0460	-19.0816	132.00	1	1.06	0.94;
1120	1	0.00	0.00	0.00	0.00	1	1.0460	-19.0816	33.00	1	1.06	0.94;
1121	1	0.00	0.00	0.00	0.00	1	1.0461	-19.0825	132.00	1	1.06	0.94;
1122	1	0.00	0.00	0.00	0.00	1	1.0482	-3.7417	132.00	1	1.06	0.94;
1123	1	0.00	0.00	0.00	0.00	1	1.0482	-3.7417	33.00	1	1.06	0.94;
1124	1	0.00	0.00	0.00	0.00	1	1.0482	-3.7417	132.00	1	1.06	0.94;
1125	1	0.00	0.00	0.00	0.00	1	1.0409	-10.7158	33.00	1	1.06	0.94;
1126	1	0.00	0.00	0.00	0.00	1	1.0413	-10.6918	33.00	1	1.06	0.94;
1127	1	0.00	0.00	0.00	0.00	1	1.0515	-18.6055	132.00	1	1.06	0.94;
1128	1	0.00	0.00	0.00	0.00	1	1.0514	-18.5975	33.00	1	1.06	0.94;
1129	1	0.00	0.00	0.00	0.00	1	1.0530	-18.6432	132.00	1	1.06	0.94;
1130	1	0.00	0.00	0.00	0.00	1	1.0512	-18.5894	132.00	1	1.06	0.94;
1131	1	0.00	0.00	0.00	0.00	1	1.0512	-18.5894	132.00	1	1.06	0.94;
1132	1	0.00	0.00	0.00	0.00	1	1.0529	-18.6473	132.00	1	1.06	0.94;
1133	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9424	132.00	1	1.06	0.94;
1134	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9425	33.00	1	1.06	0.94;
1135	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9426	132.00	1	1.06	0.94;
1136	1	0.00	0.00	0.00	0.00	1	1.0493	-18.9457	132.00	1	1.06	0.94;
1137	1	0.00	0.00	0.00	0.00	1	1.0492	-18.9447	132.00	1	1.06	0.94;
1138	1	0.00	0.00	0.00	0.00	1	1.0498	-18.9597	132.00	1	1.06	0.94;
1139	1	0.00	0.00	0.00	0.00	1	1.0505	-18.7750	132.00	1	1.06	0.94;
1140	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9426	132.00	1	1.06	0.94;
1141	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9424	132.00	1	1.06	0.94;
1142	1	0.00	0.00	0.00	0.00	1	1.0493	-18.9469	132.00	1	1.06	0.94;
1143	1	0.00	0.00	0.00	0.00	1	1.0493	-18.9469	132.00	1	1.06	0.94;
1144	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9424	33.00	1	1.06	0.94;
1145	1	0.00	0.00	0.00	0.00	1	1.0499	-18.9606	132.00	1	1.06	0.94;
1146	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9424	132.00	1	1.06	0.94;
1147	1	0.00	0.00	0.00	0.00	1	1.0499	-18.9602	33.00	1	1.06	0.94;
1148	1	0.00	0.00	0.00	0.00	1	1.0529	-17.6153	33.00	1	1.06	0.94;
1149	1	0.00	0.00	0.00	0.00	1	1.0518	-4.1237	132.00	1	1.06	0.94;
1150	1	0.00	0.00	0.00	0.00	1	1.0516	-3.9744	33.00	1	1.06	0.94;
1151	1	0.00	0.00	0.00	0.00	1	1.0516	-4.1245	132.00	1	1.06	0.94;
1152	1	0.00	0.00	0.00	0.00	1	1.0514	-3.8236	132.00	1	1.06	0.94;
1153	1	0.00	0.00	0.00	0.00	1	1.0517	-3.9739	33.00	1	1.06	0.94;
1154	1	0.00	0.00	0.00	0.00	1	1.0515	-3.8247	132.00	1	1.06	0.94;
1155	1	0.00	0.00	0.00	0.00	1	1.0514	-3.8235	132.00	1	1.06	0.94;
1156	1	0.00	0.00	0.00	0.00	1	1.0515	-3.8245	132.00	1	1.06	0.94;
1157	1	0.00	0.00	0.00	0.00	1	1.0519	-4.1240	132.00	1	1.06	0.94;
1158	1	0.00	0.00	0.00	0.00	1	1.0517	-4.1249	132.00	1	1.06	0.94;
1159	1	0.00	0.00	0.00	0.00	1	1.0448	-19.0591	132.00	1	1.06	0.94;
1160	1	0.00	0.00	0.00	0.00	1	1.0451	-19.0618	33.00	1	1.06	0.94;
1161	1	0.00	0.00	0.00	0.00	1	1.0449	-19.0589	132.00	1	1.06	0.94;
1162	1	0.00	0.00	0.00	0.00	1	1.0450	-19.0590	33.00	1	1.06	0.94;
1163	1	0.00	0.00	0.00	0.00	1	1.0459	-19.0763	132.00	1	1.06	0.94;
1164	1	0.00	0.00	0.00	0.00	1	1.0453	-19.0673	33.00	1	1.06	0.94;
1165	1	0.00	0.00	0.00	0.00	1	1.0450	-19.0593	33.00	1	1.06	0.94;
1166	1	0.00	0.00	0.00	0.00	1	1.0461	-19.0825	33.00	1	1.06	0.94;
1167	1	0.00	0.00	0.00	0.00	1	1.0459	-19.0764	132.00	1	1.06	0.94;
1168	1	0.00	0.00	0.00	0.00	1	1.0449	-19.0604	132.00	1	1.06	0.94;
1169	1	0.00	0.00	0.00	0.00	1	1.0450	-19.0572	132.00	1	1.06	0.94;
1170	1	0.00	0.00	0.00	0.00	1	1.0456	-19.0698	132.00	1	1.06	0.94;
1171	1	0.00	0.00	0.00	0.00	1	1.0496	-4.1323	132.00	1	1.06	0.94;
1172	1	0.00	0.00	0.00	0.00	1	1.0500	-4.1359	132.00	1	1.06	0.94;
1173	1	0.00	0.00	0.00	0.00	1	1.0494	-4.3130	132.00	1	1.06	0.94;
1174	1	0.00	0.00	0.00	0.00	1	1.0502	-18.6764	33.00	1	1.06	0.94;
1175	1	0.00	0.00	0.00	0.00	1	1.0503	-18.5850	132.00	1	1.06	0.94;
1176	1	0.00	0.00	0.00	0.00	1	1.0490	-18.7449	33.00	1	1.06	0.94;
1177	1	0.00	0.00	0.00	0.00	1	1.0516	-4.1247	33.00	1	1.06	0.94;
1178	1	0.00	0.00	0.00	0.00	1	1.0530	-18.6432	33.00	1	1.06	0.94;
1179	1	0.00	0.00	0.00	0.00	1	1.0505	-18.7750	33.00	1	1.06	0.94;
1180	1	0.00	0.00	0.00	0.00	1	1.0507	-18.7254	132.00	1	1.06	0.94;
1181	1	0.00	0.00	0.00	0.00	1	1.0508	-18.7027	33.00	1	1.06	0.94;
1182	1	0.00	0.00	0.00	0.00	1	1.0508	-18.6931	33.00	1	1.06	0.94;
1183	1	0.00	0.00	0.00	0.00	1	1.0526	-18.6573	132.00	1	1.06	0.94;
1184	1	0.00	0.00	0.00	0.00	1	1.0526	-18.6573	33.00	1	1.06	0.94;
1185	1	0.00	0.00	0.00	0.00	1	1.0530	-18.6474	33.00	1	1.06	0.94;
1186	1	0.00	0.00	0.00	0.00	1	1.0512	-4.9204	132.00	1	1.06	0.94;
1187	1	0.00	0.00	0.00	0.00	1	1.0524	-5.9524	33.00	1	1.06	0.94;
1188	1	0.00	0.00	0.00	0.00	1	1.0508	-8.1362	132.00	1	1.06	0.94;
1189	1	0.00	0.00	0.00	0.00	1	1.0521	-6.9711	132.00	1	1.06	0.94;
1190	1	0.00	0.00	0.00	0.00	1	1.0483	-9.2632	132.00	1	1.06	0.94;
1191	1	0.00	0.00	0.00	0.00	1	1.0508	-18.1245	33.00	1	1.06	0.94;
1192	1	0.00	0.00	0.00	0.00	1	1.0524	-12.5118	132.00	1	1.06	0.94;
1193	1	0.00	0.00	0.00	0.00	1	1.0523	-12.5080	132.00	1	1.06	0.94;
1194	1	0.00	0.00	0.00	0.00	1	1.0521	-6.9711	33.00	1	1.06	0.94;
1195	1	0.00	0.00	0.00	0.00	1	1.0459	-19.0763	33.00	1	1.06	0.94;
1196	1	0.00	0.00	0.00	0.00	1	1.0451	-19.0584	132.00	1	1.06	0.94;
1197	1	0.00	0.00	0.00	0.00	1	1.0471	-19.0053	132.00	1	1.06	0.94;
1198	1	0.00	0.00	0.00	0.00	1	1.0496	-4.3716	132.00	1	1.06	0.94;
1199	1	0.00	0.00	0.00	0.00	1	1.0522	-6.5586	132.00	1	1.06	0.94;
1200	1	0.00	0.00	0.00	0.00	1	1.0494	-4.3130	11.00	1	1.06	0.94;
1201	1	0.00	0.00	0.00	0.00	1	1.0492	-18.9447	132.00	1	1.06	0.94;
1202	1	0.00	0.00	0.00	0.00	1	1.0492	-18.9437	33.00	1	1.06	0.94;
1203	1	0.00	0.00	0.00	0.00	1	1.0491	-18.9426	132.00	1	1.06	0.94;
1204	1	0.00	0.00	0.00	0.00	1	1.0515	-3.8246	11.00	1	1.06	0.94;
1205	1	0.00	0.00	0.00	0.00	1	1.0515	-3.8246	11.00	1	1.06	0.94;
1206	1	0.00	0.00	0.00	0.00	1	1.0475	-18.7322	33.00	1	1.06	0.94;
1207	1	0.00	0.00	0.00	0.00	1	1.0301	-13.0617	33.00	1	1.06	0.94;
1208	1	0.00	0.00	0.00	0.00	1	1.0301	-13.0617	33.00	1	1.06	0.94;
1209	1	0.00	0.00	0.00	0.00	1	1.0493	-18.9469	33.00	1	1.06	0.94;
1210	1	0.00	0.00	0.00	0.00	1	1.0508	-18.6929	33.00	1	1.06	0.94;
1211	1	0.00	0.00	0.00	0.00	1	1.0506	-18.7028	132.00	1	1.06	0.94;
1212	1	0.00	0.00	0.00	0.00	1	1.0509	-18.6784	132.00	1	1.06	0.94;
1213	1	0.00	0.00	0.00	0.00	1	1.0416	-10.6282	132.00	1	1.06	0.94;
1214	1	0.00	0.00	0.00	0.00	1	1.0516	-17.1450	33.00	1	1.06	0.94;
1215	1	0.00	0.00	0.00	0.00	1	1.0530	-17.1777	132.00	1	1.06	0.94;
1216	1	0.00	0.00	0.00	0.00	1	1.0530	-17.1777	33.00	1	1.06	0.94;
1217	1	0.00	0.00	0.00	0.00	1	1.0290	-13.8177	132.00	1	1.06	0.94;
1218	1	0.00	0.00	0.00	0.00	1	1.0312	-13.5443	132.00	1	1.06	0.94;
1219	1	0.00	0.00	0.00	0.00	1	1.0320	-13.4792	132.00	1	1.06	0.94;
1220	1	0.00	0.00	0.00	0.00	1	1.0379	-12.5966	132.00	1	1.06	0.94;
1221	1	0.00	0.00	0.00	0.00	1	1.0394	-5.6994	132.00	1	1.06	0.94;
1222	1	0.00	0.00	0.00	0.00	1	1.0465	-4.8715	132.00	1	1.06	0.94;
1223	1	0.00	0.00	0.00	0.00	1	1.0317	-13.5178	132.00	1	1.06	0.94;
1224	1	0.00	0.00	0.00	0.00	1	1.0313	-13.5485	132.00	1	1.06	0.94;
1225	1	0.00	0.00	0.00	0.00	1	1.0291	-13.8159	132.00	1	1.06	0.94;
1226	1	0.00	0.00	0.00	0.00	1	1.0518	-3.9575	132.00	1	1.06	0.94;
1227	1	0.00	0.00	0.00	0.00	1	1.0519	-3.9556	132.00	1	1.06	0.94;
1228	1	0.00	0.00	0.00	0.00	1	1.0530	-3.8661	132.00	1	1.06	0.94;
1229	1	0.00	0.00	0.00	0.00	1	1.0530	-3.9999	132.00	1	1.06	0.94;
1230	1	0.00	0.00	0.00	0.00	1	1.0512	-3.8017	132.00	1	1.06	0.94;
1231	1	0.00	0.00	0.00	0.00	1	1.0422	-13.0250	132.00	1	1.06	0.94;
1232	1	0.00	0.00	0.00	0.00	1	1.0377	-13.3047	132.00	1	1.06	0.94;
1233	1	0.00	0.00	0.00	0.00	1	1.0508	-12.2433	132.00	1	1.06	0.94;
1234	1	0.00	0.00	0.00	0.00	1	1.0500	-12.0169	132.00	1	1.06	0.94;
1235	1	0.00	0.00	0.00	0.00	1	1.0427	-13.0451	132.00	1	1.06	0.94;
1236	1	0.00	0.00	0.00	0.00	1	1.0403	-13.1838	132.00	1	1.06	0.94;
1237	1	0.00	0.00	0.00	0.00	1	1.0431	-12.9203	132.00	1	1.06	0.94;
1238	1	0.00	0.00	0.00	0.00	1	1.0363	-10.9217	132.00	1	1.06	0.94;
1239	1	0.00	0.00	0.00	0.00	1	1.0349	-10.6965	132.00	1	1.06	0.94;
1240	1	0.00	0.00	0.00	0.00	1	1.0349	-10.6941	132.00	1	1.06	0.94;
1241	1	0.00	0.00	0.00	0.00	1	1.0338	-10.5961	132.00	1	1.06	0.94;
1242	1	0.00	0.00	0.00	0.00	1	1.0338	-10.5929	132.00	1	1.06	0.94;
1243	1	0.00	0.00	0.00	0.00	1	1.0349	-10.6904	132.00	1	1.06	0.94;
1244	1	0.00	0.00	0.00	0.00	1	1.0431	-12.9213	132.00	1	1.06	0.94;
1245	1	0.00	0.00	0.00	0.00	1	1.0508	-12.2410	132.00	1	1.06	0.94;
1246	1	0.00	0.00	0.00	0.00	1	1.0508	-12.2410	132.00	1	1.06	0.94;
1247	1	0.00	0.00	0.00	0.00	1	1.0512	-12.2639	132.00	1	1.06	0.94;
1248	1	0.00	0.00	0.00	0.00	1	1.0510	-12.2487	132.00	1	1.06	0.94;
1249	1	0.00	0.00	0.00	0.00	1	1.0510	-12.2487	132.00	1	1.06	0.94;
1250	1	0.00	0.00	0.00	0.00	1	1.0350	-10.3174	132.00	1	1.06	0.94;
1251	1	0.00	0.00	0.00	0.00	1	1.0350	-10.3174	132.00	1	1.06	0.94;
1252	1	0.00	0.00	0.00	0.00	1	1.0350	-10.3174	132.00	1	1.06	0.94;
1253	1	0.00	0.00	0.00	0.00	1	1.0317	-13.5184	132.00	1	1.06	0.94;
1254	1	0.00	0.00	0.00	0.00	1	1.0317	-13.5184	132.00	1	1.06	0.94;
1255	1	0.00	0.00	0.00	0.00	1	1.0312	-13.5497	132.00	1	1.06	0.94;
1256	1	0.00	0.00	0.00	0.00	1	1.0285	-13.8132	132.00	1	1.06	0.94;
1257	1	0.00	0.00	0.00	0.00	1	1.0526	-12.2542	33.00	1	1.06	0.94;
1258	1	0.00	0.00	0.00	0.00	1	1.0530	-12.2601	33.00	1	1.06	0.94;
1259	1	0.00	0.00	0.00	0.00	1	1.0344	-10.6446	33.00	1	1.06	0.94;
1260	1	0.00	0.00	0.00	0.00	1	1.0344	-10.6450	11.00	1	1.06	0.94;
1261	1	0.00	0.00	0.00	0.00	1	1.0508	-12.2418	33.00	1	1.06	0.94;
1262	1	0.00	0.00	0.00	0.00	1	1.0343	-10.6415	33.00	1	1.06	0.94;
1263	1	0.00	0.00	0.00	0.00	1	1.0399	-13.1645	33.00	1	1.06	0.94;
1264	1	0.00	0.00	0.00	0.00	1	1.0415	-13.1144	33.00	1	1.06	0.94;
1265	1	0.00	0.00	0.00	0.00	1	1.0431	-12.9213	33.00	1	1.06	0.94;
1266	1	0.00	0.00	0.00	0.00	1	1.0310	-13.6390	11.00	1	1.06	0.94;
1267	1	0.00	0.00	0.00	0.00	1	1.0368	-9.2001	33.00	1	1.06	0.94;
1268	1	0.00	0.00	0.00	0.00	1	1.0524	-3.9106	33.00	1	1.06	0.94;
1269	1	0.00	0.00	0.00	0.00	1	1.0525	-3.9091	11.00	1	1.06	0.94;
1270	1	0.00	0.00	0.00	0.00	1	1.0524	-3.9109	6.60	1	1.06	0.94;
1271	1	0.00	0.00	0.00	0.00	1	1.0491	-4.4160	33.00	1	1.06	0.94;
1272	1	0.00	0.00	0.00	0.00	1	1.0521	-3.9009	33.00	1	1.06	0.94;
1273	1	0.00	0.00	0.00	0.00	1	1.0505	-3.7696	33.00	1	1.06	0.94;
1274	1	0.00	0.00	0.00	0.00	1	1.0298	-13.6809	33.00	1	1.06	0.94;
1275	1	0.00	0.00	0.00	0.00	1	1.0298	-13.6813	33.00	1	1.06	0.94;
1276	1	0.00	0.00	0.00	0.00	1	1.0320	-13.4792	33.00	1	1.06	0.94;
1277	1	0.00	0.00	0.00	0.00	1	1.0317	-13.5178	33.00	1	1.06	0.94;
1278	1	0.00	0.00	0.00	0.00	1	1.0317	-13.5184	33.00	1	1.06	0.94;
1279	1	0.00	0.00	0.00	0.00	1	1.0317	-13.5184	33.00	1	1.06	0.94;
1280	1	0.00	0.00	0.00	0.00	1	1.0366	-10.9811	132.00	1	1.06	0.94;
1281	1	0.00	0.00	0.00	0.00	1	1.0498	-11.9612	132.00	1	1.06	0.94;
1282	1	0.00	0.00	0.00	0.00	1	0.9488	-11.4726	33.00	1	1.06	0.94;
1283	1	0.00	0.00	0.00	0.00	1	1.0432	-11.4752	33.00	1	1.06	0.94;
1284	1	0.00	0.00	0.00	0.00	1	1.0350	-10.3174	33.00	1	1.06	0.94;
1285	1	0.00	0.00	0.00	0.00	1	1.0350	-10.3174	11.00	1	1.06	0.94;
1286	1	0.00	0.00	0.00	0.00	1	1.0350	-10.3174	11.00	1	1.06	0.94;
1287	1	0.00	0.00	0.00	0.00	1	1.0530	6.4424	132.00	1	1.06	0.94;
1288	2	0.00	0.00	0.00	0.00	1	1.0530	19.0267	132.00	1	1.06	0.94;
1289	2	0.00	0.00	0.00	0.00	1	1.0530	19.0267	132.00	1	1.06	0.94;
1290	2	0.00	0.00	0.00	0.00	1	1.0530	19.0267	132.00	1	1.06	0.94;
1291	1	0.00	0.00	0.00	0.00	1	1.0154	1.3657	132.00	1	1.06	0.94;
1292	1	0.00	0.00	0.00	0.00	1	1.0154	1.3681	132.00	1	1.06	0.94;
1293	1	0.00	0.00	0.00	0.00	1	1.0143	1.3848	132.00	1	1.06	0.94;
1294	1	0.00	0.00	0.00	0.00	1	1.0156	1.3636	132.00	1	1.06	0.94;
1295	1	0.00	0.00	0.00	0.00	1	1.0156	1.3637	132.00	1	1.06	0.94;
1296	1	0.00	0.00	0.00	0.00	1	1.0106	0.9374	132.00	1	1.06	0.94;
1297	1	0.00	0.00	0.00	0.00	1	1.0131	1.7797	132.00	1	1.06	0.94;
1298	1	0.00	0.00	0.00	0.00	1	1.0131	1.7797	132.00	1	1.06	0.94;
1299	1	0.00	0.00	0.00	0.00	1	1.0483	5.7863	132.00	1	1.06	0.94;
1300	1	0.00	0.00	0.00	0.00	1	1.0292	3.7422	132.00	1	1.06	0.94;
1301	1	0.00	0.00	0.00	0.00	1	1.0294	3.7487	132.00	1	1.06	0.94;
1302	1	0.00	0.00	0.00	0.00	1	1.0089	0.9813	132.00	1	1.06	0.94;
1303	1	0.00	0.00	0.00	0.00	1	1.0089	0.9813	132.00	1	1.06	0.94;
1304	1	0.00	0.00	0.00	0.00	1	1.0530	6.4425	132.00	1	1.06	0.94;
1305	1	0.00	0.00	0.00	0.00	1	1.0530	6.4425	132.00	1	1.06	0.94;
1306	1	0.00	0.00	0.00	0.00	1	1.0530	6.4433	132.00	1	1.06	0.94;
1307	1	0.00	0.00	0.00	0.00	1	1.0530	6.4433	132.00	1	1.06	0.94;
1308	1	0.00	0.00	0.00	0.00	1	1.0530	6.4425	132.00	1	1.06	0.94;
1309	1	0.00	0.00	0.00	0.00	1	1.0530	6.4425	132.00	1	1.06	0.94;
1310	1	0.00	0.00	0.00	0.00	1	0.9470	1.3766	33.00	1	1.06	0.94;
1311	1	0.00	0.00	0.00	0.00	1	0.9470	1.3657	33.00	1	1.06	0.94;
1312	1	0.00	0.00	0.00	0.00	1	0.9470	1.3640	33.00	1	1.06	0.94;
1313	1	0.00	0.00	0.00	0.00	1	0.9470	0.9406	33.00	1	1.06	0.94;
1314	1	0.00	0.00	0.00	0.00	1	0.9470	0.9397	11.00	1	1.06	0.94;
1315	1	0.00	0.00	0.00	0.00	1	0.9719	0.9406	11.00	1	1.06	0.94;
1316	1	0.00	0.00	0.00	0.00	1	0.9470	1.7824	33.00	1	1.06	0.94;
1317	1	0.00	0.00	0.00	0.00	1	0.9470	3.7458	33.00	1	1.06	0.94;
1318	1	0.00	0.00	0.00	0.00	1	0.9470	0.9817	33.00	1	1.06	0.94;
1319	1	0.00	0.00	0.00	0.00	1	0.9523	5.7884	33.00	1	1.06	0.94;
1320	1	0.00	0.00	0.00	0.00	1	0.9565	6.4454	33.00	1	1.06	0.94;
1321	1	0.00	0.00	0.00	0.00	1	1.0227	6.4425	33.00	1	1.06	0.94;
1322	1	0.00	0.00	0.00	0.00	1	1.0527	17.8507	132.00	1	1.06	0.94;
1323	2	0.00	0.00	0.00	0.00	1	1.0530	30.4661	132.00	1	1.06	0.94;
1324	2	0.00	0.00	0.00	0.00	1	1.0530	30.4661	132.00	1	1.06	0.94;
1325	2	0.00	0.00	0.00	0.00	1	1.0530	30.4661	132.00	1	1.06	0.94;
1326	1	0.00	0.00	0.00	0.00	1	1.0377	12.6303	132.00	1	1.06	0.94;
1327	2	0.00	0.00	0.00	0.00	1	1.0530	17.6880	132.00	1	1.06	0.94;
1328	1	0.00	0.00	0.00	0.00	1	1.0272	13.2396	132.00	1	1.06	0.94;
1329	1	0.00	0.00	0.00	0.00	1	1.0309	13.3529	132.00	1	1.06	0.94;
1330	1	0.00	0.00	0.00	0.00	1	1.0336	15.3107	132.00	1	1.06	0.94;
1331	1	0.00	0.00	0.00	0.00	1	1.0352	15.3586	132.00	1	1.06	0.94;
1332	1	0.00	0.00	0.00	0.00	1	1.0521	17.6896	132.00	1	1.06	0.94;
1333	1	0.00	0.00	0.00	0.00	1	1.0522	17.6933	132.00	1	1.06	0.94;
1334	1	0.00	0.00	0.00	0.00	1	1.0336	15.3099	132.00	1	1.06	0.94;
1335	1	0.00	0.00	0.00	0.00	1	1.0352	15.3593	132.00	1	1.06	0.94;
1336	1	0.00	0.00	0.00	0.00	1	1.0522	17.6885	132.00	1	1.06	0.94;
1337	1	0.00	0.00	0.00	0.00	1	1.0522	17.6923	132.00	1	1.06	0.94;
1338	1	0.00	0.00	0.00	0.00	1	1.0530	17.6904	33.00	1	1.06	0.94;
1339	1	0.00	0.00	0.00	0.00	1	1.0517	17.6523	132.00	1	1.06	0.94;
1340	1	0.00	0.00	0.00	0.00	1	1.0530	17.6034	132.00	1	1.06	0.94;
1341	1	0.00	0.00	0.00	0.00	1	1.0530	17.8415	132.00	1	1.06	0.94;
1342	1	0.00	0.00	0.00	0.00	1	1.0517	17.6512	132.00	1	1.06	0.94;
1343	1	0.00	0.00	0.00	0.00	1	1.0323	13.3906	132.00	1	1.06	0.94;
1344	1	0.00	0.00	0.00	0.00	1	1.0318	13.3135	132.00	1	1.06	0.94;
1345	1	0.00	0.00	0.00	0.00	1	1.0344	13.4444	132.00	1	1.06	0.94;
1346	1	0.00	0.00	0.00	0.00	1	1.0341	13.3728	132.00	1	1.06	0.94;
1347	1	0.00	0.00	0.00	0.00	1	1.0375	14.2264	132.00	1	1.06	0.94;
1348	1	0.00	0.00	0.00	0.00	1	1.0454	15.7569	132.00	1	1.06	0.94;
1349	1	0.00	0.00	0.00	0.00	1	1.0469	16.2140	132.00	1	1.06	0.94;
1350	1	0.00	0.00	0.00	0.00	1	1.0525	17.4992	132.00	1	1.06	0.94;
1351	1	0.00	0.00	0.00	0.00	1	1.0530	17.8411	132.00	1	1.06	0.94;
1352	1	0.00	0.00	0.00	0.00	1	1.0312	12.3061	132.00	1	1.06	0.94;
1353	1	0.00	0.00	0.00	0.00	1	1.0317	12.2952	132.00	1	1.06	0.94;
1354	1	0.00	0.00	0.00	0.00	1	1.0312	12.3080	132.00	1	1.06	0.94;
1355	1	0.00	0.00	0.00	0.00	1	1.0316	12.2959	132.00	1	1.06	0.94;
1356	1	0.00	0.00	0.00	0.00	1	1.0340	12.4318	132.00	1	1.06	0.94;
1357	1	0.00	0.00	0.00	0.00	1	1.0322	11.8671	132.00	1	1.06	0.94;
1358	1	0.00	0.00	0.00	0.00	1	1.0332	12.1472	132.00	1	1.06	0.94;
1359	1	0.00	0.00	0.00	0.00	1	1.0178	12.1472	33.00	1	1.06	0.94;
1360	1	0.00	0.00	0.00	0.00	1	1.0530	17.6741	11.00	1	1.06	0.94;
1361	1	0.00	0.00	0.00	0.00	1	1.0530	17.6739	11.00	1	1.06	0.94;
1362	1	0.00	0.00	0.00	0.00	1	0.9470	13.3439	33.00	1	1.06	0.94;
1363	1	0.00	0.00	0.00	0.00	1	0.9517	16.2142	33.00	1	1.06	0.94;
1364	1	0.00	0.00	0.00	0.00	1	0.9470	14.2271	33.00	1	1.06	0.94;
1365	1	0.00	0.00	0.00	0.00	1	0.9470	12.3083	33.00	1	1.06	0.94;
1366	1	0.00	0.00	0.00	0.00	1	0.9470	12.2961	33.00	1	1.06	0.94;
1367	1	0.00	0.00	0.00	0.00	1	1.0530	13.2958	33.00	1	1.06	0.94;
1368	1	0.00	0.00	0.00	0.00	1	1.0530	15.3367	33.00	1	1.06	0.94;
1369	1	0.00	0.00	0.00	0.00	1	1.0153	17.8415	11.00	1	1.06	0.94;
1370	1	0.00	0.00	0.00	0.00	1	1.0224	17.6512	11.00	1	1.06	0.94;
1371	1	0.00	0.00	0.00	0.00	1	0.9855	2.5898	132.00	1	1.06	0.94;
1372	2	0.00	0.00	0.00	0.00	1	1.0530	7.5438	132.00	1	1.06	0.94;
1373	1	0.00	0.00	0.00	0.00	1	0.9912	1.5264	132.00	1	1.06	0.94;
1374	2	0.00	0.00	0.00	0.00	1	1.0530	9.3713	132.00	1	1.06	0.94;
1375	2	0.00	0.00	0.00	0.00	1	1.0530	9.3713	132.00	1	1.06	0.94;
1376	2	0.00	0.00	0.00	0.00	1	1.0530	9.3710	132.00	1	1.06	0.94;
1377	2	0.00	0.00	0.00	0.00	1	1.0530	9.4914	132.00	1	1.06	0.94;
1378	2	0.00	0.00	0.00	0.00	1	1.0530	10.1133	132.00	1	1.06	0.94;
1379	1	198.17	67.58	0.00	0.18	1	1.0530	12.6136	132.00	1	1.06	0.94;
1380	1	0.00	0.00	0.00	0.00	1	1.0530	18.9703	132.00	1	1.06	0.94;
1381	1	0.00	0.00	0.00	0.00	1	1.0527	18.9813	132.00	1	1.06	0.94;
1382	1	0.00	0.00	0.00	0.00	1	1.0529	32.3187	22.00	1	1.06	0.94;
1383	1	0.00	0.00	0.00	0.00	1	1.0529	32.3187	22.00	1	1.06	0.94;
1384	1	0.00	0.00	0.00	0.00	1	1.0269	5.4005	132.00	1	1.06	0.94;
1385	1	0.00	0.00	0.00	0.00	1	1.0270	5.4004	132.00	1	1.06	0.94;
1386	1	0.00	0.00	0.00	0.00	1	1.0381	-11.1156	132.00	1	1.06	0.94;
1387	2	0.00	0.00	0.00	0.00	1	1.0530	7.9046	132.00	1	1.06	0.94;
1388	1	0.00	0.00	0.00	0.00	1	1.0514	-3.0446	132.00	1	1.06	0.94;
1389	1	0.00	0.00	0.00	0.00	1	1.0530	-3.0537	132.00	1	1.06	0.94;
1390	1	0.00	0.00	0.00	0.00	1	1.0266	2.9910	132.00	1	1.06	0.94;
1391	1	0.00	0.00	0.00	0.00	1	1.0530	33.2079	275.00	1	1.06	0.94;
1392	2	0.00	0.00	0.00	0.00	1	1.0530	39.2795	275.00	1	1.06	0.94;
1393	2	0.00	0.00	0.00	0.00	1	1.0530	39.2795	275.00	1	1.06	0.94;
1394	2	0.00	0.00	0.00	0.00	1	1.0530	39.1267	275.00	1	1.06	0.94;
1395	2	0.00	0.00	0.00	0.00	1	1.0530	39.1267	275.00	1	1.06	0.94;
1396	1	0.00	0.00	0.00	-1.50	1	1.0477	30.7287	400.00	1	1.06	0.94;
1397	2	0.00	0.00	0.00	0.00	1	1.0530	33.2489	400.00	1	1.06	0.94;
1398	2	0.00	0.00	0.00	0.00	1	1.0530	33.2489	400.00	1	1.06	0.94;
1399	1	0.00	0.00	0.00	0.00	1	1.0530	31.3501	400.00	1	1.06	0.94;
1400	2	0.00	0.00	0.00	0.00	1	1.0530	33.8365	400.00	1	1.06	0.94;
1401	2	0.00	0.00	0.00	0.00	1	1.0530	33.8089	400.00	1	1.06	0.94;
1402	1	0.00	0.00	0.00	0.00	1	1.0197	36.1249	132.00	1	1.06	0.94;
1403	2	0.00	0.00	0.00	0.00	1	1.0530	43.7212	132.00	1	1.06	0.94;
1404	1	0.00	0.00	0.00	0.00	1	1.0148	35.1869	132.00	1	1.06	0.94;
1405	2	0.00	0.00	0.00	0.00	1	1.0530	50.4234	132.00	1	1.06	0.94;
1406	1	0.00	0.00	0.00	0.00	1	1.0530	36.3887	275.00	1	1.06	0.94;
1407	2	0.00	0.00	0.00	0.00	1	1.0530	39.3608	275.00	1	1.06	0.94;
1408	2	0.00	0.00	0.00	0.00	1	1.0530	39.3608	275.00	1	1.06	0.94;
1409	2	0.00	0.00	0.00	0.00	1	1.0530	39.3454	275.00	1	1.06	0.94;
1410	2	0.00	0.00	0.00	0.00	1	1.0530	39.3588	275.00	1	1.06	0.94;
1411	1	0.00	0.00	0.00	0.00	1	1.0524	42.0726	275.00	1	1.06	0.94;
1412	2	0.00	0.00	0.00	0.00	1	1.0530	49.9272	275.00	1	1.06	0.94;
1413	2	0.00	0.00	0.00	0.00	1	1.0530	49.8903	275.00	1	1.06	0.94;
1414	1	0.00	0.00	0.00	0.00	1	1.0522	42.2583	275.00	1	1.06	0.94;
1415	2	0.00	0.00	0.00	0.00	1	1.0530	49.9067	275.00	1	1.06	0.94;
1416	2	0.00	0.00	0.00	0.00	1	1.0530	49.9067	275.00	1	1.06	0.94;
1417	1	0.00	0.00	0.00	0.00	1	1.0530	43.6450	33.00	1	1.06	0.94;
1418	2	0.00	0.00	0.00	0.00	1	1.0530	46.6528	33.00	1	1.06	0.94;
1419	1	0.00	0.00	0.00	0.00	1	1.0530	43.1071	33.00	1	1.06	0.94;
1420	2	0.00	0.00	0.00	0.00	1	1.0530	48.4825	33.00	1	1.06	0.94;
1421	1	0.00	0.00	0.00	0.00	1	1.0530	43.1033	33.00	1	1.06	0.94;
1422	2	0.00	0.00	0.00	0.00	1	1.0530	48.4747	33.00	1	1.06	0.94;
1423	1	0.00	0.00	0.00	0.00	1	1.0530	28.1557	33.00	1	1.06	0.94;
1424	2	0.00	0.00	0.00	0.00	1	1.0530	31.8858	33.00	1	1.06	0.94;
1425	1	0.00	0.00	0.00	0.00	1	1.0530	38.4046	33.00	1	1.06	0.94;
1426	2	0.00	0.00	0.00	0.00	1	1.0530	41.6571	33.00	1	1.06	0.94;
1427	1	0.00	0.00	0.00	0.00	1	1.0530	36.3763	33.00	1	1.06	0.94;
1428	2	0.00	0.00	0.00	0.00	1	1.0530	39.3056	33.00	1	1.06	0.94;
1429	1	0.00	0.00	0.00	0.00	1	1.0514	32.4356	33.00	1	1.06	0.94;
1430	2	0.00	0.00	0.00	0.00	1	1.0530	34.8339	33.00	1	1.06	0.94;
1431	1	0.00	0.00	0.00	0.00	1	1.0530	33.2040	33.00	1	1.06	0.94;
1432	2	0.00	0.00	0.00	0.00	1	1.0530	43.8143	33.00	1	1.06	0.94;
1433	1	0.00	0.00	0.00	0.00	1	1.0530	40.2347	33.00	1	1.06	0.94;
1434	2	0.00	0.00	0.00	0.00	1	1.0530	43.0907	33.00	1	1.06	0.94;
1435	1	0.00	0.00	0.00	0.00	1	1.0530	40.2347	33.00	1	1.06	0.94;
1436	2	0.00	0.00	0.00	0.00	1	1.0530	43.0907	33.00	1	1.06	0.94;
1437	1	0.00	0.00	0.00	0.00	1	1.0530	40.2347	33.00	1	1.06	0.94;
1438	2	0.00	0.00	0.00	0.00	1	1.0530	43.0907	33.00	1	1.06	0.94;
1439	1	0.00	0.00	0.00	0.00	1	1.0530	35.5741	33.00	1	1.06	0.94;
1440	2	0.00	0.00	0.00	0.00	1	1.0530	39.7204	33.00	1	1.06	0.94;
1441	1	0.00	0.00	0.00	0.00	1	0.9907	25.2230	132.00	1	1.06	0.94;
1442	1	0.00	0.00	0.00	0.00	1	1.0259	25.0326	132.00	1	1.06	0.94;
1443	1	0.00	0.00	0.00	0.00	1	0.9876	24.9972	132.00	1	1.06	0.94;
1444	1	0.00	0.00	0.00	0.00	1	1.0530	24.5750	275.00	1	1.06	0.94;
1445	1	0.00	0.00	0.00	0.00	1	1.0510	29.4738	400.00	1	1.06	0.94;
1446	1	0.00	0.00	0.00	0.00	1	1.0240	26.8937	275.00	1	1.06	0.94;
1447	1	0.00	0.00	0.00	0.00	1	1.0245	26.9568	275.00	1	1.06	0.94;
1448	1	0.00	0.00	0.00	0.00	1	1.0240	26.8934	275.00	1	1.06	0.94;
1449	1	0.00	0.00	0.00	0.00	1	1.0245	26.9568	275.00	1	1.06	0.94;
1450	1	0.00	0.00	0.00	0.00	1	1.0472	25.8037	132.00	1	1.06	0.94;
1451	1	0.00	0.00	0.00	0.00	1	1.0530	26.0896	132.00	1	1.06	0.94;
1452	1	0.00	0.00	0.00	0.00	1	1.0452	25.7604	132.00	1	1.06	0.94;
1453	1	0.00	0.00	0.00	0.00	1	1.0530	37.7936	132.00	1	1.06	0.94;
1454	1	0.00	0.00	0.00	0.00	1	1.0382	36.8857	132.00	1	1.06	0.94;
1455	1	0.00	0.00	0.00	0.00	1	0.9881	45.9563	33.00	1	1.06	0.94;
1456	1	0.00	0.00	0.00	0.00	1	0.9864	45.8166	33.00	1	1.06	0.94;
1457	1	0.00	0.00	0.00	0.00	1	0.9860	45.7785	33.00	1	1.06	0.94;
1458	1	0.00	0.00	0.00	0.00	1	0.9859	45.7747	33.00	1	1.06	0.94;
1459	1	0.00	0.00	0.00	0.00	1	1.0475	28.0415	132.00	1	1.06	0.94;
1460	1	0.00	0.00	0.00	0.00	1	1.0530	28.3541	132.00	1	1.06	0.94;
1461	1	0.00	0.00	0.00	0.00	1	1.0475	28.0415	132.00	1	1.06	0.94;
1462	1	0.00	0.00	0.00	0.00	1	1.0530	32.2266	275.00	1	1.06	0.94;
1463	1	0.00	0.00	0.00	0.00	1	1.0530	32.2137	275.00	1	1.06	0.94;
1464	1	0.00	0.00	0.00	0.00	1	1.0530	32.2136	275.00	1	1.06	0.94;
1465	1	0.00	0.00	0.00	0.00	1	1.0497	32.1313	275.00	1	1.06	0.94;
1466	1	0.00	0.00	0.00	0.00	1	1.0530	32.6817	275.00	1	1.06	0.94;
1467	1	0.00	0.00	0.00	0.00	1	1.0051	28.1003	132.00	1	1.06	0.94;
1468	1	0.00	0.00	0.00	0.00	1	1.0049	28.0779	132.00	1	1.06	0.94;
1469	1	0.00	0.00	0.00	0.00	1	1.0517	30.3024	132.00	1	1.06	0.94;
1470	1	0.00	0.00	0.00	0.00	1	1.0530	30.3830	132.00	1	1.06	0.94;
1471	1	0.00	0.00	0.00	0.00	1	1.0517	30.3016	132.00	1	1.06	0.94;
1472	1	0.00	0.00	0.00	0.00	1	0.9955	25.0035	132.00	1	1.06	0.94;
1473	1	0.00	0.00	0.00	0.00	1	0.9907	25.2218	132.00	1	1.06	0.94;
1474	1	0.00	0.00	0.00	0.00	1	0.9907	25.2216	132.00	1	1.06	0.94;
1475	1	0.00	0.00	0.00	0.00	1	1.0492	32.3831	275.00	1	1.06	0.94;
1476	1	0.00	0.00	0.00	0.00	1	1.0494	32.3975	275.00	1	1.06	0.94;
1477	1	0.00	0.00	0.00	0.00	1	1.0493	32.3887	275.00	1	1.06	0.94;
1478	1	0.00	0.00	0.00	0.00	1	1.0495	32.4016	275.00	1	1.06	0.94;
1479	1	0.00	0.00	0.00	0.00	1	1.0495	32.4850	275.00	1	1.06	0.94;
1480	1	0.00	0.00	0.00	0.00	1	1.0495	32.8167	275.00	1	1.06	0.94;
1481	1	0.00	0.00	0.00	0.00	1	1.0495	32.2902	275.00	1	1.06	0.94;
1482	1	0.00	0.00	0.00	0.00	1	1.0495	32.2901	275.00	1	1.06	0.94;
1483	1	0.00	0.00	0.00	0.00	1	1.0511	32.6929	275.00	1	1.06	0.94;
1484	1	0.00	0.00	0.00	0.00	1	1.0514	32.7168	275.00	1	1.06	0.94;
1485	1	0.00	0.00	0.00	0.00	1	1.0527	31.2934	400.00	1	1.06	0.94;
1486	1	0.00	0.00	0.00	0.00	1	1.0477	29.7278	400.00	1	1.06	0.94;
1487	1	0.00	0.00	0.00	0.00	1	1.0527	31.2934	400.00	1	1.06	0.94;
1488	1	0.00	0.00	0.00	0.00	1	1.0240	26.9183	275.00	1	1.06	0.94;
1489	1	300.00	153.00	0.00	2.65	1	0.9485	21.0088	275.00	1	1.06	0.94;
1490	1	0.00	0.00	0.00	0.00	1	0.9512	28.9406	132.00	1	1.06	0.94;
1491	1	0.00	0.00	0.00	0.00	1	0.9590	30.4914	132.00	1	1.06	0.94;
1492	1	0.00	0.00	0.00	0.00	1	0.9470	28.6218	132.00	1	1.06	0.94;
1493	1	0.00	0.00	0.00	0.00	1	0.9729	28.2028	132.00	1	1.06	0.94;
1494	1	0.00	0.00	0.00	0.00	1	1.0291	27.3978	275.00	1	1.06	0.94;
1495	1	0.00	0.00	0.00	0.00	1	1.0488	33.0064	275.00	1	1.06	0.94;
1496	1	0.00	0.00	0.00	0.00	1	1.0487	32.9841	275.00	1	1.06	0.94;
1497	1	0.00	0.00	0.00	0.00	1	1.0487	32.9839	275.00	1	1.06	0.94;
1498	1	0.00	0.00	0.00	0.00	1	1.0461	35.4652	275.00	1	1.06	0.94;
1499	1	0.00	0.00	0.00	0.00	1	1.0486	36.2724	275.00	1	1.06	0.94;
1500	1	0.00	0.00	0.00	0.00	1	1.0509	32.6231	275.00	1	1.06	0.94;
1501	1	0.00	0.00	0.00	0.00	1	1.0510	32.6313	275.00	1	1.06	0.94;
1502	1	0.00	0.00	0.00	0.00	1	1.0510	32.6243	275.00	1	1.06	0.94;
1503	1	0.00	0.00	0.00	0.00	1	1.0510	32.6325	275.00	1	1.06	0.94;
1504	1	0.00	0.00	0.00	0.00	1	1.0530	25.8921	132.00	1	1.06	0.94;
1505	1	0.00	0.00	0.00	0.00	1	1.0530	31.7768	132.00	1	1.06	0.94;
1506	1	0.00	0.00	0.00	0.00	1	1.0516	31.5702	132.00	1	1.06	0.94;
1507	1	0.00	0.00	0.00	0.00	1	1.0530	31.7768	132.00	1	1.06	0.94;
1508	1	0.00	0.00	0.00	0.00	1	1.0516	31.5702	132.00	1	1.06	0.94;
1509	1	0.00	0.00	0.00	0.00	1	1.0136	27.6858	132.00	1	1.06	0.94;
1510	1	0.00	0.00	0.00	0.00	1	1.0134	27.6716	132.00	1	1.06	0.94;
1511	1	0.00	0.00	0.00	0.00	1	1.0496	32.3838	275.00	1	1.06	0.94;
1512	1	0.00	0.00	0.00	0.00	1	1.0491	32.2414	275.00	1	1.06	0.94;
1513	1	0.00	0.00	0.00	0.00	1	1.0491	32.2411	275.00	1	1.06	0.94;
1514	1	0.00	0.00	0.00	0.00	1	1.0508	32.5742	275.00	1	1.06	0.94;
1515	1	0.00	0.00	0.00	0.00	1	1.0454	28.0617	275.00	1	1.06	0.94;
1516	1	0.00	0.00	0.00	0.00	1	1.0419	29.5600	275.00	1	1.06	0.94;
1517	1	0.00	0.00	0.00	0.00	1	1.0079	24.4565	132.00	1	1.06	0.94;
1518	1	0.00	0.00	0.00	0.00	1	1.0103	26.9805	132.00	1	1.06	0.94;
1519	1	0.00	0.00	0.00	0.00	1	1.0511	26.3194	132.00	1	1.06	0.94;
1520	1	0.00	0.00	0.00	0.00	1	1.0093	26.5944	132.00	1	1.06	0.94;
1521	1	0.00	0.00	0.00	0.00	1	1.0093	26.6084	132.00	1	1.06	0.94;
1522	1	0.00	0.00	0.00	0.00	1	1.0525	28.1912	132.00	1	1.06	0.94;
1523	1	0.00	0.00	0.00	0.00	1	1.0519	28.1671	132.00	1	1.06	0.94;
1524	1	0.00	0.00	0.00	0.00	1	1.0525	28.1899	132.00	1	1.06	0.94;
1525	1	0.00	0.00	0.00	0.00	1	1.0519	28.1655	132.00	1	1.06	0.94;
1526	1	0.00	0.00	0.00	0.00	1	0.9590	30.4923	132.00	1	1.06	0.94;
1527	1	0.00	0.00	0.00	0.00	1	0.9751	34.0345	132.00	1	1.06	0.94;
1528	1	0.00	0.00	0.00	0.00	1	1.0516	31.5648	132.00	1	1.06	0.94;
1529	1	0.00	0.00	0.00	0.00	1	1.0516	32.2093	275.00	1	1.06	0.94;
1530	1	0.00	0.00	0.00	0.00	1	0.9595	29.2294	132.00	1	1.06	0.94;
1531	1	0.00	0.00	0.00	0.00	1	1.0287	27.3601	275.00	1	1.06	0.94;
1532	1	0.00	0.00	0.00	0.00	1	1.0287	27.3600	275.00	1	1.06	0.94;
1533	1	0.00	0.00	0.00	0.00	1	1.0437	29.2979	400.00	1	1.06	0.94;
1534	1	0.00	0.00	0.00	0.00	1	1.0463	27.9704	132.00	1	1.06	0.94;
1535	1	0.00	0.00	0.00	0.00	1	1.0462	27.9589	132.00	1	1.06	0.94;
1536	1	0.00	0.00	0.00	0.00	1	1.0517	31.9654	275.00	1	1.06	0.94;
1537	1	0.00	0.00	0.00	0.00	1	1.0515	32.5852	275.00	1	1.06	0.94;
1538	1	0.00	0.00	0.00	0.00	1	1.0515	32.5684	275.00	1	1.06	0.94;
1539	1	0.00	0.00	0.00	0.00	1	1.0515	32.5798	275.00	1	1.06	0.94;
1540	1	0.00	0.00	0.00	0.00	1	1.0514	32.5630	275.00	1	1.06	0.94;
1541	1	0.00	0.00	0.00	0.00	1	1.0516	32.2050	275.00	1	1.06	0.94;
1542	1	0.00	0.00	0.00	0.00	1	1.0516	32.2050	275.00	1	1.06	0.94;
1543	1	0.00	0.00	0.00	0.00	1	1.0528	30.3545	132.00	1	1.06	0.94;
1544	1	0.00	0.00	0.00	0.00	1	1.0528	30.3542	132.00	1	1.06	0.94;
1545	1	0.00	0.00	0.00	0.00	1	1.0530	30.1988	400.00	1	1.06	0.94;
1546	1	0.00	0.00	0.00	0.00	1	1.0520	31.4846	400.00	1	1.06	0.94;
1547	1	0.00	0.00	0.00	0.00	1	1.0434	30.6297	275.00	1	1.06	0.94;
1548	1	0.00	0.00	0.00	0.00	1	1.0513	31.2710	400.00	1	1.06	0.94;
1549	1	0.00	0.00	0.00	0.00	1	0.9894	27.1813	132.00	1	1.06	0.94;
1550	1	0.00	0.00	0.00	0.00	1	0.9902	27.2921	132.00	1	1.06	0.94;
1551	1	0.00	0.00	0.00	0.00	1	0.9884	27.1361	132.00	1	1.06	0.94;
1552	1	0.00	0.00	0.00	0.00	1	0.9734	27.3977	132.00	1	1.06	0.94;
1553	1	0.00	0.00	0.00	0.00	1	0.9729	27.3278	132.00	1	1.06	0.94;
1554	1	0.00	0.00	0.00	0.00	1	0.9730	27.6023	132.00	1	1.06	0.94;
1555	1	0.00	0.00	0.00	0.00	1	1.0060	27.4406	132.00	1	1.06	0.94;
1556	1	0.00	0.00	0.00	0.00	1	0.9904	27.1704	132.00	1	1.06	0.94;
1557	1	0.00	0.00	0.00	0.00	1	0.9817	27.6090	132.00	1	1.06	0.94;
1558	1	0.00	0.00	0.00	0.00	1	0.9690	27.7045	132.00	1	1.06	0.94;
1559	1	0.00	0.00	0.00	0.00	1	0.9690	27.7044	132.00	1	1.06	0.94;
1560	1	0.00	0.00	0.00	0.00	1	1.0483	31.5406	400.00	1	1.06	0.94;
1561	1	0.00	0.00	0.00	0.00	1	1.0495	32.4572	400.00	1	1.06	0.94;
1562	1	0.00	0.00	0.00	0.00	1	0.9712	28.0068	132.00	1	1.06	0.94;
1563	1	0.00	0.00	0.00	0.00	1	0.9705	27.9304	132.00	1	1.06	0.94;
1564	1	0.00	0.00	0.00	0.00	1	0.9712	28.0074	132.00	1	1.06	0.94;
1565	1	0.00	0.00	0.00	0.00	1	0.9705	27.9307	132.00	1	1.06	0.94;
1566	1	0.00	0.00	0.00	0.00	1	1.0530	28.1261	132.00	1	1.06	0.94;
1567	1	0.00	0.00	0.00	0.00	1	0.9723	27.2878	132.00	1	1.06	0.94;
1568	1	0.00	0.00	0.00	0.00	1	0.9876	27.1140	132.00	1	1.06	0.94;
1569	1	0.00	0.00	0.00	0.00	1	1.0443	31.6154	400.00	1	1.06	0.94;
1570	1	0.00	0.00	0.00	0.00	1	1.0530	28.2951	132.00	1	1.06	0.94;
1571	1	0.00	0.00	0.00	0.00	1	1.0514	27.9863	132.00	1	1.06	0.94;
1572	1	0.00	0.00	0.00	0.00	1	1.0530	28.2971	132.00	1	1.06	0.94;
1573	1	0.00	0.00	0.00	0.00	1	1.0530	28.2934	132.00	1	1.06	0.94;
1574	1	0.00	0.00	0.00	0.00	1	1.0518	27.8427	132.00	1	1.06	0.94;
1575	1	0.00	0.00	0.00	0.00	1	1.0529	28.1861	132.00	1	1.06	0.94;
1576	1	0.00	0.00	0.00	0.00	1	1.0510	27.9513	132.00	1	1.06	0.94;
1577	1	0.00	0.00	0.00	0.00	1	1.0516	27.8082	132.00	1	1.06	0.94;
1578	1	0.00	0.00	0.00	0.00	1	1.0513	27.9672	132.00	1	1.06	0.94;
1579	1	0.00	0.00	0.00	0.00	1	1.0483	35.2505	275.00	1	1.06	0.94;
1580	1	0.00	0.00	0.00	0.00	1	0.9728	27.5514	132.00	1	1.06	0.94;
1581	1	0.00	0.00	0.00	0.00	1	0.9812	27.5590	132.00	1	1.06	0.94;
1582	1	0.00	0.00	0.00	0.00	1	1.0503	27.9669	132.00	1	1.06	0.94;
1583	1	0.00	0.00	0.00	0.00	1	1.0503	27.9669	132.00	1	1.06	0.94;
1584	1	33.97	9.74	0.00	0.00	1	1.0530	24.8199	33.00	1	1.06	0.94;
1585	1	140.46	31.49	0.00	0.00	1	1.0530	24.8231	33.00	1	1.06	0.94;
1586	1	0.00	0.00	0.00	0.00	1	1.0488	35.2982	275.00	1	1.06	0.94;
1587	1	0.00	0.00	0.00	0.00	1	1.0489	35.3027	275.00	1	1.06	0.94;
1588	1	0.00	0.00	0.00	0.00	1	1.0485	35.2345	275.00	1	1.06	0.94;
1589	1	0.00	0.00	0.00	0.00	1	1.0485	35.2341	275.00	1	1.06	0.94;
1590	1	0.00	0.00	0.00	0.00	1	1.0510	35.9104	275.00	1	1.06	0.94;
1591	1	0.00	0.00	0.00	0.00	1	1.0484	35.2246	275.00	1	1.06	0.94;
1592	1	0.00	0.00	0.00	0.00	1	1.0484	35.2255	275.00	1	1.06	0.94;
1593	1	0.00	0.00	0.00	0.00	1	0.9599	34.5518	132.00	1	1.06	0.94;
1594	1	0.00	0.00	0.00	0.00	1	0.9603	34.5154	132.00	1	1.06	0.94;
1595	1	0.00	0.00	0.00	0.00	1	0.9640	35.3891	132.00	1	1.06	0.94;
1596	1	0.00	0.00	0.00	0.00	1	0.9590	34.5540	132.00	1	1.06	0.94;
1597	1	0.00	0.00	0.00	0.00	1	0.9595	34.5163	132.00	1	1.06	0.94;
1598	1	0.00	0.00	0.00	0.00	1	0.9623	35.2100	132.00	1	1.06	0.94;
1599	1	0.00	0.00	0.00	0.00	1	0.9609	35.0845	132.00	1	1.06	0.94;
1600	1	0.00	0.00	0.00	0.00	1	0.9605	35.1369	132.00	1	1.06	0.94;
1601	1	0.00	0.00	0.00	0.00	1	0.9890	33.7170	132.00	1	1.06	0.94;
1602	1	0.00	0.00	0.00	0.00	1	0.9977	34.2251	132.00	1	1.06	0.94;
1603	1	0.00	0.00	0.00	0.00	1	0.9885	33.4535	132.00	1	1.06	0.94;
1604	1	0.00	0.00	0.00	0.00	1	0.9966	33.9234	132.00	1	1.06	0.94;
1605	1	0.00	0.00	0.00	0.00	1	0.9744	34.6381	132.00	1	1.06	0.94;
1606	1	0.00	0.00	0.00	0.00	1	0.9672	34.7289	132.00	1	1.06	0.94;
1607	1	0.00	0.00	0.00	0.00	1	1.0138	34.9711	132.00	1	1.06	0.94;
1608	1	0.00	0.00	0.00	0.00	1	1.0083	34.1515	132.00	1	1.06	0.94;
1609	1	0.00	0.00	0.00	0.00	1	1.0048	33.9217	132.00	1	1.06	0.94;
1610	1	0.00	0.00	0.00	0.00	1	1.0143	34.7443	132.00	1	1.06	0.94;
1611	1	0.00	0.00	0.00	0.00	1	1.0083	34.1515	132.00	1	1.06	0.94;
1612	1	0.00	0.00	0.00	0.00	1	1.0048	33.9216	132.00	1	1.06	0.94;
1613	1	0.00	0.00	0.00	0.00	1	1.0179	35.8405	132.00	1	1.06	0.94;
1614	1	0.00	0.00	0.00	0.00	1	1.0136	34.7575	132.00	1	1.06	0.94;
1615	1	0.00	0.00	0.00	0.00	1	1.0072	34.7805	132.00	1	1.06	0.94;
1616	1	0.00	0.00	0.00	0.00	1	1.0419	38.1315	275.00	1	1.06	0.94;
1617	1	0.00	0.00	0.00	0.00	1	1.0428	37.5603	275.00	1	1.06	0.94;
1618	1	0.00	0.00	0.00	0.00	1	1.0422	38.8810	275.00	1	1.06	0.94;
1619	1	0.00	0.00	0.00	0.00	1	1.0491	36.2803	275.00	1	1.06	0.94;
1620	1	0.00	0.00	0.00	0.00	1	1.0491	36.2802	275.00	1	1.06	0.94;
1621	1	0.00	0.00	0.00	0.00	1	1.0482	36.9374	275.00	1	1.06	0.94;
1622	1	0.00	0.00	0.00	0.00	1	1.0482	36.7820	275.00	1	1.06	0.94;
1623	1	0.00	0.00	0.00	0.00	1	0.9968	34.1714	132.00	1	1.06	0.94;
1624	1	0.00	0.00	0.00	0.00	1	0.9959	33.8750	132.00	1	1.06	0.94;
1625	1	0.00	0.00	0.00	0.00	1	1.0445	37.0427	275.00	1	1.06	0.94;
1626	1	0.00	0.00	0.00	0.00	1	1.0142	34.7400	132.00	1	1.06	0.94;
1627	1	0.00	0.00	0.00	0.00	1	1.0142	34.7404	132.00	1	1.06	0.94;
1628	1	0.00	0.00	0.00	0.00	1	1.0427	37.1766	275.00	1	1.06	0.94;
1629	1	0.00	0.00	0.00	0.00	1	1.0428	37.4215	275.00	1	1.06	0.94;
1630	1	0.00	0.00	0.00	0.00	1	0.9662	34.6399	132.00	1	1.06	0.94;
1631	1	0.00	0.00	0.00	0.00	1	0.9692	35.1307	132.00	1	1.06	0.94;
1632	1	0.00	0.00	0.00	0.00	1	0.9680	35.0335	132.00	1	1.06	0.94;
1633	1	0.00	0.00	0.00	0.00	1	1.0430	38.8772	275.00	1	1.06	0.94;
1634	1	0.00	0.00	0.00	0.00	1	1.0530	41.5188	275.00	1	1.06	0.94;
1635	1	0.00	0.00	0.00	0.00	1	1.0530	41.5189	275.00	1	1.06	0.94;
1636	1	0.00	0.00	0.00	0.00	1	1.0525	40.9032	275.00	1	1.06	0.94;
1637	1	0.00	0.00	0.00	0.00	1	1.0482	35.2288	275.00	1	1.06	0.94;
1638	1	0.00	0.00	0.00	0.00	1	1.0482	35.2310	275.00	1	1.06	0.94;
1639	1	0.00	0.00	0.00	0.00	1	0.9580	38.2982	132.00	1	1.06	0.94;
1640	1	0.00	0.00	0.00	0.00	1	0.9573	38.2610	132.00	1	1.06	0.94;
1641	1	0.00	0.00	0.00	0.00	1	0.9574	38.2432	132.00	1	1.06	0.94;
1642	1	0.00	0.00	0.00	0.00	1	0.9586	38.3742	132.00	1	1.06	0.94;
1643	1	0.00	0.00	0.00	0.00	1	0.9927	43.7331	132.00	1	1.06	0.94;
1644	1	0.00	0.00	0.00	0.00	1	0.9926	43.7343	132.00	1	1.06	0.94;
1645	1	0.00	0.00	0.00	0.00	1	0.9982	44.4772	132.00	1	1.06	0.94;
1646	1	0.00	0.00	0.00	0.00	1	0.9927	43.7291	132.00	1	1.06	0.94;
1647	1	0.00	0.00	0.00	0.00	1	0.9926	43.7303	132.00	1	1.06	0.94;
1648	1	0.00	0.00	0.00	0.00	1	0.9984	44.4855	132.00	1	1.06	0.94;
1649	1	0.00	0.00	0.00	0.00	1	0.9782	41.8442	132.00	1	1.06	0.94;
1650	1	0.00	0.00	0.00	0.00	1	0.9964	44.3235	132.00	1	1.06	0.94;
1651	1	0.00	0.00	0.00	0.00	1	0.9570	38.2447	132.00	1	1.06	0.94;
1652	1	0.00	0.00	0.00	0.00	1	0.9584	38.3531	132.00	1	1.06	0.94;
1653	1	0.00	0.00	0.00	0.00	1	0.9584	38.3530	132.00	1	1.06	0.94;
1654	1	0.00	0.00	0.00	0.00	1	0.9577	38.2093	132.00	1	1.06	0.94;
1655	1	0.00	0.00	0.00	0.00	1	0.9587	39.6394	132.00	1	1.06	0.94;
1656	1	0.00	0.00	0.00	0.00	1	0.9944	44.2832	132.00	1	1.06	0.94;
1657	1	0.00	0.00	0.00	0.00	1	0.9926	43.7507	132.00	1	1.06	0.94;
1658	1	0.00	0.00	0.00	0.00	1	0.9927	43.7467	132.00	1	1.06	0.94;
1659	1	0.00	0.00	0.00	0.00	1	1.0409	30.0534	275.00	1	1.06	0.94;
1660	1	0.00	0.00	0.00	0.00	1	0.9836	38.9217	132.00	1	1.06	0.94;
1661	1	0.00	0.00	0.00	0.00	1	0.9836	38.9050	132.00	1	1.06	0.94;
1662	1	32.98	14.90	0.00	0.00	1	1.0458	23.4805	33.00	1	1.06	0.94;
1663	1	27.02	3.77	0.00	0.00	1	1.0530	24.1039	33.00	1	1.06	0.94;
1664	1	47.78	13.91	0.00	0.00	1	1.0239	28.8267	33.00	1	1.06	0.94;
1665	1	0.00	0.00	0.00	0.00	1	1.0239	28.8267	33.00	1	1.06	0.94;
1666	1	0.00	0.00	0.00	0.00	1	1.0239	28.8267	33.00	1	1.06	0.94;
1667	1	45.60	12.91	0.00	0.00	1	1.0290	24.5726	33.00	1	1.06	0.94;
1668	1	27.02	5.66	0.00	0.00	1	1.0265	34.0532	33.00	1	1.06	0.94;
1669	1	23.54	-6.95	0.00	0.00	1	1.0530	25.0138	33.00	1	1.06	0.94;
1670	1	10.13	3.38	0.00	0.00	1	1.0473	24.8137	33.00	1	1.06	0.94;
1671	1	68.05	16.69	0.00	0.00	1	0.9913	33.3137	33.00	1	1.06	0.94;
1672	1	0.00	0.00	0.00	0.00	1	1.0491	32.3340	275.00	1	1.06	0.94;
1673	1	0.00	0.00	0.00	0.00	1	1.0516	31.9184	275.00	1	1.06	0.94;
1674	1	0.00	0.00	0.00	0.00	1	1.0518	32.7452	275.00	1	1.06	0.94;
1675	1	61.29	16.19	0.00	0.00	1	1.0123	32.3911	33.00	1	1.06	0.94;
1676	1	0.00	0.00	0.00	0.00	1	1.0530	32.6800	275.00	1	1.06	0.94;
1677	1	0.00	0.00	0.00	0.00	1	0.9731	28.2063	132.00	1	1.06	0.94;
1678	1	45.40	-10.23	0.00	0.00	1	1.0530	25.0293	33.00	1	1.06	0.94;
1679	1	35.17	7.25	0.00	0.00	1	1.0530	25.8190	33.00	1	1.06	0.94;
1680	1	62.19	15.30	0.00	0.00	1	1.0530	23.8722	33.00	1	1.06	0.94;
1681	1	0.00	0.00	0.00	0.00	1	1.0245	25.8037	132.00	1	1.06	0.94;
1682	1	0.00	0.00	0.00	0.00	1	1.0234	25.7604	132.00	1	1.06	0.94;
1683	2	0.00	0.00	0.00	0.00	1	1.0530	55.9186	33.00	1	1.06	0.94;
1684	1	59.70	16.69	0.00	0.00	1	1.0530	23.8883	33.00	1	1.06	0.94;
1685	1	-6.66	0.00	0.00	0.00	1	1.0068	30.9346	132.00	1	1.06	0.94;
1686	1	59.90	14.70	0.00	0.00	1	1.0530	26.4356	33.00	1	1.06	0.94;
1687	1	0.00	0.00	0.00	0.00	1	1.0267	30.3024	132.00	1	1.06	0.94;
1688	1	0.00	0.00	0.00	0.00	1	1.0267	30.3016	132.00	1	1.06	0.94;
1689	1	87.52	24.74	0.00	0.00	1	1.0530	28.1522	33.00	1	1.06	0.94;
1690	1	73.71	14.80	0.00	0.00	1	1.0530	28.7367	33.00	1	1.06	0.94;
1691	1	41.62	8.34	0.00	0.00	1	1.0530	31.2319	33.00	1	1.06	0.94;
1692	1	100.23	25.13	0.00	0.00	1	1.0530	27.7863	33.00	1	1.06	0.94;
1693	1	10.33	6.16	0.00	0.00	1	1.0530	23.9430	33.00	1	1.06	0.94;
1694	1	16.79	3.38	0.00	0.00	1	1.0530	21.9210	11.00	1	1.06	0.94;
1695	1	-6.85	-0.99	0.00	0.00	1	1.0224	30.5048	132.00	1	1.06	0.94;
1696	1	0.00	0.00	0.00	0.00	1	0.9951	25.2218	132.00	1	1.06	0.94;
1697	1	0.00	0.00	0.00	0.00	1	1.0118	25.2216	132.00	1	1.06	0.94;
1698	1	91.99	18.28	0.00	0.00	1	1.0530	28.5409	33.00	1	1.06	0.94;
1699	1	64.67	15.70	0.00	0.00	1	1.0530	29.3079	33.00	1	1.06	0.94;
1700	1	35.86	9.14	0.00	0.00	1	1.0530	30.3601	33.00	1	1.06	0.94;
1701	1	0.00	0.00	0.00	0.00	1	1.0235	28.0617	275.00	1	1.06	0.94;
1702	1	0.00	0.00	0.00	0.00	1	1.0235	28.0617	275.00	1	1.06	0.94;
1703	1	35.86	9.44	0.00	0.00	1	1.0530	22.4669	33.00	1	1.06	0.94;
1704	1	70.93	14.30	0.00	0.00	1	1.0530	28.9081	33.00	1	1.06	0.94;
1705	1	-19.67	0.00	0.00	0.00	1	1.0081	35.7139	132.00	1	1.06	0.94;
1706	1	33.68	9.64	0.00	0.00	1	1.0530	26.3258	33.00	1	1.06	0.94;
1707	1	30.40	7.55	0.00	0.00	1	1.0530	22.4737	33.00	1	1.06	0.94;
1708	1	0.00	0.00	0.00	0.00	1	1.0267	31.5702	132.00	1	1.06	0.94;
1709	1	0.00	0.00	0.00	0.00	1	1.0267	31.5702	132.00	1	1.06	0.94;
1710	1	91.69	19.37	0.00	0.00	1	1.0530	28.0227	33.00	1	1.06	0.94;
1711	1	-11.72	0.00	0.00	0.00	1	1.0048	32.8492	132.00	1	1.06	0.94;
1712	1	36.85	7.35	0.00	0.00	1	1.0530	25.1346	33.00	1	1.06	0.94;
1713	1	94.57	33.97	0.00	0.00	1	1.0530	23.0239	33.00	1	1.06	0.94;
1714	1	68.74	19.67	0.00	0.00	1	1.0530	22.9672	33.00	1	1.06	0.94;
1715	1	19.87	5.56	0.00	0.00	1	1.0530	28.7982	33.00	1	1.06	0.94;
1716	1	80.36	19.97	0.00	0.00	1	1.0530	28.4938	33.00	1	1.06	0.94;
1717	1	90.30	22.65	0.00	0.00	1	1.0530	28.3755	33.00	1	1.06	0.94;
1718	1	0.00	0.00	0.00	0.00	1	1.0266	32.5852	275.00	1	1.06	0.94;
1719	1	0.00	0.00	0.00	0.00	1	1.0266	32.5798	275.00	1	1.06	0.94;
1720	1	14.60	4.07	0.00	0.00	1	1.0530	31.3041	33.00	1	1.06	0.94;
1721	1	28.31	7.05	0.00	0.00	1	1.0530	28.8172	33.00	1	1.06	0.94;
1722	1	0.00	0.00	0.00	0.00	1	1.0273	30.3545	132.00	1	1.06	0.94;
1723	1	0.00	0.00	0.00	0.00	1	1.0273	30.3542	132.00	1	1.06	0.94;
1724	1	58.71	16.99	0.00	0.00	1	1.0530	29.6048	33.00	1	1.06	0.94;
1725	1	105.30	16.89	0.00	0.00	1	1.0530	27.9785	33.00	1	1.06	0.94;
1726	1	54.93	11.42	0.00	0.00	1	1.0530	29.3242	33.00	1	1.06	0.94;
1727	1	32.28	4.57	0.00	0.00	1	1.0530	26.4787	33.00	1	1.06	0.94;
1728	2	24.64	9.44	0.00	0.00	1	1.0491	28.5273	132.00	1	1.06	0.94;
1729	1	64.07	13.11	0.00	0.00	1	1.0530	29.3840	33.00	1	1.06	0.94;
1730	1	73.71	14.70	0.00	0.00	1	1.0530	28.7113	33.00	1	1.06	0.94;
1731	1	0.00	0.00	0.00	0.00	1	1.0266	32.2093	275.00	1	1.06	0.94;
1732	1	0.00	0.00	0.00	0.00	1	1.0266	32.2093	275.00	1	1.06	0.94;
1733	1	40.33	12.62	0.00	0.00	1	1.0530	24.5840	33.00	1	1.06	0.94;
1734	1	34.77	7.65	0.00	0.00	1	1.0530	25.9443	33.00	1	1.06	0.94;
1735	1	29.30	5.86	0.00	0.00	1	1.0530	26.0650	33.00	1	1.06	0.94;
1736	1	35.76	8.74	0.00	0.00	1	1.0530	26.2050	33.00	1	1.06	0.94;
1737	1	23.94	7.25	0.00	0.00	1	1.0530	25.2697	33.00	1	1.06	0.94;
1738	1	39.73	9.74	0.00	0.00	1	1.0530	25.1856	33.00	1	1.06	0.94;
1739	1	46.09	13.41	0.00	0.00	1	1.0530	24.8155	33.00	1	1.06	0.94;
1740	1	6.46	2.78	0.00	0.00	1	1.0530	28.0251	33.00	1	1.06	0.94;
1741	1	47.78	11.82	0.00	0.00	1	1.0530	25.3020	33.00	1	1.06	0.94;
1742	1	38.64	9.44	0.00	0.00	1	1.0530	25.2567	33.00	1	1.06	0.94;
1743	1	45.50	9.04	0.00	0.00	1	1.0530	25.1885	33.00	1	1.06	0.94;
1744	1	0.00	0.00	0.00	0.00	1	1.0266	27.8082	132.00	1	1.06	0.94;
1745	1	0.00	0.00	0.00	0.00	1	1.0268	27.8427	132.00	1	1.06	0.94;
1746	1	42.52	12.02	0.00	0.00	1	1.0530	25.1078	33.00	1	1.06	0.94;
1747	1	82.25	20.66	0.00	0.00	1	1.0530	31.4271	33.00	1	1.06	0.94;
1748	1	71.52	23.54	0.00	0.00	1	1.0530	31.9467	33.00	1	1.06	0.94;
1749	1	64.57	16.69	0.00	0.00	1	1.0530	30.1653	33.00	1	1.06	0.94;
1750	1	41.13	11.62	0.00	0.00	1	1.0530	33.0603	33.00	1	1.06	0.94;
1751	1	47.68	11.72	0.00	0.00	1	1.0530	31.7226	33.00	1	1.06	0.94;
1752	1	67.55	21.26	0.00	0.00	1	1.0530	30.2412	33.00	1	1.06	0.94;
1753	1	5.36	1.99	0.00	0.00	1	1.0530	34.1410	33.00	1	1.06	0.94;
1754	1	39.93	10.03	0.00	0.00	1	1.0530	31.6531	33.00	1	1.06	0.94;
1755	1	27.52	7.15	0.00	0.00	1	1.0530	32.8136	33.00	1	1.06	0.94;
1756	1	51.85	16.89	0.00	0.00	1	1.0530	34.9422	33.00	1	1.06	0.94;
1757	1	54.14	13.11	0.00	0.00	1	1.0530	30.6709	33.00	1	1.06	0.94;
1758	1	42.22	12.22	0.00	0.00	1	1.0530	31.8293	33.00	1	1.06	0.94;
1759	1	11.67	0.00	0.00	0.00	1	1.0530	33.5356	11.00	1	1.06	0.94;
1760	1	11.67	0.00	0.00	0.00	1	1.0530	33.5361	11.00	1	1.06	0.94;
1761	1	42.02	10.23	0.00	0.00	1	1.0530	32.6690	33.00	1	1.06	0.94;
1762	1	77.68	25.53	0.00	0.00	1	1.0530	29.5795	33.00	1	1.06	0.94;
1763	1	79.67	15.89	0.00	0.00	1	1.0530	31.3825	33.00	1	1.06	0.94;
1764	1	20.86	4.17	0.00	0.00	1	1.0530	40.5012	33.00	1	1.06	0.94;
1765	1	70.83	14.11	0.00	0.00	1	1.0530	33.7736	33.00	1	1.06	0.94;
1766	1	24.54	6.06	0.00	0.00	1	1.0530	36.8653	33.00	1	1.06	0.94;
1767	1	11.03	2.78	0.00	0.00	1	1.0530	35.6461	11.00	1	1.06	0.94;
1768	1	45.99	11.62	0.00	0.00	1	1.0530	35.7416	33.00	1	1.06	0.94;
1769	1	66.37	17.58	0.00	0.00	1	1.0530	35.4665	33.00	1	1.06	0.94;
1770	1	0.00	0.00	0.00	0.00	1	0.9781	39.6394	132.00	1	1.06	0.94;
1771	1	0.00	0.00	0.00	0.00	1	0.9781	39.6394	132.00	1	1.06	0.94;
1772	1	12.72	0.00	0.00	0.00	1	1.0530	42.8424	33.00	1	1.06	0.94;
1773	1	56.03	85.13	0.00	0.00	1	0.9470	26.8826	275.00	1	1.06	0.94;
1774	1	48.08	-24.04	0.00	0.00	1	1.0530	25.8658	33.00	1	1.06	0.94;
1775	1	12.72	3.28	0.00	0.00	1	1.0530	25.8212	11.00	1	1.06	0.94;
1776	1	33.97	8.34	0.00	0.00	1	1.0530	26.4091	33.00	1	1.06	0.94;
1777	1	0.00	0.00	0.00	0.00	1	1.0274	28.1261	132.00	1	1.06	0.94;
1778	1	0.00	0.00	0.00	0.00	1	1.0274	28.1261	132.00	1	1.06	0.94;
1779	1	-3.97	0.00	0.00	0.00	1	1.0530	35.2917	33.00	1	1.06	0.94;
1780	1	-3.97	0.00	0.00	0.00	1	1.0530	35.2917	33.00	1	1.06	0.94;
1781	1	33.58	9.44	0.00	0.00	1	1.0530	33.6670	33.00	1	1.06	0.94;
1782	1	73.01	19.77	0.00	0.00	1	1.0530	27.6537	33.00	1	1.06	0.94;
1783	1	0.00	0.00	0.00	0.00	1	1.0402	61.7423	132.00	1	1.06	0.94;
1784	1	-20.00	0.00	0.00	0.00	1	1.0530	66.3861	132.00	1	1.06	0.94;
1785	1	0.00	0.00	0.00	0.00	1	1.0432	50.5077	33.00	1	1.06	0.94;
1786	2	0.00	0.00	0.00	0.00	1	1.0530	52.6123	33.00	1	1.06	0.94;
1787	1	0.00	0.00	0.00	0.00	1	1.0182	54.1108	33.00	1	1.06	0.94;
1788	2	0.00	0.00	0.00	0.00	1	1.0185	55.5541	33.00	1	1.06	0.94;
1789	1	0.00	0.00	0.00	0.00	1	1.0469	66.2143	33.00	1	1.06	0.94;
1790	2	0.00	0.00	0.00	0.00	1	1.0530	67.7663	33.00	1	1.06	0.94;
1791	1	0.00	0.00	0.00	0.00	1	1.0530	70.4116	33.00	1	1.06	0.94;
1792	2	0.00	0.00	0.00	0.00	1	1.0530	73.6614	33.00	1	1.06	0.94;
1793	1	0.00	0.00	0.00	0.00	1	1.0530	49.8798	33.00	1	1.06	0.94;
1794	2	0.00	0.00	0.00	0.00	1	1.0530	54.2773	33.00	1	1.06	0.94;
1795	1	0.00	0.00	0.00	0.00	1	1.0289	55.2309	33.00	1	1.06	0.94;
1796	2	0.00	0.00	0.00	0.00	1	1.0438	58.1231	33.00	1	1.06	0.94;
1797	1	0.00	0.00	0.00	0.00	1	1.0277	45.5687	33.00	1	1.06	0.94;
1798	2	0.00	0.00	0.00	0.00	1	1.0530	49.6901	33.00	1	1.06	0.94;
1799	1	0.00	0.00	0.00	0.00	1	1.0277	45.5687	33.00	1	1.06	0.94;
1800	2	0.00	0.00	0.00	0.00	1	1.0530	49.6901	33.00	1	1.06	0.94;
1801	1	0.00	0.00	0.00	0.00	1	1.0442	43.4898	33.00	1	1.06	0.94;
1802	2	0.00	0.00	0.00	0.00	1	1.0530	47.6929	33.00	1	1.06	0.94;
1803	1	0.00	0.00	0.00	0.00	1	1.0311	56.5359	33.00	1	1.06	0.94;
1804	2	0.00	0.00	0.00	0.00	1	1.0530	59.9254	33.00	1	1.06	0.94;
1805	1	0.00	0.00	0.00	0.00	1	1.0530	59.9139	33.00	1	1.06	0.94;
1806	2	0.00	0.00	0.00	0.00	1	1.0530	65.5974	33.00	1	1.06	0.94;
1807	1	0.00	0.00	0.00	0.00	1	1.0530	55.7665	33.00	1	1.06	0.94;
1808	1	-11.12	0.00	0.00	0.00	1	1.0530	60.3536	33.00	1	1.06	0.94;
1809	1	1.34	0.20	0.00	0.00	1	1.0530	67.3549	33.00	1	1.06	0.94;
1810	1	-10.00	0.00	0.00	0.00	1	0.9703	72.9720	33.00	1	1.06	0.94;
1811	1	0.00	0.00	0.00	0.00	1	1.0530	64.4814	33.00	1	1.06	0.94;
1812	2	0.00	0.00	0.00	0.00	1	1.0530	67.1844	33.00	1	1.06	0.94;
1813	1	0.00	0.00	0.00	0.00	1	1.0530	64.4814	33.00	1	1.06	0.94;
1814	2	0.00	0.00	0.00	0.00	1	1.0530	67.1844	33.00	1	1.06	0.94;
1815	1	0.00	0.00	0.00	0.00	1	1.0525	62.7506	132.00	1	1.06	0.94;
1816	1	-20.00	0.00	0.00	0.00	1	1.0530	65.4930	132.00	1	1.06	0.94;
1817	1	0.00	0.00	0.00	0.00	1	1.0212	47.9363	132.00	1	1.06	0.94;
1818	1	-36.07	0.79	0.00	0.00	1	1.0062	55.0189	132.00	1	1.06	0.94;
1819	1	0.00	0.00	0.00	0.00	1	1.0352	47.0961	132.00	1	1.06	0.94;
1820	1	-20.30	0.00	0.00	0.00	1	1.0237	51.1971	132.00	1	1.06	0.94;
1821	1	0.00	0.00	0.00	0.00	1	1.0355	47.1313	132.00	1	1.06	0.94;
1822	1	-40.70	0.00	0.00	0.00	1	1.0530	51.2465	132.00	1	1.06	0.94;
1823	1	0.00	0.00	0.00	0.00	1	1.0461	56.0070	33.00	1	1.06	0.94;
1824	2	0.00	0.00	0.00	0.00	1	1.0530	58.4864	33.00	1	1.06	0.94;
1825	1	0.00	0.00	0.00	0.00	1	1.0407	52.4519	33.00	1	1.06	0.94;
1826	2	0.00	0.00	0.00	0.00	1	1.0530	54.9142	33.00	1	1.06	0.94;
1827	1	0.00	0.00	0.00	0.00	1	1.0530	53.8030	33.00	1	1.06	0.94;
1828	2	0.00	0.00	0.00	0.00	1	1.0530	56.2605	33.00	1	1.06	0.94;
1829	1	0.00	0.00	0.00	0.00	1	1.0485	62.7530	132.00	1	1.06	0.94;
1830	2	0.00	0.00	0.00	0.00	1	1.0530	68.3974	132.00	1	1.06	0.94;
1831	1	0.00	0.00	0.00	0.00	1	1.0512	63.1849	132.00	1	1.06	0.94;
1832	1	-38.00	0.00	0.00	0.00	1	1.0530	68.1184	132.00	1	1.06	0.94;
1833	1	0.00	0.00	0.00	0.00	1	1.0355	57.7806	33.00	1	1.06	0.94;
1834	2	0.00	0.00	0.00	0.00	1	1.0530	61.1702	33.00	1	1.06	0.94;
1835	1	0.00	0.00	0.00	0.00	1	1.0530	61.6971	33.00	1	1.06	0.94;
1836	1	-9.72	0.00	0.00	0.00	1	1.0530	66.2478	33.00	1	1.06	0.94;
1837	1	0.00	0.00	0.00	0.00	1	1.0330	57.9905	33.00	1	1.06	0.94;
1838	2	0.00	0.00	0.00	0.00	1	1.0530	61.3538	33.00	1	1.06	0.94;
1839	1	0.00	0.00	0.00	0.00	1	1.0481	47.7970	132.00	1	1.06	0.94;
1840	2	0.00	0.00	0.00	0.00	1	1.0530	53.0576	132.00	1	1.06	0.94;
1841	1	0.00	0.00	0.00	0.00	1	1.0481	47.7988	132.00	1	1.06	0.94;
1842	2	0.00	0.00	0.00	0.00	1	1.0529	58.4337	132.00	1	1.06	0.94;
1843	1	0.00	0.00	0.00	0.00	1	1.0378	69.5822	33.00	1	1.06	0.94;
1844	2	0.00	0.00	0.00	0.00	1	1.0530	73.4449	33.00	1	1.06	0.94;
1845	1	0.00	0.00	0.00	0.00	1	1.0378	70.5090	33.00	1	1.06	0.94;
1846	2	0.00	0.00	0.00	0.00	1	1.0530	74.3717	33.00	1	1.06	0.94;
1847	1	0.00	0.00	0.00	0.00	1	1.0486	62.4870	132.00	1	1.06	0.94;
1848	2	0.00	0.00	0.00	0.00	1	1.0328	73.9307	132.00	1	1.06	0.94;
1849	2	0.00	0.00	0.00	0.00	1	1.0417	71.7799	132.00	1	1.06	0.94;
1850	1	-23.00	0.00	0.00	0.00	1	1.0530	66.5389	132.00	1	1.06	0.94;
1851	1	0.00	0.00	0.00	0.00	1	1.0463	49.0360	132.00	1	1.06	0.94;
1852	2	0.00	0.00	0.00	0.00	1	1.0530	52.5432	132.00	1	1.06	0.94;
1853	1	0.00	0.00	0.00	0.00	1	1.0530	59.0581	275.00	1	1.06	0.94;
1854	2	0.00	0.00	0.00	0.00	1	1.0530	65.6863	275.00	1	1.06	0.94;
1855	2	0.00	0.00	0.00	0.00	1	1.0530	65.5466	275.00	1	1.06	0.94;
1856	1	0.00	0.00	0.00	0.00	1	1.0530	63.2665	33.00	1	1.06	0.94;
1857	2	0.00	0.00	0.00	0.00	1	1.0530	68.2343	33.00	1	1.06	0.94;
1858	1	0.00	0.00	0.00	0.00	1	1.0530	63.1217	33.00	1	1.06	0.94;
1859	1	-7.50	0.00	0.00	0.00	1	1.0530	67.1344	33.00	1	1.06	0.94;
1860	1	0.00	0.00	0.00	0.00	1	1.0530	62.6143	132.00	1	1.06	0.94;
1861	2	0.00	0.00	0.00	0.00	1	1.0443	71.5676	132.00	1	1.06	0.94;
1862	1	0.00	0.00	0.00	0.00	1	1.0530	58.8457	33.00	1	1.06	0.94;
1863	2	0.00	0.00	0.00	0.00	1	1.0530	61.7602	33.00	1	1.06	0.94;
1864	1	0.00	0.00	0.00	0.00	1	1.0530	50.3954	33.00	1	1.06	0.94;
1865	2	0.00	0.00	0.00	0.00	1	1.0530	53.2954	33.00	1	1.06	0.94;
1866	1	0.00	0.00	0.00	0.00	1	1.0530	63.1310	132.00	1	1.06	0.94;
1867	2	0.00	0.00	0.00	0.00	1	1.0530	67.0574	132.00	1	1.06	0.94;
1868	1	0.00	0.00	0.00	0.00	1	1.0527	49.2620	33.00	1	1.06	0.94;
1869	1	-25.00	0.00	0.00	0.00	1	1.0530	53.3316	33.00	1	1.06	0.94;
1870	1	0.00	0.00	0.00	0.00	1	1.0520	62.3859	132.00	1	1.06	0.94;
1871	1	-20.00	0.00	0.00	0.00	1	1.0529	66.5526	132.00	1	1.06	0.94;
1872	1	0.00	0.00	0.00	0.00	1	1.0383	55.0932	33.00	1	1.06	0.94;
1873	2	0.00	0.00	0.00	0.00	1	1.0474	57.4290	33.00	1	1.06	0.94;
1874	1	0.00	0.00	0.00	0.00	1	1.0530	71.1916	33.00	1	1.06	0.94;
1875	2	0.00	0.00	0.00	0.00	1	1.0530	76.8267	33.00	1	1.06	0.94;
1876	2	0.00	0.00	0.00	0.00	1	1.0530	76.8267	33.00	1	1.06	0.94;
1877	2	0.00	0.00	0.00	0.00	1	1.0530	76.8267	33.00	1	1.06	0.94;
1878	1	0.00	0.00	0.00	0.00	1	1.0398	61.6778	132.00	1	1.06	0.94;
1879	1	-20.00	0.00	0.00	0.00	1	1.0530	66.3764	132.00	1	1.06	0.94;
1880	1	0.00	0.00	0.00	0.00	1	1.0530	49.0745	33.00	1	1.06	0.94;
1881	1	-6.00	0.00	0.00	0.00	1	1.0530	53.2002	33.00	1	1.06	0.94;
1882	1	0.00	0.00	0.00	0.00	1	1.0463	49.1278	132.00	1	1.06	0.94;
1883	1	-23.50	0.00	0.00	0.00	1	1.0530	53.8141	132.00	1	1.06	0.94;
1884	1	-23.50	0.00	0.00	0.00	1	1.0530	53.7754	132.00	1	1.06	0.94;
1885	1	0.00	0.00	0.00	0.00	1	1.0285	48.7700	132.00	1	1.06	0.94;
1886	2	0.00	0.00	0.00	0.00	1	1.0530	63.5182	132.00	1	1.06	0.94;
1887	1	0.00	0.00	0.00	0.00	1	1.0492	62.9491	132.00	1	1.06	0.94;
1888	1	-17.00	0.00	0.00	0.00	1	1.0507	66.1774	132.00	1	1.06	0.94;
1889	1	0.00	0.00	0.00	0.00	1	1.0485	62.6677	132.00	1	1.06	0.94;
1890	1	-17.00	0.00	0.00	0.00	1	1.0500	65.9112	132.00	1	1.06	0.94;
1891	1	66.32	13.28	0.00	0.00	1	1.0530	37.4070	33.00	1	1.06	0.94;
1892	2	0.00	0.00	0.00	0.00	1	1.0530	40.5264	33.00	1	1.06	0.94;
1893	1	0.00	0.00	0.00	0.00	1	1.0530	71.0900	33.00	1	1.06	0.94;
1894	2	0.00	0.00	0.00	0.00	1	1.0511	74.7612	33.00	1	1.06	0.94;
1895	1	0.00	0.00	0.00	0.00	1	1.0526	63.3455	132.00	1	1.06	0.94;
1896	2	0.00	0.00	0.00	0.00	1	1.0530	65.8712	132.00	1	1.06	0.94;
1897	1	0.00	0.00	0.00	0.00	1	1.0435	67.1489	33.00	1	1.06	0.94;
1898	2	0.00	0.00	0.00	0.00	1	1.0530	71.3069	33.00	1	1.06	0.94;
1899	1	0.00	0.00	0.00	0.00	1	1.0470	62.6677	132.00	1	1.06	0.94;
1900	1	-18.00	0.00	0.00	0.00	1	1.0474	67.2576	132.00	1	1.06	0.94;
1901	1	0.00	0.00	0.00	0.00	1	1.0530	73.3325	33.00	1	1.06	0.94;
1902	2	0.00	0.00	0.00	0.00	1	1.0530	79.2488	33.00	1	1.06	0.94;
1903	1	0.00	0.00	0.00	0.00	1	1.0530	51.8509	275.00	1	1.06	0.94;
1904	2	0.00	0.00	0.00	0.00	1	1.0530	53.6091	275.00	1	1.06	0.94;
1905	1	0.00	0.00	0.00	0.00	1	1.0530	52.0257	275.00	1	1.06	0.94;
1906	2	0.00	0.00	0.00	0.00	1	1.0530	53.7915	275.00	1	1.06	0.94;
1907	1	0.00	0.00	0.00	0.00	1	1.0530	51.9787	275.00	1	1.06	0.94;
1908	2	0.00	0.00	0.00	0.00	1	1.0530	56.3379	275.00	1	1.06	0.94;
1909	1	0.00	0.00	0.00	0.00	1	1.0530	51.9800	275.00	1	1.06	0.94;
1910	2	0.00	0.00	0.00	0.00	1	1.0530	56.3442	275.00	1	1.06	0.94;
1911	1	0.00	0.00	0.00	0.00	1	1.0530	51.9036	275.00	1	1.06	0.94;
1912	2	0.00	0.00	0.00	0.00	1	1.0530	56.2697	275.00	1	1.06	0.94;
1913	1	0.00	0.00	0.00	0.00	1	1.0523	62.1115	132.00	1	1.06	0.94;
1914	2	0.00	0.00	0.00	0.00	1	1.0530	66.7553	132.00	1	1.06	0.94;
1915	1	0.00	0.00	0.00	0.00	1	1.0530	49.6926	132.00	1	1.06	0.94;
1916	2	0.00	0.00	0.00	0.00	1	1.0530	55.4863	132.00	1	1.06	0.94;
1917	1	0.00	0.00	0.00	0.00	1	1.0503	62.9389	132.00	1	1.06	0.94;
1918	2	1.67	0.30	0.00	0.00	1	1.0530	67.6825	132.00	1	1.06	0.94;
1919	1	0.00	0.00	0.00	0.00	1	1.0159	46.6717	132.00	1	1.06	0.94;
1920	2	0.00	0.00	0.00	0.00	1	1.0418	54.1315	132.00	1	1.06	0.94;
1921	1	0.00	0.00	0.00	0.00	1	1.0159	46.6717	132.00	1	1.06	0.94;
1922	2	0.00	0.00	0.00	0.00	1	1.0417	54.0731	132.00	1	1.06	0.94;
1923	1	0.00	0.00	0.00	0.00	1	1.0161	46.6846	132.00	1	1.06	0.94;
1924	2	0.00	0.00	0.00	0.00	1	1.0419	54.1099	132.00	1	1.06	0.94;
1925	1	0.00	0.00	0.00	0.00	1	1.0162	46.6571	132.00	1	1.06	0.94;
1926	2	0.00	0.00	0.00	0.00	1	1.0530	52.6606	132.00	1	1.06	0.94;
1927	1	0.00	0.00	0.00	0.00	1	1.0314	61.4228	33.00	1	1.06	0.94;
1928	2	0.00	0.00	0.00	0.00	1	1.0530	66.8224	33.00	1	1.06	0.94;
1929	1	0.00	0.00	0.00	0.00	1	1.0530	43.3234	33.00	1	1.06	0.94;
1930	2	0.00	0.00	0.00	0.00	1	1.0478	51.6151	33.00	1	1.06	0.94;
1931	1	0.00	0.00	0.00	0.00	1	1.0530	68.0581	33.00	1	1.06	0.94;
1932	2	0.00	0.00	0.00	0.00	1	1.0459	71.8889	33.00	1	1.06	0.94;
1933	1	0.00	0.00	0.00	0.00	1	1.0418	46.7018	33.00	1	1.06	0.94;
1934	1	-3.90	0.00	0.00	0.00	1	1.0530	50.9961	33.00	1	1.06	0.94;
1935	1	-3.90	0.00	0.00	0.00	1	1.0530	50.9062	33.00	1	1.06	0.94;
1936	1	0.00	0.00	0.00	0.00	1	0.9530	41.8803	33.00	1	1.06	0.94;
1937	1	-7.50	0.00	0.00	0.00	1	1.0530	42.8115	33.00	1	1.06	0.94;
1938	1	0.00	0.00	0.00	0.00	1	1.0530	64.3843	33.00	1	1.06	0.94;
1939	2	0.00	0.00	0.00	0.00	1	1.0530	68.6093	33.00	1	1.06	0.94;
1940	1	0.00	0.00	0.00	0.00	1	1.0530	61.6130	33.00	1	1.06	0.94;
1941	2	0.00	0.00	0.00	0.00	1	1.0530	64.0388	33.00	1	1.06	0.94;
1942	1	0.00	0.00	0.00	0.00	1	1.0530	65.1651	33.00	1	1.06	0.94;
1943	1	-7.50	0.00	0.00	0.00	1	1.0530	70.1311	33.00	1	1.06	0.94;
1944	1	-7.50	0.00	0.00	0.00	1	1.0530	68.1792	33.00	1	1.06	0.94;
1945	1	0.00	0.00	0.00	0.00	1	0.9815	42.1055	132.00	1	1.06	0.94;
1946	1	0.00	0.00	0.00	0.00	1	0.9815	42.1028	132.00	1	1.06	0.94;
1947	1	0.00	0.00	0.00	0.00	1	0.9765	41.2070	132.00	1	1.06	0.94;
1948	1	0.00	0.00	0.00	0.00	1	1.0443	62.5386	132.00	1	1.06	0.94;
1949	1	0.00	0.00	0.00	0.00	1	1.0445	62.5199	132.00	1	1.06	0.94;
1950	1	0.00	0.00	0.00	0.00	1	1.0443	62.5407	132.00	1	1.06	0.94;
1951	1	0.00	0.00	0.00	0.00	1	1.0444	62.5219	132.00	1	1.06	0.94;
1952	1	26.87	5.35	0.00	0.00	1	1.0252	64.2778	33.00	1	1.06	0.94;
1953	1	0.00	0.00	0.00	0.00	1	0.9767	40.6204	132.00	1	1.06	0.94;
1954	1	0.00	0.00	0.00	0.00	1	0.9815	40.9422	132.00	1	1.06	0.94;
1955	1	0.00	0.00	0.00	0.00	1	0.9723	40.5875	132.00	1	1.06	0.94;
1956	1	0.00	0.00	0.00	0.00	1	0.9770	41.1371	132.00	1	1.06	0.94;
1957	1	0.00	0.00	0.00	0.00	1	1.0530	59.4198	275.00	1	1.06	0.94;
1958	1	0.00	0.00	0.00	0.00	1	1.0530	58.5442	275.00	1	1.06	0.94;
1959	1	0.00	0.00	0.00	0.00	1	1.0505	60.8263	275.00	1	1.06	0.94;
1960	1	0.00	0.00	0.00	0.00	1	1.0394	61.6161	132.00	1	1.06	0.94;
1961	1	0.00	0.00	0.00	0.00	1	1.0394	61.6148	132.00	1	1.06	0.94;
1962	1	0.00	0.00	0.00	0.00	1	1.0165	59.6436	132.00	1	1.06	0.94;
1963	1	0.00	0.00	0.00	0.00	1	1.0470	62.6668	132.00	1	1.06	0.94;
1964	1	0.00	0.00	0.00	0.00	1	1.0415	62.0555	132.00	1	1.06	0.94;
1965	1	0.00	0.00	0.00	0.00	1	1.0486	62.4846	132.00	1	1.06	0.94;
1966	1	0.00	0.00	0.00	0.00	1	1.0198	59.9915	132.00	1	1.06	0.94;
1967	1	0.00	0.00	0.00	0.00	1	1.0459	62.3763	132.00	1	1.06	0.94;
1968	1	0.00	0.00	0.00	0.00	1	1.0432	62.9823	132.00	1	1.06	0.94;
1969	1	0.00	0.00	0.00	0.00	1	1.0530	58.5489	275.00	1	1.06	0.94;
1970	1	0.00	0.00	0.00	0.00	1	1.0496	53.9223	275.00	1	1.06	0.94;
1971	1	0.00	0.00	0.00	0.00	1	1.0530	59.0174	275.00	1	1.06	0.94;
1972	1	30.63	-6.05	0.00	0.00	1	1.0193	60.3504	33.00	1	1.06	0.94;
1973	1	0.00	0.00	0.00	0.00	1	1.0459	51.5134	275.00	1	1.06	0.94;
1974	1	0.00	0.00	0.00	0.00	1	1.0459	51.5109	275.00	1	1.06	0.94;
1975	1	0.00	0.00	0.00	0.00	1	1.0436	48.5102	275.00	1	1.06	0.94;
1976	1	0.00	0.00	0.00	0.00	1	1.0455	51.4506	275.00	1	1.06	0.94;
1977	1	0.00	0.00	0.00	0.00	1	1.0436	48.5113	275.00	1	1.06	0.94;
1978	1	0.00	0.00	0.00	0.00	1	1.0529	51.9955	275.00	1	1.06	0.94;
1979	1	0.00	0.00	0.00	0.00	1	1.0290	60.6604	132.00	1	1.06	0.94;
1980	1	0.00	0.00	0.00	0.00	1	1.0194	59.8859	132.00	1	1.06	0.94;
1981	1	0.00	0.00	0.00	0.00	1	1.0325	62.5294	132.00	1	1.06	0.94;
1982	1	0.00	0.00	0.00	0.00	1	0.9934	40.4512	132.00	1	1.06	0.94;
1983	1	0.00	0.00	0.00	0.00	1	0.9934	40.4393	132.00	1	1.06	0.94;
1984	1	40.20	10.41	0.00	0.00	1	1.0059	43.4341	33.00	1	1.06	0.94;
1985	1	0.00	0.00	0.00	0.00	1	1.0034	40.6376	132.00	1	1.06	0.94;
1986	1	0.00	0.00	0.00	0.00	1	1.0033	40.6368	132.00	1	1.06	0.94;
1987	1	0.00	0.00	0.00	0.00	1	1.0024	40.6104	132.00	1	1.06	0.94;
1988	1	0.00	0.00	0.00	0.00	1	1.0388	40.6582	132.00	1	1.06	0.94;
1989	1	0.00	0.00	0.00	0.00	1	1.0024	40.6097	132.00	1	1.06	0.94;
1990	1	32.27	7.93	0.00	0.00	1	1.0153	39.6428	33.00	1	1.06	0.94;
1991	1	0.00	0.00	0.00	0.00	1	1.0360	60.6654	132.00	1	1.06	0.94;
1992	1	0.00	0.00	0.00	0.00	1	1.0520	62.0713	132.00	1	1.06	0.94;
1993	1	0.00	0.00	0.00	0.00	1	1.0286	60.1796	132.00	1	1.06	0.94;
1994	1	0.00	0.00	0.00	0.00	1	1.0480	62.5213	132.00	1	1.06	0.94;
1995	1	0.00	0.00	0.00	0.00	1	1.0482	62.5321	132.00	1	1.06	0.94;
1996	1	0.00	0.00	0.00	0.00	1	1.0491	62.4732	132.00	1	1.06	0.94;
1997	1	0.00	0.00	0.00	0.00	1	0.9855	42.5619	132.00	1	1.06	0.94;
1998	1	0.00	0.00	0.00	0.00	1	0.9855	42.5648	132.00	1	1.06	0.94;
1999	1	0.00	0.00	0.00	0.00	1	1.0352	51.8390	132.00	1	1.06	0.94;
2000	1	0.00	0.00	0.00	0.00	1	1.0303	49.5161	132.00	1	1.06	0.94;
2001	1	0.00	0.00	0.00	0.00	1	1.0339	51.6349	132.00	1	1.06	0.94;
2002	1	0.00	0.00	0.00	0.00	1	1.0274	49.2139	132.00	1	1.06	0.94;
2003	1	17.63	0.00	0.00	0.00	1	1.0272	55.3664	33.00	1	1.06	0.94;
2004	1	0.00	0.00	0.00	0.00	1	0.9756	41.0516	132.00	1	1.06	0.94;
2005	1	0.00	0.00	0.00	0.00	1	0.9756	41.0681	132.00	1	1.06	0.94;
2006	1	0.00	0.00	0.00	0.00	1	0.9755	41.0233	132.00	1	1.06	0.94;
2007	1	0.00	0.00	0.00	0.00	1	0.9756	41.0500	132.00	1	1.06	0.94;
2008	1	0.00	0.00	0.00	0.00	1	0.9756	41.0663	132.00	1	1.06	0.94;
2009	1	0.00	0.00	0.00	0.00	1	0.9755	41.0234	132.00	1	1.06	0.94;
2010	1	0.00	0.00	0.00	0.00	1	1.0454	54.5671	33.00	1	1.06	0.94;
2011	1	0.00	0.00	0.00	0.00	1	1.0530	63.3731	132.00	1	1.06	0.94;
2012	1	0.00	0.00	0.00	0.00	1	1.0514	63.0566	132.00	1	1.06	0.94;
2013	1	0.00	0.00	0.00	0.00	1	1.0519	62.6564	132.00	1	1.06	0.94;
2014	1	0.00	0.00	0.00	0.00	1	0.9765	41.2051	132.00	1	1.06	0.94;
2015	1	0.00	0.00	0.00	0.00	1	0.9765	41.2091	132.00	1	1.06	0.94;
2016	1	0.00	0.00	0.00	0.00	1	0.9758	41.0859	132.00	1	1.06	0.94;
2017	1	0.00	0.00	0.00	0.00	1	0.9758	41.0844	132.00	1	1.06	0.94;
2018	1	0.00	0.00	0.00	0.00	1	0.9761	41.1698	132.00	1	1.06	0.94;
2019	1	0.00	0.00	0.00	0.00	1	0.9777	41.4577	132.00	1	1.06	0.94;
2020	1	0.00	0.00	0.00	0.00	1	0.9761	41.1673	132.00	1	1.06	0.94;
2021	1	0.00	0.00	0.00	0.00	1	0.9777	41.4575	132.00	1	1.06	0.94;
2022	1	0.00	0.00	0.00	0.00	1	1.0230	48.1405	132.00	1	1.06	0.94;
2023	1	3.02	0.40	0.00	0.00	1	1.0150	46.5761	132.00	1	1.06	0.94;
2024	1	0.00	0.00	0.00	0.00	1	1.0227	47.7980	132.00	1	1.06	0.94;
2025	1	0.00	0.00	0.00	0.00	1	1.0200	47.1681	132.00	1	1.06	0.94;
2026	1	0.00	0.00	0.00	0.00	1	1.0179	59.7278	33.00	1	1.06	0.94;
2027	1	0.00	0.00	0.00	0.00	1	1.0430	50.4971	33.00	1	1.06	0.94;
2028	2	0.00	0.00	0.00	0.00	1	1.0530	60.8474	132.00	1	1.06	0.94;
2029	1	0.00	0.00	0.00	0.00	1	1.0132	43.4157	132.00	1	1.06	0.94;
2030	1	0.00	0.00	0.00	0.00	1	1.0132	43.4170	132.00	1	1.06	0.94;
2031	1	0.00	0.00	0.00	0.00	1	1.0132	43.4233	132.00	1	1.06	0.94;
2032	1	0.00	0.00	0.00	0.00	1	1.0133	43.4246	132.00	1	1.06	0.94;
2033	1	0.00	0.00	0.00	0.00	1	1.0138	43.4495	132.00	1	1.06	0.94;
2034	1	0.00	0.00	0.00	0.00	1	1.0138	43.4571	132.00	1	1.06	0.94;
2035	1	0.00	0.00	0.00	0.00	1	1.0353	47.0940	132.00	1	1.06	0.94;
2036	1	0.00	0.00	0.00	0.00	1	1.0355	47.1291	132.00	1	1.06	0.94;
2037	1	0.00	0.00	0.00	0.00	1	0.9928	43.3324	132.00	1	1.06	0.94;
2038	1	0.00	0.00	0.00	0.00	1	0.9929	43.3418	132.00	1	1.06	0.94;
2039	2	0.00	0.00	0.00	0.00	1	1.0530	51.9534	132.00	1	1.06	0.94;
2040	2	0.00	0.00	0.00	0.00	1	1.0530	51.9534	132.00	1	1.06	0.94;
2041	1	27.52	7.34	0.00	0.00	1	0.9744	45.7876	33.00	1	1.06	0.94;
2042	1	0.00	0.00	0.00	0.00	1	1.0167	43.8118	132.00	1	1.06	0.94;
2043	1	0.00	0.00	0.00	0.00	1	1.0167	43.8084	132.00	1	1.06	0.94;
2044	1	0.00	0.00	0.00	0.00	1	1.0171	44.8640	132.00	1	1.06	0.94;
2045	1	0.00	0.00	0.00	0.00	1	1.0171	43.8496	132.00	1	1.06	0.94;
2046	1	0.00	0.00	0.00	0.00	1	1.0171	43.8497	132.00	1	1.06	0.94;
2047	1	0.00	0.00	0.00	0.00	1	1.0165	43.9890	132.00	1	1.06	0.94;
2048	1	0.00	0.00	0.00	0.00	1	1.0190	43.3681	132.00	1	1.06	0.94;
2049	1	0.00	0.00	0.00	0.00	1	1.0494	61.9149	132.00	1	1.06	0.94;
2050	1	0.00	0.00	0.00	0.00	1	1.0488	62.1779	132.00	1	1.06	0.94;
2051	1	0.00	0.00	0.00	0.00	1	1.0486	62.1596	132.00	1	1.06	0.94;
2052	1	0.00	0.00	0.00	0.00	1	1.0489	61.1051	275.00	1	1.06	0.94;
2053	1	0.00	0.00	0.00	0.00	1	1.0505	60.8734	275.00	1	1.06	0.94;
2054	1	0.00	0.00	0.00	0.00	1	1.0499	62.5580	132.00	1	1.06	0.94;
2055	1	13.76	0.00	0.00	0.00	1	1.0489	61.6253	33.00	1	1.06	0.94;
2056	1	0.00	0.00	0.00	0.00	1	0.9931	43.9277	132.00	1	1.06	0.94;
2057	1	0.00	0.00	0.00	0.00	1	0.9931	43.9239	132.00	1	1.06	0.94;
2058	1	25.00	-3.57	0.00	0.00	1	1.0285	44.7481	33.00	1	1.06	0.94;
2059	1	0.00	0.00	0.00	0.00	1	1.0453	51.8311	33.00	1	1.06	0.94;
2060	1	0.00	0.00	0.00	0.00	1	1.0144	44.7035	132.00	1	1.06	0.94;
2061	1	0.00	0.00	0.00	0.00	1	1.0144	44.7037	132.00	1	1.06	0.94;
2062	1	43.44	10.61	0.00	0.00	1	1.0478	42.9949	33.00	1	1.06	0.94;
2063	1	0.00	0.00	0.00	0.00	1	0.9814	54.9847	132.00	1	1.06	0.94;
2064	1	0.00	0.00	0.00	0.00	1	0.9829	54.0768	132.00	1	1.06	0.94;
2065	1	0.00	0.00	0.00	0.00	1	0.9970	57.3080	132.00	1	1.06	0.94;
2066	1	0.00	0.00	0.00	0.00	1	0.9818	55.0648	132.00	1	1.06	0.94;
2067	1	0.00	0.00	0.00	0.00	1	0.9983	57.5205	132.00	1	1.06	0.94;
2068	1	0.00	0.00	0.00	0.00	1	1.0454	48.9807	132.00	1	1.06	0.94;
2069	1	0.00	0.00	0.00	0.00	1	1.0484	47.8590	132.00	1	1.06	0.94;
2070	1	0.00	0.00	0.00	0.00	1	1.0484	47.8571	132.00	1	1.06	0.94;
2071	1	0.00	0.00	0.00	0.00	1	1.0482	48.8246	132.00	1	1.06	0.94;
2072	1	0.00	0.00	0.00	0.00	1	1.0506	61.8872	132.00	1	1.06	0.94;
2073	1	0.00	0.00	0.00	0.00	1	1.0483	48.8230	132.00	1	1.06	0.94;
2074	2	0.00	0.00	0.00	0.00	1	1.0530	58.4531	132.00	1	1.06	0.94;
2075	1	0.00	0.00	0.00	0.00	1	1.0506	61.8885	132.00	1	1.06	0.94;
2076	1	0.00	0.00	0.00	0.00	1	1.0507	62.0994	132.00	1	1.06	0.94;
2077	1	0.00	0.00	0.00	0.00	1	1.0504	61.8664	132.00	1	1.06	0.94;
2078	1	0.00	0.00	0.00	0.00	1	1.0516	62.3242	132.00	1	1.06	0.94;
2079	1	0.00	0.00	0.00	0.00	1	1.0362	41.0591	132.00	1	1.06	0.94;
2080	1	0.00	0.00	0.00	0.00	1	1.0363	41.0574	132.00	1	1.06	0.94;
2081	1	72.48	20.52	0.00	0.00	1	0.9983	56.6869	33.00	1	1.06	0.94;
2082	1	0.00	0.00	0.00	0.00	1	1.0457	50.0313	132.00	1	1.06	0.94;
2083	1	0.00	0.00	0.00	0.00	1	1.0475	50.1536	132.00	1	1.06	0.94;
2084	1	0.00	0.00	0.00	0.00	1	1.0457	50.0317	132.00	1	1.06	0.94;
2085	1	0.00	0.00	0.00	0.00	1	1.0475	50.1541	132.00	1	1.06	0.94;
2086	1	0.00	0.00	0.00	0.00	1	1.0457	61.4433	132.00	1	1.06	0.94;
2087	1	0.00	0.00	0.00	0.00	1	1.0496	63.2736	132.00	1	1.06	0.94;
2088	1	0.00	0.00	0.00	0.00	1	1.0530	64.4203	132.00	1	1.06	0.94;
2089	1	0.22	0.20	0.00	0.00	1	1.0431	62.1047	33.00	1	1.06	0.94;
2090	2	0.00	0.00	0.00	0.00	1	1.0443	71.5794	132.00	1	1.06	0.94;
2091	1	0.00	0.00	0.00	0.00	1	1.0530	63.3905	132.00	1	1.06	0.94;
2092	1	0.00	0.00	0.00	0.00	1	1.0526	63.3448	132.00	1	1.06	0.94;
2093	1	0.00	0.00	0.00	0.00	1	1.0525	63.0833	132.00	1	1.06	0.94;
2094	1	0.00	0.00	0.00	0.00	1	1.0165	59.6431	132.00	1	1.06	0.94;
2095	1	0.00	0.00	0.00	0.00	1	1.0506	50.4027	132.00	1	1.06	0.94;
2096	1	0.00	0.00	0.00	0.00	1	1.0530	50.6064	132.00	1	1.06	0.94;
2097	1	0.00	0.00	0.00	0.00	1	1.0503	50.3819	132.00	1	1.06	0.94;
2098	1	0.00	0.00	0.00	0.00	1	1.0494	50.2909	132.00	1	1.06	0.94;
2099	1	0.00	0.00	0.00	0.00	1	1.0506	50.4027	132.00	1	1.06	0.94;
2100	1	0.00	0.00	0.00	0.00	1	1.0503	50.3818	132.00	1	1.06	0.94;
2101	1	0.00	0.00	0.00	0.00	1	1.0494	50.2913	132.00	1	1.06	0.94;
2102	1	0.00	0.00	0.00	0.00	1	1.0271	48.6487	132.00	1	1.06	0.94;
2103	1	0.00	0.00	0.00	0.00	1	1.0150	46.5764	132.00	1	1.06	0.94;
2104	1	0.00	0.00	0.00	0.00	1	1.0225	48.3377	132.00	1	1.06	0.94;
2105	1	0.00	0.00	0.00	0.00	1	1.0293	48.8603	132.00	1	1.06	0.94;
2106	1	0.00	0.00	0.00	0.00	1	0.9875	53.6018	132.00	1	1.06	0.94;
2107	1	0.00	0.00	0.00	0.00	1	1.0455	51.4416	275.00	1	1.06	0.94;
2108	1	56.32	22.01	0.00	0.00	1	0.9825	52.0870	33.00	1	1.06	0.94;
2109	1	0.00	0.00	0.00	0.00	1	1.0258	55.1169	33.00	1	1.06	0.94;
2110	1	20.59	-5.95	0.00	0.09	1	0.9989	52.6176	33.00	1	1.06	0.94;
2111	1	0.00	0.00	0.00	0.00	1	1.0273	51.3655	33.00	1	1.06	0.94;
2112	1	0.00	0.00	0.00	0.00	1	1.0293	51.8009	33.00	1	1.06	0.94;
2113	1	0.00	0.00	0.00	0.00	1	1.0265	48.6968	132.00	1	1.06	0.94;
2114	1	0.00	0.00	0.00	0.00	1	1.0436	48.4979	275.00	1	1.06	0.94;
2115	1	0.00	0.00	0.00	0.00	1	1.0437	48.5005	275.00	1	1.06	0.94;
2116	1	0.00	0.00	0.00	0.00	1	1.0437	48.9097	275.00	1	1.06	0.94;
2117	1	0.00	0.00	0.00	0.00	1	1.0437	48.4829	275.00	1	1.06	0.94;
2118	1	0.00	0.00	0.00	0.00	1	1.0431	41.2622	275.00	1	1.06	0.94;
2119	1	0.00	0.00	0.00	0.00	1	1.0432	41.2494	275.00	1	1.06	0.94;
2120	1	0.00	0.00	0.00	0.00	1	1.0529	51.8091	275.00	1	1.06	0.94;
2121	1	0.00	0.00	0.00	0.00	1	1.0528	51.8078	275.00	1	1.06	0.94;
2122	1	0.00	0.00	0.00	0.00	1	1.0431	41.2753	275.00	1	1.06	0.94;
2123	1	62.78	16.75	0.00	0.00	1	0.9472	41.4284	33.00	1	1.06	0.94;
2124	1	17.11	-3.47	0.00	0.00	1	1.0435	48.4707	33.00	1	1.06	0.94;
2125	1	0.00	0.00	0.00	0.00	1	1.0494	50.2908	132.00	1	1.06	0.94;
2126	1	0.00	0.00	0.00	0.00	1	1.0466	50.0763	132.00	1	1.06	0.94;
2127	1	0.00	0.00	0.00	0.00	1	1.0494	50.2913	132.00	1	1.06	0.94;
2128	1	0.00	0.00	0.00	0.00	1	1.0466	50.0768	132.00	1	1.06	0.94;
2129	1	0.00	0.00	0.00	0.00	1	0.9737	40.7466	132.00	1	1.06	0.94;
2130	1	0.00	0.00	0.00	0.00	1	0.9737	40.7466	132.00	1	1.06	0.94;
2131	1	0.00	0.00	0.00	0.00	1	1.0530	62.8917	132.00	1	1.06	0.94;
2132	1	0.00	0.00	0.00	0.00	1	1.0525	63.0841	132.00	1	1.06	0.94;
2133	1	0.00	0.00	0.00	0.00	1	1.0502	62.5655	132.00	1	1.06	0.94;
2134	1	14.15	1.98	0.00	0.00	1	1.0530	64.4680	33.00	1	1.06	0.94;
2135	1	0.00	0.00	0.00	0.00	1	1.0459	62.3763	132.00	1	1.06	0.94;
2136	1	0.00	0.00	0.00	0.00	1	1.0530	50.6060	132.00	1	1.06	0.94;
2137	1	0.00	0.00	0.00	0.00	1	1.0530	50.6061	132.00	1	1.06	0.94;
2138	1	0.00	0.00	0.00	0.00	1	1.0530	50.6064	132.00	1	1.06	0.94;
2139	1	0.00	0.00	0.00	0.00	1	1.0530	50.6064	132.00	1	1.06	0.94;
2140	1	0.00	0.00	0.00	0.00	1	1.0529	51.8211	275.00	1	1.06	0.94;
2141	1	0.00	0.00	0.00	0.00	1	1.0529	51.8379	275.00	1	1.06	0.94;
2142	1	0.00	0.00	0.00	0.00	1	1.0437	48.9184	275.00	1	1.06	0.94;
2143	1	0.00	0.00	0.00	0.00	1	1.0529	51.8242	275.00	1	1.06	0.94;
2144	1	0.00	0.00	0.00	0.00	1	1.0529	51.9967	275.00	1	1.06	0.94;
2145	1	0.00	0.00	0.00	0.00	1	1.0529	51.9596	275.00	1	1.06	0.94;
2146	1	0.00	0.00	0.00	0.00	1	1.0529	51.9609	275.00	1	1.06	0.94;
2147	1	0.00	0.00	0.00	0.00	1	1.0529	51.8846	275.00	1	1.06	0.94;
2148	1	0.00	0.00	0.00	0.00	1	1.0529	51.8406	275.00	1	1.06	0.94;
2149	1	0.00	0.00	0.00	0.00	1	1.0529	51.9907	275.00	1	1.06	0.94;
2150	1	0.00	0.00	0.00	0.00	1	1.0186	44.0232	132.00	1	1.06	0.94;
2151	1	0.00	0.00	0.00	0.00	1	1.0186	44.0233	132.00	1	1.06	0.94;
2152	1	0.00	0.00	0.00	0.00	1	1.0176	43.9348	132.00	1	1.06	0.94;
2153	1	0.00	0.00	0.00	0.00	1	1.0176	43.9348	132.00	1	1.06	0.94;
2154	1	0.00	0.00	0.00	0.00	1	1.0530	48.9834	132.00	1	1.06	0.94;
2155	1	0.00	0.00	0.00	0.00	1	1.0530	48.9850	132.00	1	1.06	0.94;
2156	1	0.00	0.00	0.00	0.00	1	1.0493	50.2794	132.00	1	1.06	0.94;
2157	1	0.00	0.00	0.00	0.00	1	1.0493	50.2794	132.00	1	1.06	0.94;
2158	1	0.00	0.00	0.00	0.00	1	1.0493	50.2796	132.00	1	1.06	0.94;
2159	1	0.00	0.00	0.00	0.00	1	1.0493	50.2796	132.00	1	1.06	0.94;
2160	1	0.00	0.00	0.00	0.00	1	1.0495	50.2889	132.00	1	1.06	0.94;
2161	1	0.00	0.00	0.00	0.00	1	1.0495	50.2893	132.00	1	1.06	0.94;
2162	1	27.41	5.45	0.00	0.00	1	1.0481	49.0377	33.00	1	1.06	0.94;
2163	1	0.00	0.00	0.00	0.00	1	1.0517	49.5501	33.00	1	1.06	0.94;
2164	1	0.00	0.00	0.00	0.00	1	1.0432	41.2375	275.00	1	1.06	0.94;
2165	1	0.00	0.00	0.00	0.00	1	1.0431	41.2480	275.00	1	1.06	0.94;
2166	1	38.14	0.00	0.00	0.08	1	1.0513	61.1662	33.00	1	1.06	0.94;
2167	1	0.00	0.00	0.00	0.00	1	1.0513	61.1662	33.00	1	1.06	0.94;
2168	1	0.00	0.00	0.00	0.00	1	1.0182	59.4005	132.00	1	1.06	0.94;
2169	1	0.00	0.00	0.00	0.00	1	1.0268	60.0911	132.00	1	1.06	0.94;
2170	1	6.13	1.49	0.00	0.00	1	1.0282	63.9629	33.00	1	1.06	0.94;
2171	1	0.00	0.00	0.00	0.00	1	1.0145	43.5115	132.00	1	1.06	0.94;
2172	1	0.00	0.00	0.00	0.00	1	1.0140	43.0283	132.00	1	1.06	0.94;
2173	1	18.98	2.68	0.00	0.00	1	1.0530	41.3395	33.00	1	1.06	0.94;
2174	1	0.00	0.00	0.00	0.00	1	1.0530	41.3384	33.00	1	1.06	0.94;
2175	1	2.59	7.63	0.00	0.00	1	1.0481	70.4611	33.00	1	1.06	0.94;
2176	1	0.00	0.00	0.00	0.00	1	1.0351	71.0287	33.00	1	1.06	0.94;
2177	1	0.00	0.00	0.00	0.00	1	1.0498	59.6161	33.00	1	1.06	0.94;
2178	1	0.00	0.00	0.00	0.00	1	1.0198	57.0991	33.00	1	1.06	0.94;
2179	1	41.76	10.31	0.00	0.00	1	1.0530	39.1330	33.00	1	1.06	0.94;
2180	1	36.62	7.34	0.00	0.00	1	1.0530	37.9703	33.00	1	1.06	0.94;
2181	1	22.19	4.46	0.00	0.00	1	1.0530	59.4517	33.00	1	1.06	0.94;
2182	1	7.94	1.09	0.00	0.00	1	1.0530	59.0798	33.00	1	1.06	0.94;
2183	1	8.56	1.69	0.00	0.00	1	1.0530	59.6044	33.00	1	1.06	0.94;
2184	1	50.34	10.11	0.00	0.00	1	1.0530	39.4478	33.00	1	1.06	0.94;
2185	1	4.71	0.69	0.00	0.00	1	0.9934	62.1167	33.00	1	1.06	0.94;
2186	1	30.49	6.15	0.00	0.00	1	1.0530	39.0467	33.00	1	1.06	0.94;
2187	1	46.60	14.87	0.00	0.00	1	1.0530	40.5091	33.00	1	1.06	0.94;
2188	1	32.12	4.56	0.00	0.00	1	1.0530	41.3573	33.00	1	1.06	0.94;
2189	1	6.47	1.29	0.00	0.00	1	1.0530	61.0511	11.00	1	1.06	0.94;
2190	1	36.31	10.61	0.00	0.00	1	1.0530	38.8279	33.00	1	1.06	0.94;
2191	1	56.24	13.98	0.00	0.00	1	1.0530	51.0786	33.00	1	1.06	0.94;
2192	1	-0.18	-0.20	0.00	0.00	1	1.0046	71.8257	33.00	1	1.06	0.94;
2193	1	0.54	0.20	0.00	0.00	1	1.0530	61.7115	33.00	1	1.06	0.94;
2194	1	23.37	4.76	0.00	0.00	1	1.0530	38.9518	33.00	1	1.06	0.94;
2195	1	22.90	7.44	0.00	0.00	1	1.0530	48.4122	33.00	1	1.06	0.94;
2196	1	34.06	4.86	0.00	0.00	1	1.0530	59.9649	33.00	1	1.06	0.94;
2197	1	11.87	3.77	0.00	0.00	1	1.0530	39.9250	33.00	1	1.06	0.94;
2198	1	11.87	3.77	0.00	0.00	1	1.0530	39.9072	33.00	1	1.06	0.94;
2199	1	3.78	1.09	0.00	0.00	1	1.0195	66.0750	33.00	1	1.06	0.94;
2200	1	-0.61	-0.59	0.00	0.00	1	1.0530	63.2055	33.00	1	1.06	0.94;
2201	1	34.95	8.82	0.00	0.00	1	1.0530	38.8846	33.00	1	1.06	0.94;
2202	1	30.88	6.15	0.00	0.00	1	1.0530	39.2411	33.00	1	1.06	0.94;
2203	1	31.72	8.13	0.00	0.00	1	1.0530	55.1214	33.00	1	1.06	0.94;
2204	1	0.00	0.00	0.00	0.00	1	1.0033	48.7700	33.00	1	1.06	0.94;
2205	1	0.00	0.00	0.00	0.00	1	1.0245	50.6064	132.00	1	1.06	0.94;
2206	1	0.00	0.00	0.00	0.00	1	1.0245	50.6064	132.00	1	1.06	0.94;
2207	1	6.99	0.99	0.00	0.00	1	1.0530	49.0992	11.00	1	1.06	0.94;
2208	1	0.00	0.00	0.00	0.00	1	1.0153	50.6060	11.00	1	1.06	0.94;
2209	1	0.00	0.00	0.00	0.00	1	1.0153	50.6061	11.00	1	1.06	0.94;
2210	1	22.21	5.55	0.00	0.00	1	1.0530	48.7771	33.00	1	1.06	0.94;
2211	1	53.07	10.71	0.00	0.00	1	1.0530	41.4372	33.00	1	1.06	0.94;
2212	2	0.00	0.00	0.00	0.00	1	1.0530	59.5977	132.00	1	1.06	0.94;
2213	1	40.49	11.50	0.00	0.00	1	1.0530	40.6594	33.00	1	1.06	0.94;
2214	1	-2.84	-0.89	0.00	0.00	1	1.0064	56.5080	33.00	1	1.06	0.94;
2215	1	17.39	3.47	0.00	0.00	1	1.0530	48.8465	33.00	1	1.06	0.94;
2216	1	-34.00	0.00	0.00	0.00	1	1.0530	52.5834	132.00	1	1.06	0.94;
2217	1	10.08	3.07	0.00	0.00	1	1.0071	49.9381	33.00	1	1.06	0.94;
2218	1	47.23	9.52	0.00	0.00	1	1.0530	41.0057	33.00	1	1.06	0.94;
2219	1	44.34	11.00	0.00	0.00	1	1.0530	40.7906	33.00	1	1.06	0.94;
2220	1	33.13	0.00	0.00	0.08	1	1.0530	54.8933	33.00	1	1.06	0.94;
2221	1	0.00	0.00	0.00	0.00	1	1.0145	50.2889	11.00	1	1.06	0.94;
2222	1	0.00	0.00	0.00	0.00	1	1.0145	50.2893	11.00	1	1.06	0.94;
2223	1	9.77	1.98	0.00	0.00	1	1.0530	47.9582	11.00	1	1.06	0.94;
2224	1	0.00	0.00	0.00	0.00	1	1.0530	41.3384	33.00	1	1.06	0.94;
];
%% Generator Data
mpc.gen = [
2	303.7966	11.6864	298.00	-81.00	1.05	100	1	820.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
3	304.3822	18.8436	298.00	-81.00	1.05	100	1	820.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
4	303.9515	12.9930	298.00	-81.00	1.05	100	1	820.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
6	191.2500	39.0691	 78.00	-45.00	1.05	100	1	191.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
7	191.2500	39.0639	 78.00	-45.00	1.05	100	1	191.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
9	191.2500	32.7382	 81.00	-46.00	1.05	100	1	191.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
10	191.2500	33.7448	 78.00	-45.00	1.05	100	1	191.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
11	191.2500	33.7382	 78.00	-45.00	1.05	100	1	191.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
12	209.2500	42.7363	 78.00	-46.00	1.05	100	1	209.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
13	302.3886	67.1289	125.00	-70.00	1.05	100	1	334.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
15	290.4628	115.3728	263.00	-120.00	1.05	100	1	742.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
16	290.1800	73.7579	243.00	-115.00	1.05	100	1	757.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
17	290.4318	108.6465	243.00	-120.00	1.05	100	1	757.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
18	290.3847	99.8157	263.00	-120.00	1.05	100	1	742.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
20	290.1997	82.3995	107.40	-56.80	1.05	100	1	300.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
21	290.1997	82.3995	107.40	-56.80	1.05	100	1	300.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
22	144.0000	82.3995	116.20	-59.00	1.05	100	1	144.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
24	305.1217	128.7354	282.71	-180.97	1.05	100	1	790.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
25	305.0020	117.5675	302.66	-174.40	1.05	100	1	790.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
27	304.5867	94.3011	282.71	-180.97	1.05	100	1	790.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
28	304.6193	96.7860	282.71	-180.97	1.05	100	1	790.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
30	286.8438	-27.7783	115.00	-115.00	1.05	100	1	300.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
31	286.8438	-27.7783	115.00	-115.00	1.05	100	1	300.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
32	286.8438	-27.7783	115.00	-115.00	1.05	100	1	300.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
33	286.8438	-27.7783	115.00	-115.00	1.05	100	1	300.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
34	286.8438	-27.7783	115.00	-115.00	1.05	100	1	300.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
35	0.0000	0.0000	  0.00	  0.00	1.01	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
37	288.1762	91.9124	380.00	-198.00	1.05	100	1	973.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
38	288.1763	91.9276	380.00	-198.00	1.05	100	1	973.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
39	288.1758	91.8621	380.00	-198.00	1.05	100	1	973.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
41	288.5539	122.3476	380.00	-184.00	1.05	100	1	973.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
42	288.5536	122.3044	380.00	-184.00	1.05	100	1	973.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
43	288.5850	127.7988	380.00	-184.00	1.05	100	1	973.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
45	314.7812	185.6172	409.00	-217.00	1.05	100	1	811.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
46	314.7630	177.2822	402.00	-227.00	1.05	100	1	811.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
48	289.2201	138.6899	289.00	-84.00	1.05	100	1	724.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
49	288.6363	93.6437	308.00	-84.00	1.05	100	1	724.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
51	288.1725	93.1616	241.00	-81.00	1.05	100	1	732.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
52	288.4486	114.6091	268.00	-82.00	1.05	100	1	732.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
54	0.0000	0.0000	  0.00	  0.00	1.01	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
55	0.0000	0.0000	  0.00	  0.00	1.01	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
57	289.9488	193.7612	286.00	-86.00	1.05	100	1	735.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
59	290.7522	286.0000	286.00	-86.00	1.05	100	1	735.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
61	291.1783	286.0000	286.00	-86.00	1.05	100	1	735.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
62	289.9952	202.9429	287.00	-81.00	1.05	100	1	735.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
64	270.0000	27.2528	 60.00	-60.00	1.05	100	1	270.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
65	135.0000	-10.4599	 30.00	-30.00	1.04	100	1	135.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
67	292.3875	110.3622	308.00	-95.00	1.05	100	1	727.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
69	292.3719	112.5053	311.00	-95.00	1.05	100	1	727.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
71	292.7575	144.0456	329.00	-101.00	1.05	100	1	727.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
73	292.7764	142.4962	203.00	-91.00	1.05	100	1	759.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
75	0.0000	0.0000	  0.00	  0.00	1.00	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
76	0.0000	0.0000	  0.00	  0.00	1.00	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
77	0.0000	0.0000	  0.00	  0.00	1.00	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
78	0.0000	0.0000	  0.00	  0.00	1.00	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
80	287.2248	218.7852	367.00	-210.00	1.05	100	1	906.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
81	287.2549	230.1573	351.00	-208.00	1.05	100	1	906.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
83	300.4165	121.9362	392.00	-206.00	1.05	100	1	910.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
84	300.3998	117.0011	398.00	-207.00	1.05	100	1	894.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
85	300.4498	133.1419	367.00	-188.00	1.05	100	1	900.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
86	300.4500	133.2219	362.00	-187.00	1.05	100	1	903.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
88	320.3082	60.8053	312.00	-155.00	1.05	100	1	966.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
89	320.2899	58.2679	289.00	-204.00	1.05	100	1	925.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
91	298.5716	296.0000	296.00	-99.00	1.05	100	1	723.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
92	298.5988	296.0000	296.00	-92.00	1.05	100	1	723.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
94	285.4042	138.0000	138.00	-75.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
96	285.8162	38.4515	155.00	-72.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
97	285.8163	38.4523	145.90	-79.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
99	216.0000	24.3046	 87.20	-52.80	1.05	100	1	216.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
100	216.0000	36.4629	 87.20	-52.80	1.05	100	1	216.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
101	216.0000	24.3106	 87.20	-52.80	1.05	100	1	216.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
102	216.0000	24.3106	 87.20	-52.80	1.05	100	1	216.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
103	243.0000	31.7963	103.00	-55.00	1.05	100	1	243.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
104	243.0000	31.7963	103.00	-55.00	1.05	100	1	243.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
105	216.9000	24.7567	 75.92	-52.46	1.05	100	1	216.90	0.00	0	0	0	0	0	0	0	0	0	0	0;
106	216.9000	24.7567	 75.92	-52.46	1.05	100	1	216.90	0.00	0	0	0	0	0	0	0	0	0	0	0;
107	216.9000	24.7567	 75.92	-52.46	1.05	100	1	216.90	0.00	0	0	0	0	0	0	0	0	0	0	0;
108	281.6044	34.4504	139.82	-78.06	1.05	100	1	346.80	0.00	0	0	0	0	0	0	0	0	0	0	0;
110	303.2960	80.9664	286.00	-64.00	1.05	100	1	727.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
111	303.3132	82.8649	286.00	-64.00	1.05	100	1	727.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
113	302.5446	80.3976	286.00	-64.00	1.05	100	1	727.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
114	302.5428	80.1999	286.00	-64.00	1.05	100	1	727.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
116	297.3915	128.0000	128.00	-78.00	1.05	100	1	315.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
117	297.4102	128.0000	128.00	-78.00	1.05	100	1	315.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
118	297.6882	158.0000	158.00	-84.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
120	306.8929	63.1703	335.00	-204.00	1.05	100	1	750.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
121	306.8755	61.4142	335.00	-204.00	1.05	100	1	750.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
122	0.0000	0.0000	  0.00	  0.00	1.00	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
124	291.7829	6.5327	149.00	-88.00	1.05	100	1	340.05	0.00	0	0	0	0	0	0	0	0	0	0	0;
125	291.7673	6.5241	151.00	-87.00	1.05	100	1	340.05	0.00	0	0	0	0	0	0	0	0	0	0	0;
126	291.7032	6.4893	164.00	-81.00	1.05	100	1	340.05	0.00	0	0	0	0	0	0	0	0	0	0	0;
128	299.9062	255.0000	255.00	-79.00	1.05	100	1	750.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
129	300.3579	255.0000	255.00	-79.00	1.05	100	1	750.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
131	300.8971	255.0000	255.00	-79.00	1.05	100	1	750.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
132	300.2242	255.0000	255.00	-18.00	1.05	100	1	750.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
134	299.9039	201.1937	270.00	-86.00	1.05	100	1	747.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
135	299.9061	201.4642	270.00	-86.00	1.05	100	1	747.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
137	228.0000	69.4404	 88.00	-50.00	1.05	100	1	228.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
138	228.0000	88.0000	 88.00	-50.00	1.05	100	1	228.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
139	228.0000	69.4065	 88.00	-50.00	1.05	100	1	228.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
140	300.6296	114.0000	114.00	-88.00	1.05	100	1	388.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
142	308.8195	254.4729	386.00	-211.00	1.05	100	1	892.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
143	308.8194	254.4145	385.00	-204.00	1.05	100	1	892.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
145	230.2500	41.3919	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
146	230.2500	44.9264	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
147	230.2500	44.9264	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
148	230.2500	43.0574	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
150	230.2500	43.4075	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
151	230.2500	41.3691	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
152	230.2500	43.4075	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
153	230.2500	43.3885	 72.00	-48.00	1.05	100	1	230.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
154	279.9960	93.7154	192.00	-114.00	1.05	100	1	485.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
155	280.0471	96.5447	192.00	-114.00	1.05	100	1	485.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
156	0.0000	0.0000	  0.00	  0.00	1.01	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
158	0.0000	0.0000	  0.00	  0.00	0.99	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
159	299.7712	48.1379	175.00	-60.00	1.05	100	1	525.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
161	301.6298	110.4841	175.00	-60.00	1.05	100	1	525.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
162	299.2064	29.9328	190.00	-56.40	1.05	100	1	525.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
164	289.3071	158.3805	287.00	-110.00	1.05	100	1	724.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
165	289.2751	154.3879	252.00	-107.00	1.05	100	1	754.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
166	289.3216	160.2605	252.00	-107.00	1.05	100	1	754.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
167	289.3064	158.2901	287.00	-110.00	1.05	100	1	724.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
169	293.3221	15.1970	182.00	-85.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
170	293.3060	15.0375	179.00	-83.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
171	293.3849	15.8506	176.00	-83.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
172	293.9031	24.5442	178.00	-80.00	1.05	100	1	367.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
174	291.4693	143.7738	220.00	-124.00	1.05	100	1	517.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
175	291.4692	143.7552	220.00	-124.00	1.05	100	1	517.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
176	291.4688	143.6918	220.00	-124.00	1.05	100	1	517.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
177	291.4690	143.7179	221.00	-124.00	1.05	100	1	517.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
178	304.2646	75.1717	 91.00	-62.00	1.05	100	1	349.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
179	304.2646	75.1717	 91.00	-62.00	1.05	100	1	349.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
180	304.4259	83.6778	119.00	-73.00	1.05	100	1	426.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
182	0.0000	0.0000	  0.00	  0.00	1.01	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
184	253.5000	36.5084	103.00	-55.00	1.05	100	1	253.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
185	253.5000	36.5034	 96.00	-59.00	1.05	100	1	253.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
186	253.5000	38.7953	 94.00	-60.00	1.05	100	1	253.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
187	281.8467	71.7604	164.00	-91.00	1.05	100	1	393.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
188	304.7504	94.0000	 94.00	-61.00	1.05	100	1	345.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
189	304.7504	99.4157	103.00	-57.00	1.05	100	1	345.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
190	304.9144	110.5462	154.00	-81.00	1.05	100	1	435.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
191	261.0000	35.9866	 94.00	-57.00	1.05	100	1	261.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
192	261.0000	35.9817	 94.00	-57.00	1.05	100	1	261.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
193	252.0000	36.7860	107.00	-57.00	1.05	100	1	252.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
195	290.9585	98.3396	225.60	-123.00	1.05	100	1	373.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
196	290.9585	98.3396	225.60	-123.00	1.05	100	1	373.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
197	290.9585	98.3396	229.40	-117.60	1.05	100	1	375.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
199	294.2835	134.2900	134.29	-95.64	1.05	100	1	400.05	0.00	0	0	0	0	0	0	0	0	0	0	0;
200	294.2835	134.2900	134.29	-95.64	1.05	100	1	400.05	0.00	0	0	0	0	0	0	0	0	0	0	0;
201	294.2835	144.5202	162.75	-87.76	1.05	100	1	399.90	0.00	0	0	0	0	0	0	0	0	0	0	0;
203	306.6734	113.6624	138.00	-93.00	1.05	100	1	406.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
204	306.6734	113.6624	138.00	-93.00	1.05	100	1	406.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
205	306.6734	113.6624	155.00	-85.00	1.05	100	1	406.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
206	305.9258	17.3902	209.00	-145.20	1.05	100	1	633.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
208	306.7893	144.3306	298.72	-188.66	1.05	100	1	780.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
209	48.4500	0.7791	 16.90	 -9.80	1.05	100	1	48.45	0.00	0	0	0	0	0	0	0	0	0	0	0;
211	291.9105	35.7986	189.90	-145.10	1.05	100	1	385.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
212	291.9105	35.7986	196.20	-143.80	1.05	100	1	385.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
213	292.0336	39.0941	313.00	-183.50	1.05	100	1	549.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
215	302.0171	47.3157	166.00	-93.00	1.05	100	1	409.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
216	302.0171	47.3157	155.00	-94.00	1.05	100	1	409.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
217	302.0171	47.3157	159.00	-89.00	1.05	100	1	388.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
219	301.3644	93.8676	167.00	-106.00	1.05	100	1	371.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
220	301.3644	93.8676	167.00	-106.00	1.05	100	1	371.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
221	301.3644	93.8676	196.00	-94.00	1.05	100	1	371.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
222	290.4957	123.4471	220.00	-136.73	1.05	100	1	592.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
224	284.2307	38.6543	248.68	-139.23	1.05	100	1	550.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
225	284.2307	38.6543	248.68	-139.23	1.05	100	1	550.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
226	284.2307	38.6543	248.68	-139.23	1.05	100	1	550.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
228	316.6388	43.1765	250.00	-138.00	1.02	100	1	637.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
229	316.6388	43.1723	250.00	-138.00	1.02	100	1	637.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
231	304.9596	-26.5535	250.00	-140.00	1.05	100	1	600.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
232	304.9596	-26.5535	250.00	-140.00	1.05	100	1	600.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
234	66.0000	5.6624	 25.00	-14.00	1.05	100	1	66.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
235	66.0000	5.6624	 25.00	-14.00	1.05	100	1	66.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
236	67.5000	5.6624	 25.00	-14.00	1.05	100	1	67.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
237	67.5000	5.6624	 25.00	-14.00	1.05	100	1	67.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
238	67.5000	5.6624	 25.00	-14.00	1.05	100	1	67.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
239	67.5000	5.6624	 25.00	-14.00	1.05	100	1	67.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
241	282.6396	57.3225	158.63	-90.39	1.05	100	1	363.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
242	282.6396	57.3225	158.63	-90.39	1.05	100	1	363.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
243	175.5000	23.3416	 74.57	-37.80	1.05	100	1	175.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
244	175.5000	23.3416	 74.57	-37.80	1.05	100	1	175.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
249	310.0921	50.1858	194.00	-91.00	1.05	100	1	342.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
251	310.2737	31.6413	180.00	-86.00	1.05	100	1	363.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
253	90.0000	24.2725	 41.00	-21.00	1.05	100	1	90.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
254	253.5000	51.6601	100.00	-57.00	1.05	100	1	253.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
256	55.5000	3.1319	 28.00	-15.00	1.05	100	1	55.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
257	55.5000	3.0633	 24.00	-16.00	1.05	100	1	55.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
258	55.5000	3.1319	 24.00	-16.00	1.05	100	1	55.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
259	66.0000	4.1681	 34.00	-17.00	1.05	100	1	66.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
261	307.3149	105.4850	331.50	-147.70	1.05	100	1	630.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
263	105.0000	34.8232	 44.40	-27.90	1.05	100	1	105.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
264	105.0000	34.0152	 44.40	-27.90	1.05	100	1	105.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
265	105.0000	33.9943	 49.00	-23.50	1.05	100	1	105.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
270	304.2017	137.6650	273.40	-140.70	1.05	100	1	585.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
272	255.0000	19.7512	 70.00	-51.00	1.05	100	1	255.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
273	112.5000	10.4133	 33.00	-23.00	1.05	100	1	112.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
275	181.5000	28.7100	 39.80	-39.80	1.05	100	1	181.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
276	181.5000	28.7100	 39.80	-39.80	1.05	100	1	181.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
277	181.5000	28.7100	 39.80	-39.80	1.05	100	1	181.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
352	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
353	0.0000	150.0000	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
408	313.8041	69.5779	250.00	-50.00	1.05	100	1	2817.00	1800.00	0	0	0	0	0	0	0	0	0	0	0;
425	0.0000	72.6034	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
431	305.9952	250.0000	250.00	-250.00	1.05	100	1	1500.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
572	0.0000	59.8381	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
574	0.0000	70.5590	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
585	0.0000	87.7914	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
855	0.0000	29.3301	158.68	-67.81	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
882	0.0000	-41.6142	158.68	-88.88	1.02	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
883	0.0000	-41.6142	158.68	-88.88	1.02	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
884	0.0000	37.9771	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
885	0.0000	43.9284	161.99	-125.92	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
886	0.0000	-0.0009	151.66	-134.71	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
887	0.0000	-0.0009	151.66	-134.71	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
888	0.0000	3.0129	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
889	0.0000	3.0348	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
890	0.0000	27.7004	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
891	0.0000	27.7004	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
892	0.0000	-0.0000	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
893	0.0000	-0.0000	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
894	0.0000	17.4542	162.11	-67.08	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
895	0.0000	22.0024	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
896	0.0000	21.9703	161.99	-67.11	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
897	0.0000	-0.0000	158.68	-67.81	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
898	0.0000	-0.0005	158.68	-67.81	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
901	0.0000	22.9721	142.50	-71.25	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
903	0.0000	23.0783	257.60	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
974	0.0000	32.2854	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
975	0.0000	27.5277	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
976	0.0000	57.0000	 57.00	  0.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
977	0.0000	57.0000	 57.00	  0.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
978	0.0000	57.0000	 57.00	  0.00	1.01	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
979	0.0000	57.0000	 57.00	  0.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
980	0.0000	26.8085	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
981	0.0000	26.8085	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
982	0.0000	57.0000	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
983	0.0000	27.5277	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
984	0.0000	21.4158	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
985	0.0000	25.8162	 57.00	  0.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1083	196.5000	24.8225	 56.00	-46.00	1.05	100	1	196.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1084	196.5000	24.8225	 56.00	-46.00	1.05	100	1	196.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1085	196.5000	24.8225	 56.00	-46.00	1.05	100	1	196.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1288	200.5500	60.1959	 85.00	-60.00	1.05	100	1	200.55	0.00	0	0	0	0	0	0	0	0	0	0	0;
1289	200.5500	60.1959	 85.00	-60.00	1.05	100	1	200.55	0.00	0	0	0	0	0	0	0	0	0	0	0;
1290	200.5500	60.1959	 85.00	-60.00	1.05	100	1	200.55	0.00	0	0	0	0	0	0	0	0	0	0	0;
1323	202.5000	40.4909	 83.00	-48.00	1.05	100	1	202.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1324	202.5000	40.4909	 83.00	-48.00	1.05	100	1	202.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1325	202.5000	40.4909	100.00	-57.00	1.05	100	1	202.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1327	294.4026	112.5368	176.55	-129.80	1.05	100	1	510.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1372	299.3907	138.0000	138.00	-138.00	1.05	100	1	630.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1374	61.5000	7.0000	  7.00	 -7.00	1.05	100	1	61.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1375	61.5000	7.0000	  7.00	 -7.00	1.05	100	1	61.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1376	61.5000	7.0000	  7.00	 -7.00	1.05	100	1	61.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1377	61.5000	15.1000	 15.10	-15.10	1.05	100	1	61.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1378	96.0000	20.7000	 20.70	-20.70	1.05	100	1	96.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1387	237.0000	51.9300	 51.93	-51.93	1.05	100	1	237.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1392	220.0764	64.6089	176.00	-52.00	1.05	100	1	432.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1393	220.0764	64.6089	176.00	-52.00	1.05	100	1	432.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1394	220.0764	2.0000	  2.00	 -2.00	1.05	100	1	432.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1395	220.0764	2.0000	  2.00	 -2.00	1.05	100	1	432.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1397	247.3043	-135.4185	414.40	-190.50	1.05	100	1	900.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1398	247.3043	-135.4185	414.40	-190.50	1.05	100	1	900.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1400	232.0515	97.9010	405.00	-171.00	1.05	100	1	907.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1401	232.0320	89.3214	128.00	-97.00	1.05	100	1	907.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1403	105.7500	45.0000	 45.00	-24.00	1.05	100	1	105.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
1405	78.7500	37.0000	 37.00	-20.00	1.05	100	1	78.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
1407	190.5834	73.1566	371.80	-108.00	1.05	100	1	864.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1408	190.5834	73.1566	371.80	-108.00	1.05	100	1	864.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1409	190.5834	73.1711	371.80	-108.00	1.05	100	1	864.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1410	190.5765	70.8106	371.80	-108.00	1.05	100	1	864.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1412	165.0000	13.3483	 68.00	-39.00	1.05	100	1	165.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1413	165.0000	13.3497	 68.00	-39.00	1.05	100	1	165.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1415	165.0000	13.3411	 48.00	-33.00	1.05	100	1	165.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1416	165.0000	13.3411	 48.00	-33.00	1.05	100	1	165.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1418	140.4000	10.0000	 10.00	-10.00	1.05	100	1	140.40	0.00	0	0	0	0	0	0	0	0	0	0	0;
1420	53.3166	32.4500	 32.45	-22.02	1.05	100	1	72.36	0.00	0	0	0	0	0	0	0	0	0	0	0;
1422	53.3709	32.4500	 32.45	-22.02	1.05	100	1	72.36	0.00	0	0	0	0	0	0	0	0	0	0	0;
1424	32.4000	1.8215	  9.86	 -9.86	1.05	100	1	32.40	0.00	0	0	0	0	0	0	0	0	0	0	0;
1426	68.0400	3.8918	 30.27	-20.54	1.05	100	1	68.04	0.00	0	0	0	0	0	0	0	0	0	0	0;
1428	35.6400	16.9500	 16.95	-11.50	1.05	100	1	35.64	0.00	0	0	0	0	0	0	0	0	0	0	0;
1430	41.0400	3.5702	 12.49	-12.49	1.05	100	1	41.04	0.00	0	0	0	0	0	0	0	0	0	0	0;
1432	67.5000	5.4279	 14.79	-14.79	1.05	100	1	67.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1434	115.9200	11.5464	 35.27	-35.27	1.05	100	1	115.92	0.00	0	0	0	0	0	0	0	0	0	0	0;
1436	115.9200	11.5464	 35.27	-35.27	1.05	100	1	115.92	0.00	0	0	0	0	0	0	0	0	0	0	0;
1438	115.9200	11.5464	 35.27	-35.27	1.05	100	1	115.92	0.00	0	0	0	0	0	0	0	0	0	0	0;
1440	34.5600	10.3500	 10.35	-10.35	1.05	100	1	34.56	0.00	0	0	0	0	0	0	0	0	0	0	0;
1683	180.0000	84.0399	 88.00	-47.00	1.05	100	1	180.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1728	49.5000	7.4509	 24.81	-25.50	1.05	100	1	49.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1786	20.5200	3.5000	  3.50	 -3.50	1.05	100	1	20.52	0.00	0	0	0	0	0	0	0	0	0	0	0;
1788	12.9600	-1.0000	 -1.00	 -1.00	1.02	100	1	12.96	0.00	0	0	0	0	0	0	0	0	0	0	0;
1790	30.2400	3.8400	  6.90	 -6.90	1.05	100	1	30.24	0.00	0	0	0	0	0	0	0	0	0	0	0;
1792	31.3200	0.4289	  5.00	 -5.00	1.05	100	1	31.32	0.00	0	0	0	0	0	0	0	0	0	0	0;
1794	9.3600	-1.0000	 -1.00	 -1.00	1.05	100	1	9.36	0.00	0	0	0	0	0	0	0	0	0	0	0;
1796	23.0100	5.1704	  7.00	 -7.00	1.04	100	1	23.01	0.00	0	0	0	0	0	0	0	0	0	0	0;
1798	39.9600	10.7000	 10.70	 -7.30	1.05	100	1	39.96	0.00	0	0	0	0	0	0	0	0	0	0	0;
1800	39.9600	10.7000	 10.70	 -7.30	1.05	100	1	39.96	0.00	0	0	0	0	0	0	0	0	0	0	0;
1802	20.2500	1.0263	  3.50	 -3.50	1.05	100	1	20.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
1804	32.4000	-6.0000	 -6.00	 -6.00	1.05	100	1	32.40	0.00	0	0	0	0	0	0	0	0	0	0	0;
1806	54.6400	16.0000	 16.00	-16.00	1.05	100	1	54.64	0.00	0	0	0	0	0	0	0	0	0	0	0;
1812	25.9200	-2.5000	 -2.50	 -2.50	1.05	100	1	25.92	0.00	0	0	0	0	0	0	0	0	0	0	0;
1814	25.9200	-2.5000	 -2.50	 -2.50	1.05	100	1	25.92	0.00	0	0	0	0	0	0	0	0	0	0	0;
1824	24.0000	1.7244	  5.25	 -5.25	1.05	100	1	24.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1826	24.0000	4.6034	  5.25	 -5.25	1.05	100	1	24.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1828	31.3200	-2.5000	 -2.50	 -2.50	1.05	100	1	31.32	0.00	0	0	0	0	0	0	0	0	0	0	0;
1830	28.6500	6.4281	  8.30	  0.00	1.05	100	1	28.65	0.00	0	0	0	0	0	0	0	0	0	0	0;
1834	16.2000	-3.0000	 -3.00	 -3.00	1.05	100	1	16.20	0.00	0	0	0	0	0	0	0	0	0	0	0;
1838	32.4000	9.8600	  9.86	 -9.86	1.05	100	1	32.40	0.00	0	0	0	0	0	0	0	0	0	0	0;
1840	37.5000	12.1000	 12.10	  0.00	1.05	100	1	37.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1842	37.5000	12.1000	 12.10	  0.00	1.05	100	1	37.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1844	49.6800	9.0000	  9.00	 -9.00	1.05	100	1	49.68	0.00	0	0	0	0	0	0	0	0	0	0	0;
1846	49.6800	9.0000	  9.00	 -9.00	1.05	100	1	49.68	0.00	0	0	0	0	0	0	0	0	0	0	0;
1848	34.5000	0.0000	  0.00	  0.00	1.03	100	1	34.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1849	34.5000	0.0000	  0.00	  0.00	1.04	100	1	34.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1852	24.7500	10.2000	 10.20	 -5.40	1.05	100	1	24.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
1854	158.8433	-15.9335	 40.00	-80.00	1.05	100	1	225.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1855	158.7945	-15.0214	 40.00	-80.00	1.05	100	1	225.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1857	7.5000	-0.5000	 -0.50	 -0.50	1.05	100	1	7.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1861	55.5000	0.0000	 13.74	  0.00	1.04	100	1	55.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1863	14.0400	-0.0265	  4.20	 -4.20	1.05	100	1	14.04	0.00	0	0	0	0	0	0	0	0	0	0	0;
1865	14.0400	1.3935	  4.20	 -4.20	1.05	100	1	14.04	0.00	0	0	0	0	0	0	0	0	0	0	0;
1867	32.5500	4.1739	  5.26	  0.00	1.05	100	1	32.55	0.00	0	0	0	0	0	0	0	0	0	0	0;
1873	11.2300	1.5000	  1.50	 -1.50	1.05	100	1	11.23	0.00	0	0	0	0	0	0	0	0	0	0	0;
1875	15.0000	3.2169	  4.30	 -2.70	1.05	100	1	15.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1876	15.0000	3.2169	  4.30	 -2.70	1.05	100	1	15.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1877	15.0000	3.2169	  4.30	 -2.70	1.05	100	1	15.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1886	22.5000	7.3000	  7.30	 -2.80	1.05	100	1	22.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
1892	12.4500	6.5800	  6.58	 -3.90	1.05	100	1	12.45	0.00	0	0	0	0	0	0	0	0	0	0	0;
1894	70.2000	-6.7171	 15.00	-15.00	1.05	100	1	70.20	0.00	0	0	0	0	0	0	0	0	0	0	0;
1896	27.9900	3.1450	  5.26	  0.00	1.05	100	1	27.99	0.00	0	0	0	0	0	0	0	0	0	0	0;
1898	19.9800	-1.0000	 -1.00	 -1.00	1.05	100	1	19.98	0.00	0	0	0	0	0	0	0	0	0	0	0;
1902	75.6000	13.0000	 13.00	-13.00	1.05	100	1	75.60	0.00	0	0	0	0	0	0	0	0	0	0	0;
1904	176.0118	14.1391	408.00	-50.00	1.05	100	1	558.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1906	175.9396	10.0718	408.00	-50.00	1.05	100	1	531.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1908	175.4977	5.7804	165.00	-87.50	1.05	100	1	399.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1910	175.4894	9.5241	165.00	-87.50	1.05	100	1	399.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1912	175.5202	10.3629	165.00	-87.50	1.05	100	1	399.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1914	27.0800	0.4138	  5.90	  0.00	1.05	100	1	27.08	0.00	0	0	0	0	0	0	0	0	0	0	0;
1916	25.2000	5.3053	 10.50	  0.00	1.05	100	1	25.20	0.00	0	0	0	0	0	0	0	0	0	0	0;
1918	27.9300	0.0000	  6.00	  0.00	1.05	100	1	27.93	0.00	0	0	0	0	0	0	0	0	0	0	0;
1920	60.0000	13.5000	 13.50	 -7.50	1.04	100	1	60.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1922	60.0000	13.5000	 13.50	 -7.50	1.04	100	1	60.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1924	60.0000	13.5000	 13.50	 -7.50	1.04	100	1	60.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1926	48.7500	18.9000	 18.90	 -9.00	1.05	100	1	48.75	0.00	0	0	0	0	0	0	0	0	0	0	0;
1928	7.8000	-1.5000	 -1.50	 -1.50	1.05	100	1	7.80	0.00	0	0	0	0	0	0	0	0	0	0	0;
1930	18.0000	0.0000	  0.00	  0.00	1.05	100	1	18.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
1932	72.3600	-12.2100	 17.91	-12.21	1.05	100	1	72.36	0.00	0	0	0	0	0	0	0	0	0	0	0;
1939	20.2500	-3.0000	 -3.00	 -3.00	1.05	100	1	20.25	0.00	0	0	0	0	0	0	0	0	0	0	0;
1941	23.1000	-5.0000	  0.00	 -5.00	1.05	100	1	23.10	0.00	0	0	0	0	0	0	0	0	0	0	0;
2028	7.5000	-1.0000	 -1.00	 -1.00	1.05	100	1	7.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
2039	9.3000	0.0000	  0.00	  0.00	1.05	100	1	9.30	0.00	0	0	0	0	0	0	0	0	0	0	0;
2040	9.3000	0.0000	  0.00	  0.00	1.05	100	1	9.30	0.00	0	0	0	0	0	0	0	0	0	0	0;
2074	37.5000	5.8602	 12.10	  0.00	1.05	100	1	37.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
2090	22.5000	0.0000	  0.00	  0.00	1.04	100	1	22.50	0.00	0	0	0	0	0	0	0	0	0	0	0;
2212	66.0000	0.0000	 32.70	  0.00	1.05	100	1	66.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
352	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
353	0.0000	150.0000	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
425	0.0000	72.6034	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
572	0.0000	59.8381	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
574	0.0000	70.5590	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
585	0.0000	87.7914	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
535	0.0000	150.0000	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
560	0.0000	33.6876	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
560	0.0000	33.6876	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
412	0.0000	150.0000	150.00	-50.00	1.02	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
405	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
408	313.8041	69.5779	250.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
408	313.8041	69.5779	250.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
374	0.0000	150.0000	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
374	0.0000	150.0000	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
422	0.0000	150.0000	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
422	0.0000	150.0000	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
425	0.0000	72.6034	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
425	0.0000	72.6034	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
348	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
359	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
359	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
444	0.0000	-3.3863	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
522	0.0000	137.1461	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
541	0.0000	150.0000	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
347	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
565	0.0000	90.6790	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
614	0.0000	39.0017	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
546	0.0000	150.0000	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
544	0.0000	150.0000	150.00	-50.00	1.03	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
533	0.0000	150.0000	150.00	-50.00	1.01	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
364	0.0000	150.0000	150.00	-50.00	1.04	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
606	0.0000	30.8018	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
606	0.0000	30.8018	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
567	0.0000	150.0000	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
614	0.0000	39.0017	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
624	0.0000	44.1259	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
439	0.0000	22.4523	150.00	-50.00	1.05	100	1	0.00	0.00	0	0	0	0	0	0	0	0	0	0	0;
];
%% Transmission Lines Data
mpc.branch = [
1	2	0.00089	0.02682	0.00000	9900.00	9900.00	9900.00	0.9991	0.00	1	-360.00	360.00;
1	3	0.00055	0.02700	0.00000	9900.00	9900.00	9900.00	0.9999	0.00	1	-360.00	360.00;
1	4	0.00080	0.02677	0.00000	9900.00	9900.00	9900.00	0.9992	0.00	1	-360.00	360.00;
5	6	0.00213	0.11452	0.00000	9900.00	9900.00	9900.00	1.0138	0.00	1	-360.00	360.00;
5	7	0.00213	0.11471	0.00000	9900.00	9900.00	9900.00	1.0138	0.00	1	-360.00	360.00;
8	9	0.00213	0.11316	0.00000	9900.00	9900.00	9900.00	1.0130	0.00	1	-360.00	360.00;
8	10	0.00206	0.11458	0.00000	9900.00	9900.00	9900.00	1.0139	0.00	1	-360.00	360.00;
8	11	0.00206	0.11490	0.00000	9900.00	9900.00	9900.00	1.0139	0.00	1	-360.00	360.00;
5	12	0.00194	0.10912	0.00000	9900.00	9900.00	9900.00	1.0138	0.00	1	-360.00	360.00;
8	13	0.00100	0.08396	0.00000	9900.00	9900.00	9900.00	1.0221	0.00	1	-360.00	360.00;
14	15	0.00030	0.02828	0.00000	9900.00	9900.00	9900.00	1.0282	0.00	1	-360.00	360.00;
14	16	0.00048	0.02805	0.00000	9900.00	9900.00	9900.00	1.0175	0.00	1	-360.00	360.00;
14	17	0.00032	0.02788	0.00000	9900.00	9900.00	9900.00	1.0261	0.00	1	-360.00	360.00;
14	18	0.00035	0.02780	0.00000	9900.00	9900.00	9900.00	1.0238	0.00	1	-360.00	360.00;
19	20	0.00130	0.06616	0.00000	9900.00	9900.00	9900.00	1.0337	0.00	1	-360.00	360.00;
19	21	0.00130	0.06616	0.00000	9900.00	9900.00	9900.00	1.0337	0.00	1	-360.00	360.00;
19	22	0.00130	0.06616	0.00000	9900.00	9900.00	9900.00	1.0445	0.00	1	-360.00	360.00;
23	24	0.00068	0.02772	0.00000	9900.00	9900.00	9900.00	1.0313	0.00	1	-360.00	360.00;
23	25	0.00075	0.02715	0.00000	9900.00	9900.00	9900.00	1.0280	0.00	1	-360.00	360.00;
26	27	0.00070	0.02673	0.00000	9900.00	9900.00	9900.00	1.0224	0.00	1	-360.00	360.00;
26	28	0.00068	0.02767	0.00000	9900.00	9900.00	9900.00	1.0237	0.00	1	-360.00	360.00;
29	30	0.00070	0.04677	0.00000	9900.00	9900.00	9900.00	0.9796	0.00	1	-360.00	360.00;
29	31	0.00070	0.04677	0.00000	9900.00	9900.00	9900.00	0.9796	0.00	1	-360.00	360.00;
29	32	0.00070	0.04677	0.00000	9900.00	9900.00	9900.00	0.9796	0.00	1	-360.00	360.00;
29	33	0.00070	0.04677	0.00000	9900.00	9900.00	9900.00	0.9796	0.00	1	-360.00	360.00;
29	34	0.00070	0.04677	0.00000	9900.00	9900.00	9900.00	0.9796	0.00	1	-360.00	360.00;
29	35	0.00070	0.04677	0.00000	9900.00	9900.00	9900.00	1.0386	0.00	1	-360.00	360.00;
36	37	0.00039	0.01976	0.00000	9900.00	9900.00	9900.00	1.0163	0.00	1	-360.00	360.00;
36	38	0.00039	0.01966	0.00000	9900.00	9900.00	9900.00	1.0163	0.00	1	-360.00	360.00;
36	39	0.00039	0.02009	0.00000	9900.00	9900.00	9900.00	1.0166	0.00	1	-360.00	360.00;
40	41	0.00045	0.01915	0.00000	9900.00	9900.00	9900.00	1.0211	0.00	1	-360.00	360.00;
40	42	0.00045	0.01931	0.00000	9900.00	9900.00	9900.00	1.0213	0.00	1	-360.00	360.00;
40	43	0.00043	0.01911	0.00000	9900.00	9900.00	9900.00	1.0220	0.00	1	-360.00	360.00;
44	45	0.00020	0.02043	0.00000	9900.00	9900.00	9900.00	1.0319	0.00	1	-360.00	360.00;
44	46	0.00021	0.02056	0.00000	9900.00	9900.00	9900.00	1.0305	0.00	1	-360.00	360.00;
47	48	0.00073	0.02523	0.00000	9900.00	9900.00	9900.00	1.0302	0.00	1	-360.00	360.00;
47	49	0.00110	0.02770	0.00000	9900.00	9900.00	9900.00	1.0221	0.00	1	-360.00	360.00;
50	51	0.00091	0.02577	0.00000	9900.00	9900.00	9900.00	1.0205	0.00	1	-360.00	360.00;
50	52	0.00073	0.02702	0.00000	9900.00	9900.00	9900.00	1.0263	0.00	1	-360.00	360.00;
53	54	0.00073	0.02523	0.00000	9900.00	9900.00	9900.00	1.0175	0.00	1	-360.00	360.00;
53	55	0.00073	0.02532	0.00000	9900.00	9900.00	9900.00	1.0175	0.00	1	-360.00	360.00;
56	57	0.00059	0.02800	0.00000	9900.00	9900.00	9900.00	1.0500	0.00	1	-360.00	360.00;
58	59	0.00030	0.02778	0.00000	9900.00	9900.00	9900.00	1.0747	0.00	1	-360.00	360.00;
60	61	0.00062	0.02754	0.00000	9900.00	9900.00	9900.00	1.0659	0.00	1	-360.00	360.00;
56	62	0.00056	0.02818	0.00000	9900.00	9900.00	9900.00	1.0528	0.00	1	-360.00	360.00;
63	64	0.00400	0.09778	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
63	65	0.00400	0.09778	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
66	67	0.00045	0.02930	0.00000	9900.00	9900.00	9900.00	1.0281	0.00	1	-360.00	360.00;
68	69	0.00040	0.02928	0.00000	9900.00	9900.00	9900.00	1.0285	0.00	1	-360.00	360.00;
70	71	0.00045	0.02893	0.00000	9900.00	9900.00	9900.00	1.0371	0.00	1	-360.00	360.00;
72	73	0.00045	0.02773	0.00000	9900.00	9900.00	9900.00	1.0353	0.00	1	-360.00	360.00;
74	75	0.00025	0.01910	0.00000	9900.00	9900.00	9900.00	1.0497	0.00	1	-360.00	360.00;
74	76	0.00021	0.01910	0.00000	9900.00	9900.00	9900.00	1.0497	0.00	1	-360.00	360.00;
74	77	0.00023	0.01933	0.00000	9900.00	9900.00	9900.00	1.0497	0.00	1	-360.00	360.00;
74	78	0.00020	0.01957	0.00000	9900.00	9900.00	9900.00	1.0497	0.00	1	-360.00	360.00;
79	80	0.00037	0.02177	0.00000	9900.00	9900.00	9900.00	1.0442	0.00	1	-360.00	360.00;
79	81	0.00035	0.02177	0.00000	9900.00	9900.00	9900.00	1.0465	0.00	1	-360.00	360.00;
82	83	0.00023	0.02024	0.00000	9900.00	9900.00	9900.00	1.0218	0.00	1	-360.00	360.00;
82	84	0.00024	0.02053	0.00000	9900.00	9900.00	9900.00	1.0212	0.00	1	-360.00	360.00;
82	85	0.00021	0.01975	0.00000	9900.00	9900.00	9900.00	1.0234	0.00	1	-360.00	360.00;
82	86	0.00021	0.01950	0.00000	9900.00	9900.00	9900.00	1.0231	0.00	1	-360.00	360.00;
87	88	0.00022	0.02133	0.00000	9900.00	9900.00	9900.00	1.0101	0.00	1	-360.00	360.00;
87	89	0.00023	0.02056	0.00000	9900.00	9900.00	9900.00	1.0093	0.00	1	-360.00	360.00;
90	91	0.00075	0.02735	0.00000	9900.00	9900.00	9900.00	1.0725	0.00	1	-360.00	360.00;
90	92	0.00073	0.02805	0.00000	9900.00	9900.00	9900.00	1.0745	0.00	1	-360.00	360.00;
93	94	0.00057	0.05251	0.00000	9900.00	9900.00	9900.00	1.0590	0.00	1	-360.00	360.00;
95	96	0.00057	0.05245	0.00000	9900.00	9900.00	9900.00	1.0078	0.00	1	-360.00	360.00;
95	97	0.00057	0.05242	0.00000	9900.00	9900.00	9900.00	1.0078	0.00	1	-360.00	360.00;
98	99	0.00167	0.07167	0.00000	9900.00	9900.00	9900.00	1.0091	0.00	1	-360.00	360.00;
98	100	0.00110	0.06517	0.00000	9900.00	9900.00	9900.00	1.0155	0.00	1	-360.00	360.00;
98	101	0.00167	0.07111	0.00000	9900.00	9900.00	9900.00	1.0091	0.00	1	-360.00	360.00;
98	102	0.00167	0.07111	0.00000	9900.00	9900.00	9900.00	1.0091	0.00	1	-360.00	360.00;
98	103	0.00127	0.06341	0.00000	9900.00	9900.00	9900.00	1.0112	0.00	1	-360.00	360.00;
98	104	0.00127	0.06341	0.00000	9900.00	9900.00	9900.00	1.0112	0.00	1	-360.00	360.00;
98	105	0.00164	0.06970	0.00000	9900.00	9900.00	9900.00	1.0093	0.00	1	-360.00	360.00;
98	106	0.00164	0.06970	0.00000	9900.00	9900.00	9900.00	1.0093	0.00	1	-360.00	360.00;
98	107	0.00164	0.06970	0.00000	9900.00	9900.00	9900.00	1.0093	0.00	1	-360.00	360.00;
98	108	0.00118	0.04815	0.00000	9900.00	9900.00	9900.00	1.0104	0.00	1	-360.00	360.00;
109	110	0.00042	0.02838	0.00000	9900.00	9900.00	9900.00	1.0186	0.00	1	-360.00	360.00;
109	111	0.00041	0.02832	0.00000	9900.00	9900.00	9900.00	1.0190	0.00	1	-360.00	360.00;
112	113	0.00041	0.02692	0.00000	9900.00	9900.00	9900.00	1.0181	0.00	1	-360.00	360.00;
112	114	0.00041	0.02862	0.00000	9900.00	9900.00	9900.00	1.0190	0.00	1	-360.00	360.00;
115	116	0.00048	0.06271	0.00000	9900.00	9900.00	9900.00	1.0617	0.00	1	-360.00	360.00;
115	117	0.00047	0.06227	0.00000	9900.00	9900.00	9900.00	1.0613	0.00	1	-360.00	360.00;
115	118	0.00034	0.04974	0.00000	9900.00	9900.00	9900.00	1.0658	0.00	1	-360.00	360.00;
119	120	0.00034	0.01961	0.00000	9900.00	9900.00	9900.00	1.0041	0.00	1	-360.00	360.00;
119	121	0.00035	0.01947	0.00000	9900.00	9900.00	9900.00	1.0037	0.00	1	-360.00	360.00;
119	122	0.00035	0.01954	0.00000	9900.00	9900.00	9900.00	1.0464	0.00	1	-360.00	360.00;
123	124	0.00747	0.05421	0.00000	9900.00	9900.00	9900.00	1.0112	0.00	1	-360.00	360.00;
123	125	0.00748	0.05407	0.00000	9900.00	9900.00	9900.00	1.0113	0.00	1	-360.00	360.00;
123	126	0.00752	0.05452	0.00000	9900.00	9900.00	9900.00	1.0112	0.00	1	-360.00	360.00;
127	128	0.00042	0.02698	0.00000	9900.00	9900.00	9900.00	1.0574	0.00	1	-360.00	360.00;
127	129	0.00019	0.01961	0.00000	9900.00	9900.00	9900.00	1.0394	0.00	1	-360.00	360.00;
130	131	0.00019	0.01964	0.00000	9900.00	9900.00	9900.00	1.0330	0.00	1	-360.00	360.00;
130	132	0.00056	0.02456	0.00000	9900.00	9900.00	9900.00	1.0457	0.00	1	-360.00	360.00;
133	134	0.00089	0.02490	0.00000	9900.00	9900.00	9900.00	1.0475	0.00	1	-360.00	360.00;
133	135	0.00089	0.02453	0.00000	9900.00	9900.00	9900.00	1.0469	0.00	1	-360.00	360.00;
136	137	0.00167	0.07100	0.00000	9900.00	9900.00	9900.00	1.0349	0.00	1	-360.00	360.00;
136	138	0.00127	0.06390	0.00000	9900.00	9900.00	9900.00	1.0430	0.00	1	-360.00	360.00;
136	139	0.00167	0.07139	0.00000	9900.00	9900.00	9900.00	1.0350	0.00	1	-360.00	360.00;
136	140	0.00098	0.04423	0.00000	9900.00	9900.00	9900.00	1.0390	0.00	1	-360.00	360.00;
141	142	0.00022	0.01963	0.00000	9900.00	9900.00	9900.00	1.0462	0.00	1	-360.00	360.00;
141	143	0.00022	0.01968	0.00000	9900.00	9900.00	9900.00	1.0463	0.00	1	-360.00	360.00;
144	145	0.00140	0.10349	0.00000	9900.00	9900.00	9900.00	1.0133	0.00	1	-360.00	360.00;
144	146	0.00128	0.10405	0.00000	9900.00	9900.00	9900.00	1.0163	0.00	1	-360.00	360.00;
144	147	0.00128	0.10405	0.00000	9900.00	9900.00	9900.00	1.0163	0.00	1	-360.00	360.00;
144	148	0.00134	0.10465	0.00000	9900.00	9900.00	9900.00	1.0146	0.00	1	-360.00	360.00;
149	150	0.00133	0.10349	0.00000	9900.00	9900.00	9900.00	1.0150	0.00	1	-360.00	360.00;
149	151	0.00140	0.10465	0.00000	9900.00	9900.00	9900.00	1.0131	0.00	1	-360.00	360.00;
149	152	0.00133	0.10349	0.00000	9900.00	9900.00	9900.00	1.0150	0.00	1	-360.00	360.00;
149	153	0.00133	0.10405	0.00000	9900.00	9900.00	9900.00	1.0149	0.00	1	-360.00	360.00;
144	154	0.00062	0.04425	0.00000	9900.00	9900.00	9900.00	1.0287	0.00	1	-360.00	360.00;
149	155	0.00060	0.04475	0.00000	9900.00	9900.00	9900.00	1.0301	0.00	1	-360.00	360.00;
144	156	0.01254	0.48109	0.00000	9900.00	9900.00	9900.00	1.0419	0.00	1	-360.00	360.00;
157	158	0.00193	0.04390	0.00000	9900.00	9900.00	9900.00	1.0590	0.00	1	-360.00	360.00;
157	159	0.00187	0.04358	0.00000	9900.00	9900.00	9900.00	1.0144	0.00	1	-360.00	360.00;
160	161	0.00049	0.04264	0.00000	9900.00	9900.00	9900.00	1.0383	0.00	1	-360.00	360.00;
160	162	0.00193	0.04365	0.00000	9900.00	9900.00	9900.00	1.0101	0.00	1	-360.00	360.00;
163	164	0.00073	0.02693	0.00000	9900.00	9900.00	9900.00	1.0394	0.00	1	-360.00	360.00;
163	165	0.00075	0.02713	0.00000	9900.00	9900.00	9900.00	1.0386	0.00	1	-360.00	360.00;
163	166	0.00072	0.02725	0.00000	9900.00	9900.00	9900.00	1.0403	0.00	1	-360.00	360.00;
163	167	0.00073	0.02713	0.00000	9900.00	9900.00	9900.00	1.0396	0.00	1	-360.00	360.00;
168	169	0.00096	0.04795	0.00000	9900.00	9900.00	9900.00	0.9942	0.00	1	-360.00	360.00;
168	170	0.00097	0.04913	0.00000	9900.00	9900.00	9900.00	0.9939	0.00	1	-360.00	360.00;
168	171	0.00092	0.04751	0.00000	9900.00	9900.00	9900.00	0.9945	0.00	1	-360.00	360.00;
168	172	0.00059	0.04619	0.00000	9900.00	9900.00	9900.00	0.9974	0.00	1	-360.00	360.00;
173	174	0.00046	0.03752	0.00000	9900.00	9900.00	9900.00	1.0469	0.00	1	-360.00	360.00;
173	175	0.00046	0.03757	0.00000	9900.00	9900.00	9900.00	1.0470	0.00	1	-360.00	360.00;
173	176	0.00046	0.03774	0.00000	9900.00	9900.00	9900.00	1.0471	0.00	1	-360.00	360.00;
173	177	0.00046	0.03767	0.00000	9900.00	9900.00	9900.00	1.0471	0.00	1	-360.00	360.00;
26	178	0.00086	0.04807	0.00000	9900.00	9900.00	9900.00	1.0268	0.00	1	-360.00	360.00;
26	179	0.00086	0.04807	0.00000	9900.00	9900.00	9900.00	1.0268	0.00	1	-360.00	360.00;
26	180	0.00077	0.04525	0.00000	9900.00	9900.00	9900.00	1.0292	0.00	1	-360.00	360.00;
181	182	0.00105	0.03622	0.00000	9900.00	9900.00	9900.00	1.0390	0.00	1	-360.00	360.00;
183	184	0.00130	0.06653	0.00000	9900.00	9900.00	9900.00	1.0133	0.00	1	-360.00	360.00;
183	185	0.00130	0.06674	0.00000	9900.00	9900.00	9900.00	1.0133	0.00	1	-360.00	360.00;
183	186	0.00122	0.06637	0.00000	9900.00	9900.00	9900.00	1.0145	0.00	1	-360.00	360.00;
183	187	0.00065	0.04656	0.00000	9900.00	9900.00	9900.00	1.0253	0.00	1	-360.00	360.00;
23	188	0.00086	0.04807	0.00000	9900.00	9900.00	9900.00	1.0345	0.00	1	-360.00	360.00;
23	189	0.00086	0.04807	0.00000	9900.00	9900.00	9900.00	1.0370	0.00	1	-360.00	360.00;
23	190	0.00077	0.04525	0.00000	9900.00	9900.00	9900.00	1.0400	0.00	1	-360.00	360.00;
183	191	0.00132	0.06621	0.00000	9900.00	9900.00	9900.00	1.0124	0.00	1	-360.00	360.00;
183	192	0.00132	0.06642	0.00000	9900.00	9900.00	9900.00	1.0124	0.00	1	-360.00	360.00;
183	193	0.00129	0.06624	0.00000	9900.00	9900.00	9900.00	1.0136	0.00	1	-360.00	360.00;
194	195	0.00077	0.04377	0.00000	9900.00	9900.00	9900.00	1.0346	0.00	1	-360.00	360.00;
194	196	0.00077	0.04377	0.00000	9900.00	9900.00	9900.00	1.0346	0.00	1	-360.00	360.00;
194	197	0.00077	0.04377	0.00000	9900.00	9900.00	9900.00	1.0346	0.00	1	-360.00	360.00;
198	199	0.00058	0.04417	0.00000	9900.00	9900.00	9900.00	1.0503	0.00	1	-360.00	360.00;
198	200	0.00058	0.04417	0.00000	9900.00	9900.00	9900.00	1.0503	0.00	1	-360.00	360.00;
198	201	0.00058	0.04417	0.00000	9900.00	9900.00	9900.00	1.0548	0.00	1	-360.00	360.00;
202	203	0.00007	0.04600	0.00000	9900.00	9900.00	9900.00	1.0399	0.00	1	-360.00	360.00;
202	204	0.00007	0.04600	0.00000	9900.00	9900.00	9900.00	1.0399	0.00	1	-360.00	360.00;
202	205	0.00007	0.04600	0.00000	9900.00	9900.00	9900.00	1.0399	0.00	1	-360.00	360.00;
202	206	0.00050	0.03257	0.00000	9900.00	9900.00	9900.00	1.0019	0.00	1	-360.00	360.00;
207	208	0.00010	0.03477	0.00000	9900.00	9900.00	9900.00	1.0353	0.00	1	-360.00	360.00;
207	209	0.02025	0.41944	0.00000	9900.00	9900.00	9900.00	0.9882	0.00	1	-360.00	360.00;
210	211	0.00089	0.04754	0.00000	9900.00	9900.00	9900.00	1.0099	0.00	1	-360.00	360.00;
210	212	0.00089	0.04754	0.00000	9900.00	9900.00	9900.00	1.0099	0.00	1	-360.00	360.00;
210	213	0.00082	0.03506	0.00000	9900.00	9900.00	9900.00	1.0103	0.00	1	-360.00	360.00;
214	215	0.00068	0.04364	0.00000	9900.00	9900.00	9900.00	1.0135	0.00	1	-360.00	360.00;
214	216	0.00068	0.04364	0.00000	9900.00	9900.00	9900.00	1.0135	0.00	1	-360.00	360.00;
214	217	0.00068	0.04364	0.00000	9900.00	9900.00	9900.00	1.0135	0.00	1	-360.00	360.00;
218	219	0.00069	0.04047	0.00000	9900.00	9900.00	9900.00	1.0305	0.00	1	-360.00	360.00;
218	220	0.00069	0.04047	0.00000	9900.00	9900.00	9900.00	1.0305	0.00	1	-360.00	360.00;
218	221	0.00069	0.04047	0.00000	9900.00	9900.00	9900.00	1.0305	0.00	1	-360.00	360.00;
14	222	0.00028	0.02700	0.00000	9900.00	9900.00	9900.00	1.0291	0.00	1	-360.00	360.00;
223	224	0.00056	0.03804	0.00000	9900.00	9900.00	9900.00	1.0068	0.00	1	-360.00	360.00;
223	225	0.00056	0.03804	0.00000	9900.00	9900.00	9900.00	1.0068	0.00	1	-360.00	360.00;
223	226	0.00056	0.03804	0.00000	9900.00	9900.00	9900.00	1.0068	0.00	1	-360.00	360.00;
227	228	0.00000	0.02941	0.00000	9900.00	9900.00	9900.00	1.0452	0.00	1	-360.00	360.00;
227	229	0.00000	0.02941	0.00000	9900.00	9900.00	9900.00	1.0452	0.00	1	-360.00	360.00;
230	231	0.00127	0.03200	0.00000	9900.00	9900.00	9900.00	0.9920	0.00	1	-360.00	360.00;
230	232	0.00127	0.03200	0.00000	9900.00	9900.00	9900.00	0.9920	0.00	1	-360.00	360.00;
233	234	0.00291	0.10909	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
233	235	0.00291	0.10909	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
233	236	0.00291	0.10909	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
233	237	0.00291	0.10909	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
233	238	0.00291	0.10909	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
233	239	0.00291	0.10909	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
240	241	0.00051	0.04776	0.00000	9900.00	9900.00	9900.00	1.0188	0.00	1	-360.00	360.00;
240	242	0.00051	0.04776	0.00000	9900.00	9900.00	9900.00	1.0188	0.00	1	-360.00	360.00;
240	243	0.00126	0.10370	0.00000	9900.00	9900.00	9900.00	1.0103	0.00	1	-360.00	360.00;
240	244	0.00126	0.10370	0.00000	9900.00	9900.00	9900.00	1.0103	0.00	1	-360.00	360.00;
245	246	0.00365	0.17444	0.00000	9900.00	9900.00	9900.00	1.0393	0.00	1	-360.00	360.00;
245	247	0.00364	0.17222	0.00000	9900.00	9900.00	9900.00	1.0393	0.00	1	-360.00	360.00;
248	249	0.00107	0.04493	0.00000	9900.00	9900.00	9900.00	1.0156	0.00	1	-360.00	360.00;
250	251	0.00127	0.03449	0.00000	9900.00	9900.00	9900.00	1.0088	0.00	1	-360.00	360.00;
252	253	0.00320	0.12162	0.00000	9900.00	9900.00	9900.00	1.0241	0.00	1	-360.00	360.00;
252	254	0.00150	0.05952	0.00000	9900.00	9900.00	9900.00	1.0215	0.00	1	-360.00	360.00;
255	256	0.00880	0.24480	0.00000	9900.00	9900.00	9900.00	1.0032	0.00	1	-360.00	360.00;
255	257	0.00900	0.24440	0.00000	9900.00	9900.00	9900.00	1.0032	0.00	1	-360.00	360.00;
255	258	0.00880	0.24440	0.00000	9900.00	9900.00	9900.00	1.0033	0.00	1	-360.00	360.00;
255	259	0.00661	0.18846	0.00000	9900.00	9900.00	9900.00	1.0042	0.00	1	-360.00	360.00;
260	261	0.00053	0.03925	0.00000	9900.00	9900.00	9900.00	1.0316	0.00	1	-360.00	360.00;
262	263	0.00433	0.13400	0.00000	9900.00	9900.00	9900.00	1.0392	0.00	1	-360.00	360.00;
262	264	0.00444	0.13478	0.00000	9900.00	9900.00	9900.00	1.0384	0.00	1	-360.00	360.00;
262	265	0.00444	0.13578	0.00000	9900.00	9900.00	9900.00	1.0386	0.00	1	-360.00	360.00;
266	267	0.00000	0.17778	0.00000	9900.00	9900.00	9900.00	0.9712	0.00	1	-360.00	360.00;
266	268	0.00000	0.17778	0.00000	9900.00	9900.00	9900.00	0.9712	0.00	1	-360.00	360.00;
269	270	0.00052	0.03854	0.00000	9900.00	9900.00	9900.00	1.0346	0.00	1	-360.00	360.00;
271	272	0.00222	0.07333	0.00000	9900.00	9900.00	9900.00	1.0039	0.00	1	-360.00	360.00;
271	273	0.00421	0.14000	0.00000	9900.00	9900.00	9900.00	1.0073	0.00	1	-360.00	360.00;
274	275	0.00250	0.10434	0.00000	9900.00	9900.00	9900.00	0.9845	0.00	1	-360.00	360.00;
274	276	0.00250	0.10434	0.00000	9900.00	9900.00	9900.00	0.9845	0.00	1	-360.00	360.00;
274	277	0.00250	0.10434	0.00000	9900.00	9900.00	9900.00	0.9845	0.00	1	-360.00	360.00;
278	279	0.00203	0.01907	0.53320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
280	281	0.00164	0.01561	0.48680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
19	282	0.00095	0.01413	0.50110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
173	282	0.00095	0.01413	0.50110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
282	168	0.00038	0.00585	0.23870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
283	284	0.00055	0.00666	0.23970	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
82	285	0.00021	0.00193	0.05400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
82	286	0.00020	0.00189	0.05290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
287	288	0.00004	0.00038	0.01250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
19	289	0.00022	0.00265	0.08820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
290	289	0.00135	0.01234	0.37800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
291	289	0.00014	0.00218	0.07690	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
173	292	0.00025	0.00266	0.08760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
290	292	0.00135	0.01234	0.37800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
291	292	0.00014	0.00218	0.07690	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
282	293	0.00046	0.00671	0.24520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
294	293	0.00005	0.00084	0.94390	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
290	294	0.00013	0.00192	0.13210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
295	288	0.00004	0.00039	0.01210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
296	194	0.00002	0.00020	0.00670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
288	297	0.00052	0.00619	0.66980	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
288	298	0.00047	0.00527	0.18820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
19	298	0.00049	0.00551	0.19680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
288	299	0.00047	0.00527	0.18810	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
173	299	0.00049	0.00551	0.19680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
300	288	0.00003	0.00035	0.01180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
300	284	0.00099	0.01058	0.34840	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
288	301	0.00027	0.00296	0.09760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
282	168	0.00038	0.00585	0.23870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
29	282	0.00007	0.00118	2.15240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
302	297	0.00088	0.00918	0.28700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
303	302	0.00005	0.00034	0.80230	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
303	304	0.00014	0.00211	0.08520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
29	282	0.00009	0.00144	1.26750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
280	281	0.00164	0.01561	0.48680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
305	82	0.00055	0.00520	0.14540	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
306	82	0.00056	0.00524	0.14640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
305	284	0.00043	0.00390	0.17180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
306	284	0.00043	0.00390	0.17020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
284	286	0.00056	0.00597	0.19660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
284	285	0.00056	0.00595	0.19570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
305	307	0.00008	0.00077	0.02270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
306	308	0.00008	0.00077	0.02270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
301	283	0.00057	0.00696	0.24980	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
281	286	0.00072	0.00663	0.20220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
281	285	0.00059	0.00641	0.21090	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
309	173	0.00010	0.00189	0.07980	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
310	19	0.00010	0.00189	0.07980	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
310	296	0.00020	0.00312	0.12670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
309	296	0.00020	0.00307	0.12530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
311	280	0.00018	0.00194	0.06110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
312	313	0.00021	0.00301	0.09790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
314	312	0.00005	0.00031	0.76060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
314	315	0.00056	0.00869	0.35400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
316	98	0.00039	0.00689	0.26870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
317	318	0.00053	0.00826	0.32270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
316	93	0.00001	0.00014	0.07170	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
318	95	0.00001	0.00008	0.00230	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
40	47	0.00012	0.00194	0.07580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
319	320	0.00032	0.00489	0.19960	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
321	322	0.00029	0.00456	0.18600	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
319	323	0.00032	0.00489	0.19960	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
47	324	0.00011	0.00173	0.07060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
325	322	0.00039	0.00410	0.17270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
98	183	0.00017	0.00288	0.10610	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
317	183	0.00012	0.00202	0.07800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
40	320	0.00024	0.00368	0.15020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
325	323	0.00105	0.01623	2.68650	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
325	320	0.00105	0.01623	2.68650	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
326	327	0.00053	0.00758	0.29670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
326	315	0.00040	0.00619	0.25110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
36	327	0.00014	0.00224	0.09120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
47	328	0.00013	0.00203	0.08300	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
36	50	0.00013	0.00195	0.30520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
322	329	0.00104	0.01511	0.53180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
329	320	0.00018	0.00280	0.11430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
240	98	0.00003	0.00052	0.01630	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
36	323	0.00024	0.00368	0.15020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
330	323	0.00018	0.00280	0.11430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
240	331	0.00043	0.00668	0.24100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
322	330	0.00104	0.01511	0.53180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
50	332	0.00048	0.00740	0.30210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
47	315	0.00030	0.00467	0.25520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
319	331	0.00026	0.00488	0.20570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
316	331	0.00009	0.00132	0.05390	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
319	333	0.00026	0.00488	0.20570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
318	333	0.00009	0.00132	0.05390	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
333	98	0.00040	0.00617	0.22430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
40	315	0.00027	0.00363	0.37130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
334	332	0.00027	0.00251	0.07370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
327	335	0.00019	0.00199	0.26220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
47	336	0.00011	0.00175	0.07120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
336	283	0.00099	0.01503	0.57380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
50	337	0.00137	0.01589	0.66430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
338	283	0.00070	0.01050	0.39070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
210	163	0.00076	0.01428	0.58850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
316	163	0.00030	0.00469	0.19160	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
339	340	0.00203	0.01907	0.53320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
335	163	0.00030	0.00469	0.19150	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
341	163	0.00026	0.00279	0.13690	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
342	127	0.00113	0.01210	0.45730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
343	163	0.00231	0.02517	0.84030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
14	344	0.00049	0.00520	0.17120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
345	346	0.00069	0.00762	0.25740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
347	346	0.00077	0.00828	0.27250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
127	348	0.00035	0.00397	0.13180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
345	127	0.00040	0.00615	0.25120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
345	130	0.00040	0.00614	0.25070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
345	349	0.00069	0.00759	0.25660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
347	349	0.00077	0.00826	0.27180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
130	350	0.00075	0.00805	0.26510	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
130	348	0.00036	0.00410	0.17080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
14	351	0.00041	0.00484	0.17120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
343	351	0.00178	0.01904	0.62700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
343	352	0.00069	0.00740	0.24350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
343	353	0.00069	0.00743	0.24470	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
14	354	0.00145	0.02246	0.91690	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
14	354	0.00145	0.02246	0.91690	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
347	355	0.00015	0.00237	0.09660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
14	356	0.00055	0.00621	0.21330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
14	357	0.00055	0.00621	0.21330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
210	358	0.00027	0.00494	0.19760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
359	360	0.00071	0.00844	0.28120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
361	133	0.00036	0.00387	0.12740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
90	133	0.00113	0.01135	0.36450	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
90	362	0.00052	0.00475	0.14560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
90	363	0.00056	0.00530	0.16520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
361	364	0.00051	0.00550	0.18100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
361	365	0.00095	0.00925	0.37210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
366	364	0.00075	0.00806	0.26530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
366	90	0.00115	0.01234	0.40630	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
360	348	0.00030	0.00316	0.10420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
359	361	0.00071	0.00845	0.28160	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
360	130	0.00053	0.00604	0.20890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
364	348	0.00121	0.01496	0.79380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
90	367	0.00097	0.01151	0.38350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
359	288	0.00084	0.00990	0.77590	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
359	297	0.00049	0.00583	0.19430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
366	368	0.00117	0.01252	0.41220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
366	369	0.00138	0.01471	0.48290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
370	371	0.00074	0.00874	0.29110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
90	371	0.00023	0.00278	0.09240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
354	372	0.00039	0.00606	0.24740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
373	374	0.00037	0.00700	0.29550	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
374	372	0.00029	0.00446	0.18190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
374	353	0.00048	0.00745	0.30410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
352	372	0.00019	0.00302	0.12320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
375	352	0.00073	0.00670	0.20520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
376	377	0.00015	0.00176	2.44290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
378	353	0.00073	0.00668	0.20460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
379	380	0.00035	0.00378	0.12430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
381	382	0.00009	0.00078	1.71720	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
383	381	0.00000	0.00001	0.02700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
383	381	0.00000	0.00001	0.02700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
383	384	0.00009	0.00077	1.69020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
385	386	0.00043	0.00390	0.11940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
374	136	0.00025	0.00388	0.15860	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
136	387	0.00006	0.00088	0.03580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
374	388	0.00025	0.00381	0.15560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
388	389	0.00006	0.00093	0.03820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
390	353	0.00016	0.00245	0.10020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
355	352	0.00016	0.00245	0.10020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
354	115	0.00002	0.00032	0.49590	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
374	141	0.00119	0.01854	0.75670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
391	392	0.00051	0.00798	0.32590	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
391	393	0.00035	0.00551	0.22490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
392	394	0.00132	0.01238	0.36560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
392	141	0.00046	0.00708	0.28890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
395	393	0.00035	0.00551	0.22490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
395	374	0.00070	0.01089	0.44460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
394	141	0.00177	0.01948	0.66820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
392	141	0.00046	0.00708	0.28890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
373	358	0.00044	0.00839	0.35390	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
394	358	0.00169	0.01591	0.44480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
394	358	0.00169	0.01591	0.44480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
198	358	0.00008	0.00074	0.02260	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
373	374	0.00037	0.00697	0.29400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
373	358	0.00045	0.00844	0.35620	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
381	377	0.00006	0.00056	1.23890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
381	377	0.00006	0.00056	1.21970	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
354	372	0.00039	0.00606	0.24740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
396	397	0.00017	0.00185	0.05830	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
396	397	0.00017	0.00186	0.10640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
358	163	0.00091	0.01707	0.71480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
393	398	0.00036	0.00381	0.12540	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
218	393	0.00023	0.00253	0.08320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
218	399	0.00021	0.00226	0.07420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
379	347	0.00062	0.00665	0.21880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
385	347	0.00075	0.00686	0.21020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
396	400	0.00041	0.00438	0.14340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
396	400	0.00041	0.00434	0.14220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
401	402	0.00065	0.00714	0.22980	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
401	403	0.00065	0.00711	0.22830	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
214	112	0.00001	0.00010	0.16920	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
400	404	0.00009	0.00105	0.03850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
112	400	0.00028	0.00399	0.15870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
109	404	0.00019	0.00294	0.12020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
44	405	0.00038	0.00711	0.29980	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
44	405	0.00038	0.00715	0.30140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
406	405	0.00055	0.00853	0.34840	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
406	405	0.00055	0.00853	0.34840	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
407	408	0.00049	0.00512	0.22600	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
407	408	0.00049	0.00512	0.25730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
44	408	0.00043	0.00461	0.30040	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
44	408	0.00043	0.00461	0.30040	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
407	401	0.00045	0.00503	0.17970	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
74	401	0.00010	0.00139	0.64400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
74	401	0.00009	0.00135	0.64260	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
407	409	0.00021	0.00241	0.08610	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
409	401	0.00023	0.00262	0.09360	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
74	123	0.00005	0.00049	0.01440	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
119	402	0.00017	0.00157	0.04770	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
119	403	0.00017	0.00157	0.04790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
402	410	0.00057	0.00520	0.15890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
403	410	0.00057	0.00519	0.15880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
411	410	0.00010	0.00090	1.98220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
74	109	0.00013	0.00195	0.25760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
74	399	0.00031	0.00471	0.58380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
112	398	0.00018	0.00281	0.47360	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
406	412	0.00070	0.01078	0.44000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
406	412	0.00070	0.01078	0.44000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
230	368	0.00235	0.03652	1.89240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
413	230	0.00154	0.02386	0.97420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
413	230	0.00156	0.02420	0.98780	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
230	414	0.00090	0.01404	0.57320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
413	414	0.00065	0.01014	0.41380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
87	415	0.00151	0.01610	0.52990	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
87	415	0.00151	0.01610	0.53000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
415	202	0.00058	0.00899	0.35910	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
202	416	0.00036	0.00560	0.98030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
414	417	0.00001	0.00012	0.00380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
414	418	0.00001	0.00012	0.00380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
419	181	0.00209	0.01961	0.54810	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
413	420	0.00029	0.00455	0.17820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
420	368	0.00080	0.01232	0.91210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
421	422	0.00047	0.00882	0.37210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
181	423	0.00103	0.00938	0.28740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
424	425	0.00105	0.00983	0.27470	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
426	427	0.00156	0.01465	0.40940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
428	412	0.00068	0.00725	0.23880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
428	412	0.00068	0.00725	0.23880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
53	422	0.00065	0.01007	0.41100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
53	429	0.00022	0.00340	0.13890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
412	429	0.00039	0.00605	0.24680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
415	369	0.00049	0.00522	0.17170	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
423	227	0.00045	0.00412	0.12630	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
424	227	0.00053	0.00494	0.13870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
53	412	0.00028	0.00402	0.75080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
430	53	0.00012	0.00152	0.59840	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
431	26	0.00012	0.00189	0.07730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
431	432	0.00007	0.00103	0.04200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
431	369	0.00129	0.01755	1.00540	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
432	26	0.00006	0.00086	0.03530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	428	0.00019	0.00292	0.11920	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	428	0.00019	0.00292	0.11920	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	415	0.00172	0.01571	0.48110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	415	0.00172	0.01571	0.48110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
422	434	0.00043	0.00659	0.26890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
412	434	0.00039	0.00610	0.24880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
435	436	0.00043	0.00600	0.29660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
436	422	0.00047	0.00882	0.37210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
435	425	0.00039	0.00603	0.24610	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
421	425	0.00081	0.01204	0.54320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
431	368	0.00111	0.01554	0.93970	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
430	412	0.00016	0.00246	0.10030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	23	0.00046	0.00707	1.42230	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	23	0.00046	0.00707	1.42240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
425	437	0.00067	0.00711	0.23410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
87	437	0.00046	0.00496	0.16350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
425	427	0.00067	0.00711	0.23410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
87	427	0.00046	0.00496	0.16350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
415	369	0.00049	0.00522	0.17170	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
413	416	0.00038	0.00593	0.24030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
426	181	0.00209	0.01961	0.54810	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
419	437	0.00156	0.01465	0.40940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
438	425	0.00105	0.00988	0.27620	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
181	439	0.00104	0.00951	0.29140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
413	440	0.00027	0.00421	0.17050	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
440	415	0.00087	0.01351	1.31730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
439	227	0.00044	0.00403	0.12350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
438	227	0.00053	0.00494	0.13870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
431	347	0.00039	0.00604	0.24660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	441	0.00104	0.00953	0.29180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
433	442	0.00104	0.00953	0.29180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
431	390	0.00055	0.00849	0.34680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
443	444	0.00038	0.00414	0.04340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
445	446	0.00021	0.00187	0.80850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
445	446	0.00021	0.00185	0.79580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
445	447	0.00025	0.00382	0.03490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
448	447	0.00025	0.00382	0.03490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
72	447	0.00018	0.00279	0.02550	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
70	447	0.00018	0.00279	0.02550	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
66	449	0.00021	0.00321	0.02930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
68	450	0.00021	0.00321	0.02930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
451	452	0.00071	0.00665	0.04140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
453	454	0.00053	0.00479	0.07060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
451	452	0.00070	0.00661	0.04120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
451	455	0.00027	0.00298	1.25040	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
456	457	0.00077	0.00293	0.02060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
63	457	0.00077	0.00296	0.02950	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
458	459	0.00046	0.00448	0.05350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
460	454	0.00066	0.00598	0.05460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
460	454	0.00066	0.00601	0.06680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
453	454	0.00052	0.00477	0.05990	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
453	461	0.00120	0.01256	0.08880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
462	463	0.00068	0.00615	0.04190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
462	459	0.00047	0.00412	0.46620	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
458	459	0.00042	0.00396	0.03950	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
462	464	0.00089	0.00804	0.05480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
465	466	0.00087	0.00920	0.06780	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
467	468	0.00087	0.00922	0.06790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
448	466	0.00041	0.00430	0.03170	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
445	468	0.00041	0.00431	0.03180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
469	467	0.00002	0.00020	0.00140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
470	465	0.00000	0.00004	0.05910	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
471	472	0.00030	0.00285	0.01930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
473	474	0.00148	0.01379	0.06280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
475	472	0.00072	0.00686	0.04660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
473	476	0.00072	0.00682	0.04640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
476	477	0.00050	0.00469	0.03190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
471	477	0.00020	0.00178	0.01210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
478	477	0.00037	0.00339	0.02310	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
79	477	0.00221	0.02012	0.13590	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
479	478	0.00043	0.00387	0.02640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
473	480	0.00161	0.01403	0.14800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
480	474	0.00000	0.00001	0.00580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
481	479	0.00078	0.00703	0.04790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
482	483	0.00027	0.00245	0.01640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
484	474	0.00108	0.01549	0.12320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
485	484	0.00123	0.00860	0.05850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
486	474	0.00108	0.01547	0.11250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
487	482	0.00020	0.00037	0.11460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
488	482	0.00020	0.00037	0.11250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
79	489	0.00032	0.00342	0.02500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
490	486	0.00124	0.00864	0.05880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
58	491	0.00010	0.00161	0.02580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
492	60	0.00153	0.01765	0.13330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
493	491	0.00116	0.01800	0.16430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
494	495	0.00112	0.01026	0.16300	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
494	495	0.00112	0.01028	0.17390	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
496	495	0.00041	0.00377	0.02470	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
496	497	0.00143	0.00727	0.04970	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
144	498	0.00005	0.00044	0.01870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
144	499	0.00005	0.00044	0.01870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
500	501	0.00060	0.00228	0.01610	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
493	492	0.00076	0.00688	0.05550	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
502	503	0.00010	0.00159	0.01450	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
504	505	0.00015	0.00240	0.93570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
493	506	0.00086	0.00832	0.54240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
502	56	0.00001	0.00011	0.00100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
149	499	0.00004	0.00032	0.01790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
149	507	0.00004	0.00032	0.01790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
492	506	0.00162	0.01528	0.64290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
481	79	0.00063	0.00581	0.03820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
79	483	0.00063	0.00671	0.04890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
508	505	0.00098	0.00958	0.10150	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
56	505	0.00098	0.00957	0.09890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
491	509	0.00373	0.01704	0.10800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
510	511	0.00018	0.00132	0.30080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
508	60	0.00001	0.00016	0.02270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
510	512	0.00021	0.00144	0.32430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
513	514	0.00016	0.00092	0.24130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
511	515	0.00029	0.00173	0.45460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
511	514	0.00009	0.00059	0.16560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
497	515	0.00013	0.00119	0.00800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
516	509	0.00338	0.02203	0.11660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
516	503	0.00273	0.01717	0.10420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
497	513	0.00013	0.00119	0.00800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
497	517	0.00064	0.00569	0.16120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
497	518	0.00070	0.00586	0.24900	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
500	519	0.00014	0.00130	0.00890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
500	520	0.00014	0.00130	0.00890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
517	521	0.00011	0.00059	0.20130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
521	511	0.00046	0.00275	0.72550	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
490	489	0.00046	0.00496	0.03500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
518	512	0.00019	0.00112	0.29250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
479	485	0.00064	0.00982	0.13780	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
475	474	0.00148	0.01379	0.06280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
522	474	0.00492	0.03430	0.25020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
523	444	0.00352	0.02453	0.18980	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
475	523	0.00241	0.01947	0.14560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
524	501	0.00050	0.00189	0.01330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
524	495	0.00075	0.00687	0.04500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
492	463	0.00164	0.01606	0.11040	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
525	223	0.00002	0.00025	0.00220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
526	223	0.00061	0.00823	0.06700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
527	525	0.00059	0.00806	0.10760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
500	528	0.00050	0.00781	0.07130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
497	528	0.00051	0.00788	0.09510	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
528	529	0.00099	0.01532	0.13960	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
528	529	0.00099	0.01535	0.13990	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
529	524	0.00547	0.02084	0.14660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
530	531	0.00023	0.00363	0.03320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
532	531	0.00024	0.00367	0.03350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
533	532	0.00046	0.00708	0.06460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
534	535	0.00140	0.01427	0.10330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
534	532	0.00095	0.00952	0.10850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
532	536	0.00144	0.01360	0.12200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
536	537	0.00021	0.00194	0.04310	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
538	531	0.00021	0.00285	0.83880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
539	531	0.00021	0.00286	0.84460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
538	540	0.00078	0.01215	0.11090	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
539	541	0.00078	0.01214	0.11080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
542	541	0.00148	0.01571	0.11560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
543	544	0.00036	0.00331	0.08630	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
545	543	0.00109	0.00989	0.06750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
545	543	0.00123	0.01110	0.07580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
545	546	0.00121	0.01209	0.09930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
542	546	0.00081	0.00861	0.07690	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
545	535	0.00092	0.00912	0.06530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
542	547	0.00031	0.00332	0.48370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
548	547	0.00019	0.00173	0.01180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
534	533	0.00084	0.00760	0.05190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
543	536	0.00061	0.00552	0.06140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
534	533	0.00085	0.00777	0.05330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
533	549	0.00201	0.02418	0.24200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
550	551	0.00026	0.00238	0.01630	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
550	552	0.00034	0.00311	0.05450	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
553	551	0.00027	0.00244	0.01670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
553	554	0.00034	0.00308	0.06300	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
555	556	0.00027	0.00243	0.01660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
555	557	0.00034	0.00310	0.04620	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
558	556	0.00027	0.00243	0.01660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
558	559	0.00034	0.00314	0.06240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
560	559	0.00029	0.00360	1.77920	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
560	554	0.00030	0.00363	1.79440	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
561	562	0.00041	0.00436	0.03210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
562	552	0.00016	0.00201	1.10530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
563	564	0.00041	0.00436	0.03210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
564	557	0.00017	0.00213	1.29770	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
565	566	0.00025	0.00226	0.03910	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
567	568	0.00025	0.00231	0.05840	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
567	569	0.00241	0.02374	0.19700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
565	569	0.00241	0.02385	0.23280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
157	569	0.00061	0.00552	0.03770	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
160	569	0.00061	0.00552	0.03770	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
567	570	0.00055	0.00387	0.55710	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
567	571	0.00054	0.00386	0.55230	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
572	573	0.00060	0.00349	0.91190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
574	575	0.00060	0.00349	0.91190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
561	576	0.00074	0.00670	0.05790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
563	577	0.00073	0.00665	0.04500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
578	557	0.00026	0.00243	0.04770	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
578	579	0.00035	0.00326	0.02130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
580	552	0.00026	0.00243	0.04770	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
580	581	0.00035	0.00326	0.02130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
574	566	0.00067	0.00614	0.08840	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
574	568	0.00067	0.00615	0.09350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
561	5	0.00010	0.00111	0.04530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
563	8	0.00010	0.00111	0.04530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
582	583	0.00013	0.00163	0.80430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
584	583	0.00013	0.00163	0.80430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
572	585	0.00096	0.01021	0.11170	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
586	587	0.00064	0.00683	0.13730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
588	589	0.00029	0.00272	0.28380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
588	590	0.00028	0.00271	0.27910	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
591	592	0.00027	0.00309	1.36540	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
591	592	0.00027	0.00309	1.36540	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
592	593	0.00041	0.00473	2.09380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
594	595	0.00012	0.00139	0.61540	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
594	587	0.00053	0.00392	1.67600	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
594	587	0.00053	0.00392	1.67600	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
596	585	0.00051	0.00599	0.04460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
596	597	0.00051	0.00600	0.04470	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
598	596	0.00083	0.00748	0.06470	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
599	596	0.00083	0.00752	0.08020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
598	600	0.00040	0.00366	0.08530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
599	592	0.00041	0.00375	0.11760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
587	601	0.00031	0.00334	0.03740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
588	591	0.00043	0.00487	2.15320	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
588	591	0.00043	0.00498	2.20200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
602	577	0.00015	0.00150	0.40830	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
603	576	0.00015	0.00143	0.37750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
604	605	0.00032	0.00287	0.01950	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
606	607	0.00184	0.01715	0.11010	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
606	608	0.00186	0.01726	0.15870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
606	609	0.00364	0.01386	0.09750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
606	610	0.00364	0.01386	0.09750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1	611	0.00125	0.01133	0.07730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1	605	0.00124	0.01129	0.13550	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
612	611	0.00032	0.00284	0.01930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
613	614	0.00028	0.00259	0.03650	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1	614	0.00177	0.01398	0.09730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
615	616	0.00107	0.01000	0.04560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
207	617	0.00085	0.00773	0.10530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
207	613	0.00056	0.00511	0.08750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
618	614	0.00133	0.00924	0.06280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1	618	0.00044	0.00475	0.03450	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
615	618	0.00153	0.01425	0.06500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
619	620	0.00030	0.00280	0.01280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1	621	0.00256	0.02088	0.12270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
621	619	0.00115	0.00690	0.03800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
616	620	0.00030	0.00280	0.01280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
622	623	0.00083	0.00763	0.12460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
624	625	0.00083	0.00761	0.11700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
626	620	0.00062	0.00235	0.01650	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
627	620	0.00062	0.00235	0.01650	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
628	616	0.00002	0.00020	0.00090	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
629	630	0.00212	0.01950	0.00670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
631	630	0.00212	0.01950	0.00670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
477	632	0.00371	0.16663	-0.01502	9900.00	9900.00	9900.00	0.9682	0.00	1	-360.00	360.00;
477	632	0.00373	0.16663	-0.02826	9900.00	9900.00	9900.00	0.9685	0.00	1	-360.00	360.00;
477	632	0.00474	0.16243	-0.02611	9900.00	9900.00	9900.00	0.9720	0.00	1	-360.00	360.00;
483	633	0.00459	0.16619	-0.00445	9900.00	9900.00	9900.00	0.9829	0.00	1	-360.00	360.00;
488	634	0.00395	0.16562	-0.00831	9900.00	9900.00	9900.00	0.9866	0.00	1	-360.00	360.00;
487	634	0.00392	0.16512	-0.00817	9900.00	9900.00	9900.00	0.9865	0.00	1	-360.00	360.00;
479	635	0.00320	0.13329	-0.00503	9900.00	9900.00	9900.00	0.9663	0.00	1	-360.00	360.00;
479	635	0.00319	0.13163	-0.00493	9900.00	9900.00	9900.00	0.9665	0.00	1	-360.00	360.00;
481	636	0.00369	0.16996	-0.01474	9900.00	9900.00	9900.00	0.9699	0.00	1	-360.00	360.00;
481	636	0.00371	0.16746	-0.01217	9900.00	9900.00	9900.00	0.9703	0.00	1	-360.00	360.00;
483	633	0.00459	0.16583	-0.00736	9900.00	9900.00	9900.00	0.9829	0.00	1	-360.00	360.00;
58	637	0.00262	0.10830	-0.00586	9900.00	9900.00	9900.00	0.9907	0.00	1	-360.00	360.00;
56	637	0.00245	0.10886	-0.00706	9900.00	9900.00	9900.00	0.9829	0.00	1	-360.00	360.00;
494	638	0.00386	0.16083	-0.00736	9900.00	9900.00	9900.00	0.9266	0.00	1	-360.00	360.00;
494	638	0.00356	0.16204	-0.00694	9900.00	9900.00	9900.00	0.9234	0.00	1	-360.00	360.00;
332	639	0.00214	0.13482	-0.00540	9900.00	9900.00	9900.00	1.0500	0.00	1	-360.00	360.00;
332	639	0.00211	0.13565	-0.00434	9900.00	9900.00	9900.00	1.0500	0.00	1	-360.00	360.00;
501	640	0.00229	0.10331	-0.00238	9900.00	9900.00	9900.00	0.9285	0.00	1	-360.00	360.00;
501	640	0.00234	0.10220	-0.00227	9900.00	9900.00	9900.00	0.9293	0.00	1	-360.00	360.00;
535	641	0.00314	0.15833	-0.02396	9900.00	9900.00	9900.00	0.9421	0.00	1	-360.00	360.00;
535	641	0.00318	0.15747	-0.02924	9900.00	9900.00	9900.00	0.9426	0.00	1	-360.00	360.00;
572	642	0.00495	0.18180	-0.02680	9900.00	9900.00	9900.00	0.9596	0.00	1	-360.00	360.00;
572	643	0.00496	0.18160	-0.00736	9900.00	9900.00	9900.00	1.0882	0.00	1	-360.00	360.00;
574	642	0.00496	0.18160	-0.00736	9900.00	9900.00	9900.00	0.9762	0.00	1	-360.00	360.00;
572	642	0.00488	0.17920	-0.00736	9900.00	9900.00	9900.00	0.9596	0.00	1	-360.00	360.00;
578	644	0.00320	0.13329	-0.00461	9900.00	9900.00	9900.00	0.9581	0.00	1	-360.00	360.00;
580	644	0.00323	0.13474	-0.00507	9900.00	9900.00	9900.00	0.9603	0.00	1	-360.00	360.00;
594	645	0.00294	0.10996	-0.00395	9900.00	9900.00	9900.00	0.9633	0.00	1	-360.00	360.00;
594	645	0.00294	0.10663	-0.00312	9900.00	9900.00	9900.00	0.9665	0.00	1	-360.00	360.00;
594	645	0.00298	0.10996	-0.00319	9900.00	9900.00	9900.00	0.9648	0.00	1	-360.00	360.00;
594	646	0.00294	0.10896	-0.00287	9900.00	9900.00	9900.00	0.9990	0.00	1	-360.00	360.00;
583	647	0.00319	0.14552	-0.00521	9900.00	9900.00	9900.00	0.9600	0.00	1	-360.00	360.00;
583	647	0.00315	0.14274	-0.00500	9900.00	9900.00	9900.00	0.9606	0.00	1	-360.00	360.00;
583	647	0.00320	0.14330	-0.00583	9900.00	9900.00	9900.00	0.9615	0.00	1	-360.00	360.00;
591	648	0.00239	0.10803	-0.01945	9900.00	9900.00	9900.00	0.9517	0.00	1	-360.00	360.00;
591	649	0.00248	0.11497	-0.00395	9900.00	9900.00	9900.00	0.9508	0.00	1	-360.00	360.00;
591	649	0.00232	0.10836	-0.01388	9900.00	9900.00	9900.00	0.9503	0.00	1	-360.00	360.00;
591	648	0.00239	0.10831	-0.00395	9900.00	9900.00	9900.00	0.9517	0.00	1	-360.00	360.00;
613	650	0.00468	0.17861	-0.00484	9900.00	9900.00	9900.00	0.9457	0.00	1	-360.00	360.00;
613	650	0.00299	0.11213	-0.01247	9900.00	9900.00	9900.00	0.9465	0.00	1	-360.00	360.00;
651	310	0.00020	0.01604	0.08070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
452	309	0.00019	0.01597	0.03440	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
457	290	0.00022	0.01692	0.01633	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
457	290	0.00014	0.01665	-0.00737	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
458	287	0.00019	0.01597	-0.01612	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
458	295	0.00017	0.01597	-0.00574	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
444	280	0.00032	0.02440	0.01210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
522	280	0.00029	0.02402	-0.00589	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
444	280	0.00038	0.02340	-0.00927	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
522	280	0.00037	0.02434	-0.00925	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
464	297	0.00018	0.01615	-0.00270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
465	284	0.00019	0.01613	0.01621	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
460	301	0.00018	0.01608	-0.00251	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
460	301	0.00012	0.01600	-0.00561	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
461	313	0.00017	0.01560	-0.00807	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
60	328	0.00017	0.01608	-0.00282	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
58	328	0.00018	0.01507	0.03090	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
498	325	0.00017	0.01601	-0.00318	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
499	325	0.00012	0.01600	-0.00460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
494	315	0.00018	0.01627	-0.00846	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
494	315	0.00019	0.01605	-0.01728	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
652	326	0.00015	0.01610	0.01410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
500	326	0.00014	0.01677	-0.00614	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
453	337	0.00018	0.01593	-0.00463	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
493	338	0.00018	0.01588	-0.00494	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
474	339	0.00023	0.01646	-0.01830	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
653	341	0.00033	0.02380	-0.00340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
529	341	0.00019	0.01573	-0.00984	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
549	127	0.00015	0.01610	-0.00319	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
546	363	0.00013	0.01675	-0.00924	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
540	360	0.00021	0.01608	0.03130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
540	360	0.00020	0.01601	-0.00811	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
530	364	0.00018	0.01599	-0.01170	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
544	365	0.00017	0.01611	-0.00237	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
535	366	0.00023	0.01694	-0.00381	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
541	360	0.00017	0.01589	-0.00395	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
551	387	0.00022	0.01583	-0.01126	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
551	389	0.00022	0.01583	-0.00297	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
581	397	0.00023	0.02670	-0.00232	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
579	397	0.00023	0.02670	-0.00500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
574	380	0.00034	0.02400	-0.00340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
572	386	0.00033	0.02380	0.01290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
586	386	0.00033	0.02380	-0.00340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
561	396	0.00023	0.02670	0.00409	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
563	396	0.00023	0.02670	0.00409	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
654	44	0.00018	0.01600	-0.00948	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
654	44	0.00018	0.01604	-0.01203	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
598	411	0.00021	0.02593	-0.00300	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
597	441	0.00017	0.01603	-0.01024	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
597	441	0.00017	0.01593	-0.00841	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
585	442	0.00019	0.01627	-0.01350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
601	442	0.00020	0.01604	-0.01303	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
607	415	0.00018	0.01599	-0.00808	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
608	415	0.00021	0.01691	-0.02007	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
612	413	0.00017	0.01603	-0.00878	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
617	417	0.00022	0.01511	-0.01103	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
617	418	0.00020	0.01601	-0.00958	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
604	413	0.00017	0.01617	-0.00837	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
620	416	0.00018	0.01613	-0.01149	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
623	87	0.00036	0.02439	0.05900	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
625	87	0.00038	0.02433	0.05900	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
655	444	0.00345	0.12495	-0.00715	9900.00	9900.00	9900.00	0.9454	0.00	1	-360.00	360.00;
656	444	0.00337	0.11662	-0.01532	9900.00	9900.00	9900.00	0.9580	0.00	1	-360.00	360.00;
655	522	0.00345	0.12495	-0.00715	9900.00	9900.00	9900.00	0.9981	0.00	1	-360.00	360.00;
656	522	0.00287	0.12247	-0.00168	9900.00	9900.00	9900.00	0.9863	0.00	1	-360.00	360.00;
657	82	0.00163	0.08323	-0.00456	9900.00	9900.00	9900.00	1.0086	0.00	1	-360.00	360.00;
657	82	0.00122	0.08087	-0.00590	9900.00	9900.00	9900.00	1.0111	0.00	1	-360.00	360.00;
658	469	0.00105	0.08687	-0.00251	9900.00	9900.00	9900.00	0.9690	0.00	1	-360.00	360.00;
659	470	0.00159	0.08603	-0.00798	9900.00	9900.00	9900.00	0.9679	0.00	1	-360.00	360.00;
660	447	0.00194	0.08517	-0.00345	9900.00	9900.00	9900.00	1.0198	0.00	1	-360.00	360.00;
660	447	0.00189	0.08500	-0.00410	9900.00	9900.00	9900.00	1.0201	0.00	1	-360.00	360.00;
661	447	0.00190	0.08560	-0.00345	9900.00	9900.00	9900.00	1.0223	0.00	1	-360.00	360.00;
661	447	0.00189	0.08553	-0.00385	9900.00	9900.00	9900.00	1.0223	0.00	1	-360.00	360.00;
662	445	0.00159	0.08630	-0.00251	9900.00	9900.00	9900.00	1.0043	0.00	1	-360.00	360.00;
663	448	0.00169	0.08387	-0.00738	9900.00	9900.00	9900.00	0.9927	0.00	1	-360.00	360.00;
663	445	0.00168	0.08337	-0.00651	9900.00	9900.00	9900.00	0.9986	0.00	1	-360.00	360.00;
662	448	0.00132	0.08332	-0.00651	9900.00	9900.00	9900.00	0.9998	0.00	1	-360.00	360.00;
664	446	0.00112	0.08729	-0.00514	9900.00	9900.00	9900.00	1.0305	0.00	1	-360.00	360.00;
664	446	0.00181	0.08258	-0.00251	9900.00	9900.00	9900.00	1.0230	0.00	1	-360.00	360.00;
664	446	0.00178	0.08340	-0.00414	9900.00	9900.00	9900.00	1.0233	0.00	1	-360.00	360.00;
665	451	0.00186	0.08710	-0.00251	9900.00	9900.00	9900.00	1.0178	0.00	1	-360.00	360.00;
665	451	0.00186	0.08710	-0.00251	9900.00	9900.00	9900.00	1.0178	0.00	1	-360.00	360.00;
665	451	0.00186	0.08750	-0.00811	9900.00	9900.00	9900.00	1.0178	0.00	1	-360.00	360.00;
666	296	0.00054	0.04891	-0.00127	9900.00	9900.00	9900.00	1.0115	0.00	1	-360.00	360.00;
667	452	0.00189	0.08520	-0.00424	9900.00	9900.00	9900.00	1.0278	0.00	1	-360.00	360.00;
667	651	0.00196	0.08353	-0.01289	9900.00	9900.00	9900.00	1.0282	0.00	1	-360.00	360.00;
666	194	0.00054	0.04891	0.00000	9900.00	9900.00	9900.00	1.0121	0.00	1	-360.00	360.00;
667	452	0.00188	0.08476	-0.00377	9900.00	9900.00	9900.00	1.0278	0.00	1	-360.00	360.00;
668	168	0.00137	0.07874	-0.00317	9900.00	9900.00	9900.00	1.0354	0.00	1	-360.00	360.00;
668	168	0.00162	0.08319	-0.01631	9900.00	9900.00	9900.00	1.0331	0.00	1	-360.00	360.00;
669	282	0.00142	0.08320	-0.00534	9900.00	9900.00	9900.00	1.0622	0.00	1	-360.00	360.00;
670	282	0.00141	0.08290	-0.00478	9900.00	9900.00	9900.00	0.9793	0.00	1	-360.00	360.00;
671	457	0.00298	0.12405	-0.01109	9900.00	9900.00	9900.00	0.9069	0.00	1	-360.00	360.00;
671	457	0.00298	0.12246	-0.01758	9900.00	9900.00	9900.00	0.9068	0.00	1	-360.00	360.00;
672	454	0.00164	0.08057	-0.00643	9900.00	9900.00	9900.00	1.0099	0.00	1	-360.00	360.00;
673	454	0.00163	0.08044	-0.00647	9900.00	9900.00	9900.00	1.1183	0.00	1	-360.00	360.00;
673	454	0.00166	0.08120	-0.00808	9900.00	9900.00	9900.00	1.1182	0.00	1	-360.00	360.00;
674	460	0.00123	0.08350	-0.00593	9900.00	9900.00	9900.00	1.1172	0.00	1	-360.00	360.00;
675	460	0.00165	0.07998	-0.00541	9900.00	9900.00	9900.00	1.1110	0.00	1	-360.00	360.00;
675	460	0.00113	0.08645	-0.00952	9900.00	9900.00	9900.00	1.1224	0.00	1	-360.00	360.00;
674	460	0.00120	0.08310	-0.00671	9900.00	9900.00	9900.00	1.1178	0.00	1	-360.00	360.00;
676	283	0.00137	0.08324	-0.00220	9900.00	9900.00	9900.00	1.0624	0.00	1	-360.00	360.00;
676	283	0.00143	0.08357	-0.00261	9900.00	9900.00	9900.00	1.0614	0.00	1	-360.00	360.00;
677	459	0.00175	0.08350	-0.00582	9900.00	9900.00	9900.00	1.1267	0.00	1	-360.00	360.00;
677	459	0.00179	0.08270	-0.00423	9900.00	9900.00	9900.00	1.1256	0.00	1	-360.00	360.00;
678	462	0.00116	0.08280	-0.00502	9900.00	9900.00	9900.00	1.0922	0.00	1	-360.00	360.00;
679	459	0.00105	0.08208	-0.00251	9900.00	9900.00	9900.00	0.9984	0.00	1	-360.00	360.00;
678	462	0.00121	0.08441	-0.00501	9900.00	9900.00	9900.00	1.0918	0.00	1	-360.00	360.00;
678	462	0.00125	0.08312	-0.00605	9900.00	9900.00	9900.00	1.0910	0.00	1	-360.00	360.00;
680	461	0.00189	0.07998	-0.00345	9900.00	9900.00	9900.00	1.0992	0.00	1	-360.00	360.00;
680	463	0.00175	0.08580	-0.01180	9900.00	9900.00	9900.00	1.0820	0.00	1	-360.00	360.00;
680	463	0.00175	0.08554	-0.00964	9900.00	9900.00	9900.00	1.0819	0.00	1	-360.00	360.00;
680	461	0.00173	0.08709	-0.01065	9900.00	9900.00	9900.00	1.1035	0.00	1	-360.00	360.00;
681	458	0.00286	0.12330	-0.01519	9900.00	9900.00	9900.00	1.0292	0.00	1	-360.00	360.00;
682	458	0.00190	0.08530	-0.00382	9900.00	9900.00	9900.00	1.0617	0.00	1	-360.00	360.00;
681	458	0.00291	0.12213	-0.01547	9900.00	9900.00	9900.00	1.0291	0.00	1	-360.00	360.00;
682	458	0.00175	0.08390	-0.00778	9900.00	9900.00	9900.00	1.0624	0.00	1	-360.00	360.00;
683	72	0.00284	0.12305	-0.01974	9900.00	9900.00	9900.00	0.9652	0.00	1	-360.00	360.00;
684	66	0.00285	0.12247	-0.00345	9900.00	9900.00	9900.00	1.0029	0.00	1	-360.00	360.00;
685	66	0.00159	0.08333	-0.00251	9900.00	9900.00	9900.00	1.0529	0.00	1	-360.00	360.00;
686	68	0.00139	0.08390	-0.00409	9900.00	9900.00	9900.00	1.0468	0.00	1	-360.00	360.00;
687	474	0.00330	0.11454	-0.01288	9900.00	9900.00	9900.00	1.0449	0.00	1	-360.00	360.00;
687	474	0.00333	0.11662	-0.01540	9900.00	9900.00	9900.00	1.0451	0.00	1	-360.00	360.00;
687	474	0.00339	0.11912	-0.01350	9900.00	9900.00	9900.00	1.0451	0.00	1	-360.00	360.00;
688	474	0.00333	0.11662	-0.01924	9900.00	9900.00	9900.00	1.0507	0.00	1	-360.00	360.00;
688	474	0.00339	0.11662	-0.01902	9900.00	9900.00	9900.00	1.0504	0.00	1	-360.00	360.00;
689	317	0.00165	0.08328	-0.00831	9900.00	9900.00	9900.00	1.0263	0.00	1	-360.00	360.00;
689	317	0.00164	0.08357	-0.00845	9900.00	9900.00	9900.00	1.0265	0.00	1	-360.00	360.00;
690	484	0.00158	0.08457	-0.00449	9900.00	9900.00	9900.00	1.0379	0.00	1	-360.00	360.00;
690	484	0.00159	0.08457	-0.00440	9900.00	9900.00	9900.00	1.0378	0.00	1	-360.00	360.00;
690	486	0.00178	0.08290	-0.00514	9900.00	9900.00	9900.00	1.0389	0.00	1	-360.00	360.00;
691	489	0.00186	0.08333	-0.00251	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
691	489	0.00186	0.08333	-0.00251	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
692	58	0.00373	0.11566	-0.00715	9900.00	9900.00	9900.00	0.9556	0.00	1	-360.00	360.00;
693	506	0.00186	0.08040	-0.00251	9900.00	9900.00	9900.00	1.0569	0.00	1	-360.00	360.00;
694	492	0.00169	0.08446	-0.00803	9900.00	9900.00	9900.00	1.0598	0.00	1	-360.00	360.00;
695	492	0.00171	0.08259	-0.00335	9900.00	9900.00	9900.00	1.0644	0.00	1	-360.00	360.00;
694	492	0.00167	0.08610	-0.00706	9900.00	9900.00	9900.00	1.0602	0.00	1	-360.00	360.00;
695	492	0.00172	0.08387	-0.00660	9900.00	9900.00	9900.00	1.0646	0.00	1	-360.00	360.00;
696	493	0.00164	0.08186	-0.00428	9900.00	9900.00	9900.00	1.0735	0.00	1	-360.00	360.00;
697	493	0.00164	0.08269	-0.00464	9900.00	9900.00	9900.00	1.0682	0.00	1	-360.00	360.00;
696	493	0.00168	0.08311	-0.00436	9900.00	9900.00	9900.00	1.0733	0.00	1	-360.00	360.00;
697	493	0.00172	0.08248	-0.00517	9900.00	9900.00	9900.00	1.0672	0.00	1	-360.00	360.00;
698	319	0.00145	0.08334	-0.00317	9900.00	9900.00	9900.00	1.0395	0.00	1	-360.00	360.00;
699	319	0.00147	0.08332	-0.00317	9900.00	9900.00	9900.00	1.0416	0.00	1	-360.00	360.00;
698	319	0.00146	0.08249	-0.00317	9900.00	9900.00	9900.00	1.0390	0.00	1	-360.00	360.00;
699	319	0.00148	0.08374	-0.00317	9900.00	9900.00	9900.00	1.0415	0.00	1	-360.00	360.00;
700	318	0.00130	0.08453	-0.01458	9900.00	9900.00	9900.00	1.0313	0.00	1	-360.00	360.00;
700	318	0.00147	0.08249	-0.00253	9900.00	9900.00	9900.00	1.0246	0.00	1	-360.00	360.00;
701	36	0.00161	0.08499	-0.00372	9900.00	9900.00	9900.00	1.0521	0.00	1	-360.00	360.00;
702	36	0.00161	0.08336	-0.00711	9900.00	9900.00	9900.00	0.9834	0.00	1	-360.00	360.00;
703	495	0.00292	0.13460	-0.01159	9900.00	9900.00	9900.00	1.0885	0.00	1	-360.00	360.00;
704	495	0.00155	0.07848	-0.00511	9900.00	9900.00	9900.00	1.0717	0.00	1	-360.00	360.00;
704	495	0.00149	0.08221	-0.01498	9900.00	9900.00	9900.00	1.0742	0.00	1	-360.00	360.00;
703	495	0.00292	0.13480	-0.01098	9900.00	9900.00	9900.00	1.0885	0.00	1	-360.00	360.00;
704	495	0.00148	0.08165	-0.01467	9900.00	9900.00	9900.00	1.0742	0.00	1	-360.00	360.00;
703	495	0.00289	0.13497	-0.01458	9900.00	9900.00	9900.00	1.0889	0.00	1	-360.00	360.00;
703	495	0.00291	0.13414	-0.01319	9900.00	9900.00	9900.00	1.0885	0.00	1	-360.00	360.00;
700	316	0.00110	0.08328	-0.00230	9900.00	9900.00	9900.00	0.9930	0.00	1	-360.00	360.00;
705	508	0.00285	0.12500	-0.00715	9900.00	9900.00	9900.00	1.0123	0.00	1	-360.00	360.00;
706	502	0.00092	0.08754	-0.00188	9900.00	9900.00	9900.00	1.0297	0.00	1	-360.00	360.00;
707	528	0.00093	0.08754	-0.00189	9900.00	9900.00	9900.00	1.0883	0.00	1	-360.00	360.00;
708	528	0.00187	0.08731	-0.00251	9900.00	9900.00	9900.00	1.0776	0.00	1	-360.00	360.00;
707	528	0.00149	0.07628	-0.01154	9900.00	9900.00	9900.00	1.0742	0.00	1	-360.00	360.00;
708	528	0.00143	0.07628	-0.00763	9900.00	9900.00	9900.00	1.0810	0.00	1	-360.00	360.00;
709	347	0.00166	0.08648	-0.01109	9900.00	9900.00	9900.00	0.9840	0.00	1	-360.00	360.00;
710	347	0.00172	0.08332	-0.00317	9900.00	9900.00	9900.00	1.0581	0.00	1	-360.00	360.00;
710	347	0.00139	0.08332	-0.01066	9900.00	9900.00	9900.00	1.0653	0.00	1	-360.00	360.00;
710	347	0.00119	0.08174	-0.00292	9900.00	9900.00	9900.00	1.0703	0.00	1	-360.00	360.00;
711	345	0.00170	0.08383	-0.00317	9900.00	9900.00	9900.00	1.0624	0.00	1	-360.00	360.00;
711	345	0.00164	0.08415	-0.00463	9900.00	9900.00	9900.00	1.0634	0.00	1	-360.00	360.00;
711	345	0.00109	0.08341	-0.00225	9900.00	9900.00	9900.00	1.0741	0.00	1	-360.00	360.00;
712	343	0.00159	0.08374	-0.00246	9900.00	9900.00	9900.00	1.0486	0.00	1	-360.00	360.00;
713	343	0.00159	0.07965	-0.00786	9900.00	9900.00	9900.00	1.0325	0.00	1	-360.00	360.00;
713	343	0.00158	0.08353	-0.01001	9900.00	9900.00	9900.00	1.0345	0.00	1	-360.00	360.00;
712	343	0.00159	0.08249	-0.00918	9900.00	9900.00	9900.00	1.0480	0.00	1	-360.00	360.00;
714	127	0.00123	0.07970	-0.00647	9900.00	9900.00	9900.00	0.9813	0.00	1	-360.00	360.00;
715	130	0.00158	0.07915	-0.00638	9900.00	9900.00	9900.00	1.0853	0.00	1	-360.00	360.00;
715	130	0.00183	0.07881	-0.00223	9900.00	9900.00	9900.00	1.0800	0.00	1	-360.00	360.00;
715	130	0.00102	0.07958	-0.00317	9900.00	9900.00	9900.00	1.1021	0.00	1	-360.00	360.00;
716	344	0.00103	0.07916	-0.00317	9900.00	9900.00	9900.00	1.0507	0.00	1	-360.00	360.00;
716	344	0.00103	0.07916	-0.00917	9900.00	9900.00	9900.00	1.0507	0.00	1	-360.00	360.00;
717	534	0.00168	0.08540	-0.00251	9900.00	9900.00	9900.00	1.0803	0.00	1	-360.00	360.00;
717	534	0.00186	0.08330	-0.00251	9900.00	9900.00	9900.00	1.0779	0.00	1	-360.00	360.00;
717	534	0.00139	0.08540	-0.00409	9900.00	9900.00	9900.00	1.0840	0.00	1	-360.00	360.00;
718	545	0.00162	0.08111	-0.00361	9900.00	9900.00	9900.00	1.0825	0.00	1	-360.00	360.00;
718	545	0.00164	0.08057	-0.00696	9900.00	9900.00	9900.00	1.0821	0.00	1	-360.00	360.00;
718	545	0.00159	0.08023	-0.00564	9900.00	9900.00	9900.00	1.0827	0.00	1	-360.00	360.00;
719	542	0.00160	0.07602	-0.00412	9900.00	9900.00	9900.00	1.0575	0.00	1	-360.00	360.00;
719	542	0.00153	0.07748	-0.00251	9900.00	9900.00	9900.00	1.0585	0.00	1	-360.00	360.00;
719	542	0.00105	0.08845	-0.00150	9900.00	9900.00	9900.00	1.0677	0.00	1	-360.00	360.00;
720	537	0.00151	0.08832	-0.00644	9900.00	9900.00	9900.00	1.0753	0.00	1	-360.00	360.00;
721	538	0.00161	0.08123	-0.00735	9900.00	9900.00	9900.00	1.1124	0.00	1	-360.00	360.00;
721	538	0.00159	0.08165	-0.00682	9900.00	9900.00	9900.00	1.1131	0.00	1	-360.00	360.00;
722	538	0.00172	0.08582	-0.00249	9900.00	9900.00	9900.00	0.9857	0.00	1	-360.00	360.00;
721	539	0.00166	0.08248	-0.00406	9900.00	9900.00	9900.00	1.1170	0.00	1	-360.00	360.00;
723	359	0.00167	0.08294	-0.00919	9900.00	9900.00	9900.00	1.0394	0.00	1	-360.00	360.00;
724	359	0.00155	0.08449	-0.00317	9900.00	9900.00	9900.00	1.0486	0.00	1	-360.00	360.00;
724	359	0.00155	0.08449	-0.00846	9900.00	9900.00	9900.00	1.0487	0.00	1	-360.00	360.00;
724	359	0.00137	0.08316	-0.00208	9900.00	9900.00	9900.00	1.0503	0.00	1	-360.00	360.00;
725	533	0.00151	0.08624	-0.00602	9900.00	9900.00	9900.00	1.1107	0.00	1	-360.00	360.00;
725	533	0.00152	0.08540	-0.00601	9900.00	9900.00	9900.00	1.1102	0.00	1	-360.00	360.00;
725	533	0.00134	0.08457	-0.00543	9900.00	9900.00	9900.00	1.1139	0.00	1	-360.00	360.00;
726	533	0.00177	0.08323	-0.00423	9900.00	9900.00	9900.00	0.9881	0.00	1	-360.00	360.00;
727	541	0.00379	0.12052	-0.00299	9900.00	9900.00	9900.00	1.0496	0.00	1	-360.00	360.00;
727	540	0.00378	0.11927	-0.00811	9900.00	9900.00	9900.00	1.0470	0.00	1	-360.00	360.00;
727	541	0.00301	0.13830	-0.01242	9900.00	9900.00	9900.00	1.0578	0.00	1	-360.00	360.00;
728	364	0.00109	0.08408	-0.00142	9900.00	9900.00	9900.00	1.0479	0.00	1	-360.00	360.00;
728	364	0.00104	0.08416	-0.00138	9900.00	9900.00	9900.00	1.0487	0.00	1	-360.00	360.00;
729	90	0.00158	0.08353	-0.01135	9900.00	9900.00	9900.00	1.0389	0.00	1	-360.00	360.00;
730	90	0.00160	0.08353	-0.00956	9900.00	9900.00	9900.00	1.0361	0.00	1	-360.00	360.00;
731	543	0.00160	0.08103	-0.00890	9900.00	9900.00	9900.00	1.0571	0.00	1	-360.00	360.00;
731	543	0.00160	0.08103	-0.00687	9900.00	9900.00	9900.00	1.0570	0.00	1	-360.00	360.00;
731	543	0.00160	0.08103	-0.00827	9900.00	9900.00	9900.00	1.0571	0.00	1	-360.00	360.00;
732	543	0.00158	0.08186	-0.00681	9900.00	9900.00	9900.00	0.9817	0.00	1	-360.00	360.00;
733	531	0.00141	0.08541	-0.00501	9900.00	9900.00	9900.00	1.0467	0.00	1	-360.00	360.00;
734	531	0.00144	0.08665	-0.00573	9900.00	9900.00	9900.00	1.0518	0.00	1	-360.00	360.00;
733	531	0.00153	0.08415	-0.00660	9900.00	9900.00	9900.00	1.0461	0.00	1	-360.00	360.00;
734	531	0.00154	0.08582	-0.00566	9900.00	9900.00	9900.00	1.0511	0.00	1	-360.00	360.00;
735	536	0.00188	0.08137	-0.00457	9900.00	9900.00	9900.00	1.0462	0.00	1	-360.00	360.00;
735	536	0.00184	0.08087	-0.00514	9900.00	9900.00	9900.00	1.0463	0.00	1	-360.00	360.00;
736	536	0.00179	0.07809	-0.01294	9900.00	9900.00	9900.00	0.9829	0.00	1	-360.00	360.00;
737	544	0.00143	0.08707	-0.00251	9900.00	9900.00	9900.00	1.0308	0.00	1	-360.00	360.00;
737	544	0.00186	0.08706	-0.00251	9900.00	9900.00	9900.00	1.0298	0.00	1	-360.00	360.00;
738	546	0.00182	0.08708	0.00000	9900.00	9900.00	9900.00	1.0585	0.00	1	-360.00	360.00;
738	546	0.00154	0.08588	-0.00425	9900.00	9900.00	9900.00	1.0617	0.00	1	-360.00	360.00;
739	546	0.00150	0.08478	-0.00539	9900.00	9900.00	9900.00	0.9739	0.00	1	-360.00	360.00;
738	546	0.00154	0.08624	-0.00652	9900.00	9900.00	9900.00	1.0619	0.00	1	-360.00	360.00;
740	133	0.00109	0.08208	-0.00317	9900.00	9900.00	9900.00	1.0283	0.00	1	-360.00	360.00;
740	133	0.00115	0.08170	-0.00183	9900.00	9900.00	9900.00	1.0272	0.00	1	-360.00	360.00;
741	385	0.00149	0.08332	-0.00582	9900.00	9900.00	9900.00	1.0516	0.00	1	-360.00	360.00;
741	379	0.00149	0.08332	-0.00489	9900.00	9900.00	9900.00	1.0128	0.00	1	-360.00	360.00;
742	561	0.00126	0.08666	-0.00075	9900.00	9900.00	9900.00	1.0513	0.00	1	-360.00	360.00;
743	563	0.00184	0.08109	-0.00375	9900.00	9900.00	9900.00	0.9598	0.00	1	-360.00	360.00;
742	561	0.00125	0.08666	-0.00083	9900.00	9900.00	9900.00	1.0515	0.00	1	-360.00	360.00;
744	563	0.00187	0.08109	-0.00378	9900.00	9900.00	9900.00	0.9598	0.00	1	-360.00	360.00;
745	392	0.00166	0.08348	-0.00977	9900.00	9900.00	9900.00	1.0983	0.00	1	-360.00	360.00;
745	392	0.00165	0.08328	-0.01113	9900.00	9900.00	9900.00	1.0985	0.00	1	-360.00	360.00;
745	392	0.00159	0.08424	-0.01059	9900.00	9900.00	9900.00	1.1008	0.00	1	-360.00	360.00;
745	392	0.00160	0.08403	-0.01136	9900.00	9900.00	9900.00	1.1004	0.00	1	-360.00	360.00;
746	558	0.00161	0.08186	-0.00666	9900.00	9900.00	9900.00	0.9574	0.00	1	-360.00	360.00;
747	373	0.00163	0.08115	-0.01393	9900.00	9900.00	9900.00	1.0467	0.00	1	-360.00	360.00;
747	373	0.00146	0.08204	-0.01259	9900.00	9900.00	9900.00	1.0503	0.00	1	-360.00	360.00;
748	391	0.00142	0.08274	-0.00216	9900.00	9900.00	9900.00	1.0570	0.00	1	-360.00	360.00;
749	354	0.00104	0.07958	-0.00317	9900.00	9900.00	9900.00	1.0559	0.00	1	-360.00	360.00;
750	565	0.00192	0.08081	-0.00986	9900.00	9900.00	9900.00	1.0353	0.00	1	-360.00	360.00;
750	565	0.00103	0.08105	-0.00169	9900.00	9900.00	9900.00	1.0570	0.00	1	-360.00	360.00;
751	567	0.00199	0.08120	-0.00972	9900.00	9900.00	9900.00	0.9442	0.00	1	-360.00	360.00;
751	567	0.00182	0.08220	-0.01125	9900.00	9900.00	9900.00	0.9467	0.00	1	-360.00	360.00;
752	567	0.00359	0.11278	-0.01605	9900.00	9900.00	9900.00	0.9892	0.00	1	-360.00	360.00;
753	565	0.00345	0.11161	-0.01407	9900.00	9900.00	9900.00	0.9907	0.00	1	-360.00	360.00;
754	571	0.00193	0.08376	-0.00639	9900.00	9900.00	9900.00	1.0228	0.00	1	-360.00	360.00;
755	571	0.00110	0.08674	-0.00789	9900.00	9900.00	9900.00	1.0244	0.00	1	-360.00	360.00;
755	570	0.00113	0.08691	-0.00839	9900.00	9900.00	9900.00	1.0240	0.00	1	-360.00	360.00;
754	570	0.00193	0.08342	-0.00770	9900.00	9900.00	9900.00	1.0228	0.00	1	-360.00	360.00;
756	374	0.00179	0.08623	-0.00352	9900.00	9900.00	9900.00	1.0528	0.00	1	-360.00	360.00;
757	374	0.00177	0.08665	-0.00386	9900.00	9900.00	9900.00	1.0534	0.00	1	-360.00	360.00;
758	393	0.00174	0.07736	-0.00913	9900.00	9900.00	9900.00	1.0585	0.00	1	-360.00	360.00;
759	393	0.00174	0.07769	-0.00622	9900.00	9900.00	9900.00	1.0594	0.00	1	-360.00	360.00;
760	393	0.00165	0.07902	-0.00868	9900.00	9900.00	9900.00	1.0617	0.00	1	-360.00	360.00;
761	136	0.00170	0.08773	-0.01152	9900.00	9900.00	9900.00	1.0868	0.00	1	-360.00	360.00;
762	352	0.00157	0.08207	-0.01180	9900.00	9900.00	9900.00	1.0583	0.00	1	-360.00	360.00;
763	352	0.00168	0.08127	-0.01370	9900.00	9900.00	9900.00	1.0559	0.00	1	-360.00	360.00;
763	353	0.00162	0.08132	-0.01045	9900.00	9900.00	9900.00	1.0633	0.00	1	-360.00	360.00;
762	353	0.00169	0.08244	-0.01056	9900.00	9900.00	9900.00	1.0622	0.00	1	-360.00	360.00;
764	160	0.00391	0.12952	-0.00599	9900.00	9900.00	9900.00	1.0229	0.00	1	-360.00	360.00;
765	157	0.00368	0.13120	-0.00582	9900.00	9900.00	9900.00	1.0135	0.00	1	-360.00	360.00;
766	160	0.00365	0.12678	-0.00566	9900.00	9900.00	9900.00	0.9703	0.00	1	-360.00	360.00;
767	157	0.00376	0.12828	-0.00616	9900.00	9900.00	9900.00	0.9716	0.00	1	-360.00	360.00;
768	552	0.00160	0.08248	-0.00705	9900.00	9900.00	9900.00	1.0294	0.00	1	-360.00	360.00;
768	557	0.00193	0.08303	-0.00868	9900.00	9900.00	9900.00	1.0266	0.00	1	-360.00	360.00;
769	559	0.00113	0.08703	-0.00840	9900.00	9900.00	9900.00	1.0254	0.00	1	-360.00	360.00;
769	554	0.00110	0.08633	-0.00817	9900.00	9900.00	9900.00	1.0260	0.00	1	-360.00	360.00;
770	358	0.00147	0.08332	-0.00263	9900.00	9900.00	9900.00	1.0133	0.00	1	-360.00	360.00;
771	569	0.00112	0.08653	-0.00574	9900.00	9900.00	9900.00	1.0368	0.00	1	-360.00	360.00;
772	569	0.00111	0.08653	-0.00663	9900.00	9900.00	9900.00	0.9587	0.00	1	-360.00	360.00;
771	569	0.00123	0.08516	-0.00544	9900.00	9900.00	9900.00	1.0343	0.00	1	-360.00	360.00;
773	566	0.00134	0.08457	-0.00454	9900.00	9900.00	9900.00	0.9580	0.00	1	-360.00	360.00;
774	566	0.00192	0.08220	-0.00919	9900.00	9900.00	9900.00	1.0354	0.00	1	-360.00	360.00;
774	568	0.00131	0.08057	-0.00494	9900.00	9900.00	9900.00	1.0221	0.00	1	-360.00	360.00;
775	568	0.00364	0.11211	-0.01699	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
775	568	0.00357	0.11153	-0.01506	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
776	372	0.00162	0.08148	-0.00791	9900.00	9900.00	9900.00	1.0361	0.00	1	-360.00	360.00;
776	372	0.00163	0.08332	-0.00801	9900.00	9900.00	9900.00	1.0364	0.00	1	-360.00	360.00;
777	141	0.00104	0.07958	-0.01360	9900.00	9900.00	9900.00	0.9804	0.00	1	-360.00	360.00;
778	141	0.00104	0.07958	-0.00317	9900.00	9900.00	9900.00	0.9803	0.00	1	-360.00	360.00;
778	141	0.00104	0.07958	-0.00244	9900.00	9900.00	9900.00	0.9803	0.00	1	-360.00	360.00;
777	141	0.00104	0.07958	-0.00317	9900.00	9900.00	9900.00	0.9804	0.00	1	-360.00	360.00;
779	598	0.00166	0.07983	-0.00615	9900.00	9900.00	9900.00	1.0717	0.00	1	-360.00	360.00;
780	599	0.00165	0.08042	-0.00498	9900.00	9900.00	9900.00	1.1322	0.00	1	-360.00	360.00;
779	599	0.00166	0.08050	-0.00605	9900.00	9900.00	9900.00	1.1310	0.00	1	-360.00	360.00;
780	598	0.00168	0.07979	-0.00581	9900.00	9900.00	9900.00	1.0722	0.00	1	-360.00	360.00;
781	598	0.00306	0.13021	-0.01756	9900.00	9900.00	9900.00	1.0813	0.00	1	-360.00	360.00;
782	599	0.00313	0.13046	-0.01469	9900.00	9900.00	9900.00	1.0692	0.00	1	-360.00	360.00;
783	406	0.00126	0.08445	-0.00317	9900.00	9900.00	9900.00	1.0854	0.00	1	-360.00	360.00;
784	406	0.00155	0.08165	-0.01043	9900.00	9900.00	9900.00	1.0690	0.00	1	-360.00	360.00;
785	407	0.00162	0.08313	-0.00661	9900.00	9900.00	9900.00	1.0435	0.00	1	-360.00	360.00;
786	407	0.00166	0.08403	-0.00774	9900.00	9900.00	9900.00	1.0442	0.00	1	-360.00	360.00;
787	596	0.00166	0.08000	-0.00445	9900.00	9900.00	9900.00	1.0811	0.00	1	-360.00	360.00;
787	596	0.00146	0.08625	-0.00251	9900.00	9900.00	9900.00	1.0893	0.00	1	-360.00	360.00;
788	596	0.00312	0.12163	-0.00542	9900.00	9900.00	9900.00	1.0510	0.00	1	-360.00	360.00;
789	596	0.00310	0.12246	-0.00631	9900.00	9900.00	9900.00	1.0511	0.00	1	-360.00	360.00;
790	588	0.00137	0.08396	-0.00398	9900.00	9900.00	9900.00	0.9267	0.00	1	-360.00	360.00;
791	588	0.00114	0.08450	-0.00431	9900.00	9900.00	9900.00	0.9267	0.00	1	-360.00	360.00;
792	588	0.00110	0.08442	-0.00439	9900.00	9900.00	9900.00	0.9269	0.00	1	-360.00	360.00;
793	401	0.00147	0.08333	-0.00388	9900.00	9900.00	9900.00	0.9785	0.00	1	-360.00	360.00;
794	401	0.00164	0.08311	-0.00317	9900.00	9900.00	9900.00	1.0365	0.00	1	-360.00	360.00;
795	401	0.00115	0.08149	-0.00186	9900.00	9900.00	9900.00	1.0354	0.00	1	-360.00	360.00;
796	119	0.00165	0.08125	-0.00287	9900.00	9900.00	9900.00	0.9813	0.00	1	-360.00	360.00;
797	119	0.00100	0.07999	-0.01063	9900.00	9900.00	9900.00	1.0280	0.00	1	-360.00	360.00;
798	119	0.00104	0.07958	-0.00949	9900.00	9900.00	9900.00	1.0273	0.00	1	-360.00	360.00;
799	405	0.00164	0.08311	-0.01144	9900.00	9900.00	9900.00	1.0488	0.00	1	-360.00	360.00;
799	405	0.00149	0.08124	-0.01863	9900.00	9900.00	9900.00	1.0517	0.00	1	-360.00	360.00;
800	405	0.00164	0.08311	-0.00817	9900.00	9900.00	9900.00	1.0416	0.00	1	-360.00	360.00;
801	408	0.00103	0.07958	-0.00317	9900.00	9900.00	9900.00	1.0442	0.00	1	-360.00	360.00;
802	408	0.00148	0.08249	-0.00269	9900.00	9900.00	9900.00	1.0403	0.00	1	-360.00	360.00;
803	408	0.00100	0.08174	-0.00317	9900.00	9900.00	9900.00	1.0070	0.00	1	-360.00	360.00;
803	408	0.00097	0.08229	-0.00317	9900.00	9900.00	9900.00	1.0073	0.00	1	-360.00	360.00;
804	592	0.00167	0.08112	-0.00457	9900.00	9900.00	9900.00	0.9396	0.00	1	-360.00	360.00;
805	592	0.00167	0.08042	-0.00444	9900.00	9900.00	9900.00	0.9939	0.00	1	-360.00	360.00;
804	592	0.00188	0.07917	-0.00365	9900.00	9900.00	9900.00	0.9359	0.00	1	-360.00	360.00;
805	592	0.00187	0.07967	-0.00381	9900.00	9900.00	9900.00	0.9905	0.00	1	-360.00	360.00;
806	592	0.00193	0.08311	-0.00922	9900.00	9900.00	9900.00	0.9399	0.00	1	-360.00	360.00;
807	592	0.00193	0.08317	-0.00908	9900.00	9900.00	9900.00	0.9400	0.00	1	-360.00	360.00;
266	583	0.00167	0.08040	-0.00525	9900.00	9900.00	9900.00	0.9195	0.00	1	-360.00	360.00;
266	583	0.00183	0.08144	-0.00313	9900.00	9900.00	9900.00	0.9170	0.00	1	-360.00	360.00;
266	583	0.00167	0.08019	-0.00276	9900.00	9900.00	9900.00	0.9195	0.00	1	-360.00	360.00;
808	585	0.00310	0.13208	-0.02156	9900.00	9900.00	9900.00	1.0399	0.00	1	-360.00	360.00;
809	585	0.00192	0.08111	-0.00531	9900.00	9900.00	9900.00	0.9777	0.00	1	-360.00	360.00;
810	597	0.00118	0.08450	-0.00379	9900.00	9900.00	9900.00	1.0831	0.00	1	-360.00	360.00;
808	585	0.00304	0.13091	-0.02211	9900.00	9900.00	9900.00	1.0400	0.00	1	-360.00	360.00;
811	585	0.00194	0.08087	-0.00624	9900.00	9900.00	9900.00	0.9777	0.00	1	-360.00	360.00;
810	585	0.00122	0.08462	-0.00374	9900.00	9900.00	9900.00	1.1406	0.00	1	-360.00	360.00;
812	412	0.00178	0.07998	-0.00579	9900.00	9900.00	9900.00	1.0931	0.00	1	-360.00	360.00;
813	412	0.00185	0.08040	-0.00707	9900.00	9900.00	9900.00	1.0680	0.00	1	-360.00	360.00;
812	412	0.00182	0.08010	-0.00648	9900.00	9900.00	9900.00	1.0923	0.00	1	-360.00	360.00;
813	412	0.00176	0.08019	-0.00671	9900.00	9900.00	9900.00	1.0692	0.00	1	-360.00	360.00;
814	429	0.00145	0.08336	-0.00587	9900.00	9900.00	9900.00	1.0607	0.00	1	-360.00	360.00;
814	429	0.00144	0.08320	-0.00569	9900.00	9900.00	9900.00	1.0608	0.00	1	-360.00	360.00;
814	434	0.00100	0.07916	-0.01049	9900.00	9900.00	9900.00	1.0846	0.00	1	-360.00	360.00;
815	433	0.00147	0.08332	-0.00465	9900.00	9900.00	9900.00	1.0794	0.00	1	-360.00	360.00;
816	433	0.00146	0.08332	-0.00494	9900.00	9900.00	9900.00	1.0794	0.00	1	-360.00	360.00;
817	431	0.00184	0.07956	-0.00685	9900.00	9900.00	9900.00	1.0412	0.00	1	-360.00	360.00;
817	431	0.00185	0.08019	-0.00639	9900.00	9900.00	9900.00	1.0413	0.00	1	-360.00	360.00;
817	431	0.00184	0.08060	-0.00573	9900.00	9900.00	9900.00	1.0416	0.00	1	-360.00	360.00;
817	431	0.00185	0.08081	-0.00668	9900.00	9900.00	9900.00	1.0415	0.00	1	-360.00	360.00;
245	53	0.00151	0.07894	-0.01162	9900.00	9900.00	9900.00	1.0587	0.00	1	-360.00	360.00;
245	53	0.00151	0.07707	-0.01243	9900.00	9900.00	9900.00	1.0579	0.00	1	-360.00	360.00;
818	422	0.00130	0.08770	-0.01607	9900.00	9900.00	9900.00	1.1195	0.00	1	-360.00	360.00;
818	422	0.00177	0.08069	-0.00621	9900.00	9900.00	9900.00	1.0983	0.00	1	-360.00	360.00;
818	422	0.00176	0.08123	-0.00538	9900.00	9900.00	9900.00	1.0989	0.00	1	-360.00	360.00;
818	422	0.00177	0.07977	-0.01024	9900.00	9900.00	9900.00	1.0978	0.00	1	-360.00	360.00;
819	421	0.00142	0.08266	-0.00776	9900.00	9900.00	9900.00	0.9501	0.00	1	-360.00	360.00;
819	421	0.00144	0.08228	-0.00662	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
820	435	0.00148	0.07744	-0.00796	9900.00	9900.00	9900.00	1.0282	0.00	1	-360.00	360.00;
820	435	0.00149	0.07699	-0.00813	9900.00	9900.00	9900.00	1.0280	0.00	1	-360.00	360.00;
821	424	0.00163	0.08415	-0.00692	9900.00	9900.00	9900.00	1.0245	0.00	1	-360.00	360.00;
822	438	0.00162	0.08353	-0.00811	9900.00	9900.00	9900.00	1.0262	0.00	1	-360.00	360.00;
823	423	0.00147	0.07965	-0.00826	9900.00	9900.00	9900.00	0.9787	0.00	1	-360.00	360.00;
824	423	0.00124	0.07957	-0.00299	9900.00	9900.00	9900.00	1.0195	0.00	1	-360.00	360.00;
825	181	0.00128	0.08041	-0.00927	9900.00	9900.00	9900.00	1.0282	0.00	1	-360.00	360.00;
825	181	0.00142	0.08341	-0.00617	9900.00	9900.00	9900.00	1.0268	0.00	1	-360.00	360.00;
825	181	0.00123	0.08349	-0.00827	9900.00	9900.00	9900.00	1.0299	0.00	1	-360.00	360.00;
826	425	0.00178	0.08290	-0.00755	9900.00	9900.00	9900.00	1.0311	0.00	1	-360.00	360.00;
826	425	0.00174	0.08311	-0.00674	9900.00	9900.00	9900.00	1.0317	0.00	1	-360.00	360.00;
827	617	0.00187	0.07831	-0.00947	9900.00	9900.00	9900.00	1.0529	0.00	1	-360.00	360.00;
827	617	0.00199	0.08031	-0.00640	9900.00	9900.00	9900.00	1.0521	0.00	1	-360.00	360.00;
828	617	0.00174	0.08081	-0.00269	9900.00	9900.00	9900.00	1.0550	0.00	1	-360.00	360.00;
828	617	0.00152	0.07793	-0.01042	9900.00	9900.00	9900.00	1.0575	0.00	1	-360.00	360.00;
829	230	0.00162	0.08082	-0.00279	9900.00	9900.00	9900.00	1.0157	0.00	1	-360.00	360.00;
829	230	0.00159	0.08394	-0.01283	9900.00	9900.00	9900.00	1.0163	0.00	1	-360.00	360.00;
830	368	0.00104	0.07958	-0.00317	9900.00	9900.00	9900.00	1.0677	0.00	1	-360.00	360.00;
831	605	0.00097	0.08458	-0.00251	9900.00	9900.00	9900.00	1.0302	0.00	1	-360.00	360.00;
831	605	0.00098	0.08441	-0.00117	9900.00	9900.00	9900.00	1.0299	0.00	1	-360.00	360.00;
832	1	0.00165	0.08054	-0.00807	9900.00	9900.00	9900.00	1.0084	0.00	1	-360.00	360.00;
833	1	0.00098	0.08199	-0.00115	9900.00	9900.00	9900.00	0.9940	0.00	1	-360.00	360.00;
834	614	0.00220	0.08164	-0.00374	9900.00	9900.00	9900.00	1.0230	0.00	1	-360.00	360.00;
835	437	0.00146	0.08044	-0.01455	9900.00	9900.00	9900.00	1.0223	0.00	1	-360.00	360.00;
836	606	0.00197	0.07842	-0.00562	9900.00	9900.00	9900.00	1.0154	0.00	1	-360.00	360.00;
837	606	0.00191	0.07720	-0.00336	9900.00	9900.00	9900.00	1.0238	0.00	1	-360.00	360.00;
836	606	0.00196	0.07775	-0.00746	9900.00	9900.00	9900.00	1.0153	0.00	1	-360.00	360.00;
837	606	0.00196	0.07886	-0.00565	9900.00	9900.00	9900.00	1.0237	0.00	1	-360.00	360.00;
838	419	0.00162	0.08082	-0.00275	9900.00	9900.00	9900.00	1.0095	0.00	1	-360.00	360.00;
839	368	0.00144	0.08415	-0.00686	9900.00	9900.00	9900.00	1.0524	0.00	1	-360.00	360.00;
830	368	0.00137	0.08020	-0.00347	9900.00	9900.00	9900.00	1.0591	0.00	1	-360.00	360.00;
839	368	0.00134	0.08707	-0.01172	9900.00	9900.00	9900.00	1.0557	0.00	1	-360.00	360.00;
432	840	0.00352	0.25220	0.00000	9900.00	9900.00	9900.00	1.0390	0.00	1	-360.00	360.00;
432	841	0.00351	0.25331	0.00000	9900.00	9900.00	9900.00	1.0390	0.00	1	-360.00	360.00;
432	842	0.00351	0.25331	0.00000	9900.00	9900.00	9900.00	1.0390	0.00	1	-360.00	360.00;
843	369	0.00130	0.08070	-0.00996	9900.00	9900.00	9900.00	1.0453	0.00	1	-360.00	360.00;
843	369	0.00122	0.07916	-0.00243	9900.00	9900.00	9900.00	1.0463	0.00	1	-360.00	360.00;
844	624	0.00186	0.08000	-0.00631	9900.00	9900.00	9900.00	1.0288	0.00	1	-360.00	360.00;
844	622	0.00170	0.08087	-0.00626	9900.00	9900.00	9900.00	1.0164	0.00	1	-360.00	360.00;
838	426	0.00112	0.08378	-0.00232	9900.00	9900.00	9900.00	1.0190	0.00	1	-360.00	360.00;
845	433	0.00103	0.07958	-0.00967	9900.00	9900.00	9900.00	1.0480	0.00	1	-360.00	360.00;
846	433	0.00098	0.07916	-0.00317	9900.00	9900.00	9900.00	1.0475	0.00	1	-360.00	360.00;
847	430	0.00116	0.08191	-0.00317	9900.00	9900.00	9900.00	1.0542	0.00	1	-360.00	360.00;
847	430	0.00116	0.08212	-0.00192	9900.00	9900.00	9900.00	1.0543	0.00	1	-360.00	360.00;
848	202	0.00101	0.07916	-0.00963	9900.00	9900.00	9900.00	1.0492	0.00	1	-360.00	360.00;
848	202	0.00102	0.07958	-0.01332	9900.00	9900.00	9900.00	1.0490	0.00	1	-360.00	360.00;
849	420	0.00100	0.08174	-0.00222	9900.00	9900.00	9900.00	1.0434	0.00	1	-360.00	360.00;
849	420	0.00099	0.08179	-0.00275	9900.00	9900.00	9900.00	1.0437	0.00	1	-360.00	360.00;
850	615	0.00092	0.08716	-0.00169	9900.00	9900.00	9900.00	0.9950	0.00	1	-360.00	360.00;
850	615	0.00093	0.08729	-0.00156	9900.00	9900.00	9900.00	0.9950	0.00	1	-360.00	360.00;
706	56	0.00112	0.08666	-0.00147	9900.00	9900.00	9900.00	1.0259	0.00	1	-360.00	360.00;
561	851	0.00628	0.29673	-0.00442	9900.00	9900.00	9900.00	0.9127	0.00	1	-360.00	360.00;
563	852	0.00618	0.29263	-0.00436	9900.00	9900.00	9900.00	0.9410	0.00	1	-360.00	360.00;
693	506	0.00114	0.08708	-0.00140	9900.00	9900.00	9900.00	1.0675	0.00	1	-360.00	360.00;
853	415	0.00119	0.08366	-0.00178	9900.00	9900.00	9900.00	1.0617	0.00	1	-360.00	360.00;
853	415	0.00119	0.08366	-0.00175	9900.00	9900.00	9900.00	1.0617	0.00	1	-360.00	360.00;
853	415	0.00119	0.08362	-0.00169	9900.00	9900.00	9900.00	1.0616	0.00	1	-360.00	360.00;
564	854	0.00660	0.28192	-0.00381	9900.00	9900.00	9900.00	0.9598	0.00	1	-360.00	360.00;
562	854	0.00665	0.28292	-0.00362	9900.00	9900.00	9900.00	0.9656	0.00	1	-360.00	360.00;
824	439	0.00107	0.07958	-0.00317	9900.00	9900.00	9900.00	1.0279	0.00	1	-360.00	360.00;
563	851	0.00629	0.29643	-0.00457	9900.00	9900.00	9900.00	0.8974	0.00	1	-360.00	360.00;
556	389	0.00018	0.01574	-0.00298	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
556	387	0.00018	0.01575	-0.00307	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
572	380	0.00018	0.01581	-0.00313	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
535	855	0.00280	0.09843	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
440	856	0.00226	0.14832	0.00000	9900.00	9900.00	9900.00	0.9775	0.00	1	-360.00	360.00;
440	856	0.00226	0.14832	-0.00215	9900.00	9900.00	9900.00	0.9775	0.00	1	-360.00	360.00;
496	857	0.00708	0.26657	-0.00337	9900.00	9900.00	9900.00	1.0664	0.00	1	-360.00	360.00;
496	857	0.00485	0.24662	-0.00124	9900.00	9900.00	9900.00	1.0662	0.00	1	-360.00	360.00;
496	858	0.00656	0.25925	-0.00535	9900.00	9900.00	9900.00	0.8795	0.00	1	-360.00	360.00;
496	858	0.00661	0.26058	-0.00491	9900.00	9900.00	9900.00	0.8796	0.00	1	-360.00	360.00;
496	857	0.00440	0.24829	-0.00568	9900.00	9900.00	9900.00	1.0664	0.00	1	-360.00	360.00;
561	852	0.00634	0.29863	-0.00460	9900.00	9900.00	9900.00	0.9524	0.00	1	-360.00	360.00;
517	859	0.00595	0.20900	-0.00246	9900.00	9900.00	9900.00	0.9570	0.00	1	-360.00	360.00;
517	859	0.00599	0.20850	-0.00297	9900.00	9900.00	9900.00	0.9571	0.00	1	-360.00	360.00;
460	860	0.00483	0.24745	-0.00165	9900.00	9900.00	9900.00	0.8984	0.00	1	-360.00	360.00;
460	860	0.00481	0.24662	-0.00171	9900.00	9900.00	9900.00	0.8983	0.00	1	-360.00	360.00;
464	861	0.00675	0.24590	-0.00173	9900.00	9900.00	9900.00	0.9250	0.00	1	-360.00	360.00;
464	861	0.00688	0.24590	-0.00280	9900.00	9900.00	9900.00	0.9255	0.00	1	-360.00	360.00;
510	862	0.00423	0.23580	-0.00241	9900.00	9900.00	9900.00	0.9273	0.00	1	-360.00	360.00;
510	862	0.00435	0.23329	-0.00541	9900.00	9900.00	9900.00	0.9288	0.00	1	-360.00	360.00;
521	863	0.00545	0.19692	-0.00313	9900.00	9900.00	9900.00	0.9612	0.00	1	-360.00	360.00;
518	863	0.00537	0.19693	-0.00321	9900.00	9900.00	9900.00	0.9611	0.00	1	-360.00	360.00;
478	864	0.00484	0.18064	-0.00350	9900.00	9900.00	9900.00	0.9652	0.00	1	-360.00	360.00;
478	864	0.00605	0.20791	-0.00188	9900.00	9900.00	9900.00	0.9664	0.00	1	-360.00	360.00;
511	865	0.00506	0.24245	-0.00328	9900.00	9900.00	9900.00	0.9262	0.00	1	-360.00	360.00;
511	865	0.00508	0.24203	-0.00372	9900.00	9900.00	9900.00	0.9264	0.00	1	-360.00	360.00;
511	866	0.00503	0.20244	-0.00423	9900.00	9900.00	9900.00	1.0761	0.00	1	-360.00	360.00;
511	866	0.00514	0.20353	-0.00423	9900.00	9900.00	9900.00	1.0762	0.00	1	-360.00	360.00;
509	867	0.00490	0.24145	-0.00355	9900.00	9900.00	9900.00	0.9949	0.00	1	-360.00	360.00;
509	867	0.00660	0.24150	-0.00173	9900.00	9900.00	9900.00	0.9957	0.00	1	-360.00	360.00;
512	868	0.00593	0.20791	-0.00251	9900.00	9900.00	9900.00	0.9496	0.00	1	-360.00	360.00;
512	868	0.00588	0.20492	-0.00255	9900.00	9900.00	9900.00	0.9497	0.00	1	-360.00	360.00;
471	869	0.00498	0.20444	-0.00469	9900.00	9900.00	9900.00	0.9674	0.00	1	-360.00	360.00;
471	869	0.00489	0.20394	-0.00442	9900.00	9900.00	9900.00	0.9672	0.00	1	-360.00	360.00;
515	870	0.00700	0.26658	-0.00686	9900.00	9900.00	9900.00	0.9525	0.00	1	-360.00	360.00;
513	870	0.00700	0.26658	-0.00606	9900.00	9900.00	9900.00	0.9525	0.00	1	-360.00	360.00;
520	871	0.00475	0.20094	-0.00936	9900.00	9900.00	9900.00	1.0703	0.00	1	-360.00	360.00;
519	871	0.00463	0.20095	-0.00938	9900.00	9900.00	9900.00	1.0703	0.00	1	-360.00	360.00;
519	872	0.00468	0.24496	-0.00373	9900.00	9900.00	9900.00	0.8953	0.00	1	-360.00	360.00;
621	873	0.00464	0.17894	-0.00306	9900.00	9900.00	9900.00	0.9975	0.00	1	-360.00	360.00;
611	874	0.00480	0.17994	-0.00288	9900.00	9900.00	9900.00	0.9699	0.00	1	-360.00	360.00;
611	874	0.00514	0.18040	-0.00335	9900.00	9900.00	9900.00	0.9715	0.00	1	-360.00	360.00;
620	875	0.00591	0.19137	-0.00906	9900.00	9900.00	9900.00	0.9692	0.00	1	-360.00	360.00;
620	875	0.00599	0.19084	-0.00928	9900.00	9900.00	9900.00	0.9697	0.00	1	-360.00	360.00;
620	876	0.00590	0.19058	-0.00935	9900.00	9900.00	9900.00	0.9698	0.00	1	-360.00	360.00;
620	876	0.00580	0.18991	-0.00873	9900.00	9900.00	9900.00	0.9694	0.00	1	-360.00	360.00;
514	877	0.00825	0.26100	-0.00132	9900.00	9900.00	9900.00	0.9580	0.00	1	-360.00	360.00;
514	877	0.00601	0.25993	-0.00113	9900.00	9900.00	9900.00	0.9541	0.00	1	-360.00	360.00;
527	319	0.00018	0.01579	-0.00570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
567	378	0.00022	0.01749	0.03133	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
705	58	0.00112	0.08666	-0.00142	9900.00	9900.00	9900.00	1.0406	0.00	1	-360.00	360.00;
526	319	0.00018	0.01579	-0.00308	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
526	319	0.00018	0.01579	-0.00570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
527	319	0.00018	0.01579	-0.00570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
878	525	0.00153	0.08654	-0.00118	9900.00	9900.00	9900.00	0.9708	0.00	1	-360.00	360.00;
878	525	0.00158	0.08599	-0.00118	9900.00	9900.00	9900.00	0.9705	0.00	1	-360.00	360.00;
879	371	0.00105	0.07958	-0.00280	9900.00	9900.00	9900.00	1.0764	0.00	1	-360.00	360.00;
366	641	0.00259	0.13903	-0.00771	9900.00	9900.00	9900.00	0.9212	0.00	1	-360.00	360.00;
880	400	0.00142	0.08028	-0.00250	9900.00	9900.00	9900.00	1.0345	0.00	1	-360.00	360.00;
881	400	0.00139	0.08091	-0.00346	9900.00	9900.00	9900.00	1.0399	0.00	1	-360.00	360.00;
880	400	0.00139	0.08078	-0.00312	9900.00	9900.00	9900.00	1.0352	0.00	1	-360.00	360.00;
881	400	0.00141	0.08036	-0.00253	9900.00	9900.00	9900.00	1.0393	0.00	1	-360.00	360.00;
474	278	0.00012	0.01559	-0.00198	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
474	339	0.00012	0.01560	-0.00217	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
474	278	0.00012	0.01554	-0.00205	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
560	882	0.00000	0.06830	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
560	883	0.00000	0.06830	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
412	884	0.00000	0.08228	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
405	885	0.00108	0.03918	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
408	886	0.00107	0.03898	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
408	887	0.00107	0.03872	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
374	888	0.00281	0.10109	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
374	889	0.00276	0.10036	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
422	890	0.00268	0.08270	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
422	891	0.00268	0.08270	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
425	892	0.00263	0.08271	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
425	893	0.00264	0.08265	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
348	894	0.00265	0.08223	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
359	895	0.00265	0.08223	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
359	896	0.00265	0.08235	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
444	897	0.00280	0.09923	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
522	898	0.00280	0.09796	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
408	899	0.00323	0.11996	0.00000	9900.00	9900.00	9900.00	0.9983	0.00	1	-360.00	360.00;
523	900	0.01255	0.65863	-0.00096	9900.00	9900.00	9900.00	0.9875	0.00	1	-360.00	360.00;
523	900	0.01254	0.65713	-0.00080	9900.00	9900.00	9900.00	0.9875	0.00	1	-360.00	360.00;
503	324	0.00020	0.01600	-0.00570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
541	901	0.00276	0.09843	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
902	354	0.00104	0.07958	-0.00320	9900.00	9900.00	9900.00	1.0559	0.00	1	-360.00	360.00;
347	903	0.00157	0.05061	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
473	904	0.00463	0.17077	-0.02749	9900.00	9900.00	9900.00	0.9742	0.00	1	-360.00	360.00;
473	904	0.00450	0.16827	-0.00736	9900.00	9900.00	9900.00	0.9737	0.00	1	-360.00	360.00;
473	904	0.00228	0.10842	-0.00230	9900.00	9900.00	9900.00	0.9726	0.00	1	-360.00	360.00;
905	608	0.00194	0.08053	-0.00541	9900.00	9900.00	9900.00	0.9614	0.00	1	-360.00	360.00;
906	505	0.00111	0.08666	-0.00108	9900.00	9900.00	9900.00	1.1043	0.00	1	-360.00	360.00;
906	505	0.00113	0.08666	-0.00164	9900.00	9900.00	9900.00	1.1036	0.00	1	-360.00	360.00;
906	505	0.00111	0.08666	-0.00108	9900.00	9900.00	9900.00	1.1043	0.00	1	-360.00	360.00;
907	358	0.00173	0.08411	-0.00666	9900.00	9900.00	9900.00	1.0133	0.00	1	-360.00	360.00;
908	358	0.00178	0.08594	-0.00790	9900.00	9900.00	9900.00	0.9789	0.00	1	-360.00	360.00;
909	358	0.00163	0.08290	-0.00976	9900.00	9900.00	9900.00	1.0359	0.00	1	-360.00	360.00;
149	910	0.00315	0.12450	-0.00395	9900.00	9900.00	9900.00	0.9813	0.00	1	-360.00	360.00;
144	910	0.00323	0.12335	-0.00176	9900.00	9900.00	9900.00	0.9817	0.00	1	-360.00	360.00;
144	910	0.00315	0.12446	-0.00358	9900.00	9900.00	9900.00	0.9813	0.00	1	-360.00	360.00;
149	910	0.00297	0.12441	-0.00401	9900.00	9900.00	9900.00	0.9806	0.00	1	-360.00	360.00;
520	872	0.00492	0.23912	-0.00361	9900.00	9900.00	9900.00	0.8987	0.00	1	-360.00	360.00;
906	505	0.00115	0.08666	-0.00134	9900.00	9900.00	9900.00	1.1029	0.00	1	-360.00	360.00;
546	362	0.00015	0.01600	-0.00463	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
240	911	0.00667	0.22467	0.00000	9900.00	9900.00	9900.00	1.0296	0.00	1	-360.00	360.00;
240	911	0.00667	0.22256	0.00000	9900.00	9900.00	9900.00	1.0296	0.00	1	-360.00	360.00;
575	912	0.00323	0.13474	-0.00395	9900.00	9900.00	9900.00	0.9371	0.00	1	-360.00	360.00;
573	912	0.00323	0.13474	-0.00395	9900.00	9900.00	9900.00	0.9206	0.00	1	-360.00	360.00;
602	119	0.00031	0.02645	-0.00327	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
603	119	0.00032	0.02607	-0.00406	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
913	476	0.00149	0.08540	-0.00759	9900.00	9900.00	9900.00	1.0500	0.00	1	-360.00	360.00;
913	476	0.00146	0.08645	-0.00679	9900.00	9900.00	9900.00	1.0505	0.00	1	-360.00	360.00;
472	914	0.01230	0.53150	0.01230	9900.00	9900.00	9900.00	0.9648	0.00	1	-360.00	360.00;
476	914	0.01230	0.53275	0.01230	9900.00	9900.00	9900.00	0.9738	0.00	1	-360.00	360.00;
627	915	0.00513	0.18223	-0.00355	9900.00	9900.00	9900.00	0.9931	0.00	1	-360.00	360.00;
628	916	0.00511	0.17953	-0.00486	9900.00	9900.00	9900.00	0.9967	0.00	1	-360.00	360.00;
160	399	0.00012	0.01577	-0.00591	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
157	398	0.00021	0.01646	-0.01608	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
510	334	0.00022	0.01654	-0.01118	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
917	163	0.00176	0.08498	-0.01212	9900.00	9900.00	9900.00	1.0332	0.00	1	-360.00	360.00;
917	163	0.00174	0.08498	-0.00608	9900.00	9900.00	9900.00	1.0334	0.00	1	-360.00	360.00;
560	918	0.00300	0.10996	-0.00848	9900.00	9900.00	9900.00	0.9570	0.00	1	-360.00	360.00;
560	919	0.00306	0.11023	-0.00977	9900.00	9900.00	9900.00	0.9573	0.00	1	-360.00	360.00;
560	919	0.00296	0.11057	-0.00991	9900.00	9900.00	9900.00	0.9558	0.00	1	-360.00	360.00;
479	321	0.00014	0.01675	-0.01047	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
485	322	0.00017	0.01508	0.04570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
490	322	0.00012	0.01592	-0.00566	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
920	490	0.00175	0.08361	-0.00728	9900.00	9900.00	9900.00	1.0490	0.00	1	-360.00	360.00;
920	490	0.00143	0.08707	-0.00290	9900.00	9900.00	9900.00	1.0546	0.00	1	-360.00	360.00;
921	490	0.00157	0.08624	-0.00339	9900.00	9900.00	9900.00	1.0521	0.00	1	-360.00	360.00;
921	490	0.00175	0.08415	-0.00646	9900.00	9900.00	9900.00	1.0491	0.00	1	-360.00	360.00;
467	284	0.00017	0.01596	-0.00313	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
922	466	0.00197	0.07970	-0.00208	9900.00	9900.00	9900.00	1.0362	0.00	1	-360.00	360.00;
923	468	0.00196	0.07833	-0.00395	9900.00	9900.00	9900.00	1.0341	0.00	1	-360.00	360.00;
924	307	0.00121	0.08045	-0.00609	9900.00	9900.00	9900.00	0.9858	0.00	1	-360.00	360.00;
924	308	0.00119	0.08032	-0.00599	9900.00	9900.00	9900.00	0.9859	0.00	1	-360.00	360.00;
657	82	0.00137	0.07957	-0.00292	9900.00	9900.00	9900.00	1.0098	0.00	1	-360.00	360.00;
36	925	0.00222	0.14237	-0.00325	9900.00	9900.00	9900.00	0.9901	0.00	1	-360.00	360.00;
40	925	0.00223	0.14165	-0.00304	9900.00	9900.00	9900.00	1.0026	0.00	1	-360.00	360.00;
629	452	0.00195	0.08331	0.00000	9900.00	9900.00	9900.00	1.0075	0.00	1	-360.00	360.00;
631	651	0.00135	0.08332	0.01032	9900.00	9900.00	9900.00	1.0133	0.00	1	-360.00	360.00;
926	572	0.00135	0.08332	-0.00251	9900.00	9900.00	9900.00	1.0557	0.00	1	-360.00	360.00;
926	572	0.00135	0.08332	-0.00251	9900.00	9900.00	9900.00	1.0557	0.00	1	-360.00	360.00;
926	572	0.00135	0.08332	-0.00251	9900.00	9900.00	9900.00	1.0557	0.00	1	-360.00	360.00;
927	574	0.00172	0.08943	-0.00251	9900.00	9900.00	9900.00	0.9554	0.00	1	-360.00	360.00;
928	428	0.00138	0.08024	-0.00293	9900.00	9900.00	9900.00	0.9940	0.00	1	-360.00	360.00;
834	614	0.00135	0.08332	-0.00251	9900.00	9900.00	9900.00	1.0322	0.00	1	-360.00	360.00;
929	90	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	0.9803	0.00	1	-360.00	360.00;
693	506	0.00135	0.08015	-0.00109	9900.00	9900.00	9900.00	1.0625	0.00	1	-360.00	360.00;
668	168	0.00122	0.08353	-0.00267	9900.00	9900.00	9900.00	1.0395	0.00	1	-360.00	360.00;
930	168	0.00137	0.07916	-0.00317	9900.00	9900.00	9900.00	0.9814	0.00	1	-360.00	360.00;
366	641	0.00232	0.13331	-0.00500	9900.00	9900.00	9900.00	0.9179	0.00	1	-360.00	360.00;
589	119	0.00032	0.02620	-0.00549	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
590	119	0.00025	0.02596	-0.00527	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
931	281	0.00149	0.08292	-0.00220	9900.00	9900.00	9900.00	1.0066	0.00	1	-360.00	360.00;
931	281	0.00146	0.08334	-0.00224	9900.00	9900.00	9900.00	1.0073	0.00	1	-360.00	360.00;
366	932	0.00232	0.13331	-0.00500	9900.00	9900.00	9900.00	1.0556	0.00	1	-360.00	360.00;
933	377	0.00121	0.08387	-0.00241	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
933	377	0.00118	0.08378	-0.00239	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
584	377	0.00022	0.02573	-0.00491	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
934	560	0.00167	0.07977	-0.00311	9900.00	9900.00	9900.00	0.9582	0.00	1	-360.00	360.00;
449	296	0.00014	0.01682	-0.00460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
450	296	0.00018	0.01579	0.03440	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
935	449	0.00138	0.08332	-0.00476	9900.00	9900.00	9900.00	1.0019	0.00	1	-360.00	360.00;
935	450	0.00188	0.08510	-0.00389	9900.00	9900.00	9900.00	1.0031	0.00	1	-360.00	360.00;
936	450	0.00191	0.08553	-0.00396	9900.00	9900.00	9900.00	1.0031	0.00	1	-360.00	360.00;
936	449	0.00139	0.08436	-0.00445	9900.00	9900.00	9900.00	1.0019	0.00	1	-360.00	360.00;
465	284	0.00020	0.01600	0.02687	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
467	284	0.00021	0.01670	0.01100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
748	395	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	1.0578	0.00	1	-360.00	360.00;
723	359	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	1.0411	0.00	1	-360.00	360.00;
836	606	0.00135	0.08332	-0.00251	9900.00	9900.00	9900.00	1.0239	0.00	1	-360.00	360.00;
833	1	0.00135	0.08332	-0.00251	9900.00	9900.00	9900.00	0.9947	0.00	1	-360.00	360.00;
937	364	0.00112	0.08412	-0.00242	9900.00	9900.00	9900.00	1.0337	0.00	1	-360.00	360.00;
937	364	0.00109	0.08412	-0.00244	9900.00	9900.00	9900.00	1.0339	0.00	1	-360.00	360.00;
938	348	0.00029	0.02270	0.05421	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
938	348	0.00027	0.02800	0.05628	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
939	938	0.00294	0.12280	-0.00715	9900.00	9900.00	9900.00	0.9743	0.00	1	-360.00	360.00;
940	383	0.00123	0.08332	-0.00274	9900.00	9900.00	9900.00	0.9525	0.00	1	-360.00	360.00;
940	381	0.00136	0.08199	-0.00257	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
941	381	0.00136	0.08241	-0.00250	9900.00	9900.00	9900.00	0.9518	0.00	1	-360.00	360.00;
940	381	0.00103	0.07958	-0.00244	9900.00	9900.00	9900.00	0.9560	0.00	1	-360.00	360.00;
941	381	0.00137	0.08316	-0.00258	9900.00	9900.00	9900.00	0.9519	0.00	1	-360.00	360.00;
941	383	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
560	918	0.00296	0.11057	-0.00991	9900.00	9900.00	9900.00	0.9563	0.00	1	-360.00	360.00;
560	942	0.00296	0.11007	-0.01037	9900.00	9900.00	9900.00	1.1075	0.00	1	-360.00	360.00;
659	284	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	0.9662	0.00	1	-360.00	360.00;
576	943	0.00628	0.29673	-0.00173	9900.00	9900.00	9900.00	0.9741	0.00	1	-360.00	360.00;
577	943	0.00628	0.29673	-0.00173	9900.00	9900.00	9900.00	0.9741	0.00	1	-360.00	360.00;
682	458	0.00193	0.08526	-0.00400	9900.00	9900.00	9900.00	1.0615	0.00	1	-360.00	360.00;
682	300	0.00163	0.08333	-0.00317	9900.00	9900.00	9900.00	1.0750	0.00	1	-360.00	360.00;
482	325	0.00017	0.01600	-0.00460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
482	944	0.00358	0.16579	-0.01278	9900.00	9900.00	9900.00	0.9600	0.00	1	-360.00	360.00;
482	944	0.00374	0.16829	-0.01415	9900.00	9900.00	9900.00	0.9610	0.00	1	-360.00	360.00;
482	944	0.00451	0.16577	-0.00563	9900.00	9900.00	9900.00	0.9673	0.00	1	-360.00	360.00;
945	377	0.00120	0.08445	-0.00234	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
560	377	0.00022	0.02600	0.01274	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
582	377	0.00022	0.02573	-0.00491	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
946	516	0.00115	0.08666	-0.00251	9900.00	9900.00	9900.00	0.9593	0.00	1	-360.00	360.00;
946	516	0.00115	0.08666	-0.00251	9900.00	9900.00	9900.00	0.9593	0.00	1	-360.00	360.00;
947	330	0.00100	0.07999	-0.00317	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
948	330	0.00104	0.07916	-0.00317	9900.00	9900.00	9900.00	1.0323	0.00	1	-360.00	360.00;
947	329	0.00138	0.07999	-0.00308	9900.00	9900.00	9900.00	0.9695	0.00	1	-360.00	360.00;
945	377	0.00122	0.08391	-0.00233	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
560	377	0.00022	0.02573	0.01114	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
598	949	0.00022	0.02616	-0.00491	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
599	411	0.00021	0.02608	-0.00491	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
950	522	0.00116	0.08708	0.00000	9900.00	9900.00	9900.00	0.9520	0.00	1	-360.00	360.00;
718	545	0.00093	0.08737	-0.00188	9900.00	9900.00	9900.00	1.0987	0.00	1	-360.00	360.00;
951	397	0.00101	0.07958	-0.01054	9900.00	9900.00	9900.00	1.0413	0.00	1	-360.00	360.00;
951	397	0.00101	0.07958	-0.00317	9900.00	9900.00	9900.00	1.0413	0.00	1	-360.00	360.00;
952	397	0.00100	0.07999	-0.00317	9900.00	9900.00	9900.00	1.0418	0.00	1	-360.00	360.00;
952	397	0.00103	0.07999	-0.00255	9900.00	9900.00	9900.00	1.0409	0.00	1	-360.00	360.00;
953	453	0.00285	0.12500	-0.00715	9900.00	9900.00	9900.00	1.0072	0.00	1	-360.00	360.00;
954	453	0.00186	0.08333	-0.00251	9900.00	9900.00	9900.00	1.0934	0.00	1	-360.00	360.00;
954	453	0.00186	0.08333	-0.00251	9900.00	9900.00	9900.00	1.0934	0.00	1	-360.00	360.00;
954	453	0.00186	0.08333	-0.00251	9900.00	9900.00	9900.00	1.0934	0.00	1	-360.00	360.00;
955	587	0.00111	0.08687	-0.00659	9900.00	9900.00	9900.00	1.1500	0.00	1	-360.00	360.00;
955	587	0.00111	0.08687	-0.00840	9900.00	9900.00	9900.00	0.8500	0.00	1	-360.00	360.00;
955	587	0.00195	0.08086	-0.00535	9900.00	9900.00	9900.00	0.9044	0.00	1	-360.00	360.00;
955	587	0.00198	0.08114	-0.00506	9900.00	9900.00	9900.00	0.9044	0.00	1	-360.00	360.00;
688	480	0.00139	0.08036	-0.00108	9900.00	9900.00	9900.00	1.0599	0.00	1	-360.00	360.00;
956	428	0.00137	0.08582	-0.00317	9900.00	9900.00	9900.00	1.0806	0.00	1	-360.00	360.00;
956	428	0.00156	0.08332	-0.00879	9900.00	9900.00	9900.00	1.0754	0.00	1	-360.00	360.00;
957	428	0.00156	0.08332	-0.00317	9900.00	9900.00	9900.00	1.0809	0.00	1	-360.00	360.00;
957	428	0.00157	0.08290	-0.00879	9900.00	9900.00	9900.00	1.0806	0.00	1	-360.00	360.00;
956	428	0.00156	0.08374	-0.00317	9900.00	9900.00	9900.00	1.0755	0.00	1	-360.00	360.00;
957	428	0.00155	0.08007	-0.01291	9900.00	9900.00	9900.00	1.0798	0.00	1	-360.00	360.00;
565	376	0.00018	0.01583	-0.00193	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
720	547	0.00137	0.08066	-0.00105	9900.00	9900.00	9900.00	1.0751	0.00	1	-360.00	360.00;
958	369	0.00114	0.08103	-0.00186	9900.00	9900.00	9900.00	1.0395	0.00	1	-360.00	360.00;
958	369	0.00138	0.07991	-0.00196	9900.00	9900.00	9900.00	1.0357	0.00	1	-360.00	360.00;
959	406	0.00137	0.07974	-0.00301	9900.00	9900.00	9900.00	0.9957	0.00	1	-360.00	360.00;
960	406	0.00137	0.08035	-0.00287	9900.00	9900.00	9900.00	1.0733	0.00	1	-360.00	360.00;
961	406	0.00138	0.07959	-0.00286	9900.00	9900.00	9900.00	1.0744	0.00	1	-360.00	360.00;
962	136	0.00138	0.07978	-0.00269	9900.00	9900.00	9900.00	1.0765	0.00	1	-360.00	360.00;
963	388	0.00136	0.08795	-0.00317	9900.00	9900.00	9900.00	0.9795	0.00	1	-360.00	360.00;
964	373	0.00138	0.07991	-0.00202	9900.00	9900.00	9900.00	0.9805	0.00	1	-360.00	360.00;
965	291	0.00178	0.08542	-0.00317	9900.00	9900.00	9900.00	1.0283	0.00	1	-360.00	360.00;
965	291	0.00163	0.08492	-0.00317	9900.00	9900.00	9900.00	1.0298	0.00	1	-360.00	360.00;
966	291	0.00137	0.07986	-0.00196	9900.00	9900.00	9900.00	1.0013	0.00	1	-360.00	360.00;
966	291	0.00138	0.08011	-0.00263	9900.00	9900.00	9900.00	1.0013	0.00	1	-360.00	360.00;
967	591	0.00135	0.08332	-0.00251	9900.00	9900.00	9900.00	1.0095	0.00	1	-360.00	360.00;
968	591	0.00134	0.08053	-0.00126	9900.00	9900.00	9900.00	1.0075	0.00	1	-360.00	360.00;
507	325	0.00017	0.01598	-0.00361	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
969	284	0.00137	0.07941	0.04363	9900.00	9900.00	9900.00	1.0446	0.00	1	-360.00	360.00;
503	336	0.00018	0.01642	-0.00334	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
491	336	0.00018	0.01642	-0.00350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
848	202	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	1.0374	0.00	1	-360.00	360.00;
817	431	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	1.0497	0.00	1	-360.00	360.00;
970	284	0.00139	0.07915	0.04363	9900.00	9900.00	9900.00	1.0172	0.00	1	-360.00	360.00;
970	284	0.00139	0.07915	0.04363	9900.00	9900.00	9900.00	1.0172	0.00	1	-360.00	360.00;
446	455	0.00005	0.01387	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
66	72	0.00007	0.01041	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
68	70	0.00007	0.01041	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
36	40	0.00006	0.02002	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
529	653	0.00012	0.01012	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
376	375	0.00000	0.01000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
806	807	0.00000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
806	807	0.00000	0.19660	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
770	907	0.00000	0.12000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
797	798	0.00244	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
26	23	0.00002	0.00500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
341	342	0.00001	0.00300	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
318	356	0.00001	0.00300	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
318	357	0.00001	0.00300	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
504	506	0.00001	0.00980	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
367	291	0.00001	0.00350	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
370	291	0.00001	0.00350	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
304	332	0.00002	0.00444	0.90000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
382	397	0.00017	0.00350	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
384	397	0.00018	0.00350	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
620	610	0.00005	0.00463	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
620	609	0.00005	0.00463	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
583	595	0.00007	0.00667	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
583	593	0.00007	0.00667	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
536	548	0.00001	0.00683	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
344	350	0.00001	0.00300	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
565	974	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
614	975	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
546	976	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
544	977	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
533	978	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
364	979	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
606	980	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
606	981	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
567	982	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
614	983	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
624	984	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
439	985	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
788	986	0.00302	0.00868	0.19860	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
789	987	0.00297	0.00901	0.19930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
697	696	0.04670	0.10550	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
233	700	0.01221	0.04562	0.07362	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
233	700	0.01441	0.05262	0.07664	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
988	760	0.00000	0.06563	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
988	759	0.00000	0.06559	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
719	720	0.00277	0.00568	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
708	707	0.04100	0.11900	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
751	775	0.00000	0.11589	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
751	775	0.00000	0.11327	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
245	814	0.00000	0.31230	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
245	814	0.00000	0.85540	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
706	705	0.03710	0.12320	0.17580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
684	683	0.00000	1.58000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
956	957	0.02330	0.08250	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
936	935	0.00000	0.08090	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
634	633	0.00380	0.00400	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
674	675	0.00810	0.52350	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
663	662	0.00000	0.44878	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
662	664	0.00000	0.44272	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
662	659	0.00000	0.30358	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
989	933	0.00480	0.01067	0.29500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
990	945	0.00480	0.01067	0.29500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
920	921	0.00140	0.06280	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
756	776	0.00000	0.03500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
757	776	0.00000	0.03500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
659	658	0.00000	0.31195	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
659	924	0.00000	0.05397	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
658	660	0.00000	0.50281	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
658	924	0.00000	0.05391	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
660	661	0.00000	0.92000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
760	758	0.00365	0.36280	0.22600	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
759	758	0.02043	0.38678	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
759	758	0.00000	0.06900	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
758	748	0.01791	0.03985	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
758	748	0.05730	1.15576	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
758	760	0.03358	0.91792	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
827	828	0.01310	0.05250	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
638	704	0.02764	0.30298	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
764	765	0.00000	0.13694	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
839	830	0.00000	0.08270	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
832	991	0.00081	0.00285	0.01040	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
832	992	0.00615	0.02993	0.01923	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
833	993	0.00281	0.01066	0.27957	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
833	994	0.00821	0.03997	0.02191	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
995	831	0.00761	0.04444	0.03861	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
993	996	0.00001	0.00010	0.00001	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
993	997	0.00000	0.25700	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
993	997	0.00000	0.21300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
996	998	0.00593	0.03271	0.09481	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
996	999	0.00323	0.01000	0.00579	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
997	1000	0.07630	0.13470	0.00098	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1001	1002	0.00040	0.00156	0.04808	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1001	1003	0.00117	0.00459	0.14110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1002	1004	0.00000	0.25000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1002	1005	0.00000	0.41670	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1002	1005	0.00000	0.41670	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1002	850	0.00070	0.00240	0.06881	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1002	994	0.00103	0.00352	0.10100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
850	1006	0.06000	0.20330	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
850	1006	0.00000	0.20230	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
850	1007	0.00000	0.74500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
850	1007	0.00000	0.74100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
850	998	0.00195	0.00653	0.15500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
998	1008	0.00000	0.25070	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1008	1006	0.01917	0.02166	0.03911	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
994	1009	0.00000	0.21200	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
994	1009	0.00000	0.21000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1009	1004	0.01287	0.01479	0.02172	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
991	1000	0.00000	0.21800	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
999	271	0.00011	0.00035	0.00055	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
992	1003	0.00206	0.01004	0.00242	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
992	999	0.00291	0.00902	0.00353	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
681	1010	0.03243	0.07225	0.01638	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
681	1011	0.01910	0.04255	0.00964	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
681	1012	0.01232	0.22745	0.00622	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
681	1013	0.01232	0.22745	0.00622	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1014	1015	0.01975	0.04399	0.00997	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1014	1016	0.01150	0.02605	0.01016	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1017	1018	0.01150	0.30733	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1019	1017	0.00214	0.00477	0.00108	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1019	685	0.00502	0.01167	0.01420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1019	1020	0.00465	0.01035	0.00235	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1019	1012	0.01100	0.02450	0.00555	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1021	1010	0.00210	0.00468	0.00106	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1021	1022	0.01503	0.26699	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1021	1022	0.01650	0.28472	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1023	1014	0.00975	0.02174	0.01229	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1023	1021	0.00210	0.00468	0.00106	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
686	1024	0.00246	0.00585	0.00916	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1025	1026	0.01213	0.28889	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1025	1024	0.02251	0.05045	0.02866	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1025	1016	0.00606	0.01372	0.00297	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1011	1027	0.00903	0.29914	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1011	1027	0.04583	0.51327	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1011	1028	0.01428	0.03182	0.00721	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1015	1029	0.00079	0.00176	0.00040	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1015	1028	0.00135	0.00302	0.00068	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1029	1030	0.01423	0.28526	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1020	1031	0.02252	0.80071	0.00884	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1020	1012	0.00635	0.01415	0.00321	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1024	1032	0.01250	0.32378	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1024	1013	0.00504	0.01135	0.00250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1028	1033	0.01352	0.26561	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1028	1033	0.01346	0.26588	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1028	1034	0.00000	0.19700	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1028	1034	0.00000	0.19700	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1012	1035	0.01110	0.29500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1013	1036	0.01121	0.30133	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1016	1037	0.01474	0.28481	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1038	1039	0.01080	0.00910	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1040	1041	0.06650	0.14815	0.03358	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1040	655	0.00351	0.01101	0.00482	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1040	1042	0.03105	0.07057	0.01775	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1043	1044	0.01276	0.26398	0.00125	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1043	656	0.00351	0.01101	0.00482	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1043	1045	0.03100	0.07049	0.01524	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1046	1044	0.01049	0.24327	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1046	656	0.00559	0.01247	0.00283	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1047	1044	0.01059	0.24477	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1047	655	0.00739	0.01666	0.00367	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1048	655	0.05167	0.11511	0.02609	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1048	1049	0.01405	0.27280	0.00190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1048	1050	0.03078	0.06856	0.01554	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1051	1052	0.00793	0.23431	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1051	1050	0.01198	0.02669	0.00605	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1041	1052	0.00806	0.23597	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1041	255	0.01198	0.02669	0.00605	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
655	1053	0.02621	0.05835	0.01734	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
656	1054	0.02621	0.05835	0.01734	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
656	1055	0.05803	0.12925	0.03080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
656	1056	0.05514	0.12284	0.02982	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
931	1057	0.00620	0.01382	0.00313	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
931	1058	0.00620	0.01382	0.00313	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
931	1059	0.00302	0.01285	0.00474	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
931	1060	0.00302	0.01285	0.00474	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1057	1061	0.00800	0.25754	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1058	1061	0.00796	0.25654	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1058	1062	0.02320	0.05260	0.01140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1063	1038	0.02421	0.28910	0.00467	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1063	252	0.00861	0.01908	0.00420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1063	255	0.04780	0.10645	0.02739	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1064	1038	0.02496	0.29574	0.00468	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1064	252	0.00861	0.01908	0.00420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1064	255	0.04780	0.10645	0.02739	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1059	1065	0.01599	0.06802	0.02509	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1060	1066	0.01599	0.06802	0.02509	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1042	1067	0.01387	0.27075	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1045	1067	0.01399	0.27029	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1045	1062	0.02652	0.06006	0.01303	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1067	1068	0.26000	0.45240	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
252	1039	0.00969	0.28300	0.00283	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
252	1065	0.00648	0.02758	0.01017	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
252	1066	0.00648	0.02758	0.01017	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
255	1069	0.02523	0.66782	0.00303	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
255	1069	0.02506	0.66758	0.00031	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1062	1068	0.01244	0.29418	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1049	1070	0.04780	0.12330	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1053	1071	0.03040	0.63593	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1054	1071	0.01682	0.65644	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1055	1051	0.01638	0.03648	0.00870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1055	1070	0.01100	0.24976	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1056	1070	0.00739	0.24889	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1056	1050	0.02829	0.06305	0.01571	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1065	1072	0.01140	0.23867	0.00083	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1066	1072	0.01143	0.23934	0.00029	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1050	1073	0.00091	0.00203	0.00046	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1050	1074	0.00112	0.00249	0.00165	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1075	950	0.00917	0.02075	0.00451	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1076	950	0.00917	0.02075	0.00451	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1077	1078	0.00012	0.00057	0.00015	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1079	1078	0.00016	0.00062	0.00184	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1080	1077	0.00361	0.01243	0.02764	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1081	1079	0.00360	0.01236	0.03068	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1082	1083	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1082	1084	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1082	1085	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
821	826	0.04668	0.10361	0.05927	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
821	1086	0.01248	0.03051	0.00889	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
821	1087	0.00824	0.02415	0.00968	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
821	1088	0.00079	0.00125	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1089	826	0.04737	0.10513	0.05961	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
822	1090	0.00298	0.00936	0.00410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
822	1091	0.00824	0.02415	0.00968	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
822	1092	0.00079	0.00125	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
838	1093	0.00399	0.01736	0.00398	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
838	1093	0.00399	0.01740	0.00398	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
838	1094	0.03187	0.07059	0.05119	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
838	1095	0.07108	0.15793	0.07099	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1096	1097	0.00806	0.24677	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1096	848	0.00157	0.01072	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1098	1097	0.00801	0.25066	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1098	848	0.00157	0.01072	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1098	1099	0.02485	0.05535	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
820	1100	0.00012	0.00030	0.00740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
820	1101	0.00012	0.00029	0.00719	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1102	1103	0.01093	0.25517	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1102	1093	0.01034	0.02301	0.00516	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1104	1103	0.01086	0.25650	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1104	1093	0.01034	0.02301	0.00516	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1105	1106	0.00767	0.23444	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1105	853	0.00776	0.02352	0.09581	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1107	1106	0.00767	0.23444	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1107	853	0.00776	0.02352	0.09581	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1108	1109	0.01380	0.29200	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1108	835	0.02273	0.05057	0.01836	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1110	1109	0.01530	0.28777	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1110	835	0.02274	0.05058	0.01825	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1111	1112	0.00389	0.32180	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1111	836	0.00366	0.01755	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1112	1113	0.04362	0.07557	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	1114	0.01048	0.20431	0.00396	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	1114	0.01067	0.20866	0.00447	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	1115	0.00739	0.27172	0.00011	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	1116	0.03171	0.07034	0.01539	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	1117	0.01600	0.03534	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	835	0.01944	0.04332	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	835	0.01991	0.04435	0.01005	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
844	1099	0.02948	0.06539	0.01430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1114	1115	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1114	1118	0.10657	0.21078	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1119	1120	0.00763	0.27444	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1119	1120	0.00752	0.28978	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1119	1121	0.01140	0.02945	0.00615	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1119	825	0.03120	0.08077	0.01680	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1122	1123	0.00764	0.23856	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1124	1123	0.00769	0.23778	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1116	1125	0.00881	0.25167	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1116	1125	0.00944	0.21667	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1125	1126	0.05089	0.10544	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1127	1128	0.00802	0.24233	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1127	824	0.00292	0.00995	0.00373	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1127	1129	0.00250	0.01351	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1130	1128	0.00706	0.25000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1131	1130	0.00031	0.00096	0.00042	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1131	824	0.00262	0.00899	0.00331	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1131	1132	0.01000	0.02227	0.00505	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1133	1134	0.00764	0.27778	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1135	1134	0.00759	0.27778	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1136	1137	0.00798	0.01778	0.00403	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
826	1138	0.01892	0.04148	0.03159	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
826	1139	0.03390	0.07546	0.01702	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
826	1137	0.00697	0.01553	0.00352	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
826	1140	0.00421	0.01511	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1141	1142	0.01774	0.03951	0.00896	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
826	1143	0.01770	0.03942	0.00894	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1141	826	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
826	1144	0.01625	0.28911	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1141	1145	0.01885	0.04131	0.03408	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1146	1133	0.01400	0.03488	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1146	1144	0.01620	0.28667	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1145	1147	0.00000	0.28000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1138	1147	0.01552	0.28889	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1093	1148	0.02100	0.27130	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1093	1148	0.02133	0.26660	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1149	1150	0.00859	0.24578	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1149	1151	0.00080	0.00491	0.09379	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1152	1153	0.00717	0.24644	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1152	837	0.01350	0.04712	0.01694	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1152	1154	0.00060	0.00231	0.05927	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1155	1150	0.00711	0.24867	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1155	837	0.01350	0.04712	0.01694	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1155	1156	0.00060	0.00231	0.05927	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1157	1153	0.00868	0.24611	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1157	1158	0.00080	0.00497	0.09573	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1159	1160	0.00330	0.31820	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1159	825	0.00411	0.00912	0.00445	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1161	1162	0.00394	0.32186	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1161	825	0.00064	0.00576	0.00212	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1161	1163	0.02869	0.07527	0.01512	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1160	1164	0.07742	0.19824	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1162	1165	0.09370	0.17155	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1121	1166	0.00719	0.27380	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1121	1166	0.00719	0.27380	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1121	1167	0.01729	0.04553	0.00921	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
825	1094	0.05105	0.14092	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
825	1168	0.01206	0.02675	0.00585	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
825	1169	0.00229	0.00508	0.00111	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
825	1095	0.01583	0.05144	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
825	1170	0.00768	0.03180	0.01269	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
836	1151	0.00294	0.02293	0.04144	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
836	1171	0.00493	0.02125	0.07334	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
836	1172	0.00513	0.02218	0.09889	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
836	1158	0.00295	0.02298	0.04279	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
836	250	0.00297	0.02361	0.02693	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
836	250	0.00280	0.02224	0.02643	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
837	1122	0.00274	0.00861	0.00377	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
837	1124	0.00274	0.00861	0.00377	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
837	248	0.00298	0.02366	0.03453	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
837	248	0.00280	0.02224	0.02643	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
837	1173	0.00710	0.03484	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
824	1174	0.01285	0.27231	0.00240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
824	1175	0.01073	0.02390	0.00542	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1174	1176	0.10853	0.20664	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1151	1177	0.00779	0.25122	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1171	1113	0.01192	0.20050	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1172	1113	0.01175	0.19883	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1158	1177	0.00794	0.24900	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1129	1178	0.00771	0.24333	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1129	1178	0.00782	0.24556	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1129	1132	0.00159	0.00476	0.10201	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1129	1132	0.00159	0.00476	0.10201	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1139	1179	0.01222	0.28556	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1139	1179	0.01204	0.28222	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1139	1090	0.00878	0.01955	0.00443	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1180	1181	0.00929	0.20367	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1086	1181	0.00942	0.20583	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1090	1180	0.00949	0.02115	0.00479	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1181	1182	0.20365	0.37813	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1183	1184	0.01403	0.28978	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1183	1184	0.01495	0.29777	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1183	1132	0.00752	0.01676	0.00380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1183	1088	0.02417	0.05384	0.01220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1132	1185	0.01039	0.28918	0.00136	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1132	1185	0.00934	0.21667	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1132	1185	0.00900	0.21250	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1132	1092	0.03164	0.07049	0.01598	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1186	1187	0.01652	0.17407	0.01900	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1186	1187	0.01259	0.23352	0.01810	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1188	1189	0.03504	0.09005	0.01940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1188	1187	0.01164	0.21356	0.01887	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1190	1096	0.00606	0.01350	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1190	1116	0.02586	0.05760	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1094	1191	0.01547	0.27644	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1094	1191	0.01511	0.26670	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1094	1191	0.01000	0.21267	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1192	853	0.02340	0.05160	0.01990	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1192	1193	0.02028	0.04467	0.01004	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1193	853	0.01362	0.02998	0.01381	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1189	1194	0.00694	0.20533	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1189	1194	0.00728	0.20267	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1163	1167	0.00040	0.00107	0.00021	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1163	1195	0.01410	0.28533	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1163	1195	0.01617	0.27289	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1163	1195	0.01385	0.26600	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1167	1170	0.00777	0.02875	0.01167	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1168	1165	0.00649	0.28111	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1196	1165	0.01245	0.28022	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1169	1196	0.00981	0.02175	0.00476	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1169	1197	0.03794	0.08451	0.01916	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1198	1186	0.00458	0.02328	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
848	1188	0.00458	0.02329	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1186	1199	0.04680	0.12064	0.02569	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1189	1199	0.01225	0.03119	0.00670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1198	1111	0.00337	0.01765	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1198	1173	0.00053	0.00364	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1173	1200	0.02708	0.69666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1173	1200	0.02734	0.71000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1173	1200	0.03372	0.69034	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1197	1176	0.01310	0.26177	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1175	1176	0.01257	0.26222	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1201	1202	0.01361	0.26511	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1203	1202	0.01394	0.26444	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1137	1201	0.00078	0.00175	0.00040	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1140	1135	0.00717	0.01821	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1140	1203	0.00073	0.00164	0.00037	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1154	1204	0.00779	0.88000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1154	1205	0.00779	0.88000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1156	1204	0.00779	0.88666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1156	1205	0.00779	0.88000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1117	1118	0.02223	0.34333	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1095	1206	0.00720	0.27267	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1095	1206	0.00719	0.27380	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
835	1207	0.01289	0.27511	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
835	1207	0.01319	0.26889	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
835	1208	0.01324	0.27111	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1208	1207	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1142	1209	0.01527	0.29333	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1143	1209	0.01452	0.27777	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1091	1210	0.00763	0.24000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1087	1210	0.00705	0.23978	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1211	1182	0.01406	0.28889	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1212	1182	0.01566	0.28089	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1092	1211	0.00090	0.00283	0.00124	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1088	1212	0.00090	0.00283	0.00124	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1170	1164	0.00716	0.27120	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1213	1099	0.00437	0.01527	0.00549	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1213	1126	0.01080	0.25433	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1100	1214	0.01120	0.19733	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1101	1214	0.01121	0.19833	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1215	820	0.03229	0.07480	0.03544	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1215	820	0.03224	0.07472	0.03527	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1215	1216	0.01058	0.20973	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1215	1216	0.00853	0.22817	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1215	1216	0.00746	0.24950	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1146	826	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
783	1217	0.00390	0.00065	0.02145	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
784	1218	0.00039	0.00065	0.02145	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1217	1219	0.01870	0.04148	0.00944	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1218	1219	0.01870	0.04148	0.00944	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1220	1219	0.02720	0.06140	0.01330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1221	1222	0.02670	0.06000	0.01300	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1223	1219	0.00822	0.01824	0.00410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1223	1219	0.00822	0.01824	0.00410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
960	1223	0.01587	0.05420	0.01870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
961	1223	0.01550	0.05440	0.01870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1224	1218	0.00510	0.01260	0.00400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1225	1217	0.00510	0.01260	0.00400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
881	1222	0.03060	0.06940	0.01520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1226	1227	0.00540	0.01200	0.00270	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
880	1226	0.04310	0.09545	0.05160	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
880	1228	0.04850	0.10745	0.05430	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1229	881	0.01635	0.03703	0.03260	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1230	880	0.01635	0.03703	0.03260	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
960	1231	0.00716	0.02658	0.02536	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
783	1232	0.00612	0.02104	0.02203	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
961	260	0.00801	0.02799	0.03395	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
784	260	0.00797	0.02820	0.01015	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1233	260	0.00036	0.00058	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1234	260	0.02189	0.04789	0.01030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1231	1235	0.00340	0.00540	0.20000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1232	1236	0.00340	0.00540	0.20000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
260	1236	0.01613	0.03592	0.00814	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1237	260	0.00806	0.01796	0.00407	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1238	1239	0.01919	0.04347	0.00941	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1240	1239	0.00348	0.00771	0.00160	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1241	1242	0.00387	0.00908	0.00219	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1243	1239	0.00039	0.00136	0.00049	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
799	1243	0.00744	0.02598	0.00934	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
799	1242	0.00744	0.02598	0.00934	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1237	1231	0.00081	0.00271	0.02890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1237	1244	0.00806	0.01796	0.00407	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1245	260	0.00020	0.00040	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1246	260	0.00020	0.00040	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1233	1247	0.00419	0.00457	0.15989	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1248	1246	0.00252	0.00394	0.09240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1249	1245	0.00252	0.00394	0.09240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1250	799	0.00672	0.02346	0.00844	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1250	800	0.00672	0.02346	0.00844	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1251	1250	0.00129	0.00286	0.00065	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1252	1250	0.00129	0.00286	0.00065	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1253	1223	0.00694	0.01527	0.00338	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1254	1223	0.00694	0.01527	0.00338	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
784	1255	0.00336	0.01098	0.00375	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
783	1256	0.00336	0.01098	0.00375	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1257	1258	0.01835	0.10191	0.01900	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1248	1257	0.00707	0.25000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1249	1257	0.00709	0.24444	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1241	1259	0.01435	0.26666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1240	1259	0.01435	0.27311	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1240	1260	0.02954	0.64666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1241	1260	0.02981	0.64200	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1245	1261	0.01089	0.25500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1233	1261	0.01085	0.25100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1246	1261	0.01083	0.27500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1247	1258	0.00730	0.27277	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1242	1262	0.01654	0.29000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1243	1262	0.01661	0.29177	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1232	1263	0.01432	0.28688	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1231	1263	0.01432	0.28688	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1236	1264	0.00700	0.25144	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1235	1264	0.00711	0.25166	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1244	1265	0.00824	0.25222	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1224	1266	0.03188	0.73333	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1224	1266	0.03167	0.72666	0.00400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1225	1266	0.03167	0.72666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1220	1267	0.00778	0.24222	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1221	1267	0.00781	0.25000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1228	1268	0.01703	0.33400	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1227	1268	0.01710	0.33800	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1228	1269	0.02755	0.70200	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1227	1269	0.02844	0.76000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1227	1270	0.02100	0.66700	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1228	1270	0.02100	0.66700	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1226	1271	0.01577	0.28660	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1222	1271	0.01563	0.28333	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1229	1272	0.00728	0.26666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1230	1272	0.00728	0.26666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
880	1273	0.00700	0.25810	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
880	1273	0.00700	0.25810	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
880	1273	0.00700	0.25810	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
784	1274	0.01333	0.33333	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
783	1274	0.01333	0.33333	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1255	1275	0.00700	0.26400	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1256	1275	0.00700	0.26400	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1219	1276	0.00900	0.26060	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1219	1276	0.00728	0.26666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1219	1276	0.00648	0.27644	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1223	1277	0.01567	0.28666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1223	1277	0.01557	0.28088	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1253	1278	0.01615	0.27977	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1253	1279	0.01615	0.27977	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1254	1279	0.01628	0.27977	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1238	1280	0.01130	0.02200	0.00425	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1234	1281	0.01130	0.02200	0.00425	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1238	1282	0.01097	0.24833	0.00000	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1234	1282	0.01078	0.24900	0.00000	9900.00	9900.00	9900.00	1.0988	0.00	1	-360.00	360.00;
1280	1283	0.01043	0.25700	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1281	1283	0.01040	0.25600	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1252	1284	0.00000	0.68000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1251	1285	0.02700	0.63300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1251	1286	0.02700	0.63300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1252	1285	0.02700	0.63300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1252	1286	0.02700	0.63300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1287	1288	0.00257	0.11586	0.00000	9900.00	9900.00	9900.00	1.0467	0.00	1	-360.00	360.00;
1287	1289	0.00257	0.11586	0.00000	9900.00	9900.00	9900.00	1.0467	0.00	1	-360.00	360.00;
1287	1290	0.00257	0.11586	0.00000	9900.00	9900.00	9900.00	1.0467	0.00	1	-360.00	360.00;
1291	1292	0.00371	0.00817	0.00614	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1293	713	0.00894	0.02131	0.00546	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1291	713	0.00558	0.01767	0.02370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1291	713	0.00558	0.01767	0.02370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1291	1294	0.00094	0.00442	0.07950	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1291	1295	0.00094	0.00442	0.07950	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
712	1296	0.02690	0.05980	0.09020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
712	1297	0.00296	0.00946	0.00470	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
712	1298	0.00296	0.00946	0.00470	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1299	1297	0.02220	0.04928	0.01122	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1299	1298	0.02220	0.04928	0.01122	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1300	713	0.01001	0.03091	0.03359	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1301	713	0.01018	0.03117	0.04382	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1299	1301	0.01264	0.02770	0.03772	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1299	1300	0.01262	0.02768	0.03696	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
712	1302	0.00646	0.01434	0.00326	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
712	1303	0.00646	0.01434	0.00326	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1299	1287	0.00137	0.00432	0.00184	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1287	1299	0.00137	0.00432	0.00184	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1287	1304	0.01757	0.03905	-0.00869	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1287	1305	0.01757	0.03905	-0.00869	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1305	1306	0.01656	0.03672	0.00752	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1304	1307	0.01656	0.03672	0.00752	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1304	1308	0.00268	0.00594	0.00122	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1305	1309	0.00268	0.00594	0.00122	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1293	1310	0.00766	0.27767	-0.00100	9900.00	9900.00	9900.00	1.0753	0.00	1	-360.00	360.00;
1292	1310	0.00760	0.27878	-0.00100	9900.00	9900.00	9900.00	1.0676	0.00	1	-360.00	360.00;
1291	1311	0.02300	0.32084	-0.00500	9900.00	9900.00	9900.00	1.0723	0.00	1	-360.00	360.00;
1291	1311	0.00000	0.27956	0.00000	9900.00	9900.00	9900.00	1.0715	0.00	1	-360.00	360.00;
1294	1312	0.00862	0.24362	-0.00140	9900.00	9900.00	9900.00	1.0723	0.00	1	-360.00	360.00;
1295	1312	0.00872	0.24384	-0.00169	9900.00	9900.00	9900.00	1.0723	0.00	1	-360.00	360.00;
1296	1313	0.00697	0.16890	-0.01580	9900.00	9900.00	9900.00	1.0657	0.00	1	-360.00	360.00;
1296	1314	0.02673	0.58340	-0.00300	9900.00	9900.00	9900.00	1.0662	0.00	1	-360.00	360.00;
1313	1315	0.00000	0.25000	0.00000	9900.00	9900.00	9900.00	0.9744	0.00	1	-360.00	360.00;
1297	1316	0.01055	0.20906	-0.00902	9900.00	9900.00	9900.00	1.0688	0.00	1	-360.00	360.00;
1298	1316	0.01055	0.21339	-0.00902	9900.00	9900.00	9900.00	1.0688	0.00	1	-360.00	360.00;
1300	1317	0.01079	0.24977	-0.00112	9900.00	9900.00	9900.00	1.0870	0.00	1	-360.00	360.00;
1301	1317	0.01081	0.24977	-0.00145	9900.00	9900.00	9900.00	1.0865	0.00	1	-360.00	360.00;
1302	1318	0.00972	0.24716	-0.00117	9900.00	9900.00	9900.00	1.0652	0.00	1	-360.00	360.00;
1303	1318	0.00976	0.24733	-0.00124	9900.00	9900.00	9900.00	1.0652	0.00	1	-360.00	360.00;
1299	1319	0.01053	0.21390	-0.00700	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1299	1319	0.01061	0.21290	-0.00700	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1299	1319	0.01007	0.21859	-0.00700	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1307	1320	0.01323	0.27777	-0.00550	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1306	1320	0.01323	0.27777	-0.00550	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1308	1321	0.00795	0.20000	0.00000	9900.00	9900.00	9900.00	1.0296	0.00	1	-360.00	360.00;
1309	1321	0.00795	0.20000	0.00000	9900.00	9900.00	9900.00	1.0296	0.00	1	-360.00	360.00;
1322	1323	0.00261	0.11724	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1322	1324	0.00261	0.11724	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1322	1325	0.00261	0.11724	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1326	1327	0.00066	0.03243	0.00000	9900.00	9900.00	9900.00	1.0169	0.00	1	-360.00	360.00;
909	1328	0.00349	0.01683	0.01857	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
770	1329	0.00351	0.01692	0.01859	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1330	1328	0.00713	0.03418	0.00875	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1331	1329	0.00709	0.03400	0.00870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1330	1332	0.01792	0.03973	0.00904	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1331	1333	0.01792	0.03973	0.00904	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1330	1334	0.00151	0.00340	0.00078	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1331	1335	0.00151	0.00340	0.00078	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1332	1336	0.00255	0.00548	0.01388	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1333	1337	0.00255	0.00548	0.01392	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1336	1338	0.00322	0.21080	0.00000	9900.00	9900.00	9900.00	0.9993	0.00	1	-360.00	360.00;
1337	1338	0.00327	0.21400	0.00000	9900.00	9900.00	9900.00	0.9992	0.00	1	-360.00	360.00;
1339	770	0.01387	0.06775	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1322	909	0.01448	0.06942	0.01777	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1339	1322	0.00054	0.00259	0.00066	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1332	1322	0.00057	0.00273	0.00070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1333	1322	0.00057	0.00273	0.00070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1340	1322	0.00182	0.00585	0.03940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1341	1322	0.00263	0.00765	0.00169	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1339	1342	0.00208	0.00348	0.01781	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1343	1344	0.00164	0.00364	0.00075	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1345	1346	0.00164	0.00364	0.00075	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1347	1345	0.01778	0.03961	0.00898	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1347	1343	0.01778	0.03944	0.00898	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1347	1348	0.01668	0.03767	0.00819	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1349	1348	0.00365	0.01149	0.00488	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1350	1349	0.01237	0.03199	0.02709	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1341	1351	0.00146	0.00234	0.09095	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1340	1350	0.00146	0.00234	0.09104	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1326	770	0.00743	0.02848	0.00643	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1326	907	0.00743	0.02848	0.00643	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1352	1353	0.03030	0.06720	0.01530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1354	1355	0.03030	0.06720	0.01530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1356	770	0.00383	0.01467	0.00331	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1357	907	0.00383	0.01467	0.00331	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1356	1326	0.00268	0.01283	0.00328	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1357	1326	0.00268	0.01283	0.00328	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1358	1357	0.01316	0.02919	0.00665	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1358	1356	0.01316	0.02919	0.00665	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
770	1346	0.02390	0.05261	0.03415	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
909	1344	0.02390	0.05261	0.03415	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
770	1354	0.03468	0.07695	0.01710	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
770	1352	0.03468	0.07700	0.02397	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1358	1359	0.00200	0.20720	0.00000	9900.00	9900.00	9900.00	1.0152	0.00	1	-360.00	360.00;
1358	1359	0.00200	0.20800	0.00000	9900.00	9900.00	9900.00	1.0152	0.00	1	-360.00	360.00;
1351	1360	0.00583	0.91980	0.00000	9900.00	9900.00	9900.00	0.9775	0.00	1	-360.00	360.00;
1351	1361	0.00583	0.89330	0.00000	9900.00	9900.00	9900.00	0.9781	0.00	1	-360.00	360.00;
1350	1360	0.00583	0.91980	0.00000	9900.00	9900.00	9900.00	1.0230	0.00	1	-360.00	360.00;
1350	1361	0.00583	0.89330	0.00000	9900.00	9900.00	9900.00	1.0223	0.00	1	-360.00	360.00;
1346	1362	0.01449	0.27111	-0.00108	9900.00	9900.00	9900.00	1.0895	0.00	1	-360.00	360.00;
1344	1362	0.01438	0.27444	-0.00108	9900.00	9900.00	9900.00	1.0918	0.00	1	-360.00	360.00;
1349	1363	0.01083	0.25550	-0.00069	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1349	1363	0.01083	0.25333	-0.00073	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1347	1364	0.00859	0.21333	-0.00300	9900.00	9900.00	9900.00	1.0952	0.00	1	-360.00	360.00;
1347	1364	0.00859	0.21333	-0.00300	9900.00	9900.00	9900.00	1.0952	0.00	1	-360.00	360.00;
1352	1365	0.01407	0.28444	-0.00300	9900.00	9900.00	9900.00	1.0881	0.00	1	-360.00	360.00;
1354	1365	0.01407	0.28444	-0.00300	9900.00	9900.00	9900.00	1.0887	0.00	1	-360.00	360.00;
1355	1366	0.01429	0.28444	-0.00126	9900.00	9900.00	9900.00	1.0893	0.00	1	-360.00	360.00;
1353	1366	0.01440	0.28444	-0.00120	9900.00	9900.00	9900.00	1.0891	0.00	1	-360.00	360.00;
1329	1367	0.00700	0.28066	0.00300	9900.00	9900.00	9900.00	0.9713	0.00	1	-360.00	360.00;
1328	1367	0.00680	0.27710	0.00300	9900.00	9900.00	9900.00	0.9839	0.00	1	-360.00	360.00;
1335	1368	0.01119	0.26620	0.00000	9900.00	9900.00	9900.00	0.9797	0.00	1	-360.00	360.00;
1334	1368	0.00677	0.27350	0.00000	9900.00	9900.00	9900.00	0.9851	0.00	1	-360.00	360.00;
1341	1369	0.00944	1.06330	0.00000	9900.00	9900.00	9900.00	1.0371	0.00	1	-360.00	360.00;
1342	1370	0.00414	0.83000	0.00000	9900.00	9900.00	9900.00	1.0287	0.00	1	-360.00	360.00;
1342	1370	0.00414	0.83000	0.00000	9900.00	9900.00	9900.00	1.0287	0.00	1	-360.00	360.00;
269	555	0.00158	0.08103	-0.00251	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
269	553	0.00112	0.08658	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
269	550	0.00162	0.08207	-0.00251	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
274	627	0.00375	0.11630	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
274	628	0.00379	0.11669	-0.00792	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
274	626	0.00373	0.11602	-0.00715	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
274	619	0.00375	0.11611	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1371	1372	0.00067	0.03111	0.00000	9900.00	9900.00	9900.00	0.9718	0.00	1	-360.00	360.00;
1371	971	0.00026	0.00096	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1373	972	0.00208	0.00471	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1373	1374	0.00582	0.24444	0.00000	9900.00	9900.00	9900.00	0.9502	0.00	1	-360.00	360.00;
1373	1375	0.00582	0.24444	0.00000	9900.00	9900.00	9900.00	0.9502	0.00	1	-360.00	360.00;
1373	1376	0.00542	0.24444	0.00000	9900.00	9900.00	9900.00	0.9500	0.00	1	-360.00	360.00;
1373	1377	0.00542	0.24444	0.00000	9900.00	9900.00	9900.00	0.9673	0.00	1	-360.00	360.00;
1373	1378	0.00512	0.16923	0.00000	9900.00	9900.00	9900.00	0.9655	0.00	1	-360.00	360.00;
1379	173	0.00154	0.08182	-0.00317	9900.00	9900.00	9900.00	1.0374	0.00	1	-360.00	360.00;
1379	19	0.00104	0.07958	-0.00317	9900.00	9900.00	9900.00	1.0284	0.00	1	-360.00	360.00;
1380	173	0.00106	0.07916	-0.00317	9900.00	9900.00	9900.00	1.0216	0.00	1	-360.00	360.00;
1381	19	0.00154	0.08182	0.00154	9900.00	9900.00	9900.00	1.0150	0.00	1	-360.00	360.00;
1380	262	0.00188	0.00415	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1381	262	0.00114	0.00410	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1382	1082	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1383	1082	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
777	1384	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
778	1385	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
245	1386	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1386	1387	0.00216	0.14970	0.00000	9900.00	9900.00	9900.00	1.0073	0.00	1	-360.00	360.00;
109	112	0.00000	0.01000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
800	405	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	1.0454	0.00	1	-360.00	360.00;
1388	1389	0.00155	0.01464	0.20356	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1388	567	0.00135	0.08332	0.00000	9900.00	9900.00	9900.00	0.9830	0.00	1	-360.00	360.00;
1390	393	0.00139	0.07915	-0.00317	9900.00	9900.00	9900.00	0.9809	0.00	1	-360.00	360.00;
562	854	0.00665	0.28292	-0.00362	9900.00	9900.00	9900.00	0.9656	0.00	1	-360.00	360.00;
1391	1392	0.00078	0.05211	0.00000	9900.00	9900.00	9900.00	1.0272	0.00	1	-360.00	360.00;
1391	1393	0.00078	0.05211	0.00000	9900.00	9900.00	9900.00	1.0272	0.00	1	-360.00	360.00;
1391	1394	0.00078	0.05211	0.00000	9900.00	9900.00	9900.00	0.9971	0.00	1	-360.00	360.00;
1391	1395	0.00078	0.05211	0.00000	9900.00	9900.00	9900.00	0.9971	0.00	1	-360.00	360.00;
1396	1397	0.00020	0.02010	0.00000	9900.00	9900.00	9900.00	0.9706	0.00	1	-360.00	360.00;
1396	1398	0.00020	0.02010	0.00000	9900.00	9900.00	9900.00	0.9706	0.00	1	-360.00	360.00;
1399	1400	0.00020	0.02045	0.00000	9900.00	9900.00	9900.00	1.0179	0.00	1	-360.00	360.00;
1399	1401	0.00022	0.02026	0.00000	9900.00	9900.00	9900.00	1.0161	0.00	1	-360.00	360.00;
1402	1403	0.00364	0.13333	0.00000	9900.00	9900.00	9900.00	1.0185	0.00	1	-360.00	360.00;
1404	1405	0.00000	0.34000	0.00000	9900.00	9900.00	9900.00	1.0488	0.00	1	-360.00	360.00;
1406	1407	0.00029	0.02971	0.00000	9900.00	9900.00	9900.00	1.0191	0.00	1	-360.00	360.00;
1406	1408	0.00029	0.02971	0.00000	9900.00	9900.00	9900.00	1.0191	0.00	1	-360.00	360.00;
1406	1409	0.00029	0.02956	0.00000	9900.00	9900.00	9900.00	1.0191	0.00	1	-360.00	360.00;
1406	1410	0.00030	0.02971	0.00000	9900.00	9900.00	9900.00	1.0185	0.00	1	-360.00	360.00;
1411	1412	0.00289	0.09152	0.00000	9900.00	9900.00	9900.00	1.0054	0.00	1	-360.00	360.00;
1411	1413	0.00289	0.09109	0.00000	9900.00	9900.00	9900.00	1.0055	0.00	1	-360.00	360.00;
1414	1415	0.00272	0.08913	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
1414	1416	0.00272	0.08913	0.00000	9900.00	9900.00	9900.00	1.0052	0.00	1	-360.00	360.00;
1417	1418	0.00207	0.04138	0.00000	9900.00	9900.00	9900.00	1.0050	0.00	1	-360.00	360.00;
1419	1420	0.00352	0.18680	0.00000	9900.00	9900.00	9900.00	1.0551	0.00	1	-360.00	360.00;
1421	1422	0.00354	0.18650	0.00000	9900.00	9900.00	9900.00	1.0550	0.00	1	-360.00	360.00;
1423	1424	0.01111	0.22220	0.00000	9900.00	9900.00	9900.00	1.0048	0.00	1	-360.00	360.00;
1425	1426	0.00461	0.09231	0.00000	9900.00	9900.00	9900.00	1.0045	0.00	1	-360.00	360.00;
1427	1428	0.00793	0.15870	0.00000	9900.00	9900.00	9900.00	1.0262	0.00	1	-360.00	360.00;
1429	1430	0.00565	0.11300	0.00000	9900.00	9900.00	9900.00	1.0034	0.00	1	-360.00	360.00;
1431	1432	0.03000	0.30000	0.00000	9900.00	9900.00	9900.00	1.0164	0.00	1	-360.00	360.00;
1433	1434	0.00238	0.04760	0.00000	9900.00	9900.00	9900.00	1.0062	0.00	1	-360.00	360.00;
1435	1436	0.00238	0.04760	0.00000	9900.00	9900.00	9900.00	1.0062	0.00	1	-360.00	360.00;
1437	1438	0.00238	0.04760	0.00000	9900.00	9900.00	9900.00	1.0062	0.00	1	-360.00	360.00;
1439	1440	0.01151	0.23020	0.00000	9900.00	9900.00	9900.00	1.0230	0.00	1	-360.00	360.00;
1075	1441	0.01535	0.03472	0.00754	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1076	1442	0.07065	0.15710	0.06225	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1076	1443	0.00510	0.01136	0.00258	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
443	1444	0.00009	0.00084	0.00594	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
311	1445	0.00230	0.02186	0.68932	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1446	1447	0.00047	0.00384	0.02605	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1448	1449	0.00047	0.00384	0.02605	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1450	1451	0.02183	0.04862	0.01635	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1452	1451	0.02182	0.04860	0.01543	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1453	1454	0.00700	0.01917	0.06235	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1455	1456	0.00103	0.00292	0.00410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1455	1456	0.00103	0.00292	0.00410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1456	1457	0.00028	0.00079	0.00111	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1456	1458	0.00031	0.00088	0.00123	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1459	1460	0.01072	0.02387	0.00541	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1461	1460	0.01072	0.02387	0.00541	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1462	1463	0.00024	0.00064	0.34500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1462	1464	0.00024	0.00064	0.34500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1462	1465	0.00078	0.00642	0.04351	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1462	1466	0.00100	0.00820	0.05560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1467	1468	0.00258	0.00584	0.00126	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1469	1470	0.00272	0.00607	0.00137	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1471	1470	0.00272	0.00607	0.00137	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1441	1472	0.01156	0.05698	0.01451	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1441	1472	0.01159	0.05712	0.02014	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1441	1473	0.00671	0.01486	0.00601	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1441	1474	0.00675	0.01490	0.00721	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1441	1443	0.01313	0.02925	0.00663	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1441	1443	0.01313	0.02925	0.00663	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1475	1476	0.00049	0.00065	0.20456	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1477	1478	0.00049	0.00065	0.20456	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1479	1476	0.00022	0.00184	0.01245	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1479	1478	0.00023	0.00186	0.01916	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1479	1480	0.00024	0.00321	0.02887	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1479	1481	0.00026	0.00219	0.01386	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1479	1482	0.00026	0.00219	0.01386	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1479	1406	0.00137	0.01917	0.17578	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1391	1483	0.00092	0.00756	0.05119	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1391	1484	0.00048	0.00396	0.02683	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1485	1486	0.00156	0.01313	0.36400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1487	1486	0.00156	0.01313	0.36400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1488	1447	0.00008	0.00062	0.00417	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1488	1449	0.00008	0.00062	0.00417	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1488	1489	0.00493	0.03571	0.13363	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1490	1491	0.01820	0.04072	0.00912	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1490	1492	0.00466	0.01037	0.00235	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1490	1493	0.04613	0.10275	0.02329	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1447	1494	0.00068	0.00561	0.03800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1449	1494	0.00068	0.00561	0.03800	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1495	1483	0.00046	0.00373	0.02527	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1495	1496	0.00017	0.00084	0.10273	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1495	1497	0.00017	0.00084	0.10273	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1495	1484	0.00089	0.00732	0.04966	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1495	1498	0.00211	0.01731	0.11739	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1495	1499	0.00277	0.02269	0.15382	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1500	1501	0.00012	0.00033	0.18030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1502	1503	0.00012	0.00033	0.18030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1472	1504	0.04447	0.10710	0.02180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1505	1506	0.00919	0.01970	0.07885	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1507	1508	0.00919	0.01970	0.07885	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1509	1510	0.00172	0.00390	0.00084	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1486	340	0.00022	0.00170	0.05155	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1486	279	0.00022	0.00170	0.05155	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1486	1396	0.00050	0.00653	0.64361	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1486	1396	0.00050	0.00653	0.64361	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1480	1511	0.00077	0.00632	0.04283	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1480	1406	0.00118	0.01637	0.14957	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1481	1512	0.00035	0.00300	0.01374	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1481	1465	0.00026	0.00219	0.01386	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1482	1513	0.00035	0.00300	0.01374	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1482	1465	0.00026	0.00219	0.01386	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1514	1465	0.00032	0.00260	0.01764	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1514	1466	0.00145	0.01192	0.08084	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1515	1444	0.00268	0.02551	0.17967	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1515	1516	0.00114	0.01079	0.07599	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1442	1517	0.02296	0.05087	0.03817	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1442	1451	0.03121	0.07037	0.01843	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1442	1451	0.03075	0.06943	0.01956	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1510	1468	0.00746	0.01655	0.00376	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1510	1518	0.03034	0.06759	0.01532	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1510	1518	0.03034	0.06759	0.01532	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1510	1519	0.03390	0.07678	0.01662	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1520	1518	0.02227	0.04961	0.01125	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1521	1518	0.02186	0.04849	0.01082	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1522	1523	0.00395	0.00271	0.06400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1522	1460	0.00266	0.00926	0.09204	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1524	1525	0.00395	0.00271	0.06400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1524	1460	0.00266	0.00926	0.09204	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1526	1527	0.01830	0.03880	0.00960	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1517	1443	0.05574	0.12417	0.02815	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1506	1528	0.00038	0.00061	0.02365	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1508	1528	0.00038	0.00061	0.02365	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1483	1484	0.00044	0.00360	0.02436	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1483	1503	0.00032	0.00136	0.37171	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1483	1501	0.00033	0.00138	0.37813	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1483	1529	0.00268	0.02196	0.14892	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1468	1530	0.03457	0.07702	0.01746	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1494	1531	0.00022	0.00156	0.03875	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1494	1532	0.00022	0.00156	0.03875	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1533	1445	0.00083	0.00678	0.20523	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1533	1399	0.00092	0.01063	0.37770	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1534	1460	0.01179	0.02570	0.02961	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1535	1460	0.01179	0.02570	0.02961	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1491	1530	0.01300	0.02896	0.00656	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1526	1491	0.00000	0.00001	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1530	1492	0.00978	0.02179	0.00494	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1511	1529	0.00079	0.00646	0.04380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1536	1529	0.00079	0.00646	0.04380	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1537	1538	0.00032	0.00103	0.30572	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1537	1484	0.00044	0.00340	0.06693	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1539	1540	0.00032	0.00103	0.30572	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1539	1484	0.00044	0.00340	0.06693	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1541	1529	0.00037	0.00066	0.20400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1542	1529	0.00037	0.00066	0.20400	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1543	1470	0.00209	0.00349	0.12200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1544	1470	0.00209	0.00349	0.12200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1545	1445	0.00176	0.01446	0.43893	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1545	1396	0.00077	0.00998	0.78212	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1546	1396	0.00077	0.00997	0.77106	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1465	1529	0.00061	0.00504	0.03418	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1465	1547	0.00097	0.00922	0.06490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1445	1548	0.00151	0.01613	0.59296	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1549	1550	0.00057	0.00466	0.00726	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1549	1551	0.00152	0.00239	0.06934	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1552	1553	0.00152	0.00239	0.06934	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1552	1554	0.00092	0.00746	0.01162	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1550	1555	0.00677	0.01419	0.14361	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1550	1556	0.00762	0.01460	0.07938	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1550	1557	0.00149	0.01194	0.02405	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1558	1493	0.00544	0.02682	0.00683	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1559	1493	0.00544	0.02682	0.00683	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1560	1548	0.00019	0.00269	0.10764	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1560	1561	0.00055	0.00524	0.17916	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1562	1563	0.00120	0.00559	0.00684	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1562	1493	0.00166	0.00816	0.00208	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1564	1565	0.00121	0.00561	0.00730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1564	1493	0.00166	0.00816	0.00208	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1555	1566	0.01767	0.03937	0.00893	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1553	1567	0.00240	0.00275	0.06200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1551	1568	0.00240	0.00275	0.06200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1399	1548	0.00103	0.01129	0.42603	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1399	1548	0.00098	0.01114	0.42731	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1399	1569	0.00062	0.00602	0.18950	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1570	1571	0.00624	0.02926	0.07806	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1570	1572	0.00003	0.00016	0.00396	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1573	1574	0.00459	0.02110	0.07598	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1573	1572	0.00003	0.00016	0.00264	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1575	1576	0.00533	0.02629	0.00670	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1575	1577	0.00368	0.01813	0.00462	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1575	1572	0.00052	0.00365	0.12940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1576	1578	0.00736	0.03039	0.00743	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1571	1578	0.00736	0.03039	0.00743	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1466	1579	0.00130	0.01028	0.07118	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1554	1580	0.00047	0.00380	0.00138	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1554	1493	0.00184	0.01469	0.00534	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1557	1581	0.00047	0.00380	0.00138	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1557	1493	0.00184	0.01469	0.00534	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1582	1566	0.00760	0.01692	0.00384	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1583	1566	0.00760	0.01692	0.00384	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1498	1499	0.00072	0.00591	0.04010	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1584	1585	0.00017	0.00047	0.00066	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1584	1585	0.00012	0.00035	0.00049	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1586	1587	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1586	1588	0.00020	0.00162	0.01097	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1586	1589	0.00021	0.00164	0.02199	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1586	1590	0.00181	0.01495	0.13007	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1586	1579	0.00090	0.00738	0.05002	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1587	1406	0.00215	0.02073	0.18358	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1587	1579	0.00090	0.00738	0.05002	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1588	1591	0.00017	0.00056	0.12236	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1589	1592	0.00014	0.00049	0.10691	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1593	1594	0.00556	0.01429	0.10500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1593	1595	0.00791	0.03901	0.00994	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1596	1597	0.00556	0.01429	0.10500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1596	1595	0.01184	0.03906	0.00950	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1598	1595	0.00307	0.01508	0.01304	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1598	1595	0.00303	0.01491	0.00644	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1590	1406	0.00073	0.00915	0.07916	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1599	1595	0.00470	0.02318	0.00591	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1600	1595	0.00842	0.01852	0.00515	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1601	1602	0.01337	0.02979	0.00675	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1603	1604	0.01337	0.02979	0.00675	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1605	1606	0.00382	0.02131	0.00542	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1605	1607	0.03212	0.07155	0.01622	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1608	1609	0.00776	0.01726	0.00574	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1608	1610	0.00579	0.02408	0.00580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1611	1612	0.00776	0.01726	0.00574	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1611	1610	0.00579	0.02408	0.00580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1402	1613	0.00031	0.00498	0.01935	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1404	1607	0.00031	0.00498	0.01935	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1614	1615	0.01014	0.02259	0.00512	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1614	1610	0.00074	0.00243	0.00716	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1614	1610	0.00078	0.00328	0.00647	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1614	1607	0.00718	0.01600	0.00363	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1614	1607	0.00718	0.01600	0.00363	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1616	1617	0.00061	0.00496	0.03311	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1616	1618	0.00060	0.00530	0.03370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1499	1619	0.00022	0.00189	0.06115	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1499	1620	0.00022	0.00185	0.04465	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1406	1619	0.00005	0.01935	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1406	1620	0.00005	0.01935	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1499	1621	0.00050	0.00430	0.07180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1499	1622	0.00050	0.00430	0.02930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1623	1602	0.00218	0.00486	0.00110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1624	1604	0.00223	0.00496	0.00250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1602	1615	0.00896	0.01995	0.00452	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1604	1607	0.01866	0.04157	0.00942	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1406	1625	0.00132	0.01078	0.09002	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1626	1610	0.00048	0.00063	0.02012	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1627	1610	0.00044	0.00057	0.01826	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1625	1628	0.00027	0.00217	0.01447	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1628	1629	0.00027	0.00217	0.01447	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1629	1617	0.00015	0.00123	0.00819	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1615	1613	0.00971	0.02162	0.00490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1606	1630	0.00086	0.00426	0.00108	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1606	1595	0.00464	0.02587	0.00658	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1631	1632	0.00088	0.00431	0.00289	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1631	1595	0.00464	0.02587	0.00658	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1631	1613	0.03594	0.09286	0.02164	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1617	1633	0.00110	0.00930	0.05900	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1411	1634	0.00000	0.00326	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1414	1635	0.00000	0.00435	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1634	1636	0.00040	0.00360	0.04140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1635	1636	0.00040	0.00360	0.04140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1636	1579	0.00390	0.03300	0.20260	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1636	1579	0.00390	0.03300	0.20260	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1637	1579	0.00012	0.00106	0.03877	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1638	1579	0.00012	0.00098	0.00667	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1639	1640	0.00133	0.00190	0.08531	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1639	1641	0.00211	0.00376	0.15200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1639	1642	0.00131	0.00187	0.08407	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1643	1644	0.00180	0.00400	0.00080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1643	1645	0.00500	0.01150	0.00240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1643	1642	0.03574	0.07946	0.02476	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1646	1647	0.00170	0.00400	0.00080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1646	1648	0.00510	0.01170	0.00250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1646	1642	0.03596	0.07940	0.02306	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1649	1650	0.01540	0.03520	0.00750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1649	1642	0.02545	0.05650	0.02089	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1651	1642	0.00334	0.00647	0.08017	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1652	1642	0.00115	0.00199	0.08020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1653	1642	0.00115	0.00199	0.08020	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1654	1642	0.00563	0.01057	0.24347	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1655	1656	0.02770	0.06330	0.01340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1655	1642	0.01499	0.03056	0.01185	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1644	1657	0.00230	0.00390	0.00080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1647	1658	0.00230	0.00390	0.00080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1659	1547	0.00042	0.00352	0.01611	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1659	1516	0.00042	0.00352	0.01611	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1660	1595	0.02190	0.05010	0.01070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1661	1595	0.02180	0.04970	0.01060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1662	1663	0.47853	0.53614	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1664	1665	0.13531	0.23274	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1664	1666	0.33320	0.58408	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1664	1429	0.06350	0.17010	0.02072	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1664	1431	0.11708	0.24105	0.02549	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1664	1431	0.11708	0.24105	0.02549	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1667	1423	0.07980	0.21160	0.01920	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1425	1668	0.04560	0.12090	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1669	1670	0.38250	0.67050	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1671	1427	0.09741	0.20055	0.02121	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1672	1511	0.00047	0.00260	0.16299	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1673	1536	0.00047	0.00260	0.16299	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1406	1617	0.00146	0.01200	0.09431	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1514	1674	0.00032	0.00094	0.23663	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1675	1439	0.07926	0.19248	0.02299	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1466	1676	0.00001	0.00003	0.01492	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1493	1677	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1678	1679	0.36620	0.60425	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1446	1680	0.00487	0.19250	0.00000	9900.00	9900.00	9900.00	0.9572	0.00	1	-360.00	360.00;
1448	1680	0.00433	0.19166	0.00000	9900.00	9900.00	9900.00	0.9572	0.00	1	-360.00	360.00;
1450	1662	0.02133	0.33333	0.00000	9900.00	9900.00	9900.00	0.9792	0.00	1	-360.00	360.00;
1450	1681	0.00455	0.56012	0.00000	9900.00	9900.00	9900.00	1.0222	0.00	1	-360.00	360.00;
1452	1662	0.00788	0.26555	0.00000	9900.00	9900.00	9900.00	0.9762	0.00	1	-360.00	360.00;
1452	1682	0.00455	0.56012	0.00000	9900.00	9900.00	9900.00	1.0213	0.00	1	-360.00	360.00;
1453	1419	0.00352	0.18680	0.00000	9900.00	9900.00	9900.00	1.0429	0.00	1	-360.00	360.00;
1453	1421	0.00354	0.18650	0.00000	9900.00	9900.00	9900.00	1.0429	0.00	1	-360.00	360.00;
1455	1683	0.00000	0.10000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1459	1684	0.00681	0.27777	0.00000	9900.00	9900.00	9900.00	0.9701	0.00	1	-360.00	360.00;
1461	1684	0.00681	0.27777	0.00000	9900.00	9900.00	9900.00	0.9701	0.00	1	-360.00	360.00;
1467	1685	0.04462	0.75133	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1469	1686	0.01015	0.25900	0.00000	9900.00	9900.00	9900.00	0.9771	0.00	1	-360.00	360.00;
1469	1687	0.00500	0.58700	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1471	1686	0.01016	0.25633	0.00000	9900.00	9900.00	9900.00	0.9771	0.00	1	-360.00	360.00;
1471	1688	0.00500	0.58700	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1441	1664	0.00619	0.23777	0.00000	9900.00	9900.00	9900.00	0.9471	0.00	1	-360.00	360.00;
1441	1664	0.00619	0.23777	0.00000	9900.00	9900.00	9900.00	0.9471	0.00	1	-360.00	360.00;
1475	1689	0.00487	0.18166	0.00000	9900.00	9900.00	9900.00	0.9708	0.00	1	-360.00	360.00;
1477	1689	0.00487	0.20666	0.00000	9900.00	9900.00	9900.00	0.9710	0.00	1	-360.00	360.00;
1479	1690	0.00492	0.20000	0.00000	9900.00	9900.00	9900.00	0.9798	0.00	1	-360.00	360.00;
1479	1690	0.00472	0.20208	0.00000	9900.00	9900.00	9900.00	0.9799	0.00	1	-360.00	360.00;
1391	1485	0.00014	0.01600	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1391	1487	0.00013	0.01600	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1391	1691	0.00481	0.18541	0.00000	9900.00	9900.00	9900.00	0.9916	0.00	1	-360.00	360.00;
1391	1691	0.00479	0.18708	0.00000	9900.00	9900.00	9900.00	0.9915	0.00	1	-360.00	360.00;
1492	1488	0.00172	0.08667	0.00000	9900.00	9900.00	9900.00	0.8968	0.00	1	-360.00	360.00;
1492	1488	0.00345	0.12916	0.00000	9900.00	9900.00	9900.00	0.8974	0.00	1	-360.00	360.00;
1460	1495	0.00115	0.08450	0.00000	9900.00	9900.00	9900.00	1.0193	0.00	1	-360.00	360.00;
1460	1495	0.00121	0.08475	0.00000	9900.00	9900.00	9900.00	1.0193	0.00	1	-360.00	360.00;
1470	1476	0.00165	0.08750	0.00000	9900.00	9900.00	9900.00	1.0046	0.00	1	-360.00	360.00;
1470	1478	0.00165	0.08750	0.00000	9900.00	9900.00	9900.00	1.0046	0.00	1	-360.00	360.00;
1500	1692	0.00442	0.19291	0.00000	9900.00	9900.00	9900.00	0.9711	0.00	1	-360.00	360.00;
1502	1692	0.00494	0.19291	0.00000	9900.00	9900.00	9900.00	0.9713	0.00	1	-360.00	360.00;
1472	1667	0.00367	0.11728	0.00000	9900.00	9900.00	9900.00	0.9601	0.00	1	-360.00	360.00;
1472	1667	0.00375	0.11794	0.00000	9900.00	9900.00	9900.00	0.9603	0.00	1	-360.00	360.00;
1472	1693	0.00766	0.20566	0.00000	9900.00	9900.00	9900.00	0.9339	0.00	1	-360.00	360.00;
1472	1694	0.05333	0.68333	0.00000	9900.00	9900.00	9900.00	0.9307	0.00	1	-360.00	360.00;
1472	1694	0.05333	0.79000	0.00000	9900.00	9900.00	9900.00	0.9289	0.00	1	-360.00	360.00;
1505	1668	0.00807	0.21500	0.00000	9900.00	9900.00	9900.00	1.0154	0.00	1	-360.00	360.00;
1507	1668	0.00807	0.21500	0.00000	9900.00	9900.00	9900.00	1.0154	0.00	1	-360.00	360.00;
1509	1695	0.04151	0.75000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1473	1696	0.00338	0.34075	0.00000	9900.00	9900.00	9900.00	0.9956	0.00	1	-360.00	360.00;
1474	1697	0.01556	0.26861	0.00000	9900.00	9900.00	9900.00	0.9791	0.00	1	-360.00	360.00;
1451	1486	0.00110	0.09796	0.00000	9900.00	9900.00	9900.00	1.0384	0.00	1	-360.00	360.00;
1451	1486	0.00110	0.09796	0.00000	9900.00	9900.00	9900.00	1.0384	0.00	1	-360.00	360.00;
1480	1698	0.00487	0.18750	0.00000	9900.00	9900.00	9900.00	0.9772	0.00	1	-360.00	360.00;
1480	1698	0.00306	0.18072	0.00000	9900.00	9900.00	9900.00	0.9777	0.00	1	-360.00	360.00;
1512	1699	0.00303	0.17922	0.00000	9900.00	9900.00	9900.00	0.9817	0.00	1	-360.00	360.00;
1513	1699	0.00303	0.17844	0.00000	9900.00	9900.00	9900.00	0.9817	0.00	1	-360.00	360.00;
1514	1700	0.00495	0.24333	0.00000	9900.00	9900.00	9900.00	0.9865	0.00	1	-360.00	360.00;
1514	1700	0.00477	0.24250	0.00000	9900.00	9900.00	9900.00	0.9866	0.00	1	-360.00	360.00;
1515	1701	0.00000	0.34070	0.00000	9900.00	9900.00	9900.00	1.0214	0.00	1	-360.00	360.00;
1515	1702	0.00000	0.34070	0.00000	9900.00	9900.00	9900.00	1.0214	0.00	1	-360.00	360.00;
1442	1703	0.01194	0.28266	0.00000	9900.00	9900.00	9900.00	0.9581	0.00	1	-360.00	360.00;
1442	1703	0.01573	0.28666	0.00000	9900.00	9900.00	9900.00	0.9610	0.00	1	-360.00	360.00;
1463	1704	0.00496	0.18458	0.00000	9900.00	9900.00	9900.00	0.9851	0.00	1	-360.00	360.00;
1464	1704	0.00487	0.18341	0.00000	9900.00	9900.00	9900.00	0.9851	0.00	1	-360.00	360.00;
1510	1705	0.02389	0.72666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1520	1669	0.00961	0.24533	0.00000	9900.00	9900.00	9900.00	0.9641	0.00	1	-360.00	360.00;
1521	1669	0.01069	0.25083	0.00000	9900.00	9900.00	9900.00	0.9641	0.00	1	-360.00	360.00;
1522	1706	0.00917	0.21916	0.00000	9900.00	9900.00	9900.00	0.9882	0.00	1	-360.00	360.00;
1524	1706	0.00911	0.21950	0.00000	9900.00	9900.00	9900.00	0.9882	0.00	1	-360.00	360.00;
1443	1444	0.00157	0.08750	0.00000	9900.00	9900.00	9900.00	0.9169	0.00	1	-360.00	360.00;
1443	1444	0.00128	0.08479	0.00000	9900.00	9900.00	9900.00	0.9202	0.00	1	-360.00	360.00;
1527	1417	0.00438	0.13300	0.00000	9900.00	9900.00	9900.00	0.9210	0.00	1	-360.00	360.00;
1517	1707	0.01028	0.25633	0.00000	9900.00	9900.00	9900.00	0.9471	0.00	1	-360.00	360.00;
1517	1707	0.01014	0.25900	0.00000	9900.00	9900.00	9900.00	0.9469	0.00	1	-360.00	360.00;
1506	1708	0.00000	0.55000	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1508	1709	0.00000	0.55000	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1483	1710	0.00482	0.20250	0.00000	9900.00	9900.00	9900.00	0.9756	0.00	1	-360.00	360.00;
1483	1710	0.00494	0.20250	0.00000	9900.00	9900.00	9900.00	0.9757	0.00	1	-360.00	360.00;
1468	1711	0.02900	0.71666	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1494	1533	0.00018	0.01607	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1494	1533	0.00013	0.01665	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1494	1712	0.00501	0.24016	0.00000	9900.00	9900.00	9900.00	0.9680	0.00	1	-360.00	360.00;
1494	1712	0.00482	0.24166	0.00000	9900.00	9900.00	9900.00	0.9680	0.00	1	-360.00	360.00;
1531	1713	0.00493	0.18500	0.00000	9900.00	9900.00	9900.00	0.9453	0.00	1	-360.00	360.00;
1532	1713	0.00498	0.18500	0.00000	9900.00	9900.00	9900.00	0.9453	0.00	1	-360.00	360.00;
1534	1714	0.00735	0.29666	0.00000	9900.00	9900.00	9900.00	0.9626	0.00	1	-360.00	360.00;
1535	1714	0.00731	0.28777	0.00000	9900.00	9900.00	9900.00	0.9628	0.00	1	-360.00	360.00;
1491	1715	0.01840	0.33333	0.00000	9900.00	9900.00	9900.00	0.9012	0.00	1	-360.00	360.00;
1491	1715	0.01840	0.34366	0.00000	9900.00	9900.00	9900.00	0.9012	0.00	1	-360.00	360.00;
1511	1716	0.00486	0.18250	0.00000	9900.00	9900.00	9900.00	0.9629	0.00	1	-360.00	360.00;
1536	1716	0.00486	0.18166	0.00000	9900.00	9900.00	9900.00	0.9933	0.00	1	-360.00	360.00;
1518	1670	0.03207	0.46250	0.00000	9900.00	9900.00	9900.00	0.9496	0.00	1	-360.00	360.00;
1537	1717	0.00500	0.19278	0.00000	9900.00	9900.00	9900.00	0.9764	0.00	1	-360.00	360.00;
1537	1718	0.00000	0.33330	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1539	1717	0.00303	0.17844	0.00000	9900.00	9900.00	9900.00	0.9753	0.00	1	-360.00	360.00;
1539	1719	0.00000	0.33330	0.00000	9900.00	9900.00	9900.00	1.0242	0.00	1	-360.00	360.00;
1541	1720	0.00482	0.24133	0.00000	9900.00	9900.00	9900.00	0.9938	0.00	1	-360.00	360.00;
1542	1720	0.00482	0.24133	0.00000	9900.00	9900.00	9900.00	0.9938	0.00	1	-360.00	360.00;
1543	1721	0.00884	0.21566	0.00000	9900.00	9900.00	9900.00	0.9916	0.00	1	-360.00	360.00;
1543	1722	0.00300	0.33480	0.00000	9900.00	9900.00	9900.00	1.0249	0.00	1	-360.00	360.00;
1544	1721	0.00877	0.21250	0.00000	9900.00	9900.00	9900.00	0.9916	0.00	1	-360.00	360.00;
1544	1723	0.00300	0.33480	0.00000	9900.00	9900.00	9900.00	1.0249	0.00	1	-360.00	360.00;
1538	1724	0.00466	0.20000	0.00000	9900.00	9900.00	9900.00	0.9808	0.00	1	-360.00	360.00;
1540	1724	0.00493	0.20000	0.00000	9900.00	9900.00	9900.00	0.9810	0.00	1	-360.00	360.00;
1496	1725	0.00503	0.18916	0.00000	9900.00	9900.00	9900.00	0.9758	0.00	1	-360.00	360.00;
1497	1725	0.00487	0.18750	0.00000	9900.00	9900.00	9900.00	0.9758	0.00	1	-360.00	360.00;
1484	1546	0.00013	0.01600	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1465	1445	0.00018	0.01706	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1465	1726	0.00472	0.20250	0.00000	9900.00	9900.00	9900.00	0.9843	0.00	1	-360.00	360.00;
1465	1726	0.00492	0.20000	0.00000	9900.00	9900.00	9900.00	0.9842	0.00	1	-360.00	360.00;
1523	1727	0.00958	0.20700	0.00000	9900.00	9900.00	9900.00	0.9930	0.00	1	-360.00	360.00;
1525	1727	0.00958	0.20283	0.00000	9900.00	9900.00	9900.00	0.9930	0.00	1	-360.00	360.00;
1519	1728	0.01683	0.33992	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1519	1728	0.01672	0.34092	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1528	1396	0.00167	0.08333	0.00000	9900.00	9900.00	9900.00	0.9996	0.00	1	-360.00	360.00;
1528	1396	0.00169	0.08333	0.00000	9900.00	9900.00	9900.00	0.9997	0.00	1	-360.00	360.00;
1503	1729	0.00524	0.20166	0.00000	9900.00	9900.00	9900.00	0.9836	0.00	1	-360.00	360.00;
1501	1729	0.00433	0.19833	0.00000	9900.00	9900.00	9900.00	0.9835	0.00	1	-360.00	360.00;
1454	1529	0.00130	0.08888	0.00000	9900.00	9900.00	9900.00	0.9561	0.00	1	-360.00	360.00;
1529	1730	0.00438	0.19166	0.00000	9900.00	9900.00	9900.00	0.9831	0.00	1	-360.00	360.00;
1529	1730	0.00489	0.18333	0.00000	9900.00	9900.00	9900.00	0.9830	0.00	1	-360.00	360.00;
1529	1731	0.00000	0.29900	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1529	1732	0.00000	0.29900	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1550	1733	0.00728	0.26666	0.00000	9900.00	9900.00	9900.00	0.9241	0.00	1	-360.00	360.00;
1550	1733	0.00728	0.26666	0.00000	9900.00	9900.00	9900.00	0.9241	0.00	1	-360.00	360.00;
1558	1734	0.00919	0.19966	0.00000	9900.00	9900.00	9900.00	0.9122	0.00	1	-360.00	360.00;
1558	1735	0.00919	0.22000	0.00000	9900.00	9900.00	9900.00	0.9134	0.00	1	-360.00	360.00;
1559	1734	0.00931	0.19966	0.00000	9900.00	9900.00	9900.00	0.9122	0.00	1	-360.00	360.00;
1559	1735	0.00931	0.22000	0.00000	9900.00	9900.00	9900.00	0.9134	0.00	1	-360.00	360.00;
1566	1560	0.00134	0.08375	0.00000	9900.00	9900.00	9900.00	1.0562	0.00	1	-360.00	360.00;
1566	1560	0.00134	0.08375	0.00000	9900.00	9900.00	9900.00	1.0562	0.00	1	-360.00	360.00;
1562	1736	0.00914	0.19833	0.00000	9900.00	9900.00	9900.00	0.9133	0.00	1	-360.00	360.00;
1564	1736	0.00914	0.20000	0.00000	9900.00	9900.00	9900.00	0.9133	0.00	1	-360.00	360.00;
1555	1737	0.01840	0.34366	0.00000	9900.00	9900.00	9900.00	0.9227	0.00	1	-360.00	360.00;
1556	1737	0.01778	0.33500	0.00000	9900.00	9900.00	9900.00	0.9477	0.00	1	-360.00	360.00;
1553	1738	0.01000	0.20366	0.00000	9900.00	9900.00	9900.00	0.9231	0.00	1	-360.00	360.00;
1551	1738	0.00989	0.20416	0.00000	9900.00	9900.00	9900.00	0.9185	0.00	1	-360.00	360.00;
1567	1739	0.00981	0.20483	0.00000	9900.00	9900.00	9900.00	0.9182	0.00	1	-360.00	360.00;
1568	1739	0.00981	0.20750	0.00000	9900.00	9900.00	9900.00	0.9147	0.00	1	-360.00	360.00;
1572	1399	0.00112	0.09347	0.00000	9900.00	9900.00	9900.00	0.9940	0.00	1	-360.00	360.00;
1572	1399	0.00112	0.09472	0.00000	9900.00	9900.00	9900.00	0.9939	0.00	1	-360.00	360.00;
1570	1740	0.00789	0.16433	0.00000	9900.00	9900.00	9900.00	0.9977	0.00	1	-360.00	360.00;
1573	1740	0.00804	0.16583	0.00000	9900.00	9900.00	9900.00	0.9977	0.00	1	-360.00	360.00;
1563	1741	0.00946	0.21833	0.00000	9900.00	9900.00	9900.00	0.9083	0.00	1	-360.00	360.00;
1565	1741	0.00946	0.21833	0.00000	9900.00	9900.00	9900.00	0.9083	0.00	1	-360.00	360.00;
1576	1742	0.00697	0.27711	0.00000	9900.00	9900.00	9900.00	0.9855	0.00	1	-360.00	360.00;
1571	1742	0.00697	0.27711	0.00000	9900.00	9900.00	9900.00	0.9832	0.00	1	-360.00	360.00;
1493	1466	0.00151	0.08479	0.00000	9900.00	9900.00	9900.00	0.8676	0.00	1	-360.00	360.00;
1493	1466	0.00146	0.08521	0.00000	9900.00	9900.00	9900.00	0.8673	0.00	1	-360.00	360.00;
1580	1743	0.00751	0.20633	0.00000	9900.00	9900.00	9900.00	0.9200	0.00	1	-360.00	360.00;
1581	1743	0.00774	0.20366	0.00000	9900.00	9900.00	9900.00	0.9160	0.00	1	-360.00	360.00;
1577	1678	0.00944	0.24466	0.00000	9900.00	9900.00	9900.00	1.0066	0.00	1	-360.00	360.00;
1577	1679	0.00954	0.21166	0.00000	9900.00	9900.00	9900.00	0.9914	0.00	1	-360.00	360.00;
1577	1744	0.00800	0.56000	0.00000	9900.00	9900.00	9900.00	1.0243	0.00	1	-360.00	360.00;
1574	1678	0.00944	0.24466	0.00000	9900.00	9900.00	9900.00	1.0050	0.00	1	-360.00	360.00;
1574	1679	0.00968	0.21433	0.00000	9900.00	9900.00	9900.00	0.9900	0.00	1	-360.00	360.00;
1574	1745	0.00800	0.56000	0.00000	9900.00	9900.00	9900.00	1.0244	0.00	1	-360.00	360.00;
1582	1746	0.00728	0.26666	0.00000	9900.00	9900.00	9900.00	0.9807	0.00	1	-360.00	360.00;
1583	1746	0.00728	0.26666	0.00000	9900.00	9900.00	9900.00	0.9807	0.00	1	-360.00	360.00;
1498	1457	0.00527	0.18750	0.00000	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1498	1458	0.00307	0.18822	0.00000	9900.00	9900.00	9900.00	1.1000	0.00	1	-360.00	360.00;
1498	1585	0.00478	0.25166	0.00000	9900.00	9900.00	9900.00	0.9295	0.00	1	-360.00	360.00;
1498	1585	0.00478	0.25250	0.00000	9900.00	9900.00	9900.00	0.9294	0.00	1	-360.00	360.00;
1588	1747	0.00370	0.18333	0.00000	9900.00	9900.00	9900.00	0.9755	0.00	1	-360.00	360.00;
1589	1747	0.00370	0.18400	0.00000	9900.00	9900.00	9900.00	0.9755	0.00	1	-360.00	360.00;
1591	1748	0.00489	0.18258	0.00000	9900.00	9900.00	9900.00	0.9735	0.00	1	-360.00	360.00;
1592	1748	0.00491	0.18333	0.00000	9900.00	9900.00	9900.00	0.9735	0.00	1	-360.00	360.00;
1593	1749	0.00741	0.27044	0.00000	9900.00	9900.00	9900.00	0.8879	0.00	1	-360.00	360.00;
1596	1749	0.00741	0.27233	0.00000	9900.00	9900.00	9900.00	0.8890	0.00	1	-360.00	360.00;
1598	1750	0.00783	0.20666	0.00000	9900.00	9900.00	9900.00	0.9022	0.00	1	-360.00	360.00;
1598	1750	0.00774	0.20750	0.00000	9900.00	9900.00	9900.00	0.9021	0.00	1	-360.00	360.00;
1595	1590	0.00156	0.08946	0.00000	9900.00	9900.00	9900.00	0.9248	0.00	1	-360.00	360.00;
1595	1590	0.00156	0.08946	0.00000	9900.00	9900.00	9900.00	0.9248	0.00	1	-360.00	360.00;
1599	1751	0.00741	0.29333	0.00000	9900.00	9900.00	9900.00	0.8939	0.00	1	-360.00	360.00;
1600	1751	0.00741	0.27111	0.00000	9900.00	9900.00	9900.00	0.8979	0.00	1	-360.00	360.00;
1601	1752	0.00939	0.19900	0.00000	9900.00	9900.00	9900.00	0.9167	0.00	1	-360.00	360.00;
1603	1752	0.00942	0.19900	0.00000	9900.00	9900.00	9900.00	0.9178	0.00	1	-360.00	360.00;
1605	1675	0.00740	0.29667	0.00000	9900.00	9900.00	9900.00	0.9495	0.00	1	-360.00	360.00;
1605	1675	0.00728	0.29444	0.00000	9900.00	9900.00	9900.00	0.9495	0.00	1	-360.00	360.00;
1594	1753	0.00527	0.27333	0.00000	9900.00	9900.00	9900.00	0.9091	0.00	1	-360.00	360.00;
1597	1753	0.00523	0.27333	0.00000	9900.00	9900.00	9900.00	0.9092	0.00	1	-360.00	360.00;
1608	1754	0.00738	0.24722	0.00000	9900.00	9900.00	9900.00	0.9448	0.00	1	-360.00	360.00;
1611	1754	0.00738	0.24722	0.00000	9900.00	9900.00	9900.00	0.9448	0.00	1	-360.00	360.00;
1614	1755	0.00700	0.27822	0.00000	9900.00	9900.00	9900.00	0.9527	0.00	1	-360.00	360.00;
1614	1755	0.00689	0.27777	0.00000	9900.00	9900.00	9900.00	0.9526	0.00	1	-360.00	360.00;
1616	1756	0.00479	0.24500	0.00000	9900.00	9900.00	9900.00	0.9688	0.00	1	-360.00	360.00;
1616	1756	0.00476	0.24416	0.00000	9900.00	9900.00	9900.00	0.9688	0.00	1	-360.00	360.00;
1609	1757	0.00619	0.23777	0.00000	9900.00	9900.00	9900.00	0.9381	0.00	1	-360.00	360.00;
1612	1757	0.00622	0.23777	0.00000	9900.00	9900.00	9900.00	0.9381	0.00	1	-360.00	360.00;
1623	1758	0.00979	0.20600	0.00000	9900.00	9900.00	9900.00	0.9321	0.00	1	-360.00	360.00;
1624	1758	0.00944	0.20750	0.00000	9900.00	9900.00	9900.00	0.9343	0.00	1	-360.00	360.00;
1626	1759	0.01222	0.20000	0.00000	9900.00	9900.00	9900.00	0.9617	0.00	1	-360.00	360.00;
1627	1760	0.01222	0.20000	0.00000	9900.00	9900.00	9900.00	0.9617	0.00	1	-360.00	360.00;
1610	1628	0.00151	0.08333	0.00000	9900.00	9900.00	9900.00	1.0031	0.00	1	-360.00	360.00;
1610	1628	0.00157	0.08750	0.00000	9900.00	9900.00	9900.00	1.0032	0.00	1	-360.00	360.00;
1615	1761	0.00940	0.19900	0.00000	9900.00	9900.00	9900.00	0.9455	0.00	1	-360.00	360.00;
1615	1761	0.00940	0.19900	0.00000	9900.00	9900.00	9900.00	0.9455	0.00	1	-360.00	360.00;
1630	1762	0.00600	0.27544	0.00000	9900.00	9900.00	9900.00	0.8882	0.00	1	-360.00	360.00;
1632	1762	0.00503	0.27133	0.00000	9900.00	9900.00	9900.00	0.8818	0.00	1	-360.00	360.00;
1613	1617	0.00141	0.08613	0.00000	9900.00	9900.00	9900.00	0.9994	0.00	1	-360.00	360.00;
1607	1617	0.00126	0.08738	0.00000	9900.00	9900.00	9900.00	1.0009	0.00	1	-360.00	360.00;
1637	1763	0.00503	0.18916	0.00000	9900.00	9900.00	9900.00	0.9783	0.00	1	-360.00	360.00;
1638	1763	0.00442	0.19291	0.00000	9900.00	9900.00	9900.00	0.9780	0.00	1	-360.00	360.00;
1649	1764	0.00954	0.20883	0.00000	9900.00	9900.00	9900.00	0.9235	0.00	1	-360.00	360.00;
1649	1764	0.00978	0.31966	0.00000	9900.00	9900.00	9900.00	0.9233	0.00	1	-360.00	360.00;
1651	1765	0.00723	0.25344	0.00000	9900.00	9900.00	9900.00	0.8905	0.00	1	-360.00	360.00;
1640	1765	0.00723	0.24900	0.00000	9900.00	9900.00	9900.00	0.8894	0.00	1	-360.00	360.00;
1652	1766	0.00892	0.23883	0.00000	9900.00	9900.00	9900.00	0.9030	0.00	1	-360.00	360.00;
1652	1767	0.04358	0.97750	0.00000	9900.00	9900.00	9900.00	0.8962	0.00	1	-360.00	360.00;
1653	1766	0.00892	0.23850	0.00000	9900.00	9900.00	9900.00	0.9030	0.00	1	-360.00	360.00;
1653	1767	0.04358	0.97300	0.00000	9900.00	9900.00	9900.00	0.8962	0.00	1	-360.00	360.00;
1641	1768	0.00910	0.21316	0.00000	9900.00	9900.00	9900.00	0.8969	0.00	1	-360.00	360.00;
1654	1768	0.00930	0.21550	0.00000	9900.00	9900.00	9900.00	0.8966	0.00	1	-360.00	360.00;
1655	1769	0.00000	0.24800	0.00000	9900.00	9900.00	9900.00	0.8905	0.00	1	-360.00	360.00;
1655	1769	0.00000	0.24916	0.00000	9900.00	9900.00	9900.00	0.8905	0.00	1	-360.00	360.00;
1655	1770	0.00000	0.57500	0.00000	9900.00	9900.00	9900.00	0.9802	0.00	1	-360.00	360.00;
1655	1771	0.00000	0.57500	0.00000	9900.00	9900.00	9900.00	0.9802	0.00	1	-360.00	360.00;
1579	1561	0.00013	0.01600	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1642	1579	0.00157	0.08458	0.00000	9900.00	9900.00	9900.00	0.9220	0.00	1	-360.00	360.00;
1642	1579	0.00152	0.08708	0.00000	9900.00	9900.00	9900.00	0.9221	0.00	1	-360.00	360.00;
1642	1579	0.00152	0.08458	0.00000	9900.00	9900.00	9900.00	0.9221	0.00	1	-360.00	360.00;
1644	1772	0.02000	0.27111	0.00000	9900.00	9900.00	9900.00	0.9414	0.00	1	-360.00	360.00;
1647	1772	0.02000	0.27111	0.00000	9900.00	9900.00	9900.00	0.9415	0.00	1	-360.00	360.00;
1659	1773	0.00488	0.20250	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1659	1773	0.00494	0.20166	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1492	1774	0.00994	0.20833	0.00000	9900.00	9900.00	9900.00	0.9173	0.00	1	-360.00	360.00;
1492	1774	0.00922	0.21700	0.00000	9900.00	9900.00	9900.00	0.9178	0.00	1	-360.00	360.00;
1460	1775	0.03225	0.79000	0.00000	9900.00	9900.00	9900.00	0.9857	0.00	1	-360.00	360.00;
1460	1775	0.03230	0.79000	0.00000	9900.00	9900.00	9900.00	0.9857	0.00	1	-360.00	360.00;
1451	1663	0.01054	0.26883	0.00000	9900.00	9900.00	9900.00	0.9939	0.00	1	-360.00	360.00;
1451	1663	0.01040	0.26732	0.00000	9900.00	9900.00	9900.00	0.9939	0.00	1	-360.00	360.00;
1566	1776	0.01088	0.20000	0.00000	9900.00	9900.00	9900.00	0.9904	0.00	1	-360.00	360.00;
1566	1776	0.01087	0.20033	0.00000	9900.00	9900.00	9900.00	0.9904	0.00	1	-360.00	360.00;
1566	1777	0.00100	0.73800	0.00000	9900.00	9900.00	9900.00	1.0250	0.00	1	-360.00	360.00;
1566	1778	0.00100	0.73800	0.00000	9900.00	9900.00	9900.00	1.0250	0.00	1	-360.00	360.00;
1595	1671	0.00965	0.21200	0.00000	9900.00	9900.00	9900.00	0.9676	0.00	1	-360.00	360.00;
1595	1671	0.00965	0.21200	0.00000	9900.00	9900.00	9900.00	0.9676	0.00	1	-360.00	360.00;
1610	1779	0.01432	0.26670	0.00000	9900.00	9900.00	9900.00	0.9637	0.00	1	-360.00	360.00;
1610	1780	0.01432	0.26670	0.00000	9900.00	9900.00	9900.00	0.9637	0.00	1	-360.00	360.00;
1613	1781	0.00953	0.20516	0.00000	9900.00	9900.00	9900.00	0.9524	0.00	1	-360.00	360.00;
1607	1781	0.00953	0.20583	0.00000	9900.00	9900.00	9900.00	0.9567	0.00	1	-360.00	360.00;
1672	1782	0.00479	0.24500	0.00000	9900.00	9900.00	9900.00	0.9566	0.00	1	-360.00	360.00;
1673	1782	0.00476	0.24416	0.00000	9900.00	9900.00	9900.00	0.9872	0.00	1	-360.00	360.00;
1674	1433	0.00312	0.12500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1674	1435	0.00312	0.12500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1674	1437	0.00312	0.12500	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1677	1569	0.00112	0.09389	0.00000	9900.00	9900.00	9900.00	1.1500	0.00	1	-360.00	360.00;
1676	1569	0.00018	0.01617	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1519	1504	0.00000	0.02500	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1783	1784	0.01760	0.44890	0.00000	9900.00	9900.00	9900.00	0.9878	0.00	1	-360.00	360.00;
1785	1786	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1787	1788	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1789	1790	0.01000	0.10000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1791	1792	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	1.0048	0.00	1	-360.00	360.00;
1793	1794	0.10000	0.90000	0.00000	9900.00	9900.00	9900.00	0.9974	0.00	1	-360.00	360.00;
1795	1796	0.02000	0.24000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1797	1798	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1799	1800	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1801	1802	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1803	1804	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.9726	0.00	1	-360.00	360.00;
1805	1806	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	1.0352	0.00	1	-360.00	360.00;
1807	1808	0.00000	0.80000	0.00000	9900.00	9900.00	9900.00	0.9968	0.00	1	-360.00	360.00;
1809	1810	0.00000	0.92600	0.00000	9900.00	9900.00	9900.00	1.0800	0.00	1	-360.00	360.00;
1811	1812	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.9990	0.00	1	-360.00	360.00;
1813	1814	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.9990	0.00	1	-360.00	360.00;
1815	1816	0.01560	0.34730	0.00000	9900.00	9900.00	9900.00	0.9974	0.00	1	-360.00	360.00;
1817	1818	0.00750	0.25000	0.00000	9900.00	9900.00	9900.00	0.9970	0.00	1	-360.00	360.00;
1819	1820	0.00710	0.19530	0.00000	9900.00	9900.00	9900.00	1.0109	0.00	1	-360.00	360.00;
1821	1822	0.00710	0.19550	0.00000	9900.00	9900.00	9900.00	0.9834	0.00	1	-360.00	360.00;
1823	1824	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1825	1826	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1827	1828	0.02000	0.15000	0.00000	9900.00	9900.00	9900.00	1.0014	0.00	1	-360.00	360.00;
1829	1830	0.01460	0.37600	0.00000	9900.00	9900.00	9900.00	1.0169	0.00	1	-360.00	360.00;
1831	1832	0.01010	0.25100	0.00000	9900.00	9900.00	9900.00	0.9980	0.00	1	-360.00	360.00;
1833	1834	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	0.9768	0.00	1	-360.00	360.00;
1835	1836	0.10000	0.90000	0.00000	9900.00	9900.00	9900.00	1.0057	0.00	1	-360.00	360.00;
1837	1838	0.01000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1839	1840	0.00720	0.26600	0.00000	9900.00	9900.00	9900.00	1.0234	0.00	1	-360.00	360.00;
1841	1842	0.00720	0.26600	0.00000	9900.00	9900.00	9900.00	1.0276	0.00	1	-360.00	360.00;
1843	1844	0.01000	0.15000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1845	1846	0.01000	0.15000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1847	1848	0.01510	0.62280	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1847	1849	0.01760	0.50870	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1847	1850	0.02110	0.34000	0.00000	9900.00	9900.00	9900.00	0.9977	0.00	1	-360.00	360.00;
1851	1852	0.00960	0.27110	0.00000	9900.00	9900.00	9900.00	1.0194	0.00	1	-360.00	360.00;
1853	1854	0.00170	0.08170	0.00000	9900.00	9900.00	9900.00	0.9841	0.00	1	-360.00	360.00;
1853	1855	0.00180	0.07990	0.00000	9900.00	9900.00	9900.00	0.9854	0.00	1	-360.00	360.00;
1856	1857	0.11760	1.27440	0.00000	9900.00	9900.00	9900.00	0.9984	0.00	1	-360.00	360.00;
1858	1859	0.07280	1.03200	0.00000	9900.00	9900.00	9900.00	1.0025	0.00	1	-360.00	360.00;
1860	1861	0.00550	0.21940	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1862	1863	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	1.0037	0.00	1	-360.00	360.00;
1864	1865	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	1.0089	0.00	1	-360.00	360.00;
1866	1867	0.01760	0.50870	0.00000	9900.00	9900.00	9900.00	1.0089	0.00	1	-360.00	360.00;
1868	1869	0.01200	0.31470	0.00000	9900.00	9900.00	9900.00	0.9999	0.00	1	-360.00	360.00;
1870	1871	0.01900	0.40240	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1872	1873	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1874	1875	0.05060	0.72000	0.00000	9900.00	9900.00	9900.00	1.0236	0.00	1	-360.00	360.00;
1874	1876	0.05060	0.72000	0.00000	9900.00	9900.00	9900.00	1.0236	0.00	1	-360.00	360.00;
1874	1877	0.05060	0.72000	0.00000	9900.00	9900.00	9900.00	1.0236	0.00	1	-360.00	360.00;
1878	1879	0.01780	0.45420	0.00000	9900.00	9900.00	9900.00	0.9873	0.00	1	-360.00	360.00;
1880	1881	0.00000	1.33300	0.00000	9900.00	9900.00	9900.00	0.9974	0.00	1	-360.00	360.00;
1882	1883	0.01930	0.38520	0.00000	9900.00	9900.00	9900.00	0.9944	0.00	1	-360.00	360.00;
1882	1884	0.01930	0.38200	0.00000	9900.00	9900.00	9900.00	0.9945	0.00	1	-360.00	360.00;
1885	1886	0.00000	1.19520	0.00000	9900.00	9900.00	9900.00	1.0252	0.00	1	-360.00	360.00;
1887	1888	0.01950	0.36520	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1889	1890	0.01950	0.36640	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1891	1892	0.05000	0.49480	0.00000	9900.00	9900.00	9900.00	1.0347	0.00	1	-360.00	360.00;
1893	1894	0.01000	0.10000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1895	1896	0.01950	0.36320	0.00000	9900.00	9900.00	9900.00	1.0047	0.00	1	-360.00	360.00;
1897	1898	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	0.9919	0.00	1	-360.00	360.00;
1899	1900	0.02170	0.48750	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1901	1902	0.01000	0.15000	0.00000	9900.00	9900.00	9900.00	1.0196	0.00	1	-360.00	360.00;
1903	1904	0.00020	0.01930	0.00000	9900.00	9900.00	9900.00	1.0023	0.00	1	-360.00	360.00;
1905	1906	0.00020	0.01940	0.00000	9900.00	9900.00	9900.00	1.0016	0.00	1	-360.00	360.00;
1907	1908	0.00097	0.04800	0.00000	9900.00	9900.00	9900.00	1.0011	0.00	1	-360.00	360.00;
1909	1910	0.00097	0.04800	0.00000	9900.00	9900.00	9900.00	1.0028	0.00	1	-360.00	360.00;
1911	1912	0.00097	0.04800	0.00000	9900.00	9900.00	9900.00	1.0031	0.00	1	-360.00	360.00;
1913	1914	0.01340	0.33130	0.00000	9900.00	9900.00	9900.00	1.0005	0.00	1	-360.00	360.00;
1915	1916	0.01990	0.39480	0.00000	9900.00	9900.00	9900.00	1.0224	0.00	1	-360.00	360.00;
1917	1918	0.01500	0.34930	0.00000	9900.00	9900.00	9900.00	0.9966	0.00	1	-360.00	360.00;
1919	1920	0.00790	0.23080	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1921	1922	0.00790	0.22900	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1923	1924	0.00790	0.22980	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1925	1926	0.00800	0.23200	0.00000	9900.00	9900.00	9900.00	1.0029	0.00	1	-360.00	360.00;
1927	1928	0.12500	1.33200	0.00000	9900.00	9900.00	9900.00	0.9662	0.00	1	-360.00	360.00;
1929	1930	0.03400	0.88400	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1931	1932	0.01000	0.10000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1933	1934	0.54450	2.09400	0.00000	9900.00	9900.00	9900.00	1.0059	0.00	1	-360.00	360.00;
1933	1935	0.54450	2.05000	0.00000	9900.00	9900.00	9900.00	1.0060	0.00	1	-360.00	360.00;
1936	1937	0.01700	0.24000	0.00000	9900.00	9900.00	9900.00	0.9059	0.00	1	-360.00	360.00;
1938	1939	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	0.9938	0.00	1	-360.00	360.00;
1940	1941	0.02000	0.20000	0.00000	9900.00	9900.00	9900.00	0.9943	0.00	1	-360.00	360.00;
1942	1943	0.16000	1.27070	0.00000	9900.00	9900.00	9900.00	1.0071	0.00	1	-360.00	360.00;
1942	1944	0.01630	0.77760	0.00000	9900.00	9900.00	9900.00	0.9997	0.00	1	-360.00	360.00;
1945	1841	0.07030	0.16010	0.03450	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1946	1945	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1946	1947	0.02490	0.05660	0.01220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1783	1878	0.00264	0.00594	0.00660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1948	1949	0.00060	0.00280	0.00070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1950	1951	0.00060	0.00280	0.00070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1952	1897	0.13360	0.25400	0.00090	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1952	1791	0.12960	0.36480	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1953	1954	0.01470	0.03370	0.00710	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1955	1956	0.01850	0.05270	0.01170	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1957	1958	0.00280	0.01930	0.07480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1957	1959	0.00444	0.03038	0.11773	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1960	1961	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1960	1829	0.01430	0.03280	0.00690	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1960	1847	0.02630	0.06030	0.01280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1960	1962	0.01570	0.03590	0.00760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1960	1951	0.03140	0.07190	0.01530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1960	1963	0.01360	0.03200	0.00640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1960	1964	0.03065	0.07025	0.01490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1961	1965	0.02600	0.05960	0.01260	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1961	1966	0.01570	0.03590	0.00760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1961	1878	0.00130	0.00290	0.00060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1961	1949	0.03140	0.07190	0.01530	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1961	1967	0.01360	0.03200	0.00640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1961	1968	0.03065	0.07025	0.01490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1958	1969	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1958	1970	0.00852	0.03134	0.19330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1969	1971	0.00390	0.02060	0.09710	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1972	1942	0.30400	0.58300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1973	1974	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1973	1971	0.01220	0.05100	0.28440	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1973	1975	0.00600	0.02210	0.13660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1974	1976	0.00010	0.00100	0.00580	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1974	1977	0.00600	0.02210	0.13660	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1974	1970	0.00378	0.01390	0.08560	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1973	1978	0.00420	0.03576	0.21598	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1979	1980	0.02162	0.04957	0.01054	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1979	1964	0.03065	0.07025	0.01490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1981	1968	0.03065	0.07025	0.01490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1982	1841	0.05870	0.13410	0.02860	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1982	1660	0.00980	0.02230	0.00480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1983	1839	0.05870	0.13410	0.02860	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1983	1661	0.00980	0.02230	0.00480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1984	1797	0.03647	0.10472	0.01242	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1984	1799	0.03647	0.10472	0.01242	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1985	1986	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1985	1987	0.00610	0.01210	0.00250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1985	1988	0.03540	0.07260	0.01480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1986	1989	0.00610	0.01210	0.00250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1986	1954	0.03080	0.06330	0.01290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1990	1801	0.17000	0.35000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1991	1992	0.08990	0.14870	0.03110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1991	1993	0.06014	0.09963	0.02332	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1994	1995	0.00120	0.00270	0.00060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1995	1996	0.03940	0.09010	0.01910	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1995	1917	0.03490	0.07990	0.01700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1997	1998	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1997	1947	0.04290	0.09760	0.02100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1998	1839	0.05990	0.13630	0.02930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1999	2000	0.08750	0.14530	0.03010	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2001	2002	0.08750	0.14530	0.03010	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2003	1803	0.02750	0.06060	0.00610	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2003	1833	0.12080	0.24840	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2003	1938	0.36410	0.76640	0.00460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2004	2005	0.00110	0.00170	0.05920	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2004	2006	0.00150	0.00340	0.00070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2007	2008	0.00110	0.00170	0.05920	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2007	2009	0.00141	0.00324	0.00193	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1807	2010	0.09000	0.20000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2011	2012	0.02840	0.06750	0.01330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1815	2013	0.00480	0.01145	0.00225	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1947	2014	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1947	2015	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1947	2016	0.00200	0.00460	0.04130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1947	2017	0.00200	0.00460	0.04130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1947	2018	0.00200	0.00450	0.00100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1947	2019	0.00170	0.00851	0.00206	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2014	2020	0.00200	0.00450	0.00100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2015	2021	0.00170	0.00851	0.00206	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1817	2022	0.00850	0.01950	0.00410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1817	2023	0.01440	0.03300	0.00700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2024	2022	0.00920	0.02100	0.00440	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2024	2025	0.01020	0.02330	0.00490	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2026	1927	0.28000	0.32000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2027	1785	0.00050	0.00105	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1818	2028	0.90500	1.31400	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2029	2030	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2031	2032	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2030	2033	0.00190	0.00280	0.09820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2032	2034	0.00190	0.00280	0.09820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1819	2035	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1821	2036	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2035	2037	0.03880	0.08880	0.01880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2035	1839	0.01570	0.03600	0.00760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2036	2038	0.03880	0.08880	0.01880	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2036	1841	0.01570	0.03600	0.00760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1820	2039	0.33280	0.15300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1820	2040	0.33280	0.15300	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2037	2021	0.01490	0.03410	0.00720	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2038	2019	0.01490	0.03410	0.00720	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2041	1787	0.53410	1.05620	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2041	1823	0.35990	0.76710	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2041	1825	0.23920	0.52790	0.00010	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2043	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2044	0.01240	0.03970	0.00890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2044	0.01240	0.03970	0.00890	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2034	0.00480	0.01530	0.00340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2045	0.00150	0.00220	0.07500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2046	0.00150	0.00220	0.07500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2047	0.00485	0.01057	0.00221	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2042	2048	0.00485	0.01057	0.00221	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2043	2033	0.00480	0.01530	0.00340	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1829	1831	0.00930	0.02120	0.00450	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1954	1956	0.00380	0.01900	0.00460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2049	2050	0.01570	0.03600	0.00760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2049	2051	0.01570	0.03600	0.00760	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2052	2053	0.00407	0.02785	0.10787	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1996	2054	0.02120	0.04860	0.01030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2055	1835	0.04550	0.01130	0.00216	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2005	2016	0.00060	0.00090	0.03280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2008	2017	0.00060	0.00090	0.03280	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2056	1657	0.02450	0.04050	0.00850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2057	1658	0.02450	0.04050	0.00850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2058	1933	0.22460	0.46080	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2058	2059	0.14840	0.40740	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2060	2044	0.00830	0.02650	0.01820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2061	2044	0.00830	0.02650	0.01820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2062	1929	0.03510	0.03023	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2063	2064	0.02810	0.06430	0.01370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2063	2065	0.03600	0.08220	0.01750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2066	2064	0.02810	0.06430	0.01370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2066	2067	0.03600	0.08220	0.01750	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1841	1839	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1841	2068	0.03750	0.08580	0.01820	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1841	2069	0.00100	0.00220	0.00050	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1839	2070	0.00100	0.00220	0.00050	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2071	2072	0.07790	0.19680	0.05200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2073	2072	0.07790	0.19680	0.05200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2074	1842	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1847	1965	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1847	2075	0.02000	0.05790	0.01230	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1965	2072	0.02000	0.05790	0.01230	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2072	2075	0.00005	0.00012	0.00002	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2072	2076	0.00060	0.00240	0.00050	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2072	2077	0.00870	0.01980	0.00420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2072	2078	0.00870	0.01980	0.00420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2079	2080	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2079	2048	0.03004	0.06157	0.01238	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1851	2068	0.00210	0.00500	0.00100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1971	1853	0.00004	0.00024	0.06220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1856	2081	1.09070	1.45053	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2082	2083	0.00900	0.02340	0.00502	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2084	2085	0.00900	0.02340	0.00502	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2086	2077	0.03550	0.08110	0.01730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2087	2078	0.03550	0.08110	0.01730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2087	2088	0.01750	0.05000	0.01190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1858	2089	0.16000	0.25000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1860	2076	0.00510	0.01200	0.00240	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1861	2090	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2091	2092	0.00280	0.00640	0.00140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1866	2093	0.00280	0.00640	0.00140	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1870	2078	0.00250	0.00580	0.00120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1962	2094	0.00000	0.00001	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1966	2067	0.02863	0.06600	0.03100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2094	2065	0.02863	0.06599	0.03100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2095	2096	0.00690	0.01570	0.00330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2095	2097	0.00180	0.00410	0.00090	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2095	2098	0.00620	0.01420	0.00300	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2099	2096	0.00690	0.01570	0.00330	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2099	2100	0.00180	0.00410	0.00090	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2099	2101	0.00620	0.01420	0.00300	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2022	2102	0.02150	0.03550	0.00740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2022	2002	0.05020	0.08320	0.01730	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2022	2103	0.02290	0.05250	0.01110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2022	2104	0.03220	0.05330	0.01110	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2022	2105	0.01578	0.02615	0.00544	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2064	2106	0.03840	0.08800	0.01870	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2064	1980	0.04198	0.09623	0.02046	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1976	2107	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2107	1977	0.00290	0.02440	0.14720	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2108	1862	0.62749	0.83845	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2108	1872	0.47608	0.52757	0.00230	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2108	2109	0.42570	0.90480	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2108	2110	1.10450	1.47240	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2068	1882	0.00250	0.00580	0.00120	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2068	1915	0.02190	0.05200	0.01030	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2068	2023	0.04560	0.10450	0.02220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2068	2025	0.04013	0.09196	0.01954	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2111	2112	0.03000	0.07000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2102	1885	0.00590	0.01030	0.00190	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2102	2113	0.01070	0.01780	0.00370	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2044	2047	0.01826	0.03742	0.00752	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1977	2114	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1977	2115	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1977	2116	0.00140	0.01230	0.07420	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2117	2115	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2117	2118	0.00590	0.05100	0.30720	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1975	2115	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2114	2119	0.00610	0.05360	0.22142	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2115	2120	0.00360	0.03070	0.18480	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2115	2121	0.00260	0.02190	0.13220	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2115	2122	0.00610	0.05360	0.22142	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2115	1621	0.00850	0.07310	0.44540	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2123	1936	0.07580	0.09381	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2123	1864	0.82928	1.15303	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2076	2013	0.00480	0.01145	0.00225	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2012	1917	0.01060	0.02520	0.00500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1880	2124	0.18000	0.18000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2112	2010	0.21000	0.45000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2077	1992	0.01910	0.04540	0.00900	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1887	2092	0.01210	0.02840	0.00570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1887	1963	0.00530	0.01230	0.00250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1889	2093	0.01210	0.02840	0.00570	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1889	1967	0.00530	0.01230	0.00250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2083	2125	0.00640	0.01460	0.00310	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2083	2126	0.00710	0.01840	0.00395	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2085	2127	0.00640	0.01460	0.00310	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2085	2128	0.00710	0.01840	0.00395	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2129	1956	0.00780	0.03910	0.00940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2130	1956	0.00780	0.03910	0.00940	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2110	2109	0.13930	0.29610	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2109	1795	0.01170	0.01120	0.00080	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2006	2009	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2006	1956	0.00290	0.01480	0.00360	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2009	1956	0.00290	0.01480	0.00360	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2013	2131	0.00335	0.00554	0.00130	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1895	2092	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2132	2093	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1949	1917	0.03370	0.07720	0.01640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1951	1917	0.03370	0.07720	0.01640	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2133	1917	0.09540	0.21840	0.04630	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2133	2050	0.01640	0.03750	0.00790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2054	2051	0.01640	0.03750	0.00790	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2134	1811	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2134	1813	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1899	1963	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2135	1967	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2096	2136	0.00086	0.00059	0.01510	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2096	2137	0.00080	0.00056	0.01410	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2096	2138	0.00012	0.00056	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2096	2139	0.00012	0.00056	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2096	2127	0.01500	0.03490	0.00740	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2140	2120	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2140	1903	0.00002	0.00033	0.14210	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2140	2141	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2140	2142	0.00240	0.02080	0.12520	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2121	2143	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1905	2144	0.00002	0.00032	0.13510	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1907	2145	0.00006	0.00021	0.05250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1909	2146	0.00006	0.00021	0.05250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1911	2147	0.00006	0.00021	0.05250	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2143	2148	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2144	2149	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2147	2148	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2147	2141	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2148	2146	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2146	2149	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2149	2145	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2145	2141	0.00000	0.00100	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2144	1978	0.00000	0.00004	0.00022	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2150	2151	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2150	2152	0.00140	0.00210	0.07500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2151	2153	0.00140	0.00210	0.07500	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2142	2116	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2000	2105	0.03442	0.05705	0.01186	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1913	1992	0.00120	0.00280	0.00050	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2154	2070	0.02420	0.05510	0.01180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2155	2069	0.02420	0.05510	0.01180	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2156	2157	0.00009	0.00034	0.00460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2158	2159	0.00009	0.00034	0.00460	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2125	2098	0.00000	0.00001	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2127	2101	0.00000	0.00001	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2098	2101	0.00010	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2098	2160	0.00382	0.00557	0.01871	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2098	2156	0.00250	0.00490	0.00100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2101	2161	0.00382	0.00557	0.01871	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2101	2158	0.00250	0.00490	0.00100	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2103	2023	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2103	1923	0.00150	0.00340	0.00070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2103	1925	0.00150	0.00340	0.00070	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2103	2025	0.00547	0.01254	0.00266	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2103	1656	0.01440	0.03300	0.00700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2103	1648	0.01440	0.03300	0.00700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2023	1919	0.00130	0.00300	0.00060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2023	1921	0.00130	0.00300	0.00060	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2023	1650	0.01450	0.03310	0.00700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2023	1645	0.01450	0.03310	0.00700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2053	1959	0.00089	0.00607	0.02350	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2059	1827	0.04240	0.11640	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2162	2163	0.43720	0.58190	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2162	1793	0.09880	0.18920	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2162	1868	0.02040	0.01590	0.00050	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2163	1793	0.20750	0.39730	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1956	2021	0.00239	0.01199	0.00290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1956	2019	0.00239	0.01199	0.00290	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2119	2164	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2119	2118	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2119	1633	0.00190	0.01670	0.10200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2164	1622	0.00430	0.03710	0.22850	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2122	2118	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2165	2118	0.00000	0.00010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2165	1618	0.00190	0.01670	0.10200	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2166	1940	0.01660	0.03320	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2166	2167	0.06010	0.12010	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2153	2045	0.00075	0.00290	0.03908	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2152	2046	0.00075	0.00290	0.03908	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2168	2169	0.02380	0.03940	0.00930	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2169	1993	0.01206	0.01997	0.00468	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2170	1789	0.05300	0.14550	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2171	2047	0.03120	0.07980	0.01700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2172	2048	0.03120	0.07980	0.01700	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2173	2174	0.02332	0.02388	0.00151	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2175	1874	0.00800	0.03240	0.00010	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2176	1901	0.04193	0.12043	0.01428	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2176	1901	0.04193	0.12043	0.01428	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2177	1805	0.01193	0.03427	0.00406	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2177	1805	0.01193	0.03427	0.00406	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2177	1805	0.01193	0.03427	0.00406	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2178	1837	0.02810	0.05780	0.00610	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1946	2179	0.01050	0.27980	0.00000	9900.00	9900.00	9900.00	0.9171	0.00	1	-360.00	360.00;
1945	2179	0.01050	0.28500	0.00000	9900.00	9900.00	9900.00	0.9170	0.00	1	-360.00	360.00;
1948	1952	0.01820	0.27830	0.00000	9900.00	9900.00	9900.00	1.0027	0.00	1	-360.00	360.00;
1950	1952	0.01800	0.27670	0.00000	9900.00	9900.00	9900.00	1.0027	0.00	1	-360.00	360.00;
1953	2180	0.00700	0.28290	0.00000	9900.00	9900.00	9900.00	0.9130	0.00	1	-360.00	360.00;
1955	2180	0.00700	0.28290	0.00000	9900.00	9900.00	9900.00	0.9166	0.00	1	-360.00	360.00;
1960	1969	0.00500	0.12250	0.00000	9900.00	9900.00	9900.00	0.9971	0.00	1	-360.00	360.00;
1960	1972	0.01040	0.27730	0.00000	9900.00	9900.00	9900.00	1.0238	0.00	1	-360.00	360.00;
1961	1958	0.00300	0.12180	0.00000	9900.00	9900.00	9900.00	1.0120	0.00	1	-360.00	360.00;
1961	1958	0.00500	0.12210	0.00000	9900.00	9900.00	9900.00	0.9972	0.00	1	-360.00	360.00;
1961	1972	0.01040	0.27730	0.00000	9900.00	9900.00	9900.00	1.0238	0.00	1	-360.00	360.00;
1979	2181	0.02130	0.35330	0.00000	9900.00	9900.00	9900.00	0.9881	0.00	1	-360.00	360.00;
1981	2181	0.01770	0.39700	0.00000	9900.00	9900.00	9900.00	0.9483	0.00	1	-360.00	360.00;
1982	1984	0.00900	0.27850	0.00000	9900.00	9900.00	9900.00	0.9935	0.00	1	-360.00	360.00;
1983	1984	0.00900	0.27600	0.00000	9900.00	9900.00	9900.00	0.9936	0.00	1	-360.00	360.00;
1987	1990	0.01000	0.28333	0.00000	9900.00	9900.00	9900.00	0.9736	0.00	1	-360.00	360.00;
1989	1990	0.01000	0.28333	0.00000	9900.00	9900.00	9900.00	0.9735	0.00	1	-360.00	360.00;
1991	2182	0.01190	0.39000	0.00000	9900.00	9900.00	9900.00	0.9789	0.00	1	-360.00	360.00;
1994	2183	0.01820	0.67130	0.00000	9900.00	9900.00	9900.00	0.9825	0.00	1	-360.00	360.00;
1997	2184	0.00880	0.24470	0.00000	9900.00	9900.00	9900.00	0.9224	0.00	1	-360.00	360.00;
1998	2184	0.00880	0.24470	0.00000	9900.00	9900.00	9900.00	0.9224	0.00	1	-360.00	360.00;
1999	2003	0.01040	0.27650	0.00000	9900.00	9900.00	9900.00	0.9824	0.00	1	-360.00	360.00;
2001	2003	0.01040	0.27650	0.00000	9900.00	9900.00	9900.00	0.9825	0.00	1	-360.00	360.00;
2011	1809	0.06140	0.88700	0.00000	9900.00	9900.00	9900.00	0.9929	0.00	1	-360.00	360.00;
2185	1816	0.12800	1.38300	0.00000	9900.00	9900.00	9900.00	0.9587	0.00	1	-360.00	360.00;
2014	2186	0.00540	0.27778	0.00000	9900.00	9900.00	9900.00	0.9190	0.00	1	-360.00	360.00;
2015	2186	0.00540	0.27778	0.00000	9900.00	9900.00	9900.00	0.9190	0.00	1	-360.00	360.00;
2024	2027	0.00750	0.25000	0.00000	9900.00	9900.00	9900.00	0.9870	0.00	1	-360.00	360.00;
2026	1818	0.00000	1.06670	0.00000	9900.00	9900.00	9900.00	1.0429	0.00	1	-360.00	360.00;
2029	2187	0.00870	0.24920	0.00000	9900.00	9900.00	9900.00	0.9435	0.00	1	-360.00	360.00;
2031	2187	0.00870	0.24920	0.00000	9900.00	9900.00	9900.00	0.9435	0.00	1	-360.00	360.00;
2037	2041	0.01050	0.27890	0.00000	9900.00	9900.00	9900.00	1.0004	0.00	1	-360.00	360.00;
2038	2041	0.01050	0.27890	0.00000	9900.00	9900.00	9900.00	1.0005	0.00	1	-360.00	360.00;
2042	2188	0.01780	0.29900	0.00000	9900.00	9900.00	9900.00	0.9564	0.00	1	-360.00	360.00;
2043	2188	0.01750	0.30270	0.00000	9900.00	9900.00	9900.00	0.9562	0.00	1	-360.00	360.00;
2049	2052	0.00540	0.09870	0.00000	9900.00	9900.00	9900.00	1.0126	0.00	1	-360.00	360.00;
2049	2189	0.04150	0.53000	0.00000	9900.00	9900.00	9900.00	0.9920	0.00	1	-360.00	360.00;
2049	2189	0.04340	0.52500	0.00000	9900.00	9900.00	9900.00	0.9923	0.00	1	-360.00	360.00;
1996	2055	0.01520	0.39400	0.00000	9900.00	9900.00	9900.00	0.9975	0.00	1	-360.00	360.00;
2005	2190	0.00780	0.24930	0.00000	9900.00	9900.00	9900.00	0.9138	0.00	1	-360.00	360.00;
2008	2190	0.00780	0.23930	0.00000	9900.00	9900.00	9900.00	0.9141	0.00	1	-360.00	360.00;
2056	2058	0.02000	0.24490	0.00000	9900.00	9900.00	9900.00	0.9602	0.00	1	-360.00	360.00;
2057	2058	0.02000	0.24580	0.00000	9900.00	9900.00	9900.00	0.9602	0.00	1	-360.00	360.00;
2060	2062	0.01350	0.26670	0.00000	9900.00	9900.00	9900.00	0.9508	0.00	1	-360.00	360.00;
2061	2062	0.01360	0.26730	0.00000	9900.00	9900.00	9900.00	0.9508	0.00	1	-360.00	360.00;
2063	2191	0.00630	0.27980	0.00000	9900.00	9900.00	9900.00	0.9123	0.00	1	-360.00	360.00;
2066	2191	0.00630	0.27780	0.00000	9900.00	9900.00	9900.00	0.9126	0.00	1	-360.00	360.00;
2192	1849	0.01600	0.50000	0.00000	9900.00	9900.00	9900.00	0.9635	0.00	1	-360.00	360.00;
2075	2193	0.02230	0.64330	0.00000	9900.00	9900.00	9900.00	0.9964	0.00	1	-360.00	360.00;
2079	2194	0.03120	0.36370	0.00000	9900.00	9900.00	9900.00	0.9724	0.00	1	-360.00	360.00;
2080	2194	0.03190	0.35500	0.00000	9900.00	9900.00	9900.00	0.9730	0.00	1	-360.00	360.00;
2082	2195	0.01040	0.28000	0.00000	9900.00	9900.00	9900.00	0.9824	0.00	1	-360.00	360.00;
2084	2195	0.01040	0.28000	0.00000	9900.00	9900.00	9900.00	0.9823	0.00	1	-360.00	360.00;
2086	2196	0.00880	0.27330	0.00000	9900.00	9900.00	9900.00	0.9870	0.00	1	-360.00	360.00;
2087	2196	0.00880	0.27670	0.00000	9900.00	9900.00	9900.00	0.9863	0.00	1	-360.00	360.00;
2016	2197	0.00820	0.19330	0.00000	9900.00	9900.00	9900.00	0.9196	0.00	1	-360.00	360.00;
2017	2198	0.00820	0.19600	0.00000	9900.00	9900.00	9900.00	0.9195	0.00	1	-360.00	360.00;
2091	1867	0.01760	0.50870	0.00000	9900.00	9900.00	9900.00	1.0045	0.00	1	-360.00	360.00;
2199	1867	0.00000	1.00000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2199	1867	0.00000	1.00000	0.00000	9900.00	9900.00	9900.00	0.9490	0.00	1	-360.00	360.00;
1962	2081	0.00890	0.27870	0.00000	9900.00	9900.00	9900.00	1.0005	0.00	1	-360.00	360.00;
1966	2081	0.00900	0.28000	0.00000	9900.00	9900.00	9900.00	0.9885	0.00	1	-360.00	360.00;
2064	1976	0.00100	0.08960	0.00000	9900.00	9900.00	9900.00	0.9638	0.00	1	-360.00	360.00;
2064	2107	0.00240	0.08950	0.00000	9900.00	9900.00	9900.00	0.9541	0.00	1	-360.00	360.00;
2064	2108	0.00540	0.27778	0.00000	9900.00	9900.00	9900.00	0.9689	0.00	1	-360.00	360.00;
2064	2108	0.00540	0.27778	0.00000	9900.00	9900.00	9900.00	0.9689	0.00	1	-360.00	360.00;
2068	2111	0.02420	0.40670	0.00000	9900.00	9900.00	9900.00	1.0126	0.00	1	-360.00	360.00;
2044	1977	0.00310	0.10210	0.00000	9900.00	9900.00	9900.00	0.9759	0.00	1	-360.00	360.00;
2044	1975	0.00300	0.12170	0.00000	9900.00	9900.00	9900.00	0.9756	0.00	1	-360.00	360.00;
2044	2123	0.01040	0.27650	0.00000	9900.00	9900.00	9900.00	1.0439	0.00	1	-360.00	360.00;
2044	2123	0.00780	0.25000	0.00000	9900.00	9900.00	9900.00	1.0399	0.00	1	-360.00	360.00;
2131	1893	0.01430	0.23000	0.00000	9900.00	9900.00	9900.00	0.9759	0.00	1	-360.00	360.00;
2012	2200	0.03500	0.50500	0.00000	9900.00	9900.00	9900.00	1.0013	0.00	1	-360.00	360.00;
2129	2201	0.00700	0.21000	0.00000	9900.00	9900.00	9900.00	0.9156	0.00	1	-360.00	360.00;
2130	2201	0.00700	0.21000	0.00000	9900.00	9900.00	9900.00	0.9156	0.00	1	-360.00	360.00;
2020	2202	0.00780	0.24300	0.00000	9900.00	9900.00	9900.00	0.9192	0.00	1	-360.00	360.00;
2018	2202	0.00780	0.24730	0.00000	9900.00	9900.00	9900.00	0.9191	0.00	1	-360.00	360.00;
2106	2110	0.01100	0.27700	0.00000	9900.00	9900.00	9900.00	1.0072	0.00	1	-360.00	360.00;
2006	1891	0.00780	0.24830	0.00000	9900.00	9900.00	9900.00	0.9144	0.00	1	-360.00	360.00;
2009	1891	0.00880	0.28130	0.00000	9900.00	9900.00	9900.00	0.9144	0.00	1	-360.00	360.00;
2132	1896	0.01950	0.37040	0.00000	9900.00	9900.00	9900.00	1.0078	0.00	1	-360.00	360.00;
2133	2134	0.00895	0.23917	0.00000	9900.00	9900.00	9900.00	0.9868	0.00	1	-360.00	360.00;
2054	2134	0.01990	0.32870	0.00000	9900.00	9900.00	9900.00	0.9930	0.00	1	-360.00	360.00;
2054	2134	0.01636	0.33730	0.00000	9900.00	9900.00	9900.00	0.9911	0.00	1	-360.00	360.00;
2065	2203	0.01060	0.28600	0.00000	9900.00	9900.00	9900.00	0.9360	0.00	1	-360.00	360.00;
2067	2203	0.01050	0.28600	0.00000	9900.00	9900.00	9900.00	0.9349	0.00	1	-360.00	360.00;
1885	2204	0.02857	0.45714	0.00000	9900.00	9900.00	9900.00	1.0251	0.00	1	-360.00	360.00;
2096	2120	0.00300	0.09970	0.00000	9900.00	9900.00	9900.00	1.0039	0.00	1	-360.00	360.00;
2096	2121	0.00230	0.08900	0.00000	9900.00	9900.00	9900.00	0.9982	0.00	1	-360.00	360.00;
2096	2205	0.04040	0.66700	0.00000	9900.00	9900.00	9900.00	1.0278	0.00	1	-360.00	360.00;
2096	2206	0.04040	0.66700	0.00000	9900.00	9900.00	9900.00	1.0278	0.00	1	-360.00	360.00;
2096	2207	0.02580	0.42330	0.00000	9900.00	9900.00	9900.00	0.9943	0.00	1	-360.00	360.00;
2136	2208	0.01260	0.32400	0.00000	9900.00	9900.00	9900.00	1.0371	0.00	1	-360.00	360.00;
2137	2209	0.01240	0.32600	0.00000	9900.00	9900.00	9900.00	1.0371	0.00	1	-360.00	360.00;
2097	2210	0.01050	0.28530	0.00000	9900.00	9900.00	9900.00	0.9889	0.00	1	-360.00	360.00;
2100	2210	0.01050	0.28400	0.00000	9900.00	9900.00	9900.00	0.9889	0.00	1	-360.00	360.00;
2150	2142	0.00220	0.08910	0.00000	9900.00	9900.00	9900.00	0.9852	0.00	1	-360.00	360.00;
2150	2211	0.00800	0.18980	0.00000	9900.00	9900.00	9900.00	0.9558	0.00	1	-360.00	360.00;
2151	2116	0.00220	0.08870	0.00000	9900.00	9900.00	9900.00	0.9846	0.00	1	-360.00	360.00;
2151	2211	0.00800	0.19520	0.00000	9900.00	9900.00	9900.00	0.9556	0.00	1	-360.00	360.00;
2000	2124	0.01800	0.29870	0.00000	9900.00	9900.00	9900.00	0.9889	0.00	1	-360.00	360.00;
2002	2124	0.01800	0.29870	0.00000	9900.00	9900.00	9900.00	0.9889	0.00	1	-360.00	360.00;
2154	2212	0.01470	0.56670	0.00000	9900.00	9900.00	9900.00	0.9847	0.00	1	-360.00	360.00;
2155	2212	0.01470	0.56670	0.00000	9900.00	9900.00	9900.00	0.9847	0.00	1	-360.00	360.00;
2089	2212	0.00000	0.67300	0.00000	9900.00	9900.00	9900.00	0.9967	0.00	1	-360.00	360.00;
2033	2213	0.00910	0.27000	0.00000	9900.00	9900.00	9900.00	0.9468	0.00	1	-360.00	360.00;
2034	2213	0.00900	0.27830	0.00000	9900.00	9900.00	9900.00	0.9464	0.00	1	-360.00	360.00;
2214	1916	0.00000	0.70000	0.00000	9900.00	9900.00	9900.00	0.9506	0.00	1	-360.00	360.00;
2126	2215	0.01040	0.27730	0.00000	9900.00	9900.00	9900.00	0.9886	0.00	1	-360.00	360.00;
2128	2215	0.01040	0.27730	0.00000	9900.00	9900.00	9900.00	0.9886	0.00	1	-360.00	360.00;
2113	2162	0.01800	0.28000	0.00000	9900.00	9900.00	9900.00	0.9673	0.00	1	-360.00	360.00;
2104	2162	0.01800	0.28000	0.00000	9900.00	9900.00	9900.00	0.9662	0.00	1	-360.00	360.00;
1956	2164	0.00410	0.11780	0.00000	9900.00	9900.00	9900.00	0.9364	0.00	1	-360.00	360.00;
1956	2122	0.00280	0.11730	0.00000	9900.00	9900.00	9900.00	0.9395	0.00	1	-360.00	360.00;
1956	2165	0.00410	0.11890	0.00000	9900.00	9900.00	9900.00	0.9388	0.00	1	-360.00	360.00;
2050	2166	0.00870	0.29030	0.00000	9900.00	9900.00	9900.00	0.9889	0.00	1	-360.00	360.00;
2051	2166	0.00733	0.23370	0.00000	9900.00	9900.00	9900.00	0.9905	0.00	1	-360.00	360.00;
2070	2216	0.01630	0.77760	0.00000	9900.00	9900.00	9900.00	0.9814	0.00	1	-360.00	360.00;
2069	2216	0.01640	0.76670	0.00000	9900.00	9900.00	9900.00	0.9820	0.00	1	-360.00	360.00;
2217	2216	0.00000	1.00000	0.00000	9900.00	9900.00	9900.00	0.9711	0.00	1	-360.00	360.00;
2217	2216	0.00000	1.00000	0.00000	9900.00	9900.00	9900.00	0.9711	0.00	1	-360.00	360.00;
2153	2218	0.00880	0.24500	0.00000	9900.00	9900.00	9900.00	0.9533	0.00	1	-360.00	360.00;
2152	2218	0.00880	0.24500	0.00000	9900.00	9900.00	9900.00	0.9533	0.00	1	-360.00	360.00;
2045	2219	0.00620	0.27240	0.00000	9900.00	9900.00	9900.00	0.9506	0.00	1	-360.00	360.00;
2046	2219	0.00610	0.27310	0.00000	9900.00	9900.00	9900.00	0.9505	0.00	1	-360.00	360.00;
2168	2220	0.00880	0.26444	0.00000	9900.00	9900.00	9900.00	0.9616	0.00	1	-360.00	360.00;
2169	2170	0.02110	0.30200	0.00000	9900.00	9900.00	9900.00	1.0019	0.00	1	-360.00	360.00;
2160	2221	0.01800	0.41190	0.00000	9900.00	9900.00	9900.00	1.0344	0.00	1	-360.00	360.00;
2161	2222	0.01800	0.41190	0.00000	9900.00	9900.00	9900.00	1.0344	0.00	1	-360.00	360.00;
2156	2223	0.02280	0.93870	0.00000	9900.00	9900.00	9900.00	0.9864	0.00	1	-360.00	360.00;
2158	2223	0.02280	0.92800	0.00000	9900.00	9900.00	9900.00	0.9865	0.00	1	-360.00	360.00;
2171	2173	0.02420	0.41000	0.00000	9900.00	9900.00	9900.00	0.9639	0.00	1	-360.00	360.00;
2172	2173	0.02130	0.38530	0.00000	9900.00	9900.00	9900.00	0.9496	0.00	1	-360.00	360.00;
2174	2224	0.04000	0.40000	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2088	2175	0.00880	0.27780	0.00000	9900.00	9900.00	9900.00	0.9945	0.00	1	-360.00	360.00;
1980	2176	0.01111	0.28000	0.00000	9900.00	9900.00	9900.00	0.9869	0.00	1	-360.00	360.00;
1970	2177	0.00417	0.20000	0.00000	9900.00	9900.00	9900.00	1.0177	0.00	1	-360.00	360.00;
2105	2178	0.02857	0.45714	0.00000	9900.00	9900.00	9900.00	1.0440	0.00	1	-360.00	360.00;
1964	1843	0.00900	0.28340	0.00000	9900.00	9900.00	9900.00	1.0139	0.00	1	-360.00	360.00;
1968	1845	0.00900	0.28340	0.00000	9900.00	9900.00	9900.00	1.0156	0.00	1	-360.00	360.00;
2094	2081	0.00700	0.21000	0.00000	9900.00	9900.00	9900.00	1.0010	0.00	1	-360.00	360.00;
2044	2117	0.00310	0.10240	0.00000	9900.00	9900.00	9900.00	0.9748	0.00	1	-360.00	360.00;
2096	1978	0.00230	0.08900	0.00000	9900.00	9900.00	9900.00	1.0083	0.00	1	-360.00	360.00;
1959	1931	0.00500	0.20000	0.00000	9900.00	9900.00	9900.00	0.9630	0.00	1	-360.00	360.00;
1841	2071	0.00073	0.01875	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1839	2073	0.00073	0.01875	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
2080	1988	0.00177	0.03600	0.89999	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1078	1382	0.00349	0.09143	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1078	1383	0.00349	0.09143	0.00000	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1081	473	0.00164	0.08332	-0.00208	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
1080	473	0.00167	0.08373	-0.00261	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
971	394	0.00100	0.07999	-0.00317	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
971	394	0.00126	0.08445	-0.00317	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
971	394	0.00150	0.08040	-0.00317	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
971	394	0.00111	0.08353	-0.00317	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
972	348	0.00107	0.07958	-0.00286	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
972	348	0.00102	0.07958	-0.00277	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
972	938	0.00290	0.12255	-0.01924	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
972	938	0.00308	0.12270	-0.00715	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
973	109	0.00176	0.07987	-0.00652	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
973	112	0.00176	0.07946	-0.00664	9900.00	9900.00	9900.00	0.0000	0.00	1	-360.00	360.00;
];
mpc.areas =[
1 1;
];
%% Generator Cost Data (Made up)
mpc.gencost = [
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.50	1.00;
2	0	0	3	0.10	1.50	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.10	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.10	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.10	0.00;
2	0	0	3	0.10	0.10	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.50	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	2.00	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.00	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	0.00;
2	0	0	3	0.10	1.50	1.00;
2	0	0	3	0.10	1.50	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	0.50	0.10;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
2	0	0	3	0.10	2.00	1.00;
];
