# Hydrilla (Python implementation)

This is the repository of Python incarnation of [Hydrilla](https://hydrillabugs.koszko.org/projects/hydrilla/wiki), a repository software to serve [Haketilo](https://hydrillabugs.koszko.org/projects/haketilo/wiki) packages.

The information below is meant to help hack on the codebase. If you're instead looking for some noob-friendly documentation, see the [user manual](https://hydrillabugs.koszko.org/projects/hydrilla/wiki/User_manual).

## Dependencies

### Runtime

* Python3 (>= 3.7)
* [hydrilla.builder](https://git.koszko.org/hydrilla-builder/)
* flask (>= 1.1)
* click
* jsonschema (>= 3.0)

### Build

* build (a PEP517 package builder)
* setuptools
* wheel
* setuptools_scm
* babel (Python library)

### Test

* pytest

## Building

We're using setuptools. You can build a wheel under `dist/` with
``` shell
python3 -m build
```
Optionally, add a `--no-isolation` option to the second command to have it use system packages where possible instead of downloading all dependencies from PyPI.

The generated .whl file can then be used to install Hydrilla either globally or in the current Python virtualenv:
```shell
python3 -m pip install dist/put_the_name_of_generated_file_here.whl
```

### PyPI considerations

Commands like `python3 -m build` and `python3 -m pip` but also `virtualenv` will by default download the dependencies from PyPI repository[^pypi]. Although this is what many people want, it carries along a freedom issue. PyPI is not committed to only hosting libre software packages[^pypi_freeware] and, like any platform allowing upload of code by the public, has lower package standards than repositories of many operating system distributions. For this reason you are encouraged to use the dependencies as provided by your distribution.

To perform the build and installation without PyPI, first install all dependencies system-wide. For example, in Debian-based distributions (including Trisquel):
``` shell
sudo apt install python3-flask python3-flask python3-jsonschema \
     python3-setuptools python3-setuptools-scm python3-babel python3-wheel \
     python3-build
```

If you're using `virtualenv` command to create a virtual environment, make sure you invoke it with `--system-site-packages` and `--no-download`. The first option is necessary for packages installed inside the virtualenv to be able to use globally-installed dependencies. The second one will make `virtualenv` use locally-available base libraries (setuptools, etc.) instead of downloading them from PyPI.

Now, in unpacked source directories of **both** `hydrilla-builder` and `hydrilla`, run the build and installation commands:
``` shell
python3 -m build --no-isolation
python3 -m pip install dist/hydrilla*.whl # or use the full file name
```

[^pypi]: [https://pypi.org/](https://pypi.org/)
[^pypi_freeware]: [https://pypi.org/search/?c=License+%3A%3A+Freeware](https://pypi.org/search/?c=License+%3A%3A+Freeware)

## Testing

For tests to pass you need compiled message catalogs to be present. If you've performed the build at least once, they're already there. Otherwise, you need to run `./setup.py compile_catalog`. Then you can run the actual tests:
``` shell
python3 -m pytest
```

## Installation from wheels

Instead of building yourself you can use Python wheels provided on [Hydrilla downloads page](https://hydrillabugs.koszko.org/projects/hydrilla/wiki/Releases).

``` shell
python3 -m pip install \
    path/to/downloaded/hydrilla.builder-1.1b1-py3-none-any.whl \
    path/to/downloaded/hydrilla-1.1b1-py3-none-any.whl
```

## Running

### Hydrilla command

Hydrilla includes a `hydrilla` shell command that can be used to quickly and easily spawn a local instance, e.g.:
```
hydrilla -m /path/to/where/package/files/to/serve/are/stored -p 10112
```
This will cause the resources from provided path to be served at [http://127.0.0.1:10112/](http://127.0.0.1:10112/).

The actual packages to serve are made using [Hydrilla builder](https://git.koszko.org/hydrilla-builder/).

For more information about available options, pass the `--help` flag to `hydrilla` command:
``` shell
hydrilla --help
```

If you navigate your POSIX shell to Hydrilla sources directory, you can also consult the included manpage (`man` tool required):
``` shell
man ./doc/man/man1/hydrilla.1
```

Last but not least, you might find it useful to consult the default, internal configuration file of Hydrilla that resides under `src/hydrilla/server/config.json` in the sources repository.

### WSGI

If you want to test a more production-suitable deployment option, consult sample Apache2 config files and a WSGI script supplied in `doc/examples` directory.

## Copying

Hydrilla is Copyright (C) 2021-2022 Wojtek Kosior and contributors, entirely available under the GNU Affero General Public License version 3 or later. Some files might also give you broader permissions, see comments inside them.

*I, Wojtek Kosior, thereby promise not to sue for violation of this project's license. Although I request that you do not make use this code in a proprietary program, I am not going to enforce this in court.*

## Contributing

Please visit our Redmine instance at https://hydrillabugs.koszko.org.

You can also write an email to koszko@koszko.org.
