import { Construct } from 'constructs';
import { Destination } from './destination';
import { Source } from './source';
export interface DockerImageDeploymentProps {
    /**
     * Source of the image to deploy.
     */
    readonly source: Source;
    /**
     * Destination repository to deploy the image to.
     */
    readonly destination: Destination;
}
/**
 * `DockerImageDeployment` pushes an image from a local or external source to a specified external destination
 */
export declare class DockerImageDeployment extends Construct {
    private readonly cb;
    constructor(scope: Construct, id: string, props: DockerImageDeploymentProps);
    private validateTag;
}
