# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Saml']


class Saml(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 assertion_signed: Optional[pulumi.Input[bool]] = None,
                 attribute_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authn_context_class_ref: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 default_relay_state: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 digest_algorithm: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 honor_force_authn: Optional[pulumi.Input[bool]] = None,
                 idp_issuer: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_years_valid: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 preconfigured_app: Optional[pulumi.Input[str]] = None,
                 recipient: Optional[pulumi.Input[str]] = None,
                 request_compressed: Optional[pulumi.Input[bool]] = None,
                 response_signed: Optional[pulumi.Input[bool]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 sp_issuer: Optional[pulumi.Input[str]] = None,
                 sso_url: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_name_id_format: Optional[pulumi.Input[str]] = None,
                 subject_name_id_template: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an SAML Application.

        This resource allows you to create and configure an SAML Application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.app.Saml("example",
            attribute_statements=[okta.app.SamlAttributeStatementArgs(
                filter_type="REGEX",
                filter_value=".*",
                name="groups",
                type="GROUP",
            )],
            audience="http://example.com/audience",
            authn_context_class_ref="urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport",
            destination="http://example.com",
            digest_algorithm="SHA256",
            honor_force_authn=False,
            label="example",
            recipient="http://example.com",
            response_signed=True,
            signature_algorithm="RSA_SHA256",
            sso_url="http://example.com",
            subject_name_id_format="urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
            subject_name_id_template=user["userName"])
        ```

        ## Import

        A SAML App can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:app/saml:Saml example <app id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL.
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL.
        :param pulumi.Input[bool] accessibility_self_service: Enable self service.
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format.
        :param pulumi.Input[bool] assertion_signed: Determines whether the SAML assertion is digitally signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]] attribute_statements: List of SAML Attribute statements.
        :param pulumi.Input[str] audience: Audience restriction.
        :param pulumi.Input[str] authn_context_class_ref: Identifies the SAML authentication context class for the assertion’s authentication statement.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar.
        :param pulumi.Input[str] default_relay_state: Identifies a specific application resource in an IDP initiated SSO scenario.
        :param pulumi.Input[str] destination: Identifies the location where the SAML response is intended to be sent inside of the SAML assertion.
        :param pulumi.Input[str] digest_algorithm: Determines the digest algorithm used to digitally sign the SAML assertion and response.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: features enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app.
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[bool] honor_force_authn: Prompt user to re-authenticate if SP asks for it.
        :param pulumi.Input[str] idp_issuer: SAML issuer ID.
        :param pulumi.Input[str] key_name: Certificate name. This modulates the rotation of keys. New name == new key.
        :param pulumi.Input[int] key_years_valid: Number of years the certificate is valid.
        :param pulumi.Input[str] label: label of application.
        :param pulumi.Input[str] preconfigured_app: name of application from the Okta Integration Network, if not included a custom app will be created.
        :param pulumi.Input[str] recipient: The location where the app may present the SAML assertion.
        :param pulumi.Input[bool] request_compressed: Denotes whether the request is compressed or not.
        :param pulumi.Input[bool] response_signed: Determines whether the SAML auth response message is digitally signed.
        :param pulumi.Input[str] signature_algorithm: Signature algorithm used ot digitally sign the assertion and response.
        :param pulumi.Input[str] sp_issuer: SAML service provider issuer.
        :param pulumi.Input[str] sso_url: Single Sign on Url.
        :param pulumi.Input[str] status: status of application.
        :param pulumi.Input[str] subject_name_id_format: Identifies the SAML processing rules.
        :param pulumi.Input[str] subject_name_id_template: Template for app user's username when a user is assigned to the app.
        :param pulumi.Input[str] user_name_template: Username template.
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix.
        :param pulumi.Input[str] user_name_template_type: Username template type.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]] users: Users associated with the application
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['accessibility_error_redirect_url'] = accessibility_error_redirect_url
            __props__['accessibility_login_redirect_url'] = accessibility_login_redirect_url
            __props__['accessibility_self_service'] = accessibility_self_service
            __props__['app_settings_json'] = app_settings_json
            __props__['assertion_signed'] = assertion_signed
            __props__['attribute_statements'] = attribute_statements
            __props__['audience'] = audience
            __props__['authn_context_class_ref'] = authn_context_class_ref
            __props__['auto_submit_toolbar'] = auto_submit_toolbar
            __props__['default_relay_state'] = default_relay_state
            __props__['destination'] = destination
            __props__['digest_algorithm'] = digest_algorithm
            __props__['features'] = features
            __props__['groups'] = groups
            __props__['hide_ios'] = hide_ios
            __props__['hide_web'] = hide_web
            __props__['honor_force_authn'] = honor_force_authn
            __props__['idp_issuer'] = idp_issuer
            __props__['key_name'] = key_name
            __props__['key_years_valid'] = key_years_valid
            if label is None:
                raise TypeError("Missing required property 'label'")
            __props__['label'] = label
            __props__['preconfigured_app'] = preconfigured_app
            __props__['recipient'] = recipient
            __props__['request_compressed'] = request_compressed
            __props__['response_signed'] = response_signed
            __props__['signature_algorithm'] = signature_algorithm
            __props__['sp_issuer'] = sp_issuer
            __props__['sso_url'] = sso_url
            __props__['status'] = status
            __props__['subject_name_id_format'] = subject_name_id_format
            __props__['subject_name_id_template'] = subject_name_id_template
            __props__['user_name_template'] = user_name_template
            __props__['user_name_template_suffix'] = user_name_template_suffix
            __props__['user_name_template_type'] = user_name_template_type
            __props__['users'] = users
            __props__['certificate'] = None
            __props__['entity_key'] = None
            __props__['entity_url'] = None
            __props__['http_post_binding'] = None
            __props__['http_redirect_binding'] = None
            __props__['key_id'] = None
            __props__['metadata'] = None
            __props__['name'] = None
            __props__['sign_on_mode'] = None
        super(Saml, __self__).__init__(
            'okta:app/saml:Saml',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_self_service: Optional[pulumi.Input[bool]] = None,
            app_settings_json: Optional[pulumi.Input[str]] = None,
            assertion_signed: Optional[pulumi.Input[bool]] = None,
            attribute_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]]] = None,
            audience: Optional[pulumi.Input[str]] = None,
            authn_context_class_ref: Optional[pulumi.Input[str]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            default_relay_state: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[str]] = None,
            digest_algorithm: Optional[pulumi.Input[str]] = None,
            entity_key: Optional[pulumi.Input[str]] = None,
            entity_url: Optional[pulumi.Input[str]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hide_ios: Optional[pulumi.Input[bool]] = None,
            hide_web: Optional[pulumi.Input[bool]] = None,
            honor_force_authn: Optional[pulumi.Input[bool]] = None,
            http_post_binding: Optional[pulumi.Input[str]] = None,
            http_redirect_binding: Optional[pulumi.Input[str]] = None,
            idp_issuer: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            key_years_valid: Optional[pulumi.Input[int]] = None,
            label: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            preconfigured_app: Optional[pulumi.Input[str]] = None,
            recipient: Optional[pulumi.Input[str]] = None,
            request_compressed: Optional[pulumi.Input[bool]] = None,
            response_signed: Optional[pulumi.Input[bool]] = None,
            sign_on_mode: Optional[pulumi.Input[str]] = None,
            signature_algorithm: Optional[pulumi.Input[str]] = None,
            sp_issuer: Optional[pulumi.Input[str]] = None,
            sso_url: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subject_name_id_format: Optional[pulumi.Input[str]] = None,
            subject_name_id_template: Optional[pulumi.Input[str]] = None,
            user_name_template: Optional[pulumi.Input[str]] = None,
            user_name_template_suffix: Optional[pulumi.Input[str]] = None,
            user_name_template_type: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]]] = None) -> 'Saml':
        """
        Get an existing Saml resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL.
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL.
        :param pulumi.Input[bool] accessibility_self_service: Enable self service.
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format.
        :param pulumi.Input[bool] assertion_signed: Determines whether the SAML assertion is digitally signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]] attribute_statements: List of SAML Attribute statements.
        :param pulumi.Input[str] audience: Audience restriction.
        :param pulumi.Input[str] authn_context_class_ref: Identifies the SAML authentication context class for the assertion’s authentication statement.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar.
        :param pulumi.Input[str] certificate: The raw signing certificate.
        :param pulumi.Input[str] default_relay_state: Identifies a specific application resource in an IDP initiated SSO scenario.
        :param pulumi.Input[str] destination: Identifies the location where the SAML response is intended to be sent inside of the SAML assertion.
        :param pulumi.Input[str] digest_algorithm: Determines the digest algorithm used to digitally sign the SAML assertion and response.
        :param pulumi.Input[str] entity_key: Entity ID, the ID portion of the `entity_url`.
        :param pulumi.Input[str] entity_url: Entity URL for instance http://www.okta.com/exk1fcia6d6EMsf331d8.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: features enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app.
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[bool] honor_force_authn: Prompt user to re-authenticate if SP asks for it.
        :param pulumi.Input[str] http_post_binding: `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post` location from the SAML metadata.
        :param pulumi.Input[str] http_redirect_binding: `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect` location from the SAML metadata.
        :param pulumi.Input[str] idp_issuer: SAML issuer ID.
        :param pulumi.Input[str] key_id: Certificate key ID.
        :param pulumi.Input[str] key_name: Certificate name. This modulates the rotation of keys. New name == new key.
        :param pulumi.Input[int] key_years_valid: Number of years the certificate is valid.
        :param pulumi.Input[str] label: label of application.
        :param pulumi.Input[str] metadata: The raw SAML metadata in XML.
        :param pulumi.Input[str] name: The name of the attribute statement.
        :param pulumi.Input[str] preconfigured_app: name of application from the Okta Integration Network, if not included a custom app will be created.
        :param pulumi.Input[str] recipient: The location where the app may present the SAML assertion.
        :param pulumi.Input[bool] request_compressed: Denotes whether the request is compressed or not.
        :param pulumi.Input[bool] response_signed: Determines whether the SAML auth response message is digitally signed.
        :param pulumi.Input[str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[str] signature_algorithm: Signature algorithm used ot digitally sign the assertion and response.
        :param pulumi.Input[str] sp_issuer: SAML service provider issuer.
        :param pulumi.Input[str] sso_url: Single Sign on Url.
        :param pulumi.Input[str] status: status of application.
        :param pulumi.Input[str] subject_name_id_format: Identifies the SAML processing rules.
        :param pulumi.Input[str] subject_name_id_template: Template for app user's username when a user is assigned to the app.
        :param pulumi.Input[str] user_name_template: Username template.
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix.
        :param pulumi.Input[str] user_name_template_type: Username template type.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]] users: Users associated with the application
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
        __props__["accessibility_self_service"] = accessibility_self_service
        __props__["app_settings_json"] = app_settings_json
        __props__["assertion_signed"] = assertion_signed
        __props__["attribute_statements"] = attribute_statements
        __props__["audience"] = audience
        __props__["authn_context_class_ref"] = authn_context_class_ref
        __props__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__["certificate"] = certificate
        __props__["default_relay_state"] = default_relay_state
        __props__["destination"] = destination
        __props__["digest_algorithm"] = digest_algorithm
        __props__["entity_key"] = entity_key
        __props__["entity_url"] = entity_url
        __props__["features"] = features
        __props__["groups"] = groups
        __props__["hide_ios"] = hide_ios
        __props__["hide_web"] = hide_web
        __props__["honor_force_authn"] = honor_force_authn
        __props__["http_post_binding"] = http_post_binding
        __props__["http_redirect_binding"] = http_redirect_binding
        __props__["idp_issuer"] = idp_issuer
        __props__["key_id"] = key_id
        __props__["key_name"] = key_name
        __props__["key_years_valid"] = key_years_valid
        __props__["label"] = label
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["preconfigured_app"] = preconfigured_app
        __props__["recipient"] = recipient
        __props__["request_compressed"] = request_compressed
        __props__["response_signed"] = response_signed
        __props__["sign_on_mode"] = sign_on_mode
        __props__["signature_algorithm"] = signature_algorithm
        __props__["sp_issuer"] = sp_issuer
        __props__["sso_url"] = sso_url
        __props__["status"] = status
        __props__["subject_name_id_format"] = subject_name_id_format
        __props__["subject_name_id_template"] = subject_name_id_template
        __props__["user_name_template"] = user_name_template
        __props__["user_name_template_suffix"] = user_name_template_suffix
        __props__["user_name_template_type"] = user_name_template_type
        __props__["users"] = users
        return Saml(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom error page URL.
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom login page URL.
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable self service.
        """
        return pulumi.get(self, "accessibility_self_service")

    @property
    @pulumi.getter(name="appSettingsJson")
    def app_settings_json(self) -> pulumi.Output[Optional[str]]:
        """
        Application settings in JSON format.
        """
        return pulumi.get(self, "app_settings_json")

    @property
    @pulumi.getter(name="assertionSigned")
    def assertion_signed(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether the SAML assertion is digitally signed.
        """
        return pulumi.get(self, "assertion_signed")

    @property
    @pulumi.getter(name="attributeStatements")
    def attribute_statements(self) -> pulumi.Output[Optional[Sequence['outputs.SamlAttributeStatement']]]:
        """
        List of SAML Attribute statements.
        """
        return pulumi.get(self, "attribute_statements")

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Output[Optional[str]]:
        """
        Audience restriction.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies the SAML authentication context class for the assertion’s authentication statement.
        """
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[bool]]:
        """
        Display auto submit toolbar.
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The raw signing certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="defaultRelayState")
    def default_relay_state(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies a specific application resource in an IDP initiated SSO scenario.
        """
        return pulumi.get(self, "default_relay_state")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies the location where the SAML response is intended to be sent inside of the SAML assertion.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Determines the digest algorithm used to digitally sign the SAML assertion and response.
        """
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="entityKey")
    def entity_key(self) -> pulumi.Output[str]:
        """
        Entity ID, the ID portion of the `entity_url`.
        """
        return pulumi.get(self, "entity_key")

    @property
    @pulumi.getter(name="entityUrl")
    def entity_url(self) -> pulumi.Output[str]:
        """
        Entity URL for instance http://www.okta.com/exk1fcia6d6EMsf331d8.
        """
        return pulumi.get(self, "entity_url")

    @property
    @pulumi.getter
    def features(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        features enabled.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon on mobile app.
        """
        return pulumi.get(self, "hide_ios")

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @property
    @pulumi.getter(name="honorForceAuthn")
    def honor_force_authn(self) -> pulumi.Output[Optional[bool]]:
        """
        Prompt user to re-authenticate if SP asks for it.
        """
        return pulumi.get(self, "honor_force_authn")

    @property
    @pulumi.getter(name="httpPostBinding")
    def http_post_binding(self) -> pulumi.Output[str]:
        """
        `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post` location from the SAML metadata.
        """
        return pulumi.get(self, "http_post_binding")

    @property
    @pulumi.getter(name="httpRedirectBinding")
    def http_redirect_binding(self) -> pulumi.Output[str]:
        """
        `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect` location from the SAML metadata.
        """
        return pulumi.get(self, "http_redirect_binding")

    @property
    @pulumi.getter(name="idpIssuer")
    def idp_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        SAML issuer ID.
        """
        return pulumi.get(self, "idp_issuer")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        Certificate key ID.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate name. This modulates the rotation of keys. New name == new key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyYearsValid")
    def key_years_valid(self) -> pulumi.Output[Optional[int]]:
        """
        Number of years the certificate is valid.
        """
        return pulumi.get(self, "key_years_valid")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        label of application.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        The raw SAML metadata in XML.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the attribute statement.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preconfiguredApp")
    def preconfigured_app(self) -> pulumi.Output[Optional[str]]:
        """
        name of application from the Okta Integration Network, if not included a custom app will be created.
        """
        return pulumi.get(self, "preconfigured_app")

    @property
    @pulumi.getter
    def recipient(self) -> pulumi.Output[Optional[str]]:
        """
        The location where the app may present the SAML assertion.
        """
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="requestCompressed")
    def request_compressed(self) -> pulumi.Output[Optional[bool]]:
        """
        Denotes whether the request is compressed or not.
        """
        return pulumi.get(self, "request_compressed")

    @property
    @pulumi.getter(name="responseSigned")
    def response_signed(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether the SAML auth response message is digitally signed.
        """
        return pulumi.get(self, "response_signed")

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[str]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Signature algorithm used ot digitally sign the assertion and response.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="spIssuer")
    def sp_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        SAML service provider issuer.
        """
        return pulumi.get(self, "sp_issuer")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> pulumi.Output[Optional[str]]:
        """
        Single Sign on Url.
        """
        return pulumi.get(self, "sso_url")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        status of application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subjectNameIdFormat")
    def subject_name_id_format(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies the SAML processing rules.
        """
        return pulumi.get(self, "subject_name_id_format")

    @property
    @pulumi.getter(name="subjectNameIdTemplate")
    def subject_name_id_template(self) -> pulumi.Output[Optional[str]]:
        """
        Template for app user's username when a user is assigned to the app.
        """
        return pulumi.get(self, "subject_name_id_template")

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> pulumi.Output[Optional[str]]:
        """
        Username template.
        """
        return pulumi.get(self, "user_name_template")

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        Username template suffix.
        """
        return pulumi.get(self, "user_name_template_suffix")

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> pulumi.Output[Optional[str]]:
        """
        Username template type.
        """
        return pulumi.get(self, "user_name_template_type")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.SamlUser']]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

