# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Server']


class Server(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 credentials_rotation_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 issuer_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an Authorization Server.

        This resource allows you to create and configure an Authorization Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.Server("example",
            audiences=["api://example"],
            description="My Example Auth Server",
            issuer_mode="CUSTOM_URL",
            status="ACTIVE")
        ```

        ## Import

        Authorization Server can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:auth/server:Server example <auth server id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audiences: The recipients that the tokens are intended for. This becomes the `aud` claim in an access token.
        :param pulumi.Input[str] credentials_rotation_mode: The key rotation mode for the authorization server. Can be `"AUTO"` or `"MANUAL"`.
        :param pulumi.Input[str] description: The description of the authorization server.
        :param pulumi.Input[str] issuer_mode: Allows you to use a custom issuer URL. It can be set to `"CUSTOM_URL"` or `"ORG_URL"`
        :param pulumi.Input[str] name: The name of the authorization server.
        :param pulumi.Input[str] status: The status of the auth server. It defaults to `"ACTIVE"`
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if audiences is None:
                raise TypeError("Missing required property 'audiences'")
            __props__['audiences'] = audiences
            __props__['credentials_rotation_mode'] = credentials_rotation_mode
            __props__['description'] = description
            __props__['issuer_mode'] = issuer_mode
            __props__['name'] = name
            __props__['status'] = status
            __props__['credentials_last_rotated'] = None
            __props__['credentials_next_rotation'] = None
            __props__['issuer'] = None
            __props__['kid'] = None
        super(Server, __self__).__init__(
            'okta:auth/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            credentials_last_rotated: Optional[pulumi.Input[str]] = None,
            credentials_next_rotation: Optional[pulumi.Input[str]] = None,
            credentials_rotation_mode: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            issuer_mode: Optional[pulumi.Input[str]] = None,
            kid: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audiences: The recipients that the tokens are intended for. This becomes the `aud` claim in an access token.
        :param pulumi.Input[str] credentials_last_rotated: The timestamp when the authorization server started to use the `kid` for signing tokens.
        :param pulumi.Input[str] credentials_next_rotation: The timestamp when the authorization server changes the key for signing tokens. Only returned when `credentials_rotation_mode` is `"AUTO"`.
        :param pulumi.Input[str] credentials_rotation_mode: The key rotation mode for the authorization server. Can be `"AUTO"` or `"MANUAL"`.
        :param pulumi.Input[str] description: The description of the authorization server.
        :param pulumi.Input[str] issuer: The complete URL for a Custom Authorization Server. This becomes the `iss` claim in an access token.
        :param pulumi.Input[str] issuer_mode: Allows you to use a custom issuer URL. It can be set to `"CUSTOM_URL"` or `"ORG_URL"`
        :param pulumi.Input[str] kid: The ID of the JSON Web Key used for signing tokens issued by the authorization server.
        :param pulumi.Input[str] name: The name of the authorization server.
        :param pulumi.Input[str] status: The status of the auth server. It defaults to `"ACTIVE"`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["audiences"] = audiences
        __props__["credentials_last_rotated"] = credentials_last_rotated
        __props__["credentials_next_rotation"] = credentials_next_rotation
        __props__["credentials_rotation_mode"] = credentials_rotation_mode
        __props__["description"] = description
        __props__["issuer"] = issuer
        __props__["issuer_mode"] = issuer_mode
        __props__["kid"] = kid
        __props__["name"] = name
        __props__["status"] = status
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def audiences(self) -> pulumi.Output[Sequence[str]]:
        """
        The recipients that the tokens are intended for. This becomes the `aud` claim in an access token.
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter(name="credentialsLastRotated")
    def credentials_last_rotated(self) -> pulumi.Output[str]:
        """
        The timestamp when the authorization server started to use the `kid` for signing tokens.
        """
        return pulumi.get(self, "credentials_last_rotated")

    @property
    @pulumi.getter(name="credentialsNextRotation")
    def credentials_next_rotation(self) -> pulumi.Output[str]:
        """
        The timestamp when the authorization server changes the key for signing tokens. Only returned when `credentials_rotation_mode` is `"AUTO"`.
        """
        return pulumi.get(self, "credentials_next_rotation")

    @property
    @pulumi.getter(name="credentialsRotationMode")
    def credentials_rotation_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The key rotation mode for the authorization server. Can be `"AUTO"` or `"MANUAL"`.
        """
        return pulumi.get(self, "credentials_rotation_mode")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the authorization server.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        The complete URL for a Custom Authorization Server. This becomes the `iss` claim in an access token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Allows you to use a custom issuer URL. It can be set to `"CUSTOM_URL"` or `"ORG_URL"`
        """
        return pulumi.get(self, "issuer_mode")

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Output[str]:
        """
        The ID of the JSON Web Key used for signing tokens issued by the authorization server.
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the authorization server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The status of the auth server. It defaults to `"ACTIVE"`
        """
        return pulumi.get(self, "status")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

