# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'HookAuth',
    'HookChannel',
    'HookHeader',
]

@pulumi.output_type
class HookAuth(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: Key to use for authentication, usually the header name, for example `"Authorization"`.
        :param str type: The type of hook to trigger. Currently only `"HTTP"` is supported.
        :param str value: Authentication secret.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key to use for authentication, usually the header name, for example `"Authorization"`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of hook to trigger. Currently only `"HTTP"` is supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Authentication secret.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HookChannel(dict):
    def __init__(__self__, *,
                 uri: str,
                 version: str,
                 method: Optional[str] = None,
                 type: Optional[bool] = None):
        """
        :param str uri: The URI the hook will hit.
        :param str version: The version of the endpoint.
        :param str method: The request method to use. Default is `"POST"`.
        :param bool type: The type of hook to trigger. Currently only `"HTTP"` is supported.
        """
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "version", version)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI the hook will hit.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the endpoint.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The request method to use. Default is `"POST"`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def type(self) -> Optional[bool]:
        """
        The type of hook to trigger. Currently only `"HTTP"` is supported.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HookHeader(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: Key to use for authentication, usually the header name, for example `"Authorization"`.
        :param str value: Authentication secret.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key to use for authentication, usually the header name, for example `"Authorization"`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Authentication secret.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


