# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AdminRoleTargetsArgs', 'AdminRoleTargets']

@pulumi.input_type
class AdminRoleTargetsArgs:
    def __init__(__self__, *,
                 role_type: pulumi.Input[str],
                 user_id: pulumi.Input[str],
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AdminRoleTargets resource.
        :param pulumi.Input[str] role_type: Name of the role associated with the user. See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[str] user_id: ID of the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: List of group IDs. Conflicts with `apps`.
        """
        pulumi.set(__self__, "role_type", role_type)
        pulumi.set(__self__, "user_id", user_id)
        if apps is not None:
            pulumi.set(__self__, "apps", apps)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Input[str]:
        """
        Name of the role associated with the user. See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_type", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        """
        return pulumi.get(self, "apps")

    @apps.setter
    def apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "apps", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of group IDs. Conflicts with `apps`.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)


@pulumi.input_type
class _AdminRoleTargetsState:
    def __init__(__self__, *,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_id: Optional[pulumi.Input[str]] = None,
                 role_type: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AdminRoleTargets resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: List of group IDs. Conflicts with `apps`.
        :param pulumi.Input[str] role_id: Role ID.
        :param pulumi.Input[str] role_type: Name of the role associated with the user. See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[str] user_id: ID of the user.
        """
        if apps is not None:
            pulumi.set(__self__, "apps", apps)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        """
        return pulumi.get(self, "apps")

    @apps.setter
    def apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "apps", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of group IDs. Conflicts with `apps`.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[str]]:
        """
        Role ID.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role associated with the user. See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_type", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class AdminRoleTargets(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_type: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages targets for administrator roles.

        This resource allows you to define permissions for admin roles into a smaller subset of Groups or Apps within your org.
        You can define admin roles to target Groups, Applications, and Application Instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.AdminRoleTargets("example",
            apps=[
                "oidc_client.<app_id>",
                "facebook",
            ],
            role_type="APP_ADMIN",
            user_id="<user_id>")
        ```

        ## Import

        Okta Admin Role Targets can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/adminRoleTargets:AdminRoleTargets example &#60;user id&#62;/&#60;role type&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: List of group IDs. Conflicts with `apps`.
        :param pulumi.Input[str] role_type: Name of the role associated with the user. See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[str] user_id: ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdminRoleTargetsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages targets for administrator roles.

        This resource allows you to define permissions for admin roles into a smaller subset of Groups or Apps within your org.
        You can define admin roles to target Groups, Applications, and Application Instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.AdminRoleTargets("example",
            apps=[
                "oidc_client.<app_id>",
                "facebook",
            ],
            role_type="APP_ADMIN",
            user_id="<user_id>")
        ```

        ## Import

        Okta Admin Role Targets can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/adminRoleTargets:AdminRoleTargets example &#60;user id&#62;/&#60;role type&#62;
        ```

        :param str resource_name: The name of the resource.
        :param AdminRoleTargetsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdminRoleTargetsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_type: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdminRoleTargetsArgs.__new__(AdminRoleTargetsArgs)

            __props__.__dict__["apps"] = apps
            __props__.__dict__["groups"] = groups
            if role_type is None and not opts.urn:
                raise TypeError("Missing required property 'role_type'")
            __props__.__dict__["role_type"] = role_type
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["role_id"] = None
        super(AdminRoleTargets, __self__).__init__(
            'okta:index/adminRoleTargets:AdminRoleTargets',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            role_id: Optional[pulumi.Input[str]] = None,
            role_type: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'AdminRoleTargets':
        """
        Get an existing AdminRoleTargets resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: List of group IDs. Conflicts with `apps`.
        :param pulumi.Input[str] role_id: Role ID.
        :param pulumi.Input[str] role_type: Name of the role associated with the user. See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        :param pulumi.Input[str] user_id: ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdminRoleTargetsState.__new__(_AdminRoleTargetsState)

        __props__.__dict__["apps"] = apps
        __props__.__dict__["groups"] = groups
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["role_type"] = role_type
        __props__.__dict__["user_id"] = user_id
        return AdminRoleTargets(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def apps(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        """
        return pulumi.get(self, "apps")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of group IDs. Conflicts with `apps`.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[str]:
        """
        Role ID.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Output[str]:
        """
        Name of the role associated with the user. See [API Docs](https://developer.okta.com/docs/reference/api/roles/#role-types).
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

