# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys

sys.path.insert(0, os.path.abspath(".."))

# -- Project information -----------------------------------------------------

project = "pydsge"
copyright = "2019, Gregor Boehl"
author = "Gregor Boehl"


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
# extensions = ['sphinx.ext.napoleon', 'sphinx.ext.autodoc', 'sphinx.ext.autosectionlabel','nbsphinx']
extensions = [
    "sphinx.ext.napoleon",
    "sphinx.ext.autodoc",
    "sphinx.ext.autosectionlabel",
    "nbsphinx",
    "IPython.sphinxext.ipython_console_highlighting",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates", "**.ipynb_checkpoints"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# version = '0.1.5'

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "alabaster"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

autodoc_mock_imports = [
    "grgrlib",
    "econsieve",
    "econsieve.stats",
    "particles",
    "numpy",
    "pandas",
    "emcee",
    "kombine",
    "pathos",
    "yaml",
    "sympy",
    "scipy",
    "numba",
    "tqdm",
    "pygmo",
    "matplotlib",
    "cloudpickle",
    "dill",
]

autoclass_content = "both"
autodoc_member_order = "groupwise"


def setup(app):
    app.add_stylesheet("css/custom.css")


master_doc = "index"

html_theme_options = {
    # 'github_banner': True,
    "description": "Solving, filtering and estimating of DSGE models with occasionally binding constraints",
    "github_button": True,
    "github_repo": "pydsge",
    "github_user": "gboehl",
    "sidebar_collapse": False,
}
