/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.engine;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ru.autosome.assist.ASequence;
import ru.autosome.assist.Conductor;
import ru.autosome.assist.WordRecord;
import ru.autosome.ytilib.MunkResult;
import ru.autosome.ytilib.Sequence;
import ru.autosome.ytilib.ShapedWPCM;
import ru.autosome.ytilib.WPCM;

public class SoptiStep {
    private Sequence[] sequences;
    private double totalWeight;
    private double[] background;
    private List<Integer>[] primaryHits;
    private List<Integer>[] revcompHits;
    private double[] customShape;
    protected WPCM pm;
    public static final int GLOBAL_ITERATION_LIMIT = 1000;
    private int iterationLimit = 1000;
    private HashSet<Double> prevKDIC = new HashSet(this.iterationLimit, 1.0f);

    public List<Integer>[] getRevcompHits() {
        return this.revcompHits;
    }

    public List<Integer>[] getPrimaryHits() {
        return this.primaryHits;
    }

    public SoptiStep(Sequence[] joinedSets, double weight, double[] background, int iterationLimit) {
        this.sequences = joinedSets;
        this.totalWeight = this.sequences.length;
        this.primaryHits = (List[])Array.newInstance(List.class, this.sequences.length);
        this.revcompHits = (List[])Array.newInstance(List.class, this.sequences.length);
        for (int i = 0; i < this.sequences.length; ++i) {
            this.primaryHits[i] = new ArrayList<Integer>(17);
            this.revcompHits[i] = new ArrayList<Integer>(17);
        }
        this.background = background;
        if (iterationLimit > 1000) {
            throw new RuntimeException("too big iteration limit");
        }
        this.iterationLimit = iterationLimit;
        this.totalWeight = weight;
    }

    public SoptiStep(Sequence[] joinedSets, double weight, double[] background, int iterationLimit, double[] customShape) {
        this(joinedSets, weight, background, iterationLimit);
        this.customShape = customShape;
    }

    public MunkResult zoops(double zoopsFactor, Conductor conductor) {
        WPCM zpm = new WPCM(this.pm).toPWM(zoopsFactor * (double)this.sequences.length, this.background);
        ArrayList<Integer> sequenceOrder = new ArrayList<Integer>();
        for (int i = 0; i < this.sequences.length; ++i) {
            sequenceOrder.add(i);
        }
        final double[] bestScores = new double[this.sequences.length];
        for (int i = 0; i < this.sequences.length; ++i) {
            bestScores[i] = this.primaryHits[i].size() > 0 ? zpm.score(this.sequences[i].getDirect(), this.primaryHits[i].get(0)) : zpm.score(this.sequences[i].getRevcomp(), this.revcompHits[i].get(0));
        }
        Collections.sort(sequenceOrder, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.valueOf(bestScores[o2]).compareTo(bestScores[o1]);
            }
        });
        ArrayList<byte[]> wordsal = new ArrayList<byte[]>();
        HashMap<Integer, Integer> sequenceNumbers = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.sequences.length; ++i) {
            int index = (Integer)sequenceOrder.get(i);
            for (Integer hit : this.primaryHits[index]) {
                wordsal.add(Arrays.copyOfRange(this.sequences[index].getDirect(), (int)hit, hit + zpm.length()));
                sequenceNumbers.put(wordsal.size() - 1, i + 1);
            }
            for (Integer hit : this.revcompHits[index]) {
                wordsal.add(Arrays.copyOfRange(this.sequences[index].getRevcomp(), (int)hit, hit + zpm.length()));
                sequenceNumbers.put(wordsal.size() - 1, i + 1);
            }
        }
        byte[][] words = (byte[][])wordsal.toArray((T[])new byte[wordsal.size()][]);
        double[] deltaSI = new double[words.length];
        for (int i = 0; i < words.length; ++i) {
            double deltasi;
            byte[][] partialWords = (byte[][])Arrays.copyOfRange(words, 0, i + 1);
            byte[] lastWord = partialWords[partialWords.length - 1];
            WPCM partialMatrix = new WPCM(partialWords).toPWM(zoopsFactor * (double)partialWords.length, this.background);
            deltaSI[i] = deltasi = partialMatrix.score(lastWord) - zpm.score(lastWord);
            if (i <= 0) continue;
            int n = i;
            deltaSI[n] = deltaSI[n] + deltaSI[i - 1];
        }
        double maxDeltaSI = deltaSI[0];
        int sequenceCount = (Integer)sequenceNumbers.get(0);
        for (int i = 1; i < deltaSI.length; ++i) {
            if (!(deltaSI[i] > maxDeltaSI)) continue;
            maxDeltaSI = deltaSI[i];
            sequenceCount = Math.max(sequenceCount, (Integer)sequenceNumbers.get(i));
        }
        conductor.message("ZOOPS detected motif in " + sequenceCount + " sequences of " + this.sequences.length);
        WPCM pm = new WPCM(zpm.length(), this.primaryHits, this.revcompHits, this.sequences, sequenceOrder, sequenceCount);
        WPCM pwm = new WPCM(pm).toPWM(this.background);
        List<WordRecord> wordList = this.extractWordList(pwm, sequenceOrder, sequenceCount);
        return new MunkResult(wordList, pm, this.background, sequenceCount, this.sequences.length, ASequence.medianLength(this.sequences));
    }

    protected WPCM zoops2(double zoopsFactor) {
        WPCM zpm = new WPCM(this.pm).toPWM(zoopsFactor * (double)this.sequences.length, this.background);
        ArrayList<Integer> sequenceOrder = new ArrayList<Integer>();
        for (int i = 0; i < this.sequences.length; ++i) {
            sequenceOrder.add(i);
        }
        final double[] bestScores = new double[this.sequences.length];
        for (int i = 0; i < this.sequences.length; ++i) {
            bestScores[i] = this.primaryHits[i].size() > 0 ? zpm.score(this.sequences[i].getDirect(), this.primaryHits[i].get(0)) : zpm.score(this.sequences[i].getRevcomp(), this.revcompHits[i].get(0));
        }
        Collections.sort(sequenceOrder, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.valueOf(bestScores[o2]).compareTo(bestScores[o1]);
            }
        });
        double[] deltaSI = new double[this.sequences.length];
        for (int i = 0; i < this.sequences.length; ++i) {
            double deltasi;
            WPCM partialMatrix = new WPCM(zpm.length(), this.primaryHits, this.revcompHits, this.sequences, sequenceOrder, i + 1).toPWM(zoopsFactor * (double)(i + 1), this.background);
            int k = (Integer)sequenceOrder.get(i);
            deltaSI[i] = deltasi = partialMatrix.bestScore(this.sequences[k], this.primaryHits[k], this.revcompHits[k]) - bestScores[k];
            if (i <= 0) continue;
            int n = i;
            deltaSI[n] = deltaSI[n] + deltaSI[i - 1];
        }
        double maxDeltaSI = deltaSI[0];
        int sequenceCount = 1;
        for (int i = 1; i < deltaSI.length; ++i) {
            if (!(deltaSI[i] >= maxDeltaSI)) continue;
            maxDeltaSI = deltaSI[i];
            sequenceCount = Math.max(sequenceCount, i + 1);
        }
        return new WPCM(zpm.length(), this.primaryHits, this.revcompHits, this.sequences, sequenceOrder, sequenceCount);
    }

    public double optimize(WPCM base) {
        this.prevKDIC.clear();
        this.pm = this.customShape == null ? new WPCM(base).toPWM(this.background) : new ShapedWPCM(base, this.customShape).toPWM(this.background);
        this.pm.setN(this.totalWeight);
        while (true) {
            for (int i = 0; i < this.sequences.length; ++i) {
                Sequence s = this.sequences[i];
                s.bestHits(this.pm, this.primaryHits[i], this.revcompHits[i]);
            }
            this.pm.rebuild(this.primaryHits, this.revcompHits, this.sequences);
            double newInfocod = this.pm.kdic(this.background);
            if (this.prevKDIC.contains(newInfocod) || this.prevKDIC.size() >= this.iterationLimit - 1) {
                this.pm = new WPCM(this.pm);
                return newInfocod;
            }
            this.prevKDIC.add(newInfocod);
            this.pm.toPWM(this.background);
        }
    }

    private List<WordRecord> extractWordList(WPCM pm, List<Integer> sequenceOrder, int sequenceCount) {
        ArrayList<WordRecord> result = new ArrayList<WordRecord>(sequenceCount);
        for (int i = 0; i < sequenceCount; ++i) {
            byte[] word;
            int k = sequenceOrder.get(i);
            int hitc = this.primaryHits[k].size() + this.revcompHits[k].size();
            for (Integer hit : this.primaryHits[k]) {
                word = Arrays.copyOfRange(this.sequences[k].getDirect(), (int)hit, hit + pm.length());
                result.add(new WordRecord(k, hit, word, "direct", pm.score(word), this.sequences[k].weight / (double)hitc));
            }
            for (Integer hit : this.revcompHits[k]) {
                word = Arrays.copyOfRange(this.sequences[k].getRevcomp(), (int)hit, hit + pm.length());
                result.add(new WordRecord(k, this.sequences[k].getRevcomp().length - pm.length() - hit, word, "revcomp", pm.score(word), this.sequences[k].weight / (double)hitc));
            }
        }
        return result;
    }

    public List<WordRecord> extractWordList(WPCM pm) {
        ArrayList<WordRecord> result = new ArrayList<WordRecord>(this.sequences.length * 2);
        for (int k = 0; k < this.sequences.length; ++k) {
            byte[] word;
            int hitc = this.primaryHits[k].size() + this.revcompHits[k].size();
            for (Integer hit : this.primaryHits[k]) {
                word = Arrays.copyOfRange(this.sequences[k].getDirect(), (int)hit, hit + pm.length());
                result.add(new WordRecord(k, hit, word, "direct", pm.score(word), this.sequences[k].weight / (double)hitc));
            }
            for (Integer hit : this.revcompHits[k]) {
                word = Arrays.copyOfRange(this.sequences[k].getRevcomp(), (int)hit, hit + pm.length());
                result.add(new WordRecord(k, this.sequences[k].getRevcomp().length - pm.length() - hit, word, "revcomp", pm.score(word), this.sequences[k].weight / (double)hitc));
            }
        }
        return result;
    }
}

