/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape;

import java.util.ArrayList;
import ru.autosome.perfectosape.Position;
import ru.autosome.perfectosape.Sequence;

public class SequenceWithSNP {
    public final String left;
    public final String right;
    public final char[] mid;

    public SequenceWithSNP(String left, char[] mid, String right) {
        this.left = left.toLowerCase();
        char[] mid_upcased = new char[mid.length];
        for (int i = 0; i < mid.length; ++i) {
            mid_upcased[i] = Character.toUpperCase(mid[i]);
        }
        this.mid = mid_upcased;
        this.right = right.toLowerCase();
    }

    public static SequenceWithSNP fromString(String seq_w_snp) {
        String[] seq_parts = seq_w_snp.split("\\[|\\]");
        if (seq_parts.length == 3) {
            String left = seq_parts[0];
            char[] mid = seq_parts[1].replaceAll("/", "").toCharArray();
            String right = seq_parts[2];
            return new SequenceWithSNP(left, mid, right);
        }
        if (seq_parts.length == 1) {
            int left_separator = seq_w_snp.indexOf("/");
            int right_separator = seq_w_snp.lastIndexOf("/");
            String left = seq_w_snp.substring(0, left_separator - 1);
            String right = seq_w_snp.substring(right_separator + 2, seq_w_snp.length());
            char[] mid = seq_w_snp.substring(left_separator - 1, right_separator + 2).replaceAll("/", "").toCharArray();
            return new SequenceWithSNP(left, mid, right);
        }
        throw new IllegalArgumentException("Can't parse sequence with SNPs: " + seq_w_snp);
    }

    int pos_of_snp() {
        return this.left.length();
    }

    public int num_cases() {
        return this.mid.length;
    }

    public Sequence[] sequence_variants() {
        Sequence[] result = new Sequence[this.num_cases()];
        for (int i = 0; i < this.num_cases(); ++i) {
            result[i] = new Sequence(this.left + this.mid[i] + this.right);
        }
        return result;
    }

    public int length() {
        return this.left.length() + 1 + this.right.length();
    }

    public int left_shift(int motif_length) {
        return Math.max(0, this.pos_of_snp() - motif_length + 1);
    }

    public ArrayList<Position> positions_subsequence_overlaps_snp(int subsequence_length) {
        int left_pos = Math.max(0, this.left.length() - subsequence_length + 1);
        int right_pos = Math.min(this.length(), this.left.length() + subsequence_length);
        return Position.positions_between(left_pos, right_pos, subsequence_length);
    }

    public String toString() {
        String mid_variants = "" + this.mid[0];
        for (int i = 1; i < this.num_cases(); ++i) {
            mid_variants = mid_variants + "/" + this.mid[i];
        }
        return this.left + "[" + mid_variants + "]" + this.right;
    }
}

