/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.autosome.perfectosape.SequenceWithSNP;
import ru.autosome.perfectosape.api.Task;
import ru.autosome.perfectosape.calculations.SNPScan;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.motifModels.PWM;

public class MultiSNPScan
extends Task<Map<PWM, Map<SequenceWithSNP, SNPScan.RegionAffinityInfos>>> {
    Parameters parameters;

    public MultiSNPScan(Parameters parameters) {
        this.parameters = parameters;
    }

    SNPScan calculator(PWM pwm, SequenceWithSNP sequenceWithSNP, CanFindPvalue pvalueCalculator) {
        return new SNPScan(pwm, sequenceWithSNP, pvalueCalculator);
    }

    public Map<PWM, Map<SequenceWithSNP, SNPScan.RegionAffinityInfos>> call() {
        HashMap<PWM, Map<SequenceWithSNP, SNPScan.RegionAffinityInfos>> result;
        this.setStatus(Task.Status.RUNNING);
        try {
            result = new HashMap<PWM, Map<SequenceWithSNP, SNPScan.RegionAffinityInfos>>();
            for (PWM pwm : this.parameters.pvalueCalculator.keySet()) {
                CanFindPvalue pvalueCalculator = this.parameters.pvalueCalculator.get(pwm);
                HashMap<SequenceWithSNP, SNPScan.RegionAffinityInfos> result_part = new HashMap<SequenceWithSNP, SNPScan.RegionAffinityInfos>();
                for (SequenceWithSNP sequenceWithSNP : this.parameters.sequencesWithSNP) {
                    if (this.interrupted()) {
                        result.put(pwm, result_part);
                        return result;
                    }
                    result_part.put(sequenceWithSNP, this.calculator(pwm, sequenceWithSNP, pvalueCalculator).affinityInfos());
                    this.tick();
                }
                result.put(pwm, result_part);
            }
        }
        catch (Exception err) {
            this.setStatus(Task.Status.FAIL);
            return null;
        }
        this.setStatus(Task.Status.SUCCESS);
        return result;
    }

    @Override
    public Integer getTotalTicks() {
        return this.parameters.sequencesWithSNP.size() * this.parameters.pvalueCalculator.size();
    }

    public static class Parameters {
        public List<SequenceWithSNP> sequencesWithSNP;
        Map<PWM, CanFindPvalue> pvalueCalculator;

        public Parameters() {
        }

        public Parameters(List<SequenceWithSNP> sequencesWithSNP, Map<PWM, CanFindPvalue> pvalueCalculator) {
            this.sequencesWithSNP = sequencesWithSNP;
            this.pvalueCalculator = pvalueCalculator;
        }
    }
}

