/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.api;

import java.io.PrintStream;
import java.util.EventListener;
import java.util.concurrent.Callable;

public abstract class Task<ResultType>
implements Callable {
    private Status status;
    private Integer currentTicks = 0;
    public PrintStream outputStream;
    public boolean silent = false;
    Listener listener;
    private final Object lock = new Object();

    public void setEventLister(Listener listener) {
        this.listener = listener;
    }

    protected Task() {
        this.status = Status.INITIALIZED;
        this.outputStream = System.err;
    }

    public abstract Integer getTotalTicks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick() {
        Object object = this.lock;
        synchronized (object) {
            this.currentTicks = this.currentTicks + 1;
            if (this.listener != null) {
                this.listener.eventOccured(this, Event.TICK);
            }
        }
    }

    public double completionPercent() {
        return Math.floor(100 * this.currentTicks / this.getTotalTicks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentTicks() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentTicks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean interrupted() {
        Object object = this.lock;
        synchronized (object) {
            return this.status == Status.INTERRUPTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatus(Status newStatus) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status != Status.INTERRUPTED) {
                this.status = newStatus;
                if (this.listener != null) {
                    this.listener.eventOccured(this, Event.STATUS_CHANGED);
                }
                return true;
            }
            return false;
        }
    }

    void message(String msg) {
        if (!this.silent) {
            this.outputStream.println(msg);
        }
    }

    static interface Listener
    extends EventListener {
        public void eventOccured(Task var1, Event var2);
    }

    public static enum Event {
        TICK,
        STATUS_CHANGED;

    }

    public static enum Status {
        INITIALIZED,
        RUNNING,
        SUCCESS,
        FAIL,
        INTERRUPTED;

    }
}

