/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations;

import gnu.trove.iterator.TDoubleDoubleIterator;
import gnu.trove.iterator.TDoubleObjectIterator;
import gnu.trove.map.hash.TDoubleDoubleHashMap;
import gnu.trove.map.hash.TDoubleObjectHashMap;
import ru.autosome.perfectosape.PWMAligned;
import ru.autosome.perfectosape.Position;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.formatters.ResultInfo;
import ru.autosome.perfectosape.motifModels.PWM;

public class AlignedPWMIntersection {
    public final BackgroundModel firstBackground;
    public final BackgroundModel secondBackground;
    public final PWMAligned alignment;
    public Double maxPairHashSize;

    public AlignedPWMIntersection(PWMAligned alignment, BackgroundModel firstBackground, BackgroundModel secondBackground) {
        this.firstBackground = firstBackground;
        this.secondBackground = secondBackground;
        this.alignment = alignment;
    }

    public AlignedPWMIntersection(PWM firstPWM, PWM secondPWM, BackgroundModel firstBackground, BackgroundModel secondBackground, Position relativePosition) {
        this.firstBackground = firstBackground;
        this.secondBackground = secondBackground;
        this.alignment = new PWMAligned(firstPWM, secondPWM, relativePosition);
    }

    public double count_in_intersection(double first_threshold, double second_threshold) throws HashOverflowException {
        double[] intersections = this.counts_for_two_matrices(first_threshold, second_threshold);
        return this.combine_intersection_values(intersections[0], intersections[1]);
    }

    public double combine_intersection_values(double intersection_count_1, double intersection_count_2) {
        return Math.sqrt(intersection_count_1 * intersection_count_2);
    }

    private double[] counts_for_two_matrices(double threshold_first, double threshold_second) throws HashOverflowException {
        if (this.firstBackground.equals(this.secondBackground)) {
            BackgroundModel background = this.firstBackground;
            double result = this.get_counts(threshold_first, threshold_second, background);
            return new double[]{result, result};
        }
        double first_result = this.get_counts(threshold_first, threshold_second, this.firstBackground);
        double second_result = this.get_counts(threshold_first, threshold_second, this.secondBackground);
        return new double[]{first_result, second_result};
    }

    private int summarySize(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores) {
        int sum = 0;
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            sum += iterator.value().size();
        }
        return sum;
    }

    private TDoubleObjectHashMap<TDoubleDoubleHashMap> initialScoreHash() {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> scores = new TDoubleObjectHashMap<TDoubleDoubleHashMap>();
        scores.put(0.0, new TDoubleDoubleHashMap(new double[]{0.0}, new double[]{1.0}));
        return scores;
    }

    private double get_counts(double threshold_first, double threshold_second, BackgroundModel background) throws HashOverflowException {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> scores = this.initialScoreHash();
        for (int pos = 0; pos < this.alignment.length(); ++pos) {
            double[] firstColumn = this.alignment.first_pwm.matrix[pos];
            double[] secondColumn = this.alignment.second_pwm.matrix[pos];
            double leastSufficientScoreFirst = threshold_first - this.alignment.first_pwm.best_suffix(pos + 1);
            double leastSufficientScoreSecond = threshold_second - this.alignment.second_pwm.best_suffix(pos + 1);
            scores = background.is_wordwise() ? this.recalc_score_hash_wordwise(scores, firstColumn, secondColumn, leastSufficientScoreFirst, leastSufficientScoreSecond) : this.recalc_score_hash(scores, firstColumn, secondColumn, leastSufficientScoreFirst, leastSufficientScoreSecond, background);
            if (this.maxPairHashSize == null || !((double)this.summarySize(scores) > this.maxPairHashSize)) continue;
            throw new HashOverflowException("Hash overflow in AlignedPWMIntersection#get_counts");
        }
        return this.combine_scores(scores);
    }

    double combine_scores(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores) {
        double sum = 0.0;
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            TDoubleDoubleIterator second_iterator = iterator.value().iterator();
            while (second_iterator.hasNext()) {
                second_iterator.advance();
                sum += second_iterator.value();
            }
        }
        return sum;
    }

    TDoubleObjectHashMap<TDoubleDoubleHashMap> feedHashToRecalc(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores, double[] firstColumn, double leastSufficientScoreFirst) {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> result = new TDoubleObjectHashMap<TDoubleDoubleHashMap>();
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score_first = iterator.key();
            for (int letter = 0; letter < 4; ++letter) {
                double new_score_first = score_first + firstColumn[letter];
                if (!(new_score_first >= leastSufficientScoreFirst)) continue;
                result.put(new_score_first, new TDoubleDoubleHashMap());
            }
        }
        return result;
    }

    TDoubleObjectHashMap<TDoubleDoubleHashMap> recalc_score_hash(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores, double[] firstColumn, double[] secondColumn, double leastSufficientScoreFirst, double leastSufficientScoreSecond, BackgroundModel background) {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> new_scores = this.feedHashToRecalc(scores, firstColumn, leastSufficientScoreFirst);
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score_first = iterator.key();
            TDoubleDoubleHashMap second_scores = iterator.value();
            TDoubleDoubleIterator second_iterator = second_scores.iterator();
            while (second_iterator.hasNext()) {
                second_iterator.advance();
                double score_second = second_iterator.key();
                double count = second_iterator.value();
                for (int letter = 0; letter < 4; ++letter) {
                    double new_score_second;
                    double new_score_first = score_first + firstColumn[letter];
                    if (!(new_score_first >= leastSufficientScoreFirst) || !((new_score_second = score_second + secondColumn[letter]) >= leastSufficientScoreSecond)) continue;
                    double add = background.count(letter) * count;
                    new_scores.get(new_score_first).adjustOrPutValue(new_score_second, add, add);
                }
            }
        }
        return new_scores;
    }

    TDoubleObjectHashMap<TDoubleDoubleHashMap> recalc_score_hash_wordwise(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores, double[] firstColumn, double[] secondColumn, double leastSufficientScoreFirst, double leastSufficientScoreSecond) {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> new_scores = this.feedHashToRecalc(scores, firstColumn, leastSufficientScoreFirst);
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score_first = iterator.key();
            TDoubleDoubleHashMap second_scores = iterator.value();
            TDoubleDoubleIterator second_iterator = second_scores.iterator();
            while (second_iterator.hasNext()) {
                second_iterator.advance();
                double score_second = second_iterator.key();
                double count = second_iterator.value();
                for (int letter = 0; letter < 4; ++letter) {
                    double new_score_second;
                    double new_score_first = score_first + firstColumn[letter];
                    if (!(new_score_first >= leastSufficientScoreFirst) || !((new_score_second = score_second + secondColumn[letter]) >= leastSufficientScoreSecond)) continue;
                    new_scores.get(new_score_first).adjustOrPutValue(new_score_second, count, count);
                }
            }
        }
        return new_scores;
    }

    public static class SimilarityInfo
    extends ResultInfo {
        public final double recognizedByBoth;
        public final double recognizedByFirst;
        public final double recognizedBySecond;

        public SimilarityInfo(double recognizedByBoth, double recognizedByFirst, double recognizedBySecond) {
            this.recognizedByFirst = recognizedByFirst;
            this.recognizedBySecond = recognizedBySecond;
            this.recognizedByBoth = recognizedByBoth;
        }

        public static Double jaccardByCounts(double recognizedByFirst, double recognizedBySecond, double recognizedByBoth) {
            if (recognizedByFirst == 0.0 || recognizedBySecond == 0.0) {
                return null;
            }
            double union = recognizedByFirst + recognizedBySecond - recognizedByBoth;
            return recognizedByBoth / union;
        }

        public Double similarity() {
            return SimilarityInfo.jaccardByCounts(this.recognizedByFirst, this.recognizedBySecond, this.recognizedByBoth);
        }

        public Double distance() {
            Double similarity = this.similarity();
            if (similarity == null) {
                return null;
            }
            return 1.0 - similarity;
        }

        public Double realPvalueFirst(BackgroundModel background, int alignmentLength) {
            double vocabularyVolume = Math.pow(background.volume(), alignmentLength);
            return this.recognizedByFirst / vocabularyVolume;
        }

        public Double realPvalueSecond(BackgroundModel background, int alignmentLength) {
            double vocabularyVolume = Math.pow(background.volume(), alignmentLength);
            return this.recognizedBySecond / vocabularyVolume;
        }
    }
}

