/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations.findThreshold;

import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.ScoringModelDistributions.ScoringModelDistibutions;
import ru.autosome.perfectosape.calculations.findThreshold.CanFindThreshold;

public abstract class FindThresholdByDiscretization
implements CanFindThreshold {
    Double discretization;

    public FindThresholdByDiscretization(Double discretization) {
        this.discretization = discretization;
    }

    abstract ScoringModelDistibutions discretedScoringModel();

    @Override
    public CanFindThreshold.ThresholdInfo weakThresholdByPvalue(double pvalue) throws HashOverflowException {
        return this.discretedScoringModel().weak_threshold(pvalue).downscale(this.discretization);
    }

    @Override
    public CanFindThreshold.ThresholdInfo strongThresholdByPvalue(double pvalue) throws HashOverflowException {
        return this.discretedScoringModel().strong_threshold(pvalue).downscale(this.discretization);
    }

    @Override
    public CanFindThreshold.ThresholdInfo thresholdByPvalue(double pvalue, BoundaryType boundaryType) throws HashOverflowException {
        return this.discretedScoringModel().threshold(pvalue, boundaryType).downscale(this.discretization);
    }

    @Override
    public CanFindThreshold.ThresholdInfo[] weakThresholdsByPvalues(double[] pvalues) throws HashOverflowException {
        return this.downscale_all(this.discretedScoringModel().weak_thresholds(pvalues), this.discretization);
    }

    @Override
    public CanFindThreshold.ThresholdInfo[] strongThresholsdByPvalues(double[] pvalues) throws HashOverflowException {
        return this.downscale_all(this.discretedScoringModel().strong_thresholds(pvalues), this.discretization);
    }

    @Override
    public CanFindThreshold.ThresholdInfo[] thresholdsByPvalues(double[] pvalues, BoundaryType boundaryType) throws HashOverflowException {
        return this.downscale_all(this.discretedScoringModel().thresholds(pvalues, boundaryType), this.discretization);
    }

    private CanFindThreshold.ThresholdInfo[] downscale_all(CanFindThreshold.ThresholdInfo[] thresholdInfos, double discretization) {
        CanFindThreshold.ThresholdInfo[] result = new CanFindThreshold.ThresholdInfo[thresholdInfos.length];
        for (int i = 0; i < thresholdInfos.length; ++i) {
            result[i] = thresholdInfos[i].downscale(discretization);
        }
        return result;
    }
}

