/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import ru.autosome.perfectosape.ArrayExtensions;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.formatters.OutputInformation;
import ru.autosome.perfectosape.formatters.ResultInfo;
import ru.autosome.perfectosape.importers.MotifImporter;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.DataModel;
import ru.autosome.perfectosape.motifModels.Named;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public abstract class FindPvalueGeneralized<ModelType extends ScoringModel & Named, BackgroundType extends GeneralizedBackgroundModel> {
    protected String pm_filename;
    protected Double discretization;
    protected double[] thresholds;
    protected Integer max_hash_size;
    protected DataModel data_model;
    protected double effective_count;
    protected ModelType motif;
    protected BackgroundType background;
    protected File thresholds_folder;
    CanFindPvalue cache_calculator;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <pat-file> <threshold list>... [options]\n" + "\n" + "Options:\n" + "  [-d <discretization level>]\n" + "  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n" + "  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n" + "  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n" + "  [-b <background probabilities] " + this.DOC_background_option() + "\n" + "  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n" + "\n" + "Examples:\n" + "  " + this.DOC_run_string() + " motifs/KLF4_f2.pat 7.32\n" + "  " + this.DOC_run_string() + " motifs/KLF4_f2.pat 7.32 4.31 5.42 -d 1000 -b 0.2,0.3,0.3,0.2\n";
    }

    protected abstract CanFindPvalue calculator() throws FileNotFoundException;

    protected abstract void initialize_default_background();

    protected abstract void extract_background(String var1);

    protected abstract MotifImporter<ModelType> motifImporter();

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.discretization = 10000.0;
        this.thresholds = new double[0];
        this.max_hash_size = 10000000;
        this.data_model = DataModel.PWM;
        this.thresholds_folder = null;
        this.effective_count = 100.0;
    }

    protected void extract_pm_filename(ArrayList<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.pm_filename = argv.remove(0);
    }

    protected void extract_threshold_lists(ArrayList<String> argv) {
        ArrayList<Double> thresholds_list = new ArrayList<Double>();
        try {
            while (!argv.isEmpty()) {
                thresholds_list.add(Double.valueOf(argv.get(0)));
                argv.remove(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (thresholds_list.isEmpty()) {
            throw new IllegalArgumentException("You should specify at least one threshold");
        }
        this.thresholds = ArrayExtensions.toPrimitiveArray(thresholds_list);
    }

    protected void extract_option(ArrayList<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b")) {
            this.extract_background(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.max_hash_size = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("-d")) {
            this.discretization = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.data_model = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.data_model = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effective_count = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--precalc")) {
            this.thresholds_folder = new File(argv.remove(0));
        } else {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    void setup_from_arglist(ArrayList<String> argv) {
        this.extract_pm_filename(argv);
        this.extract_threshold_lists(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.motif = (ScoringModel)this.motifImporter().loadPWMFromParser(PMParser.from_file_or_stdin(this.pm_filename));
    }

    OutputInformation report_table_layout() throws FileNotFoundException {
        return this.calculator().report_table_layout();
    }

    OutputInformation report_table(ArrayList<? extends ResultInfo> data) throws FileNotFoundException {
        OutputInformation result = this.report_table_layout();
        result.data = data;
        return result;
    }

    <R extends ResultInfo> OutputInformation report_table(R[] data) throws FileNotFoundException {
        ArrayList data_list = new ArrayList(data.length);
        Collections.addAll(data_list, data);
        return this.report_table(data_list);
    }

    OutputInformation report_table() throws HashOverflowException, FileNotFoundException {
        ResultInfo[] results = this.calculator().pvaluesByThresholds(this.thresholds);
        return this.report_table(results);
    }
}

