/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.perfectosape.backgroundModels.Background;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueBsearchBuilder;
import ru.autosome.perfectosape.cli.Helper;
import ru.autosome.perfectosape.cli.MultiSNPScanGeneralized;
import ru.autosome.perfectosape.importers.MotifCollectionImporter;
import ru.autosome.perfectosape.importers.PWMImporter;
import ru.autosome.perfectosape.motifModels.PWM;

public class MultiSNPScan
extends MultiSNPScanGeneralized<BackgroundModel> {
    @Override
    protected String DOC_run_string() {
        return "java ru.autosome.perfectosape.cli.MultiSNPScan";
    }

    @Override
    protected String DOC_background_option() {
        return "ACGT - 4 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.25,0.24,0.26,0.25";
    }

    private MultiSNPScan() {
    }

    @Override
    protected void extract_background(String str) {
        this.background = Background.fromString(str);
    }

    @Override
    protected void initialize_default_background() {
        this.background = new WordwiseBackground();
    }

    @Override
    protected void load_collection_of_pwms() throws FileNotFoundException {
        PWMImporter pwmImporter = new PWMImporter((BackgroundModel)this.background, this.dataModel, this.effectiveCount);
        MotifCollectionImporter<PWM> importer = new MotifCollectionImporter<PWM>(pwmImporter);
        List<PWM> pwmList = importer.loadPWMCollection(this.path_to_collection_of_pwms);
        this.pwmCollection = new ArrayList();
        for (PWM pwm : pwmList) {
            FindPvalueAPE<PWM, GeneralizedBackgroundModel> pvalueCalculator = this.thresholds_folder == null ? new FindPvalueAPE<PWM, GeneralizedBackgroundModel>(pwm, this.background, this.discretization, this.max_hash_size) : new FindPvalueBsearchBuilder(this.thresholds_folder).pvalueCalculator(pwm);
            this.pwmCollection.add(new MultiSNPScanGeneralized.ThresholdEvaluator(pwm, pvalueCalculator, pwm.getName()));
        }
    }

    protected static MultiSNPScanGeneralized from_arglist(ArrayList<String> argv) throws FileNotFoundException {
        MultiSNPScan result = new MultiSNPScan();
        Helper.print_help_if_requested(argv, result.documentString());
        result.setup_from_arglist(argv);
        return result;
    }

    protected static MultiSNPScanGeneralized from_arglist(String[] args) throws FileNotFoundException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return MultiSNPScan.from_arglist(argv);
    }

    public static void main(String[] args) {
        try {
            MultiSNPScanGeneralized calculation = MultiSNPScan.from_arglist(args);
            calculation.process();
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\n" + new MultiSNPScan().documentString());
            System.exit(1);
        }
    }
}

