/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.examples;

import ru.autosome.perfectosape.api.FindPvalueAPE;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.PWM;

public class FindPvalue {
    static void print_result(CanFindPvalue.PvalueInfo info, BackgroundModel background, int pwmLength) {
        System.out.println("threshold: " + info.threshold + "\n" + "pvalue: " + info.pvalue + "\n" + "number of recognized words: " + info.numberOfRecognizedWords(background, pwmLength) + "\n------------\n");
    }

    public static void main(String[] args) {
        PWM pwm = PWM.fromParser(PMParser.from_file_or_stdin("test_data/pwm/KLF4_f2.pwm"));
        WordwiseBackground background = new WordwiseBackground();
        double discretization = 10000.0;
        Integer max_hash_size = null;
        double threshold = 3.0;
        double[] thresholds = new double[]{3.0, 5.0, 7.0};
        FindPvalueAPE<PWM, WordwiseBackground> calculator = new FindPvalueAPE<PWM, WordwiseBackground>(pwm, background, discretization, max_hash_size);
        CanFindPvalue.PvalueInfo info = null;
        try {
            info = calculator.pvalueByThreshold(threshold);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        FindPvalue.print_result(info, background, pwm.length());
        CanFindPvalue.PvalueInfo[] infos = new CanFindPvalue.PvalueInfo[]{};
        try {
            infos = calculator.pvaluesByThresholds(thresholds);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < infos.length; ++i) {
            FindPvalue.print_result(infos[i], background, pwm.length());
        }
        double[][] matrix_cAVNCT = new double[][]{{1.0, 2.0, 1.0, 1.0}, {10.5, -3.0, 0.0, 0.0}, {5.0, 5.0, 5.0, -10.0}, {0.0, 0.0, 0.0, 0.0}, {-1.0, 10.5, -1.0, 0.0}, {0.0, 0.0, 0.0, 2.0}};
        PWM pwm_manual_constructed = new PWM(matrix_cAVNCT, "PWM for cAVNCt consensus sequence");
        double[] thresholds_2 = new double[]{15.0, 16.0, 17.0};
        FindPvalueAPE.Parameters parameters = new FindPvalueAPE.Parameters(pwm_manual_constructed, thresholds_2, discretization, background, max_hash_size);
        ru.autosome.perfectosape.api.FindPvalueAPE bioumlCalculator = new ru.autosome.perfectosape.api.FindPvalueAPE(parameters);
        CanFindPvalue.PvalueInfo[] infosBiouml = (CanFindPvalue.PvalueInfo[])bioumlCalculator.call();
        for (int i = 0; i < infosBiouml.length; ++i) {
            FindPvalue.print_result(infosBiouml[i], background, pwm_manual_constructed.length());
        }
    }
}

