/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.importers;

import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.importers.MotifImporter;
import ru.autosome.perfectosape.motifModels.DataModel;
import ru.autosome.perfectosape.motifModels.DiPCM;
import ru.autosome.perfectosape.motifModels.DiPPM;
import ru.autosome.perfectosape.motifModels.DiPWM;

public class DiPWMImporter
extends MotifImporter<DiPWM> {
    DiBackgroundModel dibackground;
    DataModel dataModel;
    Double effectiveCount;

    public DiPWMImporter(DiBackgroundModel dibackground, DataModel dataModel, Double effectiveCount) {
        this.dibackground = dibackground;
        this.dataModel = dataModel;
        this.effectiveCount = effectiveCount;
    }

    @Override
    public DiPWM transformToPWM(double[][] matrix, String name) {
        DiPWM dipwm;
        switch (this.dataModel) {
            case PCM: {
                dipwm = new DiPCM(matrix, name).to_pwm(this.dibackground);
                break;
            }
            case PPM: {
                dipwm = new DiPPM(matrix, name).to_pwm(this.dibackground, this.effectiveCount);
                break;
            }
            case PWM: {
                dipwm = new DiPWM(matrix, name);
                break;
            }
            default: {
                throw new Error("This code never reached");
            }
        }
        return dipwm;
    }
}

